/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.kitchen.dao.impl;

import com.openbravo.pos.ticket.PaymentLine;
import fr.protactile.kitchen.dao.config.DaoConfig;
import fr.protactile.kitchen.dao.entities.Payments;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class PaymentsDao
extends DaoConfig<Payments> {
    @Override
    protected Class<Payments> classType() {
        return Payments.class;
    }

    public void deletePayments(int idTicket) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            String hqlUpdate = "delete from Payments P where P.idTicket.id = :id ";
            Transaction tx = session.beginTransaction();
            int updatedEntities = session.createQuery(hqlUpdate).setParameter("id", (Object)idTicket).executeUpdate();
            tx.commit();
            session.close();
        }
    }

    public List<PaymentLine> loadPayment(Date date_open, Date date_close) {
        ArrayList<PaymentLine> payments = new ArrayList<PaymentLine>();
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("select payment, SUM(P.total), count(P.id)  from Payments P where P.idTicket.paid = 1  and P.idTicket.canceled  = 0  and P.idTicket.created >= :date_open and P.idTicket.created <= : date_close GROUP BY P.payment");
            query.setParameter("date_open", (Object)date_open);
            query.setParameter("date_close", (Object)date_close);
            List payments_result = query.getResultList();
            for (Object[] payment : payments_result) {
                payments.add(new PaymentLine((String)payment[0], (double)((Double)payment[1]), ((Long)payment[2]).intValue()));
            }
            tx.commit();
            session.close();
        }
        return payments;
    }

    public List<Payments> getTicketPaymentS(int idTicket) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("select P from Payments P where P.idTicket.id = :idTicket");
            query.setParameter("idTicket", (Object)idTicket);
            List payments = query.list();
            tx.commit();
            session.close();
            return payments;
        }
        return null;
    }
}

