/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.kitchen.dao.impl;

import fr.protactile.kitchen.dao.config.DaoConfig;
import fr.protactile.kitchen.dao.entities.Orders;
import java.util.Date;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class OrderDao
extends DaoConfig<Orders> {
    @Override
    protected Class<Orders> classType() {
        return Orders.class;
    }

    public void cancelOrder(String idTicket) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            String hqlUpdate = "update Orders O set O.canceled = 1, O.sourceCancel = 'caisse', O.updatedAt = :updatedAt where O.idTicket = :idTicket ";
            Transaction tx = session.beginTransaction();
            int updatedEntities = session.createQuery(hqlUpdate).setParameter("idTicket", (Object)idTicket).setParameter("updatedAt", (Object)new Date()).executeUpdate();
            tx.commit();
            session.close();
        }
    }

    public void paidOrder(int id) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            String hqlUpdate = "update Orders O set O.paid = 1,  O.updatedAt = :updatedAt where O.id = :id ";
            Transaction tx = session.beginTransaction();
            int updatedEntities = session.createQuery(hqlUpdate).setParameter("id", (Object)id).setParameter("updatedAt", (Object)new Date()).executeUpdate();
            tx.commit();
            session.close();
        }
    }

    public void setIdTicketCaisse(int id, String id_ticket) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            String hqlUpdate = "update Orders O set O.idTicket = :idTicket,  O.updatedAt = :updatedAt where O.id = :id ";
            Transaction tx = session.beginTransaction();
            int updatedEntities = session.createQuery(hqlUpdate).setParameter("idTicket", (Object)id_ticket).setParameter("updatedAt", (Object)new Date()).setParameter("id", (Object)id).executeUpdate();
            tx.commit();
            session.close();
        }
    }

    public void cancelOrderById(int id_order) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            String hqlUpdate = "update Orders O set O.canceled = 1, O.sourceCancel = 'caisse', O.updatedAt = :updatedAt where O.id = :id";
            Transaction tx = session.beginTransaction();
            int updatedEntities = session.createQuery(hqlUpdate).setParameter("id", (Object)id_order).setParameter("updatedAt", (Object)new Date()).executeUpdate();
            tx.commit();
            session.close();
        }
    }

    public void paidOrderByTicket(String idTicket) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            String hqlUpdate = "update Orders O set O.paid = 1,  O.updatedAt = :updatedAt where O.idTicket = :idTicket ";
            Transaction tx = session.beginTransaction();
            int updatedEntities = session.createQuery(hqlUpdate).setParameter("idTicket", (Object)idTicket).setParameter("updatedAt", (Object)new Date()).executeUpdate();
            tx.commit();
            session.close();
        }
    }

    public void setOrderUpdateDate(Integer idOrder) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Date now = new Date();
            Query q = session.createQuery("UPDATE Orders o SET o.updatedAt = :updatedAt WHERE o.id = :id");
            q.setParameter("id", (Object)idOrder);
            Date date_update = new Date();
            System.out.println("++++++++ date update : " + date_update);
            q.setParameter("updatedAt", (Object)new Date());
            int a = q.executeUpdate();
            tx.commit();
            session.close();
        }
    }

    public void disableUpdate(Integer idOrder) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Date now = new Date();
            Query q = session.createQuery("UPDATE Orders o SET o.updatable = 0 WHERE o.id = :id");
            q.setParameter("id", (Object)idOrder);
            int a = q.executeUpdate();
            tx.commit();
            session.close();
        }
    }

    public void setOrderUpdateDate(Integer idOrder, String update_reason) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Date now = new Date();
            Query q = session.createQuery("UPDATE Orders o SET o.updatedAt = :updatedAt, o.update_reason = :update_reason WHERE o.id = :id");
            q.setParameter("id", (Object)idOrder);
            q.setParameter("update_reason", (Object)update_reason);
            Date date_update = new Date();
            System.out.println("++++++++ date update : " + date_update);
            q.setParameter("updatedAt", (Object)new Date());
            int a = q.executeUpdate();
            tx.commit();
            session.close();
        }
    }

    public void updateOrder(Orders order, Session session) {
        String hqlUpdate = "update Orders O set O.bipper = :bipper, O.comment = :comment, O.type = :type, O.update_reason = :update_reason, O.updated = :updated, O.totalTTC =:totalTTC,  O.updatedAt = :updatedAt where O.id = :id ";
        int updatedEntities = session.createQuery(hqlUpdate).setParameter("bipper", (Object)order.getBipper()).setParameter("comment", (Object)order.getComment()).setParameter("type", (Object)order.getType()).setParameter("update_reason", (Object)order.getUpdate_reason()).setParameter("updated", (Object)order.isUpdated()).setParameter("totalTTC", (Object)order.getTotalTTC()).setParameter("updatedAt", (Object)new Date()).setParameter("id", (Object)order.getId()).executeUpdate();
    }

    public Orders getOrderById(int id, Session session) {
        Orders order = null;
        Query query = session.createQuery("from Orders O where  O.id = :id ");
        query.setParameter("id", (Object)id);
        List result = query.list();
        order = result.isEmpty() ? null : (Orders)result.get(0);
        return order;
    }

    public void updateOrder(Session session, Orders order) {
        String hqlUpdate = "update Orders O set O.bipper = :bipper, O.comment = :comment, O.type = :type  where O.id = :id ";
        int updatedEntities = session.createQuery(hqlUpdate).setParameter("bipper", (Object)order.getBipper()).setParameter("comment", (Object)order.getComment()).setParameter("type", (Object)order.getType()).setParameter("id", (Object)order.getId()).executeUpdate();
    }

    public List<Orders> getOrders(String idTicket, Session session) {
        Query query = session.createQuery("from Orders O where  O.idTicket = :idTicket ");
        query.setParameter("idTicket", (Object)idTicket);
        List result = query.list();
        return result;
    }
}

