/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.kitchen.dao.entities;

import com.openbravo.pos.util.LogToFile;
import fr.protactile.kitchen.dao.entities.Itemsticket;
import fr.protactile.kitchen.dao.entities.Optionsticket;
import fr.protactile.kitchen.dao.entities.Tickets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.hibernate.annotations.ColumnDefault;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;

@Entity
@Table(name="ticketlines")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="Ticketlines.findAll", query="SELECT t FROM Ticketlines t"), @NamedQuery(name="Ticketlines.findById", query="SELECT t FROM Ticketlines t WHERE t.id = :id"), @NamedQuery(name="Ticketlines.findByRefProduct", query="SELECT t FROM Ticketlines t WHERE t.refProduct = :refProduct"), @NamedQuery(name="Ticketlines.findByQuantity", query="SELECT t FROM Ticketlines t WHERE t.quantity = :quantity")})
public class Ticketlines
implements Serializable,
Cloneable {
    @Basic(optional=false)
    @NotNull
    @Column(name="QUANTITY")
    private double quantity;
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="ID")
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=255)
    @Column(name="REF_PRODUCT")
    private @NotNull @Size(min=1, max=255) String refProduct;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="idLine", fetch=FetchType.EAGER)
    private Collection<Optionsticket> optionsticketCollection;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="idLine", fetch=FetchType.LAZY)
    private Collection<Itemsticket> itemsticketCollection;
    @JoinColumn(name="ID_TICKET", referencedColumnName="ID", foreignKey=@ForeignKey(name="ticketlines_ibfk_1"))
    @ManyToOne(optional=false)
    @OnDelete(action=OnDeleteAction.CASCADE)
    private Tickets idTicket;
    @Basic(optional=false)
    @NotNull
    @Column(name="UNIT_PAID", columnDefinition="DOUBLE default '0'")
    private double unit_paid;
    @Basic(optional=false)
    @NotNull
    @Column(name="PRICE", columnDefinition="DOUBLE default '0'")
    private double price;
    @Basic(optional=false)
    @NotNull
    @Column(name="DISCOUNT", columnDefinition="DOUBLE default '0'")
    private double discount;
    @Size(max=255)
    @Column(name="SIZE_PRODUCT")
    private @Size(max=255) String size_product;
    @Size(max=255)
    @Column(name="NAME_SIZE_PRODUCT")
    private @Size(max=255) String name_size_product;
    @Size(max=1024)
    @Column(name="NOTE")
    private @Size(max=1024) String note;
    @Size(max=255)
    @Column(name="LABEL_DISCOUNT")
    private @Size(max=255) String label_discount;
    @Size(max=255)
    @Column(name="PLACE_SERVED")
    private @Size(max=255) String place_served;
    @Size(max=255)
    @Column(name="TIME_SERVED")
    private @Size(max=255) String time_served;
    @ColumnDefault(value="false")
    @Column(name="PROMO_BASKET")
    private boolean promo_basket;
    @ColumnDefault(value="false")
    @Column(name="NEXT_LINE")
    private boolean next_line;
    @NotNull
    @Column(name="POINTS_LOYALTY", columnDefinition="DOUBLE default '0'")
    private double points_loyalty;
    @Column(name="ID_LINE_KITCHEN", columnDefinition="int default 0", nullable=false)
    private int id_line_kitchen;
    @Column(name="ID_LINE_SOURCE", columnDefinition="int default 0", nullable=false)
    private int id_line_source;
    @Size(max=255)
    @Column(name="TYPE_DISCOUNT")
    private @Size(max=255) String type_discount;
    @Column(name="ALIAS_SIZE")
    private String alias_size;
    @ColumnDefault(value="false")
    @Column(name="PROMO_PRODUCT")
    private boolean promo_product;
    @Size(max=255)
    @Column(name="ID_GLOBAL_PRODUCT")
    private @Size(max=255) String id_global_product;

    public Ticketlines() {
    }

    public Ticketlines(Integer id) {
        this.id = id;
    }

    public Ticketlines(int id, String refProduct, double quantity, double price, double discount, String size_product, String name_size_product, String note, String label_discount, String place_served, String time_served, boolean promo_basket, int id_line_kitchen) {
        this.id = id;
        this.refProduct = refProduct;
        this.quantity = quantity;
        this.price = price;
        this.discount = discount;
        this.size_product = size_product;
        this.name_size_product = name_size_product;
        this.note = note;
        this.label_discount = label_discount;
        this.place_served = place_served;
        this.time_served = time_served;
        this.promo_basket = promo_basket;
        this.id_line_kitchen = id_line_kitchen;
    }

    public Ticketlines(Integer id, String refProduct, double quantity) {
        this.id = id;
        this.refProduct = refProduct;
        this.quantity = quantity;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getRefProduct() {
        return this.refProduct;
    }

    public void setRefProduct(String refProduct) {
        this.refProduct = refProduct;
    }

    @XmlTransient
    public Collection<Optionsticket> getOptionsticketCollection() {
        return this.optionsticketCollection;
    }

    public void setOptionsticketCollection(Collection<Optionsticket> optionsticketCollection) {
        this.optionsticketCollection = optionsticketCollection;
    }

    @XmlTransient
    public Collection<Itemsticket> getItemsticketCollection() {
        return this.itemsticketCollection;
    }

    public void setItemsticketCollection(Collection<Itemsticket> itemsticketCollection) {
        this.itemsticketCollection = itemsticketCollection;
    }

    public Tickets getIdTicket() {
        return this.idTicket;
    }

    public void setIdTicket(Tickets idTicket) {
        this.idTicket = idTicket;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Ticketlines)) {
            return false;
        }
        Ticketlines other = (Ticketlines)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "fr.protactile.kitchen.dao.entities.Ticketlines[ id=" + this.id + " ]";
    }

    public Object clone() {
        try {
            Ticketlines o = null;
            o = (Ticketlines)super.clone();
            ArrayList<Optionsticket> options = new ArrayList<Optionsticket>();
            for (Optionsticket option : this.optionsticketCollection) {
                options.add((Optionsticket)option.clone());
            }
            o.setOptionsticketCollection(options);
            ArrayList<Itemsticket> items = new ArrayList<Itemsticket>();
            for (Itemsticket item : this.itemsticketCollection) {
                items.add((Itemsticket)item.clone());
            }
            o.setItemsticketCollection(items);
            return o;
        }
        catch (CloneNotSupportedException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return null;
        }
    }

    public double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public double getUnit_paid() {
        return this.unit_paid;
    }

    public void setUnit_paid(double unit_paid) {
        this.unit_paid = unit_paid;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public double getDiscount() {
        return this.discount;
    }

    public void setDiscount(double discount) {
        this.discount = discount;
    }

    public String getSize_product() {
        return this.size_product;
    }

    public void setSize_product(String size_product) {
        this.size_product = size_product;
    }

    public String getName_size_product() {
        return this.name_size_product;
    }

    public void setName_size_product(String name_size_product) {
        this.name_size_product = name_size_product;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getLabel_discount() {
        return this.label_discount;
    }

    public void setLabel_discount(String label_discount) {
        this.label_discount = label_discount;
    }

    public String getPlace_served() {
        return this.place_served;
    }

    public void setPlace_served(String place_served) {
        this.place_served = place_served;
    }

    public String getTime_served() {
        return this.time_served;
    }

    public void setTime_served(String time_served) {
        this.time_served = time_served;
    }

    public boolean isPromo_basket() {
        return this.promo_basket;
    }

    public void setPromo_basket(boolean promo_basket) {
        this.promo_basket = promo_basket;
    }

    public boolean isNext_line() {
        return this.next_line;
    }

    public void setNext_line(boolean next_line) {
        this.next_line = next_line;
    }

    public void setDefaultInfo() {
        if (this.refProduct == null) {
            this.refProduct = "";
        }
    }

    public double getPoints_loyalty() {
        return this.points_loyalty;
    }

    public void setPoints_loyalty(double points_loyalty) {
        this.points_loyalty = points_loyalty;
    }

    public int getId_line_kitchen() {
        return this.id_line_kitchen;
    }

    public void setId_line_kitchen(int id_line_kitchen) {
        this.id_line_kitchen = id_line_kitchen;
    }

    public int getId_line_source() {
        return this.id_line_source;
    }

    public void setId_line_source(int id_line_source) {
        this.id_line_source = id_line_source;
    }

    public String getType_discount() {
        return this.type_discount;
    }

    public void setType_discount(String type_discount) {
        this.type_discount = type_discount;
    }

    public String getAlias_size() {
        return this.alias_size;
    }

    public void setAlias_size(String alias_size) {
        this.alias_size = alias_size;
    }

    public boolean isPromo_product() {
        return this.promo_product;
    }

    public void setPromo_product(boolean promo_product) {
        this.promo_product = promo_product;
    }

    public String getId_global_product() {
        return this.id_global_product;
    }

    public void setId_global_product(String id_global_product) {
        this.id_global_product = id_global_product;
    }
}

