/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.kitchen.dao.entities;

import com.openbravo.pos.util.LogToFile;
import fr.protactile.kitchen.dao.entities.ScreenItem;
import fr.protactile.kitchen.dao.entities.ScreenLine;
import fr.protactile.kitchen.dao.entities.ScreenSupplement;
import java.io.Serializable;
import java.util.Collection;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@Entity
@Table(name="SCREENS")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="Screen.findAll", query="SELECT s FROM Screen s"), @NamedQuery(name="Screen.findById", query="SELECT s FROM Screen s WHERE s.id = :id"), @NamedQuery(name="Screen.findByName", query="SELECT s FROM Screen s WHERE s.name = :name")})
public class Screen
implements Serializable,
Cloneable {
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="idScreen")
    private Collection<ScreenLine> screenLineCollection;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="idScreen")
    private Collection<ScreenSupplement> screenSupplementCollection;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="idScreen")
    private Collection<ScreenItem> screenItemCollection;
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="ID")
    private Integer id;
    @Size(max=255)
    @Column(name="NAME")
    private @Size(max=255) String name;
    @Column(name="NUMBER", columnDefinition="int default '0'")
    private Integer number;
    @Column(name="DELETED", columnDefinition="boolean default false", nullable=false)
    private boolean deleted;

    public Screen() {
    }

    public Screen(Integer id) {
        this.id = id;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Screen)) {
            return false;
        }
        Screen other = (Screen)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return this.name;
    }

    public Object clone() {
        try {
            Screen o = null;
            o = (Screen)super.clone();
            return o;
        }
        catch (CloneNotSupportedException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return null;
        }
    }

    @XmlTransient
    public Collection<ScreenSupplement> getScreenSupplementCollection() {
        return this.screenSupplementCollection;
    }

    public void setScreenSupplementCollection(Collection<ScreenSupplement> screenSupplementCollection) {
        this.screenSupplementCollection = screenSupplementCollection;
    }

    @XmlTransient
    public Collection<ScreenLine> getScreenLineCollection() {
        return this.screenLineCollection;
    }

    public void setScreenLineCollection(Collection<ScreenLine> screenLineCollection) {
        this.screenLineCollection = screenLineCollection;
    }

    @XmlTransient
    public Collection<ScreenItem> getScreenItemCollection() {
        return this.screenItemCollection;
    }

    public void setScreenItemCollection(Collection<ScreenItem> screenItemCollection) {
        this.screenItemCollection = screenItemCollection;
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }
}

