/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.kitchen.dao.entities;

import com.openbravo.pos.util.LogToFile;
import fr.protactile.kitchen.dao.entities.LinesOrder;
import fr.protactile.kitchen.dao.entities.ScreenItemNew;
import fr.protactile.kitchen.dao.entities.Supplements;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@Entity
@Table(name="ITEMS")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="Items.findAll", query="SELECT i FROM Items i"), @NamedQuery(name="Items.findById", query="SELECT i FROM Items i WHERE i.id = :id"), @NamedQuery(name="Items.findByName", query="SELECT i FROM Items i WHERE i.name = :name"), @NamedQuery(name="Items.findByQuantity", query="SELECT i FROM Items i WHERE i.quantity = :quantity"), @NamedQuery(name="Items.findByStatus", query="SELECT i FROM Items i WHERE i.status = :status")})
public class Items
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="ID")
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=255)
    @Column(name="NAME")
    private @NotNull @Size(min=1, max=255) String name;
    @Basic(optional=false)
    @NotNull
    @Column(name="QUANTITY")
    private double quantity;
    @Size(max=255)
    @Column(name="STATUS")
    private @Size(max=255) String status;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="idItem")
    private Collection<Supplements> supplementsCollection;
    @JoinColumn(name="ID_LINE", referencedColumnName="ID", foreignKey=@ForeignKey(name="items_ibfk_1"))
    @ManyToOne(optional=false)
    private LinesOrder idLine;
    @Transient
    private int id_carte;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="idItem")
    private Collection<ScreenItemNew> screenItemCollection;
    @Column(name="IMAGE_PATH")
    private String image_path;
    @Basic(optional=false)
    @Column(name="id_product", columnDefinition="int default '0'")
    private int id_product;
    @Transient
    private int index_carte;
    @Column(name="UPDATED_AT")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date updatedAt;
    @Basic(optional=false)
    @Column(name="VALID", columnDefinition="boolean default false", nullable=false)
    private boolean valid;
    @Transient
    private int id_product_local;
    @Transient
    private int id_carte_local;
    @Basic(optional=false)
    @Column(name="TOP_PRODUCT", columnDefinition="boolean default false", nullable=false)
    private boolean top_product;
    @Column(name="ID_ITEM_SOURCE", columnDefinition="int default 0", nullable=false)
    private int id_item_source;
    @Column(name="alias_size")
    private String alias_size;
    @Column(name="SIZE_PRODUCT")
    private String sizeProduct;
    @Column(name="COMMENT")
    private String comment;
    @Column(name="FROM_OPTION", columnDefinition="boolean default false", nullable=false)
    private boolean fromOption;
    @Column(name="alias")
    private String alias;
    @Column(name="REAL_QUANTITY", columnDefinition="double default 0", nullable=false)
    private double real_quantity;
    @Column(name="ZONE_NAME")
    private String zone_name;
    @Column(name="ZONE_POSITION", columnDefinition="int default 0", nullable=false)
    private int zone_position;
    @Column(name="ZONE_COLOR")
    private String zone_color;
    @Transient
    private int id_item_tmp;
    @Transient
    private boolean supplement;
    @Size(max=255)
    @Column(name="id_global_product")
    private @Size(max=255) String id_global_product;
    @Transient
    private String id_global_carte;

    public Items() {
    }

    public Items(Integer id) {
        this.id = id;
    }

    public Items(Integer id, String name, double quantity) {
        this.id = id;
        this.name = name;
        this.quantity = quantity;
    }

    public Items(String name, double quantity, String status, int id_item, int id_carte, String image_path, int index_carte, int id_product_local, int id_carte_local, boolean top_product, String sizeProduct, String alias_size, String comment, String alias, double real_quantity) {
        this.name = name;
        this.quantity = quantity;
        this.status = status;
        this.id_carte = id_carte;
        this.image_path = image_path;
        this.id_product = id_item;
        this.index_carte = index_carte;
        this.id_product_local = id_product_local;
        this.id_carte_local = id_carte_local;
        this.top_product = top_product;
        this.sizeProduct = sizeProduct;
        this.alias_size = alias_size;
        this.comment = comment;
        this.alias = alias;
        this.real_quantity = real_quantity;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @XmlTransient
    public Collection<Supplements> getSupplementsCollection() {
        return this.supplementsCollection;
    }

    public void setSupplementsCollection(Collection<Supplements> supplementsCollection) {
        this.supplementsCollection = supplementsCollection;
    }

    public LinesOrder getIdLine() {
        return this.idLine;
    }

    public void setIdLine(LinesOrder idLine) {
        this.idLine = idLine;
    }

    @XmlTransient
    public Collection<ScreenItemNew> getScreenItemCollection() {
        return this.screenItemCollection;
    }

    public void setScreenItemCollection(Collection<ScreenItemNew> screenItemCollection) {
        this.screenItemCollection = screenItemCollection;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Items)) {
            return false;
        }
        Items other = (Items)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "fr.protactile.kitchen.dao.entities.Items[ id=" + this.id + " ]";
    }

    public int getId_carte() {
        return this.id_carte;
    }

    public void setId_carte(int id_carte) {
        this.id_carte = id_carte;
    }

    public int getId_product() {
        return this.id_product;
    }

    public void setId_product(int id_product) {
        this.id_product = id_product;
    }

    public int getIndex_carte() {
        return this.index_carte;
    }

    public void setIndex_carte(int index_carte) {
        this.index_carte = index_carte;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public int getId_product_local() {
        return this.id_product_local;
    }

    public void setId_product_local(int id_product_local) {
        this.id_product_local = id_product_local;
    }

    public int getId_carte_local() {
        return this.id_carte_local;
    }

    public void setId_carte_local(int id_carte_local) {
        this.id_carte_local = id_carte_local;
    }

    public boolean isTop_product() {
        return this.top_product;
    }

    public void setTop_product(boolean top_product) {
        this.top_product = top_product;
    }

    public Object clone() {
        try {
            Items o = null;
            o = (Items)super.clone();
            ArrayList<Supplements> supplements = new ArrayList<Supplements>();
            for (Supplements supplement : this.supplementsCollection) {
                supplements.add((Supplements)supplement.clone());
            }
            o.setSupplementsCollection(supplements);
            return o;
        }
        catch (CloneNotSupportedException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return null;
        }
    }

    public int getId_item_source() {
        return this.id_item_source;
    }

    public void setId_item_source(int id_item_source) {
        this.id_item_source = id_item_source;
    }

    public int getId_item_tmp() {
        return this.id_item_tmp;
    }

    public void setId_item_tmp(int id_item_tmp) {
        this.id_item_tmp = id_item_tmp;
    }

    public boolean isSupplement() {
        return this.supplement;
    }

    public void setSupplement(boolean supplement) {
        this.supplement = supplement;
    }

    public String getAlias_size() {
        return this.alias_size;
    }

    public void setAlias_size(String alias_size) {
        this.alias_size = alias_size;
    }

    public String getSizeProduct() {
        return this.sizeProduct;
    }

    public void setSizeProduct(String sizeProduct) {
        this.sizeProduct = sizeProduct;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getId_global_product() {
        return this.id_global_product;
    }

    public void setId_global_product(String id_global_product) {
        this.id_global_product = id_global_product;
    }

    public String getId_global_carte() {
        return this.id_global_carte;
    }

    public void setId_global_carte(String id_global_carte) {
        this.id_global_carte = id_global_carte;
    }

    public boolean isFromOption() {
        return this.fromOption;
    }

    public void setFromOption(boolean fromOption) {
        this.fromOption = fromOption;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public double getRealQuantity() {
        return this.real_quantity;
    }

    public void setRealQuantity(double realQuantity) {
        this.real_quantity = realQuantity;
    }

    public String getZoneName() {
        return this.zone_name;
    }

    public void setZoneName(String zoneName) {
        this.zone_name = zoneName;
    }

    public int getZonePosition() {
        return this.zone_position;
    }

    public void setZonePosition(int zonePosition) {
        this.zone_position = zonePosition;
    }

    public String getZoneColor() {
        return this.zone_color;
    }

    public void setZoneColor(String zoneColor) {
        this.zone_color = zoneColor;
    }
}

