/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.kitchen.dao.config;

import com.openbravo.pos.util.LogToFile;
import com.procaisse.db.connection.hibernate.DBUtils;
import com.procaisse.db.connection.hibernate.HibernateTools;
import fr.protactile.kitchen.dao.entities.LinesOrder;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public abstract class DaoConfig<T> {
    protected static Session s = HibernateTools.getSession();
    protected static SessionFactory sessionFactory = HibernateTools.sessionFactory_kitchen;

    protected abstract Class<T> classType();

    public void openSession() {
        if (s == null || s != null && !s.isOpen()) {
            s = HibernateTools.getSession();
        }
    }

    public Session getCurrentSession() {
        this.openSession();
        return s;
    }

    public void close() {
        if (s != null) {
            s.close();
        }
    }

    public List<T> list() {
        this.openSession();
        if (s != null) {
            Query query = s.createQuery("from " + this.classType().getName());
            List list = query.list();
            s.close();
            return list;
        }
        return null;
    }

    public T find(Object _id) {
        if (!s.isOpen()) {
            this.openSession();
        }
        Object result = s.find(this.classType(), _id);
        return (T)result;
    }

    public void save(Object o) {
        if (s == null) {
            DBUtils.initDB();
            s = HibernateTools.getSession();
        }
        if (s != null) {
            if (!s.isOpen()) {
                this.openSession();
            }
            if (o != null) {
                s.save(o);
            }
        }
    }

    public void update(Object o) {
        if (!s.isOpen()) {
            this.openSession();
        }
        if (o != null) {
            s.update(o);
        }
    }

    public void remove(Object o) {
        block4: {
            if (!s.isOpen()) {
                this.openSession();
            }
            if (o != null) {
                Transaction tx = null;
                try {
                    tx = s.beginTransaction();
                    s.remove(o);
                    tx.commit();
                }
                catch (Exception e) {
                    LogToFile.log("severe", e.getMessage(), e);
                    if (tx == null) break block4;
                    tx.rollback();
                }
            }
        }
    }

    public void removeById(Object _id) {
        T o = this.find(_id);
        if (o != null) {
            this.remove(o);
        }
    }

    public void persist(Object o) {
        if (!s.isOpen()) {
            this.openSession();
        }
        if (o != null) {
            s.persist(o);
        }
    }

    public T merge(Object o) {
        if (!s.isOpen()) {
            this.openSession();
        }
        if (o != null) {
            return (T)s.merge(o);
        }
        return null;
    }

    public void flush() {
        if (s != null) {
            s.flush();
        }
    }

    public void clear() {
        if (s != null) {
            s.clear();
        }
    }

    public void setSession() {
        s = HibernateTools.getSession();
    }

    public SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    public T find(Object _id, Session session) {
        Object result = session.find(this.classType(), _id);
        return (T)result;
    }

    public void saveOrUpdate(Object o) {
        if (s == null) {
            DBUtils.initDB();
            s = HibernateTools.getSession();
        }
        if (s != null) {
            if (!s.isOpen()) {
                this.openSession();
            }
            if (o != null) {
                s.saveOrUpdate(o);
            }
        }
    }

    public void saveOrUpdate(String className, Object o) {
        if (s == null) {
            DBUtils.initDB();
            s = HibernateTools.getSession();
        }
        if (s != null) {
            if (!s.isOpen()) {
                this.openSession();
            }
            if (o != null) {
                if (o instanceof LinesOrder) {
                    System.out.println("line quantity : : " + ((LinesOrder)o).getQuantity());
                }
                s.saveOrUpdate(className, o);
            }
        }
    }
}

