/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.glory.POSSimple;

import com.glory.fcc.service.BrueBoxServiceStub;
import com.glory.fcc.service.IUserInterface;
import fr.protactile.glory.POSSimple.IPrinter;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class PrintClass {
    private String[] JH_Line;
    private String[] JF_Line;
    private IPrinter printer;
    SimpleDateFormat sdf1 = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

    public PrintClass(IPrinter p) {
        int i;
        this.printer = p;
        int MAX_LINE = Integer.parseInt(this.getIni("JournalHeader", "MAXLINE", "4", "POSSimple.ini"));
        this.JH_Line = new String[MAX_LINE];
        for (i = 0; i < MAX_LINE; ++i) {
            this.JH_Line[i] = this.getIni("JournalHeader", "LINE" + (i + 1), "", "POSSimple.ini");
        }
        MAX_LINE = Integer.parseInt(this.getIni("JournalFooter", "MAXLINE", "2", "POSSimple.ini"));
        this.JF_Line = new String[MAX_LINE];
        for (i = 0; i < MAX_LINE; ++i) {
            this.JF_Line[i] = this.getIni("JournalFooter", "LINE" + (i + 1), "", "POSSimple.ini");
        }
    }

    public String space(int num) {
        Object ret = "";
        for (int i = 0; i < num; ++i) {
            ret = (String)ret + " ";
        }
        return ret;
    }

    public String getIni(String ApName, String keyName, String defaults, String file) {
        System.out.println(file);
        StringBuilder strResult = new StringBuilder(this.space(255));
        strResult.delete(0, strResult.length());
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            String line = null;
            Vector<String> lines = new Vector<String>();
            while ((line = in.readLine()) != null) {
                lines.add(line);
            }
            in.close();
            int beginSection = -1;
            for (int l = 0; l < lines.size(); ++l) {
                line = (String)lines.get(l);
                System.out.println(line);
                if (!line.trim().startsWith("[")) continue;
                beginSection = l;
                if (!ApName.equals(line.substring(line.indexOf("[") + 1, line.indexOf("]")))) continue;
                for (int m = beginSection + 1; m < lines.size() && !(line = (String)lines.get(m)).trim().startsWith("["); ++m) {
                    int index = line.indexOf(61);
                    if (index < 0 || !keyName.equals(line.substring(0, index).trim())) continue;
                    strResult.append(line.substring(index + 1).trim());
                    return strResult.toString();
                }
            }
            return strResult.toString();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return defaults;
    }

    public String center(String str) {
        int spaces = (int)Math.floor((35 - str.length()) / 2);
        return this.space(spaces) + str;
    }

    public void printJournal(String str) {
        this.printer.println(str);
    }

    public void printHeader() {
        for (int i = 0; i < this.JH_Line.length; ++i) {
            this.printJournal(this.center(this.JH_Line[i]));
        }
        Date date1 = new Date();
        this.printJournal(this.center(this.sdf1.format(date1) + "\n"));
        this.printJournal("#:Name" + this.space(16) + "QTY" + this.space(4) + "Amount");
        this.printJournal("-----------------------------------");
    }

    public void printFooter(boolean paied, long paidAmount, String total, String deposit, String change) {
        this.printJournal("-----------------------------------");
        this.printJournal(this.space(20) + "TOTAL " + this.space(9 - total.length()) + total + "\n");
        this.printJournal(this.space(20) + "Cash  " + this.space(9 - deposit.length()) + deposit);
        this.printJournal(this.space(20) + "Change" + this.space(9 - change.length()) + change + "\n\n");
        if (!paied && Double.parseDouble(change.replaceAll(",", "")) > 0.0) {
            this.printJournal("Non Paied Amount is " + IUserInterface.decimalFormat.format((double)paidAmount / 100.0) + " Euro");
            this.printJournal("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            this.printJournal("The Change is not paied. ");
            this.printJournal("Please goto customer desk with this");
            this.printJournal("ticket.");
            this.printJournal("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
        for (int i = 0; i < this.JF_Line.length; ++i) {
            this.printJournal(this.center(this.JF_Line[i]));
        }
        this.printJournal("===================================");
    }

    public void printRepFEHeader() {
        Date date1 = new Date();
        this.printJournal(this.center(this.sdf1.format(date1) + "\n"));
        this.printJournal(this.center("Replenishment From Entrance"));
        this.printJournal("Denomination" + this.space(8) + "QTY" + this.space(6) + "Amount");
        this.printJournal("-----------------------------------");
    }

    public void printEndRepFE(BrueBoxServiceStub.CashType cash) {
        this.printJournal("-----------------------------------");
        this.getDenominationTotal(cash.getDenomination());
        this.printJournal("===================================");
    }

    public void printRepFCHeader() {
        Date date1 = new Date();
        this.printJournal(this.center(this.sdf1.format(date1) + "\n"));
        this.printJournal(this.center("Replenishment From Cassette"));
        this.printJournal("Denomination" + this.space(8) + "QTY" + this.space(6) + "Amount");
        this.printJournal("-----------------------------------");
    }

    public void printEndRepFC(BrueBoxServiceStub.CashType cash) {
        this.printJournal("-----------------------------------");
        this.getDenominationTotal(cash.getDenomination());
        this.printJournal("===================================");
    }

    public int getDenominationTotal(BrueBoxServiceStub.DenominationType[] denomination) {
        int total = 0;
        if (denomination != null) {
            for (int j = 0; j < denomination.length; ++j) {
                BrueBoxServiceStub.DenominationType dnm = denomination[j];
                float fValue = dnm.getFv().intValue();
                float fValue100 = fValue / 100.0f;
                String amtStr = IUserInterface.decimalFormat.format((float)dnm.getPiece().intValue() * fValue100);
                String lblStr = IUserInterface.decimalFormat.format(fValue100);
                total += (int)((float)dnm.getPiece().intValue() * fValue);
                this.printJournal(lblStr + this.space(15 - lblStr.length()) + this.space(8 - dnm.getPiece().toString().length()) + dnm.getPiece() + this.space(12 - amtStr.length()) + amtStr);
            }
        } else {
            this.printJournal(this.center("Nothing"));
        }
        return total;
    }

    public void printCancelCashin(BrueBoxServiceStub.CashType[] cash) {
        int[] total = new int[2];
        this.printJournal("-----------------------------------");
        this.printJournal("************ CANCELLED ************");
        for (int i = 0; i < cash.length; ++i) {
            total[i] = 0;
            if (cash[i].getType().intValue() == 1) {
                this.printJournal(this.center("Cash In Details"));
            }
            if (cash[i].getType().intValue() == 2) {
                this.printJournal(this.center("Returned Cash Details"));
            }
            total[i] = this.getDenominationTotal(cash[i].getDenomination());
        }
        if (total[0] != total[1]) {
            this.printJournal("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            this.printJournal("Please goto customer desk with this");
            this.printJournal("ticket and get cash. " + IUserInterface.decimalFormat.format((total[0] - total[1]) / 100) + "Euro");
            this.printJournal("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
        this.printJournal("===================================");
    }
}

