/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.glory.POSSimple;

import fr.protactile.glory.POSSimple.FrmMain;
import fr.protactile.glory.POSSimple.ItemsClass;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class FrmItemList
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JScrollPane jScrollPane = null;
    private JTable dgItemList = null;
    private DefaultTableModel defaultTableModel = null;
    private final String[] columnNames = new String[]{"#", "Name", "Amount"};
    private FrmMain _pFrm;

    public FrmItemList(FrmMain pFrm) {
        this._pFrm = pFrm;
        this.initialize();
    }

    private void initialize() {
        this.setSize(316, 300);
        this.setPreferredSize(new Dimension(316, 300));
        this.setContentPane(this.getJContentPane());
        this.setTitle("frmItemList");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                System.out.println("windowOpened()");
                FrmItemList.this.defaultTableModel.setColumnIdentifiers(FrmItemList.this.columnNames);
                DefaultTableColumnModel columnModel = (DefaultTableColumnModel)FrmItemList.this.dgItemList.getColumnModel();
                columnModel.getColumn(0).setPreferredWidth(1);
                columnModel.getColumn(1).setPreferredWidth(150);
                DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(4);
                columnModel.getColumn(2).setCellRenderer(renderer);
                Document doc = null;
                SAXBuilder adapter = new SAXBuilder();
                try {
                    doc = adapter.build("ItemList.xml");
                    List list = doc.getRootElement().getChildren();
                    for (Element element : list) {
                        Object[] info = new String[3];
                        info[0] = element.getChildText("itemNum");
                        info[1] = element.getChildText("itemName");
                        DecimalFormat format = new DecimalFormat("#,##0.00");
                        info[2] = format.format(Double.parseDouble(element.getChildText("itemAmount")) / 100.0);
                        FrmItemList.this.defaultTableModel.addRow(info);
                    }
                }
                catch (JDOMException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJScrollPane(), "Center");
        }
        return this.jContentPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getDgItemList());
        }
        return this.jScrollPane;
    }

    private DefaultTableModel getDefaultTableModel() {
        if (this.defaultTableModel == null) {
            this.defaultTableModel = new DefaultTableModel();
            this.defaultTableModel.setColumnCount(3);
        }
        return this.defaultTableModel;
    }

    private JTable getDgItemList() {
        if (this.dgItemList == null) {
            this.dgItemList = new JTable(1, 3){
                private static final long serialVersionUID = 9017336483126396560L;

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            this.dgItemList.setSize(new Dimension(286, 242));
            this.dgItemList.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.dgItemList.setModel(this.getDefaultTableModel());
            this.dgItemList.setSelectionMode(0);
            this.dgItemList.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    System.out.println("mouseClicked()");
                    if (e.getClickCount() == 2) {
                        Point pt = e.getPoint();
                        int row = FrmItemList.this.dgItemList.convertRowIndexToModel(FrmItemList.this.dgItemList.rowAtPoint(pt));
                        FrmItemList.this._pFrm.txtNumber.setText(FrmItemList.this.defaultTableModel.getValueAt(row, 0).toString());
                        FrmItemList.this._pFrm.lblName.setText(FrmItemList.this.defaultTableModel.getValueAt(row, 1).toString());
                        FrmItemList.this._pFrm.txtAmount.setText(FrmItemList.this.defaultTableModel.getValueAt(row, 2).toString());
                        FrmItemList.this._pFrm.txtCount.setText("1");
                        FrmItemList.this._pFrm.txtCount.requestFocus();
                        FrmItemList.this._pFrm.txtCount.selectAll();
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
        }
        return this.dgItemList;
    }

    public ItemsClass getItemsClass(int id) {
        ItemsClass myitem = new ItemsClass();
        for (int i = 0; i < this.dgItemList.getRowCount(); ++i) {
            if (Integer.parseInt(this.defaultTableModel.getValueAt(i, 0).toString()) != id) continue;
            myitem.setItemNum(id);
            myitem.setItemName(this.defaultTableModel.getValueAt(i, 1).toString());
            myitem.setItemAmount(Double.parseDouble(this.defaultTableModel.getValueAt(i, 2).toString()));
            return myitem;
        }
        myitem.setItemNum(-1);
        return myitem;
    }
}

