/*
 * Decompiled with CFR 0.152.
 */
package fr.biborne.jobqueue;

import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.UploadCommandService;
import fr.biborne.jobqueue.Job;
import fr.biborne.jobqueue.JobResult;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.json.JSONObject;

public class SendToCaisseJob
implements Job {
    private JSONObject ticketObject;
    private int numRetry;

    public SendToCaisseJob(JSONObject ticketObject) {
        this.ticketObject = ticketObject;
        this.numRetry = 0;
    }

    @Override
    public JobResult run() {
        boolean success = false;
        boolean retry = false;
        int delay = 0;
        Response response = null;
        if (AppLocal.IP_MASTER != null) {
            try {
                JSONObject jsonResponse;
                String responseBodyString;
                String url = "http://" + AppLocal.IP_MASTER + ":9097/newItems/sendTicketToMev";
                OkHttpClient client = new OkHttpClient();
                RequestBody body = RequestBody.create((MediaType)UploadCommandService.JSON, (String)this.ticketObject.toString());
                Request request = new Request.Builder().url(url).post(body).build();
                response = client.newCall(request).execute();
                ResponseBody responseBody = response.body();
                if (responseBody != null && !(responseBodyString = response.body().string()).isEmpty() && !(jsonResponse = new JSONObject(responseBodyString)).isNull("message")) {
                    String message = jsonResponse.getString("message");
                    success = message.equalsIgnoreCase("success");
                }
                response.close();
            }
            catch (IOException ex) {
                if (response != null) {
                    response.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        if (!success && this.numRetry < 3) {
            ++this.numRetry;
            switch (this.numRetry) {
                case 1: {
                    delay = 5000;
                    break;
                }
                case 2: {
                    delay = 30000;
                    break;
                }
                case 3: {
                    delay = 120000;
                }
            }
            retry = true;
        }
        JobResult jobResult = new JobResult(success, retry, delay);
        return jobResult;
    }

    public int getNumRetry() {
        return this.numRetry;
    }

    public void setNumRetry(int numRetry) {
        this.numRetry = numRetry;
    }

    @Override
    public void sendLog() {
        LogToFile.log("Probleme d'envoi des commandes des bornes vers la caisse");
    }
}

