/*
 * Decompiled with CFR 0.152.
 */
package fr.biborne.jobqueue;

import com.openbravo.pos.util.LogToFile;
import com.procaisse.MEV.SendData;
import fr.biborne.jobqueue.Job;
import fr.biborne.jobqueue.JobResult;

public class MevJob
implements Job {
    private String requestXMLMev;
    private SendData sendData;
    private int numRetry;

    public MevJob(String requestXMLMev) {
        this.requestXMLMev = requestXMLMev;
        this.sendData = new SendData();
        this.numRetry = 0;
    }

    @Override
    public JobResult run() {
        boolean success = false;
        boolean retry = false;
        int delay = 0;
        System.out.println("numRetry******* : " + this.numRetry);
        try {
            success = this.sendData.sendDataToMEV(this.requestXMLMev);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        if (!success && this.numRetry < 3) {
            ++this.numRetry;
            switch (this.numRetry) {
                case 1: {
                    delay = 5000;
                    break;
                }
                case 2: {
                    delay = 30000;
                    break;
                }
                case 3: {
                    delay = 120000;
                }
            }
            retry = true;
        }
        JobResult jobResult = new JobResult(success, retry, delay);
        return jobResult;
    }

    public int getNumRetry() {
        return this.numRetry;
    }

    public void setNumRetry(int numRetry) {
        this.numRetry = numRetry;
    }

    @Override
    public void sendLog() {
        LogToFile.log("Probleme d'envoi des transactions caisse vers la MEV");
    }
}

