/*
 * Decompiled with CFR 0.152.
 */
package fr.biborne.jobqueue;

import com.openbravo.pos.util.LogToFile;
import fr.biborne.jobqueue.IJobQueue;
import fr.biborne.jobqueue.Job;
import fr.biborne.jobqueue.JobResult;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ManagerJobQueue {
    private IJobQueue jobQueue;

    public ManagerJobQueue(IJobQueue jobQueue) {
        this.jobQueue = jobQueue;
    }

    public void addJob(Job job) {
        long key = new Date().getTime();
        this.addJob(job, key);
    }

    public void addJob(Job job, long key) {
        this.jobQueue.addJob(key, job);
    }

    public IJobQueue getJobQueue() {
        return this.jobQueue;
    }

    public void handleJobs() {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        exec.execute(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        if (!ManagerJobQueue.this.jobQueue.isEmpty()) {
                            long nowTime = new Date().getTime();
                            Map.Entry<Long, Job> firstEntry = ManagerJobQueue.this.jobQueue.getFirstEntry();
                            long jobExecutionTime = firstEntry.getKey();
                            Job job = firstEntry.getValue();
                            if (job != null && nowTime >= jobExecutionTime) {
                                JobResult jobResult = job.run();
                                System.out.println("jobResult : " + jobResult);
                                ManagerJobQueue.this.jobQueue.removeJob(jobExecutionTime);
                                if (!jobResult.isSuccess()) {
                                    if (!jobResult.shouldRetry()) {
                                        job.sendLog();
                                    } else {
                                        long executionTime = nowTime + (long)jobResult.getDelay();
                                        ManagerJobQueue.this.jobQueue.addJob(executionTime, job);
                                    }
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                        continue;
                    }
                    break;
                }
            }
        });
    }
}

