/*
 * Decompiled with CFR 0.152.
 */
package com.protactile.mailer;

import com.openbravo.pos.util.LogToFile;
import com.protactile.mailer.AttachmentResource;
import com.protactile.mailer.Email;
import com.protactile.mailer.EmailAddressValidationCriteria;
import com.protactile.mailer.EmailValidationUtil;
import com.protactile.mailer.MailException;
import com.protactile.mailer.Recipient;
import com.protactile.mailer.TransportStrategy;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class Mailer {
    private Session session;
    private TransportStrategy transportStrategy;
    private EmailAddressValidationCriteria emailAddressValidationCriteria;

    public Mailer(Session session) {
        this.session = session;
        this.emailAddressValidationCriteria = new EmailAddressValidationCriteria(true, true);
    }

    public Mailer(String host, String port, String username, String password) {
        this.createSession(host, port, username, password);
        this.emailAddressValidationCriteria = new EmailAddressValidationCriteria(true, true);
    }

    public Mailer(String host, int port, String username, String password, TransportStrategy transportStrategy) {
        if (host == null || "".equals(host.trim())) {
            throw new RuntimeException("Can't send an email without host");
        }
        if (password != null && !"".equals(password.trim()) && (username == null || "".equals(username.trim()))) {
            throw new RuntimeException("Can't have a password without username");
        }
        this.transportStrategy = transportStrategy;
        this.session = this.createMailSession(host, port, username, password);
        this.emailAddressValidationCriteria = new EmailAddressValidationCriteria(true, true);
    }

    public Session createMailSession(String host, int port, final String username, final String password) {
        Properties properties = System.getProperties();
        properties.setProperty("mail.smtp.host", host);
        properties.put("mail.smtp.port", (Object)port);
        properties.put("mail.smtp.auth", "true");
        properties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        if (password != null) {
            return Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password);
                }
            });
        }
        return Session.getInstance((Properties)properties);
    }

    public Mailer(String host, int port, String username, String password) {
        this(host, port, username, password, TransportStrategy.SMTP_SSL);
    }

    public void setDebug(boolean debug) {
        this.session.setDebug(debug);
    }

    public final void sendMail(Email email) throws MailException {
        if (this.validate(email)) {
            try {
                MimeEmailMessageWrapper messageRoot = new MimeEmailMessageWrapper();
                MimeMessage message = new MimeMessage(this.session);
                message.setFrom((Address)new InternetAddress(email.getFromRecipient().getAddress(), email.getFromRecipient().getName()));
                this.setRecipients(email, (Message)message);
                message.setSubject(email.getSubject());
                message.setContent((Multipart)messageRoot.multipartRoot);
                this.setTexts(email, messageRoot.multipartAlternativeMessages);
                this.setEmbeddedImages(email, messageRoot.multipartRelated);
                this.setAttachments(email, messageRoot.multipartRoot);
                message.saveChanges();
                Transport transport = this.session.getTransport();
                transport.connect();
                transport.sendMessage((Message)message, message.getAllRecipients());
                transport.close();
                System.out.println("+++++++ send message");
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    private void logSession(Session session, TransportStrategy transportStrategy) {
        String logmsg = "starting mail session (host: %s, port: %s, username: %s, authenticate: %s, transport: %s)";
        Properties properties = session.getProperties();
    }

    public boolean validate(Email email) throws MailException {
        if (email.getText() == null && email.getTextHTML() == null) {
            throw new MailException("Email is not valid: missing content body");
        }
        if (email.getSubject() == null || email.getSubject().equals("")) {
            throw new MailException("Email is not valid: missing subject");
        }
        if (email.getRecipients().size() == 0) {
            throw new MailException("Email is not valid: missing recipients");
        }
        if (email.getFromRecipient() == null) {
            throw new MailException("Email is not valid: missing sender");
        }
        if (!EmailValidationUtil.isValid(email.getFromRecipient().getAddress(), this.emailAddressValidationCriteria)) {
            throw new MailException(String.format("Invalid FROM address: %s", email));
        }
        for (Recipient recipient : email.getRecipients()) {
            if (EmailValidationUtil.isValid(recipient.getAddress(), this.emailAddressValidationCriteria)) continue;
            throw new MailException(String.format("Invalid TO address: %s", email));
        }
        return true;
    }

    private Message prepareMessage(Email email, MimeMultipart multipartRoot) throws MessagingException, UnsupportedEncodingException {
        MimeMessage message = new MimeMessage(this.session);
        message.setSubject(email.getSubject());
        message.setFrom((Address)new InternetAddress(email.getFromRecipient().getAddress(), email.getFromRecipient().getName()));
        message.setContent((Multipart)multipartRoot);
        message.setSentDate(new Date());
        return message;
    }

    private void setRecipients(Email email, Message message) throws UnsupportedEncodingException, MessagingException {
        for (Recipient recipient : email.getRecipients()) {
            System.out.println("++++++++++ recipient.getAddress() : " + recipient.getAddress());
            InternetAddress address = new InternetAddress(recipient.getAddress(), recipient.getName());
            message.addRecipient(recipient.getType(), (Address)address);
        }
    }

    private void setTexts(Email email, MimeMultipart multipartAlternativeMessages) throws MessagingException {
        if (email.getText() != null) {
            MimeBodyPart messagePart = new MimeBodyPart();
            messagePart.setText(email.getText(), "UTF-8");
            multipartAlternativeMessages.addBodyPart((BodyPart)messagePart);
        }
        if (email.getTextHTML() != null) {
            MimeBodyPart messagePartHTML = new MimeBodyPart();
            messagePartHTML.setContent((Object)email.getTextHTML(), "text/html; charset=\"UTF-8\"");
            multipartAlternativeMessages.addBodyPart((BodyPart)messagePartHTML);
        }
    }

    private void setEmbeddedImages(Email email, MimeMultipart multipartRelated) throws MessagingException {
        for (AttachmentResource embeddedImage : email.getEmbeddedImages()) {
            multipartRelated.addBodyPart(this.getBodyPartFromDatasource(embeddedImage, "inline"));
        }
    }

    private void setAttachments(Email email, MimeMultipart multipartRoot) throws MessagingException {
        for (AttachmentResource resource : email.getAttachments()) {
            multipartRoot.addBodyPart(this.getBodyPartFromDatasource(resource, "attachment"));
        }
    }

    private BodyPart getBodyPartFromDatasource(AttachmentResource resource, String dispositionType) throws MessagingException {
        MimeBodyPart attachmentPart = new MimeBodyPart();
        DataSource ds = resource.getDataSource();
        attachmentPart.setDataHandler(new DataHandler(resource.getDataSource()));
        attachmentPart.setFileName(resource.getName());
        attachmentPart.setHeader("Content-Type", ds.getContentType() + "; filename=" + ds.getName() + "; name=" + ds.getName());
        attachmentPart.setHeader("Content-ID", String.format("<%s>", ds.getName()));
        attachmentPart.setDisposition(dispositionType + "; size=0");
        return attachmentPart;
    }

    public void setEmailAddressValidationCriteria(EmailAddressValidationCriteria emailAddressValidationCriteria) {
        this.emailAddressValidationCriteria = emailAddressValidationCriteria;
    }

    public static void sendMailParametred(Email email) {
        String javaHome = System.getProperty("java.home");
        String java_home = javaHome.replace("\\", "/");
        String cacert = java_home + "/lib/security/cacerts";
        System.setProperty("javax.net.ssl.trustStore", cacert);
        System.setProperty("javax.net.ssl.trustStorePassword", "changeit");
        String username = "procaisse@giga-tactile.fr";
        String password = "Momtazpa55$";
        String host = "smtp.ionos.fr";
        new Mailer("smtp.ionos.fr", "465", "procaisse@giga-tactile.fr", "Momtazpa55$").sendMail(email);
    }

    private void sendEmail() {
        String to = "khadija.elallaoui@gmail.com";
        String from = "nono-reply@pro-tactile.fr";
        System.out.println("TLSEmail Start");
        try {
            MimeMessage message = new MimeMessage(this.session);
            message.setFrom((Address)new InternetAddress(from));
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
            message.setSubject("subject");
            message.setText("Hello, aas is sending email test");
            Transport.send((Message)message);
            System.out.println("Yo it has been sent..");
        }
        catch (MessagingException mex) {
            mex.printStackTrace();
        }
    }

    private void createSession(String host, String port, final String username, final String password) {
        Properties properties = System.getProperties();
        properties.setProperty("mail.smtp.host", host);
        properties.put("mail.transport.protocol", "smtp");
        properties.put("mail.smtp.port", port);
        properties.put("mail.smtp.auth", "true");
        properties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        this.session = Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        });
    }

    private class MimeEmailMessageWrapper {
        private final MimeMultipart multipartRoot = new MimeMultipart("mixed");
        private final MimeMultipart multipartRelated;
        private final MimeMultipart multipartAlternativeMessages;

        MimeEmailMessageWrapper() {
            MimeBodyPart contentRelated = new MimeBodyPart();
            this.multipartRelated = new MimeMultipart("related");
            MimeBodyPart contentAlternativeMessages = new MimeBodyPart();
            this.multipartAlternativeMessages = new MimeMultipart("alternative");
            try {
                this.multipartRoot.addBodyPart((BodyPart)contentRelated);
                contentRelated.setContent((Multipart)this.multipartRelated);
                this.multipartRelated.addBodyPart((BodyPart)contentAlternativeMessages);
                contentAlternativeMessages.setContent((Multipart)this.multipartAlternativeMessages);
            }
            catch (MessagingException e) {
                LogToFile.log("severe", e.getMessage(), (Exception)((Object)e));
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }
}

