/*
 * Decompiled with CFR 0.152.
 */
package com.protactile.mailer;

import com.protactile.mailer.AttachmentResource;
import com.protactile.mailer.Recipient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.activation.DataSource;
import javax.mail.Message;
import javax.mail.util.ByteArrayDataSource;

public class Email {
    private Recipient fromRecipient;
    private String text;
    private String textHTML;
    private String subject;
    private final List<Recipient> recipients = new ArrayList<Recipient>();
    private final List<AttachmentResource> embeddedImages = new ArrayList<AttachmentResource>();
    private final List<AttachmentResource> attachments = new ArrayList<AttachmentResource>();

    public void setFromAddress(String name, String fromAddress) {
        this.fromRecipient = new Recipient(name, fromAddress, null);
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTextHTML(String textHTML) {
        this.textHTML = textHTML;
    }

    public void addRecipient(String name, String address, Message.RecipientType type) {
        this.recipients.add(new Recipient(name, address, type));
    }

    public void addEmbeddedImage(String name, byte[] data, String mimetype) {
        ByteArrayDataSource dataSource = new ByteArrayDataSource(data, mimetype);
        dataSource.setName(name);
        this.addEmbeddedImage(name, (DataSource)dataSource);
    }

    public void addEmbeddedImage(String name, DataSource imagedata) {
        this.embeddedImages.add(new AttachmentResource(name, imagedata));
    }

    public void addAttachment(String name, byte[] data, String mimetype) {
        ByteArrayDataSource dataSource = new ByteArrayDataSource(data, mimetype);
        dataSource.setName(name);
        this.addAttachment(name, (DataSource)dataSource);
    }

    public void addAttachment(String name, DataSource filedata) {
        this.attachments.add(new AttachmentResource(name, filedata));
    }

    public Recipient getFromRecipient() {
        return this.fromRecipient;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getText() {
        return this.text;
    }

    public String getTextHTML() {
        return this.textHTML;
    }

    public List<AttachmentResource> getAttachments() {
        return Collections.unmodifiableList(this.attachments);
    }

    public List<AttachmentResource> getEmbeddedImages() {
        return Collections.unmodifiableList(this.embeddedImages);
    }

    public List<Recipient> getRecipients() {
        return Collections.unmodifiableList(this.recipients);
    }
}

