/*
 * Decompiled with CFR 0.152.
 */
package com.procaisse.db.connection.firebase;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FirebaseUploadLogger {
    private static final String LOG_DIR = System.getProperty("user.home") + "/FirebaseUploadLogs";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat fileNameFormat = new SimpleDateFormat("yyyy-MM-dd_HHmmss");
    private String currentLogFile;
    private BufferedWriter logWriter;

    public FirebaseUploadLogger() {
        this.initializeLogger();
    }

    private void initializeLogger() {
        try {
            File logDirectory = new File(LOG_DIR);
            if (!logDirectory.exists()) {
                logDirectory.mkdirs();
            }
            String timestamp = fileNameFormat.format(new Date());
            this.currentLogFile = LOG_DIR + "/firebase_upload_" + timestamp + ".log";
            this.logWriter = new BufferedWriter(new FileWriter(this.currentLogFile, true));
            this.writeHeader();
        }
        catch (IOException e) {
            System.err.println("Failed to initialize logger: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void writeHeader() throws IOException {
        this.writeLine("=".repeat(80));
        this.writeLine("FIREBASE UPLOAD LOG");
        this.writeLine("Session started at: " + dateFormat.format(new Date()));
        this.writeLine("Log file: " + this.currentLogFile);
        this.writeLine("=".repeat(80));
        this.writeLine("");
    }

    public void logInfo(String message) {
        this.writeLog("INFO", message, null);
    }

    public void logSuccess(String message) {
        this.writeLog("SUCCESS", message, null);
    }

    public void logWarning(String message) {
        this.writeLog("WARNING", message, null);
    }

    public void logError(String message, Exception e) {
        this.writeLog("ERROR", message, e);
    }

    public void logStep(String stepName) {
        try {
            this.writeLine("");
            this.writeLine("-".repeat(80));
            this.writeLine("STEP: " + stepName);
            this.writeLine("-".repeat(80));
        }
        catch (IOException e) {
            System.err.println("Failed to log step: " + e.getMessage());
        }
    }

    private void writeLog(String level, String message, Exception e) {
        try {
            String timestamp = dateFormat.format(new Date());
            String logEntry = String.format("[%s] [%s] %s", timestamp, level, message);
            this.writeLine(logEntry);
            if (e != null) {
                this.writeLine("Exception: " + e.getClass().getName() + ": " + e.getMessage());
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                this.writeLine("Stack trace:");
                this.writeLine(sw.toString());
            }
            System.out.println(logEntry);
            if (e != null) {
                e.printStackTrace();
            }
        }
        catch (IOException ex) {
            System.err.println("Failed to write log: " + ex.getMessage());
        }
    }

    private void writeLine(String line) throws IOException {
        if (this.logWriter != null) {
            this.logWriter.write(line);
            this.logWriter.newLine();
            this.logWriter.flush();
        }
    }

    public void close() {
        try {
            if (this.logWriter != null) {
                this.writeLine("");
                this.writeLine("=".repeat(80));
                this.writeLine("Session ended at: " + dateFormat.format(new Date()));
                this.writeLine("=".repeat(80));
                this.logWriter.close();
                System.out.println("Log file saved to: " + this.currentLogFile);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to close logger: " + e.getMessage());
        }
    }

    public String getLogFilePath() {
        return this.currentLogFile;
    }
}

