/*
 * Decompiled with CFR 0.152.
 */
package com.procaisse.db.connection.firebase;

import com.google.api.core.ApiFuture;
import com.google.api.gax.paging.Page;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FieldValue;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.QuerySnapshot;
import com.google.cloud.firestore.SetOptions;
import com.google.cloud.firestore.WriteResult;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.HttpMethod;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageClass;
import com.google.cloud.storage.StorageOptions;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.cloud.StorageClient;
import com.openbravo.basic.BasicException;
import com.openbravo.basic.BasicStorage;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.parser.CarteParser;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.ticket.UserInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.SystemUtils;
import com.openbravo.service.CarteService;
import com.procaisse.db.connection.firebase.FireBaseInstance;
import com.procaisse.db.connection.firebase.FirebaseUploadLogger;
import com.procaisse.db.connection.firebase.Params_Caisse;
import fr.protactile.procaisse.dao.entities.CarteInfo_DB;
import fr.protactile.procaisse.dao.entities.FilesChanges;
import fr.protactile.procaisse.dao.impl.CarteInfo_DB_Dao;
import fr.protactile.procaisse.dao.impl.FilesChangesDao;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class FirebaseService {
    private static FirebaseService m_instance = null;
    Firestore firedb = null;
    FirebaseApp fireApp = null;
    FireBaseInstance mFireBaseInstance = FireBaseInstance.getInstance();
    String URL_DATABASE = "prochaine-backend.appspot.com";
    MarqueNFC marqueNF;
    String siret;
    String keenio;
    AppConfig config;
    final FilerUtils m_FilerUtils = FilerUtils.getInstance();
    private CarteInfo_DB_Dao mCarteInfoDao;
    private FilesChangesDao mFilesChanesDao;
    private final String MANIFEST = "MANIFEST";
    private List<String> prefixFiles;
    private final String prefix_categories = "C_";
    private final String prefix_products = "P_";
    private final String prefix_ingredients = "I_";
    private final String prefix_supplements = "S_";
    private List<String> pathList;
    private FilerUtils mFilerUtils;
    private final String FILES = "files";
    private final String TIMESTAMP = "timestamp";
    private FirebaseUploadLogger uploadLogger;

    public static FirebaseService getInstance() throws BasicException {
        if (m_instance == null) {
            m_instance = new FirebaseService();
        }
        return m_instance;
    }

    public FirebaseService() throws BasicException {
        this.config = AppConfig.getInstance(true, this.m_FilerUtils.getFileProperties());
        this.siret = AppLocal.dlSales.getMarqueNF().getSiret();
        if (AppLocal.dlItems != null) {
            try {
                this.keenio = AppLocal.dlItems.getUserKeenIo();
                if (this.keenio == null) {
                    this.keenio = "-";
                }
            }
            catch (BasicException ex) {
                LogToFile.log("severe", null, ex);
            }
        }
        this.fireApp = AppLocal.fireApp;
        this.firedb = AppLocal.firedb;
        this.mCarteInfoDao = new CarteInfo_DB_Dao();
        this.mFilesChanesDao = new FilesChangesDao();
        this.prefixFiles = new ArrayList<String>();
        this.prefixFiles.add("C_");
        this.prefixFiles.add("P_");
        this.prefixFiles.add("I_");
        this.prefixFiles.add("S_");
        this.mFilerUtils = FilerUtils.getInstance();
        this.uploadLogger = new FirebaseUploadLogger();
    }

    public void UpdateFireBaseParams() {
        try {
            ApiFuture future = this.firedb.collection("Caisse_Parameters").document(AppLocal.FRANCHISE_ID).set(this.getLocalHashParams());
            System.out.println("+++++++++++succes added" + ((WriteResult)future.get()).getUpdateTime());
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public Params_Caisse readParams(String collection, String nameDocument) throws InterruptedException, ExecutionException {
        Params_Caisse param = null;
        DocumentReference documentReference = this.firedb.collection(collection).document(nameDocument);
        ApiFuture future = documentReference.get();
        DocumentSnapshot document = (DocumentSnapshot)future.get();
        if (document.exists()) {
            param = (Params_Caisse)document.toObject(Params_Caisse.class);
            System.out.println("Paramatrs  exist in Firebase");
        } else {
            System.out.println("Paramatrs Not exist in Firebase");
            this.addParamsToPostgre();
        }
        return param;
    }

    public void addParamsToPostgre() {
        try {
            ApiFuture apiFuture = this.firedb.collection("Caisse_Parameters").document(AppLocal.FRANCHISE_ID).set(this.getLocalHashParams());
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void deleteParams(String name_resto, String nameDocument) throws InterruptedException, ExecutionException {
        ApiFuture writeResult = this.firedb.collection(name_resto).document(nameDocument).delete();
    }

    public HashMap<String, String> getLocalHashParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("customer_loyalty", this.config.getProperty("customer.loyalty"));
        params.put("id_customer_loyalty", this.config.getProperty("customer.loyalty.id"));
        params.put("send_sms", this.config.getProperty("send.sms"));
        params.put("api_key_sms", this.config.getProperty("sms.api.key"));
        params.put("prefix", this.config.getProperty("api.sms.prefix"));
        params.put("api_key_secret", this.config.getProperty("sms.api.secret"));
        params.put("name_resto", this.config.getProperty("restaurant.name"));
        params.put("franchise_mode", this.config.getProperty("mode.franchise"));
        params.put("id_franchise", this.config.getProperty("franchise.id"));
        params.put("table_obligatoire", this.config.getProperty("mandatory.table"));
        params.put("check_orderTable", this.config.getProperty("order.table"));
        params.put("checkblocBip", this.config.getProperty("bloc.bip"));
        params.put("hideTypeOrder", this.config.getProperty("cache.typeOrder"));
        params.put("checkPlan", this.config.getProperty("deactive.plan"));
        params.put("checkJunior", this.config.getProperty("product.junior.enabled"));
        params.put("checkMega", this.config.getProperty("product.senior.enabled"));
        params.put("checkSenior", this.config.getProperty("product.mega.enabled"));
        params.put("checksize1", this.config.getProperty("product.size1.enabled"));
        params.put("checksize2", this.config.getProperty("product.size2.enabled"));
        params.put("checksize3", this.config.getProperty("product.size3.enabled"));
        params.put("checksize4", this.config.getProperty("product.size4.enabled"));
        params.put("checksize5", this.config.getProperty("product.size5.enabled"));
        params.put("checksize6", this.config.getProperty("product.size6.enabled"));
        params.put("checksize7", this.config.getProperty("product.size7.enabled"));
        params.put("textJunior", this.config.getProperty("product.size.junior"));
        params.put("textSenior", this.config.getProperty("product.size.senior"));
        params.put("textMega", this.config.getProperty("product.size.mega"));
        params.put("textSize1", this.config.getProperty("product.size1"));
        params.put("textSize2", this.config.getProperty("product.size2"));
        params.put("textSize3", this.config.getProperty("product.size3"));
        params.put("textSize4", this.config.getProperty("product.size4"));
        params.put("textSize5", this.config.getProperty("product.size5"));
        params.put("textSize6", this.config.getProperty("product.size6"));
        params.put("textSize7", this.config.getProperty("product.size7"));
        params.put("descriptionJunior", this.config.getProperty("product.size1.description"));
        params.put("descriptionSenior", this.config.getProperty("product.size2.description"));
        params.put("descriptionMega", this.config.getProperty("product.size3.description"));
        params.put("descriptionSize4", this.config.getProperty("product.size4.description"));
        params.put("descriptionSize5", this.config.getProperty("product.size5.description"));
        params.put("descriptionSize6", this.config.getProperty("product.size6.description"));
        params.put("descriptionSize7", this.config.getProperty("product.size7.description"));
        params.put("descriptionSize8", this.config.getProperty("product.size8.description"));
        params.put("descriptionSize9", this.config.getProperty("product.size9.description"));
        params.put("descriptionSize10", this.config.getProperty("product.size10.description"));
        params.put("checkFondNoir", this.config.getProperty("print.fondNoir"));
        params.put("blackBackgroundNumOrder", this.config.getProperty("black.background.num.order"));
        params.put("checkTicketCuisine", this.config.getProperty("print.ticketCuisine"));
        params.put("printTotalRecap", this.config.getProperty("total.recap"));
        params.put("shiftOption", this.config.getProperty("shift.option"));
        params.put("imageCategory", this.config.getProperty("image.category"));
        params.put("checkQtt", this.config.getProperty("deactive.quantity"));
        params.put("checkGroupeOption", this.config.getProperty("option.groupe"));
        params.put("listColor", this.config.getProperty("color.options"));
        params.put("separateOption", this.config.getProperty("separate.option"));
        params.put("ingredientExclusAtLabel1", this.config.getProperty("label.printIngredientExclus"));
        params.put("ingredientAtLabel", this.config.getProperty("label.printIngredient"));
        params.put("noteAtLabel", this.config.getProperty("label.printnote"));
        params.put("checkAutoCutter", this.config.getProperty("label.autocutter"));
        params.put("printIngredientKitchen", this.config.getProperty("print.ingredient.kitchen"));
        params.put("cash", this.config.getProperty("payment.cash"));
        params.put("cb", this.config.getProperty("payment.cb"));
        params.put("ticketResto", this.config.getProperty("payment.ticketResto"));
        params.put("debit", this.config.getProperty("payment.debit"));
        params.put("free", this.config.getProperty("payment.free"));
        params.put("cheque_vacances", this.config.getProperty("payment.cheque.vacances"));
        params.put("twint", this.config.getProperty("payment.twint"));
        params.put("cashDro", this.config.getProperty("payment.cashDro"));
        params.put("cheque", this.config.getProperty("payment.cheque"));
        params.put("cbDrawer", this.config.getProperty("cb.drawer"));
        params.put("checkPaymentRapid", this.config.getProperty("encaisse.rapide"));
        params.put("paymentSepare", this.config.getProperty("payment.separe"));
        params.put("checkRendMonnaie", this.config.getProperty("ticket.rendMonnaie"));
        params.put("checkAvoir", this.config.getProperty("print.avoir"));
        params.put("delaiText", this.config.getProperty("print.avoir.delai"));
        params.put("delayUnit", this.config.getProperty("print.avoir.unit"));
        params.put("scannQR", this.config.getProperty("scan.qr"));
        params.put("scannBarCodeBorne", this.config.getProperty("scan.barcode.order"));
        params.put("openDrawer", this.config.getProperty("open.drawer"));
        params.put("displayNameServeur", this.config.getProperty("display.nameServeur"));
        params.put("printTicketAttente", this.config.getProperty("pending.ticket"));
        params.put("sourceOrder", this.config.getProperty("source.order"));
        params.put("fondCaisse", this.config.getProperty("show.fondCaisse"));
        params.put("sizeProduct", this.config.getProperty("size.product"));
        params.put("sizeSupplement", this.config.getProperty("size.supplement"));
        params.put("displayNumberOrder", this.config.getProperty("display.numberOrder"));
        params.put("writeFondCaisse", this.config.getProperty("write.fondCaisse"));
        params.put("calculFondCaisse", this.config.getProperty("cacul.fondCaisse"));
        params.put("textPlusTrad", this.config.getProperty("text.later"));
        params.put("identifiantCaisse", this.config.getProperty("identifiant.caisse"));
        params.put("plan_table", this.config.getProperty("plan.table"));
        params.put("select_customer", this.config.getProperty("select.customer"));
        params.put("facture", this.config.getProperty("button.facture"));
        params.put("display_time", this.config.getProperty("display.time"));
        params.put("master_payment", this.config.getProperty("master.payment"));
        params.put("modeOrder", this.config.getProperty("default.modeOrder"));
        params.put("spinnerFitlter", this.config.getProperty("filter.number"));
        params.put("prefix_phone", this.config.getProperty("prefix.phone"));
        params.put("countRapelTicketHour", this.config.getProperty("rappelTicket.limited.count"));
        params.put("checkRapelTicket", this.config.getProperty("rappelTicket.limited"));
        params.put("checkStatsEmail", this.config.getProperty("email.synthese"));
        params.put("customer_name", this.config.getProperty("add.customer.name"));
        params.put("ticket_num_order", this.config.getProperty("print.num.order"));
        params.put("print_etiquette_take_away", this.config.getProperty("print.label.take.away"));
        params.put("hide_sub_categories", this.config.getProperty("hide.sub.categories"));
        params.put("numberPrintZ", this.config.getProperty("number.print.z"));
        params.put("auto_close", this.config.getProperty("auto.close"));
        params.put("time_out_inactivity", this.config.getProperty("timeout.inactivity"));
        params.put("showImageOptions", this.config.getProperty("show.image.option"));
        params.put("showImageProducts", this.config.getProperty("show.image.product"));
        params.put("number_digit_product_price", this.config.getProperty("number.digit.product.price"));
        params.put("printZGlobal", this.config.getProperty("print.ticket.z.gloabl"));
        params.put("hideNameApp", this.config.getProperty("hide.name.app"));
        params.put("addHourToNumberOrder", this.config.getProperty("add.hour.to.number.order"));
        params.put("validWithoutPrint", this.config.getProperty("valid.without.print"));
        params.put("pendingDeliveryOrders", this.config.getProperty("pending.delivery.ordersS"));
        params.put("number_print_delivery", this.config.getProperty("number.print.delivery"));
        params.put("printRecapDelivery", this.config.getProperty("print.recapitulatif.delivery"));
        params.put("hideUpdatedTickets", this.config.getProperty("hide.button.updated.tickets"));
        params.put("checkInternet", this.config.getProperty("check.internet"));
        params.put("addDeliveryDate", this.config.getProperty("add.delivery.date"));
        params.put("showGOptionInKitchen", this.config.getProperty("show.gOption.ticket.kitchen"));
        params.put("trackingDeletedLines", this.config.getProperty("tracking.deleted.lines.order"));
        params.put("kitchenTicketByProduct", this.config.getProperty("kitchen.ticket.by.product"));
        params.put("productKitchenBold", this.config.getProperty("product.kitchen.bold"));
        params.put("checkPromoCodeBorne", this.config.getProperty("promo.code.borne"));
        params.put("printProductWithExludedIngedient", this.config.getProperty("print.product.with.excluded.ingredients"));
        params.put("hideDescriptionInKitchenticket", this.config.getProperty("hide.description.product.in.ticket"));
        params.put("hideOrders", this.config.getProperty("hide.orders"));
        params.put("easleNumber", this.config.getProperty("add.easel.number"));
        params.put("call_customer", this.config.getProperty("call.customer.by.sms"));
        params.put("siret_siege", this.config.getProperty("siret.siege"));
        params.put("bipOnsite", this.config.getProperty("bip.onsite"));
        params.put("bipTakeaway", this.config.getProperty("bip.takeaway"));
        params.put("bipTakeawayPhone", this.config.getProperty("bip.takeaway.phone"));
        return params;
    }

    public void saveProperties(String collection, String nameDocument) {
        try {
            Params_Caisse param = this.readParams(collection, nameDocument);
            if (param != null) {
                this.config.setProperty("customer.loyalty", param.getCustomer_loyalty());
                this.config.setProperty("customer.loyalty.id", param.getId_customer_loyalty());
                this.config.setProperty("send.sms", param.getSend_sms());
                this.config.setProperty("sms.api.key", param.getApi_key_sms());
                this.config.setProperty("api.sms.prefix", param.getPrefix());
                this.config.setProperty("sms.api.secret", param.getApi_key_secret());
                this.config.setProperty("restaurant.name", param.getName_resto());
                this.config.setProperty("mode.franchise", param.getFranchise_mode());
                this.config.setProperty("mandatory.table", param.getTable_obligatoire());
                this.config.setProperty("order.table", param.getCheck_orderTable());
                this.config.setProperty("bloc.bip", param.getCheckblocBip());
                this.config.setProperty("cache.typeOrder", param.getHideTypeOrder());
                this.config.setProperty("deactive.plan", param.getCheckPlan());
                this.config.setProperty("product.junior.enabled", param.getCheckJunior());
                this.config.setProperty("product.senior.enabled", param.getCheckSenior());
                this.config.setProperty("product.mega.enabled", param.getCheckMega());
                this.config.setProperty("product.size1.enabled", param.getChecksize1());
                this.config.setProperty("product.size2.enabled", param.getChecksize2());
                this.config.setProperty("product.size3.enabled", param.getChecksize3());
                this.config.setProperty("product.size4.enabled", param.getChecksize4());
                this.config.setProperty("product.size5.enabled", param.getChecksize5());
                this.config.setProperty("product.size6.enabled", param.getChecksize6());
                this.config.setProperty("product.size7.enabled", param.getChecksize7());
                this.config.setProperty("product.size.junior", param.getTextJunior());
                this.config.setProperty("product.size.senior", param.getTextSenior());
                this.config.setProperty("product.size.mega", param.getTextMega());
                this.config.setProperty("product.size1", param.getTextSize1());
                this.config.setProperty("product.size2", param.getTextSize2());
                this.config.setProperty("product.size3", param.getTextSize3());
                this.config.setProperty("product.size4", param.getTextSize4());
                this.config.setProperty("product.size5", param.getTextSize5());
                this.config.setProperty("product.size6", param.getTextSize6());
                this.config.setProperty("product.size7", param.getTextSize7());
                this.config.setProperty("product.size1.description", param.getDescriptionJunior());
                this.config.setProperty("product.size2.description", param.getDescriptionSenior());
                this.config.setProperty("product.size3.description", param.getDescriptionMega());
                this.config.setProperty("product.size4.description", param.getDescriptionSize4());
                this.config.setProperty("product.size5.description", param.getDescriptionSize5());
                this.config.setProperty("product.size6.description", param.getDescriptionSize6());
                this.config.setProperty("product.size7.description", param.getDescriptionSize7());
                this.config.setProperty("product.size8.description", param.getDescriptionSize8());
                this.config.setProperty("product.size9.description", param.getDescriptionSize9());
                this.config.setProperty("product.size10.description", param.getDescriptionSize10());
                this.config.setProperty("print.fondNoir", param.getCheckFondNoir());
                this.config.setProperty("black.background.num.order", param.getBlackBackgroundNumOrder());
                this.config.setProperty("print.ticketCuisine", param.getCheckTicketCuisine());
                this.config.setProperty("total.recap", param.getPrintTotalRecap());
                this.config.setProperty("shift.option", param.getShiftOption());
                this.config.setProperty("image.category", param.getImageCategory());
                this.config.setProperty("deactive.quantity", param.getCheckQtt());
                this.config.setProperty("option.groupe", param.getCheckGroupeOption());
                this.config.setProperty("color.options", param.getListColor());
                this.config.setProperty("separate.option", param.getSeparateOption());
                this.config.setProperty("label.printIngredientExclus", param.getIngredientExclusAtLabel1());
                this.config.setProperty("label.printIngredient", param.getIngredientAtLabel());
                this.config.setProperty("label.printnote", param.getNoteAtLabel());
                this.config.setProperty("label.autocutter", param.getCheckAutoCutter());
                this.config.setProperty("print.ingredient.kitchen", param.getPrintIngredientKitchen());
                this.config.setProperty("payment.cash", param.getCash());
                this.config.setProperty("payment.cb", param.getCb());
                this.config.setProperty("payment.ticketResto", param.getTicketResto());
                this.config.setProperty("payment.free", param.getFree());
                this.config.setProperty("payment.debit", param.getDebit());
                this.config.setProperty("payment.cheque.vacances", param.getCheque_vacances());
                this.config.setProperty("payment.twint", param.getTwint());
                this.config.setProperty("payment.cashDro", param.getCashDro());
                this.config.setProperty("payment.cheque", param.getCheque());
                this.config.setProperty("cb.drawer", param.getCbDrawer());
                this.config.setProperty("encaisse.rapide", param.getCheckPaymentRapid());
                this.config.setProperty("payment.separe", param.getPaymentSepare());
                this.config.setProperty("ticket.rendMonnaie", param.getCheckRendMonnaie());
                this.config.setProperty("print.avoir", param.getCheckAvoir());
                this.config.setProperty("print.avoir.delai", param.getDelaiText());
                this.config.setProperty("print.avoir.unit", param.getDelayUnit());
                this.config.setProperty("scan.qr", param.getScannQR());
                this.config.setProperty("scan.barcode.order", param.getScannBarCodeBorne());
                this.config.setProperty("open.drawer", param.getOpenDrawer());
                this.config.setProperty("display.nameServeur", param.getDisplayNameServeur());
                this.config.setProperty("pending.ticket", param.getPrintTicketAttente());
                this.config.setProperty("source.order", param.getSourceOrder());
                this.config.setProperty("show.fondCaisse", param.getFondCaisse());
                this.config.setProperty("size.product", param.getSizeProduct());
                this.config.setProperty("size.supplement", param.getSizeSupplement());
                this.config.setProperty("display.numberOrder", param.getDisplayNumberOrder());
                this.config.setProperty("write.fondCaisse", param.getWriteFondCaisse());
                this.config.setProperty("cacul.fondCaisse", param.getCalculFondCaisse());
                this.config.setProperty("text.later", param.getTextPlusTrad());
                this.config.setProperty("identifiant.caisse", param.getIdentifiantCaisse());
                this.config.setProperty("plan.table", param.getPlan_table());
                this.config.setProperty("select.customer", param.getSelect_customer());
                this.config.setProperty("button.facture", param.getFacture());
                this.config.setProperty("display.time", param.getDisplay_time());
                this.config.setProperty("master.payment", param.getMaster_payment());
                this.config.setProperty("default.modeOrder", param.getModeOrder());
                this.config.setProperty("filter.number", param.getSpinnerFitlter());
                this.config.setProperty("prefix.phone", param.getPrefix_phone());
                this.config.setProperty("rappelTicket.limited.count", param.getCountRapelTicketHour());
                this.config.setProperty("rappelTicket.limited", param.getCheckRapelTicket());
                this.config.setProperty("email.synthese", param.getCheckStatsEmail());
                this.config.setProperty("add.customer.name", param.getCustomer_name());
                this.config.setProperty("print.num.order", param.getTicket_num_order());
                this.config.setProperty("print.label.take.away", param.getPrint_etiquette_take_away());
                this.config.setProperty("hide.sub.categories", param.getHide_sub_categories());
                this.config.setProperty("number.print.z", param.getNumberPrintZ());
                this.config.setProperty("auto.close", param.getAuto_close());
                this.config.setProperty("timeout.inactivity", param.getTime_out_inactivity());
                this.config.setProperty("show.image.option", param.getShowImageOptions());
                this.config.setProperty("show.image.product", param.getShowImageProducts());
                this.config.setProperty("number.digit.product.price", param.getNumber_digit_product_price());
                this.config.setProperty("print.ticket.z.gloabl", param.getPrintZGlobal());
                this.config.setProperty("hide.name.app", param.getHideNameApp());
                this.config.setProperty("add.hour.to.number.order", param.getAddHourToNumberOrder());
                this.config.setProperty("valid.without.print", param.getValidWithoutPrint());
                this.config.setProperty("pending.delivery.ordersS", param.getPendingDeliveryOrders());
                this.config.setProperty("number.print.delivery", param.getNumber_print_delivery());
                this.config.setProperty("print.recapitulatif.delivery", param.getPrintRecapDelivery());
                this.config.setProperty("hide.button.updated.tickets", param.getHideUpdatedTickets());
                this.config.setProperty("check.internet", param.getCheckInternet());
                this.config.setProperty("add.delivery.date", param.getAddDeliveryDate());
                this.config.setProperty("show.gOption.ticket.kitchen", param.getShowGOptionInKitchen());
                this.config.setProperty("tracking.deleted.lines.order", param.getTrackingDeletedLines());
                this.config.setProperty("kitchen.ticket.by.product", param.getKitchenTicketByProduct());
                this.config.setProperty("product.kitchen.bold", param.getProductKitchenBold());
                this.config.setProperty("promo.code.borne", param.getCheckPromoCodeBorne());
                this.config.setProperty("print.product.with.excluded.ingredients", param.getPrintProductWithExludedIngedient());
                this.config.setProperty("hide.description.product.in.ticket", param.getHideDescriptionInKitchenticket());
                this.config.setProperty("hide.orders", param.getHideOrders());
                this.config.setProperty("add.easel.number", param.getEasleNumber());
                this.config.setProperty("call.customer.by.sms", param.getCall_customer());
                System.out.println("param.getSiret_siege() : " + param.getSiret_siege());
                this.config.setProperty("siret.siege", param.getSiret_siege());
                this.config.setProperty("bip.onsite", param.getBipOnsite());
                this.config.setProperty("bip.takeaway", param.getBipTakeaway());
                this.config.setProperty("bip.takeaway.phone", param.getBipTakeawayPhone());
                this.config.save();
                this.config.initAppLocal();
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void saveCaisseProperties() {
    }

    public JSONObject getJsonBySettingType(String collection) throws InterruptedException, ExecutionException {
        Object params = new JSONObject();
        DocumentReference documentReference = this.firedb.collection(collection).document(AppLocal.FRANCHISE_ID);
        ApiFuture future = documentReference.get();
        DocumentSnapshot document = (DocumentSnapshot)future.get();
        params = document.exists() ? this.mapToJSON(document.getData()) : null;
        return params;
    }

    private JSONObject mapToJSON(Map<String, Object> map) {
        JSONObject obj = new JSONObject();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map subMap = (Map)value;
                obj.put(key, (Object)this.mapToJSON(subMap));
                continue;
            }
            if (value instanceof List) {
                obj.put(key, (Object)this.listToJSONArray((List)value));
                continue;
            }
            obj.put(key, value);
        }
        return obj;
    }

    private JSONArray listToJSONArray(List<Object> list) {
        JSONArray arr = new JSONArray();
        for (Object obj : list) {
            if (obj instanceof Map) {
                arr.put((Object)this.mapToJSON((Map)obj));
                continue;
            }
            if (obj instanceof List) {
                arr.put((Object)this.listToJSONArray((List)obj));
                continue;
            }
            arr.put(obj);
        }
        return arr;
    }

    public JSONObject getJsonPubBySiret() throws InterruptedException, ExecutionException {
        JSONObject Publications = new JSONObject();
        JSONObject PubicationJson = new JSONObject();
        JSONArray bornePublicationImages = new JSONArray();
        JSONArray bornePublicationVideos = new JSONArray();
        if (this.siret != null && !this.siret.isEmpty()) {
            CollectionReference publications = this.firedb.collection("publications_borne");
            ApiFuture query = publications.get();
            QuerySnapshot querySnapshot = (QuerySnapshot)query.get();
            List documents = querySnapshot.getDocuments();
            for (DocumentSnapshot document : documents) {
                String siret_Pub = this.getSiret(document.getId());
                if (!this.siret.equals(siret_Pub)) continue;
                PubicationJson = this.mapToJSON(document.getData());
                if (PubicationJson.get("type").equals("photo")) {
                    bornePublicationImages.put((Object)PubicationJson);
                    continue;
                }
                bornePublicationVideos.put((Object)PubicationJson);
            }
            Publications.put("bornePublicationVideos", (Object)bornePublicationVideos);
            Publications.put("bornePublicationImages", (Object)bornePublicationImages);
        }
        return Publications;
    }

    public String getSiret(String idDocument) {
        int underscoreIndex = idDocument.indexOf(95);
        String resultString = idDocument.substring(0, underscoreIndex);
        return resultString;
    }

    public String getPublicationLastUpdated() throws InterruptedException, ExecutionException {
        String last_update = null;
        DocumentReference documentReference = this.firedb.collection("publication_change").document(this.siret);
        ApiFuture future = documentReference.get();
        DocumentSnapshot document = (DocumentSnapshot)future.get();
        Object last = document.get("last_update");
        if (document.exists() && last != null) {
            last_update = document.get("last_update").toString();
        }
        return last_update;
    }

    public boolean bulkFilesDownload() {
        System.out.println("AppLocal.FRANCHISE_ID : " + AppLocal.FRANCHISE_ID);
        if (AppLocal.FRANCHISE_ID != null && !AppLocal.FRANCHISE_ID.isEmpty()) {
            try {
                return this.downloadJsonManifest();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return false;
    }

    public JSONObject DownloadCarteTest() {
        JSONObject jsonCarte = new JSONObject();
        String bucketFolder = "CartesCampagnesDeploy/" + AppLocal.FRANCHISE_ID + "/";
        try {
            String account_service = "/firebase/firestoreSuperAdmin.json";
            InputStream serviceAccount = this.getClass().getResourceAsStream(account_service);
            Storage storage = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)GoogleCredentials.fromStream((InputStream)serviceAccount))).build().getService();
            Page blobs = storage.list("prochaine-backend.appspot.com", new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)bucketFolder), Storage.BlobListOption.currentDirectory()});
            if (blobs != null) {
                for (Blob blob : blobs.iterateAll()) {
                    File carteFile = this.m_FilerUtils.getFileFullPath("cartes");
                    if (!carteFile.exists()) {
                        carteFile.mkdir();
                    }
                    String siret_fireStore = blob.getName().substring(blob.getName().lastIndexOf(47) + 1).trim();
                    if (!(this.siret + ".json").equals(siret_fireStore)) continue;
                    CarteInfo_DB last_carte = this.mCarteInfoDao.getLastCarteInfo();
                    if (last_carte == null || new Date(blob.getUpdateTime()).compareTo(last_carte.getLast_update()) > 0) {
                        String destFilePath = carteFile + "/" + siret_fireStore;
                        blob.downloadTo(Paths.get(destFilePath, new String[0]));
                        if (!new File(destFilePath).exists()) continue;
                        FileInputStream is = new FileInputStream(destFilePath);
                        String jsonTxt = IOUtils.toString((InputStream)is, (String)"UTF-8");
                        jsonCarte = new JSONObject(jsonTxt);
                        CarteInfo_DB updatedCarte = new CarteInfo_DB(new Date(blob.getUpdateTime()));
                        this.mCarteInfoDao.addCarte(updatedCarte);
                        new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "La carte est telecharg\u00e9e.", 1500, NPosition.TOP_CENTER_FULL, (int)AppVarUtils.getScreenDimension().getWidth(), 70);
                        continue;
                    }
                    new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "La carte est \u00e0 jour.", 1500, NPosition.TOP_CENTER_FULL, (int)AppVarUtils.getScreenDimension().getWidth(), 70);
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return jsonCarte;
    }

    public JSONObject getJonManifest(String collection) throws InterruptedException, ExecutionException {
        JSONObject filesManifest = new JSONObject();
        DocumentReference documentReference = this.firedb.collection(collection).document(AppLocal.FRANCHISE_ID);
        ApiFuture future = documentReference.get();
        DocumentSnapshot document = (DocumentSnapshot)future.get();
        if (document.exists()) {
            JSONObject files = this.mapToJSON(document.getData());
            filesManifest = files.getJSONObject("files");
        }
        return filesManifest;
    }

    public boolean downloadJsonManifest() throws InterruptedException, ExecutionException, ParseException, IOException {
        boolean result = false;
        try {
            System.out.println("downloadJsonManifest : ");
            FilesChanges lastFilesChangesInfo = this.mFilesChanesDao.getLastFilesChangesInfo();
            Date date_infos_update = this.getinfos_update();
            if (date_infos_update != null) {
                if (lastFilesChangesInfo != null) {
                    if (date_infos_update.after(lastFilesChangesInfo.getLast_update())) {
                        System.out.println("downloadJsonManifest 1: ");
                        JSONObject filesManifest = this.getJonManifest("MANIFEST");
                        this.ManifestDownloader(filesManifest);
                        File manifestold = this.m_FilerUtils.getFileFullPath("manifests/manifest.json");
                        File manifest_new = this.m_FilerUtils.getFileFullPath("manifests/manifest_new.json");
                        if (manifestold.exists() && manifest_new.exists()) {
                            boolean deleted;
                            Object path;
                            FileReader oldReader = new FileReader(manifestold);
                            FileReader newReader = new FileReader(manifest_new);
                            JSONObject oldManifest = new JSONObject(new JSONTokener((Reader)oldReader));
                            JSONObject newManifest = new JSONObject(new JSONTokener((Reader)newReader));
                            String keyFileJson = this.siret + ".json";
                            if (oldManifest.has(keyFileJson)) {
                                if (newManifest.has(keyFileJson)) {
                                    this.checkAndDownloadFiles(newManifest, oldManifest, keyFileJson);
                                }
                            } else {
                                JSONObject fileInfo = newManifest.getJSONObject(keyFileJson);
                                String path2 = fileInfo.getString("path");
                                this.DownloadOneFile(path2);
                            }
                            this.setImageToDownload();
                            for (Object file : oldManifest.keySet()) {
                                if (file.toString().equals(keyFileJson) || !this.pathList.contains(file.toString())) continue;
                                JSONObject fileInfo = oldManifest.getJSONObject(file.toString());
                                String fileName = this.getFileName(file.toString());
                                Object object = path = fileInfo.getString("path").equals("categories/" + fileName) ? "catagories/" + fileName : fileInfo.getString("path");
                                if (!newManifest.has(file.toString())) {
                                    File fileToDelete = this.m_FilerUtils.getFileFullPath("images/" + (String)path);
                                    if (!fileToDelete.exists()) continue;
                                    boolean deleted2 = fileToDelete.delete();
                                    this.deleteUberImages(fileToDelete);
                                    continue;
                                }
                                this.checkAndDownloadFiles(newManifest, oldManifest, file.toString());
                            }
                            for (Object file : newManifest.keySet()) {
                                if (file.toString().equals(keyFileJson) || oldManifest.has(file.toString()) || !this.pathList.contains(file.toString())) continue;
                                String fileName = this.getFileName(file.toString());
                                JSONObject fileInfo = newManifest.getJSONObject(file.toString());
                                path = fileInfo.getString("path");
                                System.out.println("path : " + (String)path);
                                this.DownloadOneFile((String)path);
                            }
                            if (oldReader != null) {
                                oldReader.close();
                            }
                            if (newReader != null) {
                                newReader.close();
                            }
                            if (deleted = manifestold.delete()) {
                                String sourceFileName = SystemUtils.SYS_USER_HOME + File.separator + "manifests/manifest_new.json";
                                String targetFileName = SystemUtils.SYS_USER_HOME + File.separator + "manifests/manifest.json";
                                Path sourcePath = Paths.get(sourceFileName, new String[0]);
                                Path targetPath = Paths.get(targetFileName, new String[0]);
                                Files.move(sourcePath, targetPath, new CopyOption[0]);
                            }
                        }
                        FilesChanges mFilesChanges = new FilesChanges(date_infos_update);
                        this.mFilesChanesDao.addFilesChanges(mFilesChanges);
                    }
                } else {
                    JSONObject filesManifest = this.getJonManifest("MANIFEST");
                    this.ManifestDownloader(filesManifest);
                    File manifestfile = this.m_FilerUtils.getFileFullPath("manifests/manifest.json");
                    if (manifestfile.exists()) {
                        String line;
                        StringBuilder content = new StringBuilder();
                        BufferedReader reader = new BufferedReader(new FileReader(manifestfile.getAbsolutePath()));
                        while ((line = reader.readLine()) != null) {
                            content.append(line);
                        }
                        reader.close();
                        JSONObject jsonObject = new JSONObject(content.toString());
                        String keyFileJson = this.siret + ".json";
                        System.out.println("keyFileJson : " + keyFileJson);
                        if (jsonObject.has(keyFileJson)) {
                            System.out.println("json siret exist");
                            JSONObject fileJson = jsonObject.getJSONObject(keyFileJson);
                            String pathJson = fileJson.getString("path");
                            this.DownloadOneFile(pathJson);
                        }
                        this.setImageToDownload();
                        System.out.println("pathList size: " + this.pathList.size());
                        System.out.println("jsonObject.keySet() size : " + jsonObject.keySet().size());
                        for (Object file : jsonObject.keySet()) {
                            JSONObject fileInfo;
                            String path;
                            if (file.toString().equals(keyFileJson) || !this.pathList.contains(file.toString()) || (path = (fileInfo = jsonObject.getJSONObject(file.toString())).getString("path")) == null || path.isEmpty() || !path.contains("/") && !path.equals(this.siret + ".json")) continue;
                            System.out.println("path : " + path);
                            this.DownloadOneFile(path);
                        }
                        FilesChanges mFilesChanges = new FilesChanges(date_infos_update);
                        this.mFilesChanesDao.addFilesChanges(mFilesChanges);
                    }
                }
                result = true;
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return result;
    }

    public void DownloadOneFile(String path) {
        int lastIndex = path.lastIndexOf(".");
        String extension = path.substring(lastIndex, path.length());
        String nameFile = path.substring(0, lastIndex);
        if (extension.equals(".json")) {
            System.out.println("nameFile : " + nameFile);
        }
        if (extension != null && extension.equals(".json") && nameFile != null && nameFile.equals(this.siret) || extension != null && !extension.equals(".json")) {
            String extractedString;
            String bucketFolder = path.equals(this.siret + ".json") ? "CartesCampagnesDeploy/" + AppLocal.FRANCHISE_ID + "/" + path : "CartesCampagnesImages/" + AppLocal.FRANCHISE_ID + "/" + path;
            int index = path.indexOf(47);
            String string = extractedString = path.equals(this.siret + ".json") ? "cartes" : path.substring(0, index);
            if (extractedString.equals("categories")) {
                extractedString = "catagories";
            }
            File directory = path.equals(this.siret + ".json") ? new File(SystemUtils.SYS_USER_HOME, extractedString) : new File(SystemUtils.SYS_USER_HOME, "images/" + extractedString);
            try {
                if (!directory.exists()) {
                    FileUtils.forceMkdir((File)directory);
                    directory.setExecutable(true, false);
                    directory.setReadable(true, false);
                    directory.setWritable(true, false);
                }
                String account_service = "/firebase/firestoreSuperAdmin.json";
                InputStream serviceAccount = this.getClass().getResourceAsStream(account_service);
                Storage storage = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)GoogleCredentials.fromStream((InputStream)serviceAccount))).build().getService();
                Blob blob = storage.get("prochaine-backend.appspot.com", bucketFolder, new Storage.BlobGetOption[0]);
                if (blob != null && blob.getSize() > 0L) {
                    String file_name = blob.getName().substring(blob.getName().lastIndexOf(47) + 1).trim();
                    String destFilePath = directory + File.separator + file_name;
                    File destFile = new File(destFilePath);
                    if (!destFile.exists()) {
                        destFile.createNewFile();
                    }
                    blob.downloadTo(Paths.get(destFilePath, new String[0]));
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public Date getinfos_update() throws InterruptedException, ExecutionException {
        System.out.println("AppLocal.FRANCHISE_ID : " + AppLocal.FRANCHISE_ID);
        Long last_update = null;
        try {
            JSONObject siretFileObject;
            JSONObject filesObject;
            DocumentReference documentReference = this.firedb.collection("MANIFEST").document(AppLocal.FRANCHISE_ID);
            ApiFuture future = documentReference.get();
            System.out.println(" step 1");
            DocumentSnapshot document = (DocumentSnapshot)future.get();
            System.out.println(" step 2");
            System.out.println("document : " + document);
            Object last = document.get("infos_update");
            System.out.println("last getinfos_update : " + last);
            Object params = new JSONObject();
            params = document.exists() ? this.mapToJSON(document.getData()) : null;
            if (!(params == null || params.isNull("files") || (filesObject = params.getJSONObject("files")).isNull(this.siret + ".json") || (siretFileObject = filesObject.getJSONObject(this.siret + ".json")) == null || siretFileObject.isNull("timestamp"))) {
                Timestamp date = (Timestamp)siretFileObject.get("timestamp");
                System.out.println("date siret : " + date.toDate());
                last_update = date.toDate().getTime();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return last_update != null ? new Date(last_update) : null;
    }

    public void ManifestDownloader(JSONObject filesManifest) {
        File manifestDir = this.m_FilerUtils.getFileFullPath("manifests");
        try {
            if (filesManifest.length() > 0) {
                File manifestold;
                if (!manifestDir.exists()) {
                    manifestDir.mkdir();
                }
                String manifestFilePath = !(manifestold = this.m_FilerUtils.getFileFullPath("manifests/manifest.json")).exists() ? manifestDir + "/manifest.json" : manifestDir + "/manifest_new.json";
                System.out.println("manifestFilePath : " + manifestFilePath);
                FileWriter fileWriter = new FileWriter(manifestFilePath);
                fileWriter.write(filesManifest.toString());
                fileWriter.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteUberImages(File file) throws IOException {
        String SIZE_32px = "_32px";
        String SIZE_64px = "_64px";
        String SIZE_128px = "_128px";
        String SIZE_256px = "_256px";
        String SIZE_512px = "_512px";
        File directory = file.getParentFile();
        if (!directory.exists() || !directory.isDirectory()) {
            return;
        }
        String baseFileName = file.getName();
        String fileExtension = this.getFileExtension(baseFileName);
        String fileNameWithoutExtension = baseFileName.substring(0, baseFileName.lastIndexOf(46));
        for (String size : new String[]{SIZE_32px, SIZE_64px, SIZE_128px, SIZE_256px, SIZE_512px}) {
            String newFileName = fileNameWithoutExtension + size + "." + fileExtension;
            File fileToDelete = new File(directory, newFileName);
            if (!fileToDelete.exists()) continue;
            if (fileToDelete.delete()) {
                System.out.println("Deleted: " + fileToDelete.getName());
                continue;
            }
            System.out.println("Failed to delete: " + fileToDelete.getName());
        }
    }

    private String getFileExtension(String fileName) {
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastDotIndex > 0) {
            return fileName.substring(lastDotIndex + 1);
        }
        return "";
    }

    private void checkAndDownloadFiles(JSONObject newManifest, JSONObject oldManifest, String fileKey) {
        if (oldManifest.has(fileKey)) {
            File fileToDownload;
            Object pathLocal;
            JSONObject oldFile = oldManifest.getJSONObject(fileKey);
            JSONObject newFile = newManifest.getJSONObject(fileKey);
            String oldTimestampString = oldFile.getString("timestamp");
            Instant oldInstant = Instant.parse(oldTimestampString);
            long oldTimestamp = oldInstant.toEpochMilli();
            String newTimestampString = newFile.getString("timestamp");
            Instant newInstant = Instant.parse(newTimestampString);
            long newTimestamp = newInstant.toEpochMilli();
            String pathCheckedFile = newFile.getString("path");
            String fileName = this.getFileName(fileKey.toString());
            Object object = pathLocal = newFile.getString("path").equals("categories/" + fileName) ? "catagories/" + fileName : newFile.getString("path");
            if (newTimestamp > oldTimestamp && pathCheckedFile != null && !pathCheckedFile.isEmpty() && (pathCheckedFile.contains("/") || pathCheckedFile.equals(this.siret + ".json"))) {
                this.DownloadOneFile(pathCheckedFile);
                File fileToDelete = this.m_FilerUtils.getFileFullPath("images/" + (String)pathLocal);
                if (fileToDelete.exists()) {
                    try {
                        this.deleteUberImages(fileToDelete);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            } else if (pathCheckedFile != null && !pathCheckedFile.equals(this.siret + ".json") && !(fileToDownload = this.m_FilerUtils.getFileFullPath("images/" + (String)pathLocal)).exists()) {
                this.DownloadOneFile(pathCheckedFile);
            }
        } else {
            JSONObject newFile = newManifest.getJSONObject(fileKey);
            String pathCheckedFile = newFile.getString("path");
            if (pathCheckedFile != null && !pathCheckedFile.isEmpty() && (pathCheckedFile.contains("/") || pathCheckedFile.equals(this.siret + ".json"))) {
                this.DownloadOneFile(pathCheckedFile);
            }
        }
    }

    private String getFileName(String fileKey) {
        for (String prefixFile : this.prefixFiles) {
            if (!fileKey.startsWith(prefixFile)) continue;
            return fileKey.substring(prefixFile.length());
        }
        return fileKey;
    }

    public boolean checkUpdate() {
        block4: {
            try {
                FilesChanges lastFilesChangesInfo = this.mFilesChanesDao.getLastFilesChangesInfo();
                Date infoUpdate = this.getinfos_update();
                System.out.println("infoUpdate : " + infoUpdate);
                if (infoUpdate == null) break block4;
                if (lastFilesChangesInfo != null) {
                    System.out.println("lastFilesChangesInfo.getLast_update() : " + lastFilesChangesInfo.getLast_update());
                    if (infoUpdate.after(lastFilesChangesInfo.getLast_update())) {
                        System.out.println(" new items");
                        return true;
                    }
                    break block4;
                }
                return true;
            }
            catch (Exception ex) {
                Logger.getLogger(FirebaseService.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setImageToDownload() {
        if (this.pathList == null) {
            this.pathList = new ArrayList<String>();
        } else {
            this.pathList.clear();
        }
        File carteFile = this.mFilerUtils.getFileFullPath("cartes/" + this.siret + ".json");
        if (carteFile.exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(carteFile);
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
                JSONTokener tokener = new JSONTokener((Reader)inputStreamReader);
                JSONObject jsonItems = new JSONObject(tokener);
                if (!jsonItems.toString().equals("{}") && jsonItems.has("orderJson")) {
                    JSONObject orderJson = jsonItems.getJSONObject("orderJson");
                    this.pathList = CarteParser.getPathList(orderJson);
                }
            }
            catch (FileNotFoundException ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (IOException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
    }

    public void saveNutriImage(String imagelink, String nutriImageName) {
        try {
            File directory = new File(new File(System.getProperty("user.home")), "images/NutriPictures");
            FileUtils.forceMkdir((File)directory);
            String url = directory.getPath();
            File dest = new File(url + "/" + nutriImageName);
            if (!dest.exists()) {
                dest.createNewFile();
            }
            FileUtils.copyURLToFile((URL)new URL(imagelink), (File)dest);
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public void uploadInfoDownloadedCarte(boolean is_full_downloaded, String operation) {
        CarteInfo_DB mcarte = this.mCarteInfoDao.getLastCarteInfo();
        Firestore db = null;
        try {
            String account_service = "/firebase/firestoreSuperAdmin.json";
            InputStream serviceAccount = this.getClass().getResourceAsStream(account_service);
            db = (Firestore)((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setCredentials((Credentials)GoogleCredentials.fromStream((InputStream)serviceAccount))).build().getService();
            HashMap<String, Object> operationData = new HashMap<String, Object>();
            UserInfo userInfo = new UserInfo(AppLocal.user != null ? AppLocal.user : AppLocal.user_maintenance);
            Date now = new Date();
            Timestamp firestoreTimestamp = Timestamp.of((Date)now);
            operationData.put("utilisateur_id", userInfo.getName());
            operationData.put("carte_id", mcarte != null && is_full_downloaded ? mcarte.getId() : null);
            operationData.put("a_telecharge", is_full_downloaded);
            operationData.put("operation", operation);
            operationData.put("machine_id", this.keenio);
            operationData.put("derniere_mise_a_jour", firestoreTimestamp);
            DocumentReference docRef = db.collection("carte_download_tracking").document(this.siret);
            ApiFuture future = docRef.set(Collections.singletonMap("operations", FieldValue.arrayUnion((Object[])new Object[]{operationData})), SetOptions.merge());
            future.get();
            this.updateStatusForceDownload(false);
            System.out.println("\u2705 Op\u00e9ration ajout\u00e9e dans Firestore : " + operationData);
            db.close();
        }
        catch (Exception ex) {
            if (db != null) {
                try {
                    db.close();
                }
                catch (Exception ex1) {
                    LogToFile.log("severe", ex1.getMessage(), ex1);
                }
            }
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void uploadInfoMachine() {
        Firestore db = null;
        try {
            String account_service = "/firebase/firestoreSuperAdmin.json";
            InputStream serviceAccount = this.getClass().getResourceAsStream(account_service);
            db = (Firestore)((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setCredentials((Credentials)GoogleCredentials.fromStream((InputStream)serviceAccount))).build().getService();
            Date now = new Date();
            Timestamp firestoreTimestamp = Timestamp.of((Date)now);
            HashMap<String, Object> operationData = new HashMap<String, Object>();
            operationData.put("synchro_params_firebase", AppLocal.SYNCHRO_PARAM_FIREBASE);
            operationData.put("download_online_json_item", AppLocal.DOWNLOAD_ONLINE_JSON_ITEMS);
            operationData.put("machine_display_type", AppLocal.MODEL_CAISSE);
            operationData.put("machine_display_type", AppLocal.MODEL_CAISSE);
            operationData.put("derniere_mise_a_jour", firestoreTimestamp);
            if (AppLocal.FRANCHISE_ID != null && !AppLocal.FRANCHISE_ID.isEmpty()) {
                operationData.put("franchiseId", AppLocal.FRANCHISE_ID);
            }
            DocumentReference docRef = db.collection("machine_infos_params").document(this.siret);
            HashMap<String, HashMap<String, Object>> updateData = new HashMap<String, HashMap<String, Object>>();
            updateData.put(this.keenio, operationData);
            ApiFuture future = docRef.set(updateData, SetOptions.merge());
            future.get();
            System.out.println("\u2705 Infos de la machine mises \u00e0 jour dans Firestore : " + operationData);
            db.close();
        }
        catch (Exception ex) {
            if (db != null) {
                try {
                    db.close();
                }
                catch (Exception ex1) {
                    LogToFile.log("severe", ex1.getMessage(), ex1);
                }
            }
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public boolean getStatusForceDownload() {
        boolean forceDownload = false;
        try {
            DocumentReference documentReference = this.firedb.collection("carte_download_tracking").document(this.siret);
            ApiFuture future = documentReference.get();
            DocumentSnapshot document = (DocumentSnapshot)future.get();
            if (document.exists()) {
                Object status = document.get("online_force_downlaod");
                System.out.println("online_force_downlaod : " + status);
                if (status instanceof Boolean) {
                    forceDownload = (Boolean)status;
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(FirebaseService.class.getName()).log(Level.SEVERE, null, ex);
        }
        return forceDownload;
    }

    public void updateStatusForceDownload(boolean newStatus) {
        try {
            DocumentReference documentReference = this.firedb.collection("carte_download_tracking").document(this.siret);
            ApiFuture future = documentReference.get();
            DocumentSnapshot document = (DocumentSnapshot)future.get();
            if (!document.contains("online_force_downlaod")) {
                HashMap<String, Boolean> initField = new HashMap<String, Boolean>();
                initField.put("online_force_downlaod", false);
                documentReference.set(initField, SetOptions.merge());
                System.out.println("Champ 'online_force_downlaod' cr\u00e9\u00e9 avec la valeur false.");
            }
            HashMap<String, Boolean> updates = new HashMap<String, Boolean>();
            updates.put("online_force_downlaod", newStatus);
            ApiFuture apiFuture = documentReference.update(updates);
        }
        catch (Exception ex) {
            Logger.getLogger(FirebaseService.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void uploadProcaisseProperties(File directory, Storage storage, String bucketName, String siret, String folderkeenio) {
        try {
            System.out.println(" D\u00e9but de l'upload des propri\u00e9t\u00e9s Procaisse...");
            if (!directory.exists()) {
                System.out.println(" R\u00e9pertoire introuvable : " + directory.getAbsolutePath());
                return;
            }
            File[] directoryFiles = directory.listFiles();
            if (directoryFiles == null) {
                System.out.println(" Le r\u00e9pertoire est vide ou inaccessible.");
                return;
            }
            for (File file : directoryFiles) {
                String fileName = file.getName();
                if (!fileName.equals("procaisse.properties")) {
                    System.out.println(" Fichier ignor\u00e9 : " + fileName);
                    continue;
                }
                String rootFolder = "procaisse-properties";
                String siretFolder = rootFolder + "/" + siret;
                String keenioFolder = siretFolder + "/" + folderkeenio;
                Page blobs = storage.list(bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)(keenioFolder + "/"))});
                ArrayList<Blob> fileList = new ArrayList<Blob>();
                blobs.iterateAll().forEach(blob -> {
                    if (!blob.isDirectory()) {
                        fileList.add((Blob)blob);
                    }
                });
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy-HH-mm-ss");
                Blob latestBlob = null;
                LocalDateTime latestDate = null;
                for (Blob blob2 : fileList) {
                    LocalDateTime blobDate = this.extractDateFromBlobName(blob2.getName(), formatter);
                    if (blobDate == null || latestDate != null && !blobDate.isAfter(latestDate)) continue;
                    latestDate = blobDate;
                    latestBlob = blob2;
                }
                LocalDateTime fileLastModified = LocalDateTime.ofInstant(Instant.ofEpochMilli(file.lastModified()), ZoneId.systemDefault());
                if (latestDate != null && latestBlob != null && !fileLastModified.isAfter(latestDate)) {
                    System.out.println("Le fichier local n'est pas plus r\u00e9cent, pas d'upload n\u00e9cessaire.");
                    return;
                }
                if (fileList.size() >= 30) {
                    fileList.sort(Comparator.comparing(blob -> {
                        LocalDateTime date = this.extractDateFromBlobName(blob.getName(), formatter);
                        return date != null ? date : LocalDateTime.MIN;
                    }));
                    Blob oldestFile = (Blob)fileList.get(0);
                    oldestFile.delete(new Blob.BlobSourceOption[0]);
                }
                String timestamp = fileLastModified.format(formatter);
                String newFileName = "procaisse-" + timestamp + ".properties";
                String fullPath = keenioFolder + "/" + newFileName;
                try (FileInputStream inputStream = new FileInputStream(file);){
                    BlobInfo blobInfo = BlobInfo.newBuilder((String)bucketName, (String)fullPath).setContentType("text/plain").build();
                    storage.create(blobInfo, (InputStream)inputStream, new Storage.BlobWriteOption[0]);
                }
                catch (IOException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Erreur g\u00e9n\u00e9rale : " + ex.getMessage());
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void uploadProcaisseProperties() {
        System.out.println("********************uploadProcaisseProperties ********");
        try {
            File dbDirectory = new File(SystemUtils.SYS_USER_HOME);
            String account_service = "/firebase/firestoreSuperAdmin.json";
            InputStream serviceAccount = this.getClass().getResourceAsStream(account_service);
            Storage storage = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)GoogleCredentials.fromStream((InputStream)serviceAccount))).build().getService();
            String bucketName = "prochaine-backend.appspot.com";
            Bucket bucket = storage.get(bucketName, new Storage.BucketGetOption[0]);
            if (bucket == null) {
                System.out.println(" Le bucket '" + bucketName + "' n'existe pas !");
                return;
            }
            if (this.siret != null) {
                this.uploadProcaisseProperties(dbDirectory, storage, bucketName, this.siret, this.keenio);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private LocalDateTime extractDateFromBlobName(String blobName, DateTimeFormatter formatter) {
        int index = blobName.lastIndexOf("procaisse-");
        if (index == -1) {
            return null;
        }
        String datePartWithExtension = blobName.substring(index + "procaisse-".length());
        String datePart = datePartWithExtension.replace(".properties", "");
        try {
            return LocalDateTime.parse(datePart, formatter);
        }
        catch (DateTimeParseException e) {
            System.out.println("Format de date incorrect dans : " + blobName);
            return null;
        }
    }

    public void uploadAllNF525Archives() {
        block15: {
            File baseArchiveDir = new File(System.getProperty("user.home") + "/procaisse-properties/archive");
            try {
                System.out.println("Initialisation des identifiants Google Cloud...");
                String account_service = "/firebase/google_cloud_service_account.json";
                InputStream serviceAccount = this.getClass().getResourceAsStream(account_service);
                Storage storage = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)ServiceAccountCredentials.fromStream((InputStream)serviceAccount))).build().getService();
                String bucketName = "procaisse-windows";
                System.out.println(" Bucket cible : " + bucketName);
                try {
                    String rootFolder = "nf525_archive/";
                    String placeholderPath = rootFolder + ".placeholder";
                    BlobId placeholderBlobId = BlobId.of((String)bucketName, (String)placeholderPath);
                    if (storage.get(placeholderBlobId) == null) {
                        System.out.println("'nf525_archive/' non trouv\u00e9, cr\u00e9ation du placeholder...");
                        BlobInfo placeholderBlobInfo = BlobInfo.newBuilder((BlobId)placeholderBlobId).setContentType("text/plain").build();
                        storage.create(placeholderBlobInfo, new byte[0], new Storage.BlobTargetOption[0]);
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                if (this.siret == null || this.keenio == null) break block15;
                System.out.println("SIRET = " + this.siret + ", KEENIO = " + this.keenio);
                List<String> existingArchives = AppLocal.dlItems.loadIdsArchiveNotSynchronized();
                System.out.println("Archives existantes r\u00e9cup\u00e9r\u00e9es : " + existingArchives.size() + " List : " + existingArchives);
                if (existingArchives == null || existingArchives.isEmpty()) break block15;
                File[] zipFiles = baseArchiveDir.listFiles(file -> file.isFile() && file.getName().endsWith(".zip"));
                if (zipFiles == null || zipFiles.length == 0) {
                    System.out.println("\ufe0f Aucun fichier ZIP trouv\u00e9 dans : " + baseArchiveDir.getAbsolutePath());
                    return;
                }
                System.out.println("Fichiers ZIP trouv\u00e9s : " + zipFiles.length);
                System.out.println("start remonte archive : " + new Date());
                for (File zipFile : zipFiles) {
                    String[] subFolders;
                    String firebasePath;
                    Object archiveId;
                    String year;
                    String zipName;
                    block16: {
                        String day;
                        zipName = zipFile.getName().replace(".zip", "");
                        year = zipName.length() >= 4 ? zipName.substring(0, 4) : null;
                        String month = zipName.length() >= 6 ? zipName.substring(4, 6) : null;
                        String string = day = zipName.length() == 8 ? zipName.substring(6, 8) : null;
                        if (year == null || month == null) continue;
                        archiveId = day != null ? zipName : year + month;
                        if (!existingArchives.contains(archiveId)) {
                            System.out.println("Archiveest D\u00e9ja remont\u00e9e ou  n'est pas enregistr\u00e9e  dans la base Local  : " + (String)archiveId + " (fichier: " + zipName + ")");
                            continue;
                        }
                        System.out.println("Nouvelle archive d\u00e9tect\u00e9e : " + (String)archiveId + " (fichier: " + zipName + ")");
                        firebasePath = "nf525_archive/" + this.keenio + "/" + year + "/" + month;
                        if (day != null) {
                            firebasePath = firebasePath + "/" + day;
                        }
                        try {
                            Page blobs = storage.list(bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)(firebasePath + "/"))});
                            if (blobs.iterateAll().iterator().hasNext()) {
                            }
                            break block16;
                        }
                        catch (Exception ex) {
                            LogToFile.log("severe", ex.getMessage(), ex);
                        }
                        continue;
                    }
                    String yearPath = "nf525_archive/" + this.keenio + "/" + year + "/";
                    for (String sub : subFolders = new String[]{"jet", "controle", "fiscal"}) {
                        String placeholderPath = yearPath + sub + "/.placeholder";
                        BlobId placeholderBlobId = BlobId.of((String)bucketName, (String)placeholderPath);
                        if (storage.get(placeholderBlobId) != null) continue;
                        BlobInfo placeholderBlobInfo = BlobInfo.newBuilder((BlobId)placeholderBlobId).setContentType("text/plain").build();
                        storage.create(placeholderBlobInfo, new byte[0], new Storage.BlobTargetOption[0]);
                    }
                    System.out.println("Chemin Firebase cible : " + firebasePath);
                    File extractTo = new File(baseArchiveDir, zipName + "_extracted");
                    if (!extractTo.exists()) {
                        extractTo.mkdirs();
                    }
                    this.unzip(zipFile, extractTo);
                    File[] extractedDirs = extractTo.listFiles(File::isDirectory);
                    if (extractedDirs != null && extractedDirs.length > 0) {
                        File firstDir = extractedDirs[0];
                        System.out.println("Dossier extrait d\u00e9tect\u00e9 : " + firstDir.getAbsolutePath());
                        this.uploadNF525Archive(firstDir, storage, bucketName, this.siret, this.keenio, firebasePath, extractTo, (String)archiveId);
                        continue;
                    }
                    System.out.println("Aucun dossier trouv\u00e9 apr\u00e8s extraction dans : " + extractTo.getAbsolutePath());
                }
                System.out.println("end remonte archive : " + new Date());
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public void uploadNF525Archive(File archiveDir, Storage storage, String bucketName, String siret, String keenio, String firebasePath, File extractTo, String archiveId) {
        try {
            if (!archiveDir.exists() || !archiveDir.isDirectory()) {
                System.out.println("Dossier introuvable : " + archiveDir.getAbsolutePath());
                return;
            }
            File[] files = archiveDir.listFiles();
            if (files == null || files.length == 0) {
                System.out.println("Aucun fichier \u00e0 uploader dans : " + archiveDir.getAbsolutePath());
                return;
            }
            for (File file : files) {
                if (!file.isFile()) continue;
                String fileName = file.getName().toLowerCase();
                String subFolder = fileName.contains("jet") ? "jet" : (fileName.contains("signature") || fileName.contains("rapport") || fileName.contains("file_all_data") ? "controle" : "fiscal");
                String fullFirebasePath = firebasePath + "/" + subFolder + "/" + file.getName();
                try (FileInputStream inputStream = new FileInputStream(file);){
                    BlobInfo blobInfo = BlobInfo.newBuilder((String)bucketName, (String)fullFirebasePath).setContentType("application/octet-stream").setStorageClass(StorageClass.COLDLINE).build();
                    storage.create(blobInfo, (InputStream)inputStream, new Storage.BlobWriteOption[0]);
                    URL uRL = storage.signUrl(blobInfo, 5L, TimeUnit.MINUTES, new Storage.SignUrlOption[]{Storage.SignUrlOption.withV4Signature(), Storage.SignUrlOption.httpMethod((HttpMethod)HttpMethod.GET)});
                }
                catch (IOException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
            System.out.println("Upload termin\u00e9 pour : " + firebasePath);
            AppLocal.dlItems.updateArchiveSynchronized(archiveId);
            if (extractTo.exists()) {
                FirebaseService.deleteDirectoryRecursively(extractTo);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void unzip(File zipFile, File destDir) throws IOException {
        byte[] buffer = new byte[1024];
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry zipEntry;
            while ((zipEntry = zis.getNextEntry()) != null) {
                File newFile = new File(destDir, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    newFile.mkdirs();
                    continue;
                }
                newFile.getParentFile().mkdirs();
                try (FileOutputStream fos = new FileOutputStream(newFile);){
                    int len;
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                }
            }
        }
    }

    public void uploadJetCsvFromZip() {
        File zipFile = new File(System.getProperty("user.home") + "/procaisse-properties/JET.zip");
        System.out.println("Fichier ZIP \u00e0 uploader : " + zipFile.getAbsolutePath());
        if (!zipFile.exists()) {
            System.out.println("Fichier ZIP introuvable : " + zipFile.getAbsolutePath());
            return;
        }
        try {
            System.out.println("Initialisation des identifiants Google Cloud...");
            String account_service = "/firebase/google_cloud_service_account.json";
            InputStream serviceAccount = this.getClass().getResourceAsStream(account_service);
            if (serviceAccount == null) {
                System.out.println("Fichier de compte de service introuvable : " + account_service);
                return;
            }
            Storage storage = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)ServiceAccountCredentials.fromStream((InputStream)serviceAccount))).build().getService();
            System.out.println(" Connexion \u00e0 Google Cloud Storage r\u00e9ussie.");
            String bucketName = "procaisse-windows";
            System.out.println("Bucket cible : " + bucketName);
            try {
                String rootFolder = "nf525_archive/";
                String placeholderPath = rootFolder + ".placeholder";
                BlobId placeholderBlobId = BlobId.of((String)bucketName, (String)placeholderPath);
                if (storage.get(placeholderBlobId) == null) {
                    System.out.println("'nf525_archive/' non trouv\u00e9, cr\u00e9ation du placeholder...");
                    BlobInfo placeholderBlobInfo = BlobInfo.newBuilder((BlobId)placeholderBlobId).setContentType("text/plain").build();
                    storage.create(placeholderBlobInfo, new byte[0], new Storage.BlobTargetOption[0]);
                    System.out.println(" Placeholder cr\u00e9\u00e9 : " + placeholderPath);
                } else {
                    System.out.println("\u2139\ufe0f 'nf525_archive/' existe d\u00e9j\u00e0.");
                }
            }
            catch (Exception e) {
                System.out.println("Erreur lors de la cr\u00e9ation du dossier racine : " + e.getMessage());
                e.printStackTrace();
            }
            if (this.keenio == null || this.keenio.isEmpty()) {
                System.out.println(" La variable 'keenio' est vide ou non initialis\u00e9e.");
                return;
            }
            String firebasePath = "nf525_archive/" + this.keenio + "/JET/JET.zip";
            System.out.println("Chemin cible pour JET.zip : " + firebasePath);
            try {
                Blob blobCheck = storage.get(bucketName, firebasePath, new Storage.BlobGetOption[0]);
                if (blobCheck != null && blobCheck.exists(new Blob.BlobSourceOption[0])) {
                    System.out.println("\ufe0f Le fichier JET.zip existe d\u00e9j\u00e0 sur Google Cloud Storage : " + firebasePath);
                    return;
                }
            }
            catch (Exception e) {
                System.out.println(" Erreur lors de la v\u00e9rification de l'existence du fichier : " + e.getMessage());
                e.printStackTrace();
            }
            BlobInfo blobInfo = BlobInfo.newBuilder((String)bucketName, (String)firebasePath).setContentType("application/zip").setStorageClass(StorageClass.COLDLINE).build();
            try (FileInputStream inputStream = new FileInputStream(zipFile);){
                storage.create(blobInfo, (InputStream)inputStream, new Storage.BlobWriteOption[0]);
                System.out.println("JET.zip upload\u00e9 avec succ\u00e8s dans : " + firebasePath);
            }
        }
        catch (Exception e) {
            System.out.println("Erreur lors de l'upload de JET.zip : " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void deleteDirectoryRecursively(File dir) {
        File[] children;
        if (dir.isDirectory() && (children = dir.listFiles()) != null) {
            for (File child : children) {
                FirebaseService.deleteDirectoryRecursively(child);
            }
        }
        dir.delete();
    }

    private void uploadFileWithStream(File localFile, StorageClient storageClient, String firebasePath) throws IOException {
        this.uploadLogger.logInfo("Starting file upload: " + localFile.getName() + " -> " + firebasePath);
        this.uploadLogger.logInfo("File size: " + localFile.length() + " bytes");
        try (FileInputStream inputStream = new FileInputStream(localFile);){
            BlobId blobId = BlobId.of((String)storageClient.bucket().getName(), (String)firebasePath);
            BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)blobId).setContentType(this.getContentType(localFile.getName())).build();
            storageClient.bucket().getStorage().create(blobInfo, (InputStream)inputStream, new Storage.BlobWriteOption[0]);
            this.uploadLogger.logSuccess("File uploaded successfully: " + localFile.getName());
        }
        catch (IOException e) {
            this.uploadLogger.logError("Failed to upload file: " + localFile.getName(), e);
            throw e;
        }
    }

    public void uploadWithDirectory(File directory, StorageClient storageClient, String folder) {
        this.uploadLogger.logStep("UPLOAD WITH DIRECTORY: " + directory.getPath());
        try {
            if (!directory.exists()) {
                this.uploadLogger.logWarning("Directory does not exist: " + directory.getPath());
                return;
            }
            if (!directory.isDirectory()) {
                this.uploadLogger.logWarning("Path is not a directory: " + directory.getPath());
                return;
            }
            this.uploadLogger.logInfo("Directory exists and is valid");
            File[] directoryFiles = directory.listFiles();
            if (directoryFiles == null) {
                this.uploadLogger.logWarning("Cannot list files in directory: " + directory.getPath());
                return;
            }
            this.uploadLogger.logInfo("Found " + directoryFiles.length + " items in directory");
            for (File file : directoryFiles) {
                if (!file.isDirectory() || file.getName().endsWith(".zip") || file.getName().endsWith(".rar") || file.getName().endsWith(".7z")) continue;
                this.uploadLogger.logInfo("Processing subdirectory: " + file.getName());
                File[] subFiles = file.listFiles();
                if (subFiles != null) {
                    this.uploadLogger.logInfo("Found " + subFiles.length + " files in subdirectory: " + file.getName());
                    for (File subFile : subFiles) {
                        if (!subFile.isFile()) continue;
                        try {
                            String blobString = "Restaurants/" + this.siret + "/" + folder + "/" + file.getName() + "/" + subFile.getName();
                            this.uploadFileWithStream(subFile, storageClient, blobString);
                        }
                        catch (IOException fileEx) {
                            this.uploadLogger.logError("Error uploading file: " + subFile.getName(), fileEx);
                            LogToFile.log("LEVEL_WARNING", "Error uploading file: " + subFile.getName(), fileEx);
                        }
                    }
                    continue;
                }
                this.uploadLogger.logWarning("Cannot list files in subdirectory: " + file.getName());
            }
            this.uploadLogger.logSuccess("Directory upload completed");
        }
        catch (Exception ex) {
            this.uploadLogger.logError("Error in uploadWithDirectory", ex);
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void uploadFile(File directory, StorageClient storageClient) {
        this.uploadLogger.logStep("UPLOAD FILES FROM DIRECTORY: " + directory.getPath());
        try {
            if (directory == null) {
                this.uploadLogger.logWarning("Directory is null");
                return;
            }
            if (!directory.exists()) {
                this.uploadLogger.logWarning("Directory does not exist: " + directory.getPath());
                return;
            }
            if (!directory.isDirectory()) {
                this.uploadLogger.logWarning("Path is not a directory: " + directory.getPath());
                return;
            }
            this.uploadLogger.logInfo("Directory is valid, listing files...");
            File[] directoryFiles = directory.listFiles();
            if (directoryFiles == null) {
                this.uploadLogger.logWarning("Cannot list files in directory");
                return;
            }
            int fileCount = 0;
            for (File file : directoryFiles) {
                if (!file.isFile()) continue;
                ++fileCount;
            }
            this.uploadLogger.logInfo("Found " + fileCount + " files to upload");
            int uploadedCount = 0;
            int failedCount = 0;
            for (File file : directoryFiles) {
                if (!file.isFile()) continue;
                try {
                    this.uploadFileWithStream(file, storageClient, "Restaurants/" + this.siret + "/" + file.getName());
                    ++uploadedCount;
                }
                catch (IOException fileEx) {
                    ++failedCount;
                    this.uploadLogger.logError("Error uploading file: " + file.getName(), fileEx);
                    LogToFile.log("LEVEL_WARNING", "Error uploading file: " + file.getName(), fileEx);
                }
            }
            this.uploadLogger.logSuccess("Upload summary - Uploaded: " + uploadedCount + ", Failed: " + failedCount);
        }
        catch (Exception ex) {
            this.uploadLogger.logError("Error in uploadFile", ex);
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void bulkFilesUpload(boolean shouldUpdateExistingFiles) {
        this.uploadLogger.logStep("BULK FILES UPLOAD");
        this.uploadLogger.logInfo("Should update existing files: " + shouldUpdateExistingFiles);
        try {
            File sourceCarteFolder = new File(System.getProperty("user.home") + "/CartesTemp");
            File sourceImagesFolder = new File(System.getProperty("user.home") + "/images");
            this.uploadLogger.logInfo("Source carte folder: " + sourceCarteFolder.getPath());
            this.uploadLogger.logInfo("Source images folder: " + sourceImagesFolder.getPath());
            this.uploadLogger.logInfo("Carte folder exists: " + sourceCarteFolder.exists());
            this.uploadLogger.logInfo("Images folder exists: " + sourceImagesFolder.exists());
            StorageClient storageClient = this.initializeStorageClient();
            this.uploadLogger.logSuccess("Storage client initialized successfully");
            if (!shouldUpdateExistingFiles) {
                this.uploadLogger.logInfo("Starting new upload (not updating existing files)");
                this.uploadFile(sourceCarteFolder, storageClient);
                this.uploadWithDirectory(sourceImagesFolder, storageClient, "images");
            } else {
                this.uploadLogger.logInfo("Starting sync mode (updating existing files)");
                this.syncRestaurantImages(sourceImagesFolder, storageClient);
            }
            this.uploadLogger.logSuccess("Bulk files upload completed");
        }
        catch (Exception ex) {
            this.uploadLogger.logError("Error in bulkFilesUpload", ex);
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public boolean createJsonCarted() {
        boolean is_created;
        this.uploadLogger.logStep("CREATE JSON CARTE");
        try {
            AppView m_App = (AppView)BasicStorage.getObject("APP_ROOT_INSTANCE");
            CarteService mCarteService = new CarteService(AppLocal.dlSales, AppLocal.dlItems, m_App);
            File destinationFolder = new File(System.getProperty("user.home") + "/CartesTemp");
            this.uploadLogger.logInfo("Destination folder: " + destinationFolder.getPath());
            if (!destinationFolder.exists()) {
                this.uploadLogger.logInfo("Creating destination folder");
                boolean created = destinationFolder.mkdir();
                this.uploadLogger.logInfo("Folder created: " + created);
            } else {
                this.uploadLogger.logInfo("Destination folder already exists");
            }
            this.uploadLogger.logInfo("Exporting carte to JSON...");
            mCarteService.exportCarteJSON(destinationFolder, false);
            this.uploadLogger.logSuccess("JSON carte created successfully");
            is_created = true;
        }
        catch (Exception ex) {
            this.uploadLogger.logError("Error creating JSON carte", ex);
            LogToFile.log("severe", ex.getMessage(), ex);
            is_created = false;
        }
        return is_created;
    }

    public void deleteCreatedCarte() {
        this.uploadLogger.logStep("DELETE CREATED CARTE FILES");
        try {
            File destinationFolder = new File(System.getProperty("user.home") + "/CartesTemp");
            if (!destinationFolder.exists()) {
                this.uploadLogger.logInfo("CartesTemp folder does not exist - nothing to delete");
                return;
            }
            this.uploadLogger.logInfo("CartesTemp folder exists, deleting files...");
            File[] files = destinationFolder.listFiles();
            if (files == null) {
                this.uploadLogger.logWarning("Cannot list files in CartesTemp folder");
                return;
            }
            this.uploadLogger.logInfo("Found " + files.length + " items to process");
            int deletedCount = 0;
            int failedCount = 0;
            for (File file : files) {
                if (!file.isFile()) continue;
                boolean deleted = file.delete();
                if (deleted) {
                    this.uploadLogger.logSuccess("Deleted file: " + file.getName());
                    ++deletedCount;
                    continue;
                }
                this.uploadLogger.logWarning("Failed to delete file: " + file.getName());
                ++failedCount;
            }
            this.uploadLogger.logSuccess("Deletion summary - Deleted: " + deletedCount + ", Failed: " + failedCount);
        }
        catch (Exception ex) {
            this.uploadLogger.logError("Error deleting carte files", ex);
            LogToFile.log("severe", "Error deleting carte: " + ex.getMessage(), ex);
        }
    }

    public void UploadCarteToFireBase() {
        this.uploadLogger = new FirebaseUploadLogger();
        this.uploadLogger.logStep("UPLOAD CARTE TO FIREBASE - START");
        try {
            this.logDebugInfo();
            if (!this.createJsonCarted()) {
                this.uploadLogger.logError("Failed to create/upload JSON carte", null);
                return;
            }
            CarteInfo_DB lastCarte = this.mCarteInfoDao.getLastCarteInfo();
            java.sql.Timestamp currentTime = new java.sql.Timestamp(System.currentTimeMillis());
            this.uploadLogger.logInfo("Current timestamp: " + currentTime);
            this.uploadLogger.logInfo("Last carte exists: " + (lastCarte != null));
            if (lastCarte == null) {
                lastCarte = new CarteInfo_DB();
                this.handleNewCarte(currentTime);
            } else {
                this.handleExistingCarte(lastCarte, currentTime);
            }
            this.deleteCreatedCarte();
            lastCarte.setLocal_last_upload(currentTime);
            this.uploadLogger.logInfo("Updating carte record with new upload timestamp");
            this.mCarteInfoDao.update(lastCarte);
            this.uploadLogger.logSuccess("Carte record updated");
            this.uploadLogger.logStep("UPLOAD CARTE TO FIREBASE - COMPLETED SUCCESSFULLY");
        }
        catch (Exception e) {
            this.uploadLogger.logError("Fatal error in UploadCarteToFireBase", e);
        }
        finally {
            this.uploadLogger.close();
        }
    }

    private void logDebugInfo() {
        this.uploadLogger.logStep("DEBUG INFORMATION");
        this.uploadLogger.logInfo("FRANCHISE_ID: " + AppLocal.FRANCHISE_ID);
        this.uploadLogger.logInfo("DOWNLOAD_ONLINE_JSON_ITEMS: " + AppLocal.DOWNLOAD_ONLINE_JSON_ITEMS);
        this.uploadLogger.logInfo("SIRET: " + this.siret);
    }

    private void handleNewCarte(java.sql.Timestamp currentTime) {
        this.uploadLogger.logStep("HANDLE NEW CARTE (First Time)");
        this.bulkFilesUpload(false);
        CarteInfo_DB newCarte = new CarteInfo_DB();
        newCarte.setFirst_menu_downloaded(true);
        newCarte.setLocal_last_upload(currentTime);
        this.uploadLogger.logInfo("Creating new carte record in database");
        this.mCarteInfoDao.addCarte(newCarte);
        this.uploadLogger.logSuccess("New carte record created");
    }

    private void handleExistingCarte(CarteInfo_DB lastCarte, java.sql.Timestamp currentTime) {
        this.uploadLogger.logStep("HANDLE EXISTING CARTE");
        this.uploadLogger.logInfo("Last upload date: " + lastCarte.getLocal_last_upload());
        this.uploadLogger.logInfo("Last update date: " + lastCarte.getLocal_last_update());
        if (this.shouldUploadFiles(lastCarte)) {
            this.uploadLogger.logInfo("Files need to be uploaded");
            boolean shouldUpdateExistingFiles = this.needsFileUpdate(lastCarte);
            this.uploadLogger.logInfo("Should update existing files: " + shouldUpdateExistingFiles);
            this.bulkFilesUpload(shouldUpdateExistingFiles);
        } else {
            this.uploadLogger.logInfo("No upload needed - files are up to date");
        }
    }

    private boolean shouldUploadFiles(CarteInfo_DB lastCarte) {
        this.uploadLogger.logStep("CHECK IF FILES SHOULD BE UPLOADED");
        if (lastCarte.getLocal_last_upload() == null) {
            this.uploadLogger.logInfo("First upload - files should be uploaded");
            return true;
        }
        Date lastUpdate = lastCarte.getLocal_last_update();
        Date lastUpload = lastCarte.getLocal_last_upload();
        this.uploadLogger.logInfo("Last update: " + lastUpdate);
        this.uploadLogger.logInfo("Last upload: " + lastUpload);
        boolean shouldUpload = lastUpdate != null && lastUpdate.after(lastUpload);
        this.uploadLogger.logInfo("Should upload: " + shouldUpload);
        return shouldUpload;
    }

    private boolean needsFileUpdate(CarteInfo_DB lastCarte) {
        this.uploadLogger.logStep("CHECK IF FILE UPDATE IS NEEDED");
        if (lastCarte.getLocal_last_upload() == null) {
            this.uploadLogger.logInfo("First upload - no update needed, will upload fresh");
            return false;
        }
        this.uploadLogger.logInfo("Checking if image folder exists in Firebase for SIRET: " + this.siret);
        boolean exists = this.imageFolderExistInDbBySiret();
        this.uploadLogger.logInfo("Image folder exists in Firebase: " + exists);
        return exists;
    }

    public boolean imageFolderExistInDbBySiret() {
        this.uploadLogger.logStep("CHECK IMAGE FOLDER IN FIREBASE");
        String folderPath = "Restaurants/" + this.siret + "/";
        String bucketName = "prochaine-backend.appspot.com";
        this.uploadLogger.logInfo("Folder path: " + folderPath);
        this.uploadLogger.logInfo("Bucket name: " + bucketName);
        boolean found = false;
        try {
            InputStream serviceAccount = this.getClass().getResourceAsStream("/firebase/firestoreSuperAdmin.json");
            if (serviceAccount == null) {
                this.uploadLogger.logError("Service account file not found", null);
                return false;
            }
            Storage storage = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)GoogleCredentials.fromStream((InputStream)serviceAccount))).build().getService();
            this.uploadLogger.logInfo("Checking Firebase storage for folder existence...");
            Page blobs = storage.list(bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)folderPath), Storage.BlobListOption.pageSize((long)1L)});
            found = blobs.iterateAll().iterator().hasNext();
            this.uploadLogger.logInfo("Folder found: " + found);
        }
        catch (Exception ex) {
            this.uploadLogger.logError("Error checking folder in Firebase", ex);
            LogToFile.log("severe", null, ex);
        }
        return found;
    }

    private StorageClient initializeStorageClient() throws IOException {
        this.uploadLogger.logStep("INITIALIZE STORAGE CLIENT");
        String accountService = "/firebase/firestoreSuperAdmin.json";
        this.uploadLogger.logInfo("Loading credentials from: " + accountService);
        InputStream serviceAccount = this.getClass().getResourceAsStream(accountService);
        if (serviceAccount == null) {
            this.uploadLogger.logError("Credentials file not found: " + accountService, null);
            throw new IOException("Fichier credentials introuvable: " + accountService);
        }
        this.uploadLogger.logInfo("Credentials loaded successfully");
        GoogleCredentials credentials = GoogleCredentials.fromStream((InputStream)serviceAccount);
        FirebaseOptions options = FirebaseOptions.builder().setCredentials(credentials).setStorageBucket("prochaine-backend.appspot.com").build();
        if (FirebaseApp.getApps().isEmpty()) {
            this.uploadLogger.logInfo("Initializing Firebase App");
            FirebaseApp.initializeApp((FirebaseOptions)options);
            this.uploadLogger.logSuccess("Firebase App initialized");
        } else {
            this.uploadLogger.logInfo("Firebase App already initialized");
        }
        this.uploadLogger.logSuccess("Storage client created successfully");
        return StorageClient.getInstance();
    }

    private void syncRestaurantImages(File sourceImagesFolder, StorageClient storageClient) {
        this.uploadLogger.logStep("SYNC RESTAURANT IMAGES - START");
        this.uploadLogger.logInfo("Sync mode: Checking and updating existing files");
        this.uploadLogger.logInfo("SIRET: " + this.siret);
        try {
            if (!sourceImagesFolder.exists() || !sourceImagesFolder.isDirectory()) {
                this.uploadLogger.logError("Source images folder does not exist: " + sourceImagesFolder.getPath(), null);
                return;
            }
            this.uploadLogger.logInfo("Source folder exists: " + sourceImagesFolder.getPath());
            File[] localResourceFolders = sourceImagesFolder.listFiles(File::isDirectory);
            if (localResourceFolders == null || localResourceFolders.length == 0) {
                this.uploadLogger.logWarning("No resource folders found in: " + sourceImagesFolder.getPath());
                return;
            }
            this.uploadLogger.logInfo("Found " + localResourceFolders.length + " local resource folders to process");
            int totalFolders = localResourceFolders.length;
            int processedFolders = 0;
            int failedFolders = 0;
            int totalFilesUpdated = 0;
            int totalFilesNew = 0;
            int totalFilesUnchanged = 0;
            int totalFilesDeleted = 0;
            String restaurantBasePath = "Restaurants/" + this.siret + "/images/";
            for (File localResourceFolder : localResourceFolders) {
                String resourceFolderName = localResourceFolder.getName();
                String firebaseResourcePath = restaurantBasePath + resourceFolderName + "/";
                this.uploadLogger.logStep("Processing Resource Folder: " + resourceFolderName);
                this.uploadLogger.logInfo("Firebase path: " + firebaseResourcePath);
                try {
                    HashMap<String, File> localFilesMap = new HashMap<String, File>();
                    this.collectAllFiles(localResourceFolder, "", localFilesMap);
                    this.uploadLogger.logInfo("Found " + localFilesMap.size() + " local files in folder: " + resourceFolderName);
                    if (localFilesMap.isEmpty()) {
                        this.uploadLogger.logInfo("No files to process in folder: " + resourceFolderName);
                        ++processedFolders;
                        continue;
                    }
                    this.uploadLogger.logInfo("Listing existing files in Firebase...");
                    HashSet<String> existingFirebaseFiles = new HashSet<String>();
                    HashMap<String, Blob> firebaseBlobsMap = new HashMap<String, Blob>();
                    Iterable firebaseBlobs = storageClient.bucket().list(new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)firebaseResourcePath)}).iterateAll();
                    for (Blob blob : firebaseBlobs) {
                        String relativePath;
                        String fullPath = blob.getName();
                        if (!fullPath.startsWith(firebaseResourcePath) || (relativePath = fullPath.substring(firebaseResourcePath.length())).isEmpty() || relativePath.endsWith("/")) continue;
                        existingFirebaseFiles.add(relativePath);
                        firebaseBlobsMap.put(relativePath, blob);
                    }
                    this.uploadLogger.logInfo("Found " + existingFirebaseFiles.size() + " existing files in Firebase");
                    int updatedFiles = 0;
                    int newFiles = 0;
                    int unchangedFiles = 0;
                    int errorFiles = 0;
                    for (Map.Entry entry : localFilesMap.entrySet()) {
                        String relativePath = (String)entry.getKey();
                        File localFile = (File)entry.getValue();
                        String firebaseFilePath = firebaseResourcePath + relativePath;
                        this.uploadLogger.logInfo("Checking file: " + relativePath);
                        if (existingFirebaseFiles.contains(relativePath)) {
                            try {
                                boolean timestampNewer;
                                Blob existingBlob = (Blob)firebaseBlobsMap.get(relativePath);
                                if (existingBlob == null) continue;
                                long localLastModified = localFile.lastModified();
                                long localSize = localFile.length();
                                long firebaseSize = existingBlob.getSize();
                                long firebaseUpdateTime = existingBlob.getUpdateTime();
                                this.uploadLogger.logInfo("  Local - Size: " + localSize + " bytes, Modified: " + new Date(localLastModified));
                                this.uploadLogger.logInfo("  Firebase - Size: " + firebaseSize + " bytes, Updated: " + new Date(firebaseUpdateTime));
                                boolean sizeChanged = localSize != firebaseSize;
                                boolean bl = timestampNewer = localLastModified > firebaseUpdateTime + 60000L;
                                if (sizeChanged || timestampNewer) {
                                    String reason = sizeChanged ? "size changed (" + firebaseSize + " -> " + localSize + ")" : "newer timestamp";
                                    this.uploadLogger.logInfo("  File needs update (" + reason + ") - uploading");
                                    try {
                                        this.uploadFileWithStream(localFile, storageClient, firebaseFilePath);
                                        this.uploadLogger.logSuccess("  Updated file: " + relativePath);
                                        ++updatedFiles;
                                    }
                                    catch (IOException uploadEx) {
                                        this.uploadLogger.logError("  Failed to update file: " + relativePath, uploadEx);
                                        ++errorFiles;
                                    }
                                    continue;
                                }
                                this.uploadLogger.logInfo("  File unchanged (same size and not newer): " + relativePath);
                                ++unchangedFiles;
                            }
                            catch (Exception fileEx) {
                                this.uploadLogger.logError("  Failed to compare file: " + relativePath, fileEx);
                                ++errorFiles;
                            }
                            continue;
                        }
                        this.uploadLogger.logInfo("  New local file - uploading: " + relativePath);
                        try {
                            this.uploadFileWithStream(localFile, storageClient, firebaseFilePath);
                            this.uploadLogger.logSuccess("  Uploaded new file: " + relativePath);
                            ++newFiles;
                        }
                        catch (IOException uploadEx) {
                            this.uploadLogger.logError("  Failed to upload new file: " + relativePath, uploadEx);
                            ++errorFiles;
                        }
                    }
                    this.uploadLogger.logInfo("Checking for orphaned files in Firebase...");
                    int deletedFiles = 0;
                    for (String firebaseRelativePath : existingFirebaseFiles) {
                        if (localFilesMap.containsKey(firebaseRelativePath)) continue;
                        this.uploadLogger.logWarning("Removing orphaned Firebase file: " + firebaseRelativePath);
                        try {
                            Blob blobToDelete = (Blob)firebaseBlobsMap.get(firebaseRelativePath);
                            if (blobToDelete != null) {
                                blobToDelete.delete(new Blob.BlobSourceOption[0]);
                                this.uploadLogger.logSuccess("  Deleted orphaned file: " + firebaseRelativePath);
                                ++deletedFiles;
                                continue;
                            }
                            this.uploadLogger.logWarning("  Blob not found in map, skipping: " + firebaseRelativePath);
                        }
                        catch (Exception deleteEx) {
                            this.uploadLogger.logError("  Failed to delete orphaned file: " + firebaseRelativePath, deleteEx);
                        }
                    }
                    this.uploadLogger.logSuccess("Sync summary for folder '" + resourceFolderName + "' - Updated: " + updatedFiles + ", New: " + newFiles + ", Unchanged: " + unchangedFiles + ", Deleted: " + deletedFiles + (String)(errorFiles > 0 ? ", Errors: " + errorFiles : ""));
                    totalFilesUpdated += updatedFiles;
                    totalFilesNew += newFiles;
                    totalFilesUnchanged += unchangedFiles;
                    totalFilesDeleted += deletedFiles;
                    ++processedFolders;
                }
                catch (Exception folderEx) {
                    this.uploadLogger.logError("Failed to process resource folder: " + resourceFolderName, folderEx);
                    ++failedFolders;
                }
            }
            this.uploadLogger.logStep("SYNC COMPLETED");
            this.uploadLogger.logSuccess("Processed folders: " + processedFolders + "/" + totalFolders);
            this.uploadLogger.logSuccess("Total files - Updated: " + totalFilesUpdated + ", New: " + totalFilesNew + ", Unchanged: " + totalFilesUnchanged + ", Deleted: " + totalFilesDeleted);
            if (failedFolders > 0) {
                this.uploadLogger.logWarning("Failed folders: " + failedFolders);
            }
        }
        catch (Exception ex) {
            this.uploadLogger.logError("FATAL ERROR in syncRestaurantImages", ex);
            LogToFile.log("severe", "Error in syncRestaurantImages", ex);
        }
    }

    private void collectAllFiles(File directory, String relativePath, Map<String, File> filesMap) {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String fileName;
            if (file.isFile()) {
                String fileRelativePath = relativePath.isEmpty() ? file.getName() : relativePath + "/" + file.getName();
                filesMap.put(fileRelativePath, file);
                continue;
            }
            if (!file.isDirectory() || (fileName = file.getName()).endsWith(".zip") || fileName.endsWith(".rar") || fileName.endsWith(".7z")) continue;
            String subDirRelativePath = relativePath.isEmpty() ? fileName : relativePath + "/" + fileName;
            this.collectAllFiles(file, subDirRelativePath, filesMap);
        }
    }

    private String getContentType(String fileName) {
        if (fileName == null) {
            return "application/octet-stream";
        }
        String extension = "";
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot > 0) {
            extension = fileName.substring(lastDot + 1).toLowerCase();
        }
        System.out.println("*********fileName : " + fileName + " **********extension : " + extension);
        switch (extension) {
            case "jpg": 
            case "jpeg": {
                return "image/jpeg";
            }
            case "png": {
                return "image/png";
            }
            case "gif": {
                return "image/gif";
            }
            case "bmp": {
                return "image/bmp";
            }
            case "webp": {
                return "image/webp";
            }
            case "svg": {
                return "image/svg+xml";
            }
            case "tiff": 
            case "tif": {
                return "image/tiff";
            }
            case "ico": {
                return "image/x-icon";
            }
            case "pdf": {
                return "application/pdf";
            }
            case "txt": {
                return "text/plain";
            }
            case "json": {
                return "application/json";
            }
            case "xml": {
                return "application/xml";
            }
            case "zip": {
                return "application/zip";
            }
            case "rar": {
                return "application/x-rar-compressed";
            }
        }
        return "application/octet-stream";
    }
}

