/*
 * Decompiled with CFR 0.152.
 */
package com.procaisse.db.connection.firebase;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.firestore.Firestore;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.cloud.FirestoreClient;
import com.openbravo.pos.util.LogToFile;
import java.io.InputStream;
import java.util.List;

public class FireBaseInstance {
    private static final String DATABASE_URL = "https://prochaine-backend.firebaseio.com";
    private static FireBaseInstance m_instance = null;
    private FirebaseApp fireApp;
    private Firestore firestoredb;

    public FireBaseInstance() {
        try {
            String account_service = "/firebase/firestoreSuperAdmin.json";
            InputStream serviceAccount = this.getClass().getResourceAsStream(account_service);
            if (serviceAccount != null) {
                FirebaseOptions options = new FirebaseOptions.Builder().setCredentials(GoogleCredentials.fromStream((InputStream)serviceAccount)).setDatabaseUrl(DATABASE_URL).setStorageBucket("prochaine-backend.appspot.com").build();
                boolean hasBeenInitialized = false;
                List firebaseApps = FirebaseApp.getApps();
                for (FirebaseApp app : firebaseApps) {
                    if (!app.getName().equals("[DEFAULT]")) continue;
                    hasBeenInitialized = true;
                    this.fireApp = app;
                    this.firestoredb = FirestoreClient.getFirestore();
                    break;
                }
                if (!hasBeenInitialized) {
                    this.fireApp = FirebaseApp.initializeApp((FirebaseOptions)options);
                    this.firestoredb = FirestoreClient.getFirestore();
                }
                System.out.println("++++++++++++++fireApp" + this.fireApp);
                System.out.println("++++++++++++++firestoredb" + this.firestoredb);
            } else {
                System.out.println("File dont exist");
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public static FireBaseInstance getInstance() {
        if (m_instance == null) {
            m_instance = new FireBaseInstance();
        }
        return m_instance;
    }

    public FirebaseApp getFireApp() {
        return this.fireApp;
    }

    public void setFireApp(FirebaseApp fireApp) {
        this.fireApp = fireApp;
    }

    public Firestore getFirestoredb() {
        return this.firestoredb;
    }

    public void setFirestoredb(Firestore firestoredb) {
        this.firestoredb = firestoredb;
    }
}

