/*
 * Decompiled with CFR 0.152.
 */
package com.procaisse.compress;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class CompressImages
implements Serializable {
    public void compressImage(String file_input, String file_output) throws FileNotFoundException, IOException {
        File input = new File(file_input);
        BufferedImage image = ImageIO.read(input);
        File output = new File(file_output);
        FileOutputStream out = new FileOutputStream(output);
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("png");
        ImageWriter writer = null;
        while (writers.hasNext()) {
            ImageWriter candidate = writers.next();
            if (candidate.getClass().getSimpleName().equals("CLibPNGImageWriter")) {
                writer = candidate;
                break;
            }
            if (writer != null) continue;
            writer = candidate;
        }
        if (writer != null) {
            ImageOutputStream ios = ImageIO.createImageOutputStream(out);
            writer.setOutput(ios);
            ImageWriteParam param = writer.getDefaultWriteParam();
            if (param.canWriteCompressed()) {
                param.setCompressionMode(2);
                param.setCompressionQuality(0.5f);
            }
            writer.write(null, new IIOImage(image, null, null), param);
            ((OutputStream)out).close();
            ios.close();
            writer.dispose();
        }
    }

    public void compressImages(File[] files, int max_size) throws IOException {
        for (File file : files) {
            if (file.length() <= (long)max_size) continue;
            this.compressImage(file.getAbsolutePath(), file.getAbsolutePath());
        }
    }
}

