/*
 * Decompiled with CFR 0.152.
 */
package com.procaisse.avomark;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.DateDeserializer;
import com.openbravo.pos.util.InfoAvomark;
import com.openbravo.pos.util.LogToFile;
import com.procaisse.avomark.AvomarkClient;
import com.procaisse.avomark.CardAvomark;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class AvomarkService {
    private static final String BASE_URL = "https://api360.avomark.fr/api";
    private static AvomarkService m_instance = null;
    private String token;
    private InfoAvomark mAvomark;

    public AvomarkService() {
        try {
            this.mAvomark = AppLocal.dlSystem.getInfoAvomark();
            if (this.mAvomark != null) {
                System.out.println("***** mAvomarkInfo" + this.mAvomark.toString());
                this.token = this.getToken(this.mAvomark.getUsername(), this.mAvomark.getPassword(), this.mAvomark.getDevice_id());
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public static AvomarkService getInstance() {
        if (m_instance == null) {
            m_instance = new AvomarkService();
        }
        return m_instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getToken(String username, String password, int terminal) throws IOException {
        OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
        String requestBodyContent = String.format("Username=%s&Password=%s&Terminal=%d", username, password, terminal);
        MediaType MEDIA_TYPE = MediaType.parse((String)"application/x-www-form-urlencoded");
        RequestBody body = RequestBody.create((MediaType)MEDIA_TYPE, (String)requestBodyContent);
        Request request = new Request.Builder().url("https://api360.avomark.fr/api/token").post(body).addHeader("Content-Type", "application/x-www-form-urlencoded").build();
        try (Response response = client.newCall(request).execute();){
            System.out.println("Response Code: " + response.code());
            if (response.code() == 200 && response.body() != null) {
                JSONParser parser = new JSONParser();
                String responseBody = response.body().string();
                JSONObject jsonResponse = (JSONObject)parser.parse(responseBody);
                if (jsonResponse.isEmpty()) return null;
                String accessToken = jsonResponse.get((Object)"access_token").toString();
                System.out.println("Token r\u00e9cup\u00e9r\u00e9 avec succ\u00e8s !" + accessToken);
                String string = accessToken;
                return string;
            }
            System.err.println("Erreur lors de la r\u00e9cup\u00e9ration du token: " + response.code());
            return null;
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String createCustomer(String token, AvomarkClient avomarkClient) {
        Gson gson = new Gson();
        String customerJson = gson.toJson((Object)avomarkClient);
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)customerJson);
        Request request = new Request.Builder().url("https://api360.avomark.fr/api/v1/customers?typeCard=").header("Authorization", "Bearer " + token).method("POST", body).build();
        OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
        try (Response response = client.newCall(request).execute();){
            if (response.code() != 200) return null;
            String string = response.body().string();
            return string;
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AvomarkClient getCustomer(String token, String customerId) {
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)"");
        Request request = new Request.Builder().url("https://api360.avomark.fr/api/v1/customers/" + customerId).header("Authorization", "Bearer " + token).method("GET", body).build();
        OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
        try (Response response = client.newCall(request).execute();){
            AvomarkClient avomarkClient2;
            if (response.code() != 200) return null;
            Gson gson = new Gson();
            AvomarkClient avomarkClient = avomarkClient2 = (AvomarkClient)gson.fromJson(response.body().string(), AvomarkClient.class);
            return avomarkClient;
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return null;
    }

    public void searchCustomer(String nameBeginBy, String email, String phone, String city, int page) {
        String url = String.format("/v1/customers/search?nameBeginBy=%s&email=%s&phone=%s&city=%s&page=%d", nameBeginBy, email, phone, city, page);
        MediaType mediaType = MediaType.parse((String)"text/plain");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)"");
        Request request = new Request.Builder().url(BASE_URL + url).method("GET", body).build();
        OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
        try (Response response = client.newCall(request).execute();){
            if (response.code() == 200) {
                System.out.println("R\u00e9ponse : " + response.body().string());
            } else {
                System.err.println("Erreur lors de la recherche : " + response.code());
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public List<AvomarkClient> getCustomers() {
        String url = "/v1/customers";
        MediaType mediaType = MediaType.parse((String)"text/plain");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)"");
        Request request = new Request.Builder().url(BASE_URL + url).method("GET", body).build();
        List customerList = null;
        OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
        try (Response response = client.newCall(request).execute();){
            if (response.code() == 200) {
                String responseBody = response.body().string();
                Gson gson = new Gson();
                Type listType = new TypeToken<List<AvomarkClient>>(){}.getType();
                customerList = (List)gson.fromJson(responseBody, listType);
            } else {
                System.err.println("Erreur lors de la r\u00e9cup\u00e9ration des clients : " + response.code());
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return customerList;
    }

    public CardAvomark getCardAvomark(String cardNumber) throws IOException {
        System.out.println("*********cardNumber " + cardNumber);
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        CardAvomark mCardAvomark = null;
        Gson gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateDeserializer()).create();
        Request request = new Request.Builder().url("https://api360.avomark.fr/api/v1/cards/" + cardNumber).get().addHeader("Authorization", "Bearer " + this.token).addHeader("Cookie", "AVK_API360_BKEND_SVR=OVHCLUSTER01").build();
        try (Response response = client.newCall(request).execute();){
            System.out.println("******** response CardAvomark " + response);
            if (response.isSuccessful() && response.body() != null) {
                String responseBody = response.body().string();
                mCardAvomark = (CardAvomark)gson.fromJson(responseBody, CardAvomark.class);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return mCardAvomark;
    }

    public AvomarkClient getClientById(long clientId) throws IOException {
        AvomarkClient mAvomarkClient = null;
        String url = "https://api360.avomark.fr/api/v1/customers/" + clientId;
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Gson gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateDeserializer()).create();
        Request request = new Request.Builder().url(url).get().addHeader("Authorization", "Bearer " + this.token).build();
        try (Response response = client.newCall(request).execute();){
            System.out.println("******** response getClientById " + response);
            if (response.isSuccessful() && response.body() != null) {
                String responseBody = response.body().string();
                mAvomarkClient = (AvomarkClient)gson.fromJson(responseBody, AvomarkClient.class);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return mAvomarkClient;
    }

    public AvomarkClient getAvomarkClient(String cardNumber) {
        AvomarkClient mAvomarkClient = null;
        try {
            CardAvomark mCardAvomark = this.getCardAvomark(cardNumber);
            long customerId = mCardAvomark.getCustomerId();
            if (customerId != 0L) {
                mAvomarkClient = this.getClientById(customerId);
                mAvomarkClient.setmCardAvomark(mCardAvomark);
                System.out.println("*******mAvomarkClient" + mAvomarkClient.toString());
            }
        }
        catch (IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return mAvomarkClient;
    }

    public Map<String, Double> getUsernameAndBalance(AvomarkClient mAvomarkClient) {
        HashMap<String, Double> result = new HashMap<String, Double>();
        if (mAvomarkClient == null) {
            result.put("Nom client", 0.0);
            return result;
        }
        Object username = (mAvomarkClient.getFirstname() != null ? mAvomarkClient.getFirstname() : "") + (String)(mAvomarkClient.getLastname() != null ? " " + mAvomarkClient.getLastname() : "");
        if (((String)username).trim().isEmpty()) {
            username = "Nom client";
        }
        double cagnote = 0.0;
        CardAvomark mCardAvomark = mAvomarkClient.getmCardAvomark();
        if (mCardAvomark != null && mCardAvomark.getBalances() != null) {
            for (CardAvomark.Balance balance : mCardAvomark.getBalances()) {
                CardAvomark.PrimaryLoyaltyBalance primaryLoyaltyBalance = balance.getPrimaryLoyaltyBalance();
                if (primaryLoyaltyBalance == null || !"Cagnotte".equals(primaryLoyaltyBalance.getLabel()) || !"money".equals(primaryLoyaltyBalance.getType())) continue;
                cagnote = primaryLoyaltyBalance.getValue();
                System.out.println("********* Cagnotte :" + cagnote);
                break;
            }
        }
        result.put((String)username, cagnote);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createAvomarkSale(String cardNumber, JSONObject sale) throws IOException {
        String API_URL = "https://api360.avomark.fr/api/v1/cards/" + cardNumber + "/sales";
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)sale.toString());
        System.out.println("***** jsonSale :" + sale.toString());
        Request request = new Request.Builder().url(API_URL).post(body).addHeader("Content-Type", "application/json").addHeader("Authorization", "Bearer " + this.token).build();
        try (Response response = client.newCall(request).execute();){
            System.out.println("******** response createAvomarkSale " + response);
            if (response.body() == null) return false;
            if (response.code() != 201) return false;
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return false;
    }

    public HashMap<String, Object> getIDClientByCode(String code) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String url = "https://api360.avomark.fr/api/v1/customers/code/" + code;
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Request request = new Request.Builder().url(url).get().addHeader("Authorization", "Bearer " + this.token).build();
        try (Response response = client.newCall(request).execute();){
            System.out.println("******** response getClientByCode " + response);
            if (response.isSuccessful() && response.body() != null) {
                String responseBody = response.body().string();
                JSONParser parser = new JSONParser();
                JSONObject jsonResponse = (JSONObject)parser.parse(responseBody);
                long id_customer = (Long)jsonResponse.get((Object)"id");
                org.json.simple.JSONArray cardsArray = (org.json.simple.JSONArray)jsonResponse.get((Object)"cards");
                String card = cardsArray != null && !cardsArray.isEmpty() ? (String)cardsArray.get(0) : null;
                result.put("id_customer", id_customer);
                result.put("card", card);
                System.out.println("********* id_customer by code: " + id_customer + ", card: " + card);
            } else {
                System.err.println("Erreur API: " + (response.body() != null ? response.body().string() : "R\u00e9ponse vide"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LogToFile.log("severe", "Erreur dans getIDClientByCode: " + ex.getMessage(), ex);
        }
        return result;
    }

    public InfoAvomark getmAvomark() {
        return this.mAvomark;
    }

    public void setmAvomark(InfoAvomark mAvomark) {
        this.mAvomark = mAvomark;
    }

    public JSONObject createSaleAvomark(TicketInfo ticket) {
        try {
            JSONObject sale = new JSONObject();
            String card = AppLocal.currentAvomarkClient.getCards().get(0);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            String formatted = sdf.format(ticket.getDatePaid());
            Date date = new Date();
            String id_ticket = ticket.getId();
            String idSansCMD = id_ticket.replaceFirst("CMD", "");
            String receipt = "T" + idSansCMD;
            System.out.println("**********receipt :" + receipt);
            System.out.println("**********id_ticket :" + id_ticket);
            System.out.println("**********date_paid :" + ticket.getDatePaid());
            System.out.println("**********date :" + formatted);
            JSONArray jsonPurchArray = new JSONArray();
            for (TicketLineInfo line : ticket.getLines()) {
                JSONObject purchaseJson = new JSONObject();
                JSONObject itemJson = new JSONObject();
                itemJson.put((Object)"code", (Object)String.valueOf(line.getProductID()));
                itemJson.put((Object)"label", (Object)line.getNameProduct());
                JSONObject itemTypeJson = new JSONObject();
                ProductInfoExt mproduct = AppLocal.dlSales.getProductInfoById(line.getProductID());
                CategoryInfo mcategory = AppLocal.dlItems.getCategoryInfo(String.valueOf(mproduct.getCategoryid()));
                itemTypeJson.put((Object)"code", (Object)String.valueOf(mcategory.getID()));
                itemTypeJson.put((Object)"label", (Object)mcategory.getName());
                JSONObject operationJson = new JSONObject();
                operationJson.put((Object)"id", (Object)1);
                double line_price = line.getPrice() * line.getMultiply() - line.getDiscount();
                System.out.println("******** line_price :" + line_price);
                purchaseJson.put((Object)"amount", (Object)line_price);
                purchaseJson.put((Object)"quantity", (Object)line.getMultiply());
                purchaseJson.put((Object)"item", (Object)itemJson);
                purchaseJson.put((Object)"itemType", (Object)itemTypeJson);
                purchaseJson.put((Object)"operation", (Object)operationJson);
                jsonPurchArray.put((Map)purchaseJson);
            }
            if (ticket.getLabel_discount() != null && ticket.getLabel_discount().startsWith("R\u00e9duction Avomark ")) {
                JSONObject jsonDiscount = this.addDiscountInfo(ticket);
                jsonPurchArray.put((Map)jsonDiscount);
            }
            sale.put((Object)"date", (Object)formatted);
            sale.put((Object)"receipt", (Object)receipt);
            sale.put((Object)"card", (Object)card);
            sale.put((Object)"purchases", (Object)jsonPurchArray);
            return sale;
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return null;
        }
    }

    public void createAndSendAvomarkSale(TicketInfo ticket) {
        System.out.println("**********createAndSendAvomarkSale");
        String card = AppLocal.currentAvomarkClient.getCards().get(0);
        JSONObject sale = this.createSaleAvomark(ticket);
        try {
            this.createAvomarkSale(card, sale);
        }
        catch (IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public JSONObject addDiscountInfo(TicketInfo ticket) {
        JSONObject discountJson = new JSONObject();
        discountJson.put((Object)"amount", (Object)ticket.getDiscount());
        discountJson.put((Object)"quantity", (Object)1.0);
        JSONObject operationJson = new JSONObject();
        operationJson.put((Object)"id", (Object)2);
        discountJson.put((Object)"operation", (Object)operationJson);
        return discountJson;
    }
}

