/*
 * Decompiled with CFR 0.152.
 */
package com.procaisse.MEV;

import com.fazecast.jSerialComm.SerialPort;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.util.LogToFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SendData {
    private static final String[] protocols = new String[]{"SSLv3"};
    private static final String[] cipher_suites = new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_RSA_WITH_RC4_128_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_RSA_WITH_RC4_128_SHA", "TLS_RSA_WITH_RC4_128_MD5", "TLS_RSA_EXPORT_WITH_DES40_CBC_SHA", "TLS_RSA_EXPORT_WITH_RC4_40_MD5", "TLS_RSA_WITH_DES_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_NULL_SHA", "TLS_ECDHE_RSA_WITH_NULL_SHA", "TLS_RSA_WITH_NULL_SHA", "TLS_RSA_WITH_NULL_MD5"};
    private int baudRate = 9600;
    private int dataBit = 8;
    private int stopBit = 1;

    public boolean sendDataToMEV(String data) throws Exception {
        if (AppLocal.MEV_TYPE_CONNECTION != null && AppLocal.MEV_TYPE_CONNECTION.equals("serial_connection")) {
            if (AppLocal.MEV_PORT != null && !AppLocal.MEV_PORT.isEmpty()) {
                return this.sendDataSerial(data);
            }
        } else if (AppLocal.ADDRESS_IP_MEV != null && !AppLocal.ADDRESS_IP_MEV.isEmpty()) {
            return this.sendDataIP(data);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendDataSerial(String data) {
        boolean success = false;
        OutputStream outputStream = null;
        SerialPort serialPort = null;
        try {
            System.out.println("+++++++++ AppLocal.MEV_PORT : " + AppLocal.MEV_PORT);
            serialPort = SerialPort.getCommPort((String)AppLocal.MEV_PORT);
            serialPort.setComPortParameters(this.baudRate, this.dataBit, this.stopBit, 0);
            serialPort.openPort();
            outputStream = serialPort.getOutputStream();
            outputStream.write(data.getBytes());
            System.out.println("+++++++++ end connection");
            success = true;
        }
        catch (IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        finally {
            if (outputStream != null && serialPort != null) {
                try {
                    outputStream.close();
                    serialPort.closePort();
                }
                catch (IOException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendDataIP(String data) throws Exception {
        System.out.println("sendDataIP **********************");
        boolean success = false;
        Socket socket = null;
        OutputStream out = null;
        InputStream in_1 = null;
        String address_ip = AppLocal.ADDRESS_IP_MEV;
        int port = 8888;
        try {
            byte[] data_length;
            SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            socket = (SSLSocket)factory.createSocket(address_ip, port);
            ((SSLSocket)socket).setEnabledProtocols(protocols);
            ((SSLSocket)socket).setEnabledCipherSuites(cipher_suites);
            socket.setSoTimeout(60000);
            ((SSLSocket)socket).startHandshake();
            out = socket.getOutputStream();
            in_1 = socket.getInputStream();
            System.out.println("++++++ data.length() : " + data.length());
            for (byte by : data_length = this.intToLittleEndian(data.length())) {
                System.out.println("b : " + by);
            }
            out.write(data_length, 0, 4);
            byte[] buffer = new byte[4];
            for (int count = 0; count < 4; count += in_1.read(buffer, count, 4 - count)) {
            }
            for (byte b : buffer) {
                System.out.println("b 1 : " + b);
            }
            int code_retour = this.bytesToInt(buffer);
            System.out.println("++++++ code_retour : " + code_retour);
            if (code_retour == 1) {
                out.write(data.getBytes("windows-1252"), 0, data.length());
                byte[] byArray = new byte[4];
                for (int count_retour_data = 0; count_retour_data < 4; count_retour_data += in_1.read(byArray, count_retour_data, 4 - count_retour_data)) {
                }
                System.out.println("+++++++ byte_retour_data  : " + byArray);
                int data_code_retour = this.bytesToInt(byArray);
                System.out.println("+++++++ data_code_retour : " + data_code_retour);
            }
            byte[] byArray = this.intToLittleEndian(-1);
            out.write(byArray, 0, 4);
            System.out.println("end connection");
            success = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (socket != null && !socket.isOutputShutdown()) {
                try {
                    socket.shutdownOutput();
                }
                catch (Exception exception) {}
            }
            if (socket != null && !socket.isInputShutdown()) {
                try {
                    socket.shutdownInput();
                }
                catch (Exception exception) {}
            }
            if (socket != null && !socket.isClosed()) {
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
        return success;
    }

    private byte[] intToLittleEndian(int numero) {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putInt(numero);
        return bb.array();
    }

    private int bytesToInt(byte[] bytes) {
        int int_value = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
        return int_value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openDrawer() {
        OutputStream outputStream = null;
        SerialPort serialPort = null;
        ArrayList<Integer> bytes = new ArrayList<Integer>();
        try {
            bytes.add(27);
            bytes.add(112);
            bytes.add(0);
            bytes.add(60);
            bytes.add(255);
            System.out.println("+++++++++ AppLocal.DRAWER_PORT : " + AppLocal.DRAWER_PORT);
            serialPort = SerialPort.getCommPort((String)AppLocal.DRAWER_PORT);
            serialPort.setComPortParameters(this.baudRate, this.dataBit, this.stopBit, 0);
            serialPort.openPort();
            outputStream = serialPort.getOutputStream();
            Iterator iterator = bytes.iterator();
            while (iterator.hasNext()) {
                int byt = (Integer)iterator.next();
                outputStream.write(byt);
            }
            System.out.println("+++++++++ end connection");
        }
        catch (IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        finally {
            if (outputStream != null && serialPort != null) {
                try {
                    outputStream.close();
                    serialPort.closePort();
                }
                catch (IOException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
    }
}

