/*
 * Decompiled with CFR 0.152.
 */
package com.procaisse.MEV;

import com.openbravo.AppConstants;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.parser.OrdersParser;
import com.openbravo.pos.payment.PaymentInfo;
import com.openbravo.pos.printer.Decreaser;
import com.openbravo.pos.printer.PrinterHelper;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.ProductTicket;
import com.openbravo.pos.ticket.TaxInfo;
import com.openbravo.pos.ticket.TaxLineInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import com.procaisse.MEV.MEVTags;
import fr.biborne.jobqueue.MevJob;
import fr.biborne.jobqueue.SendToCaisseJob;
import fr.protactile.procaisse.dao.entities.TransactionLinesDeleted;
import fr.protactile.procaisse.dao.entities.TransactionMev;
import fr.protactile.procaisse.services.TransactionMevService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;

public class MEVService {
    public final int TICKET_WIDTH = 41;
    public static final SimpleDateFormat dateFormatterFull = new SimpleDateFormat("dd/MM/yyyy - HH:mm:ss");
    private TransactionMevService mTransactionMevService = TransactionMevService.getInstance();
    private MarqueNFC marqueNF;
    private StringBuilder requestText;
    private final String LINE_OF_DASHES = new String(new char[41]).replace("\u0000", "-") + "\n";

    public MEVService() {
        try {
            this.marqueNF = AppLocal.dlSales.getMarqueNF();
        }
        catch (Exception ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
        }
    }

    public void duplicataTicket(TicketInfo ticket) {
        TransactionMev mRefTransactionMev = this.mTransactionMevService.findWithLines("RFER", ticket.getId());
        if (mRefTransactionMev != null) {
            this.buildAndSendTransactionRequest(mRefTransactionMev.getId(), ticket, "N", "O", "RFER", null);
        }
    }

    public void reprintTicket(TicketInfo ticket) {
        TransactionMev mRefTransactionMev = this.mTransactionMevService.findWithLines("RFER", ticket.getId());
        this.buildAndSendTransactionRequest(mRefTransactionMev.getId(), ticket, "O", "N", "RFER", null);
    }

    public void printAddition(TicketInfo ticket) {
        TransactionMev mRefTransactionMev = this.mTransactionMevService.findWithLines("ADDI", ticket.getId());
        TransactionMev mTransactionMev = new TransactionMev();
        mTransactionMev.setDate_transaction(new Date());
        mTransactionMev.setLocal_id(ticket.getId());
        mTransactionMev.setTotal(NumericUtils.round(ticket.getTotal()));
        mTransactionMev.setType_transaction("ADDI");
        this.mTransactionMevService.save(mTransactionMev);
        this.buildAndSendTransactionRequest(mTransactionMev.getId(), ticket, "N", "N", "ADDI", mRefTransactionMev);
    }

    public void closeReceipt(TicketInfo ticket) {
        if (AppLocal.CONTINUITY_MODE_MEV) {
            PrinterHelper printer = new PrinterHelper();
            Decreaser decreaser = new Decreaser(AppLocal.dlSales, ticket.getId(), "TICKET", null, ticket.getNumero_order());
            printer.printTicketContinuityMode(ticket, "N", "N", "RFER", decreaser, this.marqueNF);
        } else if (AppLocal.DELEGATE_PRINT_TICKET_MEV) {
            JSONObject jsonTicket = OrdersParser.ticketToJson(ticket);
            SendToCaisseJob sendToCaisseJob = new SendToCaisseJob(jsonTicket);
            AppLocal.managerJobQueue.addJob(sendToCaisseJob);
        } else {
            TransactionMev mTransactionMev = new TransactionMev();
            mTransactionMev.setDate_transaction(new Date());
            mTransactionMev.setLocal_id(ticket.getId());
            mTransactionMev.setTotal(NumericUtils.round(ticket.getTotal()));
            mTransactionMev.setType_transaction("RFER");
            this.mTransactionMevService.save(mTransactionMev);
            TransactionMev mRefTransactionMev = this.mTransactionMevService.findWithLines("ADDI", ticket.getId());
            this.buildAndSendTransactionRequest(mTransactionMev.getId(), ticket, "N", "N", "RFER", mRefTransactionMev);
        }
    }

    public String buildTransactionRequest(int transaction_id, TicketInfo ticket, String value_reprint, String value_duplicata, String value_type_trans, TransactionMev mRefTransactionMev) {
        double total_ht = ticket.getTotalHTTaxable();
        List<TaxInfo> globalTaxes = AppLocal.getGlobalTaxes();
        double tps = 0.0;
        double tvq = 0.0;
        for (TaxInfo taxInfo : globalTaxes) {
            if (taxInfo.getId().equals("tps")) {
                tps = NumericUtils.round(total_ht * MEVTags.TPS);
            }
            if (!taxInfo.getId().equals("tvq")) continue;
            tvq = NumericUtils.round(total_ht * MEVTags.TVQ);
        }
        this.requestText = new StringBuilder();
        this.requestText.append("<reqMEV>");
        this.requestText.append("<trans ");
        this.requestText.append("noVersionTrans =");
        this.requestText.append("\"v02.00\" ");
        this.requestText.append("etatDoc =");
        this.requestText.append("\"I\" ");
        this.requestText.append("modeTrans =");
        this.requestText.append("\"O\" ");
        this.requestText.append("duplicata =");
        this.requestText.append("\"").append(value_duplicata).append("\"");
        this.requestText.append(">");
        this.requestText.append("<doc>");
        this.requestText.append("<texte>");
        this.requestText.append("<![CDATA[");
        this.requestText.append("\n");
        this.appendHeader(this.marqueNF);
        this.requestText.append("\n");
        if (value_reprint.equals("O")) {
            this.centerWithSpaces("***R\u00e9impression***");
        }
        if (value_duplicata.equals("O")) {
            this.centerWithSpaces("***DUPLICATA***");
        }
        if (value_type_trans.equals("ADDI")) {
            this.centerWithSpaces("***Vente mise en attente***");
        }
        if (ticket.isPaid() && ticket.getTotalOrder() < 0.0) {
            this.centerWithSpaces("***Remboursement***");
        }
        this.centerWithSpaces("Commande N" + ticket.getNumberOrderToPrint());
        this.requestText.append("\n");
        if (ticket.getNumTable() != 0) {
            this.requestText.append("Table N ").append(ticket.getNumTable()).append("\n");
        }
        if (ticket.getCustomer() == null && ticket.getName_customer() != null && !ticket.getName_customer().isEmpty()) {
            this.requestText.append("Client : ").append(ticket.getName_customer()).append("\n");
        }
        if (ticket.getCustomer() != null && ticket.getCustomer().getName() != null && !ticket.getCustomer().getName().isEmpty()) {
            this.requestText.append("Client : ").append(ticket.getCustomer().getName()).append("\n");
        }
        if (ticket.getCustomer() != null && ticket.getCustomer().getPhone() != null && !ticket.getCustomer().getPhone().isEmpty()) {
            this.requestText.append("T\u00e9l: ").append(ticket.getCustomer().printPhone()).append("\n");
        }
        this.requestText.append(dateFormatterFull.format(ticket.getDate())).append("\n");
        this.requestText.append("\n");
        this.addLineOfDashes();
        this.sortLinesOrder(ticket);
        for (TicketLineInfo ticketLineInfo : ticket.getLines()) {
            if (ticketLineInfo.isNext()) continue;
            this.appendProduct(ticketLineInfo, ticket.isPaid());
        }
        if (mRefTransactionMev != null) {
            for (TransactionLinesDeleted transactionLinesDeleted : mRefTransactionMev.getLines()) {
                this.appendLineDeleted(transactionLinesDeleted);
            }
        }
        this.requestText.append("\n");
        this.addLineOfDashes();
        this.alignLeftRight("SOUS-TOTAL", Formats.CURRENCY.formatValue(ticket.getTotalHTBeforeDiscount()));
        this.alignLeftRight("TPS", Formats.CURRENCY.formatValue(tps));
        this.alignLeftRight("TVQ", Formats.CURRENCY.formatValue(tvq));
        this.alignLeftRight("TOTAL", Formats.CURRENCY.formatValue(ticket.getTotal()));
        if (ticket.getDiscount() > 0.0) {
            if (ticket.getTypeDiscount().contains("ourcen")) {
                this.alignLeftRight("Reduction ", TaxLineInfo.printThisDoubleAsAmount(-Math.abs(ticket.getDiscount() * ticket.getRealTotal() / 100.0)));
            } else {
                this.alignLeftRight("Reduction ", TaxLineInfo.printThisDoubleAsAmount(-Math.abs(ticket.getDiscount())));
            }
            this.alignLeftRight("Sous total. ", Formats.CURRENCY.formatValue(ticket.getTotalHT()));
        }
        this.addLineOfDashes();
        double renduMonnaie = 0.0;
        System.out.println("+++++++++ ticket.isPaid() : " + ticket.isPaid());
        if (ticket.isPaid()) {
            boolean isNegative = false;
            if (ticket.getTotalOrder() < 0.0) {
                isNegative = true;
            }
            for (PaymentInfo payment : ticket.getPayments()) {
                if (!isNegative) {
                    this.alignLeftRight(this.getOfficialPayement(payment.getName()), payment.printTotal());
                }
                renduMonnaie += payment.getTendered() - payment.getTotal();
            }
            if (isNegative) {
                for (PaymentInfo payment : ticket.getPayments()) {
                    this.alignLeftRight(this.getOfficialPayement(payment.getName()), payment.printTotal());
                }
            }
            if (AppLocal.ISRENDMONNAIE.booleanValue() && renduMonnaie > 0.0 && ticket.getTotalOrder() > 0.0) {
                this.centerWithSpaces("Rendu monnaie: " + Formats.CURRENCY.formatValue(renduMonnaie));
                for (PaymentInfo payment : ticket.getPayments()) {
                    if (!(renduMonnaie > 0.0) || !(payment.getTendered() - payment.getTotal() > 0.0)) continue;
                    this.alignLeftRight("Rendu " + this.getOfficialPayement(payment.getName()), Formats.CURRENCY.formatValue(payment.getTendered() - payment.getTotal()));
                }
            }
        }
        this.requestText.append("TPS : ").append(AppLocal.MEV_TPS).append("\n");
        this.requestText.append("TVQ : ").append(AppLocal.MEV_TVQ).append("\n");
        this.addLineOfDashes();
        this.requestText.append("]]>");
        this.requestText.append("</texte>");
        this.requestText.append("<graphique>");
        this.requestText.append("<![CDATA[]]>");
        this.requestText.append("</graphique>");
        this.requestText.append("</doc>");
        this.requestText.append("<alignement>");
        this.requestText.append("<![CDATA[");
        this.requestText.append("\n");
        this.requestText.append("\n");
        this.requestText.append("\n");
        this.requestText.append("\n");
        this.requestText.append("\n");
        this.requestText.append("\n");
        this.requestText.append("\n");
        this.requestText.append("\n");
        this.requestText.append("\n");
        this.requestText.append("]]>");
        this.requestText.append("</alignement>");
        this.requestText.append("<donneesTrans ");
        this.requestText.append("typeTrans =");
        this.requestText.append("\"").append(value_type_trans).append("\" ");
        this.requestText.append("serveurTrans =");
        this.requestText.append("\"").append(ticket.getUser().getId()).append("\" ");
        this.requestText.append("tableTrans =");
        this.requestText.append("\"").append("").append("\" ");
        this.requestText.append("paiementTrans =");
        this.requestText.append("\"").append(this.getMevPayement(ticket)).append("\" ");
        this.requestText.append("reimpression =");
        this.requestText.append("\"").append(value_reprint).append("\" ");
        this.requestText.append("autreCompte =");
        this.requestText.append("\"S\" ");
        this.requestText.append("comptoir =");
        this.requestText.append("\"O\" ");
        this.requestText.append("numeroTrans =");
        this.requestText.append("\"").append(transaction_id).append("\" ");
        this.requestText.append("dateTrans =");
        Date dateTicket = ticket.getDatePaid() != null ? ticket.getDatePaid() : ticket.getDate();
        this.requestText.append("\"").append(DateUtils.SDF_DATE_SIGNATURE.format(dateTicket)).append("\" ");
        this.requestText.append("mtTransAvTaxes =");
        this.requestText.append("\"").append(this.format(ticket.getTotalHT())).append("\" ");
        this.requestText.append("TPSTrans =");
        this.requestText.append("\"").append(this.format(tps)).append("\" ");
        this.requestText.append("TVQTrans =");
        this.requestText.append("\"").append(this.format(tvq)).append("\" ");
        this.requestText.append("mtTransApTaxes =");
        this.requestText.append("\"").append(this.format(ticket.getTotal())).append("\" ");
        this.requestText.append("/>");
        if (mRefTransactionMev != null) {
            this.requestText.append("<ref ");
            this.requestText.append("numeroRef =");
            this.requestText.append("\"").append(mRefTransactionMev.getId()).append("\" ");
            this.requestText.append("dateRef =");
            this.requestText.append("\"").append(DateUtils.SDF_DATE_SIGNATURE.format(mRefTransactionMev.getDate_transaction())).append("\" ");
            this.requestText.append("mtRefAvTaxes =");
            this.requestText.append("\"").append(this.format(mRefTransactionMev.getTotal())).append("\" ");
            this.requestText.append("/>");
        }
        this.requestText.append("</trans>");
        this.requestText.append("</reqMEV>");
        System.out.println("++++++ requestText ************************ : " + this.requestText.toString());
        return this.requestText.toString();
    }

    private String format(double number) {
        String str = String.format("%09.2f", Math.abs(number));
        String value = str.replace(",", ".");
        return number >= 0.0 ? "+" + value : "-" + value;
    }

    private void alignLeftRight(String message1, String message2) {
        int numSpace = 41 - message1.length() - message2.length();
        System.out.println("+++++++++ TICKET_WIDTH : 41");
        if (numSpace > 0) {
            this.requestText.append(String.format("%s%" + numSpace + "s%s\n", message1, "", message2));
        } else {
            this.requestText.append(String.format("%s%s\n", message1, message2));
        }
    }

    public void centerWithSpaces(String message) {
        int numSpace1 = (41 - message.length()) / 2;
        if (numSpace1 > 0) {
            this.requestText.append(String.format("%" + numSpace1 + "s%s%" + numSpace1 + "s\n", "", message, ""));
        } else {
            this.requestText.append(message + "\n");
        }
    }

    private void sortLinesOrder(TicketInfo order) {
        if (order.getLinesCount() > 1) {
            ArrayList<TicketLineInfo> lines = new ArrayList<TicketLineInfo>();
            ArrayList<TicketLineInfo> lines_fees = new ArrayList<TicketLineInfo>();
            for (TicketLineInfo line : order.getLines()) {
                if (line.getProductName() == null || !line.getProductName().equalsIgnoreCase("Frais de livraison") && !line.getProductName().equalsIgnoreCase("Frais de gestion")) {
                    lines.add(line);
                    continue;
                }
                lines_fees.add(line);
            }
            order.setLines(lines);
            order.getLines().addAll(lines_fees);
        }
    }

    private void appendProduct(TicketLineInfo line, boolean isPaid) {
        int sizeDesignation = 20;
        String unit = line.printMultiply();
        StringBuilder name_product = new StringBuilder();
        name_product.append(line.printPanier());
        String itemName = this.getName_product(name_product.toString(), unit, sizeDesignation);
        String price_item = Formats.CURRENCY.formatValue(line.getPriceProduct() * line.getMultiply());
        this.alignLeftRight(itemName.toUpperCase(), price_item);
        for (OptionItemOrder supplement : line.getListSupplements()) {
            if (supplement.getIdProduct() != -1 && supplement.getIdProduct() != 0 || supplement.getPrice() == 0.0 && !supplement.isDisplay_free()) continue;
            this.appendSupplement(supplement, line.getMultiply() >= 0.0, line);
        }
        for (ProductTicket product : line.getListProducts()) {
            this.appendItem(product, line);
            for (OptionItemOrder supplementItem : line.getListSupplements()) {
                if (supplementItem.getIdProduct() != product.getIdProduct() || supplementItem.getIdCarte() != product.getIdCarte() || supplementItem.getIndex_carte() != product.getIndex_carte() || supplementItem.getPrice() == 0.0 && !supplementItem.isDisplay_free()) continue;
                this.appendSupplement(supplementItem, line.getMultiply() >= 0.0, line);
            }
        }
        if (line.getValueDiscount() > 0.0) {
            String labelDiscount = line.printLabelDiscount();
            this.alignLeftRight(labelDiscount, "-" + Formats.CURRENCY.formatValue(Math.abs(line.getDiscount())));
            this.requestText.append("\n");
        }
    }

    private void appendSupplement(OptionItemOrder line, boolean isPositive, TicketLineInfo ticketLine) {
        String itemName;
        Object numberOptions;
        String nameSupplement;
        int sizeDesignation = 20;
        System.out.println("sizeDesignation : " + sizeDesignation);
        int numberOption = line.getNumberOption() - line.getNumber_free();
        if (line.getNumberOption() == line.getNumber_free()) {
            numberOption = line.getNumberOption();
        }
        if ((nameSupplement = " " + (String)(numberOptions = line.isDisplay_free() && line.getPrice() == 0.0 ? "" : (int)((double)numberOption * ticketLine.getMultiply()) + " ") + line.getNameSupplement()).length() > sizeDesignation) {
            int nbrLignofProduct = nameSupplement.length() / sizeDesignation;
            for (int i = 0; i < nbrLignofProduct; ++i) {
                String ligne = nameSupplement.substring(sizeDesignation * i, sizeDesignation * (i + 1));
                itemName = this.formatMax(ligne);
                this.requestText.append(itemName);
                this.requestText.append("\n");
            }
            itemName = nameSupplement.substring(sizeDesignation * nbrLignofProduct);
        } else {
            itemName = this.formatMax(nameSupplement);
        }
        if (line.getPrice() != 0.0) {
            String price_supplement = Formats.CURRENCY.formatValue(line.getPrice() * ticketLine.getMultiply());
            this.alignLeftRight(itemName, price_supplement);
        } else {
            this.requestText.append(itemName);
            this.requestText.append("\n");
        }
    }

    private void appendItem(ProductTicket item, TicketLineInfo line) {
        int sizeDesignation = 18;
        String numberItems = String.valueOf((int)((double)item.getNumberProduct() * line.getMultiply()));
        String itemName = this.getName_Item(item.getNameProduct(), numberItems, sizeDesignation);
        if (item.getPriceProduct() != 0.0) {
            String price_item = Formats.CURRENCY.formatValue(item.getPriceProduct() * (double)item.getNumberProduct() * line.getMultiply());
            this.alignLeftRight(itemName.toUpperCase(), price_item);
        } else {
            this.requestText.append(itemName.toUpperCase());
            this.requestText.append("\n");
        }
    }

    private String getName_Item(String name_item, String numberItems, int sizeDesignation) {
        Object itemName;
        if (name_item.length() > sizeDesignation) {
            List<String> chaines = this.getLines_separate(name_item, sizeDesignation, 2);
            for (int i = 0; i < chaines.size() - 1; ++i) {
                String ligne = chaines.get(i);
                itemName = i == 0 ? this.formatMax(StringUtils.rightPad((String)numberItems, (int)4) + "--" + ligne) : this.formatMax(StringUtils.rightPad((String)"", (int)6) + ligne);
                this.requestText.append((String)itemName);
                this.requestText.append("\n");
            }
            String ligne = chaines.get(chaines.size() - 1);
            itemName = StringUtils.rightPad((String)"", (int)6) + ligne;
        } else {
            itemName = this.formatMax(StringUtils.rightPad((String)numberItems, (int)4) + "--" + name_item);
        }
        return itemName;
    }

    private String getName_product(String name_product, String unit, int sizeDesignation) {
        String itemName;
        if (name_product.length() > sizeDesignation) {
            String ligne;
            List<String> chaines = this.getLines_separate(name_product, sizeDesignation, 0);
            for (int j = 0; j < chaines.size() - 1; ++j) {
                String ligne2 = chaines.get(j);
                itemName = this.formatMax(ligne2);
                this.requestText.append(itemName.toUpperCase());
                this.requestText.append("\n");
            }
            itemName = ligne = chaines.get(chaines.size() - 1);
        } else {
            itemName = this.formatMax(name_product);
        }
        return itemName;
    }

    public String formatMax(String message) {
        return message.length() > 41 ? message.substring(0, 41) : message;
    }

    private List<String> getLines_separate(String name_product, int sizeDesignation, int prefix) {
        String[] tab_chaines = name_product.split(" ");
        ArrayList<String> chaines = new ArrayList<String>();
        Object chaine_tmp = "";
        for (String chaine : tab_chaines) {
            if (chaine.length() + ((String)chaine_tmp).length() + 1 + prefix <= sizeDesignation) {
                chaine_tmp = (String)chaine_tmp + chaine + " ";
                continue;
            }
            String string_to_add = chaine_tmp;
            string_to_add = string_to_add.substring(0, string_to_add.length() - 1);
            chaines.add(string_to_add);
            chaine_tmp = chaine + " ";
        }
        String string_to_add = chaine_tmp;
        string_to_add = string_to_add.substring(0, string_to_add.length() - 1);
        chaines.add(string_to_add);
        return chaines;
    }

    public String getOfficialPayement(String payment) {
        switch (payment.toUpperCase()) {
            case "CB": {
                return AppConstants.PAYMENT_MODE.CB.getName().toUpperCase();
            }
            case "TICKET RESTO": {
                return AppConstants.PAYMENT_MODE.TICKET_RESTO.getName().toUpperCase();
            }
            case "ESPECE": {
                return payment.toUpperCase();
            }
            case "AVOIR": {
                return AppConstants.PAYMENT_MODE.FREE.getName().toUpperCase();
            }
            case "CHEQUE": {
                return payment.toUpperCase();
            }
        }
        return payment.toUpperCase();
    }

    public String getMevPayement(TicketInfo ticket) {
        if (ticket != null && ticket.getPayments() != null && !ticket.getPayments().isEmpty()) {
            if (ticket.getPayments().size() > 1) {
                return "MIX";
            }
            if (ticket.getPayments().get(0) != null && ticket.getPayments().get(0).getName() != null) {
                switch (ticket.getPayments().get(0).getName().toUpperCase()) {
                    case "CARTE CREDIT": {
                        return "CRE";
                    }
                    case "ESPECE": {
                        return "ARG";
                    }
                    case "CARTE DEBIT": {
                        return "DEB";
                    }
                }
                return "AUT";
            }
        }
        return "SOB";
    }

    private void appendLineDeleted(TransactionLinesDeleted line) {
        int sizeDesignation = 20;
        String unit = this.printQuantity(line.getQuantity());
        String name_product = "Annule " + line.getProduct_name();
        String itemName = this.getName_product(name_product, unit, sizeDesignation);
        String price_item = "-" + Formats.CURRENCY.formatValue(line.getPrice() * line.getQuantity());
        this.alignLeftRight(itemName.toUpperCase(), price_item);
    }

    public String printQuantity(double quantity) {
        if (quantity == (double)Math.round(quantity)) {
            return Formats.INT.formatValue(quantity);
        }
        return Formats.DOUBLE.formatValue(quantity);
    }

    public void buildAndSendTransactionRequest(int transaction_id, TicketInfo ticket, String value_reprint, String value_duplicata, String value_type_trans, TransactionMev mRefTransactionMev) {
        String data = this.buildTransactionRequest(transaction_id, ticket, value_reprint, value_duplicata, value_type_trans, mRefTransactionMev);
        try {
            MevJob mevJob = new MevJob(data);
            AppLocal.managerJobQueue.addJob(mevJob);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void appendHeader(MarqueNFC marqueNF) {
        System.out.println("+++++++++ marqueNF : " + marqueNF);
        if (marqueNF != null) {
            if (marqueNF.getCompany() != null && !marqueNF.getCompany().isEmpty()) {
                this.centerWithSpaces(marqueNF.getCompany());
            }
            if (marqueNF.getZipCode() != null && !marqueNF.getZipCode().isEmpty() && marqueNF.getAdresse1() != null && !marqueNF.getAdresse1().isEmpty()) {
                this.centerWithSpaces(marqueNF.getZipCode() + " " + marqueNF.getAdresse1());
            }
            if (marqueNF.getCity() != null && !marqueNF.getCity().isEmpty()) {
                this.centerWithSpaces(marqueNF.getCity());
            }
        }
    }

    private void addLineOfDashes() {
        this.requestText.append(this.LINE_OF_DASHES);
    }

    public String buildOpenDrawerRequest() {
        this.requestText = new StringBuilder();
        this.requestText.append("<reqMEV>");
        this.requestText.append("<demandeIR ");
        this.requestText.append("noVersionIR =");
        this.requestText.append("\"v01.00\"");
        this.requestText.append(">");
        this.requestText.append("<![CDATA[");
        this.requestText.append("<0x1b>@<0x1b>p0");
        this.requestText.append("]]>");
        this.requestText.append("</demandeIR>");
        this.requestText.append("</reqMEV>");
        System.out.println("++++++ requestText ************************ : " + this.requestText.toString());
        return this.requestText.toString();
    }

    public void buildAndSendDrawerRequest() {
    }

    public String buildExteriorTransactionRequest(TicketInfo ticket) {
        TransactionMev mTransactionMev = new TransactionMev();
        mTransactionMev.setDate_transaction(new Date());
        mTransactionMev.setLocal_id(ticket.getId());
        mTransactionMev.setTotal(NumericUtils.round(ticket.getTotal()));
        mTransactionMev.setType_transaction("RFER");
        this.mTransactionMevService.save(mTransactionMev);
        TransactionMev mRefTransactionMev = this.mTransactionMevService.findWithLines("ADDI", ticket.getId());
        String data = this.buildTransactionRequest(mTransactionMev.getId(), ticket, "N", "N", "RFER", mRefTransactionMev);
        return data;
    }
}

