/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.uploads.items;

import com.openbravo.basic.BasicStorage;
import com.openbravo.beans.CarteMenu;
import com.openbravo.pos.admin.User;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppUser;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.parser.OrdersParser;
import com.openbravo.pos.parser.ResponseObject;
import com.openbravo.pos.printer.PrinterHelper;
import com.openbravo.pos.ticket.CarteInfo;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.GroupSubSupplementInfo;
import com.openbravo.pos.ticket.LivreurInfo;
import com.openbravo.pos.ticket.PhotoDispaly;
import com.openbravo.pos.ticket.PrinterInfo;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.PromotionInfo;
import com.openbravo.pos.ticket.SupplementInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.ZoneInfo;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.SystemUtils;
import com.openbravo.postgresql.db.PostgreService;
import com.openbravo.service.CarteSyncService;
import com.openbravo.service.ItemService;
import com.openbravo.service.SynchroService;
import com.openbravo.service.TicketService;
import com.procaisse.MEV.MEVService;
import fr.biborne.jobqueue.MevJob;
import fr.protactile.kitchen.services.TicketSharedService;
import fr.protactile.norm.beans.EnteteInfo;
import fr.protactile.procaisse.dao.entities.LanguageInfo;
import fr.protactile.procaisse.dao.entities.LocalScreen;
import fr.protactile.procaisse.dao.entities.TagInfo;
import fr.protactile.procaisse.services.LanguageService;
import fr.protactile.procaisse.services.LocalScreenService;
import fr.protactile.procaisse.services.TagsService;
import fr.protactile.procaisse.services.ZGlobalService;
import fr.protactile.procaisse.tpeCmi.TPECmi;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONTokener;
import org.json.simple.JSONObject;

@Path(value="/items")
public class ItemsIO {
    @GET
    @Path(value="/list")
    @Produces(value={"application/json;charset=utf-8"})
    public String getList() {
        List<CategoryInfo> categories = CarteSyncService.getCategories();
        List<ProductInfoExt> items = CarteSyncService.getItems();
        List<SupplementInfo> options = CarteSyncService.getSupplements();
        List<CarteInfo> cartes = CarteSyncService.getCartes();
        List<CarteMenu> cartesMenu = CarteSyncService.getCarteMenu();
        List<PrinterInfo> printers = CarteSyncService.getPrinters();
        List<GroupSubSupplementInfo> groupsSubSupplements = CarteSyncService.getGroupsSubOptions();
        List<PromotionInfo> promotions = CarteSyncService.getPromotionsProduct();
        LocalScreenService mLocalScreenService = LocalScreenService.getInstance();
        List<LocalScreen> screens = mLocalScreenService.getAllScreens();
        TagsService mTagsService = TagsService.getInstance();
        List<TagInfo> tags = mTagsService.getAllTags();
        List<ZoneInfo> zones = AppLocal.dlSales.getAllZones();
        LanguageService languageService = LanguageService.getInstance();
        List<LanguageInfo> languages = languageService.getAllLanguages();
        JSONObject jsonRoot = ResponseObject.getJsonCarteAndParamsBorneOld(printers, categories, items, options, cartes, cartesMenu, groupsSubSupplements, promotions, screens, tags, zones, languages);
        return jsonRoot.toString();
    }

    @GET
    @Path(value="/users")
    @Produces(value={"application/json;charset=utf-8"})
    public String getUsers() {
        List<User> users = CarteSyncService.getUsers();
        JSONObject jsonRoot = ResponseObject.getRootUserJson(users);
        return jsonRoot.toString();
    }

    @GET
    @Path(value="/imagesBorne")
    @Produces(value={"application/json;charset=utf-8"})
    public String getImagesBorne() {
        List<PhotoDispaly> photoPub = CarteSyncService.getPhotoPub();
        List<PhotoDispaly> photoHome = CarteSyncService.getPhotosHome();
        List<PhotoDispaly> photosDualScreen = CarteSyncService.getPhotosDualScreen();
        System.out.println("++++++++++++  photosDualScreen size: " + photosDualScreen.size());
        JSONObject jsonRoot = ResponseObject.getRootPhotoJson(photoPub, photoHome, photosDualScreen);
        return jsonRoot.toString();
    }

    @GET
    @Path(value="/downloadProducts")
    @Produces(value={"application/octet-stream"})
    public Response getFile() {
        File file = FilerUtils.getFile("products");
        Response.ResponseBuilder response = Response.ok((Object)file);
        response.header("Content-Disposition", (Object)"attachment; filename=products.zip");
        return response.build();
    }

    @GET
    @Path(value="/existProducts")
    @Produces(value={"application/octet-stream"})
    public String existProducts() {
        JSONObject jsonRoot = new JSONObject();
        FilerUtils m_FilerUtils = FilerUtils.getInstance();
        File SRC_DIRECTORY = m_FilerUtils.getFileFullPath("images/products");
        if (SRC_DIRECTORY.exists()) {
            jsonRoot.put((Object)"ERROR", (Object)"fichier introuvable");
        }
        jsonRoot.put((Object)"ERROR", (Object)"OK");
        return jsonRoot.toString();
    }

    @GET
    @Path(value="/downloadCategories")
    @Produces(value={"application/octet-stream"})
    public Response getFileCategories() {
        File file = FilerUtils.getFile("catagories");
        Response.ResponseBuilder response = Response.ok((Object)file);
        response.header("Content-Disposition", (Object)"attachment; filename=catagories.zip");
        return response.build();
    }

    @GET
    @Path(value="/existCategories")
    @Produces(value={"application/json;charset=utf-8"})
    public String existCategories() {
        JSONObject jsonRoot = new JSONObject();
        FilerUtils m_FilerUtils = FilerUtils.getInstance();
        File SRC_DIRECTORY = m_FilerUtils.getFileFullPath("images/catagories");
        if (SRC_DIRECTORY.exists()) {
            jsonRoot.put((Object)"ERROR", (Object)"fichier introuvable");
        }
        jsonRoot.put((Object)"ERROR", (Object)"OK");
        return jsonRoot.toString();
    }

    @GET
    @Path(value="/downloadOptions")
    @Produces(value={"application/octet-stream"})
    public Response getFileGOptions() {
        File file = FilerUtils.getFile("options");
        Response.ResponseBuilder response = Response.ok((Object)file);
        response.header("Content-Disposition", (Object)"attachment; filename=options.zip");
        return response.build();
    }

    @GET
    @Path(value="/existOptions")
    @Produces(value={"application/octet-stream"})
    public String existGOptions() {
        JSONObject jsonRoot = new JSONObject();
        FilerUtils m_FilerUtils = FilerUtils.getInstance();
        File SRC_DIRECTORY = m_FilerUtils.getFileFullPath("images/options");
        if (SRC_DIRECTORY.exists()) {
            jsonRoot.put((Object)"ERROR", (Object)"fichier introuvable");
        }
        jsonRoot.put((Object)"ERROR", (Object)"OK");
        return jsonRoot.toString();
    }

    @GET
    @Path(value="/downloadSupplements")
    @Produces(value={"application/octet-stream"})
    public Response getFileOptions() {
        File file = FilerUtils.getFile("supplements");
        Response.ResponseBuilder response = Response.ok((Object)file);
        response.header("Content-Disposition", (Object)"attachment; filename=supplements.zip");
        return response.build();
    }

    @GET
    @Path(value="/existSupplements")
    @Produces(value={"application/octet-stream"})
    public String existOptions() {
        JSONObject jsonRoot = new JSONObject();
        FilerUtils m_FilerUtils = FilerUtils.getInstance();
        File SRC_DIRECTORY = m_FilerUtils.getFileFullPath("images/supplements");
        if (SRC_DIRECTORY.exists()) {
            jsonRoot.put((Object)"ERROR", (Object)"fichier introuvable");
        }
        jsonRoot.put((Object)"ERROR", (Object)"OK");
        return jsonRoot.toString();
    }

    @GET
    @Path(value="/remoteSync")
    @Produces(value={"application/json;charset=utf-8"})
    public String remoteSync() {
        JSONObject jsonRoot = new JSONObject();
        try {
            SynchroService mSynchroService = SynchroService.getInstance();
            mSynchroService.synchronize(true, false, false);
            jsonRoot.put((Object)"ERROR", (Object)"OK");
        }
        catch (Exception ex) {
            jsonRoot.put((Object)"ERROR", (Object)"Une erreur est servenu");
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return jsonRoot.toString();
    }

    @GET
    @Path(value="/downloadProperties")
    @Produces(value={"application/octet-stream"})
    public Response getFileProperties() {
        File file = new File(SystemUtils.SYS_USER_HOME + File.separator + "procaisse.properties");
        Response.ResponseBuilder response = Response.ok((Object)file);
        response.header("Content-Disposition", (Object)"attachment; filename=procaisse.properties");
        return response.build();
    }

    @GET
    @Path(value="/downloadPhotoBorne")
    @Produces(value={"application/octet-stream"})
    public Response getFilePhotoBorne() {
        File file = FilerUtils.getFile("photosBorne");
        Response.ResponseBuilder response = Response.ok((Object)file);
        response.header("Content-Disposition", (Object)"attachment; filename=photoBorne.zip");
        return response.build();
    }

    @GET
    @Path(value="/existPhotoBorne")
    @Produces(value={"application/octet-stream"})
    public String existPhotoBorne() {
        JSONObject jsonRoot = new JSONObject();
        FilerUtils m_FilerUtils = FilerUtils.getInstance();
        File SRC_DIRECTORY = m_FilerUtils.getFileFullPath("images/photosBorne");
        if (SRC_DIRECTORY.exists()) {
            jsonRoot.put((Object)"ERROR", (Object)"fichier introuvable");
        }
        jsonRoot.put((Object)"ERROR", (Object)"OK");
        return jsonRoot.toString();
    }

    @GET
    @Path(value="/downloadPhotoPub")
    @Produces(value={"application/octet-stream"})
    public Response getFilePhotoPub() {
        File file = FilerUtils.getFile("photosPub");
        Response.ResponseBuilder response = Response.ok((Object)file);
        response.header("Content-Disposition", (Object)"attachment; filename=photosPub.zip");
        return response.build();
    }

    @GET
    @Path(value="/existPhotoPub")
    @Produces(value={"application/octet-stream"})
    public String existPhotoPub() {
        JSONObject jsonRoot = new JSONObject();
        FilerUtils m_FilerUtils = FilerUtils.getInstance();
        File SRC_DIRECTORY = m_FilerUtils.getFileFullPath("images/photosPub");
        if (SRC_DIRECTORY.exists()) {
            jsonRoot.put((Object)"ERROR", (Object)"fichier introuvable");
        }
        jsonRoot.put((Object)"ERROR", (Object)"OK");
        return jsonRoot.toString();
    }

    @GET
    @Path(value="/downloadPhotoDualScreen")
    @Produces(value={"application/octet-stream"})
    public Response getFilePhotoDoubleEcran() {
        File file = FilerUtils.getFile("photosDisplay");
        Response.ResponseBuilder response = Response.ok((Object)file);
        response.header("Content-Disposition", (Object)"attachment; filename=photosDisplay.zip");
        return response.build();
    }

    @GET
    @Path(value="/existPhotoDualScreen")
    @Produces(value={"application/octet-stream"})
    public String existPhotoDoubleEcran() {
        JSONObject jsonRoot = new JSONObject();
        FilerUtils m_FilerUtils = FilerUtils.getInstance();
        File SRC_DIRECTORY = m_FilerUtils.getFileFullPath("images/photosDisplay");
        if (SRC_DIRECTORY.exists()) {
            jsonRoot.put((Object)"ERROR", (Object)"fichier introuvable");
        }
        jsonRoot.put((Object)"ERROR", (Object)"OK");
        return jsonRoot.toString();
    }

    @GET
    @Path(value="/downloadLogos")
    @Produces(value={"application/octet-stream"})
    public Response getFileLogos() {
        File file = FilerUtils.getFile("logos");
        Response.ResponseBuilder response = Response.ok((Object)file);
        response.header("Content-Disposition", (Object)"attachment; filename=logos.zip");
        return response.build();
    }

    @GET
    @Path(value="/existLogos")
    @Produces(value={"application/octet-stream"})
    public String existLogos() {
        JSONObject jsonRoot = new JSONObject();
        FilerUtils m_FilerUtils = FilerUtils.getInstance();
        File SRC_DIRECTORY = m_FilerUtils.getFileFullPath("images/logos");
        if (SRC_DIRECTORY.exists()) {
            jsonRoot.put((Object)"ERROR", (Object)"fichier introuvable");
        }
        jsonRoot.put((Object)"ERROR", (Object)"OK");
        return jsonRoot.toString();
    }

    @POST
    @Path(value="/sendStatusProduct")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String sendStatusProduct(String requestObject) {
        String error;
        JSONObject response = null;
        try {
            response = new JSONObject();
            JSONTokener tokener = new JSONTokener(requestObject);
            org.json.JSONObject objProduct = new org.json.JSONObject(tokener);
            int product_id = objProduct.getInt("product_id");
            boolean sold_out = objProduct.getBoolean("sold_out");
            boolean hidden_borne = objProduct.getBoolean("hidden_borne");
            boolean sold_out_temporary = objProduct.isNull("sold_out_temporary") ? false : objProduct.getBoolean("sold_out_temporary");
            ItemService mItemService = ItemService.getInstance();
            mItemService.changeStatusProduct(product_id, sold_out, hidden_borne, sold_out_temporary, null);
            error = "OK";
        }
        catch (Exception e) {
            e.printStackTrace();
            error = "une erreur est servenu";
        }
        response.put((Object)"error", (Object)error);
        return response.toString();
    }

    @GET
    @Path(value="/images/{folder}/{image}")
    @Produces(value={"application/octet-stream"})
    @Consumes(value={"application/json"})
    public Response loadImage(@PathParam(value="folder") String name_folder, @PathParam(value="image") String name_image) {
        File file = FilerUtils.getImage(name_folder, name_image);
        Response.ResponseBuilder response = Response.ok((Object)file);
        response.header("Content-Disposition", (Object)("attachment; filename=" + name_image));
        return response.build();
    }

    @POST
    @Path(value="/printTicketBorne")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String printTicketBorne(String requestObject) {
        String error;
        JSONObject response = null;
        try {
            response = new JSONObject();
            JSONTokener tokener = new JSONTokener(requestObject);
            org.json.JSONObject objTicket = new org.json.JSONObject(tokener);
            String id_ticket = objTicket.getString("id_ticket");
            TicketService mTicketService = TicketService.getInstance();
            TicketInfo ticket = mTicketService.getTicketById(id_ticket);
            if (ticket != null) {
                mTicketService.printPaidTicketCaisse(ticket);
            }
            error = "OK";
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("une erreur est servenu");
            error = "une erreur est servenu";
        }
        response.put((Object)"error", (Object)error);
        return response.toString();
    }

    @GET
    @Path(value="/remoteSyncImages")
    @Produces(value={"application/json;charset=utf-8"})
    public String remoteSyncImages() {
        JSONObject jsonRoot = new JSONObject();
        try {
            System.out.println("+++++++ synchro imgaes");
            SynchroService mSynchroService = SynchroService.getInstance();
            mSynchroService.synchronizeImages();
            jsonRoot.put((Object)"ERROR", (Object)"OK");
        }
        catch (Exception ex) {
            jsonRoot.put((Object)"ERROR", (Object)"Une erreur est servenu");
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return jsonRoot.toString();
    }

    @GET
    @Path(value="/remoteSyncItems")
    @Produces(value={"application/json;charset=utf-8"})
    public String remoteSyncItems() {
        JSONObject jsonRoot = new JSONObject();
        try {
            System.out.println("++++++++ synchro items");
            SynchroService mSynchroService = SynchroService.getInstance();
            boolean result = mSynchroService.synchronizeItems();
            if (result) {
                jsonRoot.put((Object)"ERROR", (Object)"OK");
            } else {
                jsonRoot.put((Object)"ERROR", (Object)"Une erreur est servenu");
            }
        }
        catch (Exception ex) {
            jsonRoot.put((Object)"ERROR", (Object)"Une erreur est servenu");
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return jsonRoot.toString();
    }

    @POST
    @Path(value="/sendStatusDailyStockProduct")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String sendStatusDailyStockProduct(String requestObject) {
        String error;
        JSONObject response = null;
        try {
            response = new JSONObject();
            JSONTokener tokener = new JSONTokener(requestObject);
            org.json.JSONObject objProduct = new org.json.JSONObject(tokener);
            ArrayList<Integer> ids_products = new ArrayList<Integer>();
            if (!objProduct.isNull("products")) {
                JSONArray products = objProduct.getJSONArray("products");
                for (int j = 0; j < products.length(); ++j) {
                    int idProduct = products.getInt(j);
                    ids_products.add(idProduct);
                }
            }
            System.out.println("++++++++++++ receive id sold out from master ids_products : " + ids_products);
            ItemService mItemService = ItemService.getInstance();
            for (Integer id_product : ids_products) {
                mItemService.updateStatusSoldOutProduct(id_product, true);
            }
            AppLocal.product_management = true;
            error = "OK";
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("une erreur est servenu");
            error = "une erreur est servenu";
        }
        response.put((Object)"error", (Object)error);
        return response.toString();
    }

    @POST
    @Path(value="/sendSoldOutToMasterCaisse")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String sendSoldOutToMasterCaisse(String requestObject) {
        String error;
        JSONObject response = null;
        try {
            response = new JSONObject();
            JSONTokener tokener = new JSONTokener(requestObject);
            org.json.JSONObject objProduct = new org.json.JSONObject(tokener);
            ArrayList<Integer> ids_products = new ArrayList<Integer>();
            System.out.println("+++++++++ receive id products");
            if (!objProduct.isNull("products")) {
                JSONArray products = objProduct.getJSONArray("products");
                for (int j = 0; j < products.length(); ++j) {
                    int idProduct = products.getInt(j);
                    ids_products.add(idProduct);
                }
            }
            System.out.println("+++++++++ receive id products ids_products : " + ids_products);
            ItemService mItemService = ItemService.getInstance();
            for (Integer id_product : ids_products) {
                mItemService.updateStatusSoldOutProductById(id_product, true);
            }
            AppLocal.product_management = true;
            SynchroService mSynchroService = SynchroService.getInstance();
            System.out.println("+++++++++++ send id slod out to borne");
            mSynchroService.sendStatuDailyStockProduct(ids_products);
            error = "OK";
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("une erreur est servenu");
            error = "une erreur est servenu";
        }
        response.put((Object)"error", (Object)error);
        return response.toString();
    }

    @GET
    @Path(value="/remoteSyncParams")
    @Produces(value={"application/json;charset=utf-8"})
    public String remoteSyncParams() {
        JSONObject jsonRoot = new JSONObject();
        try {
            System.out.println("++++++++ synchro params");
            SynchroService mSynchroService = SynchroService.getInstance();
            mSynchroService.synchProperties();
            jsonRoot.put((Object)"ERROR", (Object)"OK");
        }
        catch (Exception ex) {
            jsonRoot.put((Object)"ERROR", (Object)"Une erreur est servenu");
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return jsonRoot.toString();
    }

    @POST
    @Path(value="/changePaymentBorne")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String changePaymentBorne(String requestObject) {
        String error;
        JSONObject response = null;
        try {
            response = new JSONObject();
            JSONTokener tokener = new JSONTokener(requestObject);
            org.json.JSONObject objBorne = new org.json.JSONObject(tokener);
            boolean payment_enabled = objBorne.getBoolean("payment_enabled");
            System.out.println("payment_enabled : " + payment_enabled);
            SynchroService mSynchroService = SynchroService.getInstance();
            mSynchroService.synchronizePaymentBorne(payment_enabled);
            error = "OK";
        }
        catch (Exception e) {
            e.printStackTrace();
            error = "une erreur est servenu";
        }
        response.put((Object)"error", (Object)error);
        return response.toString();
    }

    @GET
    @Path(value="/downloadIngredients")
    @Produces(value={"application/octet-stream"})
    public Response getFileIngredients() {
        File file = FilerUtils.getFile("ingredients");
        Response.ResponseBuilder response = Response.ok((Object)file);
        response.header("Content-Disposition", (Object)"attachment; filename=ingredients.zip");
        return response.build();
    }

    @GET
    @Path(value="/existIngredients")
    @Produces(value={"application/octet-stream"})
    public String existIngredients() {
        JSONObject jsonRoot = new JSONObject();
        FilerUtils m_FilerUtils = FilerUtils.getInstance();
        File SRC_DIRECTORY = m_FilerUtils.getFileFullPath("images/ingredients");
        if (SRC_DIRECTORY.exists()) {
            jsonRoot.put((Object)"ERROR", (Object)"fichier introuvable");
        }
        jsonRoot.put((Object)"ERROR", (Object)"OK");
        return jsonRoot.toString();
    }

    @POST
    @Path(value="/sendStatusOption")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String sendStatusOption(String requestObject) {
        String error;
        JSONObject response = null;
        try {
            response = new JSONObject();
            JSONTokener tokener = new JSONTokener(requestObject);
            org.json.JSONObject objOption = new org.json.JSONObject(tokener);
            int option_id = objOption.getInt("option_id");
            boolean sold_out = objOption.getBoolean("sold_out");
            boolean hidden_borne = objOption.getBoolean("hidden_borne");
            ItemService mItemService = ItemService.getInstance();
            mItemService.changeStatusOption(option_id, sold_out, hidden_borne, null);
            error = "OK";
        }
        catch (Exception e) {
            e.printStackTrace();
            error = "une erreur est servenu";
        }
        response.put((Object)"error", (Object)error);
        return response.toString();
    }

    @POST
    @Path(value="/sendZGlobal")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String sendZGlobal(String requestObject) {
        String error;
        JSONObject response = null;
        try {
            response = new JSONObject();
            JSONTokener tokener = new JSONTokener(requestObject);
            JSONArray jsonArrayGTP = new JSONArray(tokener);
            ZGlobalService mZGlobalService = ZGlobalService.getInstance();
            mZGlobalService.synchronizePeriods(jsonArrayGTP);
            error = "OK";
        }
        catch (Exception e) {
            e.printStackTrace();
            error = "une erreur est servenu";
        }
        response.put((Object)"error", (Object)error);
        return response.toString();
    }

    @GET
    @Path(value="/downloadTags")
    @Produces(value={"application/octet-stream"})
    public Response getFileTags() {
        File file = FilerUtils.getFile("tags");
        Response.ResponseBuilder response = Response.ok((Object)file);
        response.header("Content-Disposition", (Object)"attachment; filename=tags.zip");
        return response.build();
    }

    @GET
    @Path(value="/existTags")
    @Produces(value={"application/octet-stream"})
    public String existTags() {
        JSONObject jsonRoot = new JSONObject();
        FilerUtils m_FilerUtils = FilerUtils.getInstance();
        File SRC_DIRECTORY = m_FilerUtils.getFileFullPath("images/tags");
        if (SRC_DIRECTORY.exists()) {
            jsonRoot.put((Object)"ERROR", (Object)"fichier introuvable");
        }
        jsonRoot.put((Object)"ERROR", (Object)"OK");
        return jsonRoot.toString();
    }

    @GET
    @Path(value="/ping")
    @Produces(value={"application/json;charset=utf-8"})
    public Response ping() {
        Response.ResponseBuilder response = Response.ok();
        response.header("Content-Type", (Object)"application/json");
        return response.build();
    }

    @POST
    @Path(value="/getRapport")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getRapport(String requestObject) {
        JSONObject response = null;
        String message = "error";
        try {
            response = new JSONObject();
            JSONTokener tokener = new JSONTokener(requestObject);
            org.json.JSONObject requestJsonObject = new org.json.JSONObject(tokener);
            String date_start_text = requestJsonObject.getString("date_start");
            String date_end_text = requestJsonObject.getString("date_end");
            boolean only_borne = requestJsonObject.getBoolean("only_borne");
            System.out.println("++++++ date_start_text : " + date_start_text);
            System.out.println("++++++ date_end_text : " + date_end_text);
            if (!only_borne || AppLocal.modeCaisse != null && AppLocal.modeCaisse.equalsIgnoreCase("Borne")) {
                TicketService mTicketService = TicketService.getInstance();
                Date dateStart = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(date_start_text);
                Date dateEnd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(date_end_text);
                System.out.println("++++++ dateStart : " + dateStart);
                System.out.println("+++++ dateEnd : " + dateEnd);
                org.json.JSONObject data = mTicketService.getRapportJSON(dateStart, dateEnd);
                if (data != null) {
                    message = "OK";
                    response.put((Object)"data", (Object)data);
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        response.put((Object)"message", (Object)message);
        return response.toString();
    }

    @GET
    @Path(value="/livreurs")
    @Produces(value={"application/json;charset=utf-8"})
    public String getListLivreurs() {
        org.json.JSONObject jsonRoot = new org.json.JSONObject();
        try {
            List<LivreurInfo> livreurs = AppLocal.dlSales != null ? AppLocal.dlSales.getLivreurs() : null;
            JSONArray jsonLivreArray = ResponseObject.getJsonLivreurs(livreurs);
            jsonRoot.put("Livreurs", (Object)jsonLivreArray);
            jsonRoot.put("ERROR", (Object)"OK");
            return jsonRoot.toString();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            jsonRoot.put("ERROR", (Object)"Une erreur est servenu");
            return jsonRoot.toString();
        }
    }

    @POST
    @Path(value="/shutdown")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response shutdown() {
        Response.ResponseBuilder response = Response.ok();
        response.header("Content-Type", (Object)"application/json");
        final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> scheduledFuture = scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                JRootApp m_App = (JRootApp)BasicStorage.getObject("APP_ROOT_INSTANCE");
                if (m_App != null) {
                    System.out.println("close JRootApp*****************");
                    m_App.tryToClose();
                } else {
                    System.out.println("close normal");
                    System.exit(0);
                }
                scheduler.shutdown();
            }
        }, 2L, TimeUnit.SECONDS);
        return response.build();
    }

    @POST
    @Path(value="/getTickets")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getTickets(String requestObject) {
        JSONObject response = null;
        String message = "error";
        try {
            response = new JSONObject();
            JSONTokener tokener = new JSONTokener(requestObject);
            org.json.JSONObject requestJsonObject = new org.json.JSONObject(tokener);
            String date_start_text = requestJsonObject.getString("date_start");
            String date_end_text = requestJsonObject.getString("date_end");
            System.out.println("++++++ date_start_text : " + date_start_text);
            System.out.println("++++++ date_end_text : " + date_end_text);
            TicketService mTicketService = TicketService.getInstance();
            Date dateStart = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(date_start_text);
            Date dateEnd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(date_end_text);
            System.out.println("++++++ dateStart : " + dateStart);
            System.out.println("+++++ dateEnd : " + dateEnd);
            org.json.JSONObject data = mTicketService.getTicketsJSON(dateStart, dateEnd);
            if (data != null) {
                message = "OK";
                response.put((Object)"data", (Object)data);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        response.put((Object)"message", (Object)message);
        return response.toString();
    }

    @POST
    @Path(value="/printJustificatifPaymentBorne")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String printJustificatifPaymentBorne(String requestObject) {
        String error;
        JSONObject response = null;
        try {
            response = new JSONObject();
            JSONTokener tokener = new JSONTokener(requestObject);
            org.json.JSONObject objTicket = new org.json.JSONObject(tokener);
            String id_ticket = objTicket.getString("id_ticket");
            int couvert = objTicket.getInt("couvert");
            String motif_impression = objTicket.getString("motif_impression");
            TicketService mTicketService = TicketService.getInstance();
            TicketInfo ticket = mTicketService.getTicketById(id_ticket);
            if (ticket != null) {
                mTicketService.printTicketSansDetail(ticket, couvert, motif_impression);
            }
            error = "OK";
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("une erreur est servenu");
            error = "une erreur est servenu";
        }
        response.put((Object)"error", (Object)error);
        return response.toString();
    }

    @POST
    @Path(value="/sendTicketToMev")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String sendTicketToMev(String requestObject) {
        String message;
        JSONObject response = null;
        try {
            System.out.println("++++++++++++ call WS sendTicketToMev Caisse +++++++++++++++++");
            response = new JSONObject();
            JSONTokener tokener = new JSONTokener(requestObject);
            org.json.JSONObject objTicket = new org.json.JSONObject(tokener);
            System.out.println("objTicket : " + objTicket);
            TicketInfo ticket = OrdersParser.jsonToTicket(objTicket);
            MEVService mevService = new MEVService();
            String requestMev = mevService.buildExteriorTransactionRequest(ticket);
            MevJob mevJob = new MevJob(requestMev);
            AppLocal.managerJobQueue.addJob(mevJob);
            message = "success";
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("une erreur est servenu");
            message = "Une erreur est servenu.";
        }
        response.put((Object)"message", (Object)message);
        return response.toString();
    }

    @POST
    @Path(value="/CancelCBOrderCmi")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String cancelCBOrderCmi(String requestObject) {
        String error;
        JSONObject response = null;
        Object[] results_cmi = null;
        String message = null;
        try {
            response = new JSONObject();
            JSONTokener tokener = new JSONTokener(requestObject);
            org.json.JSONObject objTicket = new org.json.JSONObject(tokener);
            String id_ticket = objTicket.getString("id_ticket");
            TicketService mTicketService = TicketService.getInstance();
            PostgreService mPostgreService = PostgreService.getInstance();
            TicketInfo ticket = mTicketService.getTicketById(id_ticket);
            TicketInfo ticketTracked = (TicketInfo)ticket.clone();
            TicketInfo ticketLoyalty = (TicketInfo)ticket.clone();
            TPECmi mTPECmi = TPECmi.getInstance();
            TicketSharedService mTicketSharedService = TicketSharedService.getInstance();
            if (ticket != null) {
                results_cmi = mTPECmi.doCancelCurrentPayment(ticket);
                boolean sucess = (Boolean)results_cmi[0];
                String ticket_cmi = String.valueOf(results_cmi[2]);
                message = String.valueOf(results_cmi[1]);
                String session_id = String.valueOf(results_cmi[3]);
                String ecr_stan = String.valueOf(results_cmi[4]);
                String eft_stan = String.valueOf(results_cmi[5]);
                String last4_digits = String.valueOf(results_cmi[6]);
                ticket.setSession_id(session_id);
                ticket.setEft_stan(eft_stan);
                ticket.setTag_erc_stan(ecr_stan);
                ticket.setLast_digit(last4_digits);
                ticket.setEcrDateTime(AppLocal.CURRENT_ECR_DATE_TIME);
                if (sucess && ticket_cmi != null && !ticket_cmi.isEmpty()) {
                    PrinterHelper printer = new PrinterHelper();
                    if (AppLocal.CUSTOMER_LOYALTY) {
                        mTicketService.deleteTransactionLoyalty(ticketLoyalty);
                    }
                    AppUser user = AppLocal.dlSales.getUserById("0");
                    ticket = AppLocal.dlSales.cancelOrder(ticket, "ANNULATION TPE CMI", user.getId());
                    mTicketSharedService.cancelOrder(ticket.getId());
                    mTicketService.printCanceledOrder(ticket);
                    mTicketService.printCmiTicketPayment(printer, ticket_cmi, true);
                    if (AppLocal.IS_STATS_ONLINE_ENABLED.booleanValue()) {
                        mPostgreService.canceledOrder(ticketTracked);
                    }
                }
            }
            error = message != null ? message : "OK";
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("une erreur est servenu");
            error = "une erreur est servenu";
        }
        response.put((Object)"error", (Object)error);
        return response.toString();
    }

    @GET
    @Path(value="/LoadBackofficeCashlogy")
    @Produces(value={"application/json;charset=utf-8"})
    public String LoadBackofficeCashlogy() {
        JSONObject jsonRoot = new JSONObject();
        try {
            SynchroService mSynchroService = SynchroService.getInstance();
            mSynchroService.loadBackOfficeSelfCashlogy();
            jsonRoot.put((Object)"STATUS", (Object)"OK");
        }
        catch (Exception ex) {
            jsonRoot.put((Object)"ERROR", (Object)"Une erreur est servenu");
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return jsonRoot.toString();
    }

    @POST
    @Path(value="/SendTicketByEmail")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String sendEmailFromBorne(String requestObject) {
        String error;
        JSONObject response = null;
        String message = null;
        try {
            response = new JSONObject();
            JSONTokener tokener = new JSONTokener(requestObject);
            org.json.JSONObject objTicket = new org.json.JSONObject(tokener);
            String id_ticket = objTicket.getString("id_ticket");
            String email_customer = objTicket.getString("email_customer");
            TicketService ticketService = TicketService.getInstance();
            TicketInfo ticket = ticketService.getTicketById(id_ticket);
            if (ticket != null) {
                EnteteInfo enteteTicket = AppLocal.dlSales.getEnteteByTicket(ticket.getId(), true);
                String motif_impression = "demande de client";
                ticketService.sendEmailPaidTicketCaisse(ticket, enteteTicket, motif_impression, email_customer);
                message = "OK";
            }
            error = message != null ? message : "OK";
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("une erreur est servenu");
            error = "une erreur est servenu";
        }
        response.put((Object)"error", (Object)error);
        return response.toString();
    }
}

