/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.service;

import com.openbravo.basic.BasicException;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.MenuUberBuilder;
import com.openbravo.pos.ticket.SupplementInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketInfoBuilder;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.ItemService;
import com.openbravo.service.TicketService;
import fr.protactile.procaisse.dao.entities.InfoUberEats;
import fr.protactile.procaisse.dao.impl.InfoUberEatsDao;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.emitter.Emitter;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.json.JSONArray;
import org.json.JSONObject;

public class UberService {
    private static UberService m_instance;
    private String token_eats_store_orders_read;
    private String token_eats_orders;
    private String store_id;
    private String client_id;
    private String client_secret;
    private String client_id_prod = "CbKG1LwuaIkAzd1uFiHOCf1Vm_vpsOZl";
    private String client_secret_prod = "W7mswWfulyBL1vD2_DLpdQ8VQGPxqBX5le-ud5te";
    private String client_id_test = "aagY47zzWwMflOp65GWQH4gNf8oQdF0P";
    private String client_secret_test = "7il81srjO3p9x1rwhhmiLYwVf6cxYl1Fxm-AN_Zq";
    private String grant_type = "client_credentials";
    private String scope_orders_read = "eats.store.orders.read";
    private String scope_eats_order = "eats.order";
    private PropertyChangeSupport support;
    private InfoUberEatsDao mInfoUberEatsDao;
    private InfoUberEats mInfoUberEats;
    private String scope_eats_store = "eats.store";
    private String scope_eats_store_status_write = "eats.store.status.write";
    private String token_eats_store;
    private String token_eats_store_status_write;
    private int expires_in = 30;
    private ItemService mItemService;
    private String ONLINE = "ONLINE";
    private final String MESSAGE = "message";
    private final String MESSAGE_ERROR_TOKEN = "Invalid OAuth 2.0 credentials provided.";
    private final String MESSAGE_ERROR_SOTREID_EMPTY = "Merci d'introduire le store id.";
    private final String MESSAGE_ERROR_DB_EMPTY = "Carte vide.";
    private final String SUCCESS = "OK";
    private final String MESSAGE_ERROR_JOIN_UBEREATS = "Erreur ce connexion uber eats";
    private int number_send_menu;
    private TicketService mTicketService;
    private final String RESOURCE_NOT_FOUND = "resource_not_found";
    private final String URL_TOKEN = "https://auth.uber.com/oauth/v2/token";
    private final String URL_TOKEN_OLD = "https://login.uber.com/oauth/v2/token";
    private final String URL_GET_ORDER = "https://api.uber.com/v2/eats/order/";
    private final String URL_GET_ORDER_NEW = "https://api.uber.com/v1/delivery/order/";

    public static UberService getInstance() {
        if (m_instance == null) {
            m_instance = new UberService();
        }
        return m_instance;
    }

    private UberService() {
        if (AppLocal.UBER_DEV_MODE) {
            this.client_id = this.client_id_test;
            this.client_secret = this.client_secret_test;
        } else {
            this.client_id = this.client_id_prod;
            this.client_secret = this.client_secret_prod;
        }
        this.support = new PropertyChangeSupport(this);
        this.mInfoUberEatsDao = new InfoUberEatsDao();
        this.mItemService = ItemService.getInstance();
        this.loadInfoUberEats();
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.support.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.support.removePropertyChangeListener(pcl);
    }

    public void connect() throws URISyntaxException {
        if (this.store_id != null && !this.store_id.isEmpty()) {
            Socket socket = IO.socket((String)"http://45.76.44.106:6688");
            socket.connect();
            socket.on(this.store_id, new Emitter.Listener(){

                public void call(Object ... args) {
                    String OrderId;
                    String url_order;
                    JSONObject metaObject;
                    JSONObject json_order = (JSONObject)args[0];
                    System.out.println("+++++++++++ json_order : " + json_order);
                    if (!(json_order == null || json_order.isNull("meta") || (metaObject = json_order.getJSONObject("meta")).isNull("resource_id") || (url_order = "https://api.uber.com/v2/eats/order/" + (OrderId = metaObject.getString("resource_id"))).isEmpty())) {
                        System.out.println("url_order : " + url_order);
                        try {
                            JSONObject order = UberService.this.getOrderUber(url_order, 0);
                            if (order != null) {
                                String oldTicket;
                                if (UberService.this.mTicketService == null) {
                                    UberService.this.mTicketService = TicketService.getInstance();
                                }
                                String string = oldTicket = order.isNull("id") ? null : UberService.this.mTicketService.getTicketByIdPlatform(order.getString("id"));
                                if (oldTicket == null) {
                                    if (AppLocal.AUTO_ACCEPT_UBEREAT_ORDER) {
                                        UberService.this.validOrderUber(order);
                                    } else {
                                        int number_orders = UberService.this.getNumberOrdersActive();
                                        UberService.this.sentInfoOrders(number_orders, order);
                                    }
                                }
                            }
                        }
                        catch (BasicException | IOException | SQLException ex) {
                            LogToFile.log("severe", ex.getMessage(), ex);
                        }
                    }
                }
            });
        }
    }

    public JSONObject getOrderUber(String url_order, int number_try) throws IOException, BasicException, SQLException {
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().url(url_order).get().addHeader("Authorization", "Bearer " + this.token_eats_orders).addHeader("Content-Type", "application/json").build();
        Response response = client.newCall(request).execute();
        System.out.println("response : " + response);
        if (response.code() == 200) {
            String response_items = response.body().string();
            JSONObject jsonResponse = new JSONObject(response_items);
            System.out.println("+++++ jsonResponse : " + jsonResponse);
            response.close();
            return jsonResponse;
        }
        if (response.code() == 401) {
            String response_items = response.body().string();
            JSONObject jsonResponse = new JSONObject(response_items);
            System.out.println("+++++ jsonResponse : " + jsonResponse);
            System.out.println("number_try : " + number_try);
            if (number_try < 1) {
                response.close();
                this.setTokenEatsOrder();
                return this.getOrderUber(url_order, 1);
            }
        }
        response.close();
        return null;
    }

    public List<String> getOrdersUber(int number_try) throws IOException, BasicException, SQLException {
        if (this.mTicketService == null) {
            this.mTicketService = TicketService.getInstance();
        }
        ArrayList<String> orders = new ArrayList<String>();
        if (this.store_id != null && !this.store_id.isEmpty()) {
            OkHttpClient client = new OkHttpClient();
            String url_orders = "https://api.uber.com/v1/eats/stores/" + this.store_id + "/created-orders";
            Request request = new Request.Builder().url(url_orders).get().addHeader("Authorization", "Bearer " + this.token_eats_store_orders_read).addHeader("Content-Type", "application/json").build();
            Response response = client.newCall(request).execute();
            if (response.code() == 200) {
                String response_items = response.body().string();
                JSONObject jsonResponse = new JSONObject(response_items);
                if (!jsonResponse.isNull("orders")) {
                    JSONArray orders_array = jsonResponse.getJSONArray("orders");
                    if (orders_array != null) {
                        for (int i = 0; i < orders_array.length(); ++i) {
                            String id_order;
                            String oldTicket;
                            JSONObject objectOrder = orders_array.getJSONObject(i);
                            if (objectOrder.isNull("id") || (oldTicket = this.mTicketService.getTicketByIdPlatform(id_order = objectOrder.getString("id"))) != null) continue;
                            orders.add(id_order);
                        }
                    }
                    return orders;
                }
            } else if (response.code() == 401) {
                String response_items = response.body().string();
                JSONObject jsonResponse = new JSONObject(response_items);
                System.out.println("++++++++ jsonResponse new : " + jsonResponse);
                if (!jsonResponse.isNull("message")) {
                    String message = jsonResponse.getString("message");
                    if (message != null && (message.equalsIgnoreCase("Invalid OAuth 2.0 credentials provided.") || number_try < 1)) {
                        this.setTokenOrdersRead();
                        return this.getOrdersUber(1);
                    }
                    return null;
                }
            }
        }
        return null;
    }

    public int getNumberOrdersActive() {
        try {
            List<String> orders_array = this.getOrdersUber(0);
            if (orders_array != null) {
                return orders_array.size();
            }
        }
        catch (BasicException | IOException | SQLException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return 0;
    }

    public void sentInfoOrders(int number_orders, JSONObject order) {
        Object[] info_orders = new Object[2];
        info_orders[1] = number_orders;
        info_orders[0] = order;
        this.support.firePropertyChange("uber_orders", null, info_orders);
    }

    public LinkedHashMap<String, TicketInfo> getOrdersDetail() {
        LinkedHashMap<String, TicketInfo> orders = new LinkedHashMap<String, TicketInfo>();
        try {
            List<String> orders_created = this.getOrdersUber(0);
            if (orders_created != null) {
                Collections.reverse(orders_created);
                for (String id_order : orders_created) {
                    String url_order = "https://api.uber.com/v2/eats/order/" + id_order;
                    JSONObject order = this.getOrderUber(url_order, 0);
                    if (order == null) continue;
                    TicketInfo mTicketInfo = TicketInfoBuilder.create(null).objectOrder(order).buildOrder().toTicketInfo();
                    orders.put(id_order, mTicketInfo);
                }
            }
        }
        catch (BasicException | IOException | SQLException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return orders;
    }

    public boolean acceptOrder(String id_order, int number_try) throws IOException {
        Response response;
        block4: {
            JSONObject jsonRoot = new JSONObject();
            jsonRoot.put("reason", (Object)"Order has been accepted.");
            OkHttpClient client = new OkHttpClient();
            String resourceUrl = "https://api.uber.com/v1/eats/orders/" + id_order + "/accept_pos_order";
            System.out.println("+++++++++++++ resourceUrl : " + resourceUrl);
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonRoot.toString());
            Request request = new Request.Builder().url(resourceUrl).post(requestBody).addHeader("Authorization", "Bearer " + this.token_eats_orders).addHeader("Content-Type", "application/json").build();
            response = client.newCall(request).execute();
            System.out.println("+++++++++++ response : " + response);
            if (response.code() != 204) {
                try {
                    if (response.code() == 401 && number_try < 1) {
                        response.close();
                        this.setTokenEatsOrder();
                        return this.acceptOrder(id_order, 1);
                    }
                    break block4;
                }
                catch (Exception exception) {
                    response.close();
                    return false;
                }
            }
            response.close();
            return true;
        }
        response.close();
        return false;
    }

    public void denyOrder(String id_order, int number_try) throws IOException {
        String code;
        String response_items;
        JSONObject jsonResponse;
        JSONObject jsonRoot = new JSONObject();
        JSONObject jsonReason = new JSONObject();
        jsonReason.put("explanation", (Object)"Order has been denied. One or more items are sold out.");
        jsonRoot.put("reason", (Object)jsonReason);
        OkHttpClient client = new OkHttpClient();
        String resourceUrl = "https://api.uber.com/v1/eats/orders/" + id_order + "/deny_pos_order";
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonRoot.toString());
        Request request = new Request.Builder().url(resourceUrl).post(requestBody).addHeader("Authorization", "Bearer " + this.token_eats_orders).addHeader("Content-Type", "application/json").build();
        Response response = client.newCall(request).execute();
        if (response.code() != 204 && !(jsonResponse = new JSONObject(response_items = response.body().string())).isNull("code") && ((code = jsonResponse.getString("code")).equals("unauthorized") || code.equalsIgnoreCase("user_not_allowed") || number_try < 1)) {
            response.close();
            this.setTokenEatsOrder();
            this.denyOrder(id_order, 1);
        }
        response.close();
    }

    public void getTokenReadOrder() throws IOException {
        this.token_eats_store_orders_read = this.getToken(this.scope_orders_read);
    }

    public void getTokenEatsOrder() throws IOException {
        this.token_eats_orders = this.getToken(this.scope_eats_order);
    }

    private void setTokenEatsOrder() throws IOException {
        this.getTokenEatsOrder();
        if (this.mInfoUberEats == null) {
            this.mInfoUberEats = this.mInfoUberEatsDao.firstElement();
        }
        if (this.mInfoUberEats != null) {
            this.mInfoUberEatsDao.setTokenEatsOrder(this.token_eats_orders, this.mInfoUberEats.getId());
        }
    }

    private void setTokenOrdersRead() throws IOException {
        this.getTokenReadOrder();
        if (this.mInfoUberEats == null) {
            this.mInfoUberEats = this.mInfoUberEatsDao.firstElement();
        }
        if (this.mInfoUberEats != null) {
            this.mInfoUberEatsDao.setTokenOrdersRead(this.token_eats_store_orders_read, this.mInfoUberEats.getId());
        }
    }

    private void loadInfoUberEats() {
        try {
            this.mInfoUberEats = this.mInfoUberEatsDao.firstElement();
            System.out.println("++++++++++++ mInfoUberEats : " + this.mInfoUberEats);
            if (this.mInfoUberEats != null) {
                System.out.println("++++++++++++++++ mInfoUberEats id : " + this.mInfoUberEats.getId());
                this.token_eats_store_orders_read = this.mInfoUberEats.getToken_orders_read();
                this.token_eats_orders = this.mInfoUberEats.getToken_eats_orders();
                this.token_eats_store = this.mInfoUberEats.getToken_eats_store();
                this.token_eats_store_status_write = this.mInfoUberEats.getToken_eats_store_write_status();
                this.store_id = this.mInfoUberEats.getStore_id();
                if (this.token_eats_store_orders_read == null || this.token_eats_store_orders_read.isEmpty()) {
                    this.setTokenOrdersRead();
                }
                if (this.token_eats_orders == null || this.token_eats_orders.isEmpty()) {
                    this.setTokenEatsOrder();
                }
                if (this.token_eats_store == null || this.token_eats_store.isEmpty()) {
                    this.setTokenEatsStore();
                }
                if (this.store_id != null && !this.store_id.isEmpty() && !this.mInfoUberEats.isPos_integration_enabled()) {
                    boolean pos_integration_enabled = this.updatePosStaus(this.store_id, 0);
                    this.mInfoUberEats.setPos_integration_enabled(pos_integration_enabled);
                    this.mInfoUberEatsDao.setPosIntegrationEnabled(this.mInfoUberEats);
                }
            } else {
                System.out.println("++++++++++++++++++++ load info");
                this.getTokenReadOrder();
                this.getTokenEatsOrder();
                this.mInfoUberEats = new InfoUberEats();
                this.mInfoUberEats.setToken_eats_orders(this.token_eats_orders);
                this.mInfoUberEats.setToken_orders_read(this.token_eats_store_orders_read);
                this.mInfoUberEatsDao.addInfoUberEats(this.mInfoUberEats);
            }
        }
        catch (IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void getTokenEatsStore() throws IOException {
        this.token_eats_store = this.getToken(this.scope_eats_store);
    }

    public boolean updatePosStaus(String store_id, int number_try) throws IOException {
        boolean pos_integration_enabled = false;
        this.checkTokenStore();
        JSONObject jsonRoot = new JSONObject();
        jsonRoot.put("pos_integration_enabled", true);
        OkHttpClient client = new OkHttpClient();
        String resourceUrl = "https://api.uber.com/v1/eats/stores/" + store_id + "/pos_data";
        System.out.println("+++++++++ resourceUrl : " + resourceUrl);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonRoot.toString());
        Request request = new Request.Builder().url(resourceUrl).patch(requestBody).addHeader("Authorization", "Bearer " + this.token_eats_store).addHeader("Content-Type", "application/json").build();
        Response response = client.newCall(request).execute();
        System.out.println("+++++++++++++ response.code() : " + response.code());
        if (response.code() != 204) {
            String message;
            String response_items = response.body().string();
            System.out.println("++++++++++++ response_items : " + response_items);
            JSONObject jsonResponse = new JSONObject(response_items);
            if (!jsonResponse.isNull("message") && (message = jsonResponse.getString("message")) != null && (message.equalsIgnoreCase("Invalid OAuth 2.0 credentials provided.") || number_try < 1)) {
                this.setTokenEatsStore();
                this.updatePosStaus(store_id, 1);
            }
        } else {
            pos_integration_enabled = true;
        }
        response.close();
        return pos_integration_enabled;
    }

    public String getStoreID() {
        if (this.mInfoUberEats == null) {
            this.mInfoUberEats = this.mInfoUberEatsDao.firstElement();
        }
        if (this.mInfoUberEats != null) {
            System.out.println("+++++++++++++++ mInfoUberEats.getStore_id(); : " + this.mInfoUberEats.getStore_id());
            return this.mInfoUberEats.getStore_id();
        }
        return null;
    }

    public void setStoreID(String store_id) throws IOException {
        boolean pos_integration_enabled;
        boolean bl = pos_integration_enabled = store_id != null && !store_id.isEmpty() ? this.updatePosStaus(store_id, 0) : false;
        if (this.mInfoUberEats == null) {
            this.mInfoUberEats = this.mInfoUberEatsDao.firstElement();
        }
        if (this.mInfoUberEats != null) {
            this.mInfoUberEats.setPos_integration_enabled(pos_integration_enabled);
            this.mInfoUberEats.setStore_id(store_id);
            this.mInfoUberEatsDao.setStoreId(this.mInfoUberEats);
        } else {
            this.getTokenReadOrder();
            this.getTokenEatsOrder();
            this.mInfoUberEats = new InfoUberEats();
            this.mInfoUberEats.setPos_integration_enabled(pos_integration_enabled);
            this.mInfoUberEats.setToken_eats_orders(this.token_eats_orders);
            this.mInfoUberEats.setToken_orders_read(this.token_eats_store_orders_read);
            this.mInfoUberEats.setStore_id(store_id);
            this.mInfoUberEats.setToken_eats_store(this.token_eats_store);
            this.mInfoUberEatsDao.addInfoUberEats(this.mInfoUberEats);
        }
    }

    private void setTokenEatsStore() throws IOException {
        this.getTokenEatsStore();
        if (this.mInfoUberEats == null) {
            this.mInfoUberEats = this.mInfoUberEatsDao.firstElement();
        }
        if (this.mInfoUberEats != null) {
            this.mInfoUberEatsDao.setTokenEatsStore(this.token_eats_store, this.mInfoUberEats.getId());
        }
    }

    public String uploadMenu(boolean checkImage) throws IOException {
        if (this.store_id != null && !this.store_id.isEmpty()) {
            this.number_send_menu = 0;
            this.checkTokenStore();
            System.out.println("++++++++++++ token store : " + this.token_eats_store);
            List<CategoryInfo> categories = this.mItemService.getCategories();
            List<SupplementInfo> groupsOptions = this.mItemService.getGroupsOptions();
            if (categories != null && !categories.isEmpty()) {
                MenuUberBuilder menu = new MenuUberBuilder().categories(categories).groupsOptions(groupsOptions).checkImage(checkImage).build();
                JSONObject jsonMenu = menu.getMenuObject();
                System.out.println("+++++++++ jsonMenu : " + jsonMenu);
                return this.uploadMenu(jsonMenu, 0);
            }
            return "Carte vide.";
        }
        return "Merci d'introduire le store id.";
    }

    private void checkTokenStore() throws IOException {
        Date created_token = this.mInfoUberEats.getToken_eats_store_created_at() == null ? null : DateUtils.addDays(this.mInfoUberEats.getToken_eats_store_created_at(), this.expires_in);
        Date today = new Date();
        System.out.println("++++++++ created_token : " + created_token);
        if (created_token == null || !today.before(created_token)) {
            System.out.println("+++++++++++++++ genarate after check");
            this.setTokenEatsStore();
        }
    }

    private String uploadMenu(JSONObject jsonMenu, int number_try) {
        Response response = null;
        try {
            String result_message = "";
            OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).build();
            String resourceUrl = "https://api.uber.com/v2/eats/stores/" + this.store_id + "/menus";
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonMenu.toString());
            Request request = new Request.Builder().url(resourceUrl).put(requestBody).addHeader("Authorization", "Bearer " + this.token_eats_store).addHeader("Content-Type", "application/json").build();
            response = client.newCall(request).execute();
            System.out.println("+++++++++ response : " + response);
            System.out.println("+++++++++ response.message() : " + response.message());
            if (response.code() != 204) {
                String response_items = response.body().string();
                System.out.println("+++++++ response_items : " + response_items);
                JSONObject jsonResponse = new JSONObject(response_items);
                if (!jsonResponse.isNull("message")) {
                    String message;
                    result_message = message = jsonResponse.getString("message");
                    if (message != null && (message.equalsIgnoreCase("Invalid OAuth 2.0 credentials provided.") || number_try < 2)) {
                        response.close();
                        this.setTokenEatsStore();
                        return this.uploadMenu(jsonMenu, ++number_try);
                    }
                }
            } else {
                result_message = "OK";
            }
            response.close();
            return result_message;
        }
        catch (IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            if (response != null) {
                response.close();
            }
            if (number_try < 2) {
                return this.uploadMenu(jsonMenu, ++number_try);
            }
            return "Erreur ce connexion uber eats";
        }
    }

    public void uploadEmptyMenu() throws IOException {
        MenuUberBuilder menu = new MenuUberBuilder().buildEmptyMenu();
        JSONObject jsonMenu = menu.getMenuObject();
        System.out.println("+++++++++ jsonMenu : " + jsonMenu);
        this.uploadMenu(jsonMenu, 0);
    }

    public String getToken(String scope) throws IOException {
        String token = null;
        HttpClient client = new HttpClient();
        PostMethod method = new PostMethod("https://auth.uber.com/oauth/v2/token");
        method.setParameter("client_id", this.client_id);
        method.setParameter("client_secret", this.client_secret);
        method.setParameter("grant_type", this.grant_type);
        method.setParameter("scope", scope);
        client.executeMethod((HttpMethod)method);
        String response = method.getResponseBodyAsString();
        System.out.println("+++++++++++++ response : " + response);
        JSONObject jsonResponse = new JSONObject(response);
        if (!jsonResponse.isNull("access_token")) {
            String access_token = jsonResponse.getString("access_token");
            System.out.println("++++++++++ access_token : " + access_token);
            token = access_token;
        }
        method.releaseConnection();
        return token;
    }

    public void getTokenEatsStoreQStatusWrite() throws IOException {
        this.token_eats_store_status_write = this.getToken(this.scope_eats_store_status_write);
    }

    private void checkTokenStoreWriteStatus() throws IOException {
        Date created_token = this.mInfoUberEats.getToken_eats_store_write_status_created_at() == null ? null : DateUtils.addDays(this.mInfoUberEats.getToken_eats_store_write_status_created_at(), this.expires_in);
        Date today = new Date();
        System.out.println("++++++++ created_token : " + created_token);
        if (created_token == null || !today.before(created_token)) {
            System.out.println("+++++++++++++++ genarate after check");
            this.setTokenEatsStoreWriteStatus();
        }
    }

    private void setTokenEatsStoreWriteStatus() throws IOException {
        this.getTokenEatsStoreQStatusWrite();
        if (this.mInfoUberEats == null) {
            this.mInfoUberEats = this.mInfoUberEatsDao.firstElement();
        }
        if (this.mInfoUberEats != null) {
            this.mInfoUberEatsDao.setTokenEatsStoreWriteStatus(this.token_eats_store_status_write, this.mInfoUberEats.getId());
        }
    }

    public String getStatusStore() throws IOException {
        this.checkTokenStore();
        String url = "https://api.uber.com/v1/eats/store/" + this.store_id + "/status";
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().url(url).get().addHeader("Authorization", "Bearer " + this.token_eats_store).addHeader("Content-Type", "application/json").build();
        Response response = client.newCall(request).execute();
        String response_items = response.body().string();
        JSONObject jsonResponse = new JSONObject(response_items);
        if (!jsonResponse.isNull("code")) {
            String code = jsonResponse.getString("code");
            if (code.equals("unauthorized")) {
                this.setTokenOrdersRead();
                return this.getStatusStore();
            }
            return null;
        }
        if (!jsonResponse.isNull("status")) {
            String status = jsonResponse.getString("status");
            return status;
        }
        return null;
    }

    private void setStatusStore() throws IOException {
        String status = this.getStatusStore();
        System.out.println("+++++++++++++ status : " + status);
        this.mInfoUberEats.setStatus_store(status);
        this.mInfoUberEatsDao.setStatusStore(this.mInfoUberEats);
    }

    public void changeStatusStore() throws IOException {
        String status = null;
        String status_store = this.getStatusStore();
        status = status_store != null && status_store.equals(this.ONLINE) ? "PAUSED" : this.ONLINE;
        boolean changeStatus = this.changeStatusStore(status);
        if (changeStatus) {
            this.setStatusStore();
        }
    }

    private boolean changeStatusStore(String status) throws IOException {
        boolean changeStatus = false;
        this.checkTokenStoreWriteStatus();
        JSONObject jsonRoot = new JSONObject();
        jsonRoot.put("status", (Object)status);
        OkHttpClient client = new OkHttpClient();
        String resourceUrl = "https://api.uber.com/v1/eats/store/" + this.store_id + "/status";
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonRoot.toString());
        Request request = new Request.Builder().url(resourceUrl).post(requestBody).addHeader("Authorization", "Bearer " + this.token_eats_store_status_write).addHeader("Content-Type", "application/json").build();
        Response response = client.newCall(request).execute();
        System.out.println("+++++++++++++ response.code() : " + response.code());
        if (response.code() != 204) {
            String code;
            String response_items = response.body().string();
            System.out.println("+++++++++++ response_items : " + response_items);
            JSONObject jsonResponse = new JSONObject(response_items);
            if (!jsonResponse.isNull("code") && (code = jsonResponse.getString("code")).equals("unauthorized")) {
                this.changeStatusStore(status);
            }
        } else {
            changeStatus = true;
        }
        response.close();
        return changeStatus;
    }

    public boolean isOnline() {
        System.out.println("+++++++++ mInfoUberEats.getStatus_store() : " + this.mInfoUberEats.getStatus_store());
        return this.mInfoUberEats != null && this.mInfoUberEats.getStatus_store() != null && this.mInfoUberEats.getStatus_store().equals(this.ONLINE);
    }

    public void validOrderUber(final JSONObject order) {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    TicketInfo ticketInfo = TicketInfoBuilder.create(null).objectOrder(order).buildOrder().toTicketInfo();
                    if (ticketInfo != null) {
                        if (UberService.this.mTicketService == null) {
                            UberService.this.mTicketService = TicketService.getInstance();
                        }
                        String id_order = order.getString("id");
                        String oldTicket = UberService.this.mTicketService.getTicketByIdPlatform(ticketInfo.getId_online_order());
                        if (oldTicket != null) {
                            if (ticketInfo.getPlatform_current_state() == null || ticketInfo.getPlatform_current_state().equals("CREATED")) {
                                boolean bl = UberService.this.acceptOrder(id_order, 0);
                            }
                        } else {
                            boolean accept_order;
                            boolean bl = accept_order = ticketInfo.getPlatform_current_state() != null && ticketInfo.getPlatform_current_state().equalsIgnoreCase("ACCEPTED");
                            if (!accept_order) {
                                accept_order = UberService.this.acceptOrder(id_order, 0);
                            }
                            if (accept_order) {
                                UberService.this.mTicketService.orderAttente(false, ticketInfo, false, true, true, false, true, AppLocal.PRINT_TICKET_UBER_EATS);
                                UberService.this.sentInfoOrders(0, null);
                            } else {
                                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "erreur acceptation", 4000, NPosition.BOTTOM_RIGHT);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        });
    }
}

