/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.service;

import com.biborne.sms.SmsService;
import com.openbravo.basic.BasicException;
import com.openbravo.basic.BasicStorage;
import com.openbravo.beans.TicketAvoir;
import com.openbravo.components.LazyModal;
import com.openbravo.components.PopUpTicketDateError;
import com.openbravo.components.base.AppLoaderBuilder;
import com.openbravo.components.interfaces.EventHiddenModal;
import com.openbravo.controllers.borne.MessageSoldOutcontroller;
import com.openbravo.controllers.displayKitchen.AddOrderInterface;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicOrder;
import com.openbravo.dao.DataLogicProduct;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.keen.CassandraManager;
import com.openbravo.models.RankTypeOrder;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.payment.PaymentInfo;
import com.openbravo.pos.printer.Decreaser;
import com.openbravo.pos.printer.Printer;
import com.openbravo.pos.printer.PrinterHelper;
import com.openbravo.pos.ticket.CaisseZ;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.Course;
import com.openbravo.pos.ticket.CustomerLoyalty;
import com.openbravo.pos.ticket.EquipmentTurnover;
import com.openbravo.pos.ticket.FinancialReportInfo;
import com.openbravo.pos.ticket.GroupedTax;
import com.openbravo.pos.ticket.HourInfo;
import com.openbravo.pos.ticket.IndexTicketLine;
import com.openbravo.pos.ticket.ItemLabel;
import com.openbravo.pos.ticket.ItemOrderInfo;
import com.openbravo.pos.ticket.ItemResult;
import com.openbravo.pos.ticket.LivreurInfo;
import com.openbravo.pos.ticket.LogPanier;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.ticket.NumberOrder;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.OptionResult;
import com.openbravo.pos.ticket.OrderSharedBuilder;
import com.openbravo.pos.ticket.PaymentLine;
import com.openbravo.pos.ticket.PrinterInfo;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.ProductResult;
import com.openbravo.pos.ticket.ProductTicket;
import com.openbravo.pos.ticket.PromotionInfo;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.TableInfo;
import com.openbravo.pos.ticket.TaxInfo;
import com.openbravo.pos.ticket.TaxeLine;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketInfoBuilder;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.ticket.TicketResto;
import com.openbravo.pos.ticket.TotaleEncaissement;
import com.openbravo.pos.ticket.UserCaisseInfo;
import com.openbravo.pos.ticket.UserInfo;
import com.openbravo.pos.ticket.ZoneInfo;
import com.openbravo.pos.ticket.ZoneItems;
import com.openbravo.pos.ticket.ZoneItemsLabel;
import com.openbravo.pos.ticket.ZoneLines;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.Event;
import com.openbravo.pos.util.Journal;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import com.openbravo.pos.util.PaymentUtils;
import com.openbravo.pos.util.SendETicketHelper;
import com.openbravo.postgresql.db.PostgreService;
import com.openbravo.qrcode.QrCodeHelper;
import com.openbravo.service.AvoirService;
import com.openbravo.service.DishopService;
import com.openbravo.service.ItemService;
import com.openbravo.service.LoyaltyService;
import com.openbravo.service.NotificationClientService;
import com.openbravo.service.OrderOnLineService;
import com.openbravo.service.SynchroService;
import com.openbravo.service.UploadCommandService;
import com.procaisse.MEV.MEVService;
import com.procaisse.MEV.SendData;
import com.procaisse.avomark.AvomarkService;
import fr.protactile.kitchen.dao.entities.Orders;
import fr.protactile.kitchen.dao.entities.Payments;
import fr.protactile.kitchen.dao.entities.Tickets;
import fr.protactile.kitchen.services.OrderKitchenScreenService;
import fr.protactile.kitchen.services.OrderService;
import fr.protactile.kitchen.services.TicketSharedService;
import fr.protactile.norm.beans.Duplicata;
import fr.protactile.norm.beans.DuplicataJustificatifPayment;
import fr.protactile.norm.beans.EnteteInfo;
import fr.protactile.norm.beans.Facture;
import fr.protactile.norm.beans.GrandTotalPeriode;
import fr.protactile.norm.beans.GrandTotalTicket;
import fr.protactile.norm.beans.JustificatifPayment;
import fr.protactile.procaisse.cache.CacheFinder;
import fr.protactile.procaisse.cache.SharedMemoryCache;
import fr.protactile.procaisse.dao.entities.AddressInfo;
import fr.protactile.procaisse.dao.entities.BorneInfo;
import fr.protactile.procaisse.dao.entities.CaisseInfo;
import fr.protactile.procaisse.dao.entities.CustomerInfo;
import fr.protactile.procaisse.dao.entities.MoneyMouvement;
import fr.protactile.procaisse.dao.entities.PertEntity;
import fr.protactile.procaisse.services.AddressService;
import fr.protactile.procaisse.services.BorneService;
import fr.protactile.procaisse.services.CustomerService;
import fr.protactile.procaisse.services.LoyaltyCardService;
import fr.protactile.procaisse.services.MoneyMouvementServices;
import fr.protactile.procaisse.services.PertEntityServices;
import fr.protactile.procaisse.services.PromoCodeService;
import fr.protactile.procaisse.tpeCB.PaymentByCardFacade;
import fr.protactile.procaisse.tpeCB.PaymentResult;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class TicketService
implements PropertyChangeListener {
    private static Log logger = LogFactory.getFactory().getInstance(TicketService.class);
    private DataLogicSales dlSales;
    private DataLogicOrder dlOrder;
    private OrderService orderService;
    protected List<PrinterInfo> printers;
    private List<PrinterInfo> printers_options;
    private List<TicketLineInfo> productToSend;
    private List<TicketLineInfo> productEMP;
    private List<TicketLineInfo> productSpLater;
    private List<TicketLineInfo> productEmpLater;
    private List<OptionItemOrder> optionsToprint;
    private DataLogicProduct dlProduct;
    private AvoirService avoirService;
    private CassandraManager m_keenProject = null;
    private DataLogicItems dlItems;
    private SharedMemoryCache mSharedMemoryCache;
    private PrinterInfo printerSummaryKitchen;
    private List<TicketLineInfo> linesdeleted;
    private PopUpTicketDateError mPopUpTicketDateError;
    private static TicketService m_instance;
    private AppView m_App;
    private TicketSharedService mTicketSharedService;
    private List<TicketLineInfo> linesUpdated;
    private List<TicketLineInfo> oldLines;
    private List<TicketLineInfo> listDelete;
    private boolean slave;
    private LazyModal mLazyModalMessageSoldOut = null;
    private EventHiddenModal mActionEventMessageSoldOut = null;
    private NotificationClientService mNotificationClientService;
    private SmsService mSmsService;
    private OrderOnLineService mOrderOnLineService;
    private LoyaltyService mLoyaltyService;
    private CustomerService mCustomerService;
    private LoyaltyCardService mLoyaltyCardService;
    private String reason_cancel = "commande encaiss\u00e9e sur une autre caisse";
    private String RELOAD_ORDERS = "reload_orders";
    private PropertyChangeSupport support;
    private PostgreService mPostgreService = null;
    public final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public final SimpleDateFormat dateFormatterFull = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final String SOURCE_CAISSE = "caisse";
    private final String SOURCE_BORNE = "borne";
    private final String SOURCE_CLICK_AND_COLLECT = "Clickandcollect";
    private final String SOURCE_WEB = "web";
    private final String INSIDE = "inside";
    private final String MODE_CAISSE = "Caisse";
    private PromoCodeService mPromoCodeService;
    private double fondcaissecalcule;
    private PertEntityServices mPertEntityServices;
    private MoneyMouvementServices mMoneyMouvementServices;
    private AddressService mAddressService;
    private MEVService mEVService;
    private ItemService mItemService;
    private MarqueNFC marqueNF;
    private final String SOURCE_UBEREAT = "Uber Eats";
    private final String SOURCE_BORNE_CB = "borne cb";
    private final String SOURCE_ONLINE = "online";
    private final String PAYMENT_CB = "cb";
    private List<ProductTicket> subProductLater;
    private DishopService dishopService;

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.support.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.support.removePropertyChangeListener(pcl);
    }

    public TicketService(boolean test) {
    }

    public static TicketService getInstance_2() {
        if (m_instance == null) {
            m_instance = new TicketService(true);
        }
        return m_instance;
    }

    public static TicketService getInstance() {
        if (m_instance == null) {
            m_instance = new TicketService();
        }
        return m_instance;
    }

    public TicketService(String test) {
    }

    private TicketService() {
        this.slave = AppLocal.modeCaisse != null && AppLocal.modelCaisse.equals("Esclave");
        this.linesdeleted = new ArrayList<TicketLineInfo>();
        this.dlSales = AppLocal.dlSales;
        this.dlProduct = AppLocal.dlProduct;
        this.dlItems = AppLocal.dlItems;
        this.dlOrder = AppLocal.dlOrders;
        this.printers = new ArrayList<PrinterInfo>();
        this.productToSend = new ArrayList<TicketLineInfo>();
        this.productEMP = new ArrayList<TicketLineInfo>();
        this.productSpLater = new ArrayList<TicketLineInfo>();
        this.listDelete = new ArrayList<TicketLineInfo>();
        this.productEmpLater = new ArrayList<TicketLineInfo>();
        this.optionsToprint = new ArrayList<OptionItemOrder>();
        this.subProductLater = new ArrayList<ProductTicket>();
        this.mSharedMemoryCache = SharedMemoryCache.getInstance();
        if (AppLocal.KITCHEN_COMPOSITE) {
            this.orderService = OrderService.getInstance();
        }
        this.avoirService = new AvoirService(this.dlOrder);
        try {
            this.printerSummaryKitchen = this.dlSales.getPrinterSummaryKitchen();
            this.marqueNF = MarqueNFC.fetchOrStore(this.dlSales);
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        this.m_App = (AppView)BasicStorage.getObject("APP_ROOT_INSTANCE");
        if (AppLocal.KITCHEN_COMPOSITE) {
            this.mTicketSharedService = TicketSharedService.getInstance();
        }
        this.oldLines = new ArrayList<TicketLineInfo>();
        this.linesUpdated = new ArrayList<TicketLineInfo>();
        this.mLoyaltyService = LoyaltyService.getInstance();
        this.mNotificationClientService = NotificationClientService.getInstance();
        this.mNotificationClientService.addPropertyChangeListener(this);
        this.mLoyaltyCardService = LoyaltyCardService.getInstance();
        this.support = new PropertyChangeSupport(this);
        this.mPromoCodeService = PromoCodeService.getInstance();
        this.mPertEntityServices = PertEntityServices.getInstance();
        this.mMoneyMouvementServices = MoneyMouvementServices.getInstance();
        this.mEVService = new MEVService();
    }

    public void prepareLines(TicketInfo ticket, String typeOrder) throws BasicException {
        this.setTaxesByTypeOrder(ticket, typeOrder);
        this.setTaxesLines(ticket);
        this.prepareLineKitchen(ticket);
    }

    private void prepareLineKitchen(TicketInfo ticket) {
        int index = 1;
        for (TicketLineInfo line : ticket.getLines()) {
            if (line.isNext()) continue;
            if (line.isLabel()) {
                line.setNumero_line(index);
                ++index;
            } else {
                line.setNumero_line(0);
            }
            if (line.getPlace_served() == null) {
                line.setPlace_served(ticket.getType());
            }
            if (line.getTime_served() != null) continue;
            line.setTime_served("now");
        }
    }

    public void prepareTicketOptions(TicketInfo ticket) {
        this.optionsToprint.clear();
        for (TicketLineInfo line : ticket.getLines()) {
            if (line.isDiver() || line.isNext()) continue;
            for (OptionItemOrder supplement : line.getListSupplements()) {
                try {
                    if (supplement.getPrinter() == -1) continue;
                    this.optionsToprint.add(supplement);
                    PrinterInfo printerTmp = this.dlSales.getPrinterByID(supplement.getPrinter());
                    if (printerTmp == null) continue;
                    int found = -1;
                    for (PrinterInfo printer : this.printers) {
                        if (printer.getId() != printerTmp.getId()) continue;
                        found = 1;
                    }
                    if (found != -1) continue;
                    this.printers.add(printerTmp);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
    }

    public void openDrawer() {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (AppLocal.CONNECT_CASH_DRAWER) {
                    try {
                        SendData sendData = new SendData();
                        sendData.openDrawer();
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                } else if (AppLocal.MODULE_MEV && !AppLocal.CONTINUITY_MODE_MEV) {
                    TicketService.this.mEVService.buildAndSendDrawerRequest();
                } else {
                    PrinterHelper printer = new PrinterHelper();
                    printer.openCashDrawer(null);
                }
            }
        });
    }

    public void encaisserOrder(TicketInfo ticket, List<PaymentInfo> payments, Map<Integer, TicketAvoir> ticketsAvoirs, boolean printKitchen, boolean openDrawer, HashMap<Integer, TicketResto> ticketsRestau, boolean cb_borne, boolean send_to_kitchen, boolean print_ticket, String holder_ticket, String restitution_ticket_type, String email_customer) {
        ticket.setHolder(holder_ticket);
        TicketInfo ticketLoyalty = (TicketInfo)ticket.clone();
        String ticketLoyaltyId = ticket.getOrder_id_base() != null && !ticket.getOrder_id_base().isEmpty() ? ticket.getOrder_id_base() : ticketLoyalty.getId();
        String keenio = ticket.getKeenio_base() != null && !ticket.getKeenio_base().isEmpty() ? ticket.getKeenio_base() : AppLocal.getKeenio();
        this.encaisserOrder(ticket, payments, ticketsAvoirs, printKitchen, openDrawer, ticketsRestau, cb_borne, send_to_kitchen, null, null, false, null, holder_ticket, null, null, null, print_ticket, false, false, restitution_ticket_type, email_customer);
        if (AppLocal.CUSTOMER_LOYALTY) {
            this.setCagnoteCustomer(ticketLoyalty, keenio, ticketLoyaltyId, true);
        }
    }

    public void encaisserOrder(TicketInfo ticket, List<PaymentInfo> payments, Map<Integer, TicketAvoir> ticketsAvoirs, boolean printKitchen, boolean openDrawer, HashMap<Integer, TicketResto> ticketsRestau, boolean cb_borne, boolean send_to_kitchen, List<Integer> ids_tickets_borne, List<TicketLineInfo> oldLines, boolean caisse_order, List<TicketLineInfo> linesdeleted, String holder_ticket, String source_order, String type_payment, List<Integer> ids_tickets_kitchen, boolean print_ticket, boolean onlineOrder, boolean delivery, String restitution_ticket_type, String email_customer) {
        if (ticket.getLinesCount() > 0) {
            try {
                boolean add_ticket;
                TableInfo table = this.checkAvailability(ticket.getNum_table());
                if (table != null) {
                    ticket.setTable(table);
                }
                if (add_ticket = this.validOrder(openDrawer, ticket, ticketsRestau, send_to_kitchen, ids_tickets_borne, ticketsAvoirs, printKitchen, payments, oldLines, linesdeleted, "paid", onlineOrder, delivery, ids_tickets_kitchen)) {
                    if (ticket.getSent_from() != null && ticket.getSent_from().equalsIgnoreCase("Dishop")) {
                        this.changeStatusOrderDishop(ticket.getId_online_order());
                    }
                    TicketInfo ticketToSend = (TicketInfo)ticket.clone();
                    this.sendAndPrintOrder(ticketToSend, openDrawer, caisse_order, send_to_kitchen, printKitchen, cb_borne, null, true, holder_ticket, source_order, true, type_payment, print_ticket, false, false, restitution_ticket_type, email_customer);
                }
            }
            catch (Exception ex) {
                LogToFile.log("sever", ex.getMessage(), ex);
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private int getLastNumOrder() {
        int lastNumberOrder = this.orderService.getLastNumOrderKitchen(3);
        return lastNumberOrder;
    }

    public void printPlusTardTickets(EnteteInfo enteteTicket, TicketInfo tikcetToSendToPrinter) {
        ArrayList<TicketLineInfo> products = new ArrayList<TicketLineInfo>();
        ArrayList<ProductTicket> subProducts = new ArrayList<ProductTicket>();
        try {
            for (TicketLineInfo line : tikcetToSendToPrinter.getLines()) {
                if (line.getTime_served() != null && line.getTime_served().equals("later")) {
                    TicketLineInfo newLine = new TicketLineInfo(line);
                    products.add(newLine);
                    continue;
                }
                for (OptionItemOrder supplement : line.getListSupplements()) {
                    ProductInfoExt subProduct;
                    if (supplement.getId_sub_product() == 0 || supplement.getTime_served() == null || !supplement.getTime_served().equalsIgnoreCase("later") || (subProduct = this.dlItems.getProductInfoById(supplement.getId_sub_product())) == null) continue;
                    ProductTicket productTicket = new ProductTicket(subProduct, -1, null, supplement.getNumberOption(), -1, null, subProduct.getRef_web(), null, null);
                    productTicket.setTime_served("later");
                    subProducts.add(productTicket);
                }
            }
            if (products.size() > 0 || subProducts.size() > 0) {
                PrinterHelper printer = new PrinterHelper();
                Decreaser decreaser = new Decreaser(this.dlSales, tikcetToSendToPrinter.getId(), "Bon de Commande", null, tikcetToSendToPrinter.getNumero_order());
                printer.printPlusTardTickets(tikcetToSendToPrinter.getNumero_order(), tikcetToSendToPrinter, enteteTicket, false, products, subProducts, AppLocal.PRINT_FOND, decreaser);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void sendOrderToKitchen(final TicketInfo ticket, final String source_order, final boolean add_payment, final String type_payment, final boolean exterior_order, boolean printQr, final boolean pending_order, final boolean borne_order) {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                TicketService.this.saveOrderInMysql(ticket, source_order, add_payment, type_payment, exterior_order, pending_order, borne_order);
            }
        });
    }

    public AddOrderInterface getRemoteAddOrder(PrinterInfo ecran, TicketInfo tikcetToSendToPrinter) {
        try {
            String ip;
            Remote r;
            if (ecran != null && ecran.getIp() != null && !ecran.getIp().isEmpty() && (r = Naming.lookup("rmi://" + (ip = ecran.getIp()) + "/TestRMI")) instanceof AddOrderInterface) {
                return (AddOrderInterface)r;
            }
        }
        catch (Exception ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
            if (AppVarUtils.ERRONEOUS_TICKETS_DK == null) {
                AppVarUtils.ERRONEOUS_TICKETS_DK = new HashMap<String, TicketInfo>();
            }
            AppVarUtils.ERRONEOUS_TICKETS_DK.put(tikcetToSendToPrinter.getId(), tikcetToSendToPrinter);
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "La connexion \u00e0 l'ecran de suivi a \u00e9chou\u00e9.", 4000, NPosition.CENTER);
        }
        return null;
    }

    public void printKitchen(TicketInfo ticket, boolean cb_borne, List<TicketLineInfo> linesdeleted, boolean first_part_of_order, boolean updateLine) {
        ArrayList<PrinterInfo> printers = new ArrayList<PrinterInfo>();
        ArrayList<TicketLineInfo> productToSend = new ArrayList<TicketLineInfo>();
        ArrayList<TicketLineInfo> productEMP = new ArrayList<TicketLineInfo>();
        ArrayList<TicketLineInfo> productSpLater = new ArrayList<TicketLineInfo>();
        ArrayList<TicketLineInfo> productEmpLater = new ArrayList<TicketLineInfo>();
        ArrayList<OptionItemOrder> optionsToprint = new ArrayList<OptionItemOrder>();
        ArrayList<TicketLineInfo> linesUpdated = new ArrayList<TicketLineInfo>();
        ArrayList<ProductTicket> subProductLater = new ArrayList<ProductTicket>();
        this.prepareTicketCuisine(ticket, printers, productToSend, productEMP, productSpLater, productEmpLater, linesdeleted);
        if (updateLine) {
            try {
                this.prepareUpdateLines(ticket, linesUpdated);
            }
            catch (BasicException ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        for (TicketLineInfo line : ticket.getLines()) {
            if (line.isDiver() || line.isNext()) continue;
            for (OptionItemOrder supplement : line.getListSupplements()) {
                try {
                    if (supplement.getPrinter() == -1) continue;
                    supplement.setQuantity_product(line.getMultiply());
                    optionsToprint.add(supplement);
                    PrinterInfo printerTmp = this.dlSales.getPrinterByID(supplement.getPrinter());
                    if (printerTmp == null) continue;
                    int found = -1;
                    for (PrinterInfo printer : printers) {
                        if (printer.getId() != printerTmp.getId()) continue;
                        found = 1;
                    }
                    if (found != -1) continue;
                    printers.add(printerTmp);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
        PrinterHelper printer = new PrinterHelper();
        Decreaser decreaser = new Decreaser(this.dlSales, ticket.getId(), "Ticket cuisine", null, ticket.getNumero_order());
        this.sortLines(ticket, productToSend, productEMP, productEmpLater, productSpLater, subProductLater);
        LinkedHashMap<Integer, List<ZoneLines>> zoneLinesByPrinter = this.getZoneLinesByPrinter(printers, productToSend);
        LinkedHashMap<Integer, List<ZoneLines>> zoneLinesDineInLaterByPrinter = this.getZoneLinesByPrinter(printers, productSpLater);
        LinkedHashMap<Integer, List<ZoneLines>> zoneLinesTakeAwayByPrinter = this.getZoneLinesByPrinter(printers, productEMP);
        LinkedHashMap<Integer, List<ZoneLines>> zoneLinesTakeAwayLaterByPrinter = this.getZoneLinesByPrinter(printers, productEmpLater);
        LinkedHashMap<Integer, List<ZoneLines>> zoneLinesUpdatedByPrinter = this.getZoneLinesByPrinter(printers, linesUpdated);
        LinkedHashMap<Integer, List<ZoneLines>> zoneLinesDeletedByPrinter = this.getZoneLinesByPrinter(printers, linesdeleted);
        LinkedHashMap<Integer, List<ZoneItems>> zoneSubItemsLaterByPrinter = this.getZoneItemsByPrinter(printers, subProductLater);
        printer.printKitchenTickets(ticket, ticket.getType(), printers, zoneLinesByPrinter, zoneLinesDineInLaterByPrinter, zoneLinesTakeAwayByPrinter, zoneLinesTakeAwayLaterByPrinter, null, decreaser, optionsToprint, zoneLinesDeletedByPrinter, first_part_of_order, zoneLinesUpdatedByPrinter, zoneSubItemsLaterByPrinter, cb_borne);
    }

    private void sortLines(TicketInfo ticket, List<TicketLineInfo> productToSend, List<TicketLineInfo> productEMP, List<TicketLineInfo> productEmpLater, List<TicketLineInfo> productSpLater, List<ProductTicket> subProductLater) {
        ArrayList<TicketLineInfo> linesSP = new ArrayList<TicketLineInfo>();
        boolean printLater = ticket.getType().equals("Sur Place");
        if (printLater) {
            int found_take_away = -1;
            block0: for (TicketLineInfo line : productToSend) {
                if (line.getPlace_served() != null && line.getPlace_served().equals("A Emporter") || line.getTime_served() != null && line.getTime_served().equals("later")) {
                    found_take_away = 1;
                    break;
                }
                for (ProductTicket subProduct : line.getListProducts()) {
                    if (subProduct.getTime_served() == null || !subProduct.getTime_served().equals("later")) continue;
                    found_take_away = 1;
                    continue block0;
                }
            }
            if (found_take_away == -1) {
                printLater = false;
            }
        }
        if (printLater) {
            for (TicketLineInfo line : productToSend) {
                TicketLineInfo newLine = (TicketLineInfo)line.clone();
                newLine.setPrinterID(line.getPrinterID());
                newLine.setTypeUpdate(line.getTypeUpdate());
                if (line.getPlace_served() != null && line.getPlace_served().equals("A Emporter")) {
                    if (line.getTime_served() != null && line.getTime_served().equals("later")) {
                        productEmpLater.add(newLine);
                        continue;
                    }
                    productEMP.add(newLine);
                    continue;
                }
                if (line.getTime_served() != null && line.getTime_served().equals("later")) {
                    productSpLater.add(newLine);
                    continue;
                }
                if (!AppLocal.KITCHEN_TICKET_BY_PRODUCT) {
                    ArrayList<ProductTicket> subItems = new ArrayList<ProductTicket>();
                    for (ProductTicket subProduct : newLine.getListProducts()) {
                        if (subProduct.getTime_served() != null && subProduct.getTime_served().equalsIgnoreCase("later")) {
                            if (subProduct.getPrinterID() == -1 || subProduct.getPrinterID() == 0) {
                                subProduct.setPrinterID(newLine.getPrinterID());
                            }
                            if (subProduct.getIdZone() == 0) {
                                subProduct.setIdZone(line.getIdZone());
                            }
                            subProduct.setNumberProduct(subProduct.getNumberProduct() * (int)newLine.getMultiply());
                            subProductLater.add(subProduct);
                            continue;
                        }
                        subItems.add(subProduct);
                    }
                    newLine.setListProducts(subItems);
                }
                linesSP.add(newLine);
            }
            productToSend.clear();
            productToSend.addAll(linesSP);
        }
    }

    public void printLabel(TicketInfo ticket) {
        try {
            List<PrinterInfo> printersLabel = this.dlSales.getPrintersLabel();
            for (TicketLineInfo line : ticket.getLines()) {
                if (line.isNext() || AppLocal.PRINT_LABEL_PRODUCT_WITH_EXCLUDED_INFREDIENT && !line.hasExcludedIngredients()) continue;
                try {
                    ProductInfoExt productTmp = this.dlSales.getProductInfoById(line.getProductID());
                    if (productTmp != null && productTmp.getPrinterLabel() != -1) {
                        if (!AppLocal.PRINT_LABEL_PRODUCT_WITH_EXCLUDED_INFREDIENT) {
                            List<SupplementItemInfo> ingrediens = this.dlSales.getIngredientsByProducts(line.getProductID(), true, false);
                            line.setListIngredientsIN(ingrediens);
                        }
                        line.setPrinterLabel(productTmp.getPrinterLabel());
                        if (productTmp.getZoneInfo() != null) {
                            line.setNameZone(productTmp.getZoneInfo().getName());
                        }
                    }
                    for (OptionItemOrder supplement : line.getListSupplements()) {
                        ProductInfoExt subProduct;
                        if (supplement.getId_sub_product() == 0 || (subProduct = this.dlProduct.getProductInfo(supplement.getId_sub_product(), false)) == null || subProduct.getPrinterLabel() <= 0) continue;
                        ProductInfoExt item = (ProductInfoExt)subProduct.clone();
                        item.setPriceSell(0.0);
                        ProductTicket mProductTicket = new ProductTicket(item, -1, null, 1, 1, null, subProduct.getRef_web(), null, null);
                        if (line.getListProducts() == null) {
                            line.setListProducts(new ArrayList<ProductTicket>());
                        }
                        if (item.getZoneInfo() != null) {
                            mProductTicket.setIdZone(item.getZoneInfo().getId());
                            mProductTicket.setNameZone(productTmp.getZoneInfo().getName());
                        }
                        mProductTicket.setPrintSeparatedLabel(true);
                        line.getListProducts().add(mProductTicket);
                        supplement.setConvert_to_product(true);
                    }
                    for (ProductTicket subProduct : line.getListProducts()) {
                        ZoneInfo zoneInfo;
                        if (subProduct.getIdZone() == 0 || (zoneInfo = this.dlSales.getZoneInfoById(subProduct.getIdZone())) == null) continue;
                        subProduct.setNameZone(productTmp.getZoneInfo().getName());
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("sever", ex.getMessage(), ex);
                }
            }
            String status = ticket.getStatus() != null && ticket.getStatus().equals("paid") ? "PAYEE" : "EN ATTENTE";
            List<ItemLabel> itemsLabel = this.getItemsLabel(ticket, printersLabel, status);
            LinkedHashMap<Integer, List<ZoneItemsLabel>> zoneItemsLabelByPrinter = this.getZoneItemsLabelByPrinter(printersLabel, itemsLabel);
            PrinterHelper printer = new PrinterHelper();
            Decreaser decreaser = new Decreaser(this.dlSales, ticket.getId(), "Etiquette", null, ticket.getNumero_order());
            printer.printLabel(ticket, zoneItemsLabelByPrinter, status, printersLabel, decreaser);
        }
        catch (Exception ex) {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "L'impression de l'etiquette a \u00e9chou\u00e9.", 1500, NPosition.CENTER);
            LogToFile.log("sever", ex.getMessage(), ex);
        }
    }

    public void orderAttente(boolean printQr, TicketInfo ticket, boolean onlineOrder, boolean send_to_kitchen, boolean print, boolean delivery, boolean platform_order, boolean print_platform_order) {
        try {
            TableInfo table = this.checkAvailability(ticket.getNum_table());
            if (table != null) {
                ticket.setTable(table);
            }
        }
        catch (BasicException ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
        }
        this.orderAttente(printQr, ticket, onlineOrder, send_to_kitchen, print, null, null, false, null, delivery, null, platform_order, print_platform_order);
    }

    public void orderAttente(boolean printQr, TicketInfo ticket, boolean onlineOrder, boolean send_to_kitchen, boolean print, List<Integer> ids_tickets_borne, List<TicketLineInfo> oldLines, boolean caisse_order, List<TicketLineInfo> linesdeleted, boolean delivery, List<Integer> ids_tickets_kitchen, boolean platform_order, boolean print_platform_order) {
        if (ticket.getLinesCount() > 0) {
            try {
                boolean add_ticket = this.validOrder(false, ticket, null, send_to_kitchen, null, null, print, null, oldLines, linesdeleted, "pending", onlineOrder, delivery, ids_tickets_kitchen);
                if (add_ticket) {
                    if (ticket.getSent_from() != null && ticket.getSent_from().equalsIgnoreCase("Dishop")) {
                        this.changeStatusOrderDishop(ticket.getId_online_order());
                    }
                    TicketInfo ticketToSend = (TicketInfo)ticket.clone();
                    this.sendAndPrintOrder(ticketToSend, caisse_order, send_to_kitchen, print, linesdeleted, true, printQr, false, null, false, false, false, platform_order, print_platform_order);
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void printTicketQr(TicketInfo ticket, int id_order) {
        try {
            BufferedImage result = null;
            result = id_order != 0 ? QrCodeHelper.orderToImageQrCode(null, null, id_order) : QrCodeHelper.orderToImageQrCode(ticket, "caisse", -1);
            MarqueNFC marqueNF = this.dlSales.getMarqueNF();
            EnteteInfo entetTicket = new EnteteInfo("", "0", "10.0.1.27", 0, marqueNF.getCompany(), marqueNF.getAdresse1(), marqueNF.getZipCode(), marqueNF.getCity(), marqueNF.getCountry(), marqueNF.getSiret(), marqueNF.getCodeNAF(), marqueNF.getIntraTVA(), ticket.getDate(), "Commande", ticket.getLinesCount(), ticket.getId(), AppLocal.header, AppLocal.footer, "pending", "", "1", "BIBORNE", this.getIdUser(), true, true, "impression papier", 0, this.getNamrUser());
            PrinterHelper printer = new PrinterHelper();
            Decreaser decreaser = new Decreaser(this.dlSales, ticket.getId(), "Commande", null, ticket.getNumero_order());
            printer.printTicketQRBarCode(ticket, entetTicket, 1L, result, decreaser, false, null);
        }
        catch (Exception ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
        }
    }

    public Object[] getInfoZTickets(List<TicketInfo> tickets) {
        Object[] result = new Object[7];
        double turnover = 0.0;
        int number_orders = tickets.size();
        double turnover_order_At_Spot = 0.0;
        double turnover_order_Take_Away = 0.0;
        double total_tax = 0.0;
        int number_cb = number_orders;
        HashMap<String, TaxeLine> taxeLines = new HashMap<String, TaxeLine>();
        for (TicketInfo ticket : tickets) {
            turnover += ticket.getTotalOrder();
            if (ticket.getType() != null) {
                if (ticket.getType().equalsIgnoreCase("Sur Place")) {
                    turnover_order_At_Spot += ticket.getTotalOrder();
                } else {
                    turnover_order_Take_Away += ticket.getTotalOrder();
                }
            }
            for (TicketLineInfo line : ticket.getLines()) {
                if (line.getTaxInfo() == null) continue;
                Double ht = line.getPrice() * line.getMultiply() / (1.0 + line.getTaxRate());
                line.setHtAmount(ht);
                line.setTaxAmount(line.getPrice() * line.getMultiply() - ht);
                total_tax += line.getTaxAmount();
                if (taxeLines.get(line.getTaxInfo().getId()) == null) {
                    taxeLines.put(line.getTaxInfo().getId(), new TaxeLine(line.getTaxInfo().getId(), line.getTaxInfo().getName(), line.getTaxInfo().getRate(), line.getPrice(), line.getHtAmount(), line.getTaxAmount()));
                    continue;
                }
                ((TaxeLine)taxeLines.get(line.getTaxInfo().getId())).setHt(((TaxeLine)taxeLines.get(line.getTaxInfo().getId())).getHt() + line.getHtAmount());
                ((TaxeLine)taxeLines.get(line.getTaxInfo().getId())).setTotal(((TaxeLine)taxeLines.get(line.getTaxInfo().getId())).getTotal() + line.getPrice());
                ((TaxeLine)taxeLines.get(line.getTaxInfo().getId())).setTax(((TaxeLine)taxeLines.get(line.getTaxInfo().getId())).getTax() + line.getTaxAmount());
            }
        }
        ArrayList taxes = new ArrayList();
        taxes.addAll(taxeLines.values());
        result[0] = turnover;
        result[1] = number_orders;
        result[2] = turnover_order_At_Spot;
        result[3] = turnover_order_Take_Away;
        result[4] = number_cb;
        result[5] = total_tax;
        result[6] = taxes;
        return result;
    }

    public void setMPopUpTicketDateError(Scene scene) {
        if (this.mPopUpTicketDateError == null) {
            this.mPopUpTicketDateError = new PopUpTicketDateError(scene, new Stage());
        }
    }

    public void alert() {
        Platform.runLater(() -> this.mPopUpTicketDateError.show());
    }

    public boolean isValidPeriod() {
        if (!this.dlSales.isValidPeriod()) {
            this.alert();
            return false;
        }
        return true;
    }

    public boolean isValidPeriodWithoutAlert() {
        return this.dlSales.isValidPeriod();
    }

    private void printTicketCaisse(PrinterHelper printer, TicketInfo tikcetToSendToPrinter, boolean openDrawer, EnteteInfo enteteTicket, String holder_ticket, boolean print_ticket, boolean ticket_delivery, String restitution_ticket_type, String email_customer) {
        if (AppLocal.MODULE_MEV) {
            if (!AppLocal.CONNECT_CASH_DRAWER && !AppLocal.CONTINUITY_MODE_MEV) {
                this.mEVService.buildAndSendDrawerRequest();
            }
            this.mEVService.closeReceipt(tikcetToSendToPrinter);
        } else if (AppLocal.MODULE_TVA_GLOBAL) {
            try {
                MarqueNFC marqueNF = MarqueNFC.fetchOrStore(this.dlSales);
                Decreaser decreaser = new Decreaser(AppLocal.dlSales, tikcetToSendToPrinter.getId(), "TICKET", null, tikcetToSendToPrinter.getNumero_order());
                printer.printTicketContinuityMode(tikcetToSendToPrinter, "N", "N", "RFER", decreaser, marqueNF);
            }
            catch (BasicException ex) {
                LogToFile.log("severe", null, ex);
            }
        } else {
            BufferedImage result = null;
            tikcetToSendToPrinter.setTotal(tikcetToSendToPrinter.getTotal());
            Decreaser decreaser = new Decreaser(this.dlSales, tikcetToSendToPrinter.getId(), "TICKET", null, tikcetToSendToPrinter.getNumero_order());
            decreaser.setRestitution_ticket_type(restitution_ticket_type);
            if (restitution_ticket_type != null && restitution_ticket_type.equalsIgnoreCase("send email")) {
                SendETicketHelper sendETicketHelper = new SendETicketHelper();
                sendETicketHelper.sendETicket(tikcetToSendToPrinter.getNumero_order(), tikcetToSendToPrinter, enteteTicket, openDrawer, result, decreaser, holder_ticket, email_customer, null);
            } else if (AppLocal.printerCaisse.getNumber() > 0 && print_ticket) {
                printer.printCaisseTickets(tikcetToSendToPrinter.getNumero_order(), tikcetToSendToPrinter, enteteTicket, openDrawer, result, decreaser, holder_ticket);
                int number_print = AppLocal.printerCaisse.getNumber();
                for (int i = 0; i < number_print - 1; ++i) {
                    try {
                        EnteteInfo entetTicket = this.dlSales.getEnteteByTicket(tikcetToSendToPrinter.getId(), tikcetToSendToPrinter.isPaid());
                        UserInfo user = this.getCurrentUser();
                        this.printDuplicata(tikcetToSendToPrinter, printer, entetTicket, user.getId(), holder_ticket, null);
                        continue;
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", null, ex);
                    }
                }
            } else {
                try {
                    Journal.writeToJET(new Event(150, "Imprimante indisponible ", "", "identifiant d'imprimante - message", new Date().getTime(), AppLocal.printerCaisse.getName() + " - echec d'impression"));
                }
                catch (IOException ex) {
                    LogToFile.log("severe", null, ex);
                }
            }
        }
    }

    private void sendOrderToKitchenUsingRMI(final TicketInfo ticketToSendToDisplay, final TicketInfo tikcetToSendToPrinter) {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List<PrinterInfo> displayKitchens = TicketService.this.dlSales.getDisplayKitchens();
                    for (PrinterInfo displayKitchen : displayKitchens) {
                        AddOrderInterface remotObject;
                        ticketToSendToDisplay.getLines().clear();
                        int numline = 0;
                        for (TicketLineInfo line : tikcetToSendToPrinter.getLines()) {
                            if (line.isNext()) {
                                ticketToSendToDisplay.getLines().add(line);
                                continue;
                            }
                            if (line.isDiver() || TicketService.this.dlSales.getProductInfoById(line.getProductID()).getDisplayKitchen() != displayKitchen.getId()) continue;
                            line.getIngredientsInclus();
                            line.setPaid(true);
                            line.setNumLine(++numline);
                            ticketToSendToDisplay.getLines().add(line);
                        }
                        ticketToSendToDisplay.setNumberline2(numline);
                        if (ticketToSendToDisplay.getLines().size() <= 0 || (remotObject = TicketService.this.getRemoteAddOrder(displayKitchen, ticketToSendToDisplay)) == null) continue;
                        remotObject.addOrderKitchen(ticketToSendToDisplay);
                    }
                }
                catch (BasicException | RemoteException ex) {
                    if (AppVarUtils.ERRONEOUS_TICKETS_DK == null) {
                        AppVarUtils.ERRONEOUS_TICKETS_DK = new HashMap<String, TicketInfo>();
                    }
                    AppVarUtils.ERRONEOUS_TICKETS_DK.put(ticketToSendToDisplay.getId(), ticketToSendToDisplay);
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        });
    }

    private void prepareUpdateLines(TicketInfo ticket, List<TicketLineInfo> linesUpdated) throws BasicException {
        for (TicketLineInfo line : ticket.getLines()) {
            Object printerTmp;
            int found;
            TicketLineInfo oldLine;
            if (line.isNext() || line.isDiver() || !line.isSend_kitchen() || (oldLine = this.getLineByIdTemp(line.getId_temp())) == null) continue;
            boolean change_line = false;
            for (ProductTicket productTicket : line.getListProducts()) {
                found = -1;
                for (ProductTicket productTicket2 : oldLine.getListProducts()) {
                    if (productTicket.getIdProduct() != productTicket2.getIdProduct()) continue;
                    found = 1;
                }
                if (found != -1) continue;
                change_line = true;
                if (productTicket.getPrinterID() == -1) continue;
                printerTmp = this.dlSales.getPrinterByID(productTicket.getPrinterID());
                this.addPrinter((PrinterInfo)printerTmp);
            }
            for (ProductTicket productTicket : oldLine.getListProducts()) {
                found = -1;
                for (ProductTicket productTicket3 : line.getListProducts()) {
                    if (productTicket3.getIdProduct() != productTicket.getIdProduct()) continue;
                    found = 1;
                }
                if (found != -1) continue;
                change_line = true;
                if (productTicket.getPrinterID() == -1) continue;
                printerTmp = this.dlSales.getPrinterByID(productTicket.getPrinterID());
                this.addPrinter((PrinterInfo)printerTmp);
            }
            for (ItemOrderInfo itemOrderInfo : line.getListIngredients()) {
                found = -1;
                for (ItemOrderInfo itemOrderInfo2 : oldLine.getListIngredients()) {
                    if (itemOrderInfo.getIdCarte() != itemOrderInfo2.getIdCarte() || itemOrderInfo.getIdProduct() != itemOrderInfo2.getIdProduct() || itemOrderInfo.getSupplement() != itemOrderInfo2.getSupplement()) continue;
                    found = 1;
                }
                if (found != -1) continue;
                change_line = true;
            }
            for (ItemOrderInfo itemOrderInfo : oldLine.getListIngredients()) {
                found = -1;
                for (ItemOrderInfo itemOrderInfo3 : line.getListIngredients()) {
                    if (itemOrderInfo3.getIdCarte() != itemOrderInfo.getIdCarte() || itemOrderInfo3.getIdProduct() != itemOrderInfo.getIdProduct() || itemOrderInfo3.getSupplement() != itemOrderInfo.getSupplement()) continue;
                    found = 1;
                }
                if (found != -1) continue;
                change_line = true;
            }
            for (OptionItemOrder optionItemOrder : line.getListSupplements()) {
                found = -1;
                int number = 0;
                for (OptionItemOrder itemOrder : oldLine.getListSupplements()) {
                    if (optionItemOrder.getIdCarte() != itemOrder.getIdCarte() || optionItemOrder.getIdProduct() != itemOrder.getIdProduct() || optionItemOrder.getSupplement() != itemOrder.getSupplement()) continue;
                    found = 1;
                    number = itemOrder.getNumberOption();
                }
                if (found == -1) {
                    change_line = true;
                    continue;
                }
                if (number == optionItemOrder.getNumberOption()) continue;
                change_line = true;
            }
            for (OptionItemOrder optionItemOrder : oldLine.getListSupplements()) {
                found = -1;
                for (OptionItemOrder optionItemOrder2 : line.getListSupplements()) {
                    if (optionItemOrder2.getIdCarte() != optionItemOrder.getIdCarte() || optionItemOrder2.getIdProduct() != optionItemOrder.getIdProduct() || optionItemOrder2.getSupplement() != optionItemOrder.getSupplement()) continue;
                    found = 1;
                }
                if (found != -1) continue;
                change_line = true;
            }
            if (!change_line) continue;
            ProductInfoExt productTmp = CacheFinder.findProductInfoById(this.mSharedMemoryCache, this.dlSales, line.getProductID());
            if (productTmp.getPrinterID() != -1) {
                line.setPrinterID(productTmp.getPrinterID());
                PrinterInfo printerInfo = this.dlSales.getPrinterByID(productTmp.getPrinterID());
                this.addPrinter(printerInfo);
            }
            this.setLineDescription(line);
            linesUpdated.add((TicketLineInfo)line.clone());
        }
    }

    private void addPrinter(PrinterInfo printerTmp) {
        int found = -1;
        for (PrinterInfo printer : this.printers) {
            if (printer.getId() != printerTmp.getId()) continue;
            found = 1;
        }
        if (found == -1) {
            this.printers.add(printerTmp);
        }
    }

    private TicketLineInfo getLineByIdTemp(int id_tmp) {
        if (this.oldLines != null) {
            for (TicketLineInfo line : this.oldLines) {
                if (line.getId_temp() != id_tmp) continue;
                return line;
            }
        }
        return null;
    }

    public void printTicketCaisse(TicketInfo ticketToPrinter, boolean print_ticket, String holder_ticket, String restitution_ticket_type, String email_customer) {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        exec.execute(() -> {
            if (AppLocal.MODULE_MEV) {
                if (!AppLocal.CONNECT_CASH_DRAWER && !AppLocal.CONTINUITY_MODE_MEV) {
                    this.mEVService.buildAndSendDrawerRequest();
                }
                this.mEVService.closeReceipt(ticketToPrinter);
            } else if (AppLocal.MODULE_TVA_GLOBAL) {
                try {
                    PrinterHelper printer = new PrinterHelper();
                    MarqueNFC marqueNF = MarqueNFC.fetchOrStore(this.dlSales);
                    Decreaser decreaser = new Decreaser(AppLocal.dlSales, ticketToPrinter.getId(), "TICKET", null, ticketToPrinter.getNumero_order());
                    printer.printTicketContinuityMode(ticketToPrinter, "N", "N", "RFER", decreaser, marqueNF);
                }
                catch (BasicException ex) {
                    LogToFile.log("severe", null, ex);
                }
            } else {
                try {
                    Decreaser decreaser = new Decreaser(this.dlSales, ticketToPrinter.getId(), "TICKET", null, ticketToPrinter.getNumero_order());
                    decreaser.setRestitution_ticket_type(restitution_ticket_type);
                    EnteteInfo entetTicket = this.dlSales.getEnteteByTicket(ticketToPrinter.getId(), ticketToPrinter.isPaid());
                    if (restitution_ticket_type != null && restitution_ticket_type.equalsIgnoreCase("send email")) {
                        SendETicketHelper sendETicketHelper = new SendETicketHelper();
                        sendETicketHelper.sendETicket(ticketToPrinter.getNumero_order(), ticketToPrinter, entetTicket, false, null, decreaser, holder_ticket, email_customer, null);
                    } else if (AppLocal.printerCaisse.getNumber() > 0 && print_ticket) {
                        PrinterHelper printer = new PrinterHelper();
                        printer.printRappelTickets(ticketToPrinter.getNumero_order(), ticketToPrinter, entetTicket, 0L, decreaser, false, holder_ticket, null, false);
                        int n = printer.getNombreLignesInCammande();
                    } else {
                        Journal.writeToJET(new Event(150, "Imprimante indisponible ", "", "identifiant d'imprimante - message", new Date().getTime(), AppLocal.printerCaisse.getName() + " - echec d'impression"));
                    }
                }
                catch (BasicException | IOException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        });
    }

    public void printAvoir(final TicketInfo tikcetToPrintAvoir, final EnteteInfo enteteTicket) {
        for (final PaymentInfo paymentInfo : tikcetToPrintAvoir.getPayments()) {
            if (!paymentInfo.getName().equals("Avoir") || !(paymentInfo.getTotal() < 0.0)) continue;
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    PrinterHelper printer = new PrinterHelper();
                    Decreaser decreaser = new Decreaser(TicketService.this.dlSales, tikcetToPrintAvoir.getId(), "Ticket Avoir", null, tikcetToPrintAvoir.getNumero_order());
                    TicketAvoir ticketAvoir = TicketService.this.avoirService.addTicketAvoir(paymentInfo.getTotal(), TicketService.this.avoirService.getDateExpire(), paymentInfo.getOrigin(), tikcetToPrintAvoir.getId());
                    BufferedImage qrCodeImage = QrCodeHelper.stringToImageQrCode(ticketAvoir.getBarCode());
                    printer.printAvoir(-1.0 * paymentInfo.getTotal(), enteteTicket, ticketAvoir, qrCodeImage, decreaser);
                }
            });
        }
    }

    private void sendStats(final TicketInfo ticketTracked) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                TicketService.this.mPostgreService = PostgreService.getInstance();
                TicketService.this.mPostgreService.doSynchronizeOrderData(10, ticketTracked);
                TicketService.this.mPostgreService.SendDataToPostgree();
            }
        }).start();
    }

    public void sendAndPrintOrder(TicketInfo ticket, final boolean openDrawer, final boolean caisse_order, boolean send_to_kitchen, boolean printKitchen, final boolean cb_borne, final List<TicketLineInfo> lines_to_deletes, final boolean first_part_of_order, final String holder_ticket, String source_order, boolean add_payment, String type_payment, final boolean print_ticket, final boolean ticket_delivery, boolean updateOrderKitchen, final String restitution_ticket_type, final String email_customer) throws BasicException {
        ticket.setHolder(holder_ticket);
        TicketInfo ticketTracked = (TicketInfo)ticket.clone();
        TicketInfo ticketToSendToDisplay = (TicketInfo)ticket.clone();
        final TicketInfo tikcetToSendToPrinter = (TicketInfo)ticket.clone();
        TicketInfo tikcetToSendToLabelPrinter = (TicketInfo)ticket.clone();
        TicketInfo tikcetToPrintAvoir = (TicketInfo)ticket.clone();
        final TicketInfo tikcetToSendToPrinterLater = (TicketInfo)ticket.clone();
        final TicketInfo tikcetToSendToPrinterKitchen = (TicketInfo)ticket.clone();
        final EnteteInfo enteteTicket = this.dlSales.getEnteteByTicket(ticket.getId(), true);
        final PrinterHelper printer = new PrinterHelper();
        ExecutorService exec = Executors.newSingleThreadExecutor();
        exec.execute(new Runnable(){

            @Override
            public void run() {
                TicketService.this.printTicketCaisse(printer, tikcetToSendToPrinter, openDrawer, enteteTicket, holder_ticket, print_ticket, ticket_delivery, restitution_ticket_type, email_customer);
                try {
                    if (AppLocal.PRINT_NUM_ORDER && caisse_order) {
                        Decreaser decreaserNumOrder = new Decreaser(TicketService.this.dlSales, tikcetToSendToPrinter.getId(), "Ticket Numero commande", null, tikcetToSendToPrinter.getNumero_order());
                        printer.printNumOrder(tikcetToSendToPrinter, decreaserNumOrder);
                    }
                    int decreaserNumOrder = printer.getNombreLignesInCammande();
                }
                catch (Exception ex) {
                    LogToFile.log("sever", ex.getMessage(), ex);
                }
                TicketService.this.printPlusTardTickets(enteteTicket, tikcetToSendToPrinterLater);
            }
        });
        if (AppLocal.PRINT_RECAP || AppLocal.PRINT_RECAP_DELIVERY && tikcetToSendToPrinter.getType() != null && tikcetToSendToPrinter.getType().equalsIgnoreCase("En Livraison")) {
            Executors.newSingleThreadExecutor().execute(() -> this.printRecap(ticketToSendToDisplay, cb_borne));
        }
        if (send_to_kitchen) {
            if (AppLocal.KITCHEN_COMPOSITE) {
                System.out.println("source_order**************************** : " + source_order);
                this.sendOrderToKitchen(ticketToSendToDisplay, source_order, add_payment, type_payment, false, false, false, cb_borne);
            } else {
                this.sendOrderToKitchenUsingRMI(ticketToSendToDisplay, tikcetToSendToPrinter);
            }
        } else if (AppLocal.KITCHEN_COMPOSITE) {
            if (updateOrderKitchen) {
                this.updateKitchenScreenOrder(ticketToSendToDisplay);
            } else if (ticketToSendToDisplay.getStatus() != null && ticketToSendToDisplay.getStatus().equalsIgnoreCase("paid")) {
                try {
                    this.sendPaidOrderNotification(ticketToSendToDisplay.getId_shared_order());
                }
                catch (Exception ex) {
                    LogToFile.log("sever", ex.getMessage(), ex);
                }
            }
        }
        if (printKitchen) {
            if (!(cb_borne && AppLocal.KITCHEN_COMPOSITE && AppLocal.SAVE_ORDER_SLAVE)) {
                Executors.newSingleThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        TicketService.this.printKitchen(tikcetToSendToPrinterKitchen, cb_borne, lines_to_deletes, first_part_of_order, true);
                    }
                });
            }
            if (send_to_kitchen) {
                Executors.newSingleThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        if (!(AppLocal.PRINT_LABEL_TAKE_AWAY && !tikcetToSendToPrinter.getType().equals("A Emporter") || AppLocal.PRINT_LABEL_PRODUCT_WITH_EXCLUDED_INFREDIENT && !tikcetToSendToPrinter.hasProductWithExludedIngredient())) {
                            TicketService.this.printLabel(tikcetToSendToPrinter);
                        }
                    }
                });
            }
        }
        if (AppLocal.print_avoir.booleanValue()) {
            this.printAvoir(tikcetToPrintAvoir, enteteTicket);
        }
        if (AppLocal.IS_STATS_ONLINE_ENABLED.booleanValue()) {
            this.sendStats(ticketTracked);
        }
        this.sendUsedPromocode(ticket);
    }

    public void loadInfoTicket(TicketInfo ticket, boolean printKitchen, List<PaymentInfo> payments, String status_order) throws BasicException {
        this.prepareLines(ticket, ticket.getType());
        if (ticket.getTotal() >= 0.0) {
            ticket.resetPayments();
        }
        for (TicketLineInfo line : ticket.getLines()) {
            List<SupplementItemInfo> ingrediens = this.dlSales.getIngredientsByProducts(line.getProductID(), true, false);
            line.setListIngredientsIN(ingrediens);
        }
        if (status_order != null && status_order.equalsIgnoreCase("paid")) {
            ticket.setPayments(PaymentUtils.getPaymentToSave(payments, ticket));
        }
        if (this.m_App.getAppUserView() != null && this.m_App.getAppUserView().getUser() != null) {
            ticket.setUser(this.m_App.getAppUserView().getUser().getUserInfo());
        } else {
            UserInfo userInfo = new UserInfo(AppLocal.user != null ? AppLocal.user : AppLocal.user_maintenance);
            ticket.setUser(userInfo);
        }
        ticket.setActiveCash(AppLocal.m_sActiveCashIndex);
        if (ticket.getSent_from() == null || !ticket.getSent_from().equals("Dishop") || !ticket.isPlatform_order()) {
            ticket.setDate(new Date());
        }
        if (AppLocal.CUSTOMER_LOYALTY && AppLocal.currentCustomerLoyalty != null && AppLocal.currentCustomerLoyalty.getPhone() != null && !AppLocal.currentCustomerLoyalty.getPhone().isEmpty()) {
            if (ticket.getCustomer() == null) {
                this.setCustomerTicket(ticket, AppLocal.currentCustomerLoyalty.getPhone());
            }
            if (ticket.getCustomer_loyalty_id() == null) {
                ticket.setCustomer_loyalty_id(AppLocal.CUSTOMER_LOYALTY_ID);
            }
        } else if (ticket.getCustomer() != null && ticket.getCustomer().getId() == null) {
            this.setCustomerTicket(ticket, ticket.getCustomerPhone());
        }
    }

    private boolean persistTicket(TicketInfo ticket, HashMap<Integer, TicketResto> ticketsRestau, boolean send_to_kitchen, List<Integer> ids_tickets_borne, Map<Integer, TicketAvoir> ticketsAvoirs, String status_order, boolean onlineOrder, boolean delivery, List<Integer> ids_tickets_kitchen) throws BasicException, SQLException {
        boolean serveur = true;
        boolean add_ticket = false;
        if (status_order != null && status_order.equalsIgnoreCase("paid")) {
            if (AppLocal.IS_STATS_ONLINE_ENABLED.booleanValue()) {
                this.mPostgreService = PostgreService.getInstance();
                this.mPostgreService.setSynchronizing(false);
            }
            ticket.setStatus("paid");
            System.out.println("++++++++++++ start add ticket ********************************: " + new Date());
            add_ticket = this.dlSales.saveTicket(ticket, null, 0, serveur, false, ticketsRestau);
            System.out.println("++++++++++++ end add ticket ******************************* : " + new Date());
            ticket.setPaid(true);
            this.increaseCreditCustomer(ticket);
        } else {
            if (!(onlineOrder || delivery || ticket.getType() != null && ticket.getSent_from() != null && (ticket.getType().equals("Commande en ligne") || ticket.getType().equals("Dishop") || ticket.getSent_from().equals("Dishop")))) {
                ticket.setAddress(-1);
            }
            add_ticket = this.dlSales.saveTicketAttente(ticket, null, serveur);
        }
        if (add_ticket && (ticket.getType() == null || !ticket.getType().equals("Commande en ligne"))) {
            if (onlineOrder && delivery) {
                this.dlSales.deliverTicket(ticket.getId());
                this.dlSales.disburseTicket(ticket);
            }
            if (AppLocal.KITCHEN_COMPOSITE && send_to_kitchen) {
                int num_order_kitchen = -1;
                try {
                    num_order_kitchen = this.getLastNumOrder();
                }
                catch (Exception e) {
                    LogToFile.log("severe", e.getMessage(), e);
                }
                ticket.setNum_order_kitchen(num_order_kitchen);
                this.dlSales.setNumOrderKitchen(ticket);
            }
            if (AppLocal.KITCHEN_COMPOSITE) {
                this.validSharedOrder(ticket, ids_tickets_borne);
            }
            if (AppLocal.KITCHEN_COMPOSITE && !send_to_kitchen) {
                this.dlOrder.addInfoKitchenToOrder(ticket.getId(), ticket.getId_order_kitchen());
                if (ids_tickets_kitchen != null) {
                    this.orderService.setIdTicketCaisse(ids_tickets_kitchen, ticket.getId());
                    this.orderService.updateOrders(ticket);
                } else {
                    this.orderService.setIdTicketCaisse(ticket.getId_order_kitchen(), ticket.getId());
                }
                if (status_order != null && status_order.equalsIgnoreCase("paid")) {
                    this.paidOrderByTicket(ticket.getId(), ticket.getId_shared_order(), false);
                }
            }
            if (status_order != null && status_order.equalsIgnoreCase("paid")) {
                PaymentUtils.updateStatusAvoir(this.dlOrder, ticketsAvoirs);
            }
        }
        return add_ticket;
    }

    public boolean validOrder(boolean openDrawer, TicketInfo ticket, HashMap<Integer, TicketResto> ticketsRestau, boolean send_to_kitchen, List<Integer> ids_tickets_borne, Map<Integer, TicketAvoir> ticketsAvoirs, boolean printKitchen, List<PaymentInfo> payments, List<TicketLineInfo> oldLines, List<TicketLineInfo> linesdeleted, String status_order, boolean onlineOrder, boolean delivery, List<Integer> ids_tickets_kitchen) throws BasicException, SQLException {
        if (openDrawer && (!AppLocal.MODULE_MEV || AppLocal.CONTINUITY_MODE_MEV || AppLocal.CONNECT_CASH_DRAWER)) {
            this.openDrawer();
        }
        this.oldLines = oldLines;
        this.linesdeleted = linesdeleted;
        this.loadInfoTicket(ticket, printKitchen, payments, status_order);
        boolean add_ticket = this.persistTicket(ticket, ticketsRestau, send_to_kitchen, ids_tickets_borne, ticketsAvoirs, status_order, onlineOrder, delivery, ids_tickets_kitchen);
        System.out.println("add_ticket : " + add_ticket);
        if (add_ticket && ticket.getSent_from() != null && ticket.getSent_from().equalsIgnoreCase("Dishop")) {
            this.changeStatusOrderDishop(ticket.getId_online_order());
        }
        return add_ticket;
    }

    public TableInfo checkAvailability(int num_table) throws BasicException {
        TicketInfo ticketTmp;
        TableInfo table = this.dlItems.getTableByName(num_table);
        if (table != null && (ticketTmp = this.dlSales.checktable(table.getId())) == null) {
            return table;
        }
        return null;
    }

    public void sendAndPrintOrder(final TicketInfo ticket, boolean caisse_order, boolean send_to_kitchen, boolean print, List<TicketLineInfo> lines_to_deletes, boolean first_part_of_order, boolean printQr, boolean save_shared_order, String source_order, boolean exterior_order, boolean update_order_kitchen, boolean disableUpdateOrderKitchen, boolean platform_order, boolean print_platform_ticket) throws BasicException {
        System.out.println("****sendAndPrintOrder");
        TicketInfo ticketToSendToDisplay = (TicketInfo)ticket.clone();
        TicketInfo tikcetToSendToPrinter = (TicketInfo)ticket.clone();
        TicketInfo tikcetToSendToLabelPrinter = (TicketInfo)ticket.clone();
        PrinterHelper printer = new PrinterHelper();
        boolean print_note = false;
        if (platform_order) {
            print_note = print_platform_ticket;
        } else {
            boolean bl = print_note = AppLocal.PRINT_TICKET_PENDING && (tikcetToSendToPrinter.getType() == null || !tikcetToSendToPrinter.getType().equals("En Livraison"));
        }
        if (print_note) {
            this.dlSales.addEnteteNoteAfterPrint(ticket);
            final EnteteInfo enteteTicket = this.dlSales.getEnteteByTicket(ticket.getId(), ticket.isPaid());
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    PrinterHelper printer = new PrinterHelper();
                    Decreaser decreaser = new Decreaser(TicketService.this.dlSales, ticket.getId(), "COMMANDE", null, ticket.getNumero_order());
                    printer.printRappelTickets(ticket.getNumero_order(), ticket, enteteTicket, 0L, decreaser);
                }
            });
        }
        if (tikcetToSendToPrinter.getType() != null && tikcetToSendToPrinter.getType().equals("En Livraison")) {
            Executors.newSingleThreadExecutor().execute(() -> this.printLivraisonTickets(tikcetToSendToPrinter));
        }
        if (AppLocal.PRINT_RECAP || AppLocal.PRINT_RECAP_DELIVERY && tikcetToSendToPrinter.getType() != null && tikcetToSendToPrinter.getType().equalsIgnoreCase("En Livraison")) {
            Executors.newSingleThreadExecutor().execute(() -> this.printRecap(ticketToSendToDisplay, false));
        }
        if (send_to_kitchen) {
            if (AppLocal.KITCHEN_COMPOSITE) {
                this.sendOrderToKitchen(ticketToSendToDisplay, source_order, false, null, exterior_order, printQr, true, false);
            } else {
                this.sendOrderToKitchenUsingRMI(ticketToSendToDisplay, tikcetToSendToPrinter);
                if (printQr) {
                    Executors.newSingleThreadExecutor().execute(() -> this.printTicketQr(tikcetToSendToPrinter, 0));
                }
            }
        } else {
            if (update_order_kitchen && AppLocal.KITCHEN_COMPOSITE) {
                this.updateKitchenScreenOrder(ticketToSendToDisplay);
            }
            if (disableUpdateOrderKitchen && AppLocal.KITCHEN_COMPOSITE) {
                this.disableUpdate(ticketToSendToDisplay.getId_order_kitchen());
            }
        }
        if (print) {
            Executors.newSingleThreadExecutor().execute(() -> {
                this.printKitchen(tikcetToSendToPrinter, false, lines_to_deletes, first_part_of_order, true);
                if (!(AppLocal.PRINT_LABEL_TAKE_AWAY && !tikcetToSendToPrinter.getType().equals("A Emporter") || AppLocal.PRINT_LABEL_PRODUCT_WITH_EXCLUDED_INFREDIENT && !tikcetToSendToPrinter.hasProductWithExludedIngredient())) {
                    this.printLabel(tikcetToSendToPrinter);
                }
            });
        }
        if (!send_to_kitchen || !AppLocal.KITCHEN_COMPOSITE) {
            AppLocal.currentCustomerLoyalty = null;
        }
        if (platform_order && AppLocal.IS_STATS_ONLINE_ENABLED.booleanValue()) {
            TicketInfo ticketTracked = (TicketInfo)ticket.clone();
            this.sendStats(ticketTracked);
        }
    }

    public void printKitchenTicketCanceld(TicketInfo tikcetToSend) {
        Decreaser decreaser = new Decreaser(this.dlSales, tikcetToSend.getId(), "Ticket cuisine", null, tikcetToSend.getNumero_order());
        LinkedHashMap<Integer, List<ZoneLines>> zoneLinesByPrinter = this.getZoneLinesByPrinter(this.printers, this.productToSend);
        new PrinterHelper().printKitchenTicketCanceld(tikcetToSend, this.printers, zoneLinesByPrinter, AppLocal.DISPLAY_NUM_ORDER, AppLocal.DISPLAY_NAME_SERVER, decreaser);
    }

    public void prepareTicketCuisineMAJ1(TicketInfo ticket) {
        this.printers.clear();
        this.productToSend.clear();
        this.productEMP.clear();
        this.productEmpLater.clear();
        this.productSpLater.clear();
        this.listDelete.clear();
        for (TicketLineInfo line : ticket.getLines()) {
            if (line.isDiver()) continue;
            if (!line.isNext()) {
                if (line.getID() == -1 && line.getId_source() == 0) {
                    boolean sendProduct = false;
                    try {
                        ProductInfoExt productTmp = CacheFinder.findProductInfoById(this.mSharedMemoryCache, this.dlSales, line.getProductID());
                        if (productTmp.getPrinterID() != -1) {
                            sendProduct = true;
                            line.setPrinterID(productTmp.getPrinterID());
                            line.setPrint_ingredients(productTmp.isPrint_ingredients());
                            PrinterInfo printerTmp = this.dlSales.getPrinterByID(productTmp.getPrinterID());
                            this.addPrinter(printerTmp);
                        }
                        boolean addSubItemsLater = false;
                        for (OptionItemOrder optionItemOrder : line.getListSupplements()) {
                            if (optionItemOrder.getId_sub_product() == 0 || optionItemOrder.getTime_served() == null || !optionItemOrder.getTime_served().equalsIgnoreCase("later")) continue;
                            addSubItemsLater = true;
                            break;
                        }
                        if (addSubItemsLater) {
                            ArrayList options = new ArrayList();
                            for (OptionItemOrder optionItemOrder : line.getListSupplements()) {
                                ProductInfoExt subProduct;
                                boolean added_as_item = false;
                                if (optionItemOrder.getId_sub_product() != 0 && optionItemOrder.getTime_served() != null && optionItemOrder.getTime_served().equalsIgnoreCase("later") && (subProduct = this.dlItems.getProductInfoById(optionItemOrder.getId_sub_product())) != null) {
                                    added_as_item = true;
                                    ProductTicket productTicket = new ProductTicket(subProduct, -1, null, optionItemOrder.getNumberOption(), -1, null, subProduct.getRef_web(), null, null);
                                    productTicket.setTime_served("later");
                                }
                                if (added_as_item) continue;
                                options.add(optionItemOrder);
                            }
                            line.setListSupplements(options);
                        }
                        for (ProductTicket productTicket : line.getListProducts()) {
                            if (productTicket.getPrinterID() == -1) continue;
                            sendProduct = true;
                            PrinterInfo printerInfo = this.dlSales.getPrinterByID(productTicket.getPrinterID());
                            this.addPrinter(printerInfo);
                        }
                        if (!sendProduct) continue;
                        line.setTypeUpdate("add");
                        this.setLineDescription(line);
                        this.productToSend.add(line);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                    continue;
                }
                try {
                    ProductInfoExt productTmp;
                    for (ProductTicket product2 : line.getListProducts()) {
                        int foundOption;
                        int foundIngredient;
                        int found = -1;
                        for (ProductTicket productTicket : line.getOldProductsTicket()) {
                            if (product2.getIdProduct() != productTicket.getIdProduct()) continue;
                            found = 1;
                        }
                        if (found == -1) {
                            line.getListNew().add(product2);
                            if (product2.getPrinterID() == -1) continue;
                            PrinterInfo printerTmp = this.dlSales.getPrinterByID(product2.getPrinterID());
                            this.addPrinter(printerTmp);
                            continue;
                        }
                        boolean changeSupplement = false;
                        for (ItemOrderInfo itemOrderInfo : line.getListIngredients()) {
                            foundIngredient = -1;
                            for (ItemOrderInfo itemOrderInfo2 : line.getOldIngredientsTicket()) {
                                if (itemOrderInfo.getIdCarte() != itemOrderInfo2.getIdCarte() || itemOrderInfo.getIdProduct() != itemOrderInfo2.getIdProduct() || itemOrderInfo.getSupplement() != itemOrderInfo2.getSupplement()) continue;
                                foundIngredient = 1;
                            }
                            if (foundIngredient != -1 || itemOrderInfo.getIdProduct() != product2.getIdProduct()) continue;
                            changeSupplement = true;
                        }
                        for (ItemOrderInfo itemOrderInfo : line.getOldIngredientsTicket()) {
                            foundIngredient = -1;
                            for (ItemOrderInfo itemOrderInfo3 : line.getListIngredients()) {
                                if (itemOrderInfo3.getIdCarte() != itemOrderInfo.getIdCarte() || itemOrderInfo3.getIdProduct() != itemOrderInfo.getIdProduct() || itemOrderInfo3.getSupplement() != itemOrderInfo.getSupplement()) continue;
                                foundIngredient = 1;
                            }
                            if (foundIngredient != -1 || itemOrderInfo.getIdProduct() != product2.getIdProduct()) continue;
                            changeSupplement = true;
                        }
                        for (OptionItemOrder optionItemOrder : line.getListSupplements()) {
                            foundOption = -1;
                            int number = 0;
                            for (OptionItemOrder itemOrder4 : line.getOldOptionsTicket()) {
                                if (optionItemOrder.getIdCarte() != itemOrder4.getIdCarte() || optionItemOrder.getIdProduct() != itemOrder4.getIdProduct() || optionItemOrder.getSupplement() != itemOrder4.getSupplement()) continue;
                                foundOption = 1;
                                number = itemOrder4.getNumberOption();
                            }
                            if (foundOption == -1 && optionItemOrder.getIdProduct() == product2.getIdProduct()) {
                                changeSupplement = true;
                                continue;
                            }
                            if (number == optionItemOrder.getNumberOption()) continue;
                            changeSupplement = true;
                        }
                        for (OptionItemOrder optionItemOrder : line.getOldOptionsTicket()) {
                            foundOption = -1;
                            for (OptionItemOrder optionItemOrder2 : line.getListSupplements()) {
                                if (optionItemOrder2.getIdCarte() != optionItemOrder.getIdCarte() || optionItemOrder2.getIdProduct() != optionItemOrder.getIdProduct() || optionItemOrder2.getSupplement() != optionItemOrder.getSupplement()) continue;
                                foundOption = 1;
                            }
                            if (foundOption != -1 || optionItemOrder.getIdProduct() != product2.getIdProduct()) continue;
                            changeSupplement = true;
                        }
                        if (!changeSupplement) continue;
                        line.getListUpdate().add(product2);
                        if (product2.getPrinterID() == -1) continue;
                        PrinterInfo printerInfo = this.dlSales.getPrinterByID(product2.getPrinterID());
                        this.addPrinter(printerInfo);
                    }
                    for (ProductTicket productExist : line.getOldProductsTicket()) {
                        int found = -1;
                        for (ProductTicket productTicket : line.getListProducts()) {
                            if (productTicket.getIdProduct() != productExist.getIdProduct()) continue;
                            found = 1;
                        }
                        if (found != -1) continue;
                        line.getListDelete().add(productExist);
                        if (productExist.getPrinterID() == -1) continue;
                        PrinterInfo printerTmp = this.dlSales.getPrinterByID(productExist.getPrinterID());
                        this.addPrinter(printerTmp);
                    }
                    boolean change = false;
                    for (ItemOrderInfo ingredient4 : line.getListIngredients()) {
                        int found = -1;
                        for (ItemOrderInfo itemOrderInfo : line.getOldIngredientsTicket()) {
                            if (ingredient4.getIdCarte() != itemOrderInfo.getIdCarte() || ingredient4.getIdProduct() != itemOrderInfo.getIdProduct() || ingredient4.getSupplement() != itemOrderInfo.getSupplement()) continue;
                            found = 1;
                        }
                        if (found != -1) continue;
                        change = true;
                    }
                    for (ItemOrderInfo itemOrder5 : line.getOldIngredientsTicket()) {
                        int found = -1;
                        for (ItemOrderInfo itemOrderInfo : line.getListIngredients()) {
                            if (itemOrderInfo.getIdCarte() != itemOrder5.getIdCarte() || itemOrderInfo.getIdProduct() != itemOrder5.getIdProduct() || itemOrderInfo.getSupplement() != itemOrder5.getSupplement()) continue;
                            found = 1;
                        }
                        if (found != -1) continue;
                        change = true;
                    }
                    for (OptionItemOrder supplement : line.getListSupplements()) {
                        int n;
                        int found = -1;
                        boolean bl = false;
                        for (OptionItemOrder itemOrder6 : line.getOldOptionsTicket()) {
                            if (supplement.getIdCarte() != itemOrder6.getIdCarte() || supplement.getIdProduct() != itemOrder6.getIdProduct() || supplement.getSupplement() != itemOrder6.getSupplement()) continue;
                            found = 1;
                            n = itemOrder6.getNumberOption();
                        }
                        if (found == -1) {
                            change = true;
                            continue;
                        }
                        if (n == supplement.getNumberOption()) continue;
                        change = true;
                    }
                    for (OptionItemOrder itemOrder7 : line.getOldOptionsTicket()) {
                        int found = -1;
                        for (OptionItemOrder optionItemOrder : line.getListSupplements()) {
                            if (optionItemOrder.getIdCarte() != itemOrder7.getIdCarte() || optionItemOrder.getIdProduct() != itemOrder7.getIdProduct() || optionItemOrder.getSupplement() != itemOrder7.getSupplement()) continue;
                            found = 1;
                        }
                        if (found != -1) continue;
                        change = true;
                    }
                    if (line.getOldMultiply() != line.getMultiply()) {
                        line.setDifference_quantity(line.getMultiply() - line.getOldMultiply());
                        change = true;
                    }
                    boolean sendProduct = false;
                    if (change && (productTmp = CacheFinder.findProductInfoById(this.mSharedMemoryCache, this.dlSales, line.getProductID())).getPrinterID() != -1) {
                        sendProduct = true;
                        line.setPrinterID(productTmp.getPrinterID());
                        line.setPrint_ingredients(productTmp.isPrint_ingredients());
                        PrinterInfo printerTmp = this.dlSales.getPrinterByID(productTmp.getPrinterID());
                        this.addPrinter(printerTmp);
                    }
                    if (line.getListDelete().size() <= 0 && line.getListNew().size() <= 0 && line.getListUpdate().size() <= 0 && !sendProduct) continue;
                    line.setTypeUpdate("update");
                    productTmp = CacheFinder.findProductInfoById(this.mSharedMemoryCache, this.dlSales, line.getProductID());
                    if (productTmp.getPrinterID() != -1) {
                        line.setPrinterID(productTmp.getPrinterID());
                        line.setPrint_ingredients(productTmp.isPrint_ingredients());
                        PrinterInfo printerTmp = this.dlSales.getPrinterByID(productTmp.getPrinterID());
                        this.addPrinter(printerTmp);
                    }
                    this.setLineDescription(line);
                    this.productToSend.add(line);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                continue;
            }
            if (this.productToSend.size() > 0) {
                if (this.productToSend.get(this.productToSend.size() - 1).isNext()) continue;
                TicketLineInfo linePrevious = new TicketLineInfo();
                linePrevious.setNext(true);
                this.productToSend.add(linePrevious);
                continue;
            }
            TicketLineInfo linePrevious = new TicketLineInfo();
            linePrevious.setNext(true);
            this.productToSend.add(linePrevious);
        }
        try {
            for (TicketLineInfo ticketLineInfo : ticket.getOldLines()) {
                ProductInfoExt productTmp;
                if (ticketLineInfo.isDiver() || ticketLineInfo.isNext() || (productTmp = CacheFinder.findProductInfoById(this.mSharedMemoryCache, this.dlSales, ticketLineInfo.getProductID())) == null || productTmp.getPrinterID() == -1) continue;
                int found = -1;
                for (TicketLineInfo l : ticket.getLines()) {
                    if ((l.getID() == -1 || ticketLineInfo.getID() != l.getID()) && (l.getId_source() == 0 || ticketLineInfo.getId_source() != l.getId_source())) continue;
                    found = 1;
                }
                if (found != -1) continue;
                ticketLineInfo.setPrinterID(productTmp.getPrinterID());
                ticketLineInfo.setPrint_ingredients(productTmp.isPrint_ingredients());
                this.listDelete.add(ticketLineInfo);
                if (productTmp.getPrinterID() == -1) continue;
                PrinterInfo printerTmp = this.dlSales.getPrinterByID(productTmp.getPrinterID());
                this.addPrinter(printerTmp);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void printKitchenTicketsMAJ(TicketInfo ticket) {
        System.out.println("*********printKitchenTicketsMAJ");
        this.prepareTicketCuisineMAJ1(ticket);
        PrinterHelper printer = new PrinterHelper();
        Decreaser decreaser = new Decreaser(this.dlSales, ticket.getId(), "Ticket cuisine", null, ticket.getNumero_order());
        this.sortLines(ticket, this.productToSend, this.productEMP, this.productEmpLater, this.productSpLater, this.subProductLater);
        LinkedHashMap<Integer, List<ZoneLines>> zoneLinesByPrinter = this.getZoneLinesByPrinter(this.printers, this.productToSend);
        LinkedHashMap<Integer, List<ZoneLines>> zoneLinesDineInLaterByPrinter = this.getZoneLinesByPrinter(this.printers, this.productSpLater);
        LinkedHashMap<Integer, List<ZoneLines>> zoneLinesTakeAwayByPrinter = this.getZoneLinesByPrinter(this.printers, this.productEMP);
        LinkedHashMap<Integer, List<ZoneLines>> zoneLinesTakeAwayLaterByPrinter = this.getZoneLinesByPrinter(this.printers, this.productEmpLater);
        LinkedHashMap<Integer, List<ZoneLines>> zoneLinesDeletedByPrinter = this.getZoneLinesByPrinter(this.printers, this.listDelete);
        LinkedHashMap<Integer, List<ZoneItems>> zoneSubItemsLaterByPrinter = this.getZoneItemsByPrinter(this.printers, this.subProductLater);
        printer.printKitchenTicketsMAJ1(ticket, ticket.getType(), this.printers, zoneLinesByPrinter, zoneLinesDineInLaterByPrinter, zoneLinesTakeAwayByPrinter, zoneLinesTakeAwayLaterByPrinter, zoneLinesDeletedByPrinter, zoneSubItemsLaterByPrinter, AppLocal.PRINT_FOND, AppLocal.SEPARATE_OPTION, AppLocal.DISPLAY_NUM_ORDER, AppLocal.DISPLAY_NAME_SERVER, decreaser);
    }

    public void prepareLinesUpdate(TicketInfo ticket) throws BasicException, SQLException {
        if (ticket.getLinesCount() > 0) {
            this.prepareLines(ticket, ticket.getType());
            for (TicketLineInfo line : ticket.getLines()) {
                List<SupplementItemInfo> ingrediens = this.dlSales.getIngredientsByProducts(line.getProductID(), true, false);
                line.setListIngredientsIN(ingrediens);
                if (line.isDiver() || line.isNext() || line.getID() == -1 || line.getID() == 0) continue;
                line.setOldProductsTicket(this.dlSales.getProductsTicket(line.getID()));
                line.setOldIngredientsTicket(this.dlSales.getIngredientsTicket(line.getID()));
                line.setOldOptionsTicket(this.dlSales.getOptionTicket(line.getID()));
            }
        }
    }

    public void updateOrder(TicketInfo ticket, boolean only_shared_order) throws BasicException, SQLException {
        if (ticket.getTicketId() != 0 && !only_shared_order) {
            if (AppLocal.table != null) {
                if (ticket.getTable() != null) {
                    ticket.setOldTable(ticket.getTable().getId());
                }
                ticket.setTable(AppLocal.table);
            }
            ticket.setLastUpdate(new Date());
            this.dlSales.updateTicket(ticket, this.m_App.getInventoryLocation(), this.m_App.getAppUserView().getUser());
        }
    }

    public void printPaidTicketCaisse(TicketInfo ticket, EnteteInfo entetTicket, String motifif_impression) {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        exec.execute(() -> {
            PrinterHelper printer = new PrinterHelper();
            try {
                if (AppLocal.MODULE_MEV && !AppLocal.CONTINUITY_MODE_MEV) {
                    this.mEVService.duplicataTicket(ticket);
                }
                if (!entetTicket.IsTicketRestituted()) {
                    Decreaser decreaser = new Decreaser(this.dlSales, ticket.getId(), "TICKET", null, ticket.getNumero_order());
                    printer.printRappelTickets(ticket.getNumero_order(), ticket, entetTicket, 0L, decreaser);
                } else {
                    UserInfo user = this.getCurrentUser();
                    this.printDuplicata(ticket, printer, entetTicket, user.getId(), null, motifif_impression);
                }
            }
            catch (BasicException ex) {
                LogToFile.log("severe", null, ex);
            }
        });
    }

    public TicketInfo getTicketById(String id_ticket) throws BasicException {
        TicketInfo ticket = this.dlSales.getTicketById(id_ticket);
        List<TicketLineInfo> lines = this.dlSales.loadLines(ticket.getId());
        List<TicketLineInfo> linesExterne = this.dlSales.getTicketLineExterne(ticket.getId());
        lines.addAll(linesExterne);
        ticket.setLines(lines);
        for (TicketLineInfo line : ticket.getLines()) {
            List<SupplementItemInfo> ingrediens = this.dlSales.getIngredientsByProducts(line.getProductID(), true, false);
            line.setListIngredientsIN(ingrediens);
        }
        return ticket;
    }

    public void printTicketBorne(String id_ticket, String ip_address) throws IOException {
        JSONObject jsonTicket = new JSONObject();
        jsonTicket.put("id_ticket", (Object)id_ticket);
        UploadCommandService uploadCommandService = new UploadCommandService();
        if (ip_address != null) {
            String url = "http://" + ip_address + ":9097/newItems/printTicketBorne";
            String reponse = uploadCommandService.uploadCommand(url, jsonTicket.toString());
            JSONObject jSONObject = new JSONObject(reponse);
        }
    }

    private UserInfo getCurrentUser() {
        UserInfo user = null;
        user = this.m_App.getAppUserView() != null && this.m_App.getAppUserView().getUser() != null ? this.m_App.getAppUserView().getUser().getUserInfo() : new UserInfo(AppLocal.user != null ? AppLocal.user : AppLocal.user_maintenance);
        return user;
    }

    public void encaisserOrderCB(TicketInfo ticket, List<PaymentInfo> payments, String holder_ticket, CustomerLoyalty mCustomerLoyalty) {
        this.encaisserOrder(ticket, payments, null, true, false, null, true, true, null, null, false, null, holder_ticket, "borne", "CB", null, true, false, false, "print paper", null);
        TicketInfo ticketLoyalty = (TicketInfo)ticket.clone();
        if (AppLocal.CUSTOMER_LOYALTY) {
            this.setCagnoteCustomer(mCustomerLoyalty, ticketLoyalty, AppLocal.CUSTOMER_LOYALTY_ID, AppLocal.getKeenio(), ticket.getId(), true);
        } else if (AppLocal.MODULE_AVOMARK && AppLocal.currentAvomarkClient != null) {
            AvomarkService mAvomarkService = AvomarkService.getInstance();
            mAvomarkService.createAndSendAvomarkSale(ticketLoyalty);
        }
    }

    public void addSharedPayment(List<PaymentInfo> localPayments, Tickets order) {
        try {
            ArrayList<Payments> payments = new ArrayList<Payments>();
            for (PaymentInfo payment : localPayments) {
                payments.add(OrderSharedBuilder.create(payment));
            }
            this.mTicketSharedService.addPayments(order, payments);
        }
        catch (Exception ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
        }
    }

    public void paidOldOrder(TicketInfo ticket, List<TicketLineInfo> lines, List<PaymentInfo> payments, Map<Integer, TicketAvoir> ticketsAvoirs, boolean open_drawer, HashMap<Integer, TicketResto> ticketsRestau, boolean ticket_livraison, boolean print_ticket, boolean online_order, String holder_ticket, String restitution_ticket_type, String email_customer) throws BasicException {
        Tickets order;
        if (online_order) {
            this.calculLineTaxes(ticket);
        }
        TicketInfo ticketToCheck = this.dlSales.getTicketById(ticket.getId(), false);
        boolean paid = ticketToCheck.isPaid();
        List<PaymentInfo> paymentsTosave = PaymentUtils.getPaymentToSave(payments, ticket);
        ticket.setPayments(paymentsTosave);
        this.dlSales.paidLines(lines);
        if (!paid) {
            GrandTotalTicket grandTotal;
            if (AppLocal.IS_STATS_ONLINE_ENABLED.booleanValue() && this.m_keenProject != null) {
                this.m_keenProject.setSynchronizing();
            }
            if ((grandTotal = this.dlSales.getGrandTotalTicket(ticket.getId())) == null) {
                this.dlSales.addPaymentTicket(ticket, paymentsTosave, ticketsRestau);
                this.dlSales.paidTicketAttente(ticket, this.m_App.getInventoryLocation(), this.m_App.getAppUserView().getUser().getId());
                this.increaseCreditCustomer(ticket);
            }
        } else {
            this.dlSales.updatePayment(ticket, paymentsTosave, null);
        }
        PaymentUtils.updateStatusAvoir(this.dlOrder, ticketsAvoirs);
        if (ticket_livraison) {
            this.dlSales.deliverTicket(ticket.getId());
            this.dlSales.disburseTicket(ticket);
        }
        if (paid) {
            if (AppLocal.KITCHEN_COMPOSITE && ticket.getId_shared_order() != 0 && ticket.getId_shared_order() != -1) {
                this.mTicketSharedService.encaisserOrder(ticket.getId_shared_order());
                order = OrderSharedBuilder.create(ticket, "caisse", null, true);
                this.mTicketSharedService.updateOrder(order);
                this.updateSharedPayment(paymentsTosave, order);
            }
        } else {
            if (AppLocal.KITCHEN_COMPOSITE) {
                this.paidOrderByTicket(ticket.getId(), ticket.getId_shared_order(), true);
                if (ticket.getId_shared_order() != 0) {
                    order = OrderSharedBuilder.create(ticket, "caisse", null, true);
                    this.mTicketSharedService.updateOrder(order);
                    this.mTicketSharedService.encaisserOrder(ticket.getId_shared_order());
                    this.addSharedPayment(ticket.getPayments(), order);
                }
            }
            if (AppLocal.IS_STATS_ONLINE_ENABLED.booleanValue()) {
                TicketInfo ticketTracked = (TicketInfo)ticket.clone();
                this.sendStats(ticketTracked);
            }
            if (AppLocal.CUSTOMER_LOYALTY) {
                TicketInfo ticketLoyalty = (TicketInfo)ticket.clone();
                if (online_order) {
                    this.validTransaction(ticketLoyalty, AppLocal.getKeenio(), ticketLoyalty.getId());
                } else {
                    String ticketLoyaltyId = ticketLoyalty.getOrder_id_base() != null && !ticketLoyalty.getOrder_id_base().isEmpty() ? ticketLoyalty.getOrder_id_base() : ticketLoyalty.getId();
                    String keenio = ticketLoyalty.getKeenio_base() != null && !ticketLoyalty.getKeenio_base().isEmpty() ? ticketLoyalty.getKeenio_base() : AppLocal.getKeenio();
                    this.validTransaction(ticketLoyalty, keenio, ticketLoyaltyId);
                }
            }
            TicketInfo ticketpromoCode = (TicketInfo)ticket.clone();
            this.sendUsedPromocode(ticketpromoCode);
        }
        if (!ticket_livraison || !paid) {
            if (open_drawer && (!AppLocal.MODULE_MEV || AppLocal.CONTINUITY_MODE_MEV || AppLocal.CONNECT_CASH_DRAWER)) {
                this.openDrawer();
            }
            TicketInfo ticketToPrinter = (TicketInfo)ticket.clone();
            this.printTicketCaisse(ticketToPrinter, print_ticket, holder_ticket, restitution_ticket_type, email_customer);
            EnteteInfo entetTicket = this.dlSales.getEnteteByTicket(ticketToPrinter.getId(), ticketToPrinter.isPaid());
            if (AppLocal.print_avoir.booleanValue()) {
                this.printAvoir(ticketToPrinter, entetTicket);
            }
        }
    }

    public void paidDeliveredTicket(TicketInfo ticketInfo) throws BasicException {
        this.dlSales.paidLines(ticketInfo.getLines());
        this.dlSales.updatePayment(ticketInfo, ticketInfo.getPayments(), null);
        this.dlSales.disburseTicket(ticketInfo);
        if (ticketInfo.isPaid()) {
            if (AppLocal.KITCHEN_COMPOSITE && ticketInfo.getId_shared_order() != 0 && ticketInfo.getId_shared_order() != -1) {
                this.mTicketSharedService.encaisserOrder(ticketInfo.getId_shared_order());
                Tickets order = new Tickets(ticketInfo.getId_shared_order());
                this.updateSharedPayment(ticketInfo.getPayments(), order);
            }
            if (AppLocal.IS_STATS_ONLINE_ENABLED.booleanValue() && this.m_keenProject != null) {
                TicketInfo ticketTracked = (TicketInfo)ticketInfo.clone();
                new Thread(() -> this.m_keenProject.updatePaymentdOrder(ticketTracked, true)).start();
            }
        } else {
            if (AppLocal.KITCHEN_COMPOSITE) {
                this.paidOrderByTicket(ticketInfo.getId(), ticketInfo.getId_shared_order(), true);
                if (ticketInfo.getId_shared_order() != 0) {
                    this.mTicketSharedService.encaisserOrder(ticketInfo.getId_shared_order());
                    Tickets order = new Tickets(ticketInfo.getId_shared_order());
                    this.addSharedPayment(ticketInfo.getPayments(), order);
                }
            }
            if (AppLocal.IS_STATS_ONLINE_ENABLED.booleanValue() && this.m_keenProject != null) {
                this.m_keenProject.setSynchronizing();
            }
            this.dlSales.paidTicketAttente(ticketInfo, this.m_App.getInventoryLocation(), this.m_App.getAppUserView().getUser().getId());
            this.increaseCreditCustomer(ticketInfo);
            if (AppLocal.IS_STATS_ONLINE_ENABLED.booleanValue()) {
                TicketInfo ticketTracked = (TicketInfo)ticketInfo.clone();
                this.sendStats(ticketTracked);
            }
        }
    }

    public void updateSharedPayment(List<PaymentInfo> localPayments, Tickets order) {
        this.mTicketSharedService.deletePayments(order);
        this.addSharedPayment(localPayments, order);
    }

    public void updatePayment(TicketInfo ticketInfo, List<PaymentInfo> paymentsTosave, Map<Integer, TicketAvoir> ticketsAvoirs, HashMap<Integer, TicketResto> ticketsRestau) throws BasicException {
        this.dlSales.updatePayment(ticketInfo, paymentsTosave, ticketsRestau);
        if (AppLocal.KITCHEN_COMPOSITE && ticketInfo.getId_shared_order() != 0 && ticketInfo.getId_shared_order() != -1) {
            this.mTicketSharedService.encaisserOrder(ticketInfo.getId_shared_order());
            Tickets order = new Tickets(ticketInfo.getId_shared_order());
            this.updateSharedPayment(ticketInfo.getPayments(), order);
        }
        PaymentUtils.updateStatusAvoir(this.dlOrder, ticketsAvoirs);
        TicketInfo tikcetToSendToPrinter = (TicketInfo)ticketInfo.clone();
        if (AppLocal.print_avoir.booleanValue()) {
            EnteteInfo entetTicket = this.dlSales.getEnteteByTicket(tikcetToSendToPrinter.getId(), tikcetToSendToPrinter.isPaid());
            this.printAvoir(tikcetToSendToPrinter, entetTicket);
        }
        if (AppLocal.IS_STATS_ONLINE_ENABLED.booleanValue() && this.m_keenProject != null) {
            final TicketInfo ticketTracked = (TicketInfo)ticketInfo.clone();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    TicketService.this.m_keenProject.updatePaymentdOrder(ticketTracked, true);
                }
            }).start();
        }
        try {
            String idUser = "";
            idUser = this.m_App != null && this.m_App.getAppUserView() != null && this.m_App.getAppUserView().getUser() != null ? this.m_App.getAppUserView().getUser().getId() : (AppLocal.user != null ? AppLocal.user.getId() : AppLocal.user_maintenance.getId());
            Journal.writeToJET(new Event(420, "Changement du mode de r\u00e8glement apr\u00e8s \u00e9mission du ticket", idUser, "Id de ticket", new Date().getTime(), ticketInfo.getId()));
        }
        catch (IOException ex) {
            Logger.getLogger(DataLogicSales.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void setLineDescription(TicketLineInfo line) {
        if (AppLocal.PRINT_DESCRIPTION && line.getDescription() == null) {
            try {
                ProductInfoExt product = CacheFinder.findProductInfoById(this.mSharedMemoryCache, this.dlSales, line.getProductID());
                if (product != null) {
                    line.setDescription(product.getDescription());
                }
            }
            catch (BasicException ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public void checkStockProduct(HashMap<Integer, Integer> ids_products) throws BasicException, IOException {
        List<Integer> product_sold_out = this.isProductsSoldOut(ids_products);
        if (!product_sold_out.isEmpty()) {
            if (this.slave) {
                for (Integer id_product : product_sold_out) {
                    this.dlItems.updateStatusSoldOutProduct(id_product, true);
                }
                AppLocal.product_management = true;
                SynchroService mSynchroService = SynchroService.getInstance();
                mSynchroService.sendSoldOutToMasterCaisse(product_sold_out);
            } else {
                for (Integer id_product : product_sold_out) {
                    this.dlItems.updateStatusSoldOutProductById(id_product, true);
                }
                AppLocal.product_management = true;
                SynchroService mSynchroService = SynchroService.getInstance();
                mSynchroService.sendStatuDailyStockProduct(product_sold_out);
            }
        }
    }

    public List<Integer> isProductsSoldOut(HashMap<Integer, Integer> ids_products) {
        ArrayList<Integer> product_sold_out = new ArrayList<Integer>();
        Date date_start = new Date();
        date_start.setHours(6);
        date_start.setMinutes(5);
        date_start.setSeconds(0);
        for (Integer id_product : ids_products.keySet()) {
            double productsOrdered = this.mTicketSharedService.getNumberProductOrderd(id_product, date_start);
            if (!(productsOrdered >= (double)ids_products.get(id_product).intValue())) continue;
            product_sold_out.add(id_product);
        }
        return product_sold_out;
    }

    public List<Integer> getProductsSoldOut(List<TicketLineInfo> lines) {
        HashMap<Integer, Integer> ids_products = new HashMap<Integer, Integer>();
        List<Integer> ids_products_sold_out = new ArrayList<Integer>();
        for (TicketLineInfo line : lines) {
            if (line.getDaily_stock() == 0) continue;
            int id_product = this.slave ? Integer.parseInt(line.getRef_web()) : line.getProductID();
            ids_products.put(id_product, line.getDaily_stock());
        }
        if (!ids_products.isEmpty()) {
            ids_products_sold_out = this.isProductsSoldOut(ids_products);
        }
        return ids_products_sold_out;
    }

    public boolean soldOutExist(List<TicketLineInfo> linesSoldOut, TicketInfo ticket) {
        if (this.mTicketSharedService != null) {
            List<Integer> ids_products_sold_out = this.getProductsSoldOut(ticket.getLines());
            block2: for (Integer id_product : ids_products_sold_out) {
                for (TicketLineInfo line : ticket.getLines()) {
                    int id_product_local = this.slave ? Integer.parseInt(line.getRef_web()) : line.getProductID();
                    if (id_product_local != id_product) continue;
                    linesSoldOut.add(line);
                    continue block2;
                }
            }
            for (Integer id_product : ids_products_sold_out) {
                try {
                    this.dlItems.updateStatusSoldOutProduct(id_product, true);
                }
                catch (BasicException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
            if (ids_products_sold_out != null && !ids_products_sold_out.isEmpty()) {
                AppLocal.product_management = true;
            }
            return !ids_products_sold_out.isEmpty();
        }
        return false;
    }

    public void loadPopUpMessageSoldOut(String message, Scene scene) {
        try {
            this.mActionEventMessageSoldOut = new EventHiddenModal(){

                @Override
                public void onHidden() {
                    TicketService.this.mLazyModalMessageSoldOut.destroyEvents();
                    TicketService.this.mActionEventMessageSoldOut = null;
                }

                @Override
                public void onHidden(AppLoaderBuilder mBuilder) {
                    if (mBuilder != null && mBuilder.getController() != null) {
                        MessageSoldOutcontroller messageSoldOutcontroller = (MessageSoldOutcontroller)mBuilder.getController();
                    }
                    this.onHidden();
                }
            };
            if (this.mLazyModalMessageSoldOut == null) {
                this.mLazyModalMessageSoldOut = new LazyModal(StageStyle.UNDECORATED, scene, "/fx/templates/borne/message_sold_out.fxml", new Dimension((int)(AppVarUtils.getScreenDimension().getWidth() * 0.6), (int)(AppVarUtils.getScreenDimension().getHeight() * 0.4)));
            }
            this.mLazyModalMessageSoldOut.setEventHiddenModal(this.mActionEventMessageSoldOut);
            this.mLazyModalMessageSoldOut.load(message);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void deleteSoldOut(TicketInfo ticket, List<TicketLineInfo> linesSoldOut) {
        for (TicketLineInfo ticketLineInfo : linesSoldOut) {
            ticket.getLines().remove(ticketLineInfo);
        }
    }

    public boolean isProductsSoldOut(ProductInfoExt product) {
        Date date_start = new Date();
        date_start.setHours(6);
        date_start.setMinutes(5);
        date_start.setSeconds(0);
        int id_product = this.slave ? Integer.parseInt(product.getRef_web()) : product.getID();
        double productsOrdered = this.mTicketSharedService.getNumberProductOrderd(id_product, date_start);
        return productsOrdered >= (double)product.getDaily_stock();
    }

    private void validSharedOrder(TicketInfo ticket, List<Integer> ids_tickets_borne) throws BasicException {
        try {
            if (ticket.getId_shared_order() != 0) {
                this.mTicketSharedService.saveOrder(ticket.getId_shared_order());
                Tickets order = OrderSharedBuilder.create(ticket, "caisse", null, true);
                if (AppLocal.MODULE_AVOMARK && AppLocal.currentAvomarkClient != null) {
                    order.setAvomarkCustomer(AppLocal.currentAvomarkClient.getId());
                }
                this.mTicketSharedService.updateOrder(order);
                this.dlOrder.setSharedOrderInfos(ticket.getId(), ticket.getId_shared_order(), order.isExterior_order());
                if (ids_tickets_borne != null && ids_tickets_borne.size() > 1) {
                    ArrayList<Integer> ids_tickets_to_delete = new ArrayList<Integer>();
                    ids_tickets_borne.stream().filter(id_order -> id_order.intValue() != ticket.getId_shared_order()).forEachOrdered(id_order -> ids_tickets_to_delete.add((Integer)id_order));
                    this.mTicketSharedService.deleteOrders(ids_tickets_to_delete);
                }
                if (ticket.isPaid()) {
                    Tickets ticketShared = new Tickets(ticket.getId_shared_order());
                    this.addSharedPayment(ticket.getPayments(), ticketShared);
                    this.mTicketSharedService.paidSharedOrder(ticket.getId_shared_order(), AppLocal.source_order);
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
        }
    }

    public void updateTicketLivraison(TicketInfo ticket, LivreurInfo livreur) throws BasicException, SQLException {
        this.prepareLines(ticket, ticket.getType());
        for (TicketLineInfo line : ticket.getLines()) {
            List<SupplementItemInfo> ingrediens = this.dlSales.getIngredientsByProducts(line.getProductID(), true, false);
            line.setListIngredientsIN(ingrediens);
        }
        this.prepareTicketOptions(ticket);
        this.dlSales.updateTicket(ticket, this.m_App.getInventoryLocation(), this.m_App.getAppUserView().getUser());
        TicketInfo ticketToSend = (TicketInfo)ticket.clone();
        this.updateKitchenOrder(ticketToSend);
    }

    public void saveSharedOrder(final TicketInfo ticket, final String source_order, final boolean add_payment, final String type_payment, final boolean oldOrder) {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (AppLocal.HOSTNAME_DB != null && (ticket.getId_shared_order() == 0 || ticket.getId_shared_order() == -1)) {
                    try {
                        String source = source_order != null && !source_order.isEmpty() ? source_order : "caisse";
                        Tickets order = OrderSharedBuilder.create(ticket, source, type_payment, false);
                        TicketService.this.mTicketSharedService.sendOrder(order, 3);
                        if (ticket.getTicketId() != 0) {
                            TicketService.this.dlOrder.setSharedOrderInfos(ticket.getId(), order.getId(), order.isExterior_order());
                        }
                        if (add_payment) {
                            TicketService.this.addSharedPayment(ticket.getPayments(), order);
                        }
                        if (!oldOrder) {
                            HashMap<Integer, Integer> ids_products = new HashMap<Integer, Integer>();
                            for (TicketLineInfo line : ticket.getLines()) {
                                if (line.getDaily_stock() == 0) continue;
                                int id_product = TicketService.this.slave ? (line.getRef_web() == null ? line.getProductID() : Integer.parseInt(line.getRef_web())) : line.getProductID();
                                ids_products.put(id_product, line.getDaily_stock());
                            }
                            if (!ids_products.isEmpty()) {
                                TicketService.this.checkStockProduct(ids_products);
                            }
                        }
                    }
                    catch (Exception ex) {
                        LogToFile.log("sever", ex.getMessage(), ex);
                    }
                }
            }
        });
    }

    public void updateTicket(TicketInfo ticket, boolean add_log) throws BasicException, SQLException {
        ticket.setLastUpdate(new Date());
        this.dlSales.updateTicket(ticket, this.m_App.getInventoryLocation(), this.m_App.getAppUserView().getUser(), add_log);
    }

    public void printDuplicata(TicketInfo ticket, PrinterHelper printer, EnteteInfo entetTicket, String userId, String holder_ticket, String motifif_impression) throws BasicException {
        if (AppLocal.MODULE_MEV && !AppLocal.CONTINUITY_MODE_MEV) {
            this.mEVService.duplicataTicket(ticket);
        } else {
            Duplicata mDuplicata = new Duplicata(ticket.getTicketId(), ticket.getId(), "Ticket", userId, new Integer(entetTicket.getNumDoc()), motifif_impression, 0, Integer.parseInt(entetTicket.getId()));
            long impressionNumber = this.dlSales.getNumberPrintDuplicata(ticket.getId(), "Ticket");
            mDuplicata.setImpression_Number(impressionNumber);
            mDuplicata.setDate_impression(new Date());
            boolean validPrinter = Printer.isPrinterValid(printer.getPrinterCaisse());
            Duplicata lastDuplicata = null;
            if (validPrinter && mDuplicata != null) {
                lastDuplicata = this.dlSales.addDuplicataAndReturnNumberPrint(mDuplicata);
                mDuplicata.setId(lastDuplicata.getId());
                mDuplicata.setSignature(lastDuplicata.getSignature());
            }
            Decreaser decreaser = new Decreaser(this.dlSales, ticket.getId(), "DUPLICATA", mDuplicata, ticket.getNumero_order());
            if (AppLocal.MODULE_TVA_GLOBAL || AppLocal.MODULE_MEV && AppLocal.CONTINUITY_MODE_MEV) {
                printer.printTicketContinuityMode(ticket, "N", "O", "RFER", decreaser, this.marqueNF);
            } else {
                printer.printRappelTickets(ticket.getNumero_order(), ticket, entetTicket, impressionNumber, decreaser, false, holder_ticket, mDuplicata, false);
            }
        }
    }

    public void printPaidTicketCaisse(TicketInfo ticket) {
        try {
            EnteteInfo entetTicket = this.dlSales.getEnteteByTicket(ticket.getId(), ticket.isPaid());
            this.printPaidTicketCaisse(ticket, entetTicket, null);
        }
        catch (BasicException ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public void checkPromotions(TicketInfo ticket, String type_order) throws BasicException {
        String type_order_promotion;
        String string = type_order_promotion = type_order != null && (type_order.equals("Uber Eats") || type_order.equals("Delivero") || type_order.equals("Deliveroo") || type_order.equals("Just Eat") || type_order.equals("Smood")) ? "Platform" : type_order;
        if (AppLocal.PROMOTION_BY_LINE_ORDER && (ticket.getSent_from() == null || !ticket.getSent_from().equalsIgnoreCase("borne"))) {
            this.checkPromotionsCustomised(ticket, type_order_promotion);
        } else {
            this.checkPromotions(ticket, type_order_promotion, false);
        }
    }

    public void checkPromotions(TicketInfo ticket, String type_order, boolean resetPormotionApplied) throws BasicException {
        List<PromotionInfo> promotions = this.dlItems.getPromotions(false);
        if (promotions != null && !promotions.isEmpty()) {
            for (TicketLineInfo line : ticket.getLines()) {
                System.out.println("line.getPoints_loyalty() : " + line.getPoints_loyalty());
                if (line.getPoints_loyalty() != 0.0) continue;
                line.setProduct_promotion_applied(false);
                if (!line.isPromo_product()) continue;
                line.setPromo_product(false);
                line.setDiscount(0.0);
                line.setLabelDiscount("");
            }
        }
        ArrayList<TicketLineInfo> linesToAdd = new ArrayList<TicketLineInfo>();
        for (PromotionInfo promotion : promotions) {
            double quantity = 0.0;
            ArrayList<TicketLineInfo> lines_promotions = new ArrayList<TicketLineInfo>();
            for (TicketLineInfo line : ticket.getLines()) {
                ProductInfoExt product;
                if (line.getPoints_loyalty() != 0.0 || line.isProduct_promotion_applied() && AppLocal.PROMOTION_BY_LINE_ORDER || promotion.getSize_product() != null && !promotion.getSize_product().isEmpty() && (line.getName_sizeProduct() == null || !promotion.getSize_product().equals(line.getName_sizeProduct())) || promotion.getType_order() != null && !promotion.getType_order().isEmpty() && !promotion.getType_order().equals(type_order) || (product = CacheFinder.findProductInfoById(this.mSharedMemoryCache, this.dlSales, line.getProductID())) == null || product.getPromotions() == null) continue;
                for (PromotionInfo promotionProduct : product.getPromotions()) {
                    if (promotion.getId() != promotionProduct.getId()) continue;
                    lines_promotions.add(line);
                    quantity += line.getMultiply();
                }
            }
            if (!(quantity >= promotion.getQuantity())) continue;
            for (TicketLineInfo line : lines_promotions) {
                if (line.isPromo_product() && !AppLocal.PROMOTION_BY_LINE_ORDER) {
                    line.setPromo_product(false);
                    line.setDiscount(0.0);
                    line.setLabelDiscount("");
                }
                line.setProduct_promotion_applied(true);
            }
            int number_lines_to_add = (int)(quantity / promotion.getQuantity());
            List<TicketLineInfo> newLines = this.getLessExpensiveLine(lines_promotions, number_lines_to_add, promotion);
            linesToAdd.addAll(newLines);
        }
        ticket.getLines().addAll(linesToAdd);
    }

    private List<TicketLineInfo> getLessExpensiveLine(List<TicketLineInfo> lines, int number_lines_to_add, PromotionInfo promotion) {
        ArrayList<TicketLineInfo> lines_to_add = new ArrayList<TicketLineInfo>();
        Collections.sort(lines, (l1, l2) -> {
            int c = Double.compare(l1.getPriceProduct(), l2.getPriceProduct());
            if (c == 0) {
                c = Double.compare(l1.getMultiply(), l2.getMultiply());
            }
            return c;
        });
        int index_line = 0;
        while (number_lines_to_add > 0) {
            double priceToRemove;
            if (lines.get(index_line).getMultiply() == 1.0) {
                priceToRemove = this.getPriceToBeRemoved(lines.get(index_line).getPriceProduct(), promotion);
                lines.get(index_line).setDiscount(priceToRemove);
                lines.get(index_line).setType_discount("somme");
                lines.get(index_line).setLabelDiscount(promotion.getName_promotion());
                lines.get(index_line).setPromo_product(true);
                lines.get(index_line).setLabel_promotion(promotion.getLabelPromotion());
                --number_lines_to_add;
            } else if ((double)number_lines_to_add >= lines.get(index_line).getMultiply()) {
                priceToRemove = this.getPriceToBeRemoved(lines.get(index_line).getPriceProduct() * lines.get(index_line).getMultiply(), promotion);
                lines.get(index_line).setDiscount(priceToRemove);
                lines.get(index_line).setType_discount("somme");
                lines.get(index_line).setLabelDiscount(promotion.getName_promotion());
                lines.get(index_line).setLabel_promotion(promotion.getLabelPromotion());
                lines.get(index_line).setPromo_product(true);
                number_lines_to_add = (int)((double)number_lines_to_add - lines.get(index_line).getMultiply());
            } else {
                double quantityLine = lines.get(index_line).getMultiply() - (double)number_lines_to_add;
                TicketLineInfo newLine = (TicketLineInfo)lines.get(index_line).clone();
                double priceToRemove2 = this.getPriceToBeRemoved(newLine.getPriceProduct() * (double)number_lines_to_add, promotion);
                newLine.setID(-1);
                newLine.setId_source(0);
                newLine.setId_line_kitchen(0);
                for (OptionItemOrder supplement : newLine.getListSupplements()) {
                    supplement.setId_supplement_kitchen(0);
                }
                for (ItemOrderInfo ingredient : newLine.getListIngredients()) {
                    ingredient.setId_ingredient_kitchen(0);
                }
                for (ProductTicket subProduct : newLine.getListProducts()) {
                    subProduct.setId_item_kitchen(0);
                }
                newLine.setPromo_product(true);
                newLine.setDiscount(priceToRemove2);
                newLine.setType_discount("somme");
                newLine.setLabelDiscount(promotion.getName_promotion());
                newLine.setLabel_promotion(promotion.getLabelPromotion());
                newLine.setMultiply(number_lines_to_add);
                lines.get(index_line).setMultiply(quantityLine);
                number_lines_to_add = 0;
                newLine.setProduct_promotion_applied(true);
                lines_to_add.add(newLine);
            }
            ++index_line;
        }
        return lines_to_add;
    }

    private double getPriceToBeRemoved(double priceProduct, PromotionInfo promotion) {
        return priceProduct * promotion.getDiscount() / 100.0;
    }

    public void printCanceledOrder(final TicketInfo ti) {
        if (ti != null && ti.getLinesCount() > 0) {
            final PrinterHelper printer = new PrinterHelper();
            try {
                ti.setPayments(this.dlSales.findPaymetsByIdTicket(ti.getId()));
                final EnteteInfo entetTicket = this.dlSales.getEnteteByTicket(ti.getId(), true);
                Executors.newSingleThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        if (!entetTicket.IsTicketRestituted()) {
                            Decreaser decreaser = new Decreaser(TicketService.this.dlSales, ti.getId(), "TICKET", null, ti.getNumero_order());
                            printer.printRappelTickets(ti.getNumero_order(), ti, entetTicket, 0L, decreaser);
                        } else if (ti.isPaid()) {
                            try {
                                UserInfo user = TicketService.this.getCurrentUser();
                                TicketService.this.printDuplicata(ti, printer, entetTicket, user.getId(), null, null);
                            }
                            catch (Exception ex) {
                                LogToFile.log("severe", null, ex);
                            }
                        }
                    }
                });
            }
            catch (Exception ex) {
                LogToFile.log("severe", null, ex);
            }
        } else {
            new NotifyWindow(NotifyType.DEFAULT_NOTIFICATION, "Veuillez s\u00e9l\u00e9ctionner la commande \u00e0 imprimer .", 1500, NPosition.BOTTOM_RIGHT);
        }
    }

    public void printTicketUber(TicketInfo ticket_to_print) {
        Executors.newSingleThreadExecutor().execute(() -> {
            try {
                if (this.m_App.getAppUserView() != null && this.m_App.getAppUserView().getUser() != null) {
                    ticket_to_print.setUser(this.m_App.getAppUserView().getUser().getUserInfo());
                } else {
                    UserInfo userInfo = new UserInfo(AppLocal.user != null ? AppLocal.user : AppLocal.user_maintenance);
                    ticket_to_print.setUser(userInfo);
                }
                MarqueNFC marqueNF = MarqueNFC.fetchOrStore(this.dlSales);
                Decreaser decreaser = new Decreaser(this.dlSales, ticket_to_print.getId(), "Commande Uber", null, ticket_to_print.getNumero_order());
                EnteteInfo enteteTicket = new EnteteInfo("", "0", "10.0.1.27", 0, marqueNF.getCompany(), marqueNF.getAdresse1(), marqueNF.getZipCode(), marqueNF.getCity(), marqueNF.getCountry(), marqueNF.getSiret(), marqueNF.getCodeNAF(), marqueNF.getIntraTVA(), ticket_to_print.getDate(), "Commande", ticket_to_print.getLinesCount(), ticket_to_print.getId(), AppLocal.header, AppLocal.footer, "pending", "", "1", "BIBORNE", this.getIdUser(), true, true, "impression papier", 0, this.getNamrUser());
                new PrinterHelper().printRappelTickets(ticket_to_print.getNumero_order(), ticket_to_print, enteteTicket, 0L, decreaser, false, null, null, true);
            }
            catch (BasicException ex) {
                LogToFile.log("sever", ex.getMessage(), ex);
            }
        });
    }

    public PaymentResult paymentTPE(double total_order, TicketInfo ticket, String transactionId) {
        PaymentResult paymentResult = null;
        double amount = NumericUtils.round(total_order);
        CustomerInfo customer = ticket != null ? ticket.getCustomer() : null;
        PaymentByCardFacade facade = PaymentByCardFacade.getInstance(this.m_App);
        if (facade.isActivated()) {
            paymentResult = facade.doDebit(amount, customer, transactionId);
            if (paymentResult == null) {
                paymentResult = new PaymentResult();
            }
            if (paymentResult != null) {
                paymentResult.setActivated(true);
                if (!facade.isTransactionSuccessed(paymentResult.getResult())) {
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, facade.getErrorMessage(paymentResult.getResult()), 4000, NPosition.BOTTOM_RIGHT);
                } else {
                    paymentResult.setValid(true);
                    new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Transaction a bien pass\u00e9", 4000, NPosition.BOTTOM_RIGHT);
                }
            }
        } else {
            if (paymentResult == null) {
                paymentResult = new PaymentResult();
            }
            paymentResult.setActivated(false);
        }
        return paymentResult;
    }

    public PaymentResult validOrderAfterPayment(List<PaymentInfo> m_aPaymentInfo, TicketInfo currentOrder) {
        PaymentResult paymentResult = null;
        boolean exist_payment_cb = false;
        for (PaymentInfo paymentInfo : m_aPaymentInfo) {
            if (paymentInfo.getName() == null || !paymentInfo.getName().equalsIgnoreCase("CB")) continue;
            exist_payment_cb = true;
            paymentResult = this.paymentTPE(paymentInfo.getPaid(), currentOrder, null);
            if (paymentResult == null) continue;
            if (paymentResult.getType_card() == null || paymentResult.getType_card().isEmpty()) {
                String namePayment = !(!AppLocal.MODULE_MEV && !AppLocal.VERSION_CANADA && !AppLocal.MODULE_TVA_GLOBAL || paymentInfo.getName() != null && !paymentInfo.getName().equalsIgnoreCase("cb")) ? "carte credit" : paymentInfo.getName();
                paymentResult.setType_card(namePayment);
            }
            paymentInfo.setNamePayment(paymentResult.getType_card());
        }
        if (!exist_payment_cb || paymentResult != null && (!paymentResult.isActivated() || paymentResult.isValid())) {
            return paymentResult;
        }
        return null;
    }

    public boolean encaisserOnlineOrder(TicketInfo ticket, List<PaymentInfo> payments, boolean delivery, boolean delay, int minutes, boolean onlinePayment) {
        boolean result;
        block7: {
            result = false;
            if (ticket.getLinesCount() > 0) {
                try {
                    boolean add_ticket;
                    result = this.acceptOrder(delay, minutes, ticket, onlinePayment);
                    if (!result) break block7;
                    TableInfo table = this.checkAvailability(ticket.getNum_table());
                    if (table != null) {
                        ticket.setTable(table);
                    }
                    if (add_ticket = this.validOrder(false, ticket, null, true, null, null, true, payments, null, null, "paid", true, delivery, null)) {
                        TicketInfo ticketToSend = (TicketInfo)ticket.clone();
                        TicketInfo ticketLoyalty = (TicketInfo)ticket.clone();
                        this.sendAndPrintOnlineOrder(ticketToSend, false, false, true, true, false, null, true, null, null, true, null, true, false);
                        if (AppLocal.CUSTOMER_LOYALTY) {
                            this.setCagnoteCustomer(ticketLoyalty, AppLocal.CUSTOMER_LOYALTY_ID, AppLocal.getKeenio(), ticketLoyalty.getId(), true);
                        }
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("sever", ex.getMessage(), ex);
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
        return result;
    }

    public void addLogPanier(TicketLineInfo line, int numero_order) {
        try {
            UserInfo user = null;
            user = this.m_App.getAppUserView() != null && this.m_App.getAppUserView().getUser() != null ? this.m_App.getAppUserView().getUser().getUserInfo() : new UserInfo(AppLocal.user != null ? AppLocal.user : AppLocal.user_maintenance);
            ProductInfoExt productTmp = CacheFinder.findProductInfoById(this.mSharedMemoryCache, this.dlSales, line.getProductID());
            if (productTmp != null) {
                LogPanier panier = new LogPanier(user.getId(), numero_order, line.getMultiply(), line.getPrice(), productTmp.getName(), line.getValueDiscount(), line.getLabelDiscount(), true);
                this.dlSales.addLog(panier);
            }
        }
        catch (BasicException ex) {
            Logger.getLogger(TicketService.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void sendNotificationMysql(Date created, Date delivery) throws IOException {
        int seconds = created != null && delivery != null ? DateUtils.getDiffTime(created.getTime(), delivery.getTime()) : 0;
        System.out.println("seconds sendNotificationMysql : " + seconds);
        this.mNotificationClientService.sendNotification(seconds);
    }

    public boolean saveOnlineOrder(boolean printQr, TicketInfo ticket, boolean onlineOrder, boolean send_to_kitchen, boolean print, boolean delivery, boolean delay, int minutes, boolean onlinePayment) {
        boolean result;
        block5: {
            result = false;
            if (ticket.getLinesCount() > 0) {
                try {
                    boolean add_ticket;
                    result = this.acceptOrder(delay, minutes, ticket, onlinePayment);
                    if (!result || !(add_ticket = this.validOrder(false, ticket, null, send_to_kitchen, null, null, print, null, this.oldLines, null, "pending", onlineOrder, delivery, null))) break block5;
                    TicketInfo ticketLoyalty = (TicketInfo)ticket.clone();
                    TicketInfo ticketToSend = (TicketInfo)ticket.clone();
                    this.sendAndPrintOnlineOrder(ticketToSend, false, send_to_kitchen, print, null, true, printQr, false, null, false);
                    if (AppLocal.CUSTOMER_LOYALTY) {
                        this.setCagnoteCustomer(ticketLoyalty, AppLocal.CUSTOMER_LOYALTY_ID, AppLocal.getKeenio(), ticketLoyalty.getId(), false);
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
        return result;
    }

    public void saveOrderInMysql(TicketInfo ticket, String source_order, boolean add_payment, String type_payment, boolean exterior_order, boolean pending_order, boolean borne_order) {
        System.out.println("*saveOrderInMysql*");
        if (AppLocal.HOSTNAME_DB != null) {
            try {
                OrderKitchenScreenService mOrderKitchenScreenService = new OrderKitchenScreenService(AppLocal.dlSales, AppLocal.dlProduct, AppLocal.dlOrders, AppLocal.dlItems);
                Orders order_kitchen = mOrderKitchenScreenService.sendOrderToKitchen(ticket, false, true);
                if ((order_kitchen.getId() == null || order_kitchen.getId() == 0) && borne_order) {
                    this.printRecap(ticket, true, true, null);
                }
                this.sendNotificationMysql(order_kitchen.getCreated(), order_kitchen.getDelivery_date());
                if (AppLocal.SAVE_ORDER_SLAVE && AppLocal.modeCaisse != null && AppLocal.modeCaisse.equals("Borne")) {
                    try {
                        this.printKitchen(ticket, true, null, true, false);
                        String num_order_borne = DateUtils.timeFormatterWithoutSep.format(new Date()) + AppLocal.name_borne;
                        ticket.setNum_order_borne(num_order_borne);
                        InetAddress ip_machine = InetAddress.getLocalHost();
                        if (ip_machine != null) {
                            ticket.setAddress_ip_borne(ip_machine.getHostAddress());
                        }
                    }
                    catch (UnknownHostException ex) {
                        LogToFile.log("sever", ex.getMessage(), ex);
                    }
                }
                System.out.println("******* AppLocal.currentAvomarkClient id " + AppLocal.currentAvomarkClient);
                if (ticket.getId_shared_order() == 0 || ticket.getId_shared_order() == -1) {
                    String source = source_order != null && !source_order.isEmpty() ? source_order : "caisse";
                    Tickets order = OrderSharedBuilder.create(ticket, source, type_payment, false);
                    if (AppLocal.CUSTOMER_LOYALTY && AppLocal.currentCustomerLoyalty != null) {
                        order.setLicence_id_machine(AppLocal.CUSTOMER_LOYALTY_ID);
                        order.setCustomer_phone(AppLocal.currentCustomerLoyalty.getPhone());
                        if (pending_order) {
                            AppLocal.currentCustomerLoyalty = null;
                        }
                    } else if (AppLocal.MODULE_AVOMARK && AppLocal.currentAvomarkClient != null) {
                        order.setAvomarkCustomer(AppLocal.currentAvomarkClient.getId());
                    }
                    order.setExterior_order(exterior_order);
                    this.mTicketSharedService.sendOrder(order, 2);
                    if (ticket.getTicketId() != 0) {
                        this.dlOrder.setSharedOrderInfos(ticket.getId(), order.getId(), order.isExterior_order());
                    }
                    if (add_payment) {
                        this.addSharedPayment(ticket.getPayments(), order);
                    }
                    HashMap<Integer, Integer> ids_products = new HashMap<Integer, Integer>();
                    for (TicketLineInfo line : ticket.getLines()) {
                        if (line.getDaily_stock() == 0) continue;
                        int id_product = this.slave ? (line.getRef_web() == null ? line.getProductID() : Integer.parseInt(line.getRef_web())) : line.getProductID();
                        ids_products.put(id_product, line.getDaily_stock());
                    }
                    if (!ids_products.isEmpty()) {
                        this.checkStockProduct(ids_products);
                    }
                } else {
                    this.mTicketSharedService.setInfoKitchenOrder(ticket.getId_shared_order(), ticket.getId_order_kitchen(), ticket.getNum_order_kitchen());
                }
            }
            catch (Exception ex) {
                LogToFile.log("sever", ex.getMessage(), ex);
            }
        }
        AppLocal.currentCustomerLoyalty = null;
        AppLocal.currentAvomarkClient = null;
    }

    private void printLivraisonTickets(TicketInfo tikcetToSendToPrinter) {
        try {
            PrinterHelper printer = new PrinterHelper();
            MarqueNFC marqueNF = MarqueNFC.fetchOrStore(this.dlSales);
            Decreaser decreaser = new Decreaser(this.dlSales, tikcetToSendToPrinter.getId(), "Ticket Livraison", null, tikcetToSendToPrinter.getNumero_order());
            if (!tikcetToSendToPrinter.isPaid()) {
                this.dlSales.addEnteteNoteAfterPrint(tikcetToSendToPrinter);
            }
            EnteteInfo enteteTicket = this.dlSales.getEnteteByTicket(tikcetToSendToPrinter.getId(), tikcetToSendToPrinter.isPaid());
            printer.printLivraisonTickets(tikcetToSendToPrinter.getNumero_order(), tikcetToSendToPrinter, null, "", enteteTicket, decreaser);
        }
        catch (BasicException ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
        }
    }

    private void printRecap(TicketInfo tikcetToSendToPrinter, boolean cb_borne, boolean error_send_to_caisse, String num_order_borne) {
        if (this.printerSummaryKitchen == null) {
            this.setPrinterRecap();
        }
        PrinterHelper printer = new PrinterHelper();
        Decreaser decreaserKitchen = new Decreaser(this.dlSales, tikcetToSendToPrinter.getId(), "Ticket cuisine", null, tikcetToSendToPrinter.getNumero_order());
        boolean recap_delivery = AppLocal.PRINT_RECAP_DELIVERY && tikcetToSendToPrinter.getType() != null && tikcetToSendToPrinter.getType().equalsIgnoreCase("En Livraison");
        int number_print = AppLocal.PRINT_RECAP_DELIVERY && tikcetToSendToPrinter.getType() != null && tikcetToSendToPrinter.getType().equalsIgnoreCase("En Livraison") && AppLocal.NUMBER_PRINT_DELIVERY > 0 ? AppLocal.NUMBER_PRINT_DELIVERY : 1;
        for (int i = 0; i < number_print; ++i) {
            try {
                this.printRecap(tikcetToSendToPrinter, decreaserKitchen, cb_borne, recap_delivery, error_send_to_caisse, num_order_borne);
                continue;
            }
            catch (Exception ex) {
                LogToFile.log("severe", null, ex);
            }
        }
    }

    public void sendAndPrintOnlineOrder(TicketInfo ticket, boolean caisse_order, boolean send_to_kitchen, boolean print, List<TicketLineInfo> lines_to_deletes, boolean first_part_of_order, boolean printQr, boolean save_shared_order, String source_order, boolean exterior_order) throws BasicException {
        TicketInfo ticketToSendToDisplay = (TicketInfo)ticket.clone();
        TicketInfo tikcetToSendToPrinter = (TicketInfo)ticket.clone();
        TicketInfo tikcetToSendToLabelPrinter = (TicketInfo)ticket.clone();
        if (tikcetToSendToPrinter.getType() != null && tikcetToSendToPrinter.getType().equals("En Livraison")) {
            this.printLivraisonTickets(tikcetToSendToPrinter);
        }
        if (AppLocal.PRINT_RECAP || AppLocal.PRINT_RECAP_DELIVERY && tikcetToSendToPrinter.getType() != null && tikcetToSendToPrinter.getType().equalsIgnoreCase("En Livraison")) {
            this.printRecap(ticketToSendToDisplay, false);
        }
        if (send_to_kitchen) {
            if (AppLocal.KITCHEN_COMPOSITE) {
                this.saveOrderInMysql(ticketToSendToDisplay, source_order, false, null, exterior_order, false, false);
            } else {
                this.sendOrderToKitchenUsingRMI(ticketToSendToDisplay, tikcetToSendToPrinter);
            }
        }
        if (print) {
            this.printKitchen(tikcetToSendToPrinter, false, lines_to_deletes, first_part_of_order, true);
            if (!(AppLocal.PRINT_LABEL_TAKE_AWAY && !tikcetToSendToPrinter.getType().equals("A Emporter") || AppLocal.PRINT_LABEL_PRODUCT_WITH_EXCLUDED_INFREDIENT && !tikcetToSendToPrinter.hasProductWithExludedIngredient())) {
                this.printLabel(tikcetToSendToPrinter);
            }
        }
    }

    public void sendAndPrintOnlineOrder(TicketInfo ticket, boolean openDrawer, boolean caisse_order, boolean send_to_kitchen, boolean printKitchen, boolean cb_borne, List<TicketLineInfo> lines_to_deletes, boolean first_part_of_order, String holder_ticket, String source_order, boolean add_payment, String type_payment, boolean print_ticket, boolean ticket_delivery) throws BasicException {
        ticket.setHolder(holder_ticket);
        TicketInfo ticketTracked = (TicketInfo)ticket.clone();
        TicketInfo ticketToSendToDisplay = (TicketInfo)ticket.clone();
        TicketInfo tikcetToSendToPrinter = (TicketInfo)ticket.clone();
        TicketInfo tikcetToSendToLabelPrinter = (TicketInfo)ticket.clone();
        TicketInfo tikcetToPrintAvoir = (TicketInfo)ticket.clone();
        TicketInfo tikcetToSendToPrinterKitchen = (TicketInfo)ticket.clone();
        TicketInfo tikcetToSendToPrinterLater = (TicketInfo)ticket.clone();
        EnteteInfo enteteTicket = this.dlSales.getEnteteByTicket(ticket.getId(), true);
        PrinterHelper printer = new PrinterHelper();
        this.printTicketCaisse(printer, tikcetToSendToPrinter, openDrawer, enteteTicket, holder_ticket, print_ticket, ticket_delivery, "print paper", null);
        try {
            if (AppLocal.PRINT_RECAP || AppLocal.PRINT_RECAP_DELIVERY && tikcetToSendToPrinter.getType() != null && tikcetToSendToPrinter.getType().equalsIgnoreCase("En Livraison")) {
                this.printRecap(ticketToSendToDisplay, false);
            }
            int n = printer.getNombreLignesInCammande();
        }
        catch (Exception ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
        }
        this.printPlusTardTickets(enteteTicket, tikcetToSendToPrinterLater);
        if (send_to_kitchen) {
            if (AppLocal.KITCHEN_COMPOSITE) {
                this.saveOrderInMysql(ticketToSendToDisplay, source_order, add_payment, type_payment, false, false, cb_borne);
            } else {
                this.sendOrderToKitchenUsingRMI(ticketToSendToDisplay, tikcetToSendToPrinter);
            }
        }
        if (printKitchen) {
            if (!(cb_borne && AppLocal.KITCHEN_COMPOSITE && AppLocal.SAVE_ORDER_SLAVE)) {
                this.printKitchen(tikcetToSendToPrinterKitchen, cb_borne, lines_to_deletes, first_part_of_order, true);
            }
            if (!(AppLocal.PRINT_LABEL_TAKE_AWAY && !tikcetToSendToPrinter.getType().equals("A Emporter") || AppLocal.PRINT_LABEL_PRODUCT_WITH_EXCLUDED_INFREDIENT && !tikcetToSendToPrinter.hasProductWithExludedIngredient())) {
                this.printLabel(tikcetToSendToPrinter);
            }
        }
        if (AppLocal.print_avoir.booleanValue()) {
            this.printAvoir(tikcetToPrintAvoir, enteteTicket);
        }
        if (AppLocal.IS_STATS_ONLINE_ENABLED.booleanValue()) {
            this.sendStats(ticketTracked);
        }
        this.sendUsedPromocode(ticket);
    }

    public boolean acceptOnlineOrder(TicketInfo ticket, boolean delay, boolean onlinePayment, int minutes) {
        if (this.mOrderOnLineService == null) {
            this.mOrderOnLineService = OrderOnLineService.getInstance(null);
        }
        if (onlinePayment) {
            ArrayList<PaymentInfo> payments = new ArrayList<PaymentInfo>();
            payments.add(new PaymentInfo("Virement", ticket.getTotalOrder(), ticket.getTotalOrder()));
            boolean ticket_livraison = ticket.getType().equals("En Livraison");
            TicketInfo ticketToSave = (TicketInfo)ticket.clone();
            return this.encaisserOnlineOrder(ticketToSave, payments, ticket_livraison, delay, minutes, onlinePayment);
        }
        return this.saveOnlineOrder(false, ticket, true, true, true, false, delay, minutes, onlinePayment);
    }

    private boolean acceptOrder(boolean delay, int minutes, TicketInfo ticket, boolean onlinePayment) {
        this.mOrderOnLineService.setIdOrderLocal(ticket.getId_online_order(), ticket.getId());
        if (delay) {
            // empty if block
        }
        if (onlinePayment) {
            return this.mOrderOnLineService.changeStatusOrder(ticket, "paid");
        }
        return this.mOrderOnLineService.changeStatusOrder(ticket, "pending");
    }

    private void delayOrder(TicketInfo ticket, int minutes) {
        if (ticket != null && AppLocal.SEND_SMS && ticket.getCustomerPhone() != null && !ticket.getCustomerPhone().isEmpty()) {
            String message = "Nous sommes d\u00e9sol\u00e9s. Votre commande N " + ticket.getNumero_online_order() + " a ete retarde de " + minutes + " minutes.";
            if (this.mSmsService == null) {
                this.mSmsService = SmsService.getInstance();
            }
            this.mSmsService.sendSMS(ticket.getCustomerPhone(), message);
        }
    }

    public void setCagnoteCustomer(CustomerLoyalty mCustomerLoyalty, TicketInfo ticket, String customer_loyalty_id, String keenio, String order_id, boolean is_validate) {
        System.out.println("mCustomerLoyalty : " + mCustomerLoyalty);
        if (mCustomerLoyalty != null) {
            double total_point = 0.0;
            for (TicketLineInfo line : ticket.getLines()) {
                total_point += line.getPoints_loyalty() * line.getMultiply();
            }
            mCustomerLoyalty.setUsed_points(total_point);
            if (ticket.getTotal() > 0.0) {
                mCustomerLoyalty.setEarned_points(ticket.getTotal());
            }
            if (ticket.getValue_in_base() == 0.0 && ticket.getValue_out_base() == 0.0) {
                if (mCustomerLoyalty.getUsed_points() > 0.0 || mCustomerLoyalty.getEarned_points() > 0.0) {
                    this.mLoyaltyService.saveLoyaltyTransaction(mCustomerLoyalty, customer_loyalty_id, ticket.getTotal(), keenio, order_id, is_validate);
                }
            } else if (ticket.getValue_in_base() != mCustomerLoyalty.getEarned_points() || ticket.getValue_out_base() != mCustomerLoyalty.getUsed_points()) {
                this.mLoyaltyService.cancelTransaction(ticket, keenio, order_id);
                if (mCustomerLoyalty.getUsed_points() > 0.0 || mCustomerLoyalty.getEarned_points() > 0.0) {
                    this.mLoyaltyService.saveLoyaltyTransaction(mCustomerLoyalty, customer_loyalty_id, ticket.getTotal(), keenio, order_id, is_validate);
                }
            } else {
                this.mLoyaltyService.validTransaction(ticket, keenio, order_id);
            }
            AppLocal.currentCustomerLoyalty = null;
        }
    }

    public void decreaseSoldeCustomer(double price_point) {
        if (AppLocal.currentCustomerLoyalty != null) {
            AppLocal.currentCustomerLoyalty.setUsed_points(AppLocal.currentCustomerLoyalty.getUsed_points() + price_point);
        }
    }

    public void increaseSoldeCustomer(double price_point) {
        if (AppLocal.currentCustomerLoyalty != null) {
            AppLocal.currentCustomerLoyalty.setUsed_points(AppLocal.currentCustomerLoyalty.getUsed_points() - price_point);
        }
    }

    public void setCagnoteCustomer(TicketInfo ticket, String keenio, String order_id, boolean is_validate) {
        this.setCagnoteCustomer(ticket, ticket.getCustomer_loyalty_id(), keenio, order_id, is_validate);
    }

    public void saveOrderBorne(final TicketInfo ticket) {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean printErrorRecap = false;
                    BufferedImage result = null;
                    String barCode = null;
                    ticket.setSent_from("borne");
                    TicketService.this.prepareLineKitchen(ticket);
                    if (AppLocal.KITCHEN_COMPOSITE) {
                        int num_order_kitchen = 0;
                        int id_order_kitchen = 0;
                        System.out.println("AppLocal.SEND_NOPAID_ORDER_TOKITCHEN : " + AppLocal.SEND_NOPAID_ORDER_TOKITCHEN);
                        if (AppLocal.SEND_NOPAID_ORDER_TOKITCHEN) {
                            AppLocal.dlSales.setDlItems(AppLocal.dlItems);
                            OrderService orderService = OrderService.getInstance();
                            num_order_kitchen = orderService.getLastNumOrderKitchen(3);
                            ticket.setNum_order_kitchen(num_order_kitchen);
                            TicketInfo ticketToSendToMysql = (TicketInfo)ticket.clone();
                            TicketInfo ticketToSendKitchenPrinter = (TicketInfo)ticket.clone();
                            Orders order_kitchen = null;
                            OrderKitchenScreenService mOrderKitchenScreenService = new OrderKitchenScreenService(AppLocal.dlSales, AppLocal.dlProduct, AppLocal.dlOrders, AppLocal.dlItems);
                            Object[] resultAddOrder = mOrderKitchenScreenService.sendOrderToKitchen(order_kitchen, ticketToSendToMysql, false, false);
                            id_order_kitchen = resultAddOrder != null ? (Integer)resultAddOrder[0] : 0;
                            TicketService.this.sendNotificationMysql(null, null);
                            TicketService.this.prepareTicketOptions(ticketToSendKitchenPrinter);
                            TicketService.this.printKitchen(ticketToSendKitchenPrinter, false, null, true, false);
                            if (!(AppLocal.PRINT_LABEL_TAKE_AWAY && !ticket.getType().equals("A Emporter") || AppLocal.PRINT_LABEL_PRODUCT_WITH_EXCLUDED_INFREDIENT && !ticket.hasProductWithExludedIngredient())) {
                                TicketInfo tikcetToSendToLabelPrinter = (TicketInfo)ticket.clone();
                                TicketService.this.printLabel(tikcetToSendToLabelPrinter);
                            }
                            if (AppLocal.PRINT_RECAP) {
                                TicketInfo ticketToSendRecapPrinter = (TicketInfo)ticket.clone();
                                TicketService.this.printRecap(ticketToSendRecapPrinter, false, false, null);
                            }
                        }
                        if (AppLocal.SAVE_ORDER_SLAVE) {
                            Tickets order = OrderSharedBuilder.create(ticket, "borne", "bar", false);
                            order.setNum_order_kitchen(num_order_kitchen);
                            order.setId_order_kitchen(id_order_kitchen);
                            System.out.println("******* avomark active user :" + (AppLocal.MODULE_AVOMARK && AppLocal.currentAvomarkClient != null));
                            if (AppLocal.MODULE_AVOMARK && AppLocal.currentAvomarkClient != null) {
                                System.out.println("******* id customer :" + AppLocal.currentAvomarkClient.getId());
                                order.setAvomarkCustomer(AppLocal.currentAvomarkClient.getId());
                            }
                            TicketSharedService mTicketSharedService = TicketSharedService.getInstance();
                            int id_order = mTicketSharedService.sendOrder(order, 2);
                            System.out.println("+++++++++ id_order sendOrder: " + id_order);
                            if (id_order != -1) {
                                if (AppLocal.PRINTED_CODE == null || AppLocal.PRINTED_CODE.equalsIgnoreCase("QRCode")) {
                                    result = QrCodeHelper.orderToImageQrCode(null, null, id_order);
                                } else {
                                    barCode = order.getBarcode();
                                }
                            } else {
                                result = QrCodeHelper.orderToImageQrCode(ticket, "borne", -1);
                                Object orderNum = ticket.getNum_order_borne();
                                String prefix = ticket.getCaisse() != null && !ticket.getCaisse().isEmpty() && ticket.getCaisse().length() <= 2 ? ticket.getCaisse() + "-" : "C-";
                                orderNum = prefix + (String)orderNum;
                                printErrorRecap = true;
                                TicketService.this.printRecap(ticket, false, true, (String)orderNum);
                            }
                        }
                    } else {
                        result = QrCodeHelper.orderToImageQrCode(ticket, "borne", -1);
                    }
                    MarqueNFC marqueNF = MarqueNFC.fetchOrStore(TicketService.this.dlSales);
                    EnteteInfo entetTicket = new EnteteInfo("", "0", "10.0.1.27", 0, marqueNF.getCompany(), marqueNF.getAdresse1(), marqueNF.getZipCode(), marqueNF.getCity(), marqueNF.getCountry(), marqueNF.getSiret(), marqueNF.getCodeNAF(), marqueNF.getIntraTVA(), ticket.getDate(), "Commande", ticket.getLinesCount(), ticket.getId(), AppLocal.header, AppLocal.footer, "pending", "", "1", "BIBORNE", TicketService.this.getIdUser(), true, true, "impression papier", 0, TicketService.this.getNamrUser());
                    PrinterHelper printer = new PrinterHelper();
                    Decreaser decreaser = new Decreaser(TicketService.this.dlSales, ticket.getId(), "Commande", null, ticket.getNumero_order());
                    printer.printTicketBorneCustomer(ticket, entetTicket, 1L, result, decreaser, barCode);
                    if (AppLocal.PRINT_RECAP_STANDALONE && !printErrorRecap) {
                        Object orderNum = ticket.getNum_order_borne();
                        String prefix = ticket.getCaisse() != null && !ticket.getCaisse().isEmpty() && ticket.getCaisse().length() <= 2 ? ticket.getCaisse() + "-" : "C-";
                        orderNum = ticket.getNum_order_kitchen() != -1 && ticket.getNum_order_kitchen() != 0 ? String.valueOf(ticket.getNum_order_kitchen()) : prefix + (String)orderNum;
                        TicketService.this.printRecap(ticket, false, true, (String)orderNum);
                    }
                    System.out.println("AppLocal.CUSTOMER_LOYALTY : " + AppLocal.CUSTOMER_LOYALTY);
                    if (AppLocal.CUSTOMER_LOYALTY) {
                        TicketService.this.setCagnoteCustomer(AppLocal.currentCustomerLoyalty, ticket, AppLocal.CUSTOMER_LOYALTY_ID, AppLocal.getKeenio(), ticket.getId(), false);
                    }
                    AppLocal.currentCustomerLoyalty = null;
                    AppLocal.currentAvomarkClient = null;
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        });
    }

    public void setCustomerLoyalty(TicketInfo ticket) {
        this.setCustomerLoyalty(ticket, ticket.getCustomer_loyalty_id());
    }

    private void updateKitchenScreenOrder(final TicketInfo ticket) {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (AppLocal.HOSTNAME_DB != null) {
                    try {
                        OrderKitchenScreenService mOrderKitchenScreenService = new OrderKitchenScreenService(TicketService.this.dlSales, TicketService.this.dlProduct, TicketService.this.dlOrder, TicketService.this.dlItems);
                        mOrderKitchenScreenService.updateOrderKitchen(ticket, true);
                        TicketService.this.sendNotificationMysql(null, null);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            }
        });
    }

    private void disableUpdate(int id_order_kitchen) {
        try {
            this.orderService.disableUpdate(id_order_kitchen);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void updateKitchenOrder(final TicketInfo ticket) {
        if (AppLocal.KITCHEN_COMPOSITE) {
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    if (AppLocal.HOSTNAME_DB != null) {
                        try {
                            OrderKitchenScreenService mOrderKitchenScreenService = new OrderKitchenScreenService(TicketService.this.dlSales, TicketService.this.dlProduct, TicketService.this.dlOrder, TicketService.this.dlItems);
                            mOrderKitchenScreenService.updateOrderKitchen(ticket, true);
                            TicketService.this.sendNotificationMysql(null, null);
                            if (ticket.getId_shared_order() != 0 && ticket.getId_shared_order() != -1) {
                                Tickets order = OrderSharedBuilder.create(ticket, "caisse", null, true);
                                TicketService.this.mTicketSharedService.updateOrder(order);
                            }
                        }
                        catch (Exception ex) {
                            LogToFile.log("severe", ex.getMessage(), ex);
                        }
                    }
                }
            });
        } else {
            TicketInfo ticketToPrinter = (TicketInfo)ticket.clone();
            Executors.newSingleThreadExecutor().execute(() -> {
                try {
                    List<PrinterInfo> displayKitchens = this.dlSales.getDisplayKitchens();
                    for (PrinterInfo displayKitchen : displayKitchens) {
                        TicketInfo ticketToSendToDisplay = (TicketInfo)ticketToPrinter.clone();
                        ticketToSendToDisplay.getLines().clear();
                        for (TicketLineInfo line : ticketToPrinter.getLines()) {
                            if (line.isNext()) {
                                ticketToSendToDisplay.getLines().add(line);
                                continue;
                            }
                            if (CacheFinder.findProductInfoById(this.mSharedMemoryCache, this.dlSales, line.getProductID()).getDisplayKitchen() != displayKitchen.getId()) continue;
                            line.getIngredientsInclus();
                            ticketToSendToDisplay.getLines().add(line);
                        }
                        if (ticketToSendToDisplay.getLines().size() <= 0) continue;
                        this.getRemoteAddOrder(displayKitchen, ticketToSendToDisplay).updateOrderKitchen(ticketToSendToDisplay);
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("sever", ex.getMessage(), ex);
                }
            });
        }
    }

    private void paidOrderByTicket(String id_ticket, int id_shared_order, boolean sendNotification) {
        try {
            this.orderService.paidOrderByTicket(id_ticket);
            if (sendNotification) {
                this.sendPaidOrderNotification(id_shared_order);
            }
        }
        catch (Exception ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
        }
    }

    public void acceptOnLineOrder(TicketInfo ticket, boolean onlinePayment) {
        if (this.dlSales.isValidPeriod()) {
            if (ticket.getCustomer() != null && ticket.getCustomer().getId() == null) {
                if (this.mCustomerService == null) {
                    this.mCustomerService = CustomerService.getInstance();
                }
                if (this.mAddressService == null) {
                    this.mAddressService = AddressService.getInstance();
                }
                CustomerInfo mCustomerInfo = this.mCustomerService.findOneByPhone(ticket.getCustomerPhone());
                AddressInfo mAddressInfo = ticket.getAddressInfo();
                if (mCustomerInfo == null) {
                    try {
                        mCustomerInfo = ticket.getCustomer();
                        this.mCustomerService.saveWithAddress(mCustomerInfo, mAddressInfo);
                        ticket.setAddressInfo(mAddressInfo);
                    }
                    catch (BasicException ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                } else {
                    AddressInfo addressedb = this.mAddressService.findAddress(mAddressInfo, mCustomerInfo.getId());
                    if (addressedb == null || addressedb.getId() == null) {
                        mAddressInfo.setCustomer(mCustomerInfo);
                        this.mAddressService.saveAddress(mAddressInfo);
                        ticket.setAddressInfo(mAddressInfo);
                    } else {
                        ticket.setAddressInfo(addressedb);
                    }
                }
                mCustomerInfo.setLoyaltyCardCollection(this.mLoyaltyCardService.findByCustomer(mCustomerInfo.getId()));
                ticket.setCustomer(mCustomerInfo);
                if (ticket.getAddressInfo() != null) {
                    ticket.setAddress(ticket.getAddressInfo().getId());
                }
            }
            this.acceptOnlineOrder(ticket, false, onlinePayment, 0);
        }
    }

    public int cancelPayment(double total_order) {
        int result = 0;
        double amount = NumericUtils.round(total_order);
        PaymentByCardFacade facade = PaymentByCardFacade.getInstance(this.m_App);
        if (facade.isActivated()) {
            result = facade.doCancel(amount, "");
            if (!facade.isTransactionSuccessed(result)) {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, facade.getErrorMessage(result), 4000, NPosition.BOTTOM_RIGHT);
            } else {
                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Paiement annul\u00e9", 4000, NPosition.BOTTOM_RIGHT);
            }
        }
        return result;
    }

    public TicketInfo getTicketByIDandSharedId(TicketInfo ticket) throws BasicException {
        TicketInfo local_ticket = this.dlSales.getTicketById(ticket.getIdSourceSharedOrder(), ticket.getId_shared_order());
        if (local_ticket != null) {
            local_ticket.setLines(ticket.getLines());
            local_ticket.setShared_order(ticket.isShared_order());
            local_ticket.setDiscount(ticket.getDiscount());
            local_ticket.setTypeDiscount(ticket.getTypeDiscount());
        }
        return local_ticket;
    }

    public void updateLocalOrder(TicketInfo ticket) throws BasicException, SQLException {
        ticket.setLastUpdate(new Date());
        this.dlSales.updateTicket(ticket, this.m_App.getInventoryLocation(), this.m_App.getAppUserView().getUser());
    }

    public void calculLineTaxes(TicketInfo ticket) {
        for (TicketLineInfo line : ticket.getLines()) {
            Double ht = (line.getPrice() * line.getMultiply() - line.getDiscount()) / (1.0 + line.getTaxRate());
            line.setHtAmount(ht);
            line.setTaxAmount(line.getPrice() * line.getMultiply() - line.getDiscount() - ht);
        }
    }

    public JustificatifPayment getJustificatifPaymentByTicket(TicketInfo ticket) {
        try {
            JustificatifPayment mJustificatifPayment = this.dlSales.getJustificatifPaymentByTicket(ticket.getId());
            return mJustificatifPayment;
        }
        catch (BasicException ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
            return null;
        }
    }

    public boolean isExistJustificatifPayment(TicketInfo ticket) {
        try {
            JustificatifPayment mJustificatifPayment = this.dlSales.getJustificatifPaymentByTicket(ticket.getId());
            return mJustificatifPayment != null;
        }
        catch (BasicException ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
            return false;
        }
    }

    public void printTicketSansDetail(final TicketInfo ticketToPrint, final int couvert, final String motif_impression) throws BasicException {
        final EnteteInfo entetTicket = this.dlSales.getEnteteByTicket(ticketToPrint.getId(), ticketToPrint.isPaid());
        ticketToPrint.setPayments(this.dlSales.findPaymetsByIdTicket(ticketToPrint.getId()));
        List<TicketLineInfo> lines = this.dlSales.loadLines(ticketToPrint.getId());
        List<TicketLineInfo> linesExterne = this.dlSales.getTicketLineExterne(ticketToPrint.getId());
        lines.addAll(linesExterne);
        ticketToPrint.setLines(lines);
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    PrinterHelper printer = new PrinterHelper();
                    Decreaser decreaser = null;
                    boolean validPrinter = Printer.isPrinterValid(printer.getPrinterCaisse());
                    JustificatifPayment mJustificatifPayment = TicketService.this.getJustificatifPaymentByTicket(ticketToPrint);
                    if (mJustificatifPayment == null) {
                        mJustificatifPayment = new JustificatifPayment();
                        mJustificatifPayment.setTimestampGDH(new Date());
                        mJustificatifPayment.setTicket(ticketToPrint.getId());
                        JustificatifPayment lastJustificatifPayment = null;
                        if (validPrinter && mJustificatifPayment != null) {
                            lastJustificatifPayment = TicketService.this.dlSales.addJustificatifPayment(mJustificatifPayment);
                            mJustificatifPayment.setId(lastJustificatifPayment.getId());
                            mJustificatifPayment.setSignature(lastJustificatifPayment.getSignature());
                        }
                        decreaser = new Decreaser(TicketService.this.dlSales, ticketToPrint.getId(), "JUSTIFICATIF_PAYMENT", ticketToPrint.getNumero_order(), mJustificatifPayment);
                        printer.printTikcetSansDetail(ticketToPrint, entetTicket, decreaser, couvert, null, mJustificatifPayment);
                    } else {
                        UserInfo user = TicketService.this.getCurrentUser();
                        DuplicataJustificatifPayment duplicataJustificatifPayment = new DuplicataJustificatifPayment(mJustificatifPayment, user.getId(), motif_impression);
                        DuplicataJustificatifPayment previousDuplicata = TicketService.this.dlSales.getDuplicataJustificatifPaymentById(mJustificatifPayment.getId(), "JUSTIFICATIF_PAIEMENT");
                        int nbPrint = 1;
                        if (previousDuplicata != null) {
                            nbPrint = previousDuplicata.getImpression_number() + 1;
                        }
                        duplicataJustificatifPayment.setImpression_number(nbPrint);
                        DuplicataJustificatifPayment lastDuplicata = null;
                        if (validPrinter && duplicataJustificatifPayment != null) {
                            lastDuplicata = TicketService.this.dlSales.addDuplicataJustificatidPayment(duplicataJustificatifPayment);
                            duplicataJustificatifPayment.setId(lastDuplicata.getId());
                            duplicataJustificatifPayment.setSignature(lastDuplicata.getSignature());
                            duplicataJustificatifPayment.setNum_justificatif_payment(lastDuplicata.getNum_justificatif_payment());
                        }
                        decreaser = new Decreaser(TicketService.this.dlSales, ticketToPrint.getId(), "DUPLICATA_JUSTIFICATIF_PAYMENT", duplicataJustificatifPayment);
                        printer.printTikcetSansDetail(ticketToPrint, entetTicket, decreaser, couvert, duplicataJustificatifPayment, null);
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        });
    }

    public void printFacture(EnteteInfo entetTicket, TicketInfo ticket, Facture currentFacture) {
        try {
            PrinterHelper printer = new PrinterHelper();
            MarqueNFC marqueNFC = this.dlSales.getMarqueNF();
            if (currentFacture.getNb_print() == 0) {
                Decreaser decreaser = new Decreaser(this.dlSales, ticket.getId(), "FACTURE", null, ticket.getNumero_order());
                printer.printFacture(currentFacture, ticket, entetTicket, 0, decreaser, null);
            } else {
                try {
                    UserInfo user = this.getCurrentUser();
                    Duplicata mDuplicataFacture = new Duplicata(ticket.getTicketId(), ticket.getId(), "Facture", user.getId(), new Integer(entetTicket.getNumDoc()), null, (int)currentFacture.getId(), 0);
                    long impressionNumber = this.dlSales.getNumberPrintDuplicata(ticket.getId(), "Facture");
                    currentFacture.setNb_print((int)impressionNumber);
                    mDuplicataFacture.setDate_impression(new Date());
                    boolean validPrinter = Printer.isPrinterValid(printer.getPrinterCaisse());
                    Duplicata lastDuplicata = null;
                    if (validPrinter && mDuplicataFacture != null) {
                        lastDuplicata = this.dlSales.addDuplicataAndReturnNumberPrint(mDuplicataFacture);
                        mDuplicataFacture.setId(lastDuplicata.getId());
                        mDuplicataFacture.setSignature(lastDuplicata.getSignature());
                    }
                    Decreaser decreaser = new Decreaser(this.dlSales, ticket.getId(), "DUPLICATA", mDuplicataFacture, ticket.getNumero_order());
                    printer.printFacture(currentFacture, ticket, entetTicket, (int)impressionNumber, decreaser, mDuplicataFacture);
                }
                catch (BasicException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public Facture addFacture(Facture facture, String codeOperator) {
        try {
            UserInfo user;
            if (this.mCustomerService == null) {
                this.mCustomerService = CustomerService.getInstance();
            }
            CustomerInfo mCustomerInfo = null;
            if (facture.getSiret() != null && !facture.getSiret().isEmpty()) {
                mCustomerInfo = this.mCustomerService.findOneByPhoneSiret(facture.getSiret());
            }
            if (mCustomerInfo == null) {
                mCustomerInfo = new CustomerInfo();
                mCustomerInfo.setName(facture.getName_contact());
                mCustomerInfo.setCompanyname(facture.getCompany());
                mCustomerInfo.setSiret(facture.getSiret());
                mCustomerInfo.setNum_tva(facture.getNum_tva());
                AddressInfo addressCustomer = new AddressInfo();
                addressCustomer.setAddress(facture.getAddress());
                addressCustomer.setZipcode(facture.getZip_code());
                addressCustomer.setCity(facture.getCity());
                this.mCustomerService.saveWithAddress(mCustomerInfo, addressCustomer);
            }
            if (mCustomerInfo.getId() != 0) {
                facture.setId_customer(mCustomerInfo.getId());
            }
            if ((user = this.getCurrentUser()) != null) {
                facture.setCode_operator(user.getId());
                facture.setName_operator(user.getName());
            } else {
                facture.setCode_operator("0");
            }
            MarqueNFC marqueNF = this.dlSales.getMarqueNF();
            if (marqueNF != null) {
                facture.setCompany_sender(marqueNF.getCompany());
                facture.setAddress_sender(marqueNF.getAdresse1());
                facture.setZip_code_sender(marqueNF.getZipCode());
                facture.setCity_sender(marqueNF.getCity());
                facture.setCountry_sender(marqueNF.getCountry());
                facture.setSiret_sender(marqueNF.getSiret());
                facture.setCode_NAF_sender(marqueNF.getCodeNAF());
                System.out.println("marqueNF.getIntraTVA() : " + marqueNF.getIntraTVA());
                facture.setNum_tva_sender(marqueNF.getIntraTVA());
                System.out.println("facture.getIntraTVA() : " + facture.getNum_tva_sender());
                facture.setForme_juridique_sender(marqueNF.getForme_juridique());
                facture.setCapital_social_sender(marqueNF.getCapital_social());
                facture.setRCS_sender(marqueNF.getRcs());
                facture.setGreffe_sender(marqueNF.getGreffe());
                facture.setMetier_sender(marqueNF.getMetier());
            }
            facture.setReglement_tva_sender("TVA sur les encaissements");
            return this.dlSales.addFacture(facture, codeOperator);
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return null;
        }
    }

    private String getIdUser() {
        UserInfo user = this.getCurrentUser();
        return user != null ? user.getId() : "0";
    }

    public void prepareTicketCuisine(TicketInfo ticket) {
        this.printers.clear();
        this.productToSend.clear();
        this.productEMP.clear();
        this.productEmpLater.clear();
        this.productSpLater.clear();
        this.listDelete.clear();
        this.subProductLater.clear();
        this.prepareTicketCuisine(ticket, this.printers, this.productToSend, this.productEMP, this.productSpLater, this.productEmpLater, this.linesdeleted);
    }

    private void prepareTicketCuisine(TicketInfo ticket, List<PrinterInfo> printers, List<TicketLineInfo> productToSend, List<TicketLineInfo> productEMP, List<TicketLineInfo> productSpLater, List<TicketLineInfo> productEmpLater, List<TicketLineInfo> linesdeleted) {
        for (TicketLineInfo line : ticket.getLines()) {
            if (line.isDiver() || line.isSend_kitchen()) continue;
            if (!line.isNext()) {
                boolean sendProduct = false;
                try {
                    ProductInfoExt productTmp = CacheFinder.findProductInfoById(this.mSharedMemoryCache, this.dlSales, line.getProductID());
                    if (productTmp != null && productTmp.getPrinterID() != -1) {
                        CategoryInfo category = CacheFinder.findCategoryInfoById(this.mSharedMemoryCache, this.dlSales, productTmp.getCategoryid());
                        if (category != null) {
                            line.setOffset_print_kitchen(category.getOffset_print_kitchen());
                        }
                        sendProduct = true;
                        line.setPrinterID(productTmp.getPrinterID());
                        line.setPrint_ingredients(productTmp.isPrint_ingredients());
                        PrinterInfo printerTmp = this.dlSales.getPrinterByID(productTmp.getPrinterID());
                        if (printerTmp != null) {
                            int found = -1;
                            for (PrinterInfo printer : printers) {
                                if (printer.getId() != printerTmp.getId()) continue;
                                found = 1;
                            }
                            if (found == -1) {
                                printers.add(printerTmp);
                            }
                        }
                    }
                    if (line.getTime_served() == null || !line.getTime_served().equalsIgnoreCase("later")) {
                        boolean addSubItemsLater = false;
                        for (OptionItemOrder supplement : line.getListSupplements()) {
                            if (supplement.getId_sub_product() == 0 || supplement.getTime_served() == null || !supplement.getTime_served().equalsIgnoreCase("later")) continue;
                            addSubItemsLater = true;
                            break;
                        }
                        if (addSubItemsLater) {
                            ArrayList<OptionItemOrder> options = new ArrayList<OptionItemOrder>();
                            HashMap<Integer, ProductTicket> subProductsFromOptions = new HashMap<Integer, ProductTicket>();
                            for (OptionItemOrder supplement : line.getListSupplements()) {
                                ProductInfoExt subProduct;
                                boolean added_as_item = false;
                                if (supplement.getId_sub_product() != 0 && supplement.getTime_served() != null && supplement.getTime_served().equalsIgnoreCase("later") && (subProduct = this.dlItems.getProductInfoById(supplement.getId_sub_product())) != null) {
                                    added_as_item = true;
                                    ProductTicket productTicket = new ProductTicket(subProduct, -1, null, supplement.getNumberOption(), 1, null, subProduct.getRef_web(), null, null);
                                    productTicket.setTime_served("later");
                                    subProductsFromOptions.put(supplement.getOption().getiD(), productTicket);
                                    line.getListProducts().add(productTicket);
                                }
                                if (added_as_item) continue;
                                if ((supplement.getIdProduct() == 0 || supplement.getIdProduct() == -1) && supplement.getParent_supplement_id() != 0 && subProductsFromOptions.containsKey(supplement.getParent_supplement_id())) {
                                    ProductTicket productTicket = (ProductTicket)subProductsFromOptions.get(supplement.getParent_supplement_id());
                                    supplement.setIdProduct(productTicket.getIdProduct());
                                    supplement.setIndex_carte(productTicket.getIndex_carte());
                                    if (productTicket.getSupplements() == null) {
                                        productTicket.setSupplements(new ArrayList<OptionItemOrder>());
                                    }
                                    productTicket.getSupplements().add((OptionItemOrder)supplement.clone());
                                }
                                options.add(supplement);
                            }
                            line.setListSupplements(options);
                        }
                    }
                    for (ProductTicket product : line.getListProducts()) {
                        if (product.getPrinterID() == -1) continue;
                        sendProduct = true;
                        PrinterInfo printerTmp = this.dlSales.getPrinterByID(product.getPrinterID());
                        if (printerTmp == null) continue;
                        int found = -1;
                        for (PrinterInfo printer : printers) {
                            if (printer.getId() != printerTmp.getId()) continue;
                            found = 1;
                        }
                        if (found != -1) continue;
                        printers.add(printerTmp);
                    }
                    if (!sendProduct) continue;
                    this.setLineDescription(line);
                    productToSend.add(line);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                continue;
            }
            TicketLineInfo linePrevious = new TicketLineInfo();
            linePrevious.setNext(true);
            productToSend.add(linePrevious);
        }
        if (linesdeleted != null) {
            for (TicketLineInfo line : linesdeleted) {
                try {
                    ProductInfoExt productTmp = CacheFinder.findProductInfoById(this.mSharedMemoryCache, this.dlSales, line.getProductID());
                    if (productTmp == null || productTmp.getPrinterID() == -1) continue;
                    line.setPrinterID(productTmp.getPrinterID());
                    line.setPrint_ingredients(productTmp.isPrint_ingredients());
                    PrinterInfo printerTmp = this.dlSales.getPrinterByID(productTmp.getPrinterID());
                    int found = -1;
                    for (PrinterInfo printer : printers) {
                        if (printer.getId() != printerTmp.getId()) continue;
                        found = 1;
                    }
                    if (found != -1) continue;
                    printers.add(printerTmp);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
    }

    public void sendPaidOrderNotification(int id_order) throws IOException {
        this.mNotificationClientService.sendPaidOrderNotification(id_order);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        try {
            Object[] result = (Object[])evt.getNewValue();
            int id_shared_order = (Integer)result[0];
            TicketInfo ticket = this.dlSales.getTicketByIdShared(id_shared_order);
            if (ticket != null) {
                String userID = "";
                if (this.m_App.getAppUserView() != null && this.m_App.getAppUserView().getUser() != null) {
                    userID = this.m_App.getAppUserView().getUser().getId();
                } else {
                    UserInfo userInfo = new UserInfo(AppLocal.user != null ? AppLocal.user : AppLocal.user_maintenance);
                    userID = userInfo.getId();
                }
                this.dlSales.cancelOrderPending(ticket, this.reason_cancel, userID, true);
                Platform.runLater(() -> this.support.firePropertyChange(this.RELOAD_ORDERS, null, null));
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void setCustomerLoyalty(TicketInfo ticket, String customer_loyalty_id) {
        if (ticket.getCustomerPhone() != null && !ticket.getCustomerPhone().isEmpty() && customer_loyalty_id != null && !customer_loyalty_id.isEmpty()) {
            Executors.newSingleThreadExecutor().execute(() -> {
                CustomerLoyalty mCustomerLoyalty = this.mLoyaltyService.getCagnoteByLoyaltyUser(ticket.getCustomerPhone(), customer_loyalty_id);
                ticket.setmCustomerLoyalty(mCustomerLoyalty);
            });
        }
    }

    public void setCagnoteCustomer(TicketInfo ticket, String customer_loyalty_id, String keenio, String order_id, boolean is_validate) {
        if (ticket.getCustomerPhone() != null && !ticket.getCustomerPhone().isEmpty() && customer_loyalty_id != null && !customer_loyalty_id.isEmpty()) {
            Executors.newSingleThreadExecutor().execute(() -> {
                CustomerLoyalty mCustomerLoyalty = this.mLoyaltyService.getCagnoteByLoyaltyUser(ticket.getCustomerPhone(), customer_loyalty_id);
                System.out.println("+++mCustomerLoyalty" + mCustomerLoyalty);
                if (mCustomerLoyalty != null) {
                    this.setCagnoteCustomer(mCustomerLoyalty, ticket, customer_loyalty_id, keenio, order_id, is_validate);
                }
            });
        }
    }

    public void loadInfoSharedOrder(TicketInfo ticket) {
        try {
            this.prepareLines(ticket, ticket.getType());
            if (ticket.getTotal() >= 0.0) {
                ticket.resetPayments();
            }
            for (TicketLineInfo line : ticket.getLines()) {
                List<SupplementItemInfo> ingrediens = this.dlSales.getIngredientsByProducts(line.getProductID(), true, false);
                line.setListIngredientsIN(ingrediens);
            }
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public FinancialReportInfo getRapport(Date dateStart, Date dateEnd) {
        try {
            List<TaxeLine> taxes = this.dlSales.getTaxesBetwen(dateStart, dateEnd);
            List<UserCaisseInfo> users = this.dlSales.getCAbyUser(dateStart, dateEnd);
            List<RankTypeOrder> dataTypeOrders = AppLocal.dlStats.loadSatisticOrderByType(dateStart, dateEnd);
            List<RankTypeOrder> dataTypePlatformOrders = AppLocal.dlStats.loadPlatformOrdersByType(dateStart, dateEnd);
            List<PaymentLine> payments = this.dlSales.loadPayment(dateStart, dateEnd);
            Double turnover = this.dlSales.getCA(dateStart, dateEnd);
            Integer nbOrders = this.dlSales.getNbOrder(dateStart, dateEnd);
            Double totalDiscount = AppLocal.dlStats.getTotalDiscountOrderOfType(dateStart, dateEnd, "pourcentage") + AppLocal.dlStats.getTotalDiscountOrderOfType(dateStart, dateEnd, "somme");
            Double totalDiscountLines = AppLocal.dlStats.getTotalDiscountOnTicketLines(dateStart, dateEnd);
            Double turnoverCanceled = this.dlSales.getTurnoverCanceled(dateStart, dateEnd);
            List<TicketInfo> ordersCanceled = this.dlSales.loadTicketCanceled(dateStart, dateEnd);
            List<TicketInfo> notesCanceled = this.dlSales.loadNotesCanceled(dateStart, dateEnd);
            List<TicketInfo> discountOrders = this.dlSales.discountOrders(dateStart, dateEnd);
            int currentHour = new Date().getHours();
            Calendar calendarStart = Calendar.getInstance();
            calendarStart.setTime(dateStart);
            calendarStart.add(5, -4);
            Date dateStartLastWeek = calendarStart.getTime();
            Calendar calendarEnd = Calendar.getInstance();
            calendarEnd.setTime(dateEnd);
            calendarEnd.add(5, -4);
            Date dateEndLastWeek = calendarEnd.getTime();
            Double turnoverLasWeekSameHour = AppLocal.dlStats.loadSatisticByHour(dateStartLastWeek, dateEndLastWeek, currentHour);
            List<HourInfo> salesByHour = AppLocal.dlStats.loadSatisticByHour(dateStart, dateEnd, false);
            List<GroupedTax> groupedTaxes = AppLocal.dlStats.getGlobalTaxes(dateStart, dateEnd);
            TotaleEncaissement totaleEncaissement = AppLocal.dlStats.getTotalEncaissement(dateStart, dateEnd);
            double total_ht_taxable = totaleEncaissement != null ? totaleEncaissement.getTotal_ht_taxable() : 0.0;
            double total_ht_no_taxable = totaleEncaissement != null ? totaleEncaissement.getTotal_ht_no_taxable() : 0.0;
            this.calculDiscountOrders(discountOrders);
            FinancialReportInfo financialReportInfo = new FinancialReportInfo();
            financialReportInfo.setTurnover(turnover != null ? turnover : 0.0);
            financialReportInfo.setNumberOrders(nbOrders != null ? nbOrders : 0);
            financialReportInfo.setPayments(payments);
            financialReportInfo.setDataTypeOrders(dataTypeOrders);
            financialReportInfo.setDataTypePlatformOrders(dataTypePlatformOrders);
            financialReportInfo.setTaxes(taxes);
            financialReportInfo.setTotalDiscount(totalDiscount != null ? totalDiscount : 0.0);
            financialReportInfo.setTotalDiscountOnLines(totalDiscountLines != null ? totalDiscountLines : 0.0);
            financialReportInfo.setUsers(users);
            financialReportInfo.setTurnoverCanceled(turnoverCanceled != null ? turnoverCanceled : 0.0);
            financialReportInfo.setOrdersCanceled(ordersCanceled);
            financialReportInfo.setNotesCanceled(notesCanceled);
            financialReportInfo.setDiscountOrders(discountOrders);
            financialReportInfo.setTurnoverLasWeekSameHour(turnoverLasWeekSameHour != null ? turnoverLasWeekSameHour : 0.0);
            financialReportInfo.setSalesByHour(salesByHour);
            financialReportInfo.setGroupedTaxes(groupedTaxes);
            financialReportInfo.setTotal_ht_taxable(total_ht_taxable);
            financialReportInfo.setTotal_ht_no_taxable(total_ht_no_taxable);
            return financialReportInfo;
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return null;
        }
    }

    public JSONObject getRapportJSON(Date dateStart, Date dateEnd) {
        FinancialReportInfo financialReportInfo = this.getRapport(dateStart, dateEnd);
        if (financialReportInfo != null) {
            JSONObject objectRoot = new JSONObject();
            objectRoot.put("turnover", financialReportInfo.getTurnover());
            objectRoot.put("nbOrders", financialReportInfo.getNumberOrders());
            List<PaymentLine> payments = financialReportInfo.getPayments();
            List<TicketInfo> ordersCanceled = financialReportInfo.getOrdersCanceled();
            List<TicketInfo> notesCanceled = financialReportInfo.getNotesCanceled();
            List<TicketInfo> discountOrders = financialReportInfo.getDiscountOrders();
            List<HourInfo> salesHour = financialReportInfo.getSalesByHour();
            JSONArray paymentsArray = new JSONArray();
            for (PaymentLine payment : payments) {
                JSONObject objectPayment = new JSONObject();
                objectPayment.put("name_payment", (Object)payment.getM_PaymentType());
                objectPayment.put("total_payment", (Object)payment.getM_PaymentValue());
                objectPayment.put("number_payment", payment.getNombre());
                paymentsArray.put((Object)objectPayment);
            }
            objectRoot.put("payments", (Object)paymentsArray);
            List<RankTypeOrder> dataTypeOrders = financialReportInfo.getDataTypeOrders();
            JSONArray dataTypeOrderArray = new JSONArray();
            for (RankTypeOrder dataTypeOrder : dataTypeOrders) {
                JSONObject objectdataTypeOrder = new JSONObject();
                objectdataTypeOrder.put("name_type_order", (Object)dataTypeOrder.getName());
                objectdataTypeOrder.put("turnover_type_order", dataTypeOrder.getCa());
                dataTypeOrderArray.put((Object)objectdataTypeOrder);
            }
            objectRoot.put("typeOrders", (Object)dataTypeOrderArray);
            List<RankTypeOrder> dataTypePlatformOrders = financialReportInfo.getDataTypePlatformOrders();
            JSONArray dataTypePlatformOrderArray = new JSONArray();
            for (RankTypeOrder dataTypePlatformOrder : dataTypePlatformOrders) {
                JSONObject objectdataTypePlatformOrder = new JSONObject();
                objectdataTypePlatformOrder.put("name_type_order", (Object)dataTypePlatformOrder.getName());
                objectdataTypePlatformOrder.put("turnover_type_order", dataTypePlatformOrder.getCa());
                dataTypePlatformOrderArray.put((Object)objectdataTypePlatformOrder);
            }
            objectRoot.put("typePlatformOrders", (Object)dataTypePlatformOrderArray);
            List<TaxeLine> taxes = financialReportInfo.getTaxes();
            JSONArray taxesArray = new JSONArray();
            for (TaxeLine taxe : taxes) {
                JSONObject objectTaxe = new JSONObject();
                objectTaxe.put("id_taxe", (Object)taxe.getId());
                objectTaxe.put("name_taxe", (Object)taxe.getName());
                objectTaxe.put("taxe", taxe.getTax());
                taxesArray.put((Object)objectTaxe);
            }
            objectRoot.put("taxes", (Object)taxesArray);
            objectRoot.put("totalDiscount", financialReportInfo.getTotalDiscount());
            objectRoot.put("totalDiscountLines", financialReportInfo.getTotalDiscountOnLines());
            List<UserCaisseInfo> users = financialReportInfo.getUsers();
            JSONArray usersArray = new JSONArray();
            for (UserCaisseInfo userCaisseInfo : users) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("id_user", (Object)userCaisseInfo.getId());
                jSONObject.put("name_user", (Object)userCaisseInfo.getName());
                jSONObject.put("turnover_user", (Object)userCaisseInfo.getTotal());
                usersArray.put((Object)jSONObject);
            }
            objectRoot.put("users", (Object)usersArray);
            objectRoot.put("host_name", (Object)AppLocal.source_order);
            objectRoot.put("turnover_canceled", financialReportInfo.getTurnoverCanceled());
            JSONArray canceledOrdersArray = new JSONArray();
            for (TicketInfo ticketInfo : ordersCanceled) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("num_order", ticketInfo.getNumberOrderTorint());
                jSONObject.put("date_order", (Object)this.dateFormatterFull.format(ticketInfo.getDate()));
                jSONObject.put("user_order", (Object)(ticketInfo.getUser() != null ? ticketInfo.getUser().getName() : ""));
                jSONObject.put("total_order", ticketInfo.getTotalOrder());
                jSONObject.put("reason_cancel_order", (Object)ticketInfo.getReason_cancel());
                canceledOrdersArray.put((Object)jSONObject);
            }
            objectRoot.put("canceled_order", (Object)canceledOrdersArray);
            JSONArray jSONArray = new JSONArray();
            for (TicketInfo ticketInfo : discountOrders) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("num_order", ticketInfo.getNumberOrderTorint());
                jSONObject.put("date_order", (Object)this.dateFormatterFull.format(ticketInfo.getDate()));
                jSONObject.put("user_order", (Object)(ticketInfo.getUser() != null ? ticketInfo.getUser().getName() : ""));
                jSONObject.put("total_order", ticketInfo.getTotal());
                jSONObject.put("discount_order_lines", ticketInfo.getDiscountOrderAndLines());
                jSONArray.put((Object)jSONObject);
            }
            objectRoot.put("discount_order", (Object)jSONArray);
            objectRoot.put("turnoverLasWeekSameHour", financialReportInfo.getTurnoverLasWeekSameHour());
            JSONArray jSONArray2 = new JSONArray();
            for (HourInfo hourInfo : salesHour) {
                JSONObject objectHourInfo = new JSONObject();
                objectHourInfo.put("hour", hourInfo.getHour());
                objectHourInfo.put("turnover", (Object)hourInfo.getTurnover());
                objectHourInfo.put("nbOrders", hourInfo.getOrders());
                jSONArray2.put((Object)objectHourInfo);
            }
            objectRoot.put("statisticByHour", (Object)jSONArray2);
            objectRoot.put("type.equipement", (Object)AppLocal.modeCaisse);
            JSONArray jSONArray3 = new JSONArray();
            for (TicketInfo ticket : notesCanceled) {
                JSONObject objectCanceledNote = new JSONObject();
                objectCanceledNote.put("num_order", ticket.getNumberOrderTorint());
                objectCanceledNote.put("date_order", (Object)this.dateFormatterFull.format(ticket.getDate()));
                objectCanceledNote.put("user_order", (Object)(ticket.getUser() != null ? ticket.getUser().getName() : ""));
                objectCanceledNote.put("total_order", ticket.getTotalOrder());
                objectCanceledNote.put("reason_cancel_order", (Object)ticket.getReason_cancel());
                jSONArray3.put((Object)objectCanceledNote);
            }
            objectRoot.put("canceled_notes", (Object)jSONArray3);
            objectRoot.put("total_ht_taxable", financialReportInfo.getTotal_ht_taxable());
            objectRoot.put("total_ht_no_taxable", financialReportInfo.getTotal_ht_no_taxable());
            List<GroupedTax> list = financialReportInfo.getGroupedTaxes();
            JSONArray groupedTaxesArray = new JSONArray();
            for (GroupedTax taxe : list) {
                JSONObject objectGroupedTax = new JSONObject();
                objectGroupedTax.put("code_tax", (Object)taxe.getCode_taxe());
                objectGroupedTax.put("rate", taxe.getRate());
                objectGroupedTax.put("name", (Object)taxe.getName());
                objectGroupedTax.put("total_tax", taxe.getTotal_tax());
                groupedTaxesArray.put((Object)objectGroupedTax);
            }
            objectRoot.put("grouped_taxes", (Object)groupedTaxesArray);
            return objectRoot;
        }
        return null;
    }

    public LinkedHashMap<String, Object> getRapportEquippements(Date dateStart, Date dateEnd, boolean only_borne) {
        LinkedHashMap<String, Object> map_infos = new LinkedHashMap<String, Object>();
        BorneService mBorneService = BorneService.getInstance();
        List<BorneInfo> equipments = mBorneService.getEnabledBornes();
        ArrayList<String> not_available = new ArrayList<String>();
        System.out.println("+++++++++++++++equipments" + equipments.size());
        if (equipments != null) {
            for (BorneInfo equipement : equipments) {
                System.out.println("++++++++++++++equipement " + equipement.getName_borne());
                if (equipement == null || equipement.getAddress_ip() == null || equipement.getAddress_ip().isEmpty()) continue;
                try {
                    String message;
                    String reponse;
                    JSONObject jsonResponse;
                    String url = "http://" + equipement.getAddress_ip() + ":9097/newItems/getRapport";
                    JSONObject json = new JSONObject();
                    json.put("date_start", (Object)this.dateFormatterFull.format(dateStart));
                    json.put("date_end", (Object)this.dateFormatterFull.format(dateEnd));
                    json.put("only_borne", only_borne);
                    OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
                    RequestBody body = RequestBody.create((MediaType)this.JSON, (String)json.toString());
                    Request request = new Request.Builder().url(url).post(body).build();
                    Response response = client.newCall(request).execute();
                    if (response.code() != 200 || (jsonResponse = new JSONObject(reponse = response.body().string())).isNull("message") || (message = jsonResponse.getString("message")) == null || !message.equals("OK")) continue;
                    JSONObject data = jsonResponse.getJSONObject("data");
                    this.getInfosZ(data, map_infos);
                }
                catch (IOException ex) {
                    not_available.add(equipement.getName_borne());
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
        if (!not_available.isEmpty()) {
            map_infos.put("not_available", not_available);
        }
        return map_infos;
    }

    private void getInfosZ(JSONObject data, LinkedHashMap<String, Object> map_infos) {
        double totalHtNoTaxable;
        double totalHtTaxable;
        String date_order;
        JSONObject objCanceledOrder;
        JSONObject objTaxe;
        JSONArray arrayTaxes;
        JSONObject objTypeOrders;
        int i;
        String type_equipement;
        double turnover = data.isNull("turnover") ? 0.0 : data.getDouble("turnover");
        int nbOrder = data.isNull("nbOrders") ? 0 : data.getInt("nbOrders");
        double totalDiscount = data.isNull("totalDiscount") ? 0.0 : data.getDouble("totalDiscount");
        double totalDiscountLines = data.isNull("totalDiscountLines") ? 0.0 : data.getDouble("totalDiscountLines");
        double turnoverCanceled = data.isNull("turnover_canceled") ? 0.0 : data.getDouble("turnover_canceled");
        double turnoverLasWeekSameHour = data.isNull("turnoverLasWeekSameHour") ? 0.0 : data.getDouble("turnoverLasWeekSameHour");
        String host_name = data.isNull("host_name") ? null : data.getString("host_name");
        String string = type_equipement = data.isNull("type.equipement") ? null : data.getString("type.equipement");
        if (map_infos.get("turnover") != null) {
            double oldTurnover = (Double)map_infos.get("turnover");
            map_infos.replace("turnover", oldTurnover + turnover);
        } else {
            map_infos.put("turnover", turnover);
        }
        if (map_infos.get("nbOrders") != null) {
            int oldNbOrder = (Integer)map_infos.get("nbOrders");
            map_infos.replace("nbOrders", oldNbOrder + nbOrder);
        } else {
            map_infos.put("nbOrders", nbOrder);
        }
        if (map_infos.get("totalDiscount") != null) {
            double oldTotalDiscount = (Double)map_infos.get("totalDiscount");
            map_infos.replace("totalDiscount", oldTotalDiscount + totalDiscount);
        } else {
            map_infos.put("totalDiscount", totalDiscount);
        }
        if (map_infos.get("totalDiscountLines") != null) {
            double oldTotalDiscountLines = (Double)map_infos.get("totalDiscountLines");
            map_infos.replace("totalDiscountLines", oldTotalDiscountLines + totalDiscountLines);
        } else {
            map_infos.put("totalDiscountLines", totalDiscountLines);
        }
        if (map_infos.get("turnover_canceled") != null) {
            double oldTurnoverCanceled = (Double)map_infos.get("turnover_canceled");
            map_infos.replace("turnover_canceled", oldTurnoverCanceled + turnoverCanceled);
        } else {
            map_infos.put("turnover_canceled", turnoverCanceled);
        }
        if (map_infos.get("turnoverLasWeekSameHour") != null) {
            double oldTurnoverLasWeekSameHour = (Double)map_infos.get("turnoverLasWeekSameHour");
            map_infos.replace("turnoverLasWeekSameHour", oldTurnoverLasWeekSameHour + turnoverLasWeekSameHour);
        } else {
            map_infos.put("turnoverLasWeekSameHour", turnoverLasWeekSameHour);
        }
        if (!data.isNull("payments")) {
            ArrayList<PaymentLine> payments = new ArrayList<PaymentLine>();
            JSONArray arrayPayments = data.getJSONArray("payments");
            for (i = 0; i < arrayPayments.length(); ++i) {
                JSONObject objPayment = arrayPayments.getJSONObject(i);
                PaymentLine mPaymentLine = new PaymentLine();
                mPaymentLine.setM_PaymentType(objPayment.getString("name_payment"));
                mPaymentLine.setM_PaymentValue(objPayment.getDouble("total_payment"));
                mPaymentLine.setNombre(objPayment.getInt("number_payment"));
                payments.add(mPaymentLine);
            }
            if (map_infos.get("payments") != null) {
                this.setPayment(map_infos, payments);
            } else {
                map_infos.put("payments", payments);
            }
        }
        if (!data.isNull("typeOrders")) {
            ArrayList<RankTypeOrder> typeOrders = new ArrayList<RankTypeOrder>();
            JSONArray arrayTypeOrders = data.getJSONArray("typeOrders");
            for (i = 0; i < arrayTypeOrders.length(); ++i) {
                objTypeOrders = arrayTypeOrders.getJSONObject(i);
                RankTypeOrder typeOrder = new RankTypeOrder();
                typeOrder.setName(objTypeOrders.getString("name_type_order"));
                typeOrder.setCa(objTypeOrders.getDouble("turnover_type_order"));
                typeOrders.add(typeOrder);
            }
            if (map_infos.get("typeOrders") != null) {
                this.setTypeOrders(map_infos, typeOrders);
            } else {
                map_infos.put("typeOrders", typeOrders);
            }
        }
        if (!data.isNull("typePlatformOrders")) {
            ArrayList<RankTypeOrder> typePlatformOrders = new ArrayList<RankTypeOrder>();
            JSONArray arrayTypePlatformOrders = data.getJSONArray("typePlatformOrders");
            for (i = 0; i < arrayTypePlatformOrders.length(); ++i) {
                objTypeOrders = arrayTypePlatformOrders.getJSONObject(i);
                RankTypeOrder typePLatformOrder = new RankTypeOrder();
                typePLatformOrder.setName(objTypeOrders.getString("name_type_order"));
                typePLatformOrder.setCa(objTypeOrders.getDouble("turnover_type_order"));
                typePlatformOrders.add(typePLatformOrder);
            }
            if (map_infos.get("typePlatformOrders") != null) {
                this.setTypePlatformOrders(map_infos, typePlatformOrders);
            } else {
                map_infos.put("typePlatformOrders", typePlatformOrders);
            }
        }
        if (!data.isNull("taxes")) {
            ArrayList<TaxeLine> taxes = new ArrayList<TaxeLine>();
            arrayTaxes = data.getJSONArray("taxes");
            for (i = 0; i < arrayTaxes.length(); ++i) {
                objTaxe = arrayTaxes.getJSONObject(i);
                TaxeLine taxe = new TaxeLine();
                taxe.setId(objTaxe.getString("id_taxe"));
                taxe.setName(objTaxe.getString("name_taxe"));
                taxe.setTax(objTaxe.getDouble("taxe"));
                taxes.add(taxe);
            }
            if (map_infos.get("taxes") != null) {
                this.setTaxes(map_infos, taxes);
            } else {
                map_infos.put("taxes", taxes);
            }
        }
        if (!data.isNull("users")) {
            ArrayList<UserCaisseInfo> users = new ArrayList<UserCaisseInfo>();
            arrayTaxes = data.getJSONArray("users");
            for (i = 0; i < arrayTaxes.length(); ++i) {
                objTaxe = arrayTaxes.getJSONObject(i);
                UserCaisseInfo user = new UserCaisseInfo();
                user.setM_sId(objTaxe.getString("id_user"));
                user.setM_sName(objTaxe.getString("name_user"));
                user.setTotal(objTaxe.getDouble("turnover_user"));
                users.add(user);
            }
            if (map_infos.get("users") != null) {
                this.setUsers(map_infos, users);
            } else {
                map_infos.put("users", users);
            }
        }
        if (host_name != null) {
            if (map_infos.get("equipments") != null) {
                List oldEquipments = (List)map_infos.get("equipments");
                oldEquipments.add(new EquipmentTurnover(host_name, turnover, type_equipement));
            } else {
                ArrayList<EquipmentTurnover> equipments = new ArrayList<EquipmentTurnover>();
                equipments.add(new EquipmentTurnover(host_name, turnover, type_equipement));
                map_infos.put("equipments", equipments);
            }
        }
        if (!data.isNull("canceled_order")) {
            ArrayList<TicketInfo> canceledOrders = new ArrayList<TicketInfo>();
            JSONArray arrayCanceledOrders = data.getJSONArray("canceled_order");
            for (i = 0; i < arrayCanceledOrders.length(); ++i) {
                try {
                    objCanceledOrder = arrayCanceledOrders.getJSONObject(i);
                    date_order = objCanceledOrder.getString("date_order");
                    TicketInfo canceledOrder = new TicketInfo();
                    canceledOrder.setNumero_order(objCanceledOrder.getInt("num_order"));
                    canceledOrder.setUser(new UserInfo("", objCanceledOrder.getString("user_order")));
                    canceledOrder.setDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(date_order));
                    canceledOrder.setTotal(objCanceledOrder.getDouble("total_order"));
                    canceledOrder.setReason_cancel(objCanceledOrder.getString("reason_cancel_order"));
                    canceledOrders.add(canceledOrder);
                    continue;
                }
                catch (ParseException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
            if (map_infos.get("canceled_order") != null) {
                List oldCanceledOrders = (List)map_infos.get("canceled_order");
                oldCanceledOrders.addAll(canceledOrders);
            } else {
                map_infos.put("canceled_order", canceledOrders);
            }
        }
        if (!data.isNull("canceled_notes")) {
            ArrayList<TicketInfo> canceledNotes = new ArrayList<TicketInfo>();
            JSONArray arrayCanceledNotes = data.getJSONArray("canceled_notes");
            for (int i2 = 0; i2 < arrayCanceledNotes.length(); ++i2) {
                try {
                    objCanceledOrder = arrayCanceledNotes.getJSONObject(i2);
                    date_order = objCanceledOrder.getString("date_order");
                    TicketInfo canceledNote = new TicketInfo();
                    canceledNote.setNumero_order(objCanceledOrder.getInt("num_order"));
                    canceledNote.setUser(new UserInfo("", objCanceledOrder.getString("user_order")));
                    canceledNote.setDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(date_order));
                    canceledNote.setTotal(objCanceledOrder.getDouble("total_order"));
                    canceledNote.setReason_cancel(objCanceledOrder.getString("reason_cancel_order"));
                    canceledNotes.add(canceledNote);
                    continue;
                }
                catch (ParseException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
            if (map_infos.get("canceled_notes") != null) {
                List oldCanceledOrders = (List)map_infos.get("canceled_notes");
                oldCanceledOrders.addAll(canceledNotes);
            } else {
                map_infos.put("canceled_notes", canceledNotes);
            }
        }
        if (!data.isNull("discount_order")) {
            ArrayList<TicketInfo> discountOrders = new ArrayList<TicketInfo>();
            JSONArray arrayDiscountOrders = data.getJSONArray("discount_order");
            for (int i3 = 0; i3 < arrayDiscountOrders.length(); ++i3) {
                try {
                    JSONObject objDiscountOrder = arrayDiscountOrders.getJSONObject(i3);
                    date_order = objDiscountOrder.getString("date_order");
                    TicketInfo discountOrder = new TicketInfo();
                    discountOrder.setNumero_order(objDiscountOrder.getInt("num_order"));
                    discountOrder.setUser(new UserInfo("", objDiscountOrder.getString("user_order")));
                    discountOrder.setDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(date_order));
                    discountOrder.setTotal(objDiscountOrder.getDouble("total_order"));
                    discountOrder.setDiscountOrderAndLines(objDiscountOrder.getDouble("discount_order_lines"));
                    discountOrders.add(discountOrder);
                    continue;
                }
                catch (ParseException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
            if (map_infos.get("discount_order") != null) {
                List oldDiscountOrders = (List)map_infos.get("discount_order");
                oldDiscountOrders.addAll(discountOrders);
            } else {
                map_infos.put("discount_order", discountOrders);
            }
        }
        if (!data.isNull("statisticByHour")) {
            ArrayList<HourInfo> salesHour = new ArrayList<HourInfo>();
            JSONArray arraySalesHour = data.getJSONArray("statisticByHour");
            for (int i4 = 0; i4 < arraySalesHour.length(); ++i4) {
                JSONObject objHourInfo = arraySalesHour.getJSONObject(i4);
                HourInfo mHourInfo = new HourInfo();
                mHourInfo.setHour(objHourInfo.getInt("hour"));
                mHourInfo.setTurnover(objHourInfo.getDouble("turnover"));
                mHourInfo.setOrders(objHourInfo.getInt("nbOrders"));
                salesHour.add(mHourInfo);
            }
            if (map_infos.get("statisticByHour") != null) {
                this.setSalesHours(map_infos, salesHour);
            } else {
                map_infos.put("statisticByHour", salesHour);
            }
        }
        if (!data.isNull("grouped_taxes")) {
            ArrayList<GroupedTax> groupedTaxes = new ArrayList<GroupedTax>();
            JSONArray arrayGroupedTaxes = data.getJSONArray("grouped_taxes");
            for (int i5 = 0; i5 < arrayGroupedTaxes.length(); ++i5) {
                JSONObject objGroupedTax = arrayGroupedTaxes.getJSONObject(i5);
                GroupedTax groupedTax = new GroupedTax();
                groupedTax.setCode_taxe(objGroupedTax.getString("code_tax"));
                groupedTax.setName(objGroupedTax.getString("name"));
                groupedTax.setRate(objGroupedTax.getDouble("rate"));
                groupedTax.setTotal_tax(objGroupedTax.getDouble("total_tax"));
                groupedTaxes.add(groupedTax);
            }
            if (map_infos.get("grouped_taxes") != null) {
                this.setGroupedTaxes(map_infos, groupedTaxes);
            } else {
                map_infos.put("grouped_taxes", groupedTaxes);
            }
        }
        System.out.println("map_infos.get(AppConstants.STR_GTP_GROUPED_TAXES) : " + (List)map_infos.get("grouped_taxes"));
        double d = totalHtTaxable = data.isNull("total_ht_taxable") ? 0.0 : data.getDouble("total_ht_taxable");
        if (map_infos.get("total_ht_taxable") != null) {
            double oldTotalHtTaxable = (Double)map_infos.get("total_ht_taxable");
            map_infos.replace("total_ht_taxable", oldTotalHtTaxable + totalHtTaxable);
        } else {
            map_infos.put("total_ht_taxable", totalHtTaxable);
        }
        double d2 = totalHtNoTaxable = data.isNull("total_ht_no_taxable") ? 0.0 : data.getDouble("total_ht_no_taxable");
        if (map_infos.get("total_ht_no_taxable") != null) {
            double oldTotalHtNoTaxable = (Double)map_infos.get("total_ht_no_taxable");
            map_infos.replace("total_ht_no_taxable", oldTotalHtNoTaxable + totalHtNoTaxable);
        } else {
            map_infos.put("total_ht_no_taxable", totalHtNoTaxable);
        }
    }

    private void setPayment(LinkedHashMap<String, Object> map_infos, List<PaymentLine> payments) {
        List oldPayments = (List)map_infos.get("payments");
        for (PaymentLine payment : payments) {
            int found = -1;
            for (PaymentLine oldPayment : oldPayments) {
                if (!payment.getM_PaymentType().equals(oldPayment.getM_PaymentType()) || oldPayment.getM_PaymentType().equalsIgnoreCase("Avoir") && (!oldPayment.getM_PaymentType().equalsIgnoreCase("Avoir") || !(payment.getM_PaymentValue() <= 0.0 && oldPayment.getM_PaymentValue() <= 0.0) && (!(payment.getM_PaymentValue() <= 0.0) || !(oldPayment.getM_PaymentValue() <= 0.0)))) continue;
                found = 1;
                oldPayment.setM_PaymentValue(payment.getM_PaymentValue() + oldPayment.getM_PaymentValue());
                oldPayment.setNombre(payment.getNombre() + oldPayment.getNombre());
                break;
            }
            if (found != -1) continue;
            oldPayments.add(payment);
        }
    }

    private void setTypeOrders(LinkedHashMap<String, Object> map_infos, List<RankTypeOrder> typeOrders) {
        List oldTypeOrders = (List)map_infos.get("typeOrders");
        for (RankTypeOrder typeOrder : typeOrders) {
            int found = -1;
            for (RankTypeOrder oldTypeOrder : oldTypeOrders) {
                if (!typeOrder.getName().equals(oldTypeOrder.getName())) continue;
                oldTypeOrder.setCa(oldTypeOrder.getCa() + typeOrder.getCa());
                found = 1;
                break;
            }
            if (found != -1) continue;
            oldTypeOrders.add(typeOrder);
        }
    }

    private void setTypePlatformOrders(LinkedHashMap<String, Object> map_infos, List<RankTypeOrder> typePlatformOrders) {
        List oldTypeOrders = (List)map_infos.get("typePlatformOrders");
        for (RankTypeOrder typeOrder : typePlatformOrders) {
            int found = -1;
            for (RankTypeOrder oldTypeOrder : oldTypeOrders) {
                if (!typeOrder.getName().equals(oldTypeOrder.getName())) continue;
                oldTypeOrder.setCa(oldTypeOrder.getCa() + typeOrder.getCa());
                found = 1;
                break;
            }
            if (found != -1) continue;
            oldTypeOrders.add(typeOrder);
        }
    }

    private void setTaxes(LinkedHashMap<String, Object> map_infos, List<TaxeLine> taxes) {
        List oldTaxes = (List)map_infos.get("taxes");
        for (TaxeLine taxe : taxes) {
            int found = -1;
            for (TaxeLine oldTaxe : oldTaxes) {
                if (taxe.getId() == null || oldTaxe.getId() == null || !taxe.getId().equals(oldTaxe.getId())) continue;
                oldTaxe.setTax(oldTaxe.getTax() + taxe.getTax());
                found = 1;
                break;
            }
            if (found != -1) continue;
            oldTaxes.add(taxe);
        }
    }

    private void setUsers(LinkedHashMap<String, Object> map_infos, List<UserCaisseInfo> users) {
        List oldUsers = (List)map_infos.get("users");
        for (UserCaisseInfo user : users) {
            int found = -1;
            for (UserCaisseInfo oldUser : oldUsers) {
                if (!user.getName().equals(oldUser.getName())) continue;
                oldUser.setTotal(oldUser.getTotal() + user.getTotal());
                found = 1;
                break;
            }
            if (found != -1) continue;
            oldUsers.add(user);
        }
    }

    public void getInfosZ(FinancialReportInfo financialReportInfo, LinkedHashMap<String, Object> map_infos) {
        double turnover = financialReportInfo.getTurnover();
        int nbOrder = financialReportInfo.getNumberOrders();
        double totalDiscount = financialReportInfo.getTotalDiscount();
        double totalDiscountLines = financialReportInfo.getTotalDiscountOnLines();
        double turnoverCanceled = financialReportInfo.getTurnoverCanceled();
        double turnoverLasWeekSameHour = financialReportInfo.getTurnoverLasWeekSameHour();
        if (map_infos.get("turnover") != null) {
            double oldTurnover = (Double)map_infos.get("turnover");
            map_infos.replace("turnover", oldTurnover + turnover);
        } else {
            map_infos.put("turnover", turnover);
        }
        if (map_infos.get("nbOrders") != null) {
            int oldNbOrder = (Integer)map_infos.get("nbOrders");
            map_infos.replace("nbOrders", oldNbOrder + nbOrder);
        } else {
            map_infos.put("nbOrders", nbOrder);
        }
        if (map_infos.get("totalDiscount") != null) {
            double oldTotalDiscount = (Double)map_infos.get("totalDiscount");
            map_infos.replace("totalDiscount", oldTotalDiscount + totalDiscount);
        } else {
            map_infos.put("totalDiscount", totalDiscount);
        }
        if (map_infos.get("totalDiscountLines") != null) {
            double oldTotalDiscountLines = (Double)map_infos.get("totalDiscountLines");
            map_infos.replace("totalDiscountLines", oldTotalDiscountLines + totalDiscountLines);
        } else {
            map_infos.put("totalDiscountLines", totalDiscountLines);
        }
        if (map_infos.get("turnover_canceled") != null) {
            double oldTurnoverCanceled = (Double)map_infos.get("turnover_canceled");
            map_infos.replace("turnover_canceled", oldTurnoverCanceled + turnoverCanceled);
        } else {
            map_infos.put("turnover_canceled", turnoverCanceled);
        }
        if (map_infos.get("turnoverLasWeekSameHour") != null) {
            double oldTurnoverLasWeekSameHour = (Double)map_infos.get("turnoverLasWeekSameHour");
            map_infos.replace("turnoverLasWeekSameHour", oldTurnoverLasWeekSameHour + turnoverLasWeekSameHour);
        } else {
            map_infos.put("turnoverLasWeekSameHour", turnoverLasWeekSameHour);
        }
        List<PaymentLine> payments = financialReportInfo.getPayments();
        if (map_infos.get("payments") != null) {
            this.setPayment(map_infos, payments);
        } else {
            map_infos.put("payments", payments);
        }
        List<RankTypeOrder> typeOrders = financialReportInfo.getDataTypeOrders();
        if (map_infos.get("typeOrders") != null) {
            this.setTypeOrders(map_infos, typeOrders);
        } else {
            map_infos.put("typeOrders", typeOrders);
        }
        List<RankTypeOrder> typePlatformOrders = financialReportInfo.getDataTypePlatformOrders();
        if (map_infos.get("typePlatformOrders") != null) {
            this.setTypePlatformOrders(map_infos, typePlatformOrders);
        } else {
            map_infos.put("typePlatformOrders", typePlatformOrders);
        }
        List<TaxeLine> taxes = financialReportInfo.getTaxes();
        if (map_infos.get("taxes") != null) {
            this.setTaxes(map_infos, taxes);
        } else {
            map_infos.put("taxes", taxes);
        }
        List<UserCaisseInfo> users = financialReportInfo.getUsers();
        if (map_infos.get("users") != null) {
            this.setUsers(map_infos, users);
        } else {
            map_infos.put("users", users);
        }
        String host_name = AppLocal.source_order;
        String type_equipement = "Caisse";
        if (host_name != null) {
            if (map_infos.get("equipments") != null) {
                List oldEquipments = (List)map_infos.get("equipments");
                oldEquipments.add(new EquipmentTurnover(host_name, turnover, type_equipement));
            } else {
                ArrayList<EquipmentTurnover> equipments = new ArrayList<EquipmentTurnover>();
                equipments.add(new EquipmentTurnover(host_name, turnover, type_equipement));
                map_infos.put("equipments", equipments);
            }
        }
        List<TicketInfo> canceledOrders = financialReportInfo.getOrdersCanceled();
        if (map_infos.get("canceled_order") != null) {
            List oldCanceledOrders = (List)map_infos.get("canceled_order");
            oldCanceledOrders.addAll(canceledOrders);
        } else {
            map_infos.put("canceled_order", canceledOrders);
        }
        List<TicketInfo> discountOrders = financialReportInfo.getDiscountOrders();
        if (map_infos.get("discount_order") != null) {
            List oldDiscountOrders = (List)map_infos.get("discount_order");
            oldDiscountOrders.addAll(discountOrders);
        } else {
            map_infos.put("discount_order", discountOrders);
        }
        List<HourInfo> salesByHour = financialReportInfo.getSalesByHour();
        if (map_infos.get("statisticByHour") != null) {
            this.setSalesHours(map_infos, salesByHour);
        } else {
            map_infos.put("statisticByHour", salesByHour);
        }
        List<PertEntity> listPetEntity = financialReportInfo.getPertesInfos();
        if (map_infos.get("Pertes") != null) {
            List oldlistPeInfos = (List)map_infos.get("Pertes");
            oldlistPeInfos.addAll(listPetEntity);
        } else {
            map_infos.put("Pertes", listPetEntity);
        }
        List<MoneyMouvement> listMoneyMouvement = financialReportInfo.getMouvementsMoney();
        if (map_infos.get("money_mouvement") != null) {
            List oldlistMoneyMouvement = (List)map_infos.get("money_mouvement");
            oldlistMoneyMouvement.addAll(listMoneyMouvement);
        } else {
            map_infos.put("money_mouvement", listMoneyMouvement);
        }
        List<TicketInfo> canceledNotes = financialReportInfo.getNotesCanceled();
        if (map_infos.get("canceled_notes") != null) {
            List oldCanceledNotes = (List)map_infos.get("canceled_notes");
            oldCanceledNotes.addAll(canceledNotes);
        } else {
            map_infos.put("canceled_notes", canceledNotes);
        }
        List<GroupedTax> groupedTaxes = financialReportInfo.getGroupedTaxes();
        System.out.println("groupedTaxes : " + groupedTaxes);
        if (map_infos.get("grouped_taxes") != null) {
            this.setGroupedTaxes(map_infos, groupedTaxes);
        } else {
            map_infos.put("grouped_taxes", groupedTaxes);
        }
        System.out.println("map_infos.get(AppConstants.STR_GTP_GROUPED_TAXES) 2 : " + (List)map_infos.get("grouped_taxes"));
        double totalHtTaxable = financialReportInfo.getTotal_ht_taxable();
        if (map_infos.get("total_ht_taxable") != null) {
            double oldTotalHtTaxable = (Double)map_infos.get("total_ht_taxable");
            map_infos.replace("total_ht_taxable", oldTotalHtTaxable + totalHtTaxable);
        } else {
            map_infos.put("total_ht_taxable", totalHtTaxable);
        }
        double totalHtNoTaxable = financialReportInfo.getTotal_ht_no_taxable();
        if (map_infos.get("total_ht_no_taxable") != null) {
            double oldTotalHtNoTaxable = (Double)map_infos.get("total_ht_no_taxable");
            map_infos.replace("total_ht_no_taxable", oldTotalHtNoTaxable + totalHtNoTaxable);
        } else {
            map_infos.put("total_ht_no_taxable", totalHtNoTaxable);
        }
    }

    private void sendUsedPromocode(final String promo_code, final String type, final String customerPhone) {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                TicketService.this.mPromoCodeService.sendUsedPromocode(promo_code, type, customerPhone);
            }
        });
    }

    public String getSourceOrder(TicketInfo ticket) {
        if (ticket.getOrdered_from() != null && ticket.getOrdered_from().equals("inside") && (ticket.getSent_from() == null || ticket.getSent_from().isEmpty())) {
            if (AppLocal.modeCaisse != null && AppLocal.modeCaisse.equals("Caisse")) {
                if (ticket.getType() != null && ticket.getType().equalsIgnoreCase("Drive")) {
                    return "Drive";
                }
                return "caisse";
            }
            return "borne cb";
        }
        if (ticket.getType() != null && ticket.getType().equalsIgnoreCase("Drive")) {
            return "Drive";
        }
        if (ticket.getSent_from() != null) {
            switch (ticket.getSent_from()) {
                case "borne": {
                    return "borne";
                }
                case "web": {
                    return "online";
                }
                case "Uber Eats": {
                    return "Uber Eats";
                }
                case "Just Eat": {
                    return "Just Eat";
                }
                case "Delivero": {
                    return "Delivero";
                }
            }
            return ticket.getSent_from();
        }
        return "";
    }

    private void sendUsedPromocode(TicketInfo ticket) {
        if (ticket.getDiscount() != 0.0 && ticket.getLabel_discount() != null && ticket.getLabel_discount().startsWith("Code promo")) {
            String promo_code = ticket.getLabel_discount().substring(11);
            String type = this.getSourceOrder(ticket);
            this.sendUsedPromocode(promo_code, type, ticket.getCustomerPhone());
        }
    }

    public LinkedHashMap<String, Object> getXGlobal(Date dateStart, Date dateEnd) {
        try {
            double total_ht_no_taxable;
            List<TicketInfo> ordersCanceled = this.dlSales.loadTicketCanceled(dateStart, dateEnd);
            List<TicketInfo> notesCanceled = this.dlSales.loadNotesCanceled(dateStart, dateEnd);
            List<RankTypeOrder> dataTypeOrders = AppLocal.dlStats.loadSatisticOrderByType(dateStart, dateEnd);
            List<RankTypeOrder> dataTypePlatformOrders = AppLocal.dlStats.loadPlatformOrdersByType(dateStart, dateEnd);
            List<TicketInfo> discountOrders = this.dlSales.discountOrders(dateStart, dateEnd);
            double caNet = this.dlSales.getCA(dateStart, dateEnd);
            List<UserCaisseInfo> users = this.dlSales.getCAbyUser(dateStart, dateEnd);
            List<PaymentLine> payments = this.dlSales.loadPayment(dateStart, dateEnd);
            List<TaxeLine> taxes = this.dlSales.getTaxesBetwen(dateStart, dateEnd);
            double caCanceled = this.dlSales.getTurnoverCanceled(dateStart, dateEnd);
            Integer m_iSales = this.dlSales.getNbOrder(dateStart, dateEnd);
            Double totalDiscount = AppLocal.dlStats.getTotalDiscountOrderOfType(dateStart, dateEnd, "pourcentage") + AppLocal.dlStats.getTotalDiscountOrderOfType(dateStart, dateEnd, "somme");
            Double totalDiscountOnLines = AppLocal.dlStats.getTotalDiscountOnTicketLines(dateStart, dateEnd);
            int currentHour = new Date().getHours();
            Calendar calendarStart = Calendar.getInstance();
            calendarStart.setTime(dateStart);
            calendarStart.add(5, -4);
            Date dateStartLastWeek = calendarStart.getTime();
            Calendar calendarEnd = Calendar.getInstance();
            calendarEnd.setTime(dateEnd);
            calendarEnd.add(5, -4);
            Date dateEndLastWeek = calendarEnd.getTime();
            Double turnoverLasWeekSameHour = AppLocal.dlStats.loadSatisticByHour(dateStartLastWeek, dateEndLastWeek, currentHour);
            List<HourInfo> salesByHour = AppLocal.dlStats.loadSatisticByHour(dateStart, dateEnd, false);
            LinkedHashMap<String, Object> map_infos = this.getRapportEquippements(dateStart, dateEnd, false);
            List<PertEntity> pertesInfos = this.mPertEntityServices.findPertByTimeRange(dateStart, dateEnd);
            List<MoneyMouvement> mouvementsMoney = this.mMoneyMouvementServices.findMouvementByTimeRange(dateStart, dateEnd);
            List<GroupedTax> groupedTaxes = AppLocal.dlStats.getGlobalTaxes(dateStart, dateEnd);
            TotaleEncaissement totaleEncaissement = AppLocal.dlStats.getTotalEncaissement(dateStart, dateEnd);
            double total_ht_taxable = totaleEncaissement != null ? totaleEncaissement.getTotal_ht_taxable() : 0.0;
            double d = total_ht_no_taxable = totaleEncaissement != null ? totaleEncaissement.getTotal_ht_no_taxable() : 0.0;
            if (map_infos != null) {
                this.calculDiscountOrders(discountOrders);
                FinancialReportInfo financialReportInfo = new FinancialReportInfo();
                financialReportInfo.setTurnover(caNet);
                financialReportInfo.setNumberOrders(m_iSales);
                financialReportInfo.setPayments(payments);
                financialReportInfo.setDataTypeOrders(dataTypeOrders);
                financialReportInfo.setDataTypePlatformOrders(dataTypePlatformOrders);
                financialReportInfo.setTaxes(taxes);
                financialReportInfo.setTotalDiscount(totalDiscount);
                financialReportInfo.setTotalDiscountOnLines(totalDiscountOnLines);
                financialReportInfo.setUsers(users);
                financialReportInfo.setTurnoverCanceled(caCanceled);
                financialReportInfo.setOrdersCanceled(ordersCanceled);
                financialReportInfo.setNotesCanceled(notesCanceled);
                financialReportInfo.setDiscountOrders(discountOrders);
                financialReportInfo.setTurnoverLasWeekSameHour(turnoverLasWeekSameHour);
                financialReportInfo.setSalesByHour(salesByHour);
                financialReportInfo.setPertesInfos(pertesInfos);
                financialReportInfo.setMouvementsMoney(mouvementsMoney);
                financialReportInfo.setGroupedTaxes(groupedTaxes);
                financialReportInfo.setTotal_ht_taxable(total_ht_taxable);
                financialReportInfo.setTotal_ht_taxable(total_ht_no_taxable);
                this.getInfosZ(financialReportInfo, map_infos);
            }
            return map_infos;
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return null;
        }
    }

    void cancelOrderOtter(String id_order, String cancel_reason) {
        try {
            TicketInfo ticket = this.dlSales.getTicketByOnlineId(id_order);
            if (ticket != null) {
                if (this.mAddressService == null) {
                    this.mAddressService = AddressService.getInstance();
                }
                ticket.setAddressInfo(this.mAddressService.findOne(ticket.getAddress()));
                ticket.setCustomer(this.dlSales.loadCustomerExt(ticket.getCustomerId()));
                List<TicketLineInfo> lines = this.dlSales.loadLines(ticket.getId());
                List<TicketLineInfo> linesExterne = this.dlSales.getTicketLineExterne(ticket.getId());
                lines.addAll(linesExterne);
                ticket.setLines(lines);
                for (TicketLineInfo line : ticket.getLines()) {
                    List<SupplementItemInfo> ingrediens = this.dlSales.getIngredientsByProducts(line.getProductID(), true, false);
                    line.setListIngredientsIN(ingrediens);
                }
                ticket.setReason_cancel(this.reason_cancel);
                if (AppLocal.KITCHEN_COMPOSITE && ticket.getId_shared_order() != 0) {
                    this.mTicketSharedService.cancelOrder(ticket.getId_shared_order(), null);
                }
                if (AppLocal.KITCHEN_COMPOSITE) {
                    this.orderService.cancelOrder(ticket.getId());
                }
                ticket.setPayments(this.dlSales.findPaymetsByIdTicket(ticket.getId()));
                if (ticket.isPaid() && ticket.getTotalOrder() > 0.0) {
                    this.cancelTicket(ticket);
                } else {
                    UserInfo user = this.getCurrentUser();
                    this.dlSales.cancelOrderPending(ticket, ticket.getReason_cancel(), user.getId());
                    final TicketInfo ticketTracked = (TicketInfo)ticket.clone();
                    if (AppLocal.IS_STATS_ONLINE_ENABLED.booleanValue()) {
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                TicketService.this.mPostgreService = PostgreService.getInstance();
                                TicketService.this.mPostgreService.canceledOrder(ticketTracked);
                            }
                        }).start();
                    }
                    this.printCanceledTicketAndLoadTable(ticket);
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void cancelTicket(TicketInfo ticket) throws BasicException {
        TicketInfo ti = this.cancelTicket(ticket, "Espece");
        final TicketInfo ticketTracked = (TicketInfo)ticket.clone();
        if (AppLocal.IS_STATS_ONLINE_ENABLED.booleanValue()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    TicketService.this.mPostgreService = PostgreService.getInstance();
                    TicketService.this.mPostgreService.canceledOrder(ticketTracked);
                }
            }).start();
        }
        if (this.mAddressService == null) {
            this.mAddressService = AddressService.getInstance();
        }
        ti.setAddressInfo(this.mAddressService.findOne(ti.getAddress()));
        ti.setCustomer(this.dlSales.loadCustomerExt(ti.getCustomerId()));
        List<TicketLineInfo> lines = this.dlSales.loadLines(ti.getId());
        List<TicketLineInfo> linesExterne = this.dlSales.getTicketLineExterne(ti.getId());
        lines.addAll(linesExterne);
        ti.setLines(lines);
        this.printCanceledOrder(ti);
        this.printCanceledTicketAndLoadTable(ticket);
    }

    private void printCanceledTicketAndLoadTable(TicketInfo ticket) throws BasicException {
        this.prepareTicketCuisine(ticket);
        final TicketInfo tikcetToSend = (TicketInfo)ticket.clone();
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                TicketService.this.printKitchenTicketCanceld(tikcetToSend);
            }
        });
        NotifyWindow notifyWindow = new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Commande annul\u00e9.", 1500, NPosition.BOTTOM_RIGHT);
        AppLocal.CANCEL_ORDER = true;
    }

    private void setSalesHours(LinkedHashMap<String, Object> map_infos, List<HourInfo> salesByHour) {
        List oldSalesByHour = (List)map_infos.get("statisticByHour");
        for (HourInfo mHourInfo : salesByHour) {
            int found = -1;
            for (HourInfo mOldHourInfo : oldSalesByHour) {
                if (mHourInfo.getHour() != mOldHourInfo.getHour()) continue;
                mOldHourInfo.setTurnover(mOldHourInfo.getTurnover() + mOldHourInfo.getTurnover());
                mOldHourInfo.setOrders(mOldHourInfo.getOrders() + mOldHourInfo.getOrders());
                found = 1;
                break;
            }
            if (found != -1) continue;
            oldSalesByHour.add(mHourInfo);
        }
    }

    public void closeCaisse(final FinancialReportInfo financialReportInfo, Object[] result, final CaisseInfo mCaisseInfo) {
        try {
            double fondClose = financialReportInfo.getCashFund();
            this.fondcaissecalcule = 0.0;
            double course_result = (Double)result[0];
            if (course_result != 0.0) {
                if (AppLocal.WRITE_FOND_CAISSE) {
                    fondClose = course_result;
                } else {
                    Course course = new Course();
                    course.setProduct("fond caisse");
                    course.setUser(this.m_App.getAppUserView().getUser().getUserInfo());
                    course.setUnit(1.0);
                    course.setCreated(new Date());
                    course.setPrice(course_result);
                    course.setDate_validation(new Date());
                    AppLocal.dlProduct.addCource(course);
                    fondClose -= course_result;
                }
                this.fondcaissecalcule = (Double)result[2];
            }
            mCaisseInfo.setOuverte(false);
            final List<Course> courses = AppLocal.dlProduct.getCourses();
            mCaisseInfo.setDateClose(new Date());
            mCaisseInfo.setUser_close(this.m_App.getAppUserView().getUser().getUserInfo());
            mCaisseInfo.setFondClose(fondClose);
            CaisseZ caisseZ = new CaisseZ();
            caisseZ.setDateClose(mCaisseInfo.getDateClose());
            caisseZ.setDateOpen(mCaisseInfo.getDateOpen());
            caisseZ.setCaisse(mCaisseInfo.getId());
            caisseZ.setUser_close_id(mCaisseInfo.getUser_close().getId());
            caisseZ.setUser_open_id(mCaisseInfo.getUser_open_id());
            caisseZ.setHtAmount(financialReportInfo.getHTAmount());
            caisseZ.setTaxAmount(financialReportInfo.getTaxAmount());
            caisseZ.setTtcAmount(financialReportInfo.getTurnover());
            try {
                this.dlSales.closeCaisseWithoutCloture(mCaisseInfo, caisseZ, "j", financialReportInfo.getTaxes(), this.m_App.getAppUserView().getUser().getId());
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
            final MarqueNFC marqueNF = MarqueNFC.fetchOrStore(this.dlSales);
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        PrinterHelper printer = new PrinterHelper();
                        Decreaser decreaser = new Decreaser(TicketService.this.dlSales, DateUtils.SDF_YYYYMMDD.format(mCaisseInfo.getDateClose()), "Rapport de fermeture", null, new Integer(DateUtils.SDF_YYYYMMDD.format(mCaisseInfo.getDateClose())));
                        printer.printCloseCaisseCenter(financialReportInfo, courses, mCaisseInfo, marqueNF, mCaisseInfo.getDateOpen(), mCaisseInfo.getDateClose(), " Z Caisse ", null, decreaser, "day", AppLocal.NUMBER_PRINT_Z, TicketService.this.fondcaissecalcule);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            });
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public boolean saveTicketCBBorne(TicketInfo ticket, List<PaymentInfo> payments) {
        if (ticket.getLinesCount() > 0) {
            try {
                TableInfo table = this.checkAvailability(ticket.getNum_table());
                if (table != null) {
                    ticket.setTable(table);
                }
                boolean add_ticket = this.validOrder(false, ticket, null, true, null, null, true, payments, null, null, "paid", false, false, null);
                return add_ticket;
            }
            catch (Exception ex) {
                LogToFile.log("sever", ex.getMessage(), ex);
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
        return false;
    }

    public void postSaveTicketCBBorne(TicketInfo ticket, String holder_ticket, CustomerLoyalty mCustomerLoyalty) {
        ticket.setHolder(holder_ticket);
        TicketInfo ticketToSend = (TicketInfo)ticket.clone();
        TicketInfo ticketLoyalty = (TicketInfo)ticket.clone();
        try {
            this.sendAndPrintOrder(ticketToSend, false, false, true, true, true, null, true, holder_ticket, "borne", true, "CB", true, false, false, "print paper", null);
        }
        catch (BasicException ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
        }
        if (AppLocal.CUSTOMER_LOYALTY) {
            this.setCagnoteCustomer(mCustomerLoyalty, ticketLoyalty, AppLocal.CUSTOMER_LOYALTY_ID, AppLocal.getKeenio(), ticket.getId(), true);
        }
    }

    public Object[] paymentTPEAutomate(double total_order) {
        Object[] results = new Object[]{false, false, null, null};
        double total = NumericUtils.round(total_order);
        PaymentByCardFacade facade = PaymentByCardFacade.getInstance(this.m_App);
        if (facade.isActivated()) {
            results[0] = true;
            String[] results_debit = facade.debitAutomate_Reservation(total);
            if (results_debit != null && results_debit.length > 0 && results_debit[0] != null && results_debit[0].equals("1")) {
                results[1] = true;
                results[2] = results_debit.length > 1 ? results_debit[1] : null;
                results[3] = results_debit.length > 2 ? results_debit[2] : null;
            }
        }
        return results;
    }

    private void setCustomerTicket(TicketInfo ticket, String phone) {
        if (this.mCustomerService == null) {
            this.mCustomerService = CustomerService.getInstance();
        }
        try {
            CustomerInfo mCustomerInfo = this.mCustomerService.findOneByPhone(phone);
            if (mCustomerInfo == null) {
                mCustomerInfo = new CustomerInfo();
                mCustomerInfo.setName("");
                mCustomerInfo.setPhone(phone);
                this.mCustomerService.save(mCustomerInfo);
            }
            if (mCustomerInfo != null) {
                mCustomerInfo.setLoyaltyCardCollection(this.mLoyaltyCardService.findByCustomer(mCustomerInfo.getId()));
            }
            ticket.setCustomer(mCustomerInfo);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void printCloseReceipt(TicketInfo ticket) {
        this.mEVService.closeReceipt(ticket);
    }

    public void printAddition(TicketInfo ticketToPrint) {
        try {
            if (AppLocal.MODULE_MEV && !AppLocal.CONTINUITY_MODE_MEV) {
                this.mEVService.printAddition(ticketToPrint);
            } else if (AppLocal.printerCaisse.getNumber() > 0) {
                this.dlSales.addEnteteNoteAfterPrint(ticketToPrint);
                PrinterHelper printer = new PrinterHelper();
                EnteteInfo entetTicket = this.dlSales.getEnteteByTicket(ticketToPrint.getId(), ticketToPrint.isPaid());
                Decreaser decreaser = new Decreaser(this.dlSales, ticketToPrint.getId(), "Commande", null, ticketToPrint.getNumero_order());
                this.printRappelTickets(printer, ticketToPrint.getNumero_order(), ticketToPrint, entetTicket, 0L, decreaser, "ADDI");
                int n = printer.getNombreLignesInCammande();
            }
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void saveAndPrintDishopTicket(JSONObject orderDeliverooDishop) {
        try {
            TicketInfo mTicketInfo = TicketInfoBuilder.create(null).objectOrder(orderDeliverooDishop).buildOrderDishop().toTicketInfo();
            this.saveAndPrintDishopTicket(mTicketInfo);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void printDishopOrder(final TicketInfo mTicketInfo) throws BasicException {
        if (AppLocal.DISHOP_PRINTER == 1) {
            System.out.println("add enete note");
            this.dlSales.addEnteteNoteAfterPrint(mTicketInfo);
        }
        final EnteteInfo enteteTicket = AppLocal.DISHOP_PRINTER == 1 ? this.dlSales.getEnteteByTicket(mTicketInfo.getId(), mTicketInfo.isPaid()) : null;
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    PrinterHelper printer = new PrinterHelper();
                    if (AppLocal.DISHOP_PRINTER == 1) {
                        Decreaser decreaser = new Decreaser(TicketService.this.dlSales, mTicketInfo.getId(), "COMMANDE", null, mTicketInfo.getNumero_order());
                        printer.printRappelTickets(mTicketInfo.getNumero_order(), mTicketInfo, enteteTicket, 0L, decreaser);
                    } else {
                        TicketService.this.prepareAndPrintTicketCuisineDishop(mTicketInfo);
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        });
    }

    public void prepareAndPrintTicketCuisineDishop(TicketInfo ticket) throws BasicException {
        this.printers.clear();
        this.productToSend.clear();
        this.productEMP.clear();
        this.productEmpLater.clear();
        this.productSpLater.clear();
        this.listDelete.clear();
        this.prepareAndPrintTicketCuisineDishop(ticket, this.printers, this.productToSend, this.productEMP, this.productSpLater, this.productEmpLater, this.linesdeleted);
    }

    private void prepareAndPrintTicketCuisineDishop(TicketInfo mTicketInfo, List<PrinterInfo> printers, List<TicketLineInfo> productToSend, List<TicketLineInfo> productEMP, List<TicketLineInfo> productSpLater, List<TicketLineInfo> productEmpLater, List<TicketLineInfo> linesdeleted) throws BasicException {
        PrinterInfo printerKitchen = this.dlSales.getPrinterByID(AppLocal.DISHOP_PRINTER);
        printers.add(printerKitchen);
        for (TicketLineInfo line : mTicketInfo.getLines()) {
            line.setPrinterID(printerKitchen.getId());
            for (ProductTicket sub_product : line.getListProducts()) {
                sub_product.setPrinterID(printerKitchen.getId());
            }
            productToSend.add(line);
        }
        LinkedHashMap<Integer, List<ZoneLines>> zoneLinesByPrinter = new LinkedHashMap<Integer, List<ZoneLines>>();
        ArrayList<ZoneLines> listZoneLines = new ArrayList<ZoneLines>();
        ZoneLines defaultZoneLines = new ZoneLines();
        defaultZoneLines.setName("Default");
        defaultZoneLines.setPosition(1);
        defaultZoneLines.setLines(mTicketInfo.getLines());
        listZoneLines.add(defaultZoneLines);
        zoneLinesByPrinter.put(printerKitchen.getId(), listZoneLines);
        PrinterHelper printer = new PrinterHelper();
        Decreaser decreaser = new Decreaser(this.dlSales, mTicketInfo.getId(), "Ticket cuisine", null, mTicketInfo.getNumero_order());
        printer.printKitchenTickets(mTicketInfo, mTicketInfo.getType(), printers, zoneLinesByPrinter, null, null, null, null, decreaser, null, null, true, null, null, false, true);
    }

    private void printRecap(TicketInfo tikcetToSendToPrinter, boolean cb_borne) {
        this.printRecap(tikcetToSendToPrinter, cb_borne, false, null);
    }

    public LinkedHashMap<String, Object> getXLocal(Date dateStart, Date dateEnd) {
        try {
            List<TicketInfo> ordersCanceled = this.dlSales.loadTicketCanceled(dateStart, dateEnd);
            List<TicketInfo> notesCanceled = this.dlSales.loadNotesCanceled(dateStart, dateEnd);
            List<RankTypeOrder> dataTypeOrders = AppLocal.dlStats.loadSatisticOrderByType(dateStart, dateEnd);
            List<TicketInfo> discountOrders = this.dlSales.discountOrders(dateStart, dateEnd);
            double caNet = this.dlSales.getCA(dateStart, dateEnd);
            List<UserCaisseInfo> users = this.dlSales.getCAbyUser(dateStart, dateEnd);
            List<PaymentLine> payments = this.dlSales.loadPayment(dateStart, dateEnd);
            List<TaxeLine> taxes = this.dlSales.getTaxesBetwen(dateStart, dateEnd);
            double caCanceled = this.dlSales.getTurnoverCanceled(dateStart, dateEnd);
            Integer m_iSales = this.dlSales.getNbOrder(dateStart, dateEnd);
            Double totalDiscount = AppLocal.dlStats.getTotalDiscountOrderOfType(dateStart, dateEnd, "pourcentage") + AppLocal.dlStats.getTotalDiscountOrderOfType(dateStart, dateEnd, "somme");
            Double totalDiscountOnLines = AppLocal.dlStats.getTotalDiscountOnTicketLines(dateStart, dateEnd);
            int currentHour = new Date().getHours();
            Calendar calendarStart = Calendar.getInstance();
            calendarStart.setTime(dateStart);
            calendarStart.add(5, -4);
            Date dateStartLastWeek = calendarStart.getTime();
            Calendar calendarEnd = Calendar.getInstance();
            calendarEnd.setTime(dateEnd);
            calendarEnd.add(5, -4);
            Date dateEndLastWeek = calendarEnd.getTime();
            Double turnoverLasWeekSameHour = AppLocal.dlStats.loadSatisticByHour(dateStartLastWeek, dateEndLastWeek, currentHour);
            List<HourInfo> salesByHour = AppLocal.dlStats.loadSatisticByHour(dateStart, dateEnd, false);
            LinkedHashMap<String, Object> map_infos = new LinkedHashMap<String, Object>();
            List<PertEntity> pertesInfos = this.mPertEntityServices.findPertByTimeRange(dateStart, dateEnd);
            List<MoneyMouvement> mouvementsMoney = this.mMoneyMouvementServices.findMouvementByTimeRange(dateStart, dateEnd);
            this.calculDiscountOrders(discountOrders);
            FinancialReportInfo financialReportInfo = new FinancialReportInfo();
            financialReportInfo.setTurnover(caNet);
            financialReportInfo.setNumberOrders(m_iSales);
            financialReportInfo.setPayments(payments);
            financialReportInfo.setDataTypeOrders(dataTypeOrders);
            financialReportInfo.setTaxes(taxes);
            financialReportInfo.setTotalDiscount(totalDiscount);
            financialReportInfo.setTotalDiscountOnLines(totalDiscountOnLines);
            financialReportInfo.setUsers(users);
            financialReportInfo.setTurnoverCanceled(caCanceled);
            financialReportInfo.setOrdersCanceled(ordersCanceled);
            financialReportInfo.setNotesCanceled(notesCanceled);
            financialReportInfo.setDiscountOrders(discountOrders);
            financialReportInfo.setTurnoverLasWeekSameHour(turnoverLasWeekSameHour);
            financialReportInfo.setSalesByHour(salesByHour);
            financialReportInfo.setPertesInfos(pertesInfos);
            financialReportInfo.setMouvementsMoney(mouvementsMoney);
            this.getInfosZ(financialReportInfo, map_infos);
            return map_infos;
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return null;
        }
    }

    private void increaseCreditCustomer(TicketInfo ticket) {
        if (ticket.getTicketType() != 1) {
            try {
                if (ticket.getCustomer() != null && ticket.getCustomer().getLoyaltyCardCollection() != null && !ticket.getCustomer().getLoyaltyCardCollection().isEmpty()) {
                    double credit_to_add = 0.0;
                    for (PaymentInfo payment : ticket.getPayments()) {
                        if (payment.getName().equals("Carte Fid\u00e9lit\u00e9")) continue;
                        credit_to_add += payment.getTotal();
                    }
                    if (credit_to_add != 0.0) {
                        this.mLoyaltyCardService.increaseCredit(NumericUtils.round(credit_to_add *= 0.1), ticket.getCustomer().getLoyaltyCardCollection().get(0).getId());
                    }
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public JSONObject getTicketsJSON(Date dateStart, Date dateEnd) {
        try {
            List<TicketInfo> tickets = this.dlSales.loadAllOrders(dateStart, dateEnd);
            if (tickets != null) {
                JSONObject objectRoot = new JSONObject();
                JSONArray ticketsArray = new JSONArray();
                for (TicketInfo ticket : tickets) {
                    String source_order = AppLocal.modeCaisse != null && AppLocal.modeCaisse.equals("Caisse") ? "caisse" : "borne";
                    JSONObject objectOrder = new JSONObject();
                    objectOrder.put("num_order_kitchen", ticket.getNum_order_kitchen());
                    objectOrder.put("source", (Object)source_order);
                    objectOrder.put("num_order_borne", (Object)ticket.getNum_order_borne());
                    objectOrder.put("num_order", ticket.getNumero_order());
                    objectOrder.put("date_order", (Object)this.dateFormatterFull.format(ticket.getDate()));
                    objectOrder.put("user_order", (Object)(ticket.getUser() != null ? ticket.getUser().getName() : ""));
                    objectOrder.put("total_order", ticket.getTotal());
                    objectOrder.put("table_order", ticket.getNumTable());
                    objectOrder.put("type_order", (Object)ticket.getType());
                    objectOrder.put("discount_order", ticket.getDiscount());
                    objectOrder.put("type_discount_order", (Object)ticket.getTypeDiscount());
                    objectOrder.put("paid", ticket.isPaid());
                    objectOrder.put("status", (Object)ticket.getStatus());
                    objectOrder.put("cancellationReason", (Object)ticket.getReason_cancel());
                    JSONArray paymentsArray = new JSONArray();
                    for (PaymentInfo payment : ticket.getPayments()) {
                        JSONObject objectPayment = new JSONObject();
                        objectPayment.put("name_payment", (Object)payment.getName());
                        objectPayment.put("total_payment", payment.getTotal());
                        paymentsArray.put((Object)objectPayment);
                    }
                    objectOrder.put("payments", (Object)paymentsArray);
                    ticketsArray.put((Object)objectOrder);
                }
                objectRoot.put("tickets", (Object)ticketsArray);
                return objectRoot;
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return null;
    }

    public List<TicketInfo> getTicketsEquippements(Date dateStart, Date dateEnd) {
        ArrayList<TicketInfo> tickets = new ArrayList<TicketInfo>();
        BorneService mBorneService = BorneService.getInstance();
        List<BorneInfo> equipments = mBorneService.getBornes();
        if (equipments != null) {
            for (BorneInfo equipement : equipments) {
                if (equipement == null || equipement.getAddress_ip() == null || equipement.getAddress_ip().isEmpty()) continue;
                try {
                    String message;
                    String reponse;
                    JSONObject jsonResponse;
                    String url = "http://" + equipement.getAddress_ip() + ":9097/newItems/getTickets";
                    JSONObject json = new JSONObject();
                    json.put("date_start", (Object)this.dateFormatterFull.format(dateStart));
                    json.put("date_end", (Object)this.dateFormatterFull.format(dateEnd));
                    OkHttpClient client = new OkHttpClient();
                    RequestBody body = RequestBody.create((MediaType)this.JSON, (String)json.toString());
                    Request request = new Request.Builder().url(url).post(body).build();
                    Response response = client.newCall(request).execute();
                    if (response.code() != 200 || (jsonResponse = new JSONObject(reponse = response.body().string())).isNull("message") || (message = jsonResponse.getString("message")) == null || !message.equals("OK")) continue;
                    JSONObject data = jsonResponse.getJSONObject("data");
                    this.getTickets(data, tickets);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
        try {
            List<TicketInfo> localOrders = this.dlSales.loadAllOrders(dateStart, dateEnd);
            for (TicketInfo localOrder : localOrders) {
                String source_order = AppLocal.modeCaisse != null && AppLocal.modeCaisse.equals("Caisse") ? "caisse" : "borne";
                localOrder.setSource_order(source_order);
            }
            tickets.addAll(localOrders);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        Collections.sort(tickets, new Comparator<TicketInfo>(){

            @Override
            public int compare(TicketInfo t1, TicketInfo t2) {
                return t1.getDate().compareTo(t2.getDate());
            }
        });
        return tickets;
    }

    private void getTickets(JSONObject data, List<TicketInfo> allTickets) {
        ArrayList<TicketInfo> tickets = new ArrayList<TicketInfo>();
        JSONArray arrayTickets = data.getJSONArray("tickets");
        for (int i = 0; i < arrayTickets.length(); ++i) {
            try {
                JSONObject objectTicket = arrayTickets.getJSONObject(i);
                TicketInfo ticket = new TicketInfo();
                ticket.setNum_order_kitchen(objectTicket.isNull("num_order_kitchen") ? 0 : objectTicket.getInt("num_order_kitchen"));
                ticket.setSource_order(objectTicket.isNull("source") ? "" : objectTicket.getString("source"));
                ticket.setNum_order_borne(objectTicket.isNull("num_order_borne") ? null : objectTicket.getString("num_order_borne"));
                ticket.setNumero_order(objectTicket.isNull("num_order") ? 0 : objectTicket.getInt("num_order"));
                String date_order = objectTicket.getString("date_order");
                ticket.setUser(new UserInfo("", objectTicket.isNull("user_order") ? "" : objectTicket.getString("user_order")));
                ticket.setDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(date_order));
                ticket.setTotal(objectTicket.isNull("total_order") ? 0.0 : objectTicket.getDouble("total_order"));
                ticket.setNum_table(objectTicket.isNull("table_order") ? 0 : objectTicket.getInt("table_order"));
                ticket.setType(objectTicket.isNull("type_order") ? "" : objectTicket.getString("type_order"));
                ticket.setDiscount(objectTicket.isNull("discount_order") ? 0.0 : objectTicket.getDouble("discount_order"));
                ticket.setTypeDiscount(objectTicket.isNull("type_discount_order") ? "" : objectTicket.getString("type_discount_order"));
                ticket.setPaid(objectTicket.isNull("paid") ? false : objectTicket.getBoolean("paid"));
                ticket.setStatus(objectTicket.isNull("status") ? "" : objectTicket.getString("status"));
                ticket.setReason_cancel(objectTicket.isNull("cancellationReason") ? "" : objectTicket.getString("cancellationReason"));
                if (!objectTicket.isNull("payments")) {
                    JSONArray arrayPayments = objectTicket.getJSONArray("payments");
                    ArrayList<PaymentInfo> payments = new ArrayList<PaymentInfo>();
                    for (int j = 0; j < arrayPayments.length(); ++j) {
                        JSONObject objectPayment = arrayPayments.getJSONObject(j);
                        PaymentInfo payment = new PaymentInfo();
                        payment.setNamePayment(objectPayment.getString("name_payment"));
                        payment.setTotal(objectPayment.getDouble("total_payment"));
                        payments.add(payment);
                    }
                    ticket.setPayments(payments);
                }
                tickets.add(ticket);
                continue;
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        allTickets.addAll(tickets);
    }

    public void printJustificatifPaymentBorne(String id_ticket, String ip_address, int couvert, String motifif_impression) throws IOException {
        JSONObject jsonTicket = new JSONObject();
        jsonTicket.put("id_ticket", (Object)id_ticket);
        jsonTicket.put("couvert", couvert);
        jsonTicket.put("motif_impression", (Object)motifif_impression);
        UploadCommandService uploadCommandService = new UploadCommandService();
        if (ip_address != null) {
            String url = "http://" + ip_address + ":9097/newItems/printJustificatifPaymentBorne";
            String reponse = uploadCommandService.uploadCommand(url, jsonTicket.toString());
            JSONObject jsonResponse = new JSONObject(reponse);
            System.out.println("+++++++ jsonResponse : " + jsonResponse);
        }
    }

    public boolean cancelSharedOrder(TicketInfo ticket) {
        Tickets sharedOrder;
        Tickets tickets = sharedOrder = this.mTicketSharedService != null ? this.mTicketSharedService.getSharedOrder(ticket.getId_shared_order()) : null;
        if (sharedOrder != null) {
            try {
                String userID = "";
                if (this.m_App.getAppUserView() != null && this.m_App.getAppUserView().getUser() != null) {
                    userID = this.m_App.getAppUserView().getUser().getId();
                } else {
                    UserInfo userInfo = new UserInfo(AppLocal.user != null ? AppLocal.user : AppLocal.user_maintenance);
                    userID = userInfo.getId();
                }
                this.dlSales.cancelOrderPending(ticket, this.reason_cancel, userID, true);
                return true;
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return false;
    }

    public TicketInfo cancelTicket(TicketInfo ticket, String modeRefund) throws BasicException {
        UserInfo user = this.getCurrentUser();
        if (AppLocal.MODULE_CLOVER) {
            for (PaymentInfo payment : ticket.getPayments()) {
                System.out.println("+++++++++ payment.getIdPaymentExterne() : " + payment.getIdPaymentExterne());
                if (payment.getIdPaymentExterne() == null || payment.getIdPaymentExterne().isEmpty()) continue;
                PaymentByCardFacade facade = PaymentByCardFacade.getInstance(this.m_App);
                facade.doRefund(0.0, null, payment.getIdPaymentExterne());
            }
        }
        if (AppLocal.MODULE_MEV || AppLocal.MODULE_TVA_GLOBAL) {
            for (PaymentInfo payment : ticket.getPayments()) {
                payment.setTotal(-1.0 * payment.getTotal());
                payment.setPaid(-1.0 * payment.getPaid());
                System.out.println("=============== payement : " + payment.getName() + "  : " + payment.getTotal());
            }
        } else {
            ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>();
            PaymentInfo paymentInfo1 = new PaymentInfo(modeRefund, -1.0 * Math.abs(ticket.getTotalOrder()), -1.0 * Math.abs(ticket.getTotalOrder()));
            paymentInfos.add(paymentInfo1);
            ticket.setPayments(paymentInfos);
        }
        TicketInfo ti = this.dlSales.cancelOrder(ticket, ticket.getReason_cancel(), user.getId(), modeRefund);
        return ti;
    }

    public final String getTicketByIdPlatform(String idOrderPlatform) throws BasicException {
        return this.dlSales.getTicketByIdPlatform(idOrderPlatform);
    }

    public void checkPromotionsCustomised(TicketInfo ticket, String type_order) throws BasicException {
        List<PromotionInfo> promotions = this.dlItems.getPromotions(false);
        if (promotions != null && !promotions.isEmpty()) {
            for (TicketLineInfo line : ticket.getLines()) {
                if (line.getPoints_loyalty() != 0.0) continue;
                line.setProduct_promotion_applied(false);
                if (!line.isPromo_product()) continue;
                line.setPromo_product(false);
                line.setDiscount(0.0);
                line.setLabelDiscount("");
            }
            this.regroupLines(ticket);
        }
        for (PromotionInfo promotion : promotions) {
            TreeMap newPromoLines = new TreeMap(Collections.reverseOrder());
            ArrayList<IndexTicketLine> lines_promotions = new ArrayList<IndexTicketLine>();
            int index_line = 0;
            for (TicketLineInfo line : ticket.getLines()) {
                ProductInfoExt product;
                if (line.getPoints_loyalty() == 0.0 && !line.isProduct_promotion_applied() && (promotion.getSize_product() == null || promotion.getSize_product().isEmpty() || line.getName_sizeProduct() != null && promotion.getSize_product().equals(line.getName_sizeProduct())) && (promotion.getType_order() == null || promotion.getType_order().isEmpty() || promotion.getType_order().equals(type_order)) && (product = CacheFinder.findProductInfoById(this.mSharedMemoryCache, this.dlSales, line.getProductID())) != null && product.getPromotions() != null) {
                    for (PromotionInfo promotionProduct : product.getPromotions()) {
                        if (promotion.getId() != promotionProduct.getId()) continue;
                        IndexTicketLine ticketLine = new IndexTicketLine(index_line, line);
                        lines_promotions.add(ticketLine);
                    }
                }
                ++index_line;
            }
            Collections.sort(lines_promotions);
            double quantity = 0.0;
            boolean ticketOffset = false;
            for (IndexTicketLine indexTicketLine : lines_promotions) {
                indexTicketLine.getTicketLine().setProduct_promotion_applied(true);
                if (!((quantity += indexTicketLine.getTicketLine().getMultiply()) >= promotion.getQuantity())) continue;
                int promo_multiplier = (int)(quantity / promotion.getQuantity());
                if (indexTicketLine.getTicketLine().getMultiply() == 1.0) {
                    double priceToRemove = this.getPriceToBeRemoved(indexTicketLine.getTicketLine().getPriceProduct(), promotion);
                    indexTicketLine.getTicketLine().setDiscount(priceToRemove);
                    indexTicketLine.getTicketLine().setType_discount("somme");
                    indexTicketLine.getTicketLine().setLabelDiscount(promotion.getName_promotion());
                    indexTicketLine.getTicketLine().setLabel_promotion(promotion.getLabelPromotion());
                    indexTicketLine.getTicketLine().setPromo_product(true);
                } else {
                    double quantityLine = indexTicketLine.getTicketLine().getMultiply() - (double)promo_multiplier;
                    TicketLineInfo newLine = (TicketLineInfo)indexTicketLine.getTicketLine().clone();
                    newLine.setID(-1);
                    newLine.setId_line_kitchen(0);
                    newLine.setId_source(0);
                    for (OptionItemOrder supplement : newLine.getListSupplements()) {
                        supplement.setId_supplement_kitchen(0);
                    }
                    for (ItemOrderInfo ingredient : newLine.getListIngredients()) {
                        ingredient.setId_ingredient_kitchen(0);
                    }
                    for (ProductTicket subProduct : newLine.getListProducts()) {
                        subProduct.setId_item_kitchen(0);
                    }
                    double priceToRemove = this.getPriceToBeRemoved(newLine.getPriceProduct() * (double)promo_multiplier, promotion);
                    newLine.setPromo_product(true);
                    newLine.setDiscount(priceToRemove);
                    newLine.setType_discount("somme");
                    newLine.setLabelDiscount(promotion.getName_promotion());
                    newLine.setLabel_promotion(promotion.getLabelPromotion());
                    newLine.setMultiply(promo_multiplier);
                    indexTicketLine.getTicketLine().setMultiply(quantityLine);
                    newPromoLines.put(indexTicketLine.getIndex() + 1, newLine);
                }
                quantity %= promotion.getQuantity();
            }
            if (newPromoLines.isEmpty()) continue;
            for (Integer index : newPromoLines.keySet()) {
                TicketLineInfo line = (TicketLineInfo)newPromoLines.get(index);
                ticket.getLines().add(index, line);
            }
        }
    }

    public void regroupLines(TicketInfo ticket) {
        ArrayList<TicketLineInfo> lines = new ArrayList<TicketLineInfo>();
        for (TicketLineInfo ticketLine : ticket.getLines()) {
            int exist = 0;
            int index = -1;
            int j = 0;
            for (TicketLineInfo line : lines) {
                if (!line.isPaid() && !line.isNext() && ticketLine.getProductID() == line.getProductID()) {
                    int sameOption = 0;
                    int sameIngredient = 0;
                    int sameProduct = 0;
                    exist = 1;
                    for (ItemOrderInfo ingredientTicket : line.getListIngredients()) {
                        for (ItemOrderInfo ingredientNew : ticketLine.getListIngredients()) {
                            if (ingredientNew.getIdCarte() != ingredientTicket.getIdCarte() || ingredientTicket.getIdProduct() != ingredientNew.getIdProduct() || ingredientTicket.getSupplement() != ingredientNew.getSupplement()) continue;
                            ++sameIngredient;
                        }
                    }
                    for (OptionItemOrder optionTicket : line.getListSupplements()) {
                        for (OptionItemOrder optionNew : ticketLine.getListSupplements()) {
                            if (optionNew.getIdCarte() != optionTicket.getIdCarte() || optionTicket.getIdProduct() != optionNew.getIdProduct() || optionTicket.getSupplement() != optionNew.getSupplement() || optionTicket.getNumberOption() != optionNew.getNumberOption() || optionTicket.isMultiple() || optionNew.isMultiple()) continue;
                            ++sameOption;
                        }
                    }
                    for (ProductTicket product : line.getListProducts()) {
                        for (ProductTicket productNew : ticketLine.getListProducts()) {
                            if (product.getIdCarte() != productNew.getIdCarte() || product.getIdProduct() != productNew.getIdProduct() || product.getNumberProduct() != productNew.getNumberProduct()) continue;
                            ++sameProduct;
                        }
                    }
                    exist = sameOption == line.getListSupplements().size() && sameOption == ticketLine.getListSupplements().size() && sameIngredient == line.getListIngredients().size() && sameIngredient == ticketLine.getListIngredients().size() && sameProduct == line.getListProducts().size() && sameProduct == ticketLine.getListProducts().size() ? this.isExistTicketLine(line, ticketLine) : 0;
                    if (exist == 1) {
                        index = j;
                    }
                }
                ++j;
            }
            if (index == -1) {
                lines.add(ticketLine);
                continue;
            }
            ((TicketLineInfo)lines.get(index)).setMultiply(((TicketLineInfo)lines.get(index)).getMultiply() + ticketLine.getMultiply());
        }
        ticket.setLines(lines);
    }

    private int isExistTicketLine(TicketLineInfo line, TicketLineInfo newTicketLine) {
        int exist = 0;
        if (newTicketLine.getProductID() == line.getProductID()) {
            exist = 1;
        }
        if (exist == 1 && line.getValueDiscount() != newTicketLine.getValueDiscount()) {
            exist = 0;
        }
        exist = exist == 1 && (newTicketLine.getLabelDiscount() != null && line.getLabelDiscount() != null && newTicketLine.getLabelDiscount().equals(line.getLabelDiscount()) || newTicketLine.getLabelDiscount() == null && (line.getLabelDiscount() == null || line.getLabelDiscount().isEmpty()) || line.getLabelDiscount() == null && (newTicketLine.getLabelDiscount() == null || newTicketLine.getLabelDiscount().isEmpty())) ? 1 : 0;
        exist = exist == 1 && (newTicketLine.getSizeProduct() != null && line.getSizeProduct() != null && newTicketLine.getSizeProduct().equalsIgnoreCase(line.getSizeProduct()) || newTicketLine.getSizeProduct() == null && line.getSizeProduct() == null) ? 1 : 0;
        exist = exist == 1 && (newTicketLine.getNote() != null && line.getNote() != null && newTicketLine.getNote().equals(line.getNote()) || newTicketLine.getNote() == null && line.getNote() == null) ? 1 : 0;
        exist = exist == 1 && (newTicketLine.getPlace_served() != null && line.getPlace_served() != null && newTicketLine.getPlace_served().equals(line.getPlace_served()) || newTicketLine.getPlace_served() == null && line.getPlace_served() == null) ? 1 : 0;
        exist = exist == 1 && (line.getTime_served() == null || newTicketLine.getTime_served().equals(line.getTime_served())) ? 1 : 0;
        return exist;
    }

    public List<ProductInfoExt> getPromotionProducts(PromotionInfo promotion, String type) throws BasicException {
        if (this.mItemService == null) {
            this.mItemService = ItemService.getInstance();
        }
        return this.mItemService.getPromotionProducts(promotion, type);
    }

    public PromotionInfo getPromotionProducts(TicketInfo ticket, String type_order) {
        TicketLineInfo lastLine = ticket.getLastLine();
        if (lastLine != null) {
            try {
                ProductInfoExt product = CacheFinder.findProductInfoById(this.mSharedMemoryCache, this.dlSales, lastLine.getProductID());
                if (product != null && product.getPromotions() != null) {
                    for (PromotionInfo promotion : product.getPromotions()) {
                        System.out.println("promotion getPromotionProducts : " + promotion);
                        double quantity = 0.0;
                        for (TicketLineInfo line : ticket.getLines()) {
                            ProductInfoExt productTmp;
                            if (promotion.getSize_product() != null && !promotion.getSize_product().isEmpty() && (line.getName_sizeProduct() == null || !promotion.getSize_product().equals(line.getName_sizeProduct())) || promotion.getType_order() != null && !promotion.getType_order().isEmpty() && !promotion.getType_order().equals(type_order) || (productTmp = CacheFinder.findProductInfoById(this.mSharedMemoryCache, this.dlSales, line.getProductID())) == null || productTmp.getPromotions() == null) continue;
                            for (PromotionInfo promotionProduct : product.getPromotions()) {
                                if (promotion.getId() != promotionProduct.getId()) continue;
                                quantity += line.getMultiply();
                            }
                        }
                        if (quantity % promotion.getQuantity() != 1.0) continue;
                        List<ProductInfoExt> products = this.getPromotionProducts(promotion, type_order);
                        promotion.setProducts(products);
                        return promotion;
                    }
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return null;
    }

    private void setPrinterRecap() {
        try {
            this.printerSummaryKitchen = this.dlSales.getPrinterSummaryKitchen();
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void setTaxesByTypeOrder(TicketInfo ticket, String typeOrder) throws BasicException {
        for (TicketLineInfo line : ticket.getLines()) {
            if (line.isNext() || line.isDiver()) continue;
            ProductInfoExt product = CacheFinder.findProductInfoById(this.mSharedMemoryCache, this.dlSales, line.getProductID());
            if (product != null) {
                String taxeId = AppLocal.MODULE_MEV || AppLocal.MODULE_TVA_GLOBAL ? "004" : product.getTaxCategoryIDByOrderType(typeOrder);
                TaxInfo tax = CacheFinder.findTaxInfoById(this.mSharedMemoryCache, this.dlSales, taxeId);
                line.setTaxInfo(tax);
            }
            if (!AppLocal.MODULE_MULTI_TVA) continue;
            for (OptionItemOrder supplement : line.getListSupplements()) {
                if (!supplement.addTaxeToOption()) continue;
                String taxeId = AppLocal.MODULE_MEV || AppLocal.MODULE_TVA_GLOBAL ? "004" : supplement.getTaxId();
                TaxInfo tax = CacheFinder.findTaxInfoById(this.mSharedMemoryCache, this.dlSales, taxeId);
                supplement.setTax(tax);
            }
        }
    }

    public void setTaxesLines(TicketInfo ticket) {
        for (TicketLineInfo line : ticket.getLines()) {
            if (line.isNext()) continue;
            Double ht = (line.getPriceWithoutTaxedOptions() * line.getMultiply() - line.getDiscountPriceWithoutTaxedOptions()) / (1.0 + line.getTaxRate());
            line.setHtAmount(ht);
            line.setTaxAmount(line.getPriceWithoutTaxedOptions() * line.getMultiply() - line.getDiscountPriceWithoutTaxedOptions() - ht);
            double discountPercent = line.getDiscountPercent();
            if (!AppLocal.MODULE_MULTI_TVA) continue;
            for (OptionItemOrder supplement : line.getListSupplements()) {
                if (!supplement.addTaxeToOption() || supplement.getTax() == null) continue;
                Double htOption = (supplement.getFull_price() * line.getMultiply() - supplement.getDiscount(discountPercent, line.getMultiply())) / (1.0 + supplement.getTaxRate());
                supplement.setHtAmount(htOption);
                supplement.setTaxAmount(supplement.getFull_price() * line.getMultiply() - supplement.getDiscount(discountPercent, line.getMultiply()) - htOption);
            }
        }
    }

    public void addPaymentsToOldGTP() throws BasicException {
        System.out.println("++++++++++++ start addPaymentsToOldGTP :  " + new Date());
        List<GrandTotalPeriode> gtpDays = this.dlSales.loadGTPToUpdateTaxes("j");
        for (GrandTotalPeriode grandTotalPeriode : gtpDays) {
            int year = grandTotalPeriode.getYear();
            int month = grandTotalPeriode.getMonth();
            int day = grandTotalPeriode.getDay();
            Date dateStart = new Date(year - 1900, month - 1, day);
            Date dateEnd = new Date();
            DateUtils.setDateHours(dateStart, dateEnd);
            List<PaymentLine> payments = AppLocal.dlStats.loadPaymentXDay(dateStart, dateEnd);
            Double credit_card_total = 0.0;
            Double debit_card_total = 0.0;
            if (payments != null) {
                for (PaymentLine payment : payments) {
                    switch (payment.getM_PaymentType()) {
                        case "carte credit": {
                            credit_card_total = payment.getM_PaymentValue();
                            break;
                        }
                        case "carte debit": {
                            debit_card_total = payment.getM_PaymentValue();
                        }
                    }
                }
            }
            grandTotalPeriode.setCredit_card_total(credit_card_total);
            grandTotalPeriode.setDebit_card_total(debit_card_total);
            this.dlSales.addPaymentsToOldGTP(grandTotalPeriode);
        }
        List<GrandTotalPeriode> gtpMonths = this.dlSales.loadGTPToUpdateTaxes("m");
        for (GrandTotalPeriode grandTotalPeriode : gtpMonths) {
            HashMap<String, Object> map_infos = this.dlSales.getPaymentsInfoPeriode(grandTotalPeriode.getId(), "j");
            Double credit_card_total = NumericUtils.round((Double)map_infos.get("CREDIT_CARD_TOTAL"));
            Double debit_card_total = NumericUtils.round((Double)map_infos.get("DEBIT_CARD_TOTAL"));
            grandTotalPeriode.setCredit_card_total(credit_card_total);
            grandTotalPeriode.setDebit_card_total(debit_card_total);
            this.dlSales.addPaymentsToOldGTP(grandTotalPeriode);
        }
        System.out.println("++++++++++++ end addPaymentsToOldGTP :  " + new Date());
    }

    public List<ProductResult> getTicketProductGrouped(TicketInfo ticket) {
        ArrayList<ProductResult> products = new ArrayList<ProductResult>();
        try {
            for (TicketLineInfo line : ticket.getLines()) {
                ProductResult existProduct;
                ArrayList<ItemOrderInfo> itemIngredients;
                ProductInfoExt productInfo;
                if (!(line.isNext() || line.getProductName() != null && (line.getProductName().toLowerCase().contains("Frais de livraison".toLowerCase()) || line.getProductName().toLowerCase().contains("Frais de gestion".toLowerCase())))) {
                    if (line.getListProducts() == null || line.getListProducts().isEmpty()) {
                        ProductInfoExt productInfo2 = CacheFinder.findProductInfoById(this.mSharedMemoryCache, this.dlSales, line.getProductID());
                        if (AppLocal.PRINT_RECAP_TYPE_ITEMS == null || AppLocal.PRINT_RECAP_TYPE_ITEMS.equalsIgnoreCase("all_products") || productInfo2 != null && productInfo2.getPrinterID() > 0) {
                            ProductResult existProduct2 = this.getProduct(products, line.getProductID(), line.getSizeProduct(), line.getListIngredients());
                            if (existProduct2 != null) {
                                existProduct2.setQuantity(existProduct2.getQuantity() + line.getMultiply());
                            } else {
                                this.addProduct(products, line.getProductID(), line.getNameProduct(), line.getMultiply(), line.getListIngredients(), line.getSizeProduct());
                            }
                        }
                    } else {
                        for (ProductTicket item : line.getListProducts()) {
                            productInfo = CacheFinder.findProductInfoById(this.mSharedMemoryCache, this.dlSales, item.getIdProduct());
                            if (AppLocal.PRINT_RECAP_TYPE_ITEMS != null && !AppLocal.PRINT_RECAP_TYPE_ITEMS.equalsIgnoreCase("all_products") && (productInfo == null || productInfo.getPrinterID() <= 0)) continue;
                            itemIngredients = new ArrayList();
                            for (ItemOrderInfo ingredient : line.getListIngredients()) {
                                if (ingredient.getIdProduct() != item.getIdProduct() || ingredient.getIdCarte() != item.getIdCarte() || ingredient.getIndex_carte() != item.getIndex_carte()) continue;
                                itemIngredients.add(ingredient);
                            }
                            existProduct = this.getProduct(products, item.getIdProduct(), null, itemIngredients);
                            if (existProduct != null) {
                                existProduct.setQuantity(existProduct.getQuantity() + line.getMultiply() * (double)item.getNumberProduct());
                                continue;
                            }
                            this.addProduct(products, item.getIdProduct(), item.getNameProduct(), line.getMultiply() * (double)item.getNumberProduct(), itemIngredients, null);
                        }
                    }
                }
                for (OptionItemOrder supplement : line.getListSupplements()) {
                    if (!supplement.isDisplay_screen_sorti() || supplement.getId_sub_product() == 0 || (productInfo = CacheFinder.findProductInfoById(this.mSharedMemoryCache, this.dlSales, supplement.getId_sub_product())) == null || AppLocal.PRINT_RECAP_TYPE_ITEMS != null && !AppLocal.PRINT_RECAP_TYPE_ITEMS.equalsIgnoreCase("all_products") && productInfo.getPrinterID() <= 0) continue;
                    itemIngredients = new ArrayList<ItemOrderInfo>();
                    existProduct = this.getProduct(products, productInfo.getID(), null, itemIngredients);
                    if (existProduct != null) {
                        existProduct.setQuantity(existProduct.getQuantity() + (double)supplement.getNumberOption() * line.getMultiply());
                    } else {
                        this.addProduct(products, productInfo.getID(), productInfo.getName(), (double)supplement.getNumberOption() * line.getMultiply(), itemIngredients, null);
                    }
                    supplement.setItem_sub_product(true);
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        if (!products.isEmpty()) {
            Collections.sort(products, (p1, p2) -> {
                int compare = p1.getOrderCategory() == p2.getOrderCategory() ? Integer.compare(p1.getOrderProduct(), p2.getOrderProduct()) : Integer.compare(p1.getOrderCategory(), p2.getOrderCategory());
                return compare;
            });
        }
        return products;
    }

    public List<OptionResult> getTicketOptionGrouped(TicketInfo ticket) {
        ArrayList<OptionResult> options = new ArrayList<OptionResult>();
        try {
            for (TicketLineInfo line : ticket.getLines()) {
                for (OptionItemOrder supplement : line.getListSupplements()) {
                    if (!supplement.isDisplay_screen_sorti() || supplement.isItem_sub_product()) continue;
                    OptionResult oldSupplement = this.getSupplement(supplement.getSupplement(), options);
                    if (oldSupplement != null) {
                        oldSupplement.setQuantity(oldSupplement.getQuantity() + (double)supplement.getNumberOption() * line.getMultiply());
                        continue;
                    }
                    this.addOption(options, supplement, (double)supplement.getNumberOption() * line.getMultiply());
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return options;
    }

    private void addOption(List<OptionResult> options, OptionItemOrder supplement, double quantity) {
        options.add(new OptionResult(supplement.getSupplement(), supplement.getNameSupplement(), quantity));
    }

    public ProductResult getProduct(List<ProductResult> products, int id_product_to_check, String sizeProduct, List<ItemOrderInfo> ingredients) {
        for (ProductResult product : products) {
            if (product.getId() != id_product_to_check || (sizeProduct != null || product.getSizeProduct() != null) && (sizeProduct == null || product.getSizeProduct() == null || !sizeProduct.equalsIgnoreCase(product.getSizeProduct())) || !product.checkIngredients(ingredients)) continue;
            return product;
        }
        return null;
    }

    private void addProduct(List<ProductResult> products, int productID, String nameProduct, double quantity, List<ItemOrderInfo> ingredients, String sizeProduct) throws BasicException {
        int orderCategory = 0;
        int orderProduct = 0;
        int id_zone = 0;
        ProductInfoExt productInfo = CacheFinder.findProductInfoById(this.mSharedMemoryCache, this.dlSales, productID);
        if (productInfo != null) {
            CategoryInfo categoryInfo = CacheFinder.findCategoryInfoById(this.mSharedMemoryCache, this.dlSales, productInfo.getCategoryid());
            if (categoryInfo != null) {
                orderCategory = categoryInfo.getOrdercategory();
            }
            orderProduct = productInfo.getOrder_item();
            if (productInfo.getZoneId() != null) {
                id_zone = productInfo.getZoneId();
            }
        }
        products.add(new ProductResult(productID, nameProduct, quantity, orderCategory, ingredients, sizeProduct, orderProduct, id_zone));
    }

    public void printRecap(TicketInfo ticketInfo, Decreaser decreaserKitchen, boolean cb_borne, boolean recap_delivery, boolean error_send_to_caisse, String num_order_borne) {
        PrinterHelper printer = new PrinterHelper();
        ArrayList<TicketLineInfo> lines = new ArrayList<TicketLineInfo>();
        for (TicketLineInfo ticketLineInfo : ticketInfo.getLines()) {
            if (ticketLineInfo.getProductName() != null && (ticketLineInfo.getProductName().equalsIgnoreCase("Frais de livraison") || ticketLineInfo.getProductName().equalsIgnoreCase("Frais de gestion"))) continue;
            lines.add(ticketLineInfo);
        }
        List<ZoneLines> listZoneLines = this.getListZoneLines(lines, AppLocal.ADD_GROUPED_PRODUCT_BY_ZONE_TO_PRINTED_RECAP);
        List<ItemResult> itemProducts = AppLocal.ADD_GROUPED_PRODUCT_TO_PRINTED_RECAP ? this.itemsGrouped(ticketInfo) : null;
        printer.printKitchenTicketsAllProduct(this.printerSummaryKitchen, ticketInfo, listZoneLines, !AppLocal.DEACTIVE_QUANTITY, AppLocal.PRINT_FOND, AppLocal.SEPARATE_OPTION, decreaserKitchen, cb_borne, recap_delivery, error_send_to_caisse, num_order_borne, itemProducts);
    }

    private OptionResult getSupplement(int supplementId, List<OptionResult> options) {
        for (OptionResult option : options) {
            if (option.getId() != supplementId) continue;
            return option;
        }
        return null;
    }

    public List<ItemResult> itemsGrouped(TicketInfo ticket) {
        ArrayList<ItemResult> groupedItems = new ArrayList<ItemResult>();
        try {
            ArrayList<ItemResult> items = new ArrayList<ItemResult>();
            List<ProductResult> products = this.getTicketProductGrouped(ticket);
            for (ProductResult productResult : products) {
                ProductInfoExt mproduct = this.dlSales.getProductInfoById(productResult.getId());
                String name_category_product = mproduct != null ? this.dlItems.getCategoryInfo(String.valueOf(mproduct.getCategoryid())).getName() : "";
                String zone = mproduct != null && mproduct.getZoneId() != null && this.dlItems.getZoneInfoById(mproduct.getZoneId()) != null ? this.dlItems.getZoneInfoById(mproduct.getZoneId()).getName() : "Sans Zone";
                items.add(new ItemResult(productResult.getQuantity(), productResult.printName() + productResult.getNameIngredients(), name_category_product, zone));
            }
            if (AppLocal.PRINT_RECAP_TYPE_ITEMS == null || AppLocal.PRINT_RECAP_TYPE_ITEMS.equalsIgnoreCase("all_products")) {
                List<OptionResult> options = this.getTicketOptionGrouped(ticket);
                for (OptionResult option : options) {
                    Map<String, Object> option_info = null;
                    option_info = this.dlItems.getOptionInfoById(option.getId());
                    String option_category_name = (String)option_info.get("category_name");
                    items.add(new ItemResult(option.getQuantity(), option.getNameOption(), option_category_name, ""));
                }
            }
            for (ItemResult itemResult : items) {
                ItemResult existItem = this.getItem(groupedItems, itemResult);
                if (existItem != null) {
                    existItem.setQuantity(existItem.getQuantity() + itemResult.getQuantity());
                    continue;
                }
                groupedItems.add(new ItemResult(itemResult.getQuantity(), itemResult.getName(), itemResult.getOrder_category(), itemResult.getZone()));
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return groupedItems;
    }

    public ItemResult getItem(List<ItemResult> groupedItems, ItemResult item) {
        for (ItemResult groupedItem : groupedItems) {
            if (groupedItem.getName() == null || item.getName() == null || !groupedItem.getName().equalsIgnoreCase(item.getName())) continue;
            return groupedItem;
        }
        return null;
    }

    private void setGroupedTaxes(LinkedHashMap<String, Object> map_infos, List<GroupedTax> groupedTaxes) {
        List oldGroupedTaxes = (List)map_infos.get("grouped_taxes");
        System.out.println("oldGroupedTaxes : " + oldGroupedTaxes);
        for (GroupedTax groupedTax : groupedTaxes) {
            System.out.println("groupedTax :setGroupedTaxes  " + groupedTax);
            int found = -1;
            for (GroupedTax oldGroupedTaxe : oldGroupedTaxes) {
                if (!groupedTax.getCode_taxe().equals(oldGroupedTaxe.getCode_taxe())) continue;
                found = 1;
                oldGroupedTaxe.setTotal_tax(oldGroupedTaxe.getTotal_tax() + groupedTax.getTotal_tax());
                break;
            }
            if (found != -1) continue;
            oldGroupedTaxes.add(groupedTax);
        }
    }

    public void printCloseReceiptGlobalTVA(TicketInfo ticket) {
        if (AppLocal.MODULE_MEV) {
            try {
                if (this.mEVService == null) {
                    this.mEVService = new MEVService();
                }
                this.mEVService.closeReceipt(ticket);
            }
            catch (Exception ex) {
                LogToFile.log("severe", null, ex);
            }
        } else {
            PrinterHelper printer = new PrinterHelper();
            Decreaser decreaser = new Decreaser(AppLocal.dlSales, ticket.getId(), "TICKET", null, ticket.getNumero_order());
            printer.printTicketContinuityMode(ticket, "N", "N", "RFER", decreaser, this.marqueNF);
        }
    }

    public void printRappelTickets(PrinterHelper printer, int orderId, TicketInfo ticket, EnteteInfo enteteTicket, long impressionNumber, Decreaser decreaser, String value_type_trans) {
        if (AppLocal.MODULE_TVA_GLOBAL || AppLocal.MODULE_MEV && AppLocal.CONTINUITY_MODE_MEV) {
            printer.printTicketContinuityMode(ticket, "N", "N", value_type_trans, decreaser, this.marqueNF);
        } else {
            printer.printRappelTickets(ticket.getNumero_order(), ticket, enteteTicket, 0L, decreaser);
        }
    }

    public void validTransaction(TicketInfo ticket, String keenio, String idOrder) {
        Executors.newSingleThreadExecutor().execute(() -> this.mLoyaltyService.validTransaction(ticket, keenio, idOrder));
    }

    public void updateCagnoteCustomer(TicketInfo ticket) {
        Executors.newSingleThreadExecutor().execute(() -> {
            try {
                CustomerLoyalty mCustomerLoyalty = this.mLoyaltyService.getCagnoteByLoyaltyUser(ticket.getCustomerPhone(), AppLocal.CUSTOMER_LOYALTY_ID);
                if (mCustomerLoyalty != null) {
                    String ticketLoyaltyId = ticket.getOrder_id_base() != null && !ticket.getOrder_id_base().isEmpty() ? ticket.getOrder_id_base() : ticket.getId();
                    String keenio = ticket.getKeenio_base() != null && !ticket.getKeenio_base().isEmpty() ? ticket.getKeenio_base() : AppLocal.getKeenio();
                    double total_point = 0.0;
                    for (TicketLineInfo line : ticket.getLines()) {
                        total_point += line.getPoints_loyalty() * line.getMultiply();
                    }
                    mCustomerLoyalty.setUsed_points(total_point);
                    if (ticket.getTotal() > 0.0) {
                        mCustomerLoyalty.setEarned_points(ticket.getTotal());
                    }
                    this.mLoyaltyService.cancelTransaction(ticket, keenio, ticketLoyaltyId);
                    if (mCustomerLoyalty.getUsed_points() > 0.0 || mCustomerLoyalty.getEarned_points() > 0.0) {
                        this.mLoyaltyService.saveLoyaltyTransaction(mCustomerLoyalty, AppLocal.CUSTOMER_LOYALTY_ID, ticket.getTotal(), keenio, ticketLoyaltyId, false);
                    }
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        });
    }

    public void deleteTransactionLoyalty(TicketInfo ticket) {
        Executors.newSingleThreadExecutor().execute(() -> {
            try {
                String ticketLoyaltyId = ticket.getOrder_id_base() != null && !ticket.getOrder_id_base().isEmpty() ? ticket.getOrder_id_base() : ticket.getId();
                String keenio = ticket.getKeenio_base() != null && !ticket.getKeenio_base().isEmpty() ? ticket.getKeenio_base() : AppLocal.getKeenio();
                this.mLoyaltyService.cancelTransaction(ticket, keenio, ticketLoyaltyId);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        });
    }

    public FinancialReportInfo getRapportCashFund(Date dateStart, Date dateEnd, double oldCashFund) {
        try {
            List<LogPanier> logs = this.dlSales.loadLogPanier(dateStart, dateEnd);
            List<TaxeLine> taxes = this.dlSales.getTaxesBetwen(dateStart, dateEnd);
            List<UserCaisseInfo> users = this.dlSales.getCAbyUser(dateStart, dateEnd);
            List<RankTypeOrder> dataTypeOrders = AppLocal.dlStats.loadSatisticOrderByType(dateStart, dateEnd);
            List<RankTypeOrder> dataTypePlatformOrders = AppLocal.dlStats.loadPlatformOrdersByType(dateStart, dateEnd);
            List<PaymentLine> payments = this.dlSales.loadPayment(dateStart, dateEnd);
            Double turnover = this.dlSales.getCA(dateStart, dateEnd);
            Integer nbOrders = this.dlSales.getNbOrder(dateStart, dateEnd);
            Double totalDiscount = AppLocal.dlStats.getTotalDiscountOrderOfType(dateStart, dateEnd, "pourcentage") + AppLocal.dlStats.getTotalDiscountOrderOfType(dateStart, dateEnd, "somme");
            Double totalDiscountLines = AppLocal.dlStats.getTotalDiscountOnTicketLines(dateStart, dateEnd);
            Double turnoverCanceled = this.dlSales.getTurnoverCanceled(dateStart, dateEnd);
            List<TicketInfo> ordersCanceled = this.dlSales.loadTicketCanceled(dateStart, dateEnd);
            List<TicketInfo> notesCanceled = this.dlSales.loadNotesCanceled(dateStart, dateEnd);
            List<TicketInfo> discountOrders = this.dlSales.discountOrders(dateStart, dateEnd);
            List<PertEntity> pertesInfos = this.mPertEntityServices.findPertByTimeRange(dateStart, dateEnd);
            List<MoneyMouvement> mouvementsMoney = this.mMoneyMouvementServices.findMouvementByTimeRange(dateStart, dateEnd);
            double valueCourses = this.dlSales.getTotalCourses();
            List<GroupedTax> globalTaxes = AppLocal.dlStats.getGlobalTaxes(dateStart, dateEnd);
            TotaleEncaissement totaleEncaissement = AppLocal.dlStats.getTotalEncaissement(dateStart, dateEnd);
            double total_ht_taxable = totaleEncaissement != null ? totaleEncaissement.getTotal_ht_taxable() : 0.0;
            double total_ht_no_taxable = totaleEncaissement != null ? totaleEncaissement.getTotal_ht_no_taxable() : 0.0;
            this.calculDiscountOrders(discountOrders);
            FinancialReportInfo financialReportInfo = new FinancialReportInfo();
            financialReportInfo.setTurnover(turnover != null ? turnover : 0.0);
            financialReportInfo.setNumberOrders(nbOrders != null ? nbOrders : 0);
            financialReportInfo.setPayments(payments);
            financialReportInfo.setDataTypeOrders(dataTypeOrders);
            financialReportInfo.setDataTypePlatformOrders(dataTypePlatformOrders);
            financialReportInfo.setTaxes(taxes);
            financialReportInfo.setTotalDiscount(totalDiscount != null ? totalDiscount : 0.0);
            financialReportInfo.setTotalDiscountOnLines(totalDiscountLines != null ? totalDiscountLines : 0.0);
            financialReportInfo.setUsers(users);
            financialReportInfo.setTurnoverCanceled(turnoverCanceled != null ? turnoverCanceled : 0.0);
            financialReportInfo.setOrdersCanceled(ordersCanceled);
            financialReportInfo.setNotesCanceled(notesCanceled);
            financialReportInfo.setDiscountOrders(discountOrders);
            financialReportInfo.setPertesInfos(pertesInfos);
            financialReportInfo.setMouvementsMoney(mouvementsMoney);
            financialReportInfo.setLogsPanier(logs);
            financialReportInfo.setValueCourses(valueCourses);
            financialReportInfo.setGroupedTaxes(globalTaxes);
            financialReportInfo.setTotal_ht_taxable(total_ht_taxable);
            financialReportInfo.setTotal_ht_no_taxable(total_ht_no_taxable);
            double cashFund = 0.0;
            cashFund += oldCashFund;
            cashFund += financialReportInfo.getTotalCash();
            cashFund += financialReportInfo.getTotalIn();
            cashFund -= financialReportInfo.getTotalOut();
            financialReportInfo.setCashFund(cashFund -= valueCourses);
            return financialReportInfo;
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return null;
        }
    }

    private String getNamrUser() {
        UserInfo user = this.getCurrentUser();
        return user != null ? user.getName() : "";
    }

    public void printCmiTicketPayment(PrinterHelper printer, String ticket, boolean print_ticket) {
        if (AppLocal.printerCaisse.getNumber() > 0 && print_ticket) {
            BufferedImage result = null;
            printer.printTPETicket(ticket, result);
        }
    }

    public void cancelCBOrderCmi(String id_ticket, String ip_address) throws IOException {
        JSONObject jsonTicket = new JSONObject();
        jsonTicket.put("id_ticket", (Object)id_ticket);
        UploadCommandService uploadCommandService = new UploadCommandService();
        if (ip_address != null) {
            String url = "http://" + ip_address + ":9097/newItems/CancelCBOrderCmi";
            String reponse = uploadCommandService.CancelCommand(url, jsonTicket.toString());
            JSONObject jsonResponse = new JSONObject(reponse);
            if (String.valueOf(jsonResponse.get("error")).equals("Processus r\u00e9ussi. OK") || String.valueOf(jsonResponse.get("error")).equals("OK")) {
                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Commande annul\u00e9.", 1500, NPosition.BOTTOM_RIGHT);
            } else {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, String.valueOf(jsonResponse.get("error")), 1500, NPosition.BOTTOM_RIGHT);
            }
            System.out.println("++++++++++++cancelCBOrderCmi response At : " + new Date());
        }
    }

    public void sendEmailFromBorne(String id_ticket, String ip_address, String email_customer) throws IOException {
        JSONObject jsonTicket = new JSONObject();
        jsonTicket.put("id_ticket", (Object)id_ticket);
        jsonTicket.put("email_customer", (Object)email_customer);
        System.out.println("** jsonTicket" + jsonTicket.toString());
        UploadCommandService uploadCommandService = new UploadCommandService();
        if (ip_address != null) {
            String url = "http://" + ip_address + ":9097/newItems/SendTicketByEmail";
            String reponse = uploadCommandService.SendEmail(url, jsonTicket.toString());
            JSONObject jsonResponse = new JSONObject(reponse);
            System.out.println("******** jsonResponse" + jsonResponse.toString());
            if (String.valueOf(jsonResponse.get("error")).equals("OK")) {
                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Ticket \u00e9lectronique est bien envoy\u00e9.", 1500, NPosition.BOTTOM_RIGHT);
            } else {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, String.valueOf(jsonResponse.get("error")), 1500, NPosition.BOTTOM_RIGHT);
            }
            System.out.println("++++++++++++sendEmailFromBorne response At : " + new Date());
        }
    }

    public NumberOrder getNumberOrder(TicketInfo ticket) {
        Object numberOrder = "";
        String additioanl_text = "";
        if (AppLocal.DISHOP_INTEGRATION != null && AppLocal.DISHOP_INTEGRATION.equalsIgnoreCase("dishop light") && ticket.getSent_from() != null && ticket.getSent_from().equalsIgnoreCase("Dishop")) {
            additioanl_text = "ext\u00e9rieure";
        } else if (AppLocal.KITCHEN_COMPOSITE && (ticket.getNum_order_kitchen() == -1 || ticket.getNum_order_kitchen() == 0)) {
            additioanl_text = "PB connexion";
        }
        if (AppLocal.ADD_HOUR_TO_NUMBER_ORDER) {
            int orderNumber = ticket.getNum_order_kitchen() != -1 && ticket.getNum_order_kitchen() != 0 ? ticket.getNum_order_kitchen() : ticket.getNumero_order();
            numberOrder = ticket.getNumberOrderWithHour(orderNumber);
        } else {
            numberOrder = ticket.getNum_order_kitchen() != -1 && ticket.getNum_order_kitchen() != 0 ? String.valueOf(ticket.getNum_order_kitchen()) : (ticket.getCaisse() != null ? ticket.getCaisse() + ticket.getNumero_order() : String.valueOf(ticket.getNumero_order()));
        }
        return new NumberOrder((String)numberOrder, additioanl_text);
    }

    private void calculDiscountOrders(List<TicketInfo> discountOrders) {
        if (discountOrders != null && !discountOrders.isEmpty()) {
            for (TicketInfo order : discountOrders) {
                double discountOrder = 0.0;
                for (TicketLineInfo line : order.getLines()) {
                    discountOrder += line.getDiscount();
                }
                order.setDiscountOrderAndLines(discountOrder += order.getValueDiscount());
            }
        }
    }

    public void saveAndPrintDishopTicket(TicketInfo mTicketInfo) {
        try {
            if (AppLocal.DISHOP_INTEGRATION != null && AppLocal.DISHOP_INTEGRATION.equalsIgnoreCase("dishop full")) {
                if (mTicketInfo.getModePayment() != null && mTicketInfo.getModePayment().equalsIgnoreCase("stripe")) {
                    ArrayList<PaymentInfo> m_aPaymentInfo = new ArrayList<PaymentInfo>();
                    double total = mTicketInfo.getTotal();
                    m_aPaymentInfo.add(new PaymentInfo("stripe", total, total));
                    this.encaisserOrder(mTicketInfo, m_aPaymentInfo, null, true, false, null, false, true, true, null, "print paper", null);
                } else {
                    this.orderAttente(false, mTicketInfo, false, true, true, false, false, false);
                }
            } else {
                this.validOrder(false, mTicketInfo, null, false, null, null, false, null, null, null, "pending", false, false, null);
                this.printDishopOrder(mTicketInfo);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public final String getTicketByIdPlatform(String idOrderPlatform, String numerOrderPlatform) throws BasicException {
        return this.dlSales.getTicketByIdPlatform(idOrderPlatform, numerOrderPlatform);
    }

    private void changeStatusOrderDishop(String id_online_order) {
        Executors.newSingleThreadExecutor().execute(() -> {
            try {
                if (this.dishopService == null) {
                    this.dishopService = DishopService.getInstance();
                }
                this.dishopService.validOrder(id_online_order);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        });
    }

    private void sortProductsByZones(List<TicketLineInfo> productToSend, List<TicketLineInfo> productEMP, List<TicketLineInfo> productEmpLater, List<TicketLineInfo> productSpLater) {
        Comparator comparator = (t1, t2) -> {
            try {
                ZoneInfo z1 = Optional.ofNullable(this.dlSales.getProductInfoById(t1.getProductID())).map(ProductInfoExt::getZoneInfo).orElse(null);
                ZoneInfo z2 = Optional.ofNullable(this.dlSales.getProductInfoById(t2.getProductID())).map(ProductInfoExt::getZoneInfo).orElse(null);
                if (z1 == null && z2 == null) {
                    return 0;
                }
                if (z1 == null) {
                    return 1;
                }
                if (z2 == null) {
                    return -1;
                }
                return Integer.compare(z2.getPosition(), z1.getPosition());
            }
            catch (BasicException ex) {
                Logger.getLogger(TicketService.class.getName()).log(Level.SEVERE, null, ex);
                return 0;
            }
        };
        productToSend.sort(comparator);
        productEMP.sort(comparator);
        productEmpLater.sort(comparator);
        productSpLater.sort(comparator);
    }

    private ZoneInfo getZoneInfo(int idZone) {
        try {
            ZoneInfo zoneInfo = this.dlSales.getZoneInfoById(idZone);
            return zoneInfo;
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return null;
        }
    }

    private LinkedHashMap<Integer, List<ZoneLines>> getZoneLinesByPrinter(List<PrinterInfo> printers, List<TicketLineInfo> productToSend) {
        LinkedHashMap<Integer, List<ZoneLines>> zoneLinesByPrinter = null;
        if (productToSend != null && !productToSend.isEmpty()) {
            LinkedHashMap linesByPrinter = new LinkedHashMap();
            for (PrinterInfo printerInfo : printers) {
                ArrayList<TicketLineInfo> lines = new ArrayList<TicketLineInfo>();
                boolean printProduct = false;
                int index = 0;
                for (TicketLineInfo lineOrder : productToSend) {
                    System.out.println("lineOrder.isNext() : " + lineOrder.isNext());
                    printProduct = false;
                    if (!lineOrder.isNext()) {
                        if (lineOrder.getPrinterID() != printerInfo.getId()) {
                            for (ProductTicket item : lineOrder.getListProducts()) {
                                if (item.getPrinterID() != printerInfo.getId()) continue;
                                printProduct = true;
                                break;
                            }
                            if (lineOrder.getListNew() != null) {
                                for (ProductTicket item : lineOrder.getListNew()) {
                                    if (item.getPrinterID() != printerInfo.getId()) continue;
                                    printProduct = true;
                                    break;
                                }
                            }
                            if (lineOrder.getListUpdate() != null) {
                                for (ProductTicket item : lineOrder.getListUpdate()) {
                                    if (item.getPrinterID() != printerInfo.getId()) continue;
                                    printProduct = true;
                                    break;
                                }
                            }
                            if (lineOrder.getListDelete() != null) {
                                for (ProductTicket item : lineOrder.getListDelete()) {
                                    if (item.getPrinterID() != printerInfo.getId()) continue;
                                    printProduct = true;
                                    break;
                                }
                            }
                        } else {
                            printProduct = true;
                        }
                    }
                    if (printProduct) {
                        if (index >= 1 && productToSend.get(index - 1).isNext()) {
                            lines.add((TicketLineInfo)productToSend.get(index - 1).clone());
                        }
                        lines.add((TicketLineInfo)lineOrder.clone());
                    }
                    ++index;
                }
                linesByPrinter.put(printerInfo.getId(), lines);
            }
            for (Map.Entry entry : linesByPrinter.entrySet()) {
                List<ZoneLines> listZoneLines = this.getListZoneLines((List)entry.getValue(), AppLocal.ADD_GROUPED_PRODUCT_BY_ZONE_TO_KITCHEN_TICKET && !AppLocal.KITCHEN_TICKET_BY_PRODUCT);
                if (zoneLinesByPrinter == null) {
                    zoneLinesByPrinter = new LinkedHashMap<Integer, List<ZoneLines>>();
                }
                zoneLinesByPrinter.put((Integer)entry.getKey(), listZoneLines);
            }
        }
        return zoneLinesByPrinter;
    }

    private List<ZoneLines> getListZoneLines(List<TicketLineInfo> lines, boolean groupByZone) {
        ArrayList<ZoneLines> listZoneLines = new ArrayList<ZoneLines>();
        if (groupByZone) {
            Map<Integer, List<TicketLineInfo>> groupedByZone = lines.stream().collect(Collectors.groupingBy(line -> line.getIdZone()));
            ZoneLines defaultZoneLines = null;
            for (Map.Entry<Integer, List<TicketLineInfo>> zoneGroup : groupedByZone.entrySet()) {
                int zoneKey = zoneGroup.getKey();
                ZoneInfo zoneInfo = this.getZoneInfo(zoneKey);
                if (zoneInfo != null && zoneInfo.getId() != 0) {
                    ZoneLines zoneLines = new ZoneLines();
                    zoneLines.setName(zoneInfo.getName());
                    zoneLines.setPosition(zoneInfo.getPosition());
                    zoneLines.setLines(zoneGroup.getValue());
                    listZoneLines.add(zoneLines);
                    continue;
                }
                if (defaultZoneLines == null) {
                    defaultZoneLines = new ZoneLines();
                    defaultZoneLines.setName("default");
                    defaultZoneLines.setPosition(1);
                    defaultZoneLines.setLines(new ArrayList<TicketLineInfo>());
                }
                defaultZoneLines.getLines().addAll((Collection<TicketLineInfo>)zoneGroup.getValue());
            }
            listZoneLines.sort(Comparator.comparingInt(ZoneLines::getPosition).reversed());
            if (defaultZoneLines != null) {
                listZoneLines.add(defaultZoneLines);
            }
        } else {
            ZoneLines defaultZoneLines = new ZoneLines();
            defaultZoneLines.setName("Default");
            defaultZoneLines.setPosition(1);
            defaultZoneLines.setLines(lines);
            listZoneLines.add(defaultZoneLines);
        }
        return listZoneLines;
    }

    private List<ItemLabel> getItemsLabel(TicketInfo ticket, List<PrinterInfo> printers, String status) {
        String orderNum = ticket.getNumberOrder(true, false);
        ArrayList<ItemLabel> itemsLabel = new ArrayList<ItemLabel>();
        for (TicketLineInfo line : ticket.getLines()) {
            PrinterInfo printer;
            if (line.isNext()) continue;
            boolean printLineOrder = false;
            if (line.getPrinterLabel() > 0 && (printer = this.getPrinterById(printers, line.getPrinterLabel())) != null) {
                ItemLabel subItemLabel;
                printLineOrder = true;
                boolean printerNormal = printer.getModel() != null && printer.getModel().equals("Normal");
                ItemLabel itemLabel = this.createItemLabel(line, orderNum, ticket.getBipper(), printerNormal, status);
                itemsLabel.add(itemLabel);
                if (printerNormal) {
                    if (AppLocal.KITCHEN_TICKET_BY_PRODUCT) {
                        for (ProductTicket subProduct : line.getListProducts()) {
                            if (subProduct.getPrinterLabel() != printer.getId() && subProduct.getPrinterID() != printer.getId()) continue;
                            subItemLabel = this.createItemLabel(subProduct, line, orderNum, ticket.getBipper(), false, status);
                            itemsLabel.add(subItemLabel);
                        }
                    }
                } else if (!AppLocal.PRINT_LABEL_PRODUCT_WITH_EXCLUDED_INFREDIENT) {
                    for (ProductTicket subProduct : line.getListProducts()) {
                        if (!subProduct.isPrintSeparatedLabel()) continue;
                        subItemLabel = this.createItemLabel(subProduct, line, orderNum, ticket.getBipper(), false, status);
                        itemsLabel.add(subItemLabel);
                    }
                }
            }
            if (printLineOrder || line.getListProducts() == null || line.getListProducts().isEmpty()) continue;
            for (ProductTicket subProduct : line.getListProducts()) {
                ArrayList<ItemOrderInfo> ingredients = new ArrayList<ItemOrderInfo>();
                if (AppLocal.printIngredientExclus.booleanValue() && line.getListIngredients().size() > 0) {
                    for (ItemOrderInfo ingredient : line.getListIngredients()) {
                        if (ingredient.getIdProduct() != subProduct.getIdProduct() || ingredient.getIdCarte() != subProduct.getIdCarte() || ingredient.getIndex_carte() != subProduct.getIndex_carte()) continue;
                        ingredients.add(ingredient);
                    }
                }
                PrinterInfo printer2 = this.getPrinterById(printers, subProduct.getPrinterLabel());
                if (subProduct.getPrinterLabel() <= 0 || printer2 == null || AppLocal.PRINT_LABEL_PRODUCT_WITH_EXCLUDED_INFREDIENT && ingredients.isEmpty()) continue;
                ItemLabel subItemLabel = this.createItemLabel(subProduct, line, orderNum, ticket.getBipper(), true, status);
                itemsLabel.add(subItemLabel);
            }
        }
        return itemsLabel;
    }

    private ItemLabel createItemLabel(TicketLineInfo line, String orderNum, int bipper, boolean printerNormal, String status) {
        ItemLabel itemLabel = new ItemLabel();
        itemLabel.setNameProduct(line.printName());
        itemLabel.setSizeProduct(line.getSizeProduct());
        itemLabel.setAliasName(line.getAlias_name_product());
        itemLabel.setTypeOrder(line.getPlace_served());
        itemLabel.setNumberOrder(orderNum);
        itemLabel.setBipper(bipper);
        itemLabel.setQuantity(line.getMultiply());
        itemLabel.setComment(line.getNote());
        itemLabel.setZoneName(line.getNameZone());
        itemLabel.setZoneId(line.getIdZone());
        itemLabel.setPrinterId(line.getPrinterLabel());
        StringBuilder ingredientNames = new StringBuilder("");
        if (AppLocal.printIngredientAtLabel.booleanValue() && !AppLocal.PRINT_LABEL_PRODUCT_WITH_EXCLUDED_INFREDIENT && line.getListIngredientsIN().size() > 0) {
            boolean exist = false;
            for (SupplementItemInfo supplementItemInfo : line.getListIngredientsIN()) {
                for (ItemOrderInfo SansIngredient : line.getListIngredients()) {
                    if (!supplementItemInfo.getName().equals(SansIngredient.getNameSupplement())) continue;
                    exist = true;
                    break;
                }
                if (!exist) {
                    ingredientNames.append(" + ").append(supplementItemInfo.getName());
                }
                exist = false;
            }
        }
        if (AppLocal.printIngredientExclus.booleanValue() && line.getListIngredients().size() > 0) {
            for (ItemOrderInfo itemOrderInfo : line.getListIngredients()) {
                if (itemOrderInfo.getIdProduct() != -1 && itemOrderInfo.getIdProduct() != 0) continue;
                ingredientNames.append(" _SANS ").append(itemOrderInfo.getNameSupplement());
            }
        }
        StringBuilder supplementNames = new StringBuilder("");
        if (!AppLocal.PRINT_LABEL_PRODUCT_WITH_EXCLUDED_INFREDIENT && line.getListSupplements().size() > 0) {
            for (OptionItemOrder optionItemOrder : line.getListSupplements()) {
                if (optionItemOrder.getIdProduct() != -1 && optionItemOrder.getIdProduct() != 0 || optionItemOrder.isHidden_in_kitchen() || optionItemOrder.isConvert_to_product()) continue;
                if (optionItemOrder.getNumberOption() > 1) {
                    supplementNames.append(" + ").append(optionItemOrder.getNumberOption()).append("x").append(optionItemOrder.getNameSupplement()).append(this.loadWeightOption(optionItemOrder));
                    continue;
                }
                supplementNames.append(" + ").append(optionItemOrder.getNameSupplement()).append(this.loadWeightOption(optionItemOrder));
            }
        }
        StringBuilder stringBuilder = new StringBuilder("");
        if (printerNormal) {
            for (ProductTicket subProduct : line.getListProducts()) {
                ArrayList<ItemOrderInfo> ingredients = new ArrayList<ItemOrderInfo>();
                ArrayList<OptionItemOrder> supplements = new ArrayList<OptionItemOrder>();
                for (ItemOrderInfo ingredient : line.getListIngredients()) {
                    if (ingredient.getIdProduct() != subProduct.getIdProduct() || ingredient.getIdCarte() != subProduct.getIdCarte() || ingredient.getIndex_carte() != subProduct.getIndex_carte()) continue;
                    ingredients.add((ItemOrderInfo)ingredient.clone());
                }
                for (OptionItemOrder supplement : line.getListSupplements()) {
                    if (supplement.isNo_printable() || supplement.isHidden_in_kitchen() || supplement.getIdProduct() != subProduct.getIdProduct() || supplement.getIdCarte() != subProduct.getIdCarte() || supplement.getIndex_carte() != subProduct.getIndex_carte()) continue;
                    supplements.add((OptionItemOrder)supplement.clone());
                }
                subProduct.setIngredients(ingredients);
                subProduct.setSupplements(supplements);
            }
            itemLabel.setSubItems(line.getListProducts());
        } else if (!AppLocal.PRINT_LABEL_PRODUCT_WITH_EXCLUDED_INFREDIENT && line.getListProducts() != null && !line.getListProducts().isEmpty()) {
            for (ProductTicket item : line.getListProducts()) {
                if (item.isPrintSeparatedLabel()) continue;
                String full_name_item = item.getNumberProduct() > 1 ? item.getNumberProduct() + " " + item.getNameProduct() : item.getNameProduct();
                stringBuilder.append(" + ").append(full_name_item);
                String itemInfos = this.getTextItem(item, line);
                if (itemInfos == null) continue;
                stringBuilder.append(itemInfos);
            }
        }
        itemLabel.setIngredientsNames(ingredientNames.toString());
        itemLabel.setSupplementsName(supplementNames.toString());
        itemLabel.setSubItemsNames(stringBuilder.toString());
        ArrayList<ItemOrderInfo> arrayList = new ArrayList<ItemOrderInfo>();
        ArrayList<OptionItemOrder> supplements = new ArrayList<OptionItemOrder>();
        for (ItemOrderInfo ingredient : line.getListIngredients()) {
            if (ingredient.getIdProduct() != -1 && ingredient.getIdProduct() != 0) continue;
            arrayList.add((ItemOrderInfo)ingredient.clone());
        }
        for (OptionItemOrder supplement : line.getListSupplements()) {
            if (supplement.getId_sub_product() != 0 || supplement.isNo_printable() || supplement.isHidden_in_kitchen() || supplement.getIdProduct() != -1 && supplement.getIdProduct() != 0) continue;
            supplements.add((OptionItemOrder)supplement.clone());
        }
        itemLabel.setIngredients(arrayList);
        itemLabel.setSupplements(supplements);
        itemLabel.setStatus(status);
        return itemLabel;
    }

    private ItemLabel createItemLabel(ProductTicket subProduct, TicketLineInfo line, String orderNum, int bipper, boolean addCommentLine, String status) {
        ItemLabel itemLabel = new ItemLabel();
        itemLabel.setNameProduct(subProduct.getNameProduct());
        itemLabel.setSizeProduct(subProduct.getSizeProduct());
        itemLabel.setTypeOrder(line.getPlace_served());
        itemLabel.setNumberOrder(orderNum);
        itemLabel.setBipper(bipper);
        itemLabel.setQuantity((double)subProduct.getNumberProduct() * line.getMultiply());
        if (addCommentLine) {
            String comment = subProduct.getComment() != null && !subProduct.getComment().isEmpty() ? subProduct.getComment() : line.getNote();
            itemLabel.setComment(comment);
        } else {
            itemLabel.setComment(subProduct.getComment());
        }
        if (subProduct.getIdZone() != 0 && subProduct.getNameZone() != null && !subProduct.getNameZone().isEmpty()) {
            itemLabel.setZoneName(subProduct.getNameZone());
            itemLabel.setZoneId(subProduct.getIdZone());
        } else {
            itemLabel.setZoneName(line.getNameZone());
            itemLabel.setZoneId(line.getIdZone());
        }
        itemLabel.setPrinterId(subProduct.getPrinterLabel());
        StringBuilder ingredientNames = new StringBuilder("");
        if (AppLocal.printIngredientExclus.booleanValue() && line.getListIngredients().size() > 0) {
            for (ItemOrderInfo itemOrderInfo : line.getListIngredients()) {
                if (itemOrderInfo.getIdProduct() != subProduct.getIdProduct() || itemOrderInfo.getIdCarte() != subProduct.getIdCarte() || itemOrderInfo.getIndex_carte() != subProduct.getIndex_carte()) continue;
                ingredientNames.append(" _SANS ").append(itemOrderInfo.getNameSupplement());
            }
        }
        StringBuilder supplementNames = new StringBuilder("");
        if (!AppLocal.PRINT_LABEL_PRODUCT_WITH_EXCLUDED_INFREDIENT) {
            for (OptionItemOrder supplement : line.getListSupplements()) {
                if (supplement.isHidden_in_kitchen() || supplement.getIdProduct() != subProduct.getIdProduct() || supplement.getIdCarte() != subProduct.getIdCarte() || supplement.getIndex_carte() != subProduct.getIndex_carte()) continue;
                supplementNames.append(" + ").append(supplement.getNameSupplement());
            }
        }
        itemLabel.setIngredientsNames(ingredientNames.toString());
        itemLabel.setSupplementsName(supplementNames.toString());
        ArrayList<ItemOrderInfo> arrayList = new ArrayList<ItemOrderInfo>();
        ArrayList<OptionItemOrder> supplements = new ArrayList<OptionItemOrder>();
        for (ItemOrderInfo ingredient : line.getListIngredients()) {
            if (ingredient.getIdProduct() != subProduct.getIdProduct() || ingredient.getIdCarte() != subProduct.getIdCarte() || ingredient.getIndex_carte() != subProduct.getIndex_carte()) continue;
            arrayList.add((ItemOrderInfo)ingredient.clone());
        }
        for (OptionItemOrder supplement : line.getListSupplements()) {
            if (supplement.isNo_printable() || supplement.isHidden_in_kitchen() || supplement.getIdProduct() != subProduct.getIdProduct() || supplement.getIdCarte() != subProduct.getIdCarte() || supplement.getIndex_carte() != subProduct.getIndex_carte()) continue;
            supplements.add((OptionItemOrder)supplement.clone());
        }
        itemLabel.setIngredients(arrayList);
        itemLabel.setSupplements(supplements);
        itemLabel.setStatus(status);
        return itemLabel;
    }

    private PrinterInfo getPrinterById(List<PrinterInfo> printers, int printerId) {
        for (PrinterInfo printer : printers) {
            if (printer == null || printer.getId() != printerId) continue;
            return printer;
        }
        return null;
    }

    private String loadWeightOption(OptionItemOrder supplement) {
        Object textWeight = "";
        if (supplement.getWeight() != null) {
            switch (supplement.getWeight()) {
                case "light": {
                    textWeight = (String)textWeight + " == Leger ==";
                    break;
                }
                case "heavy": {
                    textWeight = (String)textWeight + " == Beaucoup  ==";
                }
            }
        }
        return textWeight;
    }

    private String getTextItem(ProductTicket item, TicketLineInfo product) {
        StringBuilder itemInfos = new StringBuilder("");
        if (AppLocal.printIngredientExclus.booleanValue() && product.getListIngredients().size() > 0) {
            for (ItemOrderInfo ingredient : product.getListIngredients()) {
                if (ingredient.getIdProduct() != item.getIdProduct() || ingredient.getIdCarte() != item.getIdCarte() || ingredient.getIndex_carte() != item.getIndex_carte()) continue;
                if (itemInfos.length() == 0) {
                    itemInfos.append("(");
                }
                itemInfos.append(" _SANS " + ingredient.getNameSupplement());
            }
        }
        if (product.getListSupplements().size() > 0) {
            for (OptionItemOrder supplement : product.getListSupplements()) {
                if (supplement.isHidden_in_kitchen() || supplement.getIdProduct() != item.getIdProduct() || supplement.getIdCarte() != item.getIdCarte() || supplement.getIndex_carte() != item.getIndex_carte()) continue;
                if (itemInfos.length() == 0) {
                    itemInfos.append("(");
                } else {
                    itemInfos.append(" + ");
                }
                if (supplement.getNumberOption() > 1) {
                    itemInfos.append(supplement.getNumberOption() + "x" + supplement.getNameSupplement() + this.loadWeightOption(supplement));
                    continue;
                }
                itemInfos.append(supplement.getNameSupplement() + this.loadWeightOption(supplement));
            }
        }
        if (itemInfos.length() > 0) {
            itemInfos.append(")");
            return itemInfos.toString();
        }
        return null;
    }

    private LinkedHashMap<Integer, List<ZoneItemsLabel>> getZoneItemsLabelByPrinter(List<PrinterInfo> printers, List<ItemLabel> itemsLabel) {
        LinkedHashMap<Integer, List<ZoneItemsLabel>> zoneItemsLabelByPrinter = null;
        if (itemsLabel != null && !itemsLabel.isEmpty()) {
            LinkedHashMap itemsLabelByPrinter = new LinkedHashMap();
            for (PrinterInfo printerInfo : printers) {
                ArrayList<ItemLabel> items = new ArrayList<ItemLabel>();
                for (ItemLabel itemLabel : itemsLabel) {
                    if (itemLabel.getPrinterId() != printerInfo.getId()) continue;
                    items.add((ItemLabel)itemLabel.clone());
                }
                itemsLabelByPrinter.put(printerInfo.getId(), items);
            }
            for (Map.Entry entry : itemsLabelByPrinter.entrySet()) {
                List<ZoneItemsLabel> listZoneItemsLabel = this.getListZoneItemsLabel((List)entry.getValue(), AppLocal.ADD_GROUPED_PRODUCT_BY_ZONE_TO_LABEL);
                if (zoneItemsLabelByPrinter == null) {
                    zoneItemsLabelByPrinter = new LinkedHashMap<Integer, List<ZoneItemsLabel>>();
                }
                zoneItemsLabelByPrinter.put((Integer)entry.getKey(), listZoneItemsLabel);
            }
        }
        return zoneItemsLabelByPrinter;
    }

    private List<ZoneItemsLabel> getListZoneItemsLabel(List<ItemLabel> itemsLabel, boolean groupByZone) {
        ArrayList<ZoneItemsLabel> listZoneLines = new ArrayList<ZoneItemsLabel>();
        if (groupByZone) {
            Map<Integer, List<ItemLabel>> groupedByZone = itemsLabel.stream().collect(Collectors.groupingBy(item -> item.getZoneId()));
            ZoneItemsLabel defaultZoneLines = null;
            for (Map.Entry<Integer, List<ItemLabel>> zoneGroup : groupedByZone.entrySet()) {
                int zoneKey = zoneGroup.getKey();
                ZoneInfo zoneInfo = this.getZoneInfo(zoneKey);
                if (zoneInfo != null && zoneInfo.getId() != 0) {
                    ZoneItemsLabel zoneItemsLabel = new ZoneItemsLabel();
                    zoneItemsLabel.setName(zoneInfo.getName());
                    zoneItemsLabel.setPosition(zoneInfo.getPosition());
                    zoneItemsLabel.setItemsLabel(zoneGroup.getValue());
                    listZoneLines.add(zoneItemsLabel);
                    continue;
                }
                if (defaultZoneLines == null) {
                    defaultZoneLines = new ZoneItemsLabel();
                    defaultZoneLines.setName("default");
                    defaultZoneLines.setPosition(1);
                    defaultZoneLines.setItemsLabel(new ArrayList<ItemLabel>());
                }
                defaultZoneLines.getItemsLabel().addAll((Collection<ItemLabel>)zoneGroup.getValue());
            }
            listZoneLines.sort(Comparator.comparingInt(ZoneItemsLabel::getPosition).reversed());
            if (defaultZoneLines != null) {
                listZoneLines.add(defaultZoneLines);
            }
        } else {
            ZoneItemsLabel defaultZoneLines = new ZoneItemsLabel();
            defaultZoneLines.setName("Default");
            defaultZoneLines.setPosition(1);
            defaultZoneLines.setItemsLabel(itemsLabel);
            listZoneLines.add(defaultZoneLines);
        }
        return listZoneLines;
    }

    private LinkedHashMap<Integer, List<ZoneItems>> getZoneItemsByPrinter(List<PrinterInfo> printers, List<ProductTicket> subProducts) {
        LinkedHashMap itemsByPrinter = new LinkedHashMap();
        LinkedHashMap<Integer, List<ZoneItems>> zoneItemsByPrinter = new LinkedHashMap<Integer, List<ZoneItems>>();
        if (subProducts != null && !subProducts.isEmpty()) {
            for (PrinterInfo printerInfo : printers) {
                ArrayList<ProductTicket> items = new ArrayList<ProductTicket>();
                for (ProductTicket item : subProducts) {
                    if (item.getPrinterID() != printerInfo.getId()) continue;
                    items.add((ProductTicket)item.clone());
                }
                itemsByPrinter.put(printerInfo.getId(), items);
            }
            for (Map.Entry entry : itemsByPrinter.entrySet()) {
                List<ZoneItems> listZoneItems = this.getListZoneItems((List)entry.getValue(), AppLocal.ADD_GROUPED_PRODUCT_BY_ZONE_TO_KITCHEN_TICKET && !AppLocal.KITCHEN_TICKET_BY_PRODUCT);
                zoneItemsByPrinter.put((Integer)entry.getKey(), listZoneItems);
            }
        }
        return zoneItemsByPrinter;
    }

    private List<ZoneItems> getListZoneItems(List<ProductTicket> items, boolean groupByZone) {
        ArrayList<ZoneItems> listZoneItems = new ArrayList<ZoneItems>();
        if (groupByZone) {
            Map<Integer, List<ProductTicket>> groupedByZone = items.stream().collect(Collectors.groupingBy(item -> item.getIdZone()));
            ZoneItems defaultZoneLines = null;
            for (Map.Entry<Integer, List<ProductTicket>> zoneGroup : groupedByZone.entrySet()) {
                int zoneKey = zoneGroup.getKey();
                ZoneInfo zoneInfo = this.getZoneInfo(zoneKey);
                if (zoneInfo != null && zoneInfo.getId() != 0) {
                    ZoneItems zoneItems = new ZoneItems();
                    zoneItems.setName(zoneInfo.getName());
                    zoneItems.setPosition(zoneInfo.getPosition());
                    zoneItems.setSubItems(zoneGroup.getValue());
                    listZoneItems.add(zoneItems);
                    continue;
                }
                if (defaultZoneLines == null) {
                    defaultZoneLines = new ZoneItems();
                    defaultZoneLines.setName("default");
                    defaultZoneLines.setPosition(1);
                    defaultZoneLines.setSubItems(new ArrayList<ProductTicket>());
                }
                defaultZoneLines.getSubItems().addAll((Collection<ProductTicket>)zoneGroup.getValue());
            }
            listZoneItems.sort(Comparator.comparingInt(ZoneItems::getPosition).reversed());
            if (defaultZoneLines != null) {
                listZoneItems.add(defaultZoneLines);
            }
        } else {
            ZoneItems defaultZoneLines = new ZoneItems();
            defaultZoneLines.setName("Default");
            defaultZoneLines.setPosition(1);
            defaultZoneLines.setSubItems(items);
            listZoneItems.add(defaultZoneLines);
        }
        return listZoneItems;
    }

    public void sendEmailPaidTicketCaisse(TicketInfo ticket, EnteteInfo enteteTicket, String motifif_impression, String email_customer) {
        try {
            if (!enteteTicket.IsTicketRestituted()) {
                Decreaser decreaser = new Decreaser(AppLocal.dlSales, ticket.getId(), "TICKET", null, ticket.getNumero_order());
                decreaser.setRestitution_ticket_type("send email");
                SendETicketHelper sendETicketHelper = new SendETicketHelper();
                sendETicketHelper.sendETicket(ticket.getNumero_order(), ticket, enteteTicket, false, null, decreaser, ticket.getHolder(), email_customer, null);
            } else {
                UserInfo user = this.getCurrentUser();
                this.sentEmailDuplicata(ticket, enteteTicket, user.getId(), ticket.getHolder(), motifif_impression, email_customer);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public void sentEmailDuplicata(TicketInfo ticket, EnteteInfo enteteTicket, String userId, String holder_ticket, String motifif_impression, String email_customer) throws BasicException {
        Duplicata mDuplicata = new Duplicata(ticket.getTicketId(), ticket.getId(), "Ticket", userId, new Integer(enteteTicket.getNumDoc()), motifif_impression, 0, Integer.parseInt(enteteTicket.getId()));
        long impressionNumber = this.dlSales.getNumberPrintDuplicata(ticket.getId(), "Ticket");
        mDuplicata.setImpression_Number(impressionNumber);
        mDuplicata.setDate_impression(new Date());
        Duplicata lastDuplicata = null;
        if (mDuplicata != null) {
            lastDuplicata = this.dlSales.addDuplicataAndReturnNumberPrint(mDuplicata);
            mDuplicata.setId(lastDuplicata.getId());
            mDuplicata.setSignature(lastDuplicata.getSignature());
        }
        Decreaser decreaser = new Decreaser(this.dlSales, ticket.getId(), "DUPLICATA", mDuplicata, ticket.getNumero_order());
        decreaser.setRestitution_ticket_type("send email");
        SendETicketHelper sendETicketHelper = new SendETicketHelper();
        sendETicketHelper.sendETicket(ticket.getNumero_order(), ticket, enteteTicket, false, null, decreaser, holder_ticket, email_customer, mDuplicata);
    }

    public void prepareRecapTicketMAJ(TicketInfo ticket, List<TicketLineInfo> updatedLines, List<TicketLineInfo> deletedLines) {
        for (TicketLineInfo line : ticket.getLines()) {
            if (line.getProductName() != null && (line.getProductName().equalsIgnoreCase("Frais de livraison") || line.getProductName().equalsIgnoreCase("Frais de gestion")) || line.isDiver() || line.isNext()) continue;
            if (line.getID() == -1 && line.getId_source() == 0) {
                line.setTypeUpdate("add");
                this.setLineDescription(line);
                updatedLines.add(line);
                continue;
            }
            try {
                boolean bl;
                int found;
                for (ProductTicket productTicket : line.getListProducts()) {
                    int foundOption;
                    int foundIngredient;
                    found = -1;
                    for (ProductTicket productTicket2 : line.getOldProductsTicket()) {
                        if (productTicket.getIdProduct() != productTicket2.getIdProduct()) continue;
                        found = 1;
                    }
                    if (found == -1) {
                        line.getListNew().add(productTicket);
                        continue;
                    }
                    boolean changeSupplement = false;
                    for (ItemOrderInfo itemOrderInfo : line.getListIngredients()) {
                        foundIngredient = -1;
                        for (ItemOrderInfo itemOrderInfo2 : line.getOldIngredientsTicket()) {
                            if (itemOrderInfo.getIdCarte() != itemOrderInfo2.getIdCarte() || itemOrderInfo.getIdProduct() != itemOrderInfo2.getIdProduct() || itemOrderInfo.getSupplement() != itemOrderInfo2.getSupplement()) continue;
                            foundIngredient = 1;
                        }
                        if (foundIngredient != -1 || itemOrderInfo.getIdProduct() != productTicket.getIdProduct()) continue;
                        changeSupplement = true;
                    }
                    for (ItemOrderInfo itemOrderInfo : line.getOldIngredientsTicket()) {
                        foundIngredient = -1;
                        for (ItemOrderInfo itemOrderInfo3 : line.getListIngredients()) {
                            if (itemOrderInfo3.getIdCarte() != itemOrderInfo.getIdCarte() || itemOrderInfo3.getIdProduct() != itemOrderInfo.getIdProduct() || itemOrderInfo3.getSupplement() != itemOrderInfo.getSupplement()) continue;
                            foundIngredient = 1;
                        }
                        if (foundIngredient != -1 || itemOrderInfo.getIdProduct() != productTicket.getIdProduct()) continue;
                        changeSupplement = true;
                    }
                    for (OptionItemOrder optionItemOrder : line.getListSupplements()) {
                        foundOption = -1;
                        int number = 0;
                        for (OptionItemOrder itemOrder4 : line.getOldOptionsTicket()) {
                            if (optionItemOrder.getIdCarte() != itemOrder4.getIdCarte() || optionItemOrder.getIdProduct() != itemOrder4.getIdProduct() || optionItemOrder.getSupplement() != itemOrder4.getSupplement()) continue;
                            foundOption = 1;
                            number = itemOrder4.getNumberOption();
                        }
                        if (foundOption == -1 && optionItemOrder.getIdProduct() == productTicket.getIdProduct()) {
                            changeSupplement = true;
                            continue;
                        }
                        if (number == optionItemOrder.getNumberOption()) continue;
                        changeSupplement = true;
                    }
                    for (OptionItemOrder optionItemOrder : line.getOldOptionsTicket()) {
                        foundOption = -1;
                        for (OptionItemOrder optionItemOrder2 : line.getListSupplements()) {
                            if (optionItemOrder2.getIdCarte() != optionItemOrder.getIdCarte() || optionItemOrder2.getIdProduct() != optionItemOrder.getIdProduct() || optionItemOrder2.getSupplement() != optionItemOrder.getSupplement()) continue;
                            foundOption = 1;
                        }
                        if (foundOption != -1 || optionItemOrder.getIdProduct() != productTicket.getIdProduct()) continue;
                        changeSupplement = true;
                    }
                    if (!changeSupplement) continue;
                    line.getListUpdate().add(productTicket);
                }
                for (ProductTicket productTicket : line.getOldProductsTicket()) {
                    found = -1;
                    for (ProductTicket productTicket3 : line.getListProducts()) {
                        if (productTicket3.getIdProduct() != productTicket.getIdProduct()) continue;
                        found = 1;
                    }
                    if (found != -1) continue;
                    line.getListDelete().add(productTicket);
                }
                boolean change = false;
                for (ItemOrderInfo ingredient4 : line.getListIngredients()) {
                    int found2 = -1;
                    for (ItemOrderInfo itemOrderInfo : line.getOldIngredientsTicket()) {
                        if (ingredient4.getIdCarte() != itemOrderInfo.getIdCarte() || ingredient4.getIdProduct() != itemOrderInfo.getIdProduct() || ingredient4.getSupplement() != itemOrderInfo.getSupplement()) continue;
                        found2 = 1;
                    }
                    if (found2 != -1) continue;
                    change = true;
                }
                for (ItemOrderInfo itemOrder5 : line.getOldIngredientsTicket()) {
                    int found3 = -1;
                    for (ItemOrderInfo itemOrderInfo : line.getListIngredients()) {
                        if (itemOrderInfo.getIdCarte() != itemOrder5.getIdCarte() || itemOrderInfo.getIdProduct() != itemOrder5.getIdProduct() || itemOrderInfo.getSupplement() != itemOrder5.getSupplement()) continue;
                        found3 = 1;
                    }
                    if (found3 != -1) continue;
                    change = true;
                }
                for (OptionItemOrder supplement : line.getListSupplements()) {
                    int n;
                    int found4 = -1;
                    boolean bl2 = false;
                    for (OptionItemOrder itemOrder6 : line.getOldOptionsTicket()) {
                        if (supplement.getIdCarte() != itemOrder6.getIdCarte() || supplement.getIdProduct() != itemOrder6.getIdProduct() || supplement.getSupplement() != itemOrder6.getSupplement()) continue;
                        found4 = 1;
                        n = itemOrder6.getNumberOption();
                    }
                    if (found4 == -1) {
                        change = true;
                        continue;
                    }
                    if (n == supplement.getNumberOption()) continue;
                    change = true;
                }
                for (OptionItemOrder itemOrder7 : line.getOldOptionsTicket()) {
                    int found5 = -1;
                    for (OptionItemOrder optionItemOrder : line.getListSupplements()) {
                        if (optionItemOrder.getIdCarte() != itemOrder7.getIdCarte() || optionItemOrder.getIdProduct() != itemOrder7.getIdProduct() || optionItemOrder.getSupplement() != itemOrder7.getSupplement()) continue;
                        found5 = 1;
                    }
                    if (found5 != -1) continue;
                    change = true;
                }
                if (line.getOldMultiply() != line.getMultiply()) {
                    line.setDifference_quantity(line.getMultiply() - line.getOldMultiply());
                    change = true;
                }
                boolean bl3 = false;
                if (change) {
                    bl = true;
                }
                if (line.getListDelete().size() <= 0 && line.getListNew().size() <= 0 && line.getListUpdate().size() <= 0 && !bl) continue;
                line.setTypeUpdate("update");
                this.setLineDescription(line);
                updatedLines.add(line);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        try {
            for (TicketLineInfo ticketLineInfo : ticket.getOldLines()) {
                if (ticketLineInfo.isDiver() || ticketLineInfo.isNext()) continue;
                int found = -1;
                for (TicketLineInfo l : ticket.getLines()) {
                    if ((l.getID() == -1 || ticketLineInfo.getID() != l.getID()) && (l.getId_source() == 0 || ticketLineInfo.getId_source() != l.getId_source())) continue;
                    found = 1;
                }
                if (found != -1) continue;
                deletedLines.add(ticketLineInfo);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void printRecapTicketMAJ(TicketInfo ticket) {
        ArrayList<TicketLineInfo> updatedLines = new ArrayList<TicketLineInfo>();
        ArrayList<TicketLineInfo> deletedLines = new ArrayList<TicketLineInfo>();
        this.prepareRecapTicketMAJ(ticket, updatedLines, deletedLines);
        if (this.printerSummaryKitchen == null) {
            this.setPrinterRecap();
        }
        Decreaser decreaserKitchen = new Decreaser(this.dlSales, ticket.getId(), "Ticket cuisine", null, ticket.getNumero_order());
        boolean recap_delivery = AppLocal.PRINT_RECAP_DELIVERY && ticket.getType() != null && ticket.getType().equalsIgnoreCase("En Livraison");
        int number_print = AppLocal.PRINT_RECAP_DELIVERY && ticket.getType() != null && ticket.getType().equalsIgnoreCase("En Livraison") && AppLocal.NUMBER_PRINT_DELIVERY > 0 ? AppLocal.NUMBER_PRINT_DELIVERY : 1;
        for (int i = 0; i < number_print; ++i) {
            try {
                PrinterHelper printer = new PrinterHelper();
                List<ZoneLines> listZoneLines = this.getListZoneLines(updatedLines, AppLocal.ADD_GROUPED_PRODUCT_BY_ZONE_TO_PRINTED_RECAP);
                printer.printRecapTicketMaj(this.printerSummaryKitchen, ticket, listZoneLines, AppLocal.PRINT_FOND, decreaserKitchen, recap_delivery, deletedLines);
                continue;
            }
            catch (Exception ex) {
                LogToFile.log("severe", null, ex);
            }
        }
    }

    public void printZBorne(GrandTotalPeriode grandTotalPeriode) {
        try {
            Date dateStart = null;
            Date dateEnd = null;
            String title = null;
            List<UserCaisseInfo> users = null;
            int year = 0;
            int month = 0;
            CaisseInfo caisse = this.dlSales.getCaisse(AppLocal.token);
            switch (grandTotalPeriode.getTypePeriode()) {
                case "j": {
                    title = " Z Journali\u00e8re ";
                    year = grandTotalPeriode.getYear();
                    month = grandTotalPeriode.getMonth();
                    int day = grandTotalPeriode.getDay();
                    dateStart = new Date(year - 1900, month - 1, day);
                    dateEnd = new Date();
                    DateUtils.setDateHours(dateStart, dateEnd);
                    users = AppLocal.dlStats.getCAbyUserXDay(dateStart, dateEnd);
                    break;
                }
                case "m": {
                    title = " Z mensuel ";
                    year = grandTotalPeriode.getYear();
                    month = grandTotalPeriode.getMonth();
                    users = this.dlSales.getCAbyUserByYearAndOrMonth(year, month);
                    dateStart = new Date(year - 1900, month - 1, 1);
                    dateEnd = new Date(year - 1900, month, 1);
                    break;
                }
                case "a": {
                    title = " Z Annuel ";
                    year = grandTotalPeriode.getYear();
                    users = this.dlSales.getCAbyUserByYearAndOrMonth(year, 0);
                    dateStart = new Date(year - 1900, 0, 1);
                    dateEnd = new Date(year - 1900 + 1, 0, 1);
                }
            }
            List<PaymentLine> payments = grandTotalPeriode.getPayments();
            Integer m_iSales = grandTotalPeriode.getNumber_orders();
            double caCanceled = grandTotalPeriode.getTurnover_canceled();
            List<TaxeLine> allTaxes = grandTotalPeriode.getTaxes();
            double turnover = grandTotalPeriode.getCumul();
            double totalDiscount = grandTotalPeriode.getTotal_discount();
            double totalDiscountOnLines = grandTotalPeriode.getTotal_discount_lines();
            List<RankTypeOrder> dataTypeOrders = grandTotalPeriode.getTypeOrders();
            List<GroupedTax> groupedTaxes = grandTotalPeriode.getGtpTaxes();
            double total_ht_taxable = grandTotalPeriode.getTotal_ht_taxable();
            double total_ht_no_taxable = grandTotalPeriode.getTotal_ht_no_taxable();
            List<TicketInfo> ordersCanceled = this.dlSales.loadTicketCanceled(dateStart, dateEnd);
            List<TicketInfo> notesCanceled = this.dlSales.loadNotesCanceled(dateStart, dateEnd);
            List<RankTypeOrder> dataTypePlatformOrders = grandTotalPeriode.getTypePlatformOrders();
            double turnoverHT = 0.0;
            double totalTaxes = 0.0;
            if (AppLocal.MODULE_MEV || AppLocal.MODULE_TVA_GLOBAL) {
                turnoverHT = turnover;
                for (GroupedTax taxe : groupedTaxes) {
                    turnoverHT -= taxe.getTotal_tax();
                }
            } else {
                for (TaxeLine allTaxe : allTaxes) {
                    turnoverHT += allTaxe.getHt();
                    totalTaxes += allTaxe.getTax();
                }
            }
            SimpleDateFormat dateFormatterInversed = DateUtils.SDF_YYYYMMDD;
            Decreaser decreaser = new Decreaser(this.dlSales, dateFormatterInversed.format(dateEnd), "Rapport de caisse: " + title, null, new Integer(dateFormatterInversed.format(dateEnd)));
            new PrinterHelper().printCloseCaisseCenter(m_iSales, turnover, null, caCanceled, totalTaxes, payments, allTaxes, users, caisse, this.marqueNF, dateStart, dateEnd, title, totalDiscount, totalDiscountOnLines, null, ordersCanceled, null, dataTypeOrders, decreaser, grandTotalPeriode.getTypePeriode(), notesCanceled, dataTypePlatformOrders, groupedTaxes, total_ht_taxable, total_ht_no_taxable);
        }
        catch (BasicException ex) {
            LogToFile.log("severe", null, ex);
        }
    }
}

