/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.service;

import com.openbravo.basic.BasicException;
import com.openbravo.basic.BasicStorage;
import com.openbravo.components.LazyModal;
import com.openbravo.components.interfaces.EventHiddenModal;
import com.openbravo.controllers.selfCheckout.SelfCheckoutController;
import com.openbravo.dao.DataLogicSystem;
import com.openbravo.pos.admin.User;
import com.openbravo.pos.config.JPanelConfigBack;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.parser.CarteParser;
import com.openbravo.pos.parser.PhotoParser;
import com.openbravo.pos.parser.UserParser;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.StatusItem;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.SystemUtils;
import com.openbravo.service.UploadCommandService;
import fr.protactile.procaisse.dao.entities.BorneInfo;
import fr.protactile.procaisse.dao.entities.CarteInfo_DB;
import fr.protactile.procaisse.dao.entities.LanguageInfo;
import fr.protactile.procaisse.dao.entities.TagInfo;
import fr.protactile.procaisse.dao.impl.CarteInfo_DB_Dao;
import fr.protactile.procaisse.services.BorneService;
import fr.protactile.procaisse.services.LanguageService;
import fr.protactile.procaisse.services.TagsService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import javafx.application.Platform;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class SynchroService {
    private DataLogicSystem dlSystem;
    private static SynchroService m_instance;
    private AppView m_App;
    private BorneService mBorneService;
    final FilerUtils m_FilerUtils = FilerUtils.getInstance();
    private CarteInfo_DB_Dao mCarteInfoDao;
    private LanguageService languageService;
    private SelfCheckoutController mCheckoutController;
    private EventHiddenModal mActionEventSelfCheckout = null;
    private LazyModal mLazyModalselfcheckout = null;
    private String selfcheckoutLogin = "/fx/selfcheckout/login.fxml";
    private JRootApp app;

    public static SynchroService getInstance() {
        if (m_instance == null) {
            m_instance = new SynchroService(null);
        }
        return m_instance;
    }

    public static SynchroService getInstance(AppView m_App) {
        if (m_instance == null) {
            m_instance = new SynchroService(m_App);
        }
        return m_instance;
    }

    private SynchroService(AppView m_App) {
        this.m_App = m_App;
        if (this.m_App == null) {
            this.m_App = (AppView)BasicStorage.getObject("APP_ROOT_INSTANCE");
        }
        System.out.println("+++++++++++++++ m_App 2 this.m_App : " + this.m_App);
        this.dlSystem = (DataLogicSystem)this.m_App.getBean("com.openbravo.dao.DataLogicSystem");
        this.mBorneService = BorneService.getInstance();
        this.mCarteInfoDao = new CarteInfo_DB_Dao();
    }

    public void synchronize(boolean synch_carte, boolean synch_users, boolean synch_properties) throws MalformedURLException, IOException, BasicException, SQLException {
        String ip_address = AppLocal.master_address;
        synch_users = true;
        if (synch_carte) {
            String url_base = "http://" + ip_address + ":9097/newItems/list";
            URL url = new URL(url_base);
            JSONTokener tokener = new JSONTokener((Reader)new InputStreamReader(url.openStream(), "UTF-8"));
            JSONObject data = new JSONObject(tokener);
            Object[] result = CarteParser.parseItems(data);
            System.out.println("+++++++++++++dataSynch" + data);
            CarteInfo_DB last_carte = this.mCarteInfoDao.getLastCarteInfo();
            if (last_carte == null || !last_carte.getFirst_menu_downloaded().booleanValue()) {
                System.out.println("vider la carte***************");
                AppLocal.dlSales.resetCarte();
            }
            if (!synch_properties) {
                AppLocal.RELOAD_PROPERTIES_AFTER_SYNCH = false;
                this.synchrParams(data);
            }
            AppLocal.dlSync.persistGlobal(result, false);
            if (last_carte == null) {
                last_carte = new CarteInfo_DB();
                last_carte.setFirst_menu_downloaded(true);
                last_carte.setLast_update(new Date());
                this.mCarteInfoDao.addCarte(last_carte);
            } else {
                last_carte.setLast_update(new Date());
                this.mCarteInfoDao.updateCarteInfo(last_carte);
            }
            this.addImage(ip_address, "products");
            this.addImage(ip_address, "catagories");
            this.addImage(ip_address, "options");
            this.addImage(ip_address, "supplements");
            this.addImage(ip_address, "ingredients");
            this.addImage(ip_address, "tags");
            this.addImage(ip_address, "NutriPictures");
            AppLocal.product_management = true;
            AppLocal.RECEIVED_TAG_CHANGE_EVENT = true;
        }
        if (synch_users) {
            this.synchUsers("http://" + ip_address + ":9097/newItems/users");
        }
        if (synch_properties) {
            AppLocal.RELOAD_PROPERTIES_AFTER_SYNCH = false;
            this.synchProperties(ip_address);
        }
    }

    private void synchUsers(String url_base) throws MalformedURLException, IOException, BasicException, SQLException {
        URL url = new URL(url_base);
        JSONTokener tokener = new JSONTokener((Reader)new InputStreamReader(url.openStream(), "UTF-8"));
        JSONObject data = new JSONObject(tokener);
        List<User> users = UserParser.parseUser(data);
        AppLocal.dlSync.persistUsers(users);
    }

    private void synchFile(String url, String name_file) throws IOException {
        FilerUtils m_FilerUtils = FilerUtils.getInstance();
        Client client = ClientBuilder.newClient();
        Response response_product = client.target(url).request().get();
        File directory = m_FilerUtils.getFileFullPath("images");
        FileUtils.forceMkdir((File)directory);
        String old_directory_path = SystemUtils.SYS_USER_HOME + File.separator + "images" + File.separator + name_file;
        File old_directoy = new File(old_directory_path);
        if (old_directoy.exists()) {
            System.out.println("++++++++++++ old_directoy exist :  " + old_directoy.getAbsolutePath());
        }
        InputStream inputStream = (InputStream)response_product.getEntity();
        String FILE_PATH = SystemUtils.SYS_USER_HOME + File.separator + "images" + File.separator + name_file + ".zip";
        System.out.println("++++++++++ FILE_PATH : " + FILE_PATH);
        File file = new File(FILE_PATH);
        System.out.println("+++++++++++++++++++ file : " + file);
        System.out.println("++++++++++++++++ copy file");
        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)file);
        System.out.println("+++++++++++++++ unzipt file");
        JPanelConfigBack.unZipIt(file.getAbsolutePath(), new File(SystemUtils.SYS_USER_HOME, "images").getAbsolutePath());
        file.delete();
    }

    private void addImage(String ip_adress, String file_name) throws MalformedURLException, IOException {
        URL url_exist = null;
        String url_download = null;
        switch (file_name) {
            case "products": {
                url_exist = new URL("http://" + ip_adress + ":9097/newItems/existProducts");
                url_download = "http://" + ip_adress + ":9097/newItems/downloadProducts";
                break;
            }
            case "catagories": {
                url_exist = new URL("http://" + ip_adress + ":9097/newItems/existCategories");
                url_download = "http://" + ip_adress + ":9097/newItems/downloadCategories";
                break;
            }
            case "options": {
                url_exist = new URL("http://" + ip_adress + ":9097/newItems/existOptions");
                url_download = "http://" + ip_adress + ":9097/newItems/downloadOptions";
                break;
            }
            case "supplements": {
                url_exist = new URL("http://" + ip_adress + ":9097/newItems/existSupplements");
                url_download = "http://" + ip_adress + ":9097/newItems/downloadSupplements";
                break;
            }
            case "photosBorne": {
                url_exist = new URL("http://" + ip_adress + ":9097/newItems/existPhotoBorne");
                url_download = "http://" + ip_adress + ":9097/newItems/downloadPhotoBorne";
                break;
            }
            case "photosPub": {
                url_exist = new URL("http://" + ip_adress + ":9097/newItems/existPhotoPub");
                url_download = "http://" + ip_adress + ":9097/newItems/downloadPhotoPub";
                break;
            }
            case "photosDisplay": {
                url_exist = new URL("http://" + ip_adress + ":9097/newItems/existPhotoDualScreen");
                url_download = "http://" + ip_adress + ":9097/newItems/downloadPhotoDualScreen";
                break;
            }
            case "logos": {
                url_exist = new URL("http://" + ip_adress + ":9097/newItems/existLogos");
                url_download = "http://" + ip_adress + ":9097/newItems/downloadLogos";
                break;
            }
            case "ingredients": {
                url_exist = new URL("http://" + ip_adress + ":9097/newItems/existIngredients");
                url_download = "http://" + ip_adress + ":9097/newItems/downloadIngredients";
                break;
            }
            case "tags": {
                url_exist = new URL("http://" + ip_adress + ":9097/newItems/existTags");
                url_download = "http://" + ip_adress + ":9097/newItems/downloadTags";
                break;
            }
            case "nutripitures": {
                url_exist = new URL("http://" + ip_adress + ":9097/newItems/existNutris");
                url_download = "http://" + ip_adress + ":9097/newItems/downloadNutri";
                break;
            }
            default: {
                url_exist = new URL("http://" + ip_adress + ":9097/newItems/existProducts");
                url_download = "http://" + ip_adress + ":9097/newItems/downloadProducts";
            }
        }
        JSONTokener tokener_exist_product = new JSONTokener((Reader)new InputStreamReader(url_exist.openStream(), "UTF-8"));
        JSONObject data_exist = new JSONObject(tokener_exist_product);
        String message = data_exist.getString("ERROR");
        if (message.equals("OK")) {
            this.synchFile(url_download, file_name);
        }
    }

    private void synchProperties(String ip_address) throws IOException, BasicException, SQLException {
        URL url_images = new URL("http://" + ip_address + ":9097/newItems/imagesBorne");
        JSONTokener tokener = new JSONTokener((Reader)new InputStreamReader(url_images.openStream(), "UTF-8"));
        JSONObject data = new JSONObject(tokener);
        Object[] result = PhotoParser.parsePhoto(data);
        AppLocal.dlSync.persistPhoto(result);
        Client client = ClientBuilder.newClient();
        String url_properties = "http://" + ip_address + ":9097/newItems/downloadProperties";
        Response response = client.target(url_properties).request().get();
        InputStream inputStream = (InputStream)response.getEntity();
        File configfile = new File(SystemUtils.SYS_USER_HOME + File.separator + "procaisse.properties");
        AppConfig appConfig = new AppConfig(configfile, true);
        appConfig.load(inputStream);
        appConfig.save();
        this.addImage(ip_address, "photosBorne");
        this.addImage(ip_address, "photosPub");
        this.addImage(ip_address, "photosDisplay");
        this.addImage(ip_address, "logos");
    }

    public void sendStatuProduct(ProductInfoExt product) throws IOException {
        List<BorneInfo> bornes = this.mBorneService.getBornes();
        JSONObject jsonProduct = new JSONObject();
        jsonProduct.put("product_id", product.getID());
        jsonProduct.put("sold_out", product.isSold_out());
        jsonProduct.put("hidden_borne", product.isHidden_borne());
        jsonProduct.put("sold_out_temporary", product.isSold_out_temporary());
        jsonProduct.put("id_global", (Object)product.getId_global());
        if (bornes != null) {
            for (BorneInfo borne : bornes) {
                if (borne == null || borne.getAddress_ip() == null || borne.getAddress_ip().isEmpty()) continue;
                this.sendStatuProduct(jsonProduct, borne.getAddress_ip());
            }
        }
    }

    private void sendStatuProduct(JSONObject jsonProduct, String ip_address) {
        try {
            UploadCommandService uploadCommandService = new UploadCommandService();
            if (ip_address != null) {
                String url = "http://" + ip_address + ":9097/newItems/sendStatusProduct";
                String reponse = uploadCommandService.uploadCommand(url, jsonProduct.toString());
                JSONObject jsonResponse = new JSONObject(reponse);
                System.out.println("jsonResponse.getString(\"error\") : " + jsonResponse.getString("error"));
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void synchrParams(JSONObject data) {
        List<LanguageInfo> languages;
        FilerUtils m_FilerUtils = FilerUtils.getInstance();
        AppConfig appConfig = AppConfig.getInstance(true, m_FilerUtils.getFileProperties());
        if (!data.isNull("promo_basket")) {
            boolean promo_basket = data.getBoolean("promo_basket");
            appConfig.setProperty("promo.basket", promo_basket ? "yes" : "no");
        }
        if (!data.isNull("min_price_order_promo_basket")) {
            appConfig.setProperty("min.price.order.promo.basket", String.valueOf(data.getDouble("min_price_order_promo_basket")));
        }
        if (!data.isNull("price_promo_basket")) {
            appConfig.setProperty("price.promo.basket", String.valueOf(data.getDouble("price_promo_basket")));
        }
        if (!data.isNull("product_size_1")) {
            appConfig.setProperty("product.size.junior", data.getString("product_size_1"));
        }
        if (!data.isNull("product_size_2")) {
            appConfig.setProperty("product.size.senior", data.getString("product_size_2"));
        }
        if (!data.isNull("product_size_3")) {
            appConfig.setProperty("product.size.mega", data.getString("product_size_3"));
        }
        if (!data.isNull("product_size_4")) {
            appConfig.setProperty("product.size1", data.getString("product_size_4"));
        }
        if (!data.isNull("product_size_5")) {
            appConfig.setProperty("product.size2", data.getString("product_size_5"));
        }
        if (!data.isNull("product_size_6")) {
            appConfig.setProperty("product.size3", data.getString("product_size_6"));
        }
        if (!data.isNull("product_size_7")) {
            appConfig.setProperty("product.size4", data.getString("product_size_7"));
        }
        if (!data.isNull("product_size_8")) {
            appConfig.setProperty("product.size5", data.getString("product_size_8"));
        }
        if (!data.isNull("product_size_9")) {
            appConfig.setProperty("product.size6", data.getString("product_size_9"));
        }
        if (!data.isNull("product_size_10")) {
            appConfig.setProperty("product.size7", data.getString("product_size_10"));
        }
        if (!data.isNull("product_size_1_enabled")) {
            appConfig.setProperty("product.junior.enabled", data.getString("product_size_1_enabled"));
        }
        if (!data.isNull("product_size_2_enabled")) {
            appConfig.setProperty("product.senior.enabled", data.getString("product_size_2_enabled"));
        }
        if (!data.isNull("product_size_3_enabled")) {
            appConfig.setProperty("product.mega.enabled", data.getString("product_size_3_enabled"));
        }
        if (!data.isNull("product_size_4_enabled")) {
            appConfig.setProperty("product.size1.enabled", data.getString("product_size_4_enabled"));
        }
        if (!data.isNull("product_size_5_enabled")) {
            appConfig.setProperty("product.size2.enabled", data.getString("product_size_5_enabled"));
        }
        if (!data.isNull("product_size_6_enabled")) {
            appConfig.setProperty("product.size3.enabled", data.getString("product_size_6_enabled"));
        }
        if (!data.isNull("product_size_7_enabled")) {
            appConfig.setProperty("product.size4.enabled", data.getString("product_size_7_enabled"));
        }
        if (!data.isNull("product_size_8_enabled")) {
            appConfig.setProperty("product.size5.enabled", data.getString("product_size_8_enabled"));
        }
        if (!data.isNull("product_size_9_enabled")) {
            appConfig.setProperty("product.size6.enabled", data.getString("product_size_9_enabled"));
        }
        if (!data.isNull("product_size_10_enabled")) {
            appConfig.setProperty("product.size7.enabled", data.getString("product_size_10_enabled"));
        }
        if (!data.isNull("product_size_1_descreption")) {
            appConfig.setProperty("product.size1.description", data.getString("product_size_1_descreption"));
        }
        if (!data.isNull("product_size_2_descreption")) {
            appConfig.setProperty("product.size2.description", data.getString("product_size_2_descreption"));
        }
        if (!data.isNull("product_size_3_descreption")) {
            appConfig.setProperty("product.size3.description", data.getString("product_size_3_descreption"));
        }
        if (!data.isNull("product_size_4_descreption")) {
            appConfig.setProperty("product.size4.description", data.getString("product_size_4_descreption"));
        }
        if (!data.isNull("product_size_5_descreption")) {
            appConfig.setProperty("product.size5.description", data.getString("product_size_5_descreption"));
        }
        if (!data.isNull("product_size_6_descreption")) {
            appConfig.setProperty("product.size6.description", data.getString("product_size_6_descreption"));
        }
        if (!data.isNull("product_size_7_descreption")) {
            appConfig.setProperty("product.size7.description", data.getString("product_size_7_descreption"));
        }
        if (!data.isNull("product_size_8_descreption")) {
            appConfig.setProperty("product.size8.description", data.getString("product_size_8_descreption"));
        }
        if (!data.isNull("product_size_9_descreption")) {
            appConfig.setProperty("product.size9.description", data.getString("product_size_9_descreption"));
        }
        if (!data.isNull("product_size_10_descreption")) {
            appConfig.setProperty("product.size10.description", data.getString("product_size_10_descreption"));
        }
        if (!data.isNull("tariff")) {
            appConfig.setProperty("tariff", data.getString("tariff"));
        }
        if ((languages = CarteParser.parseLanguages(data)) != null) {
            if (this.languageService == null) {
                this.languageService = LanguageService.getInstance();
            }
            this.languageService.setLanguages(languages);
            this.setLanguageDefault(appConfig);
        }
        appConfig.save();
        appConfig.initInfoPromoBasket();
        appConfig.initInfoProductSize();
    }

    public void synchronizeImages() throws MalformedURLException, IOException, BasicException, SQLException {
        String ip_address = AppLocal.master_address;
        System.out.println("++++++++++ start synchro");
        this.addImage(ip_address, "products");
        this.addImage(ip_address, "catagories");
        this.addImage(ip_address, "options");
        this.addImage(ip_address, "supplements");
        this.addImage(ip_address, "ingredients");
        this.addImage(ip_address, "tags");
        System.out.println("++++++++++++ end synchro");
        AppLocal.product_management = true;
        AppLocal.RECEIVED_TAG_CHANGE_EVENT = true;
    }

    public boolean synchronizeItems() throws MalformedURLException, IOException, BasicException, SQLException {
        String ip_address = AppLocal.master_address;
        String url_base = "http://" + ip_address + ":9097/newItems/list";
        URL url = new URL(url_base);
        JSONTokener tokener = new JSONTokener((Reader)new InputStreamReader(url.openStream(), "UTF-8"));
        JSONObject data = new JSONObject(tokener);
        Object[] result = CarteParser.parseItems(data);
        CarteInfo_DB last_carte = this.mCarteInfoDao.getLastCarteInfo();
        if (last_carte == null || !last_carte.getFirst_menu_downloaded().booleanValue()) {
            System.out.println("vider la carte***************");
            AppLocal.dlSales.resetCarte();
        }
        boolean synchro_value = AppLocal.dlSync.persistGlobal(result, false);
        if (last_carte == null) {
            last_carte = new CarteInfo_DB();
            last_carte.setFirst_menu_downloaded(true);
            last_carte.setLast_update(new Date());
            this.mCarteInfoDao.addCarte(last_carte);
        } else {
            last_carte.setLast_update(new Date());
            this.mCarteInfoDao.updateCarteInfo(last_carte);
        }
        AppLocal.RELOAD_PROPERTIES_AFTER_SYNCH = false;
        this.synchrParams(data);
        AppLocal.product_management = true;
        AppLocal.RECEIVED_TAG_CHANGE_EVENT = true;
        return synchro_value;
    }

    public void sendStatuDailyStockProduct(List<Integer> product_sold_out) throws IOException {
        try {
            List<BorneInfo> bornes = this.mBorneService.getBornes();
            JSONObject jsonProduct = new JSONObject();
            JSONArray arrayProducts = new JSONArray();
            for (Integer id_product : product_sold_out) {
                arrayProducts.put((Object)id_product);
            }
            jsonProduct.put("products", (Object)arrayProducts);
            if (bornes != null) {
                for (BorneInfo borne : bornes) {
                    if (borne == null || borne.getAddress_ip() == null || borne.getAddress_ip().isEmpty()) continue;
                    this.sendStatuDailyStockProduct(jsonProduct, borne.getAddress_ip());
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void sendStatuDailyStockProduct(JSONObject jsonProduct, String ip_address) throws IOException {
        UploadCommandService uploadCommandService = new UploadCommandService();
        if (ip_address != null) {
            String url = "http://" + ip_address + ":9097/newItems/sendStatusDailyStockProduct";
            String reponse = uploadCommandService.uploadCommand(url, jsonProduct.toString());
            JSONObject jsonResponse = new JSONObject(reponse);
            System.out.println("jsonResponse.getString(\"error\") : " + jsonResponse.getString("error"));
        }
    }

    public void sendSoldOutToMasterCaisse(List<Integer> product_sold_out) throws IOException {
        try {
            System.out.println("++++++++ send ids sold out to master");
            String ip_address = AppLocal.master_address;
            JSONObject jsonProduct = new JSONObject();
            JSONArray arrayProducts = new JSONArray();
            for (Integer id_product : product_sold_out) {
                arrayProducts.put((Object)id_product);
            }
            jsonProduct.put("products", (Object)arrayProducts);
            UploadCommandService uploadCommandService = new UploadCommandService();
            String url = "http://" + ip_address + ":9097/newItems/sendSoldOutToMasterCaisse";
            String reponse = uploadCommandService.uploadCommand(url, jsonProduct.toString());
            JSONObject jsonResponse = new JSONObject(reponse);
            System.out.println("jsonResponse.getString(\"error\") : " + jsonResponse.getString("error"));
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        AppLocal.product_management = true;
    }

    public void synchProperties() throws IOException, BasicException, SQLException {
        String ip_address = AppLocal.master_address;
        this.synchProperties(ip_address);
    }

    public void synchronizePaymentBorne(boolean payment_enabled) {
        AppConfig config = AppConfig.getInstance(true, this.m_FilerUtils.getFileProperties());
        config.setPropertyPaymentBorne(payment_enabled);
    }

    public void synchronizeOnseatOrder(boolean enabled) {
        AppConfig config = AppConfig.getInstance(true, this.m_FilerUtils.getFileProperties());
        config.setPropertyOnseatOrder(enabled);
    }

    public void synchronizeMaintenanceStatus(boolean activated) {
        if (activated == AppLocal.BORNE_IN_MAINTENANCE) {
            return;
        }
        AppConfig config = AppConfig.getInstance(true, this.m_FilerUtils.getFileProperties());
        config.setPropertyInMaintenance(activated);
        Platform.runLater(() -> {
            this.app = (JRootApp)BasicStorage.getObject("APP_ROOT_INSTANCE");
            this.app.showBorne(true);
        });
    }

    public void synchronizeParams(JSONArray params, JSONObject response) {
        AppConfig config = AppConfig.getInstance(true, this.m_FilerUtils.getFileProperties());
        for (int i = 0; i < params.length(); ++i) {
            if (((String)params.get(i)).equalsIgnoreCase("tags")) {
                List<TagInfo> tags = this.getAvailableTags();
                response.put("tags", tags);
                continue;
            }
            response.put(params.getString(i), (Object)config.getBooleanProperty(params.getString(i)));
        }
    }

    public void synchronizeTags(int tagNumber, boolean enabled, boolean closed) {
        TagsService ts = TagsService.getInstance();
        TagInfo tag = ts.findByNumber(tagNumber);
        if (tag != null) {
            tag.setEnabled(enabled);
            tag.setClosed(closed);
            ts.updateTag(tag);
        }
        AppLocal.RECEIVED_TAG_CHANGE_EVENT = true;
    }

    public List<TagInfo> getAvailableTags() {
        TagsService ts = TagsService.getInstance();
        return ts.getAllTags();
    }

    public void sendItems() {
        try {
            List<BorneInfo> bornes = this.mBorneService.getBornes();
            if (bornes != null) {
                for (BorneInfo borne : bornes) {
                    String url_base;
                    if (borne == null || borne.getAddress_ip() == null || borne.getAddress_ip().isEmpty() || (url_base = "http://" + borne.getAddress_ip() + ":9097/newItems/remoteSyncItems").isEmpty()) continue;
                    try {
                        URL url = new URL(url_base);
                        JSONTokener tokener = new JSONTokener((Reader)new InputStreamReader(url.openStream(), "UTF-8"));
                        JSONObject data = new JSONObject(tokener);
                        String message = data.getString("ERROR");
                        if (message.equals("OK")) continue;
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu", 1500, NPosition.BOTTOM_RIGHT);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void sendStatuOption(SupplementItemInfo option) throws IOException {
        try {
            List<BorneInfo> bornes = this.mBorneService.getBornes();
            System.out.println("bornes : " + bornes);
            JSONObject jsonOption = new JSONObject();
            jsonOption.put("option_id", option.getiD());
            jsonOption.put("sold_out", option.isSold_out());
            jsonOption.put("hidden_borne", option.isHidden_borne());
            if (bornes != null) {
                for (BorneInfo borne : bornes) {
                    if (borne == null || borne.getAddress_ip() == null || borne.getAddress_ip().isEmpty()) continue;
                    try {
                        this.sendStatuOption(jsonOption, borne.getAddress_ip());
                    }
                    catch (IOException ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void sendStatuOption(JSONObject jsonOption, String ip_address) throws IOException {
        UploadCommandService uploadCommandService = new UploadCommandService();
        if (ip_address != null) {
            String url = "http://" + ip_address + ":9097/newItems/sendStatusOption";
            String reponse = uploadCommandService.uploadCommand(url, jsonOption.toString());
            JSONObject jsonResponse = new JSONObject(reponse);
            System.out.println("jsonResponse.getString(\"error\") : " + jsonResponse.getString("error"));
        }
    }

    public void relaunchSoftware() {
        try {
            String directoryPath = "C:\\Program Files\\Procaisse";
            String[] command = new String[]{"cmd", "/c", "cd \"" + directoryPath + "\" && java -Xms2048M -Xmx2048M -jar procaisse.jar"};
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.redirectErrorStream(true);
            builder.start();
            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Relaunch Started ", 4000, NPosition.BOTTOM_RIGHT);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                e.printStackTrace();
            }
            System.exit(0);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Error occurred while trying to restart the application.", 4000, NPosition.BOTTOM_RIGHT);
        }
    }

    public void loadBackOfficeSelfCashlogy() {
        System.out.println("******************** LOAD BACKOFFICE CASHLOGY **************");
        try {
            if (AppLocal.CASHLOGY_ENABLED && AppLocal.modeCaisse != null && !AppLocal.modeCaisse.isEmpty() && (AppLocal.modeCaisse.equals("Self-checkout") || AppLocal.modeCaisse.equals("Borne"))) {
                Platform.runLater(() -> {
                    this.app = (JRootApp)BasicStorage.getObject("APP_ROOT_INSTANCE");
                    this.app.showLoginManagerCashlogy();
                });
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void openImageMaintenance() {
        try {
            String resourcePath = "/com/openbravo/images/background_promotion_2.png";
            File tempImageFile = File.createTempFile("image", ".png");
            try (InputStream is = this.getClass().getResourceAsStream(resourcePath);
                 FileOutputStream fos = new FileOutputStream(tempImageFile);){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = is.read(buffer)) != -1) {
                    fos.write(buffer, 0, bytesRead);
                }
            }
            String imagePath = tempImageFile.getAbsolutePath();
            String[] command = new String[]{"cmd", "/c", "start", imagePath};
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.start();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void setLanguageDefault(AppConfig appConfig) {
        LanguageInfo defaultLanguage;
        String newCodeLanguage;
        if (this.languageService == null) {
            this.languageService = LanguageService.getInstance();
        }
        String string = newCodeLanguage = (defaultLanguage = this.languageService.getDefaultLanguage()) != null ? defaultLanguage.getCode_language() : null;
        if (newCodeLanguage != null && !newCodeLanguage.isEmpty() && !newCodeLanguage.equals(AppLocal.APP_LANGUAGE_DEFAULT)) {
            AppLocal.APP_LANGUAGE_DEFAULT = newCodeLanguage;
            AppLocal.APP_LANGUAGE = newCodeLanguage;
            appConfig.setProperty("app.language", newCodeLanguage);
            AppLocal.loadLanguages();
        }
    }

    public void sendItemsAndImages() {
        try {
            List<BorneInfo> bornes = this.mBorneService.getBornes();
            if (bornes != null) {
                for (BorneInfo borne : bornes) {
                    String url_base;
                    if (borne == null || borne.getAddress_ip() == null || borne.getAddress_ip().isEmpty() || (url_base = "http://" + borne.getAddress_ip() + ":9097/newItems/remoteSync").isEmpty()) continue;
                    try {
                        URL url = new URL(url_base);
                        JSONTokener tokener = new JSONTokener((Reader)new InputStreamReader(url.openStream(), "UTF-8"));
                        JSONObject data = new JSONObject(tokener);
                        String message = data.getString("ERROR");
                        if (message.equals("OK")) continue;
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu", 1500, NPosition.BOTTOM_RIGHT);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void sendStatuIngredient(SupplementItemInfo ingredient) throws IOException {
        try {
            List<BorneInfo> bornes = this.mBorneService.getBornes();
            JSONObject jsonIngredient = new JSONObject();
            jsonIngredient.put("ingredient_id", ingredient.getiD());
            jsonIngredient.put("hidden", ingredient.isHidden());
            if (bornes != null) {
                for (BorneInfo borne : bornes) {
                    if (borne == null || borne.getAddress_ip() == null || borne.getAddress_ip().isEmpty()) continue;
                    try {
                        this.sendStatuIngredient(jsonIngredient, borne.getAddress_ip());
                    }
                    catch (IOException ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void sendStatuIngredient(JSONObject jsonIngredient, String ip_address) throws IOException {
        UploadCommandService uploadCommandService = new UploadCommandService();
        if (ip_address != null) {
            String url = "http://" + ip_address + ":9097/newItems/sendStatusIngredient";
            String reponse = uploadCommandService.uploadCommand(url, jsonIngredient.toString());
            JSONObject jsonResponse = new JSONObject(reponse);
            System.out.println("jsonResponse.getString(\"error\") : " + jsonResponse.getString("error"));
        }
    }

    public void sendStatusItems(List<StatusItem> statusItems) throws IOException {
        List<BorneInfo> bornes = this.mBorneService.getBornes();
        JSONObject jsonItems = new JSONObject();
        JSONArray arrayItems = new JSONArray();
        for (StatusItem statusItem : statusItems) {
            JSONObject itemObject = new JSONObject();
            itemObject.put("id_item", statusItem.getId_item());
            itemObject.put("type_item", (Object)statusItem.getType_item());
            itemObject.put("sold_out", statusItem.isSold_out());
            itemObject.put("sold_out_temporary", statusItem.isSold_out_temporary());
            itemObject.put("id_global", (Object)statusItem.getId_global());
            arrayItems.put((Object)itemObject);
        }
        jsonItems.put("items", (Object)arrayItems);
        if (bornes != null) {
            for (BorneInfo borne : bornes) {
                if (borne == null || borne.getAddress_ip() == null || borne.getAddress_ip().isEmpty()) continue;
                this.sendStatusItems(jsonItems, borne.getAddress_ip());
            }
        }
    }

    private void sendStatusItems(JSONObject jsonProduct, String ip_address) {
        try {
            UploadCommandService uploadCommandService = new UploadCommandService();
            System.out.println("jsonProduct.toString() : " + jsonProduct.toString());
            if (ip_address != null) {
                String url = "http://" + ip_address + ":9097/newItems/sendStatusItem";
                String reponse = uploadCommandService.uploadCommand(url, jsonProduct.toString());
                System.out.println("reponse : " + reponse);
                JSONObject jsonResponse = new JSONObject(reponse);
                System.out.println("jsonResponse.getString(\"error\") : " + jsonResponse.getString("error"));
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }
}

