/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.service;

import com.openbravo.pos.config.ConfigurationManagerSite;
import com.openbravo.pos.config.SiteConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.parser.ResponseObject;
import fr.protactile.procaisse.dao.entities.TimeTableInfo;
import fr.protactile.procaisse.dao.entities.ZoneDeliveryInfo;
import fr.protactile.procaisse.services.TimeTableService;
import fr.protactile.procaisse.services.ZoneDeliveryService;
import java.io.IOException;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.simple.JSONObject;

public class SiteConfigService {
    private static SiteConfigService m_instance;
    private ZoneDeliveryService mZoneDeliveryService = ZoneDeliveryService.getInstance();
    private TimeTableService mTimeTableService = TimeTableService.getInstance();
    private ConfigurationManagerSite mConfigurationManagerSite = new ConfigurationManagerSite();

    private SiteConfigService() {
    }

    public static SiteConfigService getInstance() {
        if (m_instance == null) {
            m_instance = new SiteConfigService();
        }
        return m_instance;
    }

    public void uploadParamsSite() throws IOException {
        if (AppLocal.ONLINE_ORDER_HOST_NAME != null && !AppLocal.ONLINE_ORDER_HOST_NAME.isEmpty()) {
            List<TimeTableInfo> timestables = this.mTimeTableService.getTimesTable();
            List<ZoneDeliveryInfo> zones = this.mZoneDeliveryService.getZones();
            SiteConfig mSiteConfig = this.mConfigurationManagerSite.getmSiteConfig();
            JSONObject jsonParamSite = ResponseObject.getRootJsonParamsSite(zones, timestables, mSiteConfig);
            this.uploadParamsSite(jsonParamSite);
        }
    }

    public void uploadParamsSite(JSONObject jsonParamSite) throws IOException {
        if (AppLocal.ONLINE_ORDER_HOST_NAME != null && !AppLocal.ONLINE_ORDER_HOST_NAME.isEmpty()) {
            long licenceId = AppLocal.getLicenceId();
            OkHttpClient client = new OkHttpClient();
            System.out.println("jsonParamSite.toString() : " + jsonParamSite.toString());
            String resourceUrl = AppLocal.ONLINE_ORDER_HOST_NAME + "/configurations/" + licenceId;
            System.out.println("++++++++ resourceUrl : " + resourceUrl);
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonParamSite.toString());
            Request request = new Request.Builder().url(resourceUrl).post(requestBody).build();
            Response response = client.newCall(request).execute();
            String response_body = response.body().string();
            System.out.println("response_body : " + response_body);
            response.close();
        }
    }
}

