/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.service;

import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.MenuUberBuilder;
import com.openbravo.pos.ticket.SupplementInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketInfoBuilder;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.ItemService;
import com.openbravo.service.TicketService;
import fr.protactile.procaisse.dao.entities.InfoRushour;
import fr.protactile.procaisse.dao.impl.InfoRushourDao;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.emitter.Emitter;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;

public class RusHourService {
    private static RusHourService m_instance;
    private ItemService mItemService;
    private String url_upload = "https://rushour.biborne.com/rushours";
    private InfoRushourDao mInfoRushourDao;
    private InfoRushour mInfoRushour;
    private String store_id;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private TicketService mTicketService;

    private RusHourService() {
        this.mItemService = ItemService.getInstance();
        this.mInfoRushourDao = new InfoRushourDao();
        this.loadInfoUberEats();
    }

    public static RusHourService getInstance() {
        if (m_instance == null) {
            m_instance = new RusHourService();
        }
        return m_instance;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.support.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.support.removePropertyChangeListener(pcl);
    }

    public void connect() throws URISyntaxException {
        System.out.println("connect rushour");
        if (this.store_id != null && !this.store_id.isEmpty()) {
            System.out.println("mUberService.getStoreID() : " + this.store_id);
            Socket socket = IO.socket((String)"http://45.76.44.106:6699");
            socket.connect();
            socket.on(this.store_id, new Emitter.Listener(){

                public void call(Object ... args) {
                    JSONObject json_meta;
                    JSONObject json_order_notification = (JSONObject)args[0];
                    System.out.println("+++++++ json_order_notification : " + json_order_notification);
                    String platform_source = null;
                    if (json_order_notification != null && !json_order_notification.isNull("meta") && (json_meta = json_order_notification.getJSONObject("meta")) != null && !json_meta.isNull("type")) {
                        platform_source = json_meta.getString("type");
                    }
                    if (json_order_notification != null && !json_order_notification.isNull("order")) {
                        JSONObject json_order = json_order_notification.getJSONObject("order");
                        if (platform_source != null && !platform_source.isEmpty()) {
                            json_order.put("platform_source", (Object)platform_source);
                        }
                        if (json_order != null) {
                            try {
                                if (AppLocal.AUTO_ACCEPT_RUSHOUR_ORDER) {
                                    RusHourService.this.addOrder(json_order);
                                } else {
                                    RusHourService.this.sentInfoOrders(1, json_order);
                                }
                            }
                            catch (Exception ex) {
                                LogToFile.log("severe", ex.getMessage(), ex);
                            }
                        }
                    }
                }
            });
        }
    }

    public void sentInfoOrders(int number_orders, JSONObject order) {
        Object[] info_orders = new Object[2];
        info_orders[1] = number_orders;
        info_orders[0] = order;
        this.support.firePropertyChange("rushour_orders", null, info_orders);
    }

    public int uploadMenu() throws IOException {
        if (this.store_id != null && !this.store_id.isEmpty()) {
            int result = 0;
            List<CategoryInfo> categories = this.mItemService.getCategories();
            List<SupplementInfo> groupsOptions = this.mItemService.getGroupsOptions();
            if (categories != null && groupsOptions != null) {
                MenuUberBuilder menu = new MenuUberBuilder().categories(categories).groupsOptions(groupsOptions).rushour(true).build();
                JSONObject jsonMenu = menu.getMenuObject();
                JSONObject jsonRoot = new JSONObject();
                long licenceId = AppLocal.getLicenceId();
                System.out.println("+++++++++= licenceId : " + licenceId);
                jsonRoot.put("storeid", (Object)this.store_id);
                jsonRoot.put("json", (Object)jsonMenu);
                System.out.println("+++++ jsonRoot : " + jsonRoot);
                OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).build();
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonRoot.toString());
                Request request = new Request.Builder().url(this.url_upload).post(requestBody).build();
                Response response = client.newCall(request).execute();
                if (response.code() == 200) {
                    result = 1;
                }
                String response_body = response.body().string();
                System.out.println("response_body : " + response_body);
                response.close();
            }
            return result;
        }
        return -1;
    }

    private void loadInfoUberEats() {
        try {
            this.mInfoRushour = this.mInfoRushourDao.firstElement();
            System.out.println("++++++++++++ mInfoRushour : " + this.mInfoRushour);
            if (this.mInfoRushour != null) {
                System.out.println("++++++++++++++++ mInfoRushour id : " + this.mInfoRushour.getId());
                this.store_id = this.mInfoRushour.getStore_id();
            } else {
                this.mInfoRushour = new InfoRushour();
                this.mInfoRushourDao.addInfoRushour(this.mInfoRushour);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public String getStoreID() {
        if (this.mInfoRushour == null) {
            this.mInfoRushour = this.mInfoRushourDao.firstElement();
        }
        if (this.mInfoRushour != null) {
            System.out.println("+++++++++++++++ mInfoRushour.getStore_id(); : " + this.mInfoRushour.getStore_id());
            return this.mInfoRushour.getStore_id();
        }
        return null;
    }

    public void setStoreID(String store_id) throws IOException {
        if (this.mInfoRushour == null) {
            this.mInfoRushour = this.mInfoRushourDao.firstElement();
        }
        if (this.mInfoRushour != null) {
            this.mInfoRushour.setStore_id(store_id);
            this.mInfoRushourDao.setStoreId(this.mInfoRushour);
        } else {
            this.mInfoRushour = new InfoRushour();
            this.mInfoRushour.setStore_id(store_id);
            this.mInfoRushourDao.addInfoRushour(this.mInfoRushour);
        }
    }

    private void encaisserOrder(TicketInfo ticket) {
        if (this.mTicketService == null) {
            this.mTicketService = TicketService.getInstance();
        }
        this.mTicketService.orderAttente(false, ticket, false, true, true, false, true, true);
    }

    private void addOrder(JSONObject json_order) {
        TicketInfo ticket = TicketInfoBuilder.create(null).objectOrder(json_order).buildOrderRushour().toTicketInfo();
        if (ticket != null) {
            this.encaisserOrder(ticket);
        }
    }
}

