/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.service;

import com.openbravo.basic.BasicException;
import com.openbravo.dao.DataLogicProduct;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.util.LogToFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import javax.swing.JDialog;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ProductService {
    private DataLogicProduct dlProduct;
    JDialog d;

    public ProductService(DataLogicProduct dlProduct) {
        this.dlProduct = dlProduct;
    }

    public int importProducts(File sourceFile) throws FileNotFoundException, IOException, BasicException, SQLException {
        try {
            FileInputStream input = new FileInputStream(sourceFile);
            XSSFWorkbook myWorkBook = new XSSFWorkbook((InputStream)input);
            XSSFSheet sheet = myWorkBook.getSheetAt(0);
            for (int j = 1; j <= sheet.getLastRowNum(); ++j) {
                CategoryInfo cat;
                XSSFRow row = sheet.getRow(j);
                Object nameCat = null;
                Cell cell = row.getCell(0);
                if (cell != null) {
                    nameCat = cell.getStringCellValue().trim();
                }
                cell = row.getCell(1);
                Object codeBare = switch (cell.getCellType()) {
                    case CellType.STRING -> cell.getStringCellValue().trim();
                    case CellType.NUMERIC -> "" + cell.getNumericCellValue();
                    case CellType.BOOLEAN -> "" + cell.getBooleanCellValue();
                    default -> cell.getStringCellValue().trim();
                };
                cell = row.getCell(2);
                Object productName = switch (cell.getCellType()) {
                    case CellType.STRING -> cell.getStringCellValue().trim();
                    case CellType.NUMERIC -> "" + cell.getNumericCellValue();
                    case CellType.BOOLEAN -> "" + cell.getBooleanCellValue();
                    default -> cell.getStringCellValue().trim();
                };
                cell = row.getCell(3);
                Object params = "";
                if (cell != null) {
                    switch (cell.getCellType()) {
                        case STRING: {
                            params = cell.getStringCellValue().trim();
                            break;
                        }
                        case NUMERIC: {
                            params = "" + cell.getNumericCellValue();
                            break;
                        }
                        case BOOLEAN: {
                            params = "" + cell.getBooleanCellValue();
                            break;
                        }
                        default: {
                            params = cell.getStringCellValue().trim();
                        }
                    }
                }
                cell = row.getCell(4);
                Double quantity = 0.0;
                if (cell != null) {
                    switch (cell.getCellType()) {
                        case NUMERIC: {
                            quantity = cell.getNumericCellValue();
                            break;
                        }
                        default: {
                            quantity = Double.parseDouble(cell.getStringCellValue().replaceAll("^[0-9.]", ""));
                        }
                    }
                }
                cell = row.getCell(5);
                Double priceSell = 0.0;
                if (cell != null) {
                    switch (cell.getCellType()) {
                        case NUMERIC: {
                            priceSell = cell.getNumericCellValue();
                            break;
                        }
                        default: {
                            priceSell = Double.parseDouble(cell.getStringCellValue().replaceAll("^[0-9.]", ""));
                        }
                    }
                }
                cell = row.getCell(6);
                Double priceBuy = 0.0;
                if (cell != null) {
                    switch (cell.getCellType()) {
                        case NUMERIC: {
                            priceBuy = cell.getNumericCellValue();
                            break;
                        }
                        default: {
                            priceBuy = Double.parseDouble(cell.getStringCellValue().replaceAll("^[0-9.]", ""));
                        }
                    }
                }
                if (nameCat == null) {
                    nameCat = productName;
                }
                if ((cat = this.dlProduct.getCategoryInfoByName((String)nameCat)) == null) {
                    cat = new CategoryInfo();
                    cat.setName((String)nameCat);
                    cat = this.dlProduct.addCategory(cat);
                }
                ProductInfoExt product = new ProductInfoExt();
                product.setName((String)productName + " " + (String)params);
                product.setCode((String)codeBare);
                product.setCategoryid(cat.getID());
                product.setTaxcategoryid("003");
                product.setM_dPriceBuy(priceBuy);
                product.setM_dPriceSell(priceSell);
                product.setQuantity(quantity);
                this.dlProduct.addOrUpdateProductIfExist(product);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return 1;
    }
}

