/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.service;

import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.MenuOtterBuilder;
import com.openbravo.pos.ticket.SupplementInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketInfoBuilder;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.ItemService;
import com.openbravo.service.TicketService;
import fr.protactile.procaisse.dao.entities.OtterInfo;
import fr.protactile.procaisse.dao.impl.OtterInfoDao;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.emitter.Emitter;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONObject;

public class OtterService {
    private static OtterService m_instance;
    private String token;
    private String store_id;
    private String client_id;
    private String client_secret;
    private String client_id_prod = "b8c5791a-adcd-4131-b1df-ead3272c3de9";
    private String client_secret_prod = "RZZQZQMOWAB4AO7BQZWQ";
    private final String client_id_test = "3a0ebcd2-fafb-4ade-842f-de5b1f83419d";
    private final String client_secret_test = "A3SROREY2VCPENE2TJMQ";
    private final String grant_type = "client_credentials";
    private final String scopes = "menus.read menus.upsert menus.get_current menus.async_job.read manager.orders";
    private PropertyChangeSupport support;
    private OtterInfoDao mOtterInfoDao;
    private OtterInfo mOtterInfo;
    private ItemService mItemService;
    private String ONLINE = "ONLINE";
    private final String MESSAGE = "message";
    private final String MESSAGE_ERROR_TOKEN = "Invalid OAuth 2.0 credentials provided.";
    private final String MESSAGE_ERROR_SOTREID_EMPTY = "Merci d'introduire le store id.";
    private final String SUCCESS = "OK";
    private final String URL_TEST = "https://partners.cloudkitchens.com";
    private final String URL_PROD = "";
    private String URL;
    private final String JOB_REFERENCE = "jobReference";
    private final String STATUS = "status";
    private final String FAILED = "FAILED";
    private final String PENDING = "PENDING";
    private final String EVENT_TYPE = "eventType";
    private final String SEND_MENU = "menus.send_menu";
    private final String EVENT_ID = "eventId";
    private final String NEW_ORDER = "orders.new_order";
    private final String METADATA = "metadata";
    private final String PAYLOAD = "payload";
    private TicketService mTicketService;
    private final String CANCEL_ORDER = "orders.cancel_order";

    public static OtterService getInstance() {
        if (m_instance == null) {
            m_instance = new OtterService();
        }
        return m_instance;
    }

    private OtterService() {
        if (AppLocal.OTTER_DEV_MODE) {
            this.client_id = "3a0ebcd2-fafb-4ade-842f-de5b1f83419d";
            this.client_secret = "A3SROREY2VCPENE2TJMQ";
            this.URL = "https://partners.cloudkitchens.com";
        } else {
            this.client_id = this.client_id_prod;
            this.client_secret = this.client_secret_prod;
            this.URL = "https://partners.cloudkitchens.com";
        }
        this.support = new PropertyChangeSupport(this);
        this.mOtterInfoDao = new OtterInfoDao();
        this.mItemService = ItemService.getInstance();
        System.out.println("+++++++++++ start");
        this.loadOtterInfo();
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.support.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.support.removePropertyChangeListener(pcl);
    }

    public void connect() throws URISyntaxException {
        System.out.println("+++++++++++++ connect OtterService : ");
        System.out.println("+++++++ store_id : " + this.store_id);
        if (this.store_id != null && !this.store_id.isEmpty()) {
            Socket socket = IO.socket((String)"http://45.76.44.106:6698");
            socket.connect();
            socket.on(this.store_id, new Emitter.Listener(){

                public void call(Object ... args) {
                    JSONObject json_event = (JSONObject)args[0];
                    System.out.println("+++++++++++ json_order : " + json_event);
                    if (json_event != null) {
                        String eventIdValue;
                        String eventTypeValue = json_event.isNull("eventType") ? null : json_event.getString("eventType");
                        String string = eventIdValue = json_event.isNull("eventId") ? null : json_event.getString("eventId");
                        if (eventTypeValue != null && eventIdValue != null) {
                            switch (eventTypeValue) {
                                case "menus.send_menu": {
                                    OtterService.this.sendCurrentMenu(eventIdValue);
                                    break;
                                }
                                case "orders.new_order": {
                                    JSONObject metadateObject;
                                    if (json_event.isNull("metadata") || (metadateObject = json_event.getJSONObject("metadata")) == null || metadateObject.isNull("payload")) break;
                                    JSONObject payloadObject = metadateObject.getJSONObject("payload");
                                    if (AppLocal.AUTO_ACCEPT_OTTER_ORDER) {
                                        OtterService.this.validOrder(payloadObject);
                                        break;
                                    }
                                    int number = 1;
                                    OtterService.this.sentInfoOrders(number, payloadObject);
                                    break;
                                }
                                case "orders.cancel_order": {
                                    OtterService.this.cancelOrder(json_event);
                                }
                            }
                        }
                    }
                }
            });
        }
    }

    private void setToken() throws IOException {
        this.token = this.getToken();
        System.out.println("+++ token api : " + this.token);
        if (this.mOtterInfo == null) {
            this.mOtterInfo = this.mOtterInfoDao.firstElement();
        }
        System.out.println("mOtterInfo : " + this.mOtterInfo);
        if (this.mOtterInfo != null) {
            this.mOtterInfoDao.setToken(this.token, this.mOtterInfo.getId());
        }
    }

    private void loadOtterInfo() {
        try {
            this.mOtterInfo = this.mOtterInfoDao.firstElement();
            System.out.println("++++++++++++ mOtterInfo : " + this.mOtterInfo);
            if (this.mOtterInfo != null) {
                System.out.println("++++++++++++++++ mOtterInfo id : " + this.mOtterInfo.getId());
                this.token = this.mOtterInfo.getToken();
                System.out.println("+++++++ token database*********************** : " + this.token);
                this.store_id = this.mOtterInfo.getStore_id();
                System.out.println("store_id : " + this.store_id);
                if (this.token == null || this.token.isEmpty()) {
                    this.setToken();
                }
            } else {
                System.out.println("++++++++++++++++++++ load info");
                this.token = this.getToken();
                this.mOtterInfo = new OtterInfo();
                this.mOtterInfo.setToken(this.token);
                this.mOtterInfoDao.addOtterInfo(this.mOtterInfo);
            }
        }
        catch (IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public String getStoreID() {
        if (this.mOtterInfo == null) {
            this.mOtterInfo = this.mOtterInfoDao.firstElement();
        }
        if (this.mOtterInfo != null) {
            System.out.println("+++++++++++++++ mInfoUberEats.getStore_id(); : " + this.mOtterInfo.getStore_id());
            return this.mOtterInfo.getStore_id();
        }
        return null;
    }

    public void setStoreID(String store_id) throws IOException {
        if (this.mOtterInfo == null) {
            this.mOtterInfo = this.mOtterInfoDao.firstElement();
        }
        if (this.mOtterInfo != null) {
            this.mOtterInfo.setStore_id(store_id);
            this.mOtterInfoDao.setStoreId(this.mOtterInfo);
        } else {
            this.token = this.getToken();
            this.mOtterInfo = new OtterInfo();
            this.mOtterInfo.setToken(this.token);
            this.mOtterInfo.setStore_id(store_id);
            this.mOtterInfoDao.addOtterInfo(this.mOtterInfo);
        }
    }

    public String uploadMenu() throws IOException {
        System.out.println("+++++++ store_id otter : " + this.store_id);
        if (this.store_id != null && !this.store_id.isEmpty()) {
            List<CategoryInfo> categories = this.mItemService.getCategories();
            List<SupplementInfo> groupsOptions = this.mItemService.getGroupsOptions();
            if (categories != null && groupsOptions != null) {
                MenuOtterBuilder menu = new MenuOtterBuilder().categories(categories).groupsOptions(groupsOptions).build();
                JSONObject jsonMenu = menu.getMenuObject();
                System.out.println("+++++++++ jsonMenu : " + jsonMenu);
                return this.uploadMenu(jsonMenu, 0);
            }
        }
        return "Merci d'introduire le store id.";
    }

    private String uploadMenu(JSONObject jsonMenu, int number_try) throws IOException {
        if (this.token == null || this.token.isEmpty()) {
            this.setToken();
        }
        System.out.println("++++ token : " + this.token);
        String result_message = "";
        boolean responseClosed = false;
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)jsonMenu.toString());
        Request request = new Request.Builder().url(this.URL + "/v1/menus").method("POST", body).addHeader("X-Application-Id", this.client_id).addHeader("X-Store-Id", this.store_id).addHeader("Authorization", "Bearer " + this.token).addHeader("Content-Type", "application/json").build();
        Response response = client.newCall(request).execute();
        System.out.println("++++++++++ response : " + response);
        String response_items = response.body().string();
        System.out.println("+++++++ response_items : " + response_items);
        if (response.code() != 202) {
            JSONObject jsonResponse = new JSONObject(response_items);
            if (!jsonResponse.isNull("message")) {
                String message;
                result_message = message = jsonResponse.getString("message");
                if (message != null && (message.equalsIgnoreCase("Invalid OAuth 2.0 credentials provided.") || number_try < 1)) {
                    response.close();
                    this.setToken();
                    return this.uploadMenu(jsonMenu, 1);
                }
            }
        } else {
            JSONObject jsonJobReference;
            JSONObject jsonResponse = new JSONObject(response_items);
            if (!jsonResponse.isNull("jobReference") && !(jsonJobReference = jsonResponse.getJSONObject("jobReference")).isNull("id")) {
                String jobId = jsonJobReference.getString("id");
                System.out.println("+++++ jobId : " + jobId);
                if (jobId != null && !jobId.isEmpty()) {
                    responseClosed = true;
                    response.close();
                    String status_job = this.getJobStaus(jobId);
                    System.out.println("status_job : " + status_job);
                }
            }
            result_message = "OK";
        }
        if (!responseClosed) {
            response.close();
        }
        return result_message;
    }

    private String getJobStaus(String jobId) throws IOException {
        System.out.println("++++ token : " + this.token);
        String result_message = "";
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Request request = new Request.Builder().url(this.URL + "/v1/menus/jobs/" + jobId).get().addHeader("X-Application-Id", this.client_id).addHeader("X-Store-Id", this.store_id).addHeader("Authorization", "Bearer " + this.token).addHeader("Content-Type", "application/json").build();
        Response response = client.newCall(request).execute();
        System.out.println("+++++++++ response : " + response);
        String status = null;
        if (response.code() == 200) {
            JSONObject jsonJobReference;
            String response_items = response.body().string();
            System.out.println("+++++++ response_items : " + response_items);
            JSONObject jsonResponse = new JSONObject(response_items);
            if (!jsonResponse.isNull("jobReference") && !(jsonJobReference = jsonResponse.getJSONObject("jobReference")).isNull("status")) {
                status = jsonJobReference.getString("status");
            }
        }
        System.out.println("+++++ status job: " + status);
        if (status == null || status.equalsIgnoreCase("PENDING")) {
            response.close();
            return this.getJobStaus(jobId);
        }
        response.close();
        return result_message;
    }

    public void uploadEmptyMenu() throws IOException {
        if (this.store_id != null && !this.store_id.isEmpty()) {
            MenuOtterBuilder menu = new MenuOtterBuilder().buildEmptyMenu();
            JSONObject jsonMenu = menu.getMenuObject();
            System.out.println("+++++++++ jsonMenu : " + jsonMenu);
            this.uploadMenu(jsonMenu, 0);
        }
    }

    public String getToken() throws IOException {
        String token = null;
        String url = this.URL + "/v1/auth/token";
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType mediaType = MediaType.parse((String)"application/x-www-form-urlencoded");
        StringBuilder bodyBuilder = new StringBuilder();
        bodyBuilder.append("client_id=");
        bodyBuilder.append(this.client_id);
        bodyBuilder.append("&client_secret=");
        bodyBuilder.append(this.client_secret);
        bodyBuilder.append("&grant_type=client_credentials&scope=");
        bodyBuilder.append("menus.read menus.upsert menus.get_current menus.async_job.read manager.orders");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)bodyBuilder.toString());
        Request request = new Request.Builder().url(url).method("POST", body).addHeader("Content-Type", "application/x-www-form-urlencoded").build();
        Response response = client.newCall(request).execute();
        System.out.println("+++++++++++++ response : " + response);
        if (response.code() == 200) {
            JSONObject jsonResponse = new JSONObject(response.body().string());
            System.out.println("jsonResponse : " + jsonResponse);
            if (!jsonResponse.isNull("access_token")) {
                String access_token = jsonResponse.getString("access_token");
                System.out.println("++++++++++ access_token : " + access_token);
                token = access_token;
            }
        }
        return token;
    }

    private void sendCurrentMenu(final String eventIdValue) {
        if (this.store_id != null && !this.store_id.isEmpty()) {
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    List<CategoryInfo> categories = OtterService.this.mItemService.getCategories();
                    List<SupplementInfo> groupsOptions = OtterService.this.mItemService.getGroupsOptions();
                    if (categories != null && groupsOptions != null) {
                        try {
                            MenuOtterBuilder menu = new MenuOtterBuilder().categories(categories).groupsOptions(groupsOptions).sentEvent(true).build();
                            JSONObject jsonMenu = menu.getMenuObject();
                            JSONObject menuDataObject = new JSONObject();
                            menuDataObject.put("menuData", (Object)jsonMenu);
                            System.out.println("+++++++++ jsonMenu : " + jsonMenu);
                            OtterService.this.sendCurrentMenu(menuDataObject, eventIdValue, 0);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(OtterService.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            });
        }
    }

    private void sendCurrentMenu(JSONObject jsonMenu, String eventIdValue, int number_try) throws IOException {
        if (this.token == null || this.token.isEmpty()) {
            this.setToken();
        }
        System.out.println("++++ token : " + this.token);
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)jsonMenu.toString());
        Request request = new Request.Builder().url(this.URL + "/v1/menus/current").method("POST", body).addHeader("X-Application-Id", this.client_id).addHeader("X-Store-Id", this.store_id).addHeader("X-Event-Id", eventIdValue).addHeader("Authorization", "Bearer " + this.token).addHeader("Content-Type", "application/json").build();
        Response response = client.newCall(request).execute();
        System.out.println("+++++++ response sendCurrentMenu: " + response);
        if (response.code() == 401 && number_try < 1) {
            response.close();
            this.setToken();
            this.sendCurrentMenu(jsonMenu, eventIdValue, 1);
        } else {
            response.close();
        }
    }

    public void sentInfoOrders(int number_orders, JSONObject order) {
        Object[] info_orders = new Object[2];
        info_orders[1] = number_orders;
        info_orders[0] = order;
        this.support.firePropertyChange("otter_orders", null, info_orders);
    }

    public JSONArray getOrders() {
        if (this.store_id != null && !this.store_id.isEmpty()) {
            try {
                JSONObject data;
                if (this.token == null || this.token.isEmpty()) {
                    this.setToken();
                }
                Date dateStart = new Date();
                Date dateEnd = new Date();
                DateUtils.setDateHours(dateStart, dateEnd);
                String text_dateStart = DateUtils.FORMATTER_DATE_TIME_ZONE_SSS.format(dateStart);
                String text_dateEnd = DateUtils.FORMATTER_DATE_TIME_ZONE_SSS.format(dateEnd);
                String url_get_orders = this.URL + "/manager/order/v1/orders?limit=1000&minDateTime=" + text_dateStart + "&maxDateTime=" + text_dateEnd;
                System.out.println("++++++++++++ url_get_orders : " + url_get_orders);
                OkHttpClient client = new OkHttpClient().newBuilder().build();
                Request request = new Request.Builder().url(url_get_orders).method("GET", null).addHeader("X-Application-Id", this.client_id).addHeader("X-Store-Id", this.store_id).addHeader("Authorization", "Bearer " + this.token).build();
                Response response = client.newCall(request).execute();
                System.out.println("response : " + response);
                if (response.code() == 200 && !(data = new JSONObject(response.body().string())).isNull("orders")) {
                    JSONArray jSONArray = data.getJSONArray("orders");
                }
            }
            catch (IOException ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return null;
    }

    public int getNumberOrdersActive() {
        JSONArray orders_array = this.getOrders();
        if (orders_array != null) {
            return orders_array.length();
        }
        return 0;
    }

    public LinkedHashMap<String, TicketInfo> getOrdersDetail() {
        LinkedHashMap<String, TicketInfo> orders = new LinkedHashMap<String, TicketInfo>();
        try {
            JSONArray orders_array = this.getOrders();
            if (orders_array != null) {
                for (int i = 0; i < orders_array.length(); ++i) {
                    JSONObject ordrJson = orders_array.getJSONObject(i);
                    TicketInfo mTicketInfo = TicketInfoBuilder.create(null).objectOrder(ordrJson).buildOtterOrder().toTicketInfo();
                    if (mTicketInfo == null) continue;
                    String order_id = mTicketInfo.getId_online_order();
                    orders.put(order_id, mTicketInfo);
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return orders;
    }

    public void changeStatus(String id_order, String status, String platform_source) {
        try {
            String url_change_status = this.URL + "/manager/order/v1/sources/" + platform_source + "/orders/" + id_order + "/" + status;
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            MediaType mediaType = MediaType.parse((String)"text/plain");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)"");
            Request request = new Request.Builder().url(url_change_status).method("POST", body).addHeader("X-Application-Id", this.client_id).addHeader("X-Store-Id", this.store_id).addHeader("Authorization", "Bearer " + this.token).build();
            Response response = client.newCall(request).execute();
            System.out.println("+++++++++++ response changeStatus : " + response);
        }
        catch (IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void encaisserOrder(TicketInfo ticket) {
        if (this.mTicketService == null) {
            this.mTicketService = TicketService.getInstance();
        }
        this.mTicketService.orderAttente(false, ticket, false, true, true, false, true, true);
    }

    private void validOrder(JSONObject order) {
        TicketInfo mTicketInfo = TicketInfoBuilder.create(null).objectOrder(order).buildOtterOrder().toTicketInfo();
        if (mTicketInfo != null) {
            this.encaisserOrder(mTicketInfo);
        }
    }

    private void cancelOrder(JSONObject json_event) {
        JSONObject metadateObject;
        if (!json_event.isNull("metadata") && (metadateObject = json_event.getJSONObject("metadata")) != null && !metadateObject.isNull("payload")) {
            JSONObject externalIdentifierObject;
            JSONObject payloadObject = metadateObject.getJSONObject("payload");
            String id_order = null;
            String cancel_reason = null;
            if (!payloadObject.isNull("externalIdentifiers") && !(externalIdentifierObject = payloadObject.getJSONObject("externalIdentifiers")).isNull("id")) {
                id_order = externalIdentifierObject.getString("id");
            }
            if (!payloadObject.isNull("cancellationReason")) {
                cancel_reason = payloadObject.getString("cancellationReason");
            }
            if (id_order != null) {
                if (this.mTicketService == null) {
                    this.mTicketService = TicketService.getInstance();
                }
                this.mTicketService.cancelOrderOtter(id_order, cancel_reason);
            }
        }
    }

    public void delete() {
        this.mOtterInfoDao.delete();
    }
}

