/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.service;

import com.biborne.sms.SmsService;
import com.openbravo.basic.BasicException;
import com.openbravo.basic.BasicStorage;
import com.openbravo.beans.DateUtils;
import com.openbravo.beans.OrderOnLine;
import com.openbravo.components.PopUpNotification;
import com.openbravo.components.PopUpOnlineOrderNotification;
import com.openbravo.dao.DataLogicOrder;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.sales.JPanelOrderSuivi;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketInfoBuilder;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.GagSSL;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.TicketService;
import com.procaisse.notifications.OnLineOrderDialogue;
import com.procaisse.okhttp.OkHttpCommandeService;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.emitter.Emitter;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javax.swing.JFrame;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.simple.JSONObject;

public class OrderOnLineService {
    private String adresseServer = "http://backoffice.pro-tactile.com/api/order-filter";
    private String resourceUrl = "http://backoffice.pro-tactile.com/api/order-filter";
    private String id;
    private AppView app;
    private Scene scene;
    private ScheduledExecutorService scheduler;
    private PopUpNotification m_PopUpNotification;
    private static Date dateLivraison;
    private static OrderOnLineService m_instance;
    private Date dateStart;
    private Date dateEnd;
    private PropertyChangeSupport support;
    private PopUpOnlineOrderNotification m_PopUpOnlineOrderNotification;
    private SmsService mSmsService;
    private String ONLINE_PAYMENT = "En ligne";
    private String DELIVERY = "En Livraison";
    private final SimpleDateFormat timeFormatter = com.openbravo.pos.util.DateUtils.timeFormatter;
    private TicketService mTicketService;
    private final String URL_OPEN_SITE = "https://api-backoffice.biborne.com/api/restos/clickcollectopen/";
    private final String URL_EDIT_STATUS = "https://api-backoffice.biborne.com/api/restos/clickcollectstatus/";
    private final String CLICK_COLLECT_OPEN = "clickcollect";
    boolean isopen_value;
    private String CLICKCOLLECT = "clickcollect";
    private final String URL_ORDERS_TYPES = "https://json.biborne.com/api/v1/restos/TypesCommande/";
    private final String URL_EDIT_ORDERS_TYPES = "https://json.biborne.com/api/v1/restos/updateobjetbysiret/";

    public static OrderOnLineService getInstance(Scene scene) {
        if (m_instance == null) {
            m_instance = new OrderOnLineService(scene);
        }
        return m_instance;
    }

    private OrderOnLineService(Scene scene) {
        this.app = (AppView)BasicStorage.getObject("APP_ROOT_INSTANCE");
        this.scheduler = Executors.newScheduledThreadPool(1);
        dateLivraison = new Date();
        this.support = new PropertyChangeSupport(this);
        if (!AppLocal.SUIVI_ONLINE_ORDER) {
            this.id = AppLocal.ID_ONLINE_SERVER;
            this.scene = scene;
            if (scene != null) {
                this.initPopUpNotification(scene);
            }
        }
        this.mTicketService = TicketService.getInstance();
    }

    public OrderOnLineService(String id) {
        this.id = id;
        this.app = (AppView)BasicStorage.getObject("APP_ROOT_INSTANCE");
        dateLivraison = new Date();
    }

    public void updateUnsynchronizedOrders(Date d) throws JSONException {
        dateLivraison = d;
        this.updateUnsynchronizedOrders();
    }

    public void updateUnsynchronizedOrders() throws JSONException {
        HashMap<String, Object> json = new HashMap<String, Object>();
        String js = "{\"restaurant_id\":" + Integer.valueOf(this.id) + ",\"delivery_date\":\"" + com.openbravo.pos.util.DateUtils.formatterDayMonthYear.format(dateLivraison) + "\"}";
        json.put("restaurant_id", Integer.valueOf(this.id));
        json.put("delivery_date", com.openbravo.pos.util.DateUtils.formatterDayMonthYear.format(dateLivraison));
        org.json.JSONObject jsn = this.postToServer(js);
        if (jsn.get("message").toString().equalsIgnoreCase("ok")) {
            if (!jsn.isNull("data")) {
                JSONArray jsonOrders = jsn.getJSONArray("data");
                for (int i = 0; i < jsonOrders.length(); ++i) {
                    org.json.JSONObject order = jsonOrders.getJSONObject(i);
                    OrderOnLine orderOnLine = new OrderOnLine(order);
                    if (AppVarUtils.QUEUED_ONLINE_ORDERS == null) {
                        AppVarUtils.QUEUED_ONLINE_ORDERS = new HashMap<String, OrderOnLine>();
                    }
                    if (!AppVarUtils.QUEUED_ONLINE_ORDERS.containsKey("" + orderOnLine.getId())) {
                        ++AppVarUtils.QUEUED_ONLINE_ORDERS_COUNT;
                    }
                    AppVarUtils.QUEUED_ONLINE_ORDERS.putIfAbsent("" + orderOnLine.getId(), orderOnLine);
                }
            } else {
                AppVarUtils.QUEUED_ONLINE_ORDERS = new HashMap<String, OrderOnLine>();
                AppVarUtils.QUEUED_ONLINE_ORDERS_COUNT = 0;
            }
        }
        if (AppVarUtils.QUEUED_ONLINE_ORDERS_COUNT > 0 && AppVarUtils.QUEUED_ONLINE_ORDERS.size() != AppVarUtils.QUEUED_ONLINE_ORDERS_TODAY.size()) {
            this.alert(AppVarUtils.QUEUED_ONLINE_ORDERS_COUNT, null);
        } else {
            AppVarUtils.QUEUED_ONLINE_ORDERS_COUNT = 0;
        }
    }

    public org.json.JSONObject postToServer(String json) throws JSONException {
        OkHttpClient client = GagSSL.getUnsafeOkHttpClient();
        org.json.JSONObject jsn = null;
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)json);
        Request request = new Request.Builder().url(this.resourceUrl).post(requestBody).build();
        try (Response response = client.newCall(request).execute();){
            int httpResponseCode = response.code();
            String body = response.body().string();
            jsn = new org.json.JSONObject(body);
        }
        catch (IOException ex) {
            LogToFile.log("severe", null, ex);
        }
        return jsn;
    }

    public static Date getDateLivraison() {
        return dateLivraison;
    }

    public static void setDateLivraison(Date dateLivraison) {
        OrderOnLineService.dateLivraison = dateLivraison;
    }

    public void alert(final int number_order, Component parent) {
        if (this.scene != null) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (AppLocal.SUIVI_ONLINE_ORDER || AppVarUtils.QUEUED_ONLINE_ORDERS_COUNT > 0) {
                        OrderOnLineService.this.m_PopUpNotification.show(number_order);
                    }
                }
            });
        } else if (parent != null) {
            this.initPopUpNotificationSwing(parent, number_order);
        }
    }

    public List<TicketInfo> getOrders(Date dateStart, Date dateEnd) throws JSONException {
        return this.getOrders(dateStart, dateEnd, false);
    }

    public List<TicketInfo> getOrders(Date dateStart, Date dateEnd, boolean new_orders) throws JSONException {
        List<TicketInfo> orders = new ArrayList<TicketInfo>();
        JSONArray jsonOrders = this.getArrayOrders(dateStart, dateEnd, new_orders);
        if (jsonOrders != null) {
            orders = TicketInfoBuilder.create(null).toTickets(jsonOrders, dateStart, dateEnd, new_orders);
        }
        return orders;
    }

    public boolean setIdOrderLocal(String id_order, String id_commande_local) throws JSONException {
        if (AppLocal.ONLINE_ORDER_HOST_NAME != null && !AppLocal.ONLINE_ORDER_HOST_NAME.isEmpty()) {
            try {
                System.out.println("+++++++++++++++ setIdOrderLocal date start : " + new Date());
                OkHttpCommandeService okHttpCommandeService = new OkHttpCommandeService();
                JSONObject jsonRoot = new JSONObject();
                jsonRoot.put((Object)"id_commande_local", (Object)id_commande_local);
                String url = AppLocal.ONLINE_ORDER_HOST_NAME + "/ordersChangeIdLocal/" + id_order;
                Response reponse = okHttpCommandeService.okHttpCommand("put", url, jsonRoot.toString());
                if (reponse.code() == 200) {
                    System.out.println("+++++++++++++++ setIdOrderLocal date end : " + new Date());
                    return true;
                }
            }
            catch (Exception ex) {
                Logger.getLogger(OrderOnLineService.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    public Scene getScene() {
        return this.scene;
    }

    public void initPopUpNotification(final Scene scene) {
        this.scene = scene;
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                OrderOnLineService.this.m_PopUpNotification = new PopUpNotification(scene, new Stage(), (DataLogicOrder)OrderOnLineService.this.app.getBean("com.openbravo.dao.DataLogicOrder"));
                OrderOnLineService.this.m_PopUpNotification.setmAppView(OrderOnLineService.this.app);
                try {
                    OrderOnLineService.this.m_PopUpNotification.init();
                }
                catch (IOException ex) {
                    Logger.getLogger(OrderOnLineService.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    private void initPopUpNotificationSwing(Component parent, int number_order) {
        System.out.println("m_PopUpOnlineOrderNotification : " + this.m_PopUpOnlineOrderNotification);
        this.m_PopUpOnlineOrderNotification = new PopUpOnlineOrderNotification(parent, number_order);
    }

    public void connect() throws URISyntaxException {
        if (AppLocal.ONLINE_ORDER_HOST_NAME != null && !AppLocal.ONLINE_ORDER_HOST_NAME.isEmpty() && AppLocal.ID_SITE_ORDERS != null && !AppLocal.ID_SITE_ORDERS.isEmpty()) {
            Socket socket = IO.socket((String)AppLocal.ONLINE_ORDER_HOST_NAME);
            String procaisse_licence_id = AppLocal.ID_SITE_ORDERS;
            System.out.println("+++++++++ procaisse_licence_id : " + procaisse_licence_id);
            socket.connect();
            socket.on("NEW MESSAGE", new Emitter.Listener(){

                public void call(Object ... args) {
                    String message = (String)args[0];
                    System.out.println("NEW MESSAGE" + message);
                }
            });
            socket.on(procaisse_licence_id, new Emitter.Listener(){

                public void call(Object ... args) {
                    String message = (String)args[0];
                    System.out.println(message + " / actualiser liste commande");
                    List<TicketInfo> sentTickets = OrderOnLineService.this.getSentOrders();
                    OrderOnLineService.this.sentInfoOrders(true, sentTickets);
                }
            });
        }
    }

    public void setTime(Date date) {
        Calendar calStart = Calendar.getInstance();
        calStart.setTime(date);
        calStart.add(11, AppLocal.dateStart);
        calStart.getTime();
        this.dateStart = calStart.getTime();
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(date);
        if (AppLocal.dateStart >= AppLocal.dateEnd) {
            calEnd.add(11, AppLocal.dateEnd + 24);
        } else {
            calEnd.add(11, AppLocal.dateEnd);
        }
        calEnd.getTime();
        this.dateEnd = calEnd.getTime();
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.support.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.support.removePropertyChangeListener(pcl);
    }

    public int getNumberOrders() {
        if (this.dateStart == null || this.dateEnd == null) {
            Calendar calToday = Calendar.getInstance();
            Date date_created_order = DateUtils.getToday();
            if (calToday.getTime().getHours() >= 0 && calToday.getTime().getHours() <= AppLocal.dateEnd) {
                calToday.setTime(date_created_order);
                calToday.add(6, -1);
                date_created_order = calToday.getTime();
            }
            this.setTime(date_created_order);
        }
        int number_commandes = 0;
        JSONArray jsonOrders = this.getArrayOrders(this.dateStart, this.dateEnd, true);
        if (jsonOrders != null) {
            for (int i = 0; i < jsonOrders.length(); ++i) {
                String status;
                org.json.JSONObject order = jsonOrders.getJSONObject(i);
                String string = status = order.isNull("status") ? "" : order.getString("status");
                if (!status.equals("sent")) continue;
                ++number_commandes;
            }
        }
        return number_commandes;
    }

    private void sentInfoOrders(boolean show_popUp, final List<TicketInfo> tickets) {
        if (AppLocal.AUTO_ACCEPT_ONLINE_ORDER || AppLocal.AUTO_ACCEPT_ONLINE_ORDER_NOT_PAID) {
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    boolean acceptOrder = false;
                    for (TicketInfo ticket : tickets) {
                        boolean onlinePayment;
                        if (ticket == null) continue;
                        boolean bl = onlinePayment = ticket.getModePayment() != null && ticket.getModePayment().equalsIgnoreCase(OrderOnLineService.this.ONLINE_PAYMENT);
                        if (onlinePayment) {
                            if (!AppLocal.AUTO_ACCEPT_ONLINE_ORDER) continue;
                            acceptOrder = true;
                            OrderOnLineService.this.mTicketService.acceptOnLineOrder(ticket, true);
                            continue;
                        }
                        if (!AppLocal.AUTO_ACCEPT_ONLINE_ORDER_NOT_PAID) continue;
                        acceptOrder = true;
                        OrderOnLineService.this.mTicketService.acceptOnLineOrder(ticket, false);
                    }
                    if (acceptOrder) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                JPanelOrderSuivi suiviOrderPanel;
                                AppView m_appview = (AppView)BasicStorage.getObject("APP_ROOT_INSTANCE");
                                if (m_appview.getAppUserView() != null && (suiviOrderPanel = (JPanelOrderSuivi)m_appview.getAppUserView().getPanelView("com.openbravo.pos.sales.JPanelOrderSuivi")) != null) {
                                    suiviOrderPanel.loadOrdersOnline();
                                }
                            }
                        });
                    }
                }
            });
        }
        this.sentInfoOrders(show_popUp, tickets.size());
    }

    public void goToPanelOrders() {
        if (AppLocal.user != null) {
            if (AppLocal.SUIVI_ONLINE_ORDER) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        JPanelOrderSuivi suiviOrderPanel;
                        AppView m_appview = (AppView)BasicStorage.getObject("APP_ROOT_INSTANCE");
                        if (AppLocal.view_current == null || !AppLocal.view_current.equals("com.openbravo.pos.sales.JPanelOrderSuivi")) {
                            m_appview.getAppUserView().showTask("com.openbravo.pos.sales.JPanelOrderSuivi");
                            AppLocal.view_back = "com.openbravo.pos.sales.JCaissePanel";
                            AppLocal.view_current = "com.openbravo.pos.sales.JPanelOrderSuivi";
                        }
                        if ((suiviOrderPanel = (JPanelOrderSuivi)m_appview.getAppUserView().getPanelView("com.openbravo.pos.sales.JPanelOrderSuivi")) != null) {
                            suiviOrderPanel.loadOrdersOnline();
                        }
                    }
                });
            } else {
                Executors.newSingleThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AppVarUtils.QUEUED_ONLINE_ORDERS_COUNT = 0;
                            OnLineOrderDialogue.showMessage(new JFrame(), OrderOnLineService.this.app);
                        }
                        catch (BasicException | IOException ex) {
                            LogToFile.log("severe", ex.getMessage(), ex);
                        }
                    }
                });
            }
        }
    }

    public JSONArray getArrayOrders(Date dateStart, Date dateEnd, boolean new_orders) throws JSONException {
        if (AppLocal.ONLINE_ORDER_HOST_NAME != null && !AppLocal.ONLINE_ORDER_HOST_NAME.isEmpty() && AppLocal.ID_SITE_ORDERS != null && !AppLocal.ID_SITE_ORDERS.isEmpty()) {
            try {
                String response_orders;
                org.json.JSONObject jsn;
                System.out.println("+++++++++++ start : " + new Date());
                OkHttpClient client = new OkHttpClient.Builder().readTimeout(1L, TimeUnit.MINUTES).build();
                String text_dateStart = com.openbravo.pos.util.DateUtils.FORMATTER_DATE_TIME_ZONE_SSS.format(dateStart);
                String text_dateEnd = com.openbravo.pos.util.DateUtils.FORMATTER_DATE_TIME_ZONE_SSS.format(dateEnd);
                String resourceUrl = AppLocal.ONLINE_ORDER_HOST_NAME + "/ordersByLicenceAndDayClickv3/" + AppLocal.ID_SITE_ORDERS + "&" + text_dateStart + "&" + text_dateEnd;
                System.out.println("+++++++++++ resourceUrl : " + resourceUrl);
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)"");
                Request request = new Request.Builder().url(resourceUrl).post(requestBody).build();
                Response response = client.newCall(request).execute();
                System.out.println("+++++++++++ end : " + new Date());
                if (response.code() == 200 && (jsn = new org.json.JSONObject(response_orders = response.body().string())).get("message").toString().equalsIgnoreCase("ok") && !jsn.isNull("data")) {
                    JSONArray jsonOrders = jsn.getJSONArray("data");
                    return jsonOrders;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Erreur de connexion.", 1500, NPosition.CENTER);
            }
        }
        return null;
    }

    public void sendSmsToCustomer(String status, TicketInfo ticket) {
        if (AppLocal.SEND_SMS && ticket.getCustomerPhone() != null && !ticket.getCustomerPhone().isEmpty() && status != null && !status.equalsIgnoreCase("paid")) {
            Executors.newSingleThreadExecutor().execute(() -> {
                Object message = "";
                switch (status) {
                    case "pending": {
                        message = (String)message + "Merci pour votre commande N " + ticket.getNumero_online_order();
                        if (AppLocal.RESTAURANT_NAME != null && !AppLocal.RESTAURANT_NAME.isEmpty()) {
                            message = (String)message + " chez " + AppLocal.RESTAURANT_NAME;
                        }
                        message = ticket.isDelayed() ? (ticket.getType() != null && ticket.getType().equalsIgnoreCase(this.DELIVERY) ? (String)message + ". Vous serez livres au plus tard a " + this.timeFormatter.format(ticket.getDelivered()) : (String)message + ". Celle-ci sera prete a " + this.timeFormatter.format(ticket.getDelivered())) : (ticket.getType() != null && ticket.getType().equalsIgnoreCase(this.DELIVERY) ? (String)message + ". Celle-ci sera livree a " + this.timeFormatter.format(ticket.getDelivered()) : (String)message + ". Celle-ci sera prete pour " + this.timeFormatter.format(ticket.getDelivered()));
                        message = (String)message + ".";
                        break;
                    }
                    case "reject": {
                        message = (String)message + "Nous sommes desoles, votre commande N " + ticket.getNumero_online_order() + " a ete refuse ";
                        if (ticket.getReason_cancel() != null && !ticket.getReason_cancel().isEmpty()) {
                            message = (String)message + " en raison de " + ticket.getReason_cancel();
                        }
                        if (ticket.getModePayment() != null && ticket.getModePayment().equalsIgnoreCase(this.ONLINE_PAYMENT)) {
                            message = (String)message + ". Un remboursement aura lieu sous 48h";
                        }
                        message = (String)message + ".";
                        break;
                    }
                    case "cancel": {
                        message = (String)message + "Nous sommes desoles, votre commande N " + ticket.getNumero_online_order() + " a ete annule";
                        if (ticket.getReason_cancel() != null && !ticket.getReason_cancel().isEmpty()) {
                            message = (String)message + " en raison de " + ticket.getReason_cancel();
                        }
                        if (ticket.getModePayment() != null && ticket.getModePayment().equalsIgnoreCase(this.ONLINE_PAYMENT)) {
                            message = (String)message + ". Un remboursement aura lieu sous 48h";
                        }
                        message = (String)message + ".";
                        break;
                    }
                    case "ready": {
                        message = ticket.getType() != null && ticket.getType().equalsIgnoreCase(this.DELIVERY) ? (String)message + "Votre commande N " + ticket.getNumero_online_order() + " a ete prise en charge par un livreur." : (String)message + "Votre commande N " + ticket.getNumero_online_order() + " est prete a etre recuperee.";
                    }
                }
                if (this.mSmsService == null) {
                    this.mSmsService = SmsService.getInstance();
                }
                this.mSmsService.sendSMS(ticket.getCustomerPhone(), (String)message);
            });
        }
    }

    public List<TicketInfo> getSentOrders() {
        JSONArray jsonOrders;
        ArrayList<TicketInfo> orders = new ArrayList<TicketInfo>();
        if (this.dateStart == null || this.dateEnd == null) {
            Calendar calToday = Calendar.getInstance();
            Date date_created_order = DateUtils.getToday();
            if (calToday.getTime().getHours() >= 0 && calToday.getTime().getHours() <= AppLocal.dateEnd) {
                calToday.setTime(date_created_order);
                calToday.add(6, -1);
                date_created_order = calToday.getTime();
            }
            this.setTime(date_created_order);
        }
        if ((jsonOrders = this.getArrayOrders(this.dateStart, this.dateEnd, true)) != null) {
            for (int i = 0; i < jsonOrders.length(); ++i) {
                String status;
                org.json.JSONObject order = jsonOrders.getJSONObject(i);
                String string = status = order.isNull("status") ? "" : order.getString("status");
                if (!status.equals("sent")) continue;
                TicketInfo ticket = TicketInfoBuilder.create(null).toTicketInfo(order, this.dateStart, this.dateEnd, false);
                orders.add(ticket);
            }
        }
        return orders;
    }

    private void sentInfoOrders(boolean show_popUp, int number_orders) {
        Object[] info_orders = new Object[2];
        info_orders[1] = number_orders;
        info_orders[0] = show_popUp;
        this.support.firePropertyChange("orders", null, info_orders);
    }

    public boolean changeStatusOrder(TicketInfo ticket, String status) throws JSONException {
        boolean result = false;
        if (AppLocal.ONLINE_ORDER_HOST_NAME != null && !AppLocal.ONLINE_ORDER_HOST_NAME.isEmpty()) {
            try {
                OkHttpCommandeService okHttpCommandeService = new OkHttpCommandeService();
                dateLivraison = new Date();
                JSONObject jsonRoot = new JSONObject();
                jsonRoot.put((Object)"status", (Object)status);
                String text_isFranchise = AppLocal.CLICK_COLLECT_V3 ? "true" : "false";
                String url = AppLocal.ONLINE_ORDER_HOST_NAME + "/clickv3/ordersChangeStatus/" + ticket.getId_online_order() + "&" + text_isFranchise;
                Response reponse = okHttpCommandeService.okHttpCommand("put", url, jsonRoot.toString());
                if (reponse.code() == 200) {
                    result = true;
                    this.sendSmsToCustomer(status, ticket);
                    int number_orders = this.getNumberOrders();
                    this.sentInfoOrders(false, number_orders);
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return result;
    }

    public boolean getStatusClickandCollect() {
        try {
            MarqueNFC marqueNF = MarqueNFC.fetchOrStore(AppLocal.dlSales);
            System.out.println("+++++++++ marqueNF : " + marqueNF);
            if (marqueNF != null) {
                System.out.println("++++++++++++ marqueNF.getSiret() : " + marqueNF.getSiret());
                if (marqueNF.getSiret() != null && !marqueNF.getSiret().isEmpty()) {
                    String url = "https://api-backoffice.biborne.com/api/restos/clickcollectopen/" + marqueNF.getSiret();
                    OkHttpClient client = new OkHttpClient().newBuilder().build();
                    Request request = new Request.Builder().url(url).method("GET", null).build();
                    Response response = client.newCall(request).execute();
                    String response_clickandcollect = response.body().string();
                    System.out.println("++++++++++++++++ responseCode  GET STATUS CLICKCOLLECT " + response.code());
                    if (response.code() == 200 && response_clickandcollect != null && !response_clickandcollect.trim().isEmpty()) {
                        org.json.JSONObject jsonResponse = new org.json.JSONObject(response_clickandcollect);
                        this.isopen_value = !jsonResponse.isNull("clickcollect") ? jsonResponse.getBoolean("clickcollect") : false;
                    }
                }
            }
        }
        catch (Exception e) {
            LogToFile.log("severe", e.getMessage(), e);
        }
        return this.isopen_value;
    }

    public boolean closeStatusClickandCollect(boolean value) {
        try {
            MarqueNFC marqueNF = MarqueNFC.fetchOrStore(AppLocal.dlSales);
            if (marqueNF != null) {
                OkHttpClient client = new OkHttpClient().newBuilder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
                org.json.JSONObject jsonRoot = new org.json.JSONObject();
                jsonRoot.put(this.CLICKCOLLECT, value);
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonRoot.toString());
                Request request = new Request.Builder().url("https://api-backoffice.biborne.com/api/restos/clickcollectstatus/" + marqueNF.getSiret()).method("PUT", requestBody).addHeader("Content-Type", "application/json").build();
                Response response = client.newCall(request).execute();
                System.out.println("+++++++ activete Click&Collect Code: " + response.code());
                return response.code() == 200;
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return false;
    }

    public org.json.JSONObject getOrdersTypes() {
        try {
            MarqueNFC marqueNF = MarqueNFC.fetchOrStore(AppLocal.dlSales);
            System.out.println("+++++++++ marqueNF : " + marqueNF);
            if (marqueNF != null) {
                System.out.println("++++++++++++ marqueNF.getSiret() : " + marqueNF.getSiret());
                if (marqueNF.getSiret() != null && !marqueNF.getSiret().isEmpty()) {
                    String url = "https://json.biborne.com/api/v1/restos/TypesCommande/" + marqueNF.getSiret();
                    OkHttpClient client = new OkHttpClient().newBuilder().build();
                    Request request = new Request.Builder().url(url).method("GET", null).build();
                    Response response = client.newCall(request).execute();
                    String response_body = response.body().string();
                    System.out.println("++++++++++++++++ responseCode  GET STATUS CLICKCOLLECT " + response.code());
                    if (response.code() == 200 && response_body != null && !response_body.trim().isEmpty()) {
                        org.json.JSONObject jsonResponse = new org.json.JSONObject(response_body);
                        return jsonResponse;
                    }
                }
            }
        }
        catch (Exception e) {
            LogToFile.log("severe", e.getMessage(), e);
        }
        return null;
    }

    public void setOrdersTypes(boolean atSpot, boolean takeAway, boolean delivery) {
        try {
            MarqueNFC marqueNF = MarqueNFC.fetchOrStore(AppLocal.dlSales);
            if (marqueNF != null) {
                OkHttpClient client = new OkHttpClient().newBuilder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
                org.json.JSONObject jsonRoot = new org.json.JSONObject();
                jsonRoot.put("at_spot", atSpot);
                jsonRoot.put("take_away", takeAway);
                jsonRoot.put("delivery", delivery);
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonRoot.toString());
                Request request = new Request.Builder().url("https://json.biborne.com/api/v1/restos/updateobjetbysiret/" + marqueNF.getSiret()).method("PUT", requestBody).addHeader("Content-Type", "application/json").build();
                Response response = client.newCall(request).execute();
                System.out.println("+++++++ setOrdersTypes Code: " + response.code());
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }
}

