/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.service;

import com.openbravo.pos.forms.AppLocal;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.emitter.Emitter;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class NotificationClientService {
    private static NotificationClientService m_instance;
    public Socket socket;
    private final String EVENT_NOTIFICATION_UPDATE = "notification_order_update";
    private final String STE_STATE_ORDER = "state_order";
    private final String STR_DIFF_TIME_IN_SECOND = "diff_time_in_second";
    private final String STR_ID_SHARED_ORDER = "id_shared_order";
    private final String NEW_ORDER = "new order";
    private final String PAID_ORDER = "paid order";
    private final String EVENT_NOTIFICATION = "notification_order";
    private PropertyChangeSupport support;

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.support.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.support.removePropertyChangeListener(pcl);
    }

    private NotificationClientService() {
        try {
            this.support = new PropertyChangeSupport(this);
            String userID = AppLocal.token != null && !AppLocal.token.isEmpty() ? "?userId=" + AppLocal.token : "";
            System.out.println("+++++++ userID : " + userID);
            String url_socket = "http://" + AppLocal.HOSTNAME_DB + ":6677" + userID;
            this.socket = IO.socket((String)url_socket);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(NotificationClientService.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static NotificationClientService getInstance() {
        if (m_instance == null) {
            m_instance = new NotificationClientService();
        }
        return m_instance;
    }

    public void connect() {
        System.out.println("++++++++++ socket : " + this.socket);
        if (this.socket != null) {
            this.socket.on("CONNECTION", new Emitter.Listener(){

                public void call(Object ... args) {
                    System.out.println("+++++++++++ server connect+++++++++++++++++++++++++");
                    String message = (String)args[0];
                    System.out.println(message);
                }
            });
            this.socket.on("notification_order", new Emitter.Listener(){

                public void call(Object ... args) {
                    System.out.println("+++++++++++ args : " + args[0]);
                    NotificationClientService.this.sendNotificationToService((String)args[0]);
                }
            });
            this.socket.connect();
        }
    }

    public void sendNotification(int seconds) {
        if (this.socket != null) {
            JSONObject jsonData = new JSONObject();
            jsonData.put("state_order", (Object)"new order");
            jsonData.put("diff_time_in_second", seconds);
            this.socket.emit("notification_order_update", new Object[]{jsonData.toString()});
        }
    }

    public void stop() {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public void sendPaidOrderNotification(int id_order) {
        if (this.socket != null) {
            JSONObject jsonData = new JSONObject();
            jsonData.put("state_order", (Object)"paid order");
            jsonData.put("id_shared_order", id_order);
            this.socket.emit("notification_order_update", new Object[]{jsonData.toString()});
        }
    }

    public void sendNotificationToService(String data) {
        String state_order;
        JSONObject jsonData = new JSONObject(data);
        String string = state_order = jsonData.isNull("state_order") ? "paid order" : jsonData.getString("state_order");
        if (state_order != null && state_order.equalsIgnoreCase("paid order") && !jsonData.isNull("id_shared_order")) {
            Object[] data_order = new Object[2];
            data_order[1] = state_order;
            data_order[0] = jsonData.isNull("id_shared_order") ? 0 : jsonData.getInt("id_shared_order");
            System.out.println("++++++++++ data_order[0] : " + data_order[0]);
            this.support.firePropertyChange("update_orders", null, data_order);
        }
    }
}

