/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.service;

import com.openbravo.basic.BasicException;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.CustomerLoyalty;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.LogToFile;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;

public class LoyaltyService {
    private static LoyaltyService m_instance;
    private String API_KEY = "cee340aa55e074c65a53b1f91788d287e2e6c058";
    private final String CAGNOTE = "cagnote";
    private final String PHONE = "phone";
    private final String FRANCHISE_UUID = "franchise_uuid";
    private final String SIRET = "siret";
    private final String FIRST_NAME = "first_name";
    private final String LAST_NAME = "last_name";
    private final String EMAIL = "email";
    private final String ACTIF = "active";
    private final String BIRTHDATE = "birthdate";
    private final String GENDER = "gender";
    private final String AMOUNT = "amount";
    private final String VALUE_IN = "value_in";
    private final String VALUE_OUT = "value_out";
    private final String ORDER_ID = "order_id";
    private final String KEENIO = "keenio";
    private final String IS_VALIDATE = "validate";
    private final String URL_SAVE_CAGNOTE = "http://217.69.13.134:8080/api/saveLoyaltyUserCagnoteNew";
    private final String URL_GET_CAGNOTE_PG = "https://json.biborne.com/api/v1/Customer_fidelite/GetCagnoteByLoyaltyUserPg/";
    private final String URL_SAVE_CUSTOMER_PG = "https://json.biborne.com/api/v1/Customer_fidelite/SaveLoyaltyUserPg";
    private final String URL_ACTIVATE_CUSTOMER_PG = "https://json.biborne.com/api/v1/Customer_fidelite/ActivateLoyaltyUserPg";
    private final String URL_SAVE_TRANSACTION_PG = "https://json.biborne.com/api/v1/transaction_fidelite/SaveLoyaltyTransactionPg";
    private final String URL_VALID_TRANSACTION = "https://json.biborne.com/api/v1/transaction_fidelite/validateTransactions/";
    private final String customer_loyalty_id = AppLocal.CUSTOMER_LOYALTY_ID;
    private String SIRET_VAL = "";
    private final String URL_GET_USER = "http://217.69.13.134:8080/api/getLoyaltyUserNew";
    private final String URL_DELETE_TRANSACTION = "https://json.biborne.com/api/v1/transaction_fidelite/deleteAfterCanceled/";
    private final String MESSAGE_CUSTOMER_NOT_EXIST = "Donn\u00e9es de fid\u00e9lit\u00e9 du client non trouv\u00e9es";
    private final String MESSAGE = "message";

    private LoyaltyService() {
        if (AppLocal.dlSales != null) {
            try {
                MarqueNFC marqueNF = MarqueNFC.fetchOrStore(AppLocal.dlSales);
                if (marqueNF != null) {
                    this.SIRET_VAL = marqueNF.getSiret();
                }
            }
            catch (BasicException ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public static LoyaltyService getInstance() {
        if (m_instance == null) {
            m_instance = new LoyaltyService();
        }
        return m_instance;
    }

    public CustomerLoyalty getCagnoteByLoyaltyUser(String phone, String customer_loyalty_id) {
        try {
            Request request = null;
            OkHttpClient client = new OkHttpClient().newBuilder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
            request = new Request.Builder().url("https://json.biborne.com/api/v1/Customer_fidelite/GetCagnoteByLoyaltyUserPg/" + String.valueOf(customer_loyalty_id) + "&" + phone).method("GET", null).build();
            Response response = client.newCall(request).execute();
            System.out.println("+++++++ response : " + response);
            if (response.code() == 200) {
                String message;
                String response_body = response.body().string();
                JSONObject jsonResponse = new JSONObject(response_body);
                System.out.println("++++++++++++++++++++++++++++++++++++++++++ jsonResponse getCagnote" + jsonResponse);
                if (!jsonResponse.isNull("cagnote") && !jsonResponse.isNull("phone")) {
                    int value_cagnote = jsonResponse.getInt("cagnote") / 100;
                    String value_phone = jsonResponse.getString("phone");
                    boolean actif = jsonResponse.isNull("active") ? false : (jsonResponse.get("active") == null ? false : jsonResponse.getBoolean("active"));
                    System.out.println("++++++++++++ value_cagnote : " + value_cagnote);
                    String gender = jsonResponse.isNull("gender") ? null : jsonResponse.getString("gender");
                    return new CustomerLoyalty(value_phone, value_cagnote, actif, gender);
                }
                if (!jsonResponse.isNull("message") && (message = jsonResponse.getString("message")) != null && message.equalsIgnoreCase("Donn\u00e9es de fid\u00e9lit\u00e9 du client non trouv\u00e9es")) {
                    response.close();
                    return this.saveLoyaltyUser(phone);
                }
            }
            if (response.code() == 404) {
                response.close();
                return this.saveLoyaltyUser(phone);
            }
            response.close();
        }
        catch (IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return null;
    }

    public CustomerLoyalty getCagnoteByLoyaltyUser(String phone) {
        return this.getCagnoteByLoyaltyUser(phone, this.customer_loyalty_id);
    }

    public void saveLoyaltyUserCagnote(CustomerLoyalty mCustomerLoyalty) {
        this.saveLoyaltyUserCagnote(mCustomerLoyalty, this.customer_loyalty_id);
    }

    public void saveLoyaltyUserCagnote(CustomerLoyalty mCustomerLoyalty, String customerLoylatyId) {
        try {
            String customerLoylatyId_save = customerLoylatyId != null && !customerLoylatyId.isEmpty() ? customerLoylatyId : this.customer_loyalty_id;
            double cagnote = mCustomerLoyalty.getPoints();
            System.out.println("+++++++++ cagnote : " + cagnote);
            OkHttpClient client = new OkHttpClient().newBuilder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
            MediaType mediaType = MediaType.parse((String)"text/plain");
            MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("franchise_uuid", customerLoylatyId_save).addFormDataPart("phone", mCustomerLoyalty.getPhone()).addFormDataPart("cagnote", Formats.INT.formatValue(cagnote)).build();
            Request request = new Request.Builder().url("http://217.69.13.134:8080/api/saveLoyaltyUserCagnoteNew").method("POST", (RequestBody)body).addHeader("Authorization", "Token " + this.API_KEY).build();
            Response response = client.newCall(request).execute();
            System.out.println("++++++++++ response : " + response);
        }
        catch (IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public CustomerLoyalty saveLoyaltyUser(String phone) {
        try {
            Request request = null;
            OkHttpClient client = new OkHttpClient().newBuilder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
            JSONObject jsonRoot = new JSONObject();
            jsonRoot.put("franchise_uuid", (Object)this.customer_loyalty_id);
            jsonRoot.put("siret", (Object)this.SIRET_VAL);
            jsonRoot.put("first_name", (Object)"demo");
            jsonRoot.put("last_name", (Object)"demo");
            jsonRoot.put("phone", (Object)phone);
            jsonRoot.put("email", (Object)"demo@gmail.com");
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonRoot.toString());
            request = new Request.Builder().url("https://json.biborne.com/api/v1/Customer_fidelite/SaveLoyaltyUserPg").post(requestBody).addHeader("Content-Type", "application/json").build();
            Response response = client.newCall(request).execute();
            System.out.println("+++++++++++++++++++++++ response code Save User" + response.code());
            if (response.code() == 200) {
                return new CustomerLoyalty(phone, 0.0, false, null);
            }
        }
        catch (IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return null;
    }

    public void activateLoyaltyUser(CustomerLoyalty mCustomerLoyalty) {
        try {
            Request request = null;
            OkHttpClient client = new OkHttpClient().newBuilder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
            JSONObject jsonRoot = new JSONObject();
            jsonRoot.put("franchise_uuid", (Object)this.customer_loyalty_id);
            jsonRoot.put("phone", (Object)mCustomerLoyalty.getPhone());
            jsonRoot.put("gender", (Object)mCustomerLoyalty.getGender());
            jsonRoot.put("birthdate", (Object)mCustomerLoyalty.getBirthdate());
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonRoot.toString());
            request = new Request.Builder().url("https://json.biborne.com/api/v1/Customer_fidelite/ActivateLoyaltyUserPg").method("PUT", requestBody).addHeader("Content-Type", "application/json").build();
            Response response = client.newCall(request).execute();
            System.out.println("+++++++ Activate User code: " + response.code());
        }
        catch (IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void saveLoyaltyTransaction(CustomerLoyalty mCustomerLoyalty, double total, String keenio, String order_id, boolean is_validate) {
        this.saveLoyaltyTransaction(mCustomerLoyalty, null, total, keenio, order_id, is_validate);
    }

    public void saveLoyaltyTransaction(CustomerLoyalty mCustomerLoyalty, String customerLoylatyId, double total, String keenio, String order_id, boolean is_validate) {
        System.out.println("saveLoyaltyTransaction *******");
        try {
            Request request = null;
            customerLoylatyId = customerLoylatyId != null && !customerLoylatyId.isEmpty() ? customerLoylatyId : this.customer_loyalty_id;
            OkHttpClient client = new OkHttpClient().newBuilder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
            System.out.println("++++++++ URL_SAVE_TRANSACTION_PG : https://json.biborne.com/api/v1/transaction_fidelite/SaveLoyaltyTransactionPg");
            JSONObject jsonRoot = new JSONObject();
            jsonRoot.put("franchise_uuid", (Object)this.customer_loyalty_id);
            jsonRoot.put("siret", (Object)this.SIRET_VAL);
            jsonRoot.put("phone", (Object)mCustomerLoyalty.getPhone());
            jsonRoot.put("amount", (Object)String.valueOf(total));
            jsonRoot.put("value_in", (Object)String.valueOf(mCustomerLoyalty.getEarned_points()));
            jsonRoot.put("value_out", (Object)String.valueOf(mCustomerLoyalty.getUsed_points()));
            jsonRoot.put("keenio", (Object)keenio);
            jsonRoot.put("order_id", (Object)order_id);
            jsonRoot.put("validate", is_validate);
            System.out.println("Loyalty Transaction Json " + jsonRoot.toString());
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonRoot.toString());
            request = new Request.Builder().url("https://json.biborne.com/api/v1/transaction_fidelite/SaveLoyaltyTransactionPg").method("POST", requestBody).addHeader("Content-Type", "application/json").build();
            Response response = client.newCall(request).execute();
            System.out.println("+++++++++ response : " + response);
            System.out.println("+++++++ response  saveLoyaltyTransaction code: " + response.code());
        }
        catch (IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public CustomerLoyalty getLoyaltyUserNew(String phone, String customer_loyalty_id) {
        try {
            OkHttpClient client = new OkHttpClient().newBuilder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
            MediaType mediaType = MediaType.parse((String)"text/plain");
            MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("franchise_uuid", String.valueOf(customer_loyalty_id)).addFormDataPart("phone", phone).build();
            Request request = new Request.Builder().url("http://217.69.13.134:8080/api/getLoyaltyUserNew").method("POST", (RequestBody)body).addHeader("Authorization", "Token " + this.API_KEY).build();
            Response response = client.newCall(request).execute();
            System.out.println("+++++++ response : " + response);
            if (response.code() == 200) {
                String response_body = response.body().string();
                System.out.println("++++++ response_body : " + response_body);
                JSONObject jsonResponse = new JSONObject(response_body);
                if (!jsonResponse.isNull("phone")) {
                    String gender;
                    String value_phone = jsonResponse.getString("phone");
                    String string = jsonResponse.isNull("gender") ? "" : (gender = jsonResponse.get("gender") == null ? "" : jsonResponse.getString("gender"));
                    String birthdate = jsonResponse.isNull("birthdate") ? "" : (jsonResponse.get("birthdate") == null ? "" : jsonResponse.getString("birthdate"));
                    return new CustomerLoyalty(value_phone, gender, birthdate);
                }
            }
            if (response.code() == 404) {
                return this.saveLoyaltyUser(phone);
            }
        }
        catch (IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return null;
    }

    public CustomerLoyalty getLoyaltyUserNew(String phone) {
        return this.getLoyaltyUserNew(phone, this.customer_loyalty_id);
    }

    public int validTransaction(String keenio, String idOrder) {
        System.out.println("validTransaction 1 *******");
        try {
            String url = "https://json.biborne.com/api/v1/transaction_fidelite/validateTransactions/" + keenio + "&" + idOrder;
            OkHttpClient client = new OkHttpClient().newBuilder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
            MediaType mediaType = MediaType.parse((String)"text/plain");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)"");
            Request request = new Request.Builder().url(url).method("PUT", body).build();
            Response response = client.newCall(request).execute();
            System.out.println("response : " + response);
            return response.code();
        }
        catch (IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return 0;
        }
    }

    public void validTransaction(TicketInfo ticket, String keenio, String idOrder) {
        System.out.println("validTransaction 2 *******");
        try {
            CustomerLoyalty mCustomerLoyalty;
            int codeResponseValidOrder = this.validTransaction(keenio, idOrder);
            if (codeResponseValidOrder == 404 && ticket.getCustomerPhone() != null && !ticket.getCustomerPhone().isEmpty() && this.customer_loyalty_id != null && !this.customer_loyalty_id.isEmpty() && (mCustomerLoyalty = this.getCagnoteByLoyaltyUser(ticket.getCustomerPhone(), this.customer_loyalty_id)) != null) {
                double total_point = 0.0;
                for (TicketLineInfo line : ticket.getLines()) {
                    total_point += line.getPoints_loyalty() * line.getMultiply();
                }
                mCustomerLoyalty.setUsed_points(total_point);
                if (ticket.getTotal() > 0.0) {
                    mCustomerLoyalty.setEarned_points(ticket.getTotal());
                }
                if (mCustomerLoyalty.getUsed_points() > 0.0 || mCustomerLoyalty.getEarned_points() > 0.0) {
                    this.saveLoyaltyTransaction(mCustomerLoyalty, this.customer_loyalty_id, ticket.getTotal(), keenio, idOrder, true);
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void cancelTransaction(TicketInfo ticket, String keenio, String idOrder) {
        System.out.println("cancelTransaction *******");
        try {
            String url = "https://json.biborne.com/api/v1/transaction_fidelite/deleteAfterCanceled/" + keenio + "&" + idOrder + "&" + ticket.getCustomerPhone() + "&" + this.customer_loyalty_id;
            System.out.println("url : " + url);
            OkHttpClient client = new OkHttpClient().newBuilder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
            MediaType mediaType = MediaType.parse((String)"text/plain");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)"");
            Request request = new Request.Builder().url(url).method("DELETE", body).build();
            Response response = client.newCall(request).execute();
            System.out.println("response : " + response);
        }
        catch (IOException ex) {
            Logger.getLogger(LoyaltyService.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

