/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.service;

import com.openbravo.basic.BasicException;
import com.openbravo.basic.BasicStorage;
import com.openbravo.beans.CarteMenu;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.ticket.CarteInfo;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.GroupSubSupplementInfo;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.PhotoDispaly;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.ProductPriceInfo;
import com.openbravo.pos.ticket.ProductSizeInfo;
import com.openbravo.pos.ticket.PromotionInfo;
import com.openbravo.pos.ticket.StatusItem;
import com.openbravo.pos.ticket.SupplementInfo;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.SupplementProduct;
import com.openbravo.pos.ticket.TaxInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.ImagesUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import com.openbravo.service.CarteService;
import com.openbravo.service.DeliveroService;
import com.openbravo.service.SynchroService;
import com.openbravo.service.UberService;
import fr.protactile.kitchen.dao.entities.Screen;
import fr.protactile.kitchen.dao.entities.TagKitchenInfo;
import fr.protactile.kitchen.services.ScreenService;
import fr.protactile.kitchen.services.TagKitchenService;
import fr.protactile.kitchen.services.TicketSharedService;
import fr.protactile.procaisse.dao.entities.Allergene;
import fr.protactile.procaisse.dao.entities.ImageProduct;
import fr.protactile.procaisse.dao.entities.LocalScreen;
import fr.protactile.procaisse.dao.entities.MultiLanguageProduct;
import fr.protactile.procaisse.dao.entities.NutritionalInfoProduct;
import fr.protactile.procaisse.dao.entities.TagInfo;
import fr.protactile.procaisse.services.AllergeneService;
import fr.protactile.procaisse.services.ImageProductService;
import fr.protactile.procaisse.services.LocalScreenService;
import fr.protactile.procaisse.services.MultiLanguageCarteService;
import fr.protactile.procaisse.services.MultiLanguageCategoryService;
import fr.protactile.procaisse.services.MultiLanguageGSSService;
import fr.protactile.procaisse.services.MultiLanguageProductService;
import fr.protactile.procaisse.services.MultiLanguagePromotionService;
import fr.protactile.procaisse.services.MultiLanguageSupplementItemService;
import fr.protactile.procaisse.services.MultiLanguageSupplementService;
import fr.protactile.procaisse.services.NutritionalService;
import fr.protactile.procaisse.services.TagsService;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class ItemService {
    private DataLogicItems dlItems;
    private static ItemService m_instance;
    private TicketSharedService mTicketSharedService;
    private boolean slave;
    private String SIZE_JUNIOR = "junior";
    private String SIZE_SENIOR = "senior";
    private String SIZE_MEGA = "mega";
    private String SIZE1 = "size1";
    private String SIZE2 = "size2";
    private String SIZE3 = "size3";
    private String SIZE4 = "size4";
    private String SIZE5 = "size5";
    private String SIZE6 = "size6";
    private String SIZE7 = "size7";
    private FilerUtils mFilerUtils;
    private CarteService mCarteService;
    private DataLogicSales dlSales;
    private SynchroService mSynchroService;
    private LocalScreenService mLocalScreenService;
    private ScreenService mScreenService;
    private UberService mUberService;
    private PropertyChangeSupport support;
    private ImagesUtils mImageUtils = new ImagesUtils();
    public static final String SIZE_32px = "_32px";
    public static final String SIZE_64px = "_64px";
    public static final String SIZE_128px = "_128px";
    public static final String SIZE_256px = "_256px";
    public static final String SIZE_512px = "_512px";
    public static final String SIZE_134px = "_134px";
    public static final String SIZE_96px = "_96px";
    private ImagesUtils imageutils = new ImagesUtils();
    public static final List<String> listsizes;
    public static final List<String> tagslistsizes;
    private DeliveroService mDeliveroService;
    private TagKitchenService mTagKitchenService;
    private ImageProductService imageProductService;
    private MultiLanguageProductService multiLanguageProductService;
    private NutritionalService mNutritionalService;
    protected AllergeneService allergeneService;
    private final String STR_PRODUCT = "product";
    private final String STR_OPTION = "option";
    private final String STR_INGREDIENT = "ingredient";
    private MultiLanguageCarteService multiLanguageCarteService;
    private MultiLanguageCategoryService multiLanguageCategoryService;
    private MultiLanguageSupplementService multiLanguageSupplementService;
    private MultiLanguageSupplementItemService multiLanguageSupplementItemService;
    private MultiLanguageGSSService multiLanguageGSSService;
    private MultiLanguagePromotionService multiLanguagePromotionService;

    public static ItemService getInstance(AppView m_App) {
        if (m_instance == null) {
            m_instance = new ItemService(m_App);
        }
        return m_instance;
    }

    public static ItemService getInstance() {
        if (m_instance == null) {
            m_instance = new ItemService(null);
        }
        return m_instance;
    }

    static ItemService getInstance_2() {
        if (m_instance == null) {
            m_instance = new ItemService();
        }
        return m_instance;
    }

    private ItemService() {
    }

    private ItemService(AppView m_App) {
        listsizes.add(SIZE_32px);
        listsizes.add(SIZE_64px);
        listsizes.add(SIZE_128px);
        listsizes.add(SIZE_256px);
        listsizes.add(SIZE_512px);
        tagslistsizes.add(SIZE_96px);
        tagslistsizes.add(SIZE_134px);
        this.dlItems = AppLocal.dlItems;
        this.dlSales = AppLocal.dlSales;
        System.out.println("+++++++++++++++ m_App 1 : " + m_App);
        boolean bl = this.slave = AppLocal.modeCaisse != null && AppLocal.modelCaisse.equals("Esclave");
        if (AppLocal.KITCHEN_COMPOSITE) {
            this.mTicketSharedService = TicketSharedService.getInstance();
        }
        this.mFilerUtils = FilerUtils.getInstance();
        this.support = new PropertyChangeSupport(this);
        this.imageProductService = ImageProductService.getInstance();
        this.multiLanguageProductService = MultiLanguageProductService.getInstance();
        this.mNutritionalService = NutritionalService.getInstance();
        this.allergeneService = AllergeneService.getInstance();
        this.multiLanguageCarteService = MultiLanguageCarteService.getInstance();
        this.multiLanguageCategoryService = MultiLanguageCategoryService.getInstance();
        this.multiLanguageSupplementService = MultiLanguageSupplementService.getInstance();
        this.multiLanguageSupplementItemService = MultiLanguageSupplementItemService.getInstance();
        this.multiLanguageGSSService = MultiLanguageGSSService.getInstance();
        this.multiLanguagePromotionService = MultiLanguagePromotionService.getInstance();
    }

    public void changeStatusProduct(int product_id, boolean sold_out, boolean hidden_borne, boolean sold_out_temporary, String id_global) throws BasicException {
        this.dlItems.updateStatusProduct(product_id, sold_out, hidden_borne, sold_out_temporary, id_global);
        AppLocal.product_management = true;
        this.support.firePropertyChange("reload", null, null);
    }

    public List<ProductInfoExt> getProductCatalogBorne(int category, String type) throws BasicException {
        List<ProductInfoExt> products = this.dlItems.getProductCatalogBorne(category, type);
        this.setSizes(products);
        for (ProductInfoExt product : products) {
            if (product.getAdditional_sales() != null && !product.getAdditional_sales().isEmpty()) {
                this.setSizes(product.getAdditional_sales());
            }
            product.setPromotions(this.dlItems.getPromotionsByPproduct(product.getID(), true));
        }
        return products;
    }

    public List<ProductInfoExt> getMomentProducts(TagInfo mTagInfo) throws BasicException {
        List<ProductInfoExt> products = this.dlItems.getMomentProducts(mTagInfo);
        for (ProductInfoExt product : products) {
            product.setListSizes(this.dlItems.getProductSizes(product.getID(), true));
            product.setAdditional_sales(this.dlItems.getAdditionalSales(product.getID(), true));
            product.setSub_products(this.dlItems.getSubProducts(product.getID(), true));
            for (ProductInfoExt product_additional : product.getAdditional_sales()) {
                product_additional.setListSizes(this.dlItems.getProductSizes(product_additional.getID(), true));
                product_additional.setSub_products(this.dlItems.getSubProducts(product_additional.getID(), true));
                product_additional.setPrices(this.dlItems.getProductPrices(product_additional.getID(), true));
                List<ImageProduct> images = this.imageProductService.getImages(product_additional.getID());
                product_additional.setImages(images);
                List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product_additional.getID());
                product_additional.setMultiLanguageTexts(multiLanguageTexts);
                NutritionalInfoProduct mNutritionals = this.mNutritionalService.getNutriByProduct(product_additional.getID());
                product_additional.setNutriValues(mNutritionals);
            }
            if (product.getAdditional_sales() != null && !product.getAdditional_sales().isEmpty()) {
                this.setSizes(product.getAdditional_sales());
            }
            product.setPrices(this.dlItems.getProductPrices(product.getID(), true));
            List<ImageProduct> images = this.imageProductService.getImages(product.getID());
            product.setImages(images);
            List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product.getID());
            product.setMultiLanguageTexts(multiLanguageTexts);
            NutritionalInfoProduct mNutritionals = this.mNutritionalService.getNutriByProduct(product.getID());
            product.setNutriValues(mNutritionals);
        }
        this.setSizes(products);
        return products;
    }

    public List<ProductInfoExt> getAdditionnalProductsByType(String type_order, TagInfo mTagInfo) throws BasicException {
        List<ProductInfoExt> products = this.dlItems.getAdditionnalProductsByType(type_order, mTagInfo);
        for (ProductInfoExt product : products) {
            product.setListSizes(this.dlItems.getProductSizes(product.getID(), true));
            product.setSub_products(this.dlItems.getSubProducts(product.getID(), true));
            product.setPrices(this.dlItems.getProductPrices(product.getID(), true));
            List<ImageProduct> images = this.imageProductService.getImages(product.getID());
            product.setImages(images);
            List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product.getID());
            product.setMultiLanguageTexts(multiLanguageTexts);
            NutritionalInfoProduct mNutritionals = this.mNutritionalService.getNutriByProduct(product.getID());
            product.setNutriValues(mNutritionals);
        }
        this.setSizes(products);
        return products;
    }

    private void setSizes(List<ProductInfoExt> products) {
        for (ProductInfoExt product : products) {
            this.setSizes(product);
        }
    }

    public void loadSizeProduct(List<ProductSizeInfo> listSizes, ProductInfoExt product) {
        for (ProductSizeInfo productSizeItem : product.getListSizes()) {
            if (productSizeItem.getName().equals(this.SIZE_JUNIOR) && AppLocal.PRODUCT_SIZE_JUNIOR_ENABLED && productSizeItem.isSize_enabled()) {
                productSizeItem.setDescription(AppLocal.PRODUCT_SIZE1_DESCRIPTION);
                listSizes.add(productSizeItem);
            }
            if (productSizeItem.getName().equals(this.SIZE_SENIOR) && AppLocal.PRODUCT_SIZE_SENIOR_ENABLED && productSizeItem.isSize_enabled()) {
                productSizeItem.setDescription(AppLocal.PRODUCT_SIZE2_DESCRIPTION);
                listSizes.add(productSizeItem);
            }
            if (productSizeItem.getName().equals(this.SIZE_MEGA) && AppLocal.PRODUCT_SIZE_MEGA_ENABLED && productSizeItem.isSize_enabled()) {
                productSizeItem.setDescription(AppLocal.PRODUCT_SIZE3_DESCRIPTION);
                listSizes.add(productSizeItem);
            }
            if (productSizeItem.getName().equals(this.SIZE1) && AppLocal.PRODUCT_SIZE1_ENABLED && productSizeItem.isSize_enabled()) {
                productSizeItem.setDescription(AppLocal.PRODUCT_SIZE4_DESCRIPTION);
                listSizes.add(productSizeItem);
            }
            if (productSizeItem.getName().equals(this.SIZE2) && AppLocal.PRODUCT_SIZE2_ENABLED && productSizeItem.isSize_enabled()) {
                productSizeItem.setDescription(AppLocal.PRODUCT_SIZE5_DESCRIPTION);
                listSizes.add(productSizeItem);
            }
            if (productSizeItem.getName().equals(this.SIZE3) && AppLocal.PRODUCT_SIZE3_ENABLED && productSizeItem.isSize_enabled()) {
                productSizeItem.setDescription(AppLocal.PRODUCT_SIZE6_DESCRIPTION);
                listSizes.add(productSizeItem);
            }
            if (productSizeItem.getName().equals(this.SIZE4) && AppLocal.PRODUCT_SIZE4_ENABLED && productSizeItem.isSize_enabled()) {
                productSizeItem.setDescription(AppLocal.PRODUCT_SIZE7_DESCRIPTION);
                listSizes.add(productSizeItem);
            }
            if (productSizeItem.getName().equals(this.SIZE5) && AppLocal.PRODUCT_SIZE5_ENABLED && productSizeItem.isSize_enabled()) {
                productSizeItem.setDescription(AppLocal.PRODUCT_SIZE8_DESCRIPTION);
                listSizes.add(productSizeItem);
            }
            if (productSizeItem.getName().equals(this.SIZE6) && AppLocal.PRODUCT_SIZE6_ENABLED && productSizeItem.isSize_enabled()) {
                productSizeItem.setDescription(AppLocal.PRODUCT_SIZE9_DESCRIPTION);
                listSizes.add(productSizeItem);
            }
            if (!productSizeItem.getName().equals(this.SIZE7) || !AppLocal.PRODUCT_SIZE7_ENABLED || !productSizeItem.isSize_enabled()) continue;
            productSizeItem.setDescription(AppLocal.PRODUCT_SIZE10_DESCRIPTION);
            listSizes.add(productSizeItem);
        }
    }

    public void setPriceOfFirstSize(ProductInfoExt product, String typeOrder) {
        double price_product = this.getPriceProduct(product, typeOrder, true);
        product.setPriceSell(price_product);
    }

    public double getPriceProduct(ProductInfoExt product, String typeOrder, boolean check_opening_mode) {
        double price_product = 0.0;
        if (AppLocal.OPENING_MODE && product.getPrice_opening() != 0.0 && check_opening_mode) {
            price_product = product.getPrice_opening();
        } else if (product.isMany_size() && product.getListSizes().size() > 0 && product.getListSizes().get(0) != null) {
            if (product.isDifferent_price()) {
                if (typeOrder != null) {
                    switch (typeOrder) {
                        case "Sur Place": {
                            price_product = product.getListSizes().get(0).getPrice_sp();
                            break;
                        }
                        case "A Emporter": {
                            price_product = product.getListSizes().get(0).getPrice_emp();
                            break;
                        }
                        default: {
                            price_product = product.getListSizes().get(0).getPrice();
                            break;
                        }
                    }
                }
            } else {
                price_product = product.getListSizes().get(0).getPrice();
            }
        } else if (product.isDifferent_price()) {
            if (typeOrder != null) {
                price_product = product.getPrice(typeOrder, AppLocal.TARIFF);
            }
        } else {
            price_product = product.getPrice(null, AppLocal.TARIFF);
        }
        return price_product;
    }

    public void updateStatusSoldOutProduct(int product_id, boolean sold_out) throws BasicException {
        this.dlItems.updateStatusSoldOutProduct(product_id, sold_out);
    }

    public void updateStatusSoldOutProductById(int product_id, boolean sold_out) throws BasicException {
        this.dlItems.updateStatusSoldOutProductById(product_id, sold_out);
    }

    public void changeStorableProducts() throws BasicException {
        this.dlItems.changeStorableProducts();
    }

    private List<ProductInfoExt> getProductDailyStock() throws BasicException {
        return this.dlItems.getProductDailyStock();
    }

    public void checkAndChangeStorableProducts() throws BasicException {
        List<ProductInfoExt> products = this.getProductDailyStock();
        ArrayList<Integer> products_to_change = new ArrayList<Integer>();
        Date date_start = new Date();
        date_start.setHours(6);
        date_start.setMinutes(5);
        date_start.setSeconds(0);
        System.out.println("+++++++++++ date_start : " + date_start);
        System.out.println("++++++++++++++++ products : " + products);
        if (products != null && this.mTicketSharedService != null) {
            for (ProductInfoExt product : products) {
                int id_product = this.slave ? Integer.parseInt(product.getRef_web()) : product.getID();
                System.out.println("++++++++++++ id_product : " + id_product);
                double productsOrdered = this.mTicketSharedService.getNumberProductOrderd(id_product, date_start);
                System.out.println("+++++++++++ productsOrdered : " + productsOrdered);
                if (!(productsOrdered < (double)product.getDaily_stock())) continue;
                products_to_change.add(product.getID());
            }
            System.out.println("+++++++++++++++ products_to_change : " + products_to_change);
            for (Integer id_product : products_to_change) {
                this.dlItems.updateStatusSoldOutProductById(id_product, false);
            }
        }
    }

    public double getPriceProductByBarCode(String bar_code) {
        if (bar_code != null && !bar_code.isEmpty()) {
            try {
                int lenght_barCode = bar_code.length();
                String barCode = bar_code.substring(0, lenght_barCode - 1);
                int beginIndex = barCode.length() - AppLocal.NUMBER_DIGIT_OF_PRODUCT_PRICE;
                if (beginIndex >= 0) {
                    String price_text;
                    String price_text_tmp = price_text = barCode.substring(beginIndex);
                    int beginIndexAfterComma = price_text.length() - 2;
                    String firstPart = price_text.substring(0, beginIndexAfterComma);
                    String secondPart = price_text_tmp.substring(beginIndexAfterComma);
                    StringBuilder priceBuilder = new StringBuilder();
                    priceBuilder.append(firstPart);
                    priceBuilder.append(".");
                    priceBuilder.append(secondPart);
                    double price = Double.parseDouble(priceBuilder.toString());
                    return price;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return 0.0;
            }
        }
        return 0.0;
    }

    public List<CategoryInfo> getCategories() {
        try {
            List<CategoryInfo> categories = this.dlItems.getUberEatCategories();
            for (CategoryInfo category : categories) {
                List<ProductInfoExt> products = this.dlItems.getProductsWithoutDetails(category.getID(), false, false, true, true);
                for (ProductInfoExt product : products) {
                    product.setPrices(this.dlItems.getProductPrices(product.getID(), true));
                    TaxInfo tax = this.dlItems.getTaxById(product.getTaxCategoryID());
                    if (tax != null) {
                        product.setTax_rate((int)(tax.getRate() * 100.0));
                        product.setTax_rate_double(NumericUtils.round(tax.getRate() * 100.0));
                    }
                    product.setSupplements(this.dlItems.getSupplementsByProduct(product.getID(), true, false));
                    List<ImageProduct> images = this.imageProductService.getImages(product.getID());
                    product.setImages(images);
                    List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product.getID());
                    product.setMultiLanguageTexts(multiLanguageTexts);
                    NutritionalInfoProduct mNutritionals = this.mNutritionalService.getNutriByProduct(product.getID());
                    product.setNutriValues(mNutritionals);
                    List<Allergene> listAllergenes = this.allergeneService.getAllergenesForProduct(product.getID());
                    product.setAllergenes(listAllergenes);
                }
                category.setProducts(products);
            }
            return categories;
        }
        catch (BasicException ex) {
            return null;
        }
    }

    public List<SupplementInfo> getGroupsOptions() {
        try {
            List<SupplementInfo> groupsOptions = this.dlItems.getUberEatSupplements();
            return groupsOptions;
        }
        catch (BasicException ex) {
            return null;
        }
    }

    public PromotionInfo getPromotion(ProductInfoExt product, String size_product, String type_order, double quantity) {
        if (product.getPromotions() != null && !product.getPromotions().isEmpty()) {
            for (PromotionInfo promotion : product.getPromotions()) {
                if (promotion.getSize_product() != null && (size_product == null || !promotion.getSize_product().equals(size_product)) || promotion.getType_order() != null && !promotion.getType_order().equals(type_order) || !(quantity >= promotion.getQuantity())) continue;
                return promotion;
            }
        }
        return null;
    }

    public List<PromotionInfo> getPromotions() throws BasicException {
        List<PromotionInfo> promotions = this.dlItems.getPromotions(false);
        return promotions;
    }

    public List<ProductInfoExt> getProductsManagment(int category, boolean catalog, boolean all, boolean sub_child, boolean filter_by_tarif) throws BasicException {
        List<ProductInfoExt> products = this.dlItems.getProducts(category, catalog, all, sub_child, filter_by_tarif);
        this.setSizes(products);
        this.setTimeTable(products);
        return products;
    }

    public void setSizes(ProductInfoExt product) {
        if (product.isMany_size()) {
            ArrayList<ProductSizeInfo> listSizes = new ArrayList<ProductSizeInfo>();
            this.loadSizeProduct(listSizes, product);
            product.setListSizes(listSizes);
        }
    }

    private void setTimeTable(List<ProductInfoExt> products) throws BasicException {
        for (ProductInfoExt product : products) {
            product.setDaysOn(this.dlItems.getProductDaysOn(product.getID()));
        }
    }

    public String getInfoGroupSupplement(SupplementProduct option) {
        if (option != null) {
            int size_items = option.getItems() != null ? option.getItems().size() : 0;
            return this.getInfoGroupSupplement(option.getHas_options(), option.getMin_options(), option.getMax_options(), option.getOption_free(), option.getName(), size_items, option.getNumber_click());
        }
        return "";
    }

    public String getInfoGroupSupplement(GroupSubSupplementInfo groupSubSupplementInfo) {
        if (groupSubSupplementInfo != null) {
            int size_items = groupSubSupplementInfo.getSupplements() != null ? groupSubSupplementInfo.getSupplements().size() : 0;
            return this.getInfoGroupSupplement(groupSubSupplementInfo.isHas_limit_options(), groupSubSupplementInfo.getMin_options(), groupSubSupplementInfo.getMax_options(), groupSubSupplementInfo.getOption_free(), groupSubSupplementInfo.getDisplayedName(), size_items, groupSubSupplementInfo.getNumber_click());
        }
        return "";
    }

    public String getInfoGroupSupplement(boolean has_limit_option, int min_options, int max_options, int option_free, String name_group, int size_items, int number_click) {
        StringBuilder info_option = new StringBuilder();
        min_options = min_options > size_items && min_options > number_click ? size_items : min_options;
        int n = max_options = max_options > size_items && max_options > number_click ? size_items : max_options;
        if (has_limit_option || option_free > 0) {
            info_option.append(" (");
        }
        if (option_free > 0) {
            info_option.append(String.valueOf(option_free));
            info_option.append(" ");
            info_option.append(option_free > 1 ? AppLocal.getIntString("Label.offerts") : AppLocal.getIntString("Label.offert"));
            if (has_limit_option) {
                info_option.append(", ");
            }
        }
        if (has_limit_option) {
            if (min_options > 0) {
                info_option.append(String.valueOf(min_options));
                info_option.append(" ");
                info_option.append(AppLocal.getIntString("Label.min"));
                if (max_options > 0) {
                    info_option.append(", ");
                }
            }
            if (max_options > 0) {
                info_option.append(String.valueOf(max_options));
                info_option.append(" ");
                info_option.append(AppLocal.getIntString("Label.max"));
            }
        }
        if (has_limit_option || option_free > 0) {
            info_option.append(")");
        }
        return info_option.toString().toUpperCase();
    }

    public void setSubProducts(ProductInfoExt product) {
        if (product.getSub_products() != null && !product.getSub_products().isEmpty()) {
            ArrayList<ProductInfoExt> subProducts = new ArrayList<ProductInfoExt>();
            for (ProductInfoExt sub_product : product.getSub_products()) {
                if (sub_product.getIngredients() == null || sub_product.getIngredients().isEmpty()) {
                    try {
                        List<SupplementItemInfo> ingredients = this.dlItems.getIngredientsByProductsPop(sub_product.getID());
                        sub_product.setIngredients(ingredients);
                    }
                    catch (BasicException ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
                for (int i = 1; i <= sub_product.getNumber_exemplary(); ++i) {
                    ProductInfoExt new_sub_product = (ProductInfoExt)sub_product.clone();
                    new_sub_product.setIndex_sub_product(i);
                    subProducts.add(new_sub_product);
                }
            }
            product.setSub_products(subProducts);
        }
    }

    public void deleteImages() {
        try {
            List<CategoryInfo> categories = this.dlItems.getCategories(false, false, true);
            List<ProductInfoExt> products = this.dlItems.getproductsInfo();
            List<SupplementInfo> groupsOptions = this.dlItems.getSupplementsInfo();
            List<SupplementItemInfo> supplements = this.dlItems.getAllSupplementItems();
            List<SupplementItemInfo> ingredients = this.dlItems.getAllIngredients();
            File groupsOptionsDirectory = this.mFilerUtils.getFileFullPath(FilerUtils.IMAGES_GOPTIONS);
            File categoriesDirectory = this.mFilerUtils.getFileFullPath(FilerUtils.IMAGES_CATEGORIES);
            File productsDirectory = this.mFilerUtils.getFileFullPath(FilerUtils.IMAGES_PRODUCTS);
            File supplementsDirectory = this.mFilerUtils.getFileFullPath(FilerUtils.IMAGES_SUPPLEMENTS);
            File ingredientsDirectory = this.mFilerUtils.getFileFullPath(FilerUtils.IMAGES_INGREDIENTS);
            if (categoriesDirectory.exists()) {
                ArrayList<String> categoriesPaths = new ArrayList<String>();
                for (CategoryInfo category : categories) {
                    categoriesPaths.add(category.getPath());
                    if (category.getPath_category_moment() == null || category.getPath_category_moment().isEmpty()) continue;
                    categoriesPaths.add(category.getPath_category_moment());
                }
                for (Iterator<Cloneable> iterator : categoriesDirectory.listFiles()) {
                    if (iterator == null || !((File)((Object)iterator)).exists() || this.existPathItem((List<String>)categoriesPaths, (File)((Object)iterator), true)) continue;
                    ((File)((Object)iterator)).delete();
                }
            }
            if (productsDirectory.exists()) {
                ArrayList<String> productsPaths = new ArrayList<String>();
                for (ProductInfoExt product : products) {
                    String image_product_platform = product.getImageProductPlatForm();
                    String string = product.getImageProduct();
                    ImageProduct image_product_moment = product.getImageProductMoment();
                    String image_product_moment_path = image_product_moment != null ? image_product_moment.getPath() : null;
                    productsPaths.add(string);
                    if (image_product_platform != null && !image_product_platform.isEmpty()) {
                        productsPaths.add(image_product_platform);
                    }
                    if (image_product_moment_path == null || image_product_moment_path.isEmpty()) continue;
                    productsPaths.add(image_product_moment_path);
                }
                for (Iterator<Cloneable> iterator : productsDirectory.listFiles()) {
                    if (iterator == null || !((File)((Object)iterator)).exists() || this.existPathItem((List<String>)productsPaths, (File)((Object)iterator), true)) continue;
                    ((File)((Object)iterator)).delete();
                }
            }
            if (groupsOptionsDirectory.exists()) {
                ArrayList<String> groupsOptionsPaths = new ArrayList<String>();
                for (SupplementInfo groupOptions : groupsOptions) {
                    groupsOptionsPaths.add(groupOptions.getPath());
                }
                for (Iterator<Cloneable> iterator : groupsOptionsDirectory.listFiles()) {
                    if (iterator == null || !((File)((Object)iterator)).exists() || this.existPathItem((List<String>)groupsOptionsPaths, (File)((Object)iterator), true)) continue;
                    ((File)((Object)iterator)).delete();
                }
            }
            if (supplementsDirectory.exists()) {
                ArrayList<String> supplementsPaths = new ArrayList<String>();
                for (SupplementItemInfo supplement : supplements) {
                    supplementsPaths.add(supplement.getPath());
                }
                for (Iterator<Cloneable> iterator : supplementsDirectory.listFiles()) {
                    if (iterator == null || !((File)((Object)iterator)).exists() || this.existPathItem((List<String>)supplementsPaths, (File)((Object)iterator), true)) continue;
                    ((File)((Object)iterator)).delete();
                }
            }
            if (ingredientsDirectory.exists()) {
                ArrayList<String> ingredientsPaths = new ArrayList<String>();
                for (SupplementItemInfo ingrdient : ingredients) {
                    ingredientsPaths.add(ingrdient.getPath());
                }
                for (Iterator<Cloneable> iterator : ingredientsDirectory.listFiles()) {
                    if (iterator == null || !((File)((Object)iterator)).exists() || this.existPathItem((List<String>)ingredientsPaths, (File)((Object)iterator), true)) continue;
                    ((File)((Object)iterator)).delete();
                }
            }
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private boolean existPathItem(List<String> paths, File file, boolean rename) {
        String fileName = this.getNameImage(file.getName());
        if (!fileName.equalsIgnoreCase(file.getName())) {
            rename = false;
        }
        for (String path : paths) {
            if (path == null || !path.equalsIgnoreCase(fileName)) continue;
            if (rename && !path.equals(file.getName())) {
                String newName = file.getAbsolutePath().replace(file.getName(), path);
                this.mFilerUtils.renameImage(file, newName);
            }
            return true;
        }
        return false;
    }

    public List<ProductInfoExt> getProductsWithPoints(String type, TagInfo mTagInfo) throws BasicException {
        List<ProductInfoExt> products = this.dlItems.getProductsWithPoints(type, mTagInfo);
        this.setSizes(products);
        for (ProductInfoExt product : products) {
            product.setUse_points(true);
            if (product.getAdditional_sales() == null || product.getAdditional_sales().isEmpty()) continue;
            this.setSizes(product.getAdditional_sales());
        }
        return products;
    }

    public List<ProductInfoExt> getProductCatalogType(int category, String type, boolean sub_child, boolean product_loyalty) throws BasicException {
        List<ProductInfoExt> products = this.dlItems.getProductCatalogType(category, type, sub_child, product_loyalty);
        for (ProductInfoExt product : products) {
            product.setUse_points(product_loyalty);
            product.setListSizes(this.dlItems.getProductSizes(product.getID(), true));
            product.setAdditional_sales(this.dlItems.getAdditionalSales(product.getID(), false));
            product.setPromotions(this.dlItems.getPromotionsByPproduct(product.getID(), true));
            product.setSub_products(this.dlItems.getSubProducts(product.getID(), false));
            product.setPrices(this.dlItems.getProductPrices(product.getID(), true));
            List<ImageProduct> images = this.imageProductService.getImages(product.getID());
            product.setImages(images);
            List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product.getID());
            product.setMultiLanguageTexts(multiLanguageTexts);
            NutritionalInfoProduct mNutritionals = this.mNutritionalService.getNutriByProduct(product.getID());
            product.setNutriValues(mNutritionals);
        }
        return products;
    }

    public void updateImages() {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ItemService.this.copyImageIngredients();
                    ItemService.this.renameImages();
                    ItemService.this.deleteImages();
                    ItemService.this.addImageResized();
                    ItemService.this.addImageProductUber();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        });
    }

    private void renameImages() {
        try {
            File image;
            String name_image;
            System.out.println("+++++++++++ renameImages start : " + new Date());
            List<ProductInfoExt> products = this.dlItems.getProductsWithSpaceInImage();
            List<CategoryInfo> categories = this.dlItems.getCategoriesWithSpaceInImage();
            List<SupplementInfo> groupsOptions = this.dlItems.getSupplementsWithSpaceInImage();
            List<SupplementItemInfo> options = this.dlItems.getSuppelementItemsWithSpaceInImage();
            List<SupplementItemInfo> ingredients = this.dlItems.getIngredientsWithSpaceInImage();
            if (categories != null && !categories.isEmpty()) {
                for (CategoryInfo category : categories) {
                    if (category == null || category.getPath() == null || category.getPath().isEmpty()) continue;
                    name_image = category.getPath().replaceAll(" ", "");
                    this.dlItems.updatePathItem("CATEGORIES", category.getID(), name_image);
                    image = this.mFilerUtils.getFileFullPath("images/catagories/" + category.getPath());
                    if (!image.exists() || image.isDirectory() || !image.getName().contains(" ")) continue;
                    this.mFilerUtils.renameImage(image);
                }
            }
            if (products != null && !products.isEmpty()) {
                for (ProductInfoExt product : products) {
                    String image_product = product.getImageProduct();
                    if (product == null || image_product == null || image_product.isEmpty()) continue;
                    String name_image2 = image_product.replaceAll(" ", "");
                    this.dlItems.updatePathItem("PRODUCTS", product.getID(), name_image2);
                    File image2 = this.mFilerUtils.getFileFullPath("images/products/" + image_product);
                    System.out.println("++++++++ image.getName() : " + image2.getName());
                    if (!image2.exists() || image2.isDirectory() || !image2.getName().contains(" ")) continue;
                    this.mFilerUtils.renameImage(image2);
                }
            }
            if (groupsOptions != null && !groupsOptions.isEmpty()) {
                for (SupplementInfo groupoptions : groupsOptions) {
                    if (groupoptions == null || groupoptions.getPath() == null || groupoptions.getPath().isEmpty()) continue;
                    name_image = groupoptions.getPath().replaceAll(" ", "");
                    this.dlItems.updatePathItem("SUPPLEMENT", groupoptions.getiD(), name_image);
                    image = this.mFilerUtils.getFileFullPath("images/options/" + groupoptions.getPath());
                    if (!image.exists() || image.isDirectory() || !image.getName().contains(" ")) continue;
                    this.mFilerUtils.renameImage(image);
                }
            }
            if (options != null && !options.isEmpty()) {
                for (SupplementItemInfo option : options) {
                    if (option == null || option.getPath() == null || option.getPath().isEmpty()) continue;
                    name_image = option.getPath().replaceAll(" ", "");
                    this.dlItems.updatePathItem("SUPPLEMENT_ITEM", option.getiD(), name_image);
                    image = this.mFilerUtils.getFileFullPath("images/supplements/" + option.getPath());
                    if (!image.exists() || image.isDirectory() || !image.getName().contains(" ")) continue;
                    this.mFilerUtils.renameImage(image);
                }
            }
            if (ingredients != null && !ingredients.isEmpty()) {
                for (SupplementItemInfo ingredient : ingredients) {
                    if (ingredient == null || ingredient.getPath() == null || ingredient.getPath().isEmpty()) continue;
                    name_image = ingredient.getPath().replaceAll(" ", "");
                    this.dlItems.updatePathItem("SUPPLEMENT_ITEM", ingredient.getiD(), name_image);
                    image = this.mFilerUtils.getFileFullPath("images/ingredients/" + ingredient.getPath());
                    if (!image.exists() || image.isDirectory() || !image.getName().contains(" ")) continue;
                    this.mFilerUtils.renameImage(image);
                }
            }
            System.out.println("+++++++++++ renameImages end : " + new Date());
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void copyImageIngredients() {
        try {
            System.out.println("+++++++++++++++= create images ingredients");
            List<SupplementItemInfo> ingredients = this.dlItems.getAllIngredients();
            File supplementsDirectory = this.mFilerUtils.getFileFullPath(FilerUtils.IMAGES_SUPPLEMENTS);
            File ingredientsDirectory = this.mFilerUtils.getFileFullPath(FilerUtils.IMAGES_INGREDIENTS);
            if (supplementsDirectory.exists() && !ingredientsDirectory.exists()) {
                FileUtils.forceMkdir((File)ingredientsDirectory);
                ArrayList<String> ingredientsPaths = new ArrayList<String>();
                for (SupplementItemInfo ingredient : ingredients) {
                    ingredientsPaths.add(ingredient.getPath());
                }
                for (File file : supplementsDirectory.listFiles()) {
                    if (file == null || !file.exists() || !this.existPathItem(ingredientsPaths, file, false)) continue;
                    File dest = new File(ingredientsDirectory + "/" + file.getName());
                    File src = new File(supplementsDirectory + "/" + file.getName());
                    FileUtils.copyFile((File)src, (File)dest);
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void sychroniseItems() {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ItemService.this.mSynchroService = SynchroService.getInstance(null);
                    ItemService.this.mSynchroService.sendItems();
                    ItemService.this.uploadItems(true);
                    ItemService.this.uploadItemsUberEats(true);
                }
                catch (IOException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        });
    }

    public List<ProductInfoExt> setSoldOutAndHidden(int product_id, boolean sold_out) {
        ArrayList<ProductInfoExt> products = new ArrayList<ProductInfoExt>();
        try {
            this.dlItems.setSoldOutAndHidden(product_id, sold_out);
            if (sold_out) {
                List<ProductInfoExt> productToSetSoldOut = this.setSoldOutProducts(product_id);
                products.addAll(productToSetSoldOut);
            } else {
                List<ProductInfoExt> productToSetVisible = this.setVisibleProductsBySubProduct(product_id);
                products.addAll(productToSetVisible);
            }
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return products;
    }

    public void setHiddenOnline(int product_id, boolean hidden_online) {
        try {
            this.dlItems.setHiddenOnline(product_id, hidden_online);
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void setHiddenBorne(int product_id, boolean hidden_borne) {
        try {
            this.dlItems.setHiddenBorne(product_id, hidden_borne);
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void setHiddenPlatform(int product_id, boolean hidden_ubereats) {
        try {
            this.dlItems.setHiddenUberEats(product_id, hidden_ubereats);
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void setSoldOutTemporary(int product_id, boolean sold_out) {
        try {
            this.dlItems.setSoldOutTemporary(product_id, sold_out, true);
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void setHiddenOnlineTemporary(int product_id, boolean hidden_online) {
        try {
            this.dlItems.setHiddenOnlineTemporary(product_id, hidden_online);
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void setHiddenBorneTemporary(int product_id, boolean hidden_borne) {
        try {
            this.dlItems.setHiddenBorneTemporary(product_id, hidden_borne);
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void updateIDsScreens() {
        if (AppLocal.KITCHEN_COMPOSITE) {
            if (AppLocal.MODEL_CAISSE != null && (AppLocal.MODEL_CAISSE.equalsIgnoreCase("Maitre") || AppLocal.MODEL_CAISSE.equalsIgnoreCase("Standalone"))) {
                this.mScreenService = ScreenService.getInstance();
                this.mLocalScreenService = LocalScreenService.getInstance();
                List<Screen> screens = this.mScreenService.getScreens();
                int number_screen = 1;
                for (Screen screen : screens) {
                    if (screen == null) continue;
                    try {
                        int number_products = this.dlItems.countScreenProduct(screen.getId());
                        if (number_products <= 0) continue;
                        LocalScreen mLocalScreens = this.mLocalScreenService.addScreen(screen.getName(), number_screen);
                        System.out.println("+++++++++ mLocalScreens.getId() new : " + mLocalScreens.getId());
                        System.out.println("+++++++++++ screen.getId() old : " + screen.getId());
                        this.dlItems.updateIdScreen(mLocalScreens.getId(), screen.getId());
                        ++number_screen;
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
                this.mScreenService.deleteOldScreenItem();
                this.mScreenService.deleteOldScreenSupplement();
                this.mScreenService.deleteOldScreenLine();
            } else {
                try {
                    this.dlItems.deleteProductScreen();
                }
                catch (BasicException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
    }

    public void setHiddenUberEatsTemporary(int product_id, boolean hidden_ubereats) {
        try {
            this.dlItems.setHiddenUberEatsTemporary(product_id, hidden_ubereats);
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void setEnableProducts() {
        try {
            this.dlItems.setEnableProducts();
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void sychroniseItem(final ProductInfoExt product, final boolean synchronise_local, final boolean upload_online) {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (synchronise_local) {
                        ItemService.this.mSynchroService = SynchroService.getInstance(null);
                        ItemService.this.mSynchroService.sendStatuProduct(product);
                    }
                    ItemService.this.uploadItems(upload_online);
                    ItemService.this.uploadItemsPlatform(product.getID(), product.isSold_out(), false);
                }
                catch (IOException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        });
    }

    private void uploadItems(boolean upload_online) throws IOException {
        if (AppLocal.ORDER_ONLINE_ENABLED && AppLocal.SUIVI_ONLINE_ORDER && upload_online) {
            if (this.mCarteService == null) {
                AppView m_App = (AppView)BasicStorage.getObject("APP_ROOT_INSTANCE");
                this.mCarteService = new CarteService(this.dlSales, this.dlItems, m_App);
            }
            this.mCarteService.uploadCarte();
        }
    }

    public void uploadItemsUberEats(final boolean checkImage) {
        if (AppLocal.MODULE_UBER_EATS) {
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (ItemService.this.mUberService == null) {
                            ItemService.this.mUberService = UberService.getInstance();
                        }
                        String result = ItemService.this.mUberService.uploadMenu(checkImage);
                        System.out.println("+++++++++++ result upload menu uber : " + result);
                    }
                    catch (IOException ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            });
        }
    }

    public void uploadItemsPlatform(final int item_id, final boolean hidden_platform, final boolean is_item_modifier) {
        this.uploadItemsUberEats(false);
        if (AppLocal.MODULE_DELIVERO) {
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (ItemService.this.mDeliveroService == null) {
                            ItemService.this.mDeliveroService = DeliveroService.getInstance();
                        }
                        if (hidden_platform) {
                            ItemService.this.mDeliveroService.setProductUnAvailable(item_id, is_item_modifier);
                        } else {
                            ItemService.this.mDeliveroService.setProductAvailable(item_id, is_item_modifier);
                        }
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            });
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.support.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.support.removePropertyChangeListener(pcl);
    }

    public void setPriceProduct(ProductInfoExt product, String typeOrder) {
        double price = this.getPriceByType(product, typeOrder);
        product.setPriceSell(price);
    }

    public double getPriceByType(ProductInfoExt product, String typeOrder) {
        double price = 0.0;
        if (AppLocal.OPENING_MODE && product.getPrice_opening() != 0.0) {
            price = product.getPrice_opening();
        } else {
            price = product.getPrice(null, AppLocal.TARIFF);
            if (product.isDifferent_price() && typeOrder != null) {
                typeOrder = typeOrder.equalsIgnoreCase("Uber Eats") || typeOrder.equalsIgnoreCase("Delivero") || typeOrder.equalsIgnoreCase("Deliveroo") || typeOrder.equalsIgnoreCase("Just Eat") || typeOrder.equalsIgnoreCase("Smood") ? "Platform" : typeOrder;
                price = product.getPrice(typeOrder, AppLocal.TARIFF);
            }
        }
        return price;
    }

    public double getPriceBorne(ProductSizeInfo sizeProduct, ProductInfoExt product) {
        double price = 0.0;
        if (AppLocal.OPENING_MODE && product.getPrice_opening() != 0.0) {
            price = product.getPrice_opening();
        } else {
            price = sizeProduct.getPrice();
            if (product.isDifferent_price()) {
                switch (AppLocal.ticketBorne.getType()) {
                    case "Sur Place": {
                        price = sizeProduct.getPrice_sp();
                        break;
                    }
                    case "A Emporter": {
                        price = sizeProduct.getPrice_emp();
                        break;
                    }
                    default: {
                        price = sizeProduct.getPrice();
                    }
                }
            }
        }
        return price;
    }

    public double getPriceSize(ProductSizeInfo sizeProduct, ProductInfoExt product, String typeOrder) {
        double price = 0.0;
        if (AppLocal.OPENING_MODE && product.getPrice_opening() != 0.0) {
            price = product.getPrice_opening();
        } else {
            switch (typeOrder) {
                case "Sur Place": {
                    price = sizeProduct.getPrice_sp();
                    break;
                }
                case "A Emporter": {
                    price = sizeProduct.getPrice_emp();
                    break;
                }
                case "En Livraison": {
                    price = sizeProduct.getPrice_lv();
                    break;
                }
                case "BAR": {
                    price = sizeProduct.getPrice_bar();
                    break;
                }
                case "Terasse": {
                    price = sizeProduct.getPrice_terasse();
                    break;
                }
                case "Happy Hour": {
                    price = sizeProduct.getPrice_happy_hour();
                    break;
                }
                case "Uber Eats": {
                    price = sizeProduct.getPrice_platform();
                    break;
                }
                case "Delivero": {
                    price = sizeProduct.getPrice_platform();
                    break;
                }
                case "Just Eat": {
                    price = sizeProduct.getPrice_platform();
                    break;
                }
                case "Drive": {
                    price = sizeProduct.getPrice_drive();
                    break;
                }
                case "Smood": {
                    price = sizeProduct.getPrice_platform();
                    break;
                }
                case "Deliveroo": {
                    price = sizeProduct.getPrice_platform();
                    break;
                }
                default: {
                    price = sizeProduct.getPrice();
                }
            }
        }
        return price;
    }

    public void setSoldOutAndHiddenOption(int option_id, boolean sold_out) {
        try {
            this.dlItems.setSoldOutAndHiddenOption(option_id, sold_out);
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void sychroniseOption(final SupplementItemInfo option, final boolean synchronise_local, final boolean upload_online) {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (synchronise_local) {
                        ItemService.this.mSynchroService = SynchroService.getInstance(null);
                        ItemService.this.mSynchroService.sendStatuOption(option);
                    }
                    ItemService.this.uploadItems(upload_online);
                    ItemService.this.uploadItemsPlatform(option.getiD(), option.isSold_out(), true);
                }
                catch (IOException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        });
    }

    public void changeStatusOption(int option_id, boolean sold_out, boolean hidden_borne, String id_global) throws BasicException {
        this.dlItems.updateStatusOption(option_id, sold_out, hidden_borne, id_global);
        AppLocal.product_management = true;
        this.support.firePropertyChange("reload", null, null);
    }

    public void addSizesProduct() throws BasicException, SQLException {
        List<ProductInfoExt> products = this.dlItems.getProductsWithSizes();
        for (ProductInfoExt product : products) {
            this.addSizesProduct(product);
        }
    }

    public void addSizesProduct(ProductInfoExt product) throws BasicException, SQLException {
        int tariff = 1;
        List<ProductSizeInfo> oldSizes = this.dlItems.getProductSizes(product.getID(), false);
        if (AppLocal.PRODUCT_SIZE_JUNIOR_ENABLED && product.isSize_junior_enabled()) {
            ProductSizeInfo sizeJunior = new ProductSizeInfo(this.SIZE_JUNIOR, AppLocal.PRODUCT_SIZE_JUNIOR, product.getPrice_junior(), product.getPrice_sp_junior(), product.getPrice_emp_junior(), product.getPrice_lv_junior(), product.getPrice_bar_junior(), product.getPrice_terasse_junior(), product.getPrice_happy_junior(), product.getPrice_platform_junior(), product.getID(), AppLocal.PRODUCT_SIZE1_DESCRIPTION, product.getPrice_drive_junior(), product.isSize_junior_enabled(), tariff);
            this.dlItems.addProduct_Size(sizeJunior);
        }
        if (AppLocal.PRODUCT_SIZE_SENIOR_ENABLED && product.isSize_senior_enabled()) {
            ProductSizeInfo sizeSenior = new ProductSizeInfo(this.SIZE_SENIOR, AppLocal.PRODUCT_SIZE_SENIOR, product.getPrice_senior(), product.getPrice_sp_senior(), product.getPrice_emp_senior(), product.getPrice_lv_senior(), product.getPrice_bar_senior(), product.getPrice_terasse_senior(), product.getPrice_happy_senior(), product.getPrice_platform_senior(), product.getID(), AppLocal.PRODUCT_SIZE2_DESCRIPTION, product.getPrice_drive_senior(), product.isSize_senior_enabled(), tariff);
            this.dlItems.addProduct_Size(sizeSenior);
        }
        if (AppLocal.PRODUCT_SIZE_MEGA_ENABLED && product.isSize_mega_enabled()) {
            ProductSizeInfo sizeMega = new ProductSizeInfo(this.SIZE_MEGA, AppLocal.PRODUCT_SIZE_MEGA, product.getPrice_mega(), product.getPrice_sp_mega(), product.getPrice_emp_mega(), product.getPrice_lv_mega(), product.getPrice_bar_mega(), product.getPrice_terasse_mega(), product.getPrice_happy_mega(), product.getPrice_platform_mega(), product.getID(), AppLocal.PRODUCT_SIZE3_DESCRIPTION, product.getPrice_drive_mega(), product.isSize_mega_enabled(), tariff);
            this.dlItems.addProduct_Size(sizeMega);
        }
        if (oldSizes != null) {
            for (ProductSizeInfo productSize : oldSizes) {
                this.dlItems.setOrderSize(productSize);
            }
        }
    }

    public void addPricesProduct() throws BasicException {
        int tariff = 1;
        List<ProductInfoExt> products = this.dlItems.getProductsWithDifferentPrice();
        for (ProductInfoExt product : products) {
            ProductPriceInfo price_at_spot = new ProductPriceInfo(product.getPrice_sp(), "Sur Place", product.getID(), tariff);
            this.dlItems.addProductPrice(price_at_spot);
            ProductPriceInfo price_take_away = new ProductPriceInfo(product.getPrice_emp(), "A Emporter", product.getID(), tariff);
            this.dlItems.addProductPrice(price_take_away);
            if (product.getPrice_lv() != 0.0) {
                ProductPriceInfo price_delivery = new ProductPriceInfo(product.getPrice_lv(), "En Livraison", product.getID(), tariff);
                this.dlItems.addProductPrice(price_delivery);
            }
            if (product.getPrice_bar() != 0.0) {
                ProductPriceInfo price_bar = new ProductPriceInfo(product.getPrice_bar(), "BAR", product.getID(), tariff);
                this.dlItems.addProductPrice(price_bar);
            }
            if (product.getPrice_terasse() != 0.0) {
                ProductPriceInfo price_terasse = new ProductPriceInfo(product.getPrice_terasse(), "Terasse", product.getID(), tariff);
                this.dlItems.addProductPrice(price_terasse);
            }
            if (product.getPrice_happy_hour() != 0.0) {
                ProductPriceInfo price_happyhour = new ProductPriceInfo(product.getPrice_happy_hour(), "Happy Hour", product.getID(), tariff);
                this.dlItems.addProductPrice(price_happyhour);
            }
            if (product.getPrice_platform() != 0.0) {
                ProductPriceInfo price_platform = new ProductPriceInfo(product.getPrice_platform(), "Platform", product.getID(), tariff);
                this.dlItems.addProductPrice(price_platform);
            }
            if (product.getPrice_drive() == 0.0) continue;
            ProductPriceInfo price_drive = new ProductPriceInfo(product.getPrice_drive(), "Drive", product.getID(), tariff);
            this.dlItems.addProductPrice(price_drive);
        }
    }

    public void addImageProductUber() throws BasicException, IOException {
        File productsDirectory = this.mFilerUtils.getFileFullPath(FilerUtils.IMAGES_PRODUCTS);
        List<ProductInfoExt> products = this.dlItems.getproductsInfo();
        ArrayList<String> productsPaths = new ArrayList<String>();
        for (ProductInfoExt product : products) {
            String image_product_platform = product.getImageProductPlatForm();
            String image_product = product.getImageProduct();
            if (image_product == null || image_product.isEmpty()) continue;
            boolean check = false;
            if (image_product_platform != null && !image_product_platform.isEmpty()) {
                check = new File(productsDirectory, image_product_platform).exists();
            }
            if (check) continue;
            productsPaths.add(image_product);
            this.dlItems.updateImageUber(product.getID(), this.getNamePathUber(image_product));
        }
        File[] productsFile = productsDirectory.listFiles();
        this.checkAndAddImageUber(productsPaths, productsFile, FilerUtils.IMAGES_PRODUCTS, 550, 440);
        List<ImageProduct> imagesPlatform = this.imageProductService.getImagesPlatform();
        if (imagesPlatform != null) {
            for (ImageProduct imagePlatform : imagesPlatform) {
                int id_product = imagePlatform.getProduct().getId();
                String path_platform = imagePlatform.getPath();
                if (!Pattern.matches(".*[\u00ea\u00e9\u00e8\u00e0\u00f9\u00f4\u00e7\u00ee\u00ef].*", path_platform)) continue;
                String name_image = path_platform.replaceAll(" ", "");
                String name_image_without_accent = StringUtils.stripAccents((String)name_image);
                this.dlItems.updateImageUber(id_product, name_image_without_accent);
                File image = this.mFilerUtils.getFileFullPath("images/products/" + path_platform);
                if (!image.exists() || image.isDirectory() || !image.getName().contains(" ") && !Pattern.matches(".*[\u00e9\u00e8\u00e0\u00f9\u00f4].*", image.getName())) continue;
                this.mFilerUtils.removeAccent(image);
            }
        }
    }

    public String getNameImage(String fileName) {
        String ext = ((String)fileName).substring(((String)fileName).lastIndexOf(".") + 1);
        for (String size : listsizes) {
            if (!((String)fileName).endsWith(size + "." + ext)) continue;
            fileName = ((String)fileName).substring(0, ((String)fileName).length() - (size + ext).length() - 1);
            fileName = (String)fileName + "." + ext;
            break;
        }
        return fileName;
    }

    public void addImageResized() throws BasicException, IOException {
        System.out.println("+++++++++++++++= Ajouter les Images addImageResized()");
        File groupsOptionsDirectory = this.mFilerUtils.getFileFullPath(FilerUtils.IMAGES_GOPTIONS);
        File categoriesDirectory = this.mFilerUtils.getFileFullPath(FilerUtils.IMAGES_CATEGORIES);
        File productsDirectory = this.mFilerUtils.getFileFullPath(FilerUtils.IMAGES_PRODUCTS);
        File supplementsDirectory = this.mFilerUtils.getFileFullPath(FilerUtils.IMAGES_SUPPLEMENTS);
        File ingredientsDirectory = this.mFilerUtils.getFileFullPath(FilerUtils.IMAGES_INGREDIENTS);
        File logoDirectory = this.mFilerUtils.getFileFullPath(FilerUtils.IMAGES_LOGOS);
        File imageBorneDirectory = this.mFilerUtils.getFileFullPath(FilerUtils.IMAGES_BORNE);
        File photosDisplayDirectory = this.mFilerUtils.getFileFullPath(FilerUtils.IMAGES_DISPLAY);
        File ImagePubDirectory = this.mFilerUtils.getFileFullPath(FilerUtils.IMAGES_PUB);
        File tagsDirectory = this.mFilerUtils.getFileFullPath(FilerUtils.IMAGES_TAGS);
        List<PhotoDispaly> photohomeBorne = this.dlItems.getHomeBornePhoto();
        List<PhotoDispaly> photosDisplay = this.dlItems.getAllPhoto();
        List<PhotoDispaly> photosPub = this.dlSales.getPubPhoto();
        List<CategoryInfo> categories = this.dlItems.getCategories(false, false, true);
        List<ProductInfoExt> products = this.dlItems.getproductsInfo();
        List<SupplementInfo> groupsOptions = this.dlItems.getSupplementsInfo();
        List<SupplementItemInfo> supplements = this.dlItems.getAllSupplementItems();
        List<SupplementItemInfo> ingredients = this.dlItems.getAllIngredients();
        TagsService mTagsService = TagsService.getInstance();
        List<TagInfo> tags = mTagsService.getAllTags();
        if (logoDirectory.exists()) {
            File[] logosFile = logoDirectory.listFiles();
            List<String> logosPaths = this.getListPaths(logosFile);
            this.checkAndAddImageLogo(logosPaths, logosFile, FilerUtils.IMAGES_LOGOS);
        }
        ArrayList<String> photohomeBornePaths = new ArrayList<String>();
        for (PhotoDispaly photo : photohomeBorne) {
            photohomeBornePaths.add(photo.getPath());
        }
        File[] photohomeBorneFile = imageBorneDirectory.listFiles();
        this.checkAndAddImage(photohomeBornePaths, photohomeBorneFile, FilerUtils.IMAGES_BORNE);
        ArrayList<String> photosDisplayPaths = new ArrayList<String>();
        for (PhotoDispaly photo : photosDisplay) {
            photosDisplayPaths.add(photo.getPath());
        }
        File[] photosDisplayFile = photosDisplayDirectory.listFiles();
        this.checkAndAddImage(photosDisplayPaths, photosDisplayFile, FilerUtils.IMAGES_DISPLAY);
        ArrayList<String> photosPubPaths = new ArrayList<String>();
        for (PhotoDispaly photo : photosPub) {
            photosPubPaths.add(photo.getPath());
        }
        File[] photosPubFile = ImagePubDirectory.listFiles();
        this.checkAndAddImage(photosPubPaths, photosPubFile, FilerUtils.IMAGES_PUB);
        ArrayList<String> categoriesPaths = new ArrayList<String>();
        for (CategoryInfo category : categories) {
            categoriesPaths.add(category.getPath());
        }
        File[] categoriesFile = categoriesDirectory.listFiles();
        this.checkAndAddImage(categoriesPaths, categoriesFile, FilerUtils.IMAGES_CATEGORIES);
        ArrayList<String> productsPaths = new ArrayList<String>();
        for (ProductInfoExt product : products) {
            String image_product = product.getImageProduct();
            ImageProduct image_product_moment = product.getImageProductMoment();
            String image_product_moment_path = image_product_moment != null ? image_product_moment.getPath() : null;
            productsPaths.add(image_product);
            if (image_product_moment_path == null || image_product_moment_path.isEmpty()) continue;
            productsPaths.add(image_product_moment_path);
        }
        File[] productsFile = productsDirectory.listFiles();
        this.checkAndAddImage(productsPaths, productsFile, FilerUtils.IMAGES_PRODUCTS);
        ArrayList<String> groupsOptionsPaths = new ArrayList<String>();
        for (SupplementInfo option : groupsOptions) {
            groupsOptionsPaths.add(option.getPath());
        }
        File[] groupsOptionsFile = groupsOptionsDirectory.listFiles();
        this.checkAndAddImage(groupsOptionsPaths, groupsOptionsFile, FilerUtils.IMAGES_GOPTIONS);
        ArrayList<String> supplementsPaths = new ArrayList<String>();
        for (SupplementItemInfo suppliment : supplements) {
            supplementsPaths.add(suppliment.getPath());
        }
        File[] supplementsFile = supplementsDirectory.listFiles();
        this.checkAndAddImage(supplementsPaths, supplementsFile, FilerUtils.IMAGES_SUPPLEMENTS);
        ArrayList<String> ingredientsPaths = new ArrayList<String>();
        for (SupplementItemInfo ingredient : ingredients) {
            ingredientsPaths.add(ingredient.getPath());
        }
        File[] ingredientsFile = ingredientsDirectory.listFiles();
        this.checkAndAddImage(ingredientsPaths, ingredientsFile, FilerUtils.IMAGES_INGREDIENTS);
        ArrayList<String> tagsPaths = new ArrayList<String>();
        for (TagInfo tag : tags) {
            tagsPaths.add(tag.getLogo_tag());
        }
        File[] tagsFile = tagsDirectory.listFiles();
        this.checkAndAddImageTags(tagsPaths, tagsFile, FilerUtils.IMAGES_TAGS);
    }

    public void checkAndAddImage(List<String> listPaths, File[] listFile, String directory) throws IOException {
        for (String path : listPaths) {
            File file;
            if (path == null || path.isEmpty() || !(file = this.mFilerUtils.getFileFullPath(directory + File.separator + path)).exists()) continue;
            String ext = file.getName().substring(file.getName().lastIndexOf(".") + 1);
            String name = FilenameUtils.removeExtension((String)file.getName());
            for (String size : listsizes) {
                String namePathresized = name + size + "." + ext;
                boolean found = false;
                for (File filelist : listFile) {
                    if (!filelist.getName().equalsIgnoreCase(namePathresized)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                String taille = size.substring(1, size.length() - 2);
                this.imageutils.resizeImage(file, taille);
            }
        }
    }

    public void checkAndAddImageTags(List<String> listPaths, File[] listFile, String directory) throws IOException {
        for (String path : listPaths) {
            File file;
            if (path == null || path.isEmpty() || !(file = this.mFilerUtils.getFileFullPath(directory + File.separator + path)).exists()) continue;
            String ext = file.getName().substring(file.getName().lastIndexOf(".") + 1);
            String name = FilenameUtils.removeExtension((String)file.getName());
            for (String size : tagslistsizes) {
                String namePathresized = name + size + "." + ext;
                boolean found = false;
                for (File filelist : listFile) {
                    if (!filelist.getName().equalsIgnoreCase(namePathresized)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                String taille = size.substring(1, size.length() - 2);
                this.imageutils.resizeImage(file, taille);
            }
        }
    }

    public void checkAndAddImageUber(List<String> listPaths, File[] listFile, String directory, int m_width, int m_height) throws IOException {
        for (String path : listPaths) {
            File file;
            File fileuber = this.mFilerUtils.getFileFullPath(directory + File.separator + this.getNamePathUber(path));
            if (fileuber.exists() || !(file = this.mFilerUtils.getFileFullPath(directory + File.separator + path)).exists()) continue;
            String ext = file.getName().substring(file.getName().lastIndexOf(".") + 1);
            String name = FilenameUtils.removeExtension((String)file.getName());
            String name_image_without_accent = StringUtils.stripAccents((String)name);
            String namePathresized = name_image_without_accent + "_Uber." + ext;
            boolean found = false;
            for (File filelist : listFile) {
                if (!filelist.getName().equalsIgnoreCase(namePathresized)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.mImageUtils.resizeImageUber(file, m_width, m_height);
        }
    }

    private String getNamePathUber(String path) {
        String resizedPath = null;
        if (path != null) {
            String name = path.replaceFirst("[.][^.]+$", "");
            String name_image_without_accent = StringUtils.stripAccents((String)name);
            String ext = path.substring(path.lastIndexOf(".") + 1);
            resizedPath = name_image_without_accent + "_Uber." + ext;
        }
        return resizedPath;
    }

    public List<String> getListPaths(File[] listFile) throws IOException {
        ArrayList<String> Originepaths = new ArrayList<String>();
        for (File filelist : listFile) {
            if (!filelist.exists()) continue;
            String ext = filelist.getName().substring(filelist.getName().lastIndexOf(".") + 1);
            String name = FilenameUtils.removeExtension((String)filelist.getName());
            if (name.endsWith(SIZE_256px) || ext.equals("mp4")) continue;
            Originepaths.add(name + "." + ext);
        }
        return Originepaths;
    }

    public void checkAndAddImageLogo(List<String> listPaths, File[] listFile, String directory) throws IOException {
        for (String path : listPaths) {
            File file = this.mFilerUtils.getFileFullPath(directory + File.separator + path);
            if (!file.exists()) continue;
            String ext = file.getName().substring(file.getName().lastIndexOf(".") + 1);
            String name = FilenameUtils.removeExtension((String)file.getName());
            for (String size : listsizes) {
                String namePathresized = name + size + "." + ext;
                boolean found = false;
                for (File filelist : listFile) {
                    if (!filelist.getName().equalsIgnoreCase(namePathresized)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                String taille = size.substring(1, size.length() - 2);
                this.imageutils.resizeImage(file, "256");
            }
        }
    }

    public void sychroniseItemsSlave() {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ItemService.this.mSynchroService = SynchroService.getInstance(null);
                    ItemService.this.mSynchroService.synchronize(true, false, false);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        });
    }

    public double getPriceProductByType(ProductInfoExt product, String typeOrder, boolean check_opening_mode) {
        double price_product = 0.0;
        if (AppLocal.OPENING_MODE && product.getPrice_opening() != 0.0 && check_opening_mode) {
            System.out.println("+++++++++++++++++++++++ AppLocal.OPENING_MODE" + AppLocal.OPENING_MODE);
            price_product = product.getPrice_opening();
            System.out.println("+++++++++++++++++++++++ price_product+getPrice_opening" + price_product);
        } else if (product.isMany_size() && product.getListSizes().size() > 0 && product.getListSizes().get(0) != null) {
            if (product.isDifferent_price()) {
                if (typeOrder != null) {
                    switch (typeOrder) {
                        case "Sur Place": {
                            price_product = product.getListSizes().get(0).getPrice_sp();
                            System.out.println("+++++++++++++++++++++++ price_product + SP" + price_product);
                            break;
                        }
                        case "A Emporter": {
                            price_product = product.getListSizes().get(0).getPrice_emp();
                            break;
                        }
                        case "Drive": {
                            price_product = product.getListSizes().get(0).getPrice_drive();
                            break;
                        }
                        case "BAR": {
                            price_product = product.getListSizes().get(0).getPrice_bar();
                            break;
                        }
                        case "Delivero": {
                            price_product = product.getListSizes().get(0).getPrice_delivero();
                            break;
                        }
                        case "Happy Hour": {
                            price_product = product.getListSizes().get(0).getPrice_happy_hour();
                            break;
                        }
                        case "Terasse": {
                            price_product = product.getListSizes().get(0).getPrice_terasse();
                            break;
                        }
                        case "Uber Eats": {
                            price_product = product.getListSizes().get(0).getPrice_uber();
                            break;
                        }
                        case "Deliveroo": {
                            price_product = product.getListSizes().get(0).getPrice_delivero();
                            break;
                        }
                        default: {
                            price_product = product.getListSizes().get(0).getPrice();
                            break;
                        }
                    }
                }
            } else {
                price_product = product.getListSizes().get(0).getPrice();
            }
        } else {
            price_product = this.getPriceByType(product, typeOrder);
        }
        return price_product;
    }

    public List<ProductInfoExt> getAdditionnalProducts(String typeOrder) throws BasicException {
        List<ProductInfoExt> products = this.dlItems.getAdditionnalProducts(typeOrder);
        for (ProductInfoExt product : products) {
            product.setListSizes(this.dlItems.getProductSizes(product.getID(), true));
            product.setPrices(this.dlItems.getProductPrices(product.getID(), true));
            List<ImageProduct> images = this.imageProductService.getImages(product.getID());
            product.setImages(images);
            List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product.getID());
            product.setMultiLanguageTexts(multiLanguageTexts);
            NutritionalInfoProduct mNutritionals = this.mNutritionalService.getNutriByProduct(product.getID());
            product.setNutriValues(mNutritionals);
        }
        this.setSizes(products);
        return products;
    }

    public List<ProductPriceInfo> getProductPrices(int idProduct, boolean filter_by_tariff) throws BasicException {
        return this.dlItems.getProductPrices(idProduct, true);
    }

    public List<ProductSizeInfo> getProductSizes(int idProduct, boolean filter_by_tariff) throws BasicException {
        return this.dlItems.getProductSizes(idProduct, true);
    }

    public void synchronizeTags() {
        TagsService mTagsService = TagsService.getInstance();
        List<TagInfo> tags = mTagsService.getTags();
        if (tags != null && !tags.isEmpty()) {
            for (TagInfo tag : tags) {
                this.synchroniseTag(tag);
            }
        }
    }

    public void synchroniseTag(TagInfo tag) {
        if (this.mTagKitchenService == null) {
            this.mTagKitchenService = TagKitchenService.getInstance();
        }
        if (this.mTagKitchenService != null) {
            TagKitchenInfo mTagKitchenInfo = this.mTagKitchenService.findByNumber(tag.getNumber());
            if (mTagKitchenInfo != null) {
                mTagKitchenInfo.setName(tag.getName());
                this.mTagKitchenService.updateTag(mTagKitchenInfo);
            } else if (!tag.isDeleted()) {
                TagKitchenInfo newTagKitchenInfo = new TagKitchenInfo();
                newTagKitchenInfo.setName(tag.getName());
                newTagKitchenInfo.setNumber(tag.getNumber());
                this.mTagKitchenService.addTagKitchen(newTagKitchenInfo);
            }
        }
    }

    public String getIdGlobalPrefix() {
        AppLocal.PREFIX_ID_GLOBAL = "";
        try {
            MarqueNFC marque = MarqueNFC.fetchOrStore(this.dlSales);
            if (marque != null && marque.getCompany() != null && !marque.getCompany().isEmpty()) {
                String[] arrayCompany = marque.getCompany().split(" ");
                StringBuilder prefixBuilder = new StringBuilder();
                for (String companyText : arrayCompany) {
                    prefixBuilder.append(companyText.substring(0, 1));
                }
                AppLocal.PREFIX_ID_GLOBAL = prefixBuilder.toString().toUpperCase();
            }
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return AppLocal.PREFIX_ID_GLOBAL;
    }

    public List<ProductInfoExt> getPromotionProducts(PromotionInfo promotion, String type) throws BasicException {
        ArrayList<ProductInfoExt> productsResult = new ArrayList<ProductInfoExt>();
        List<ProductInfoExt> products = this.dlItems.getPromotionProducts(promotion.getId(), type);
        this.setSizes(products);
        for (ProductInfoExt product : products) {
            boolean checkSize = false;
            boolean sizeExist = false;
            if (promotion.getSize_product() != null && !promotion.getSize_product().isEmpty()) {
                checkSize = true;
                for (ProductSizeInfo size : product.getListSizes()) {
                    if (!size.getName().equals(promotion.getSize_product())) continue;
                    sizeExist = true;
                    break;
                }
            }
            if (checkSize && !sizeExist) continue;
            if (product.getAdditional_sales() != null && !product.getAdditional_sales().isEmpty()) {
                this.setSizes(product.getAdditional_sales());
            }
            productsResult.add(product);
        }
        return productsResult;
    }

    public List<CategoryInfo> getNotRemovedCategories() {
        ArrayList<CategoryInfo> categories = new ArrayList();
        try {
            categories = AppLocal.dlItems.getCategories(true, true, false);
        }
        catch (BasicException ex) {
            ex.printStackTrace();
            return null;
        }
        return categories;
    }

    public static List<ProductInfoExt> getNotRemovedProducts() {
        ArrayList<ProductInfoExt> products = new ArrayList();
        try {
            products = AppLocal.dlItems.getAllItems(true, true);
        }
        catch (BasicException ex) {
            ex.printStackTrace();
            return null;
        }
        return products;
    }

    public static List<SupplementInfo> getNotRemovedSupplements() {
        ArrayList<SupplementInfo> supplements = new ArrayList();
        try {
            supplements = AppLocal.dlItems.getAllSupplements(true);
        }
        catch (BasicException ex) {
            ex.printStackTrace();
            return null;
        }
        return supplements;
    }

    public static List<CarteInfo> getNotRemovedCartes() {
        ArrayList<CarteInfo> cartes = new ArrayList();
        try {
            cartes = AppLocal.dlItems.getAllCartes(true);
        }
        catch (BasicException ex) {
            ex.printStackTrace();
            return null;
        }
        return cartes;
    }

    public static List<CarteMenu> getCarteMenu() {
        List<CarteMenu> carteMenu;
        try {
            carteMenu = AppLocal.dlItems.getCarteMenus();
        }
        catch (BasicException ex) {
            ex.printStackTrace();
            return null;
        }
        return carteMenu;
    }

    public static List<GroupSubSupplementInfo> getNotRemovedGroupsSubOptions() {
        ArrayList<GroupSubSupplementInfo> groupsSubOptions = new ArrayList();
        try {
            groupsSubOptions = AppLocal.dlItems.getAllGroupsSubSupplements(true);
        }
        catch (BasicException ex) {
            ex.printStackTrace();
            return null;
        }
        return groupsSubOptions;
    }

    public static List<PromotionInfo> getNotRemovedPromotionsProduct() {
        ArrayList<PromotionInfo> promotions = new ArrayList();
        try {
            promotions = AppLocal.dlItems.getPromotions(false);
        }
        catch (BasicException ex) {
            ex.printStackTrace();
            return null;
        }
        return promotions;
    }

    public void setIdGlobalItems() {
        try {
            System.out.println("++++++++++++++ setIdGlobalItems start ******************* : " + new Date());
            List<ProductInfoExt> products = this.dlItems.getProductsWithoutFilter();
            List<CategoryInfo> categories = this.dlItems.getCategoriesWithoutFilter();
            List<SupplementInfo> supplements = this.dlItems.getSupplementsWithoutFilter();
            List<SupplementItemInfo> supplementsItems = this.dlItems.getSupplementItemsWithoutFilter();
            List<CarteInfo> cartes = this.dlItems.getCartesWithoutFilter();
            List<GroupSubSupplementInfo> groupSubSupplements = this.dlItems.getAllGroupsSubSupplementsWithoutFilter();
            List<PromotionInfo> promotions = this.dlItems.getPromotionsWithoutFilter();
            for (CategoryInfo category : categories) {
                this.dlItems.setIdGlobalItem(category.getID(), "CATEGORIES", "ID_GLOBAL", category.getId_global());
            }
            for (ProductInfoExt product : products) {
                this.dlItems.setIdGlobalItem(product.getID(), "PRODUCTS", "PRODUCT_PLU", product.getId_global());
            }
            for (SupplementInfo supplement : supplements) {
                this.dlItems.setIdGlobalItem(supplement.getiD(), "SUPPLEMENT", "ID_GLOBAL", supplement.getId_global());
            }
            for (SupplementItemInfo supplementItem : supplementsItems) {
                this.dlItems.setIdGlobalItem(supplementItem.getiD(), "SUPPLEMENT_ITEM", "ITEM_PLU", supplementItem.getId_global());
            }
            for (CarteInfo carteInfo : cartes) {
                this.dlItems.setIdGlobalItem(carteInfo.getId(), "CARTE", "ID_GLOBAL", carteInfo.getId_global());
            }
            for (GroupSubSupplementInfo groupSubSupplement : groupSubSupplements) {
                this.dlItems.setIdGlobalItem(groupSubSupplement.getId(), "GROUPE_SUB_SUPPLEMENTS", "ID_GLOBAL", groupSubSupplement.getId_global());
            }
            for (PromotionInfo promotion : promotions) {
                this.dlItems.setIdGlobalItem(promotion.getId(), "PROMOTIONS", "ID_GLOBAL", promotion.getId_global());
            }
            System.out.println("++++++++++++++ setIdGlobalItems end ******************* : " + new Date());
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void sychroniseItemsAndImages() {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ItemService.this.mSynchroService = SynchroService.getInstance(null);
                    ItemService.this.mSynchroService.sendItemsAndImages();
                    ItemService.this.uploadItems(true);
                    ItemService.this.uploadItemsUberEats(true);
                    if (AppLocal.KITCHEN_COMPOSITE) {
                        ItemService.this.synchronizeTags();
                    }
                }
                catch (IOException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        });
    }

    public boolean checkIfLaterItemsExist(TicketInfo ticket) throws BasicException {
        boolean items_later_exist = false;
        for (TicketLineInfo line : ticket.getLines()) {
            if (line.isProduct_later()) {
                items_later_exist = true;
            }
            for (OptionItemOrder supplement : line.getListSupplements()) {
                ProductInfoExt subProduct;
                if (supplement.getId_sub_product() == 0 || (subProduct = this.dlItems.getProductInfoById(supplement.getId_sub_product())) == null || !subProduct.isLater()) continue;
                supplement.setOption_later(true);
                items_later_exist = true;
            }
        }
        return items_later_exist;
    }

    public List<ProductInfoExt> setSoldOutIngredient(int ingredient_id, boolean sold_out) {
        ArrayList<ProductInfoExt> products = new ArrayList<ProductInfoExt>();
        try {
            this.dlItems.setSoldOutIngredient(ingredient_id, sold_out);
            if (sold_out) {
                List<ProductInfoExt> productSoldOut = this.setSoldOutProductsByIngredient(ingredient_id);
                products.addAll(productSoldOut);
            } else {
                List<ProductInfoExt> productsVisible = this.setVisibleProductsByIngredient(ingredient_id);
                products.addAll(productsVisible);
            }
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return products;
    }

    public void changeStatusIngredient(int ingredient_id, boolean hidden, String id_global) throws BasicException {
        this.dlItems.updateStatusIngredient(ingredient_id, hidden, id_global);
        AppLocal.product_management = true;
        this.support.firePropertyChange("reload", null, null);
    }

    public void sychroniseIngredient(final SupplementItemInfo ingredient, final boolean synchronise_local, final boolean upload_online) {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (synchronise_local) {
                        ItemService.this.mSynchroService = SynchroService.getInstance(null);
                        ItemService.this.mSynchroService.sendStatuIngredient(ingredient);
                    }
                    ItemService.this.uploadItems(upload_online);
                }
                catch (IOException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        });
    }

    public List<ProductInfoExt> setSoldOutProductsByIngredient(int ingredient_id) throws BasicException {
        List<ProductInfoExt> productsByIngredient = this.dlItems.getProductsByIngredients(ingredient_id);
        ArrayList<ProductInfoExt> productsBySubProducts = new ArrayList<ProductInfoExt>();
        for (ProductInfoExt product : productsByIngredient) {
            List<ProductInfoExt> productsBySubProduct = this.setSoldOutAndHidden(product.getID(), true);
            productsBySubProducts.addAll(productsBySubProduct);
            product.setSold_out(true);
            product.setHidden_borne(true);
            product.setHidden_online(true);
            product.setHidden_platform(true);
        }
        productsByIngredient.addAll(productsBySubProducts);
        return productsByIngredient;
    }

    public List<ProductInfoExt> setVisibleProductsByIngredient(int ingredient_id) throws BasicException {
        List<ProductInfoExt> productsByIngredient = this.dlItems.getSoldOutProductsByIngredients(ingredient_id);
        ArrayList<ProductInfoExt> productsBySubProducts = new ArrayList<ProductInfoExt>();
        for (ProductInfoExt product : productsByIngredient) {
            List<ProductInfoExt> productsBySubProduct = this.setSoldOutAndHidden(product.getID(), false);
            productsBySubProducts.addAll(productsBySubProduct);
            product.setSold_out(false);
            product.setHidden_borne(false);
            product.setHidden_online(false);
            product.setHidden_platform(false);
        }
        productsByIngredient.addAll(productsBySubProducts);
        return productsByIngredient;
    }

    private List<ProductInfoExt> setSoldOutProducts(int product_id) throws BasicException {
        List<ProductInfoExt> products = this.dlItems.getSuperProducts(product_id);
        for (ProductInfoExt product : products) {
            product.setSold_out(true);
            this.dlItems.setSoldOutAndHidden(product.getID(), true);
        }
        return products;
    }

    private List<ProductInfoExt> setVisibleProductsBySubProduct(int id_sub_product) throws BasicException {
        List<ProductInfoExt> products = this.dlItems.getSuperProductsSoldOut(id_sub_product);
        for (ProductInfoExt product : products) {
            this.dlItems.setSoldOutAndHidden(product.getID(), false);
            product.setSold_out(false);
            product.setHidden_borne(false);
            product.setHidden_online(false);
            product.setHidden_platform(false);
        }
        return products;
    }

    public void synchronizeItems(final List<ProductInfoExt> products, final List<SupplementItemInfo> ingredients, final List<SupplementItemInfo> options) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ItemService.this.mSynchroService = SynchroService.getInstance(null);
                    List<StatusItem> statusItems = ItemService.this.getListStatusItems(products, ingredients, options);
                    ItemService.this.mSynchroService.sendStatusItems(statusItems);
                    ItemService.this.uploadItems(true);
                    ItemService.this.uploadItemsUberEats(false);
                    ItemService.this.setStatusItemsDeleviroo(products, options);
                }
                catch (IOException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }).start();
    }

    private List<StatusItem> getListStatusItems(List<ProductInfoExt> products, List<SupplementItemInfo> ingredients, List<SupplementItemInfo> options) {
        ArrayList<StatusItem> statusItems = new ArrayList<StatusItem>();
        for (ProductInfoExt product : products) {
            statusItems.add(new StatusItem(product.getID(), "product", product.isSold_out(), product.isSold_out_temporary(), product.getId_global()));
        }
        for (SupplementItemInfo ingredient : ingredients) {
            statusItems.add(new StatusItem(ingredient.getiD(), "ingredient", ingredient.isSold_out(), false, ingredient.getId_global()));
        }
        for (SupplementItemInfo option : options) {
            statusItems.add(new StatusItem(option.getiD(), "option", option.isSold_out(), false, option.getId_global()));
        }
        return statusItems;
    }

    private JSONArray getJsonUnavailabilities(List<ProductInfoExt> products, List<SupplementItemInfo> options) {
        JSONObject jsonItem;
        String status;
        JSONArray itemUnavailabilities = new JSONArray();
        for (ProductInfoExt product : products) {
            String id_product;
            String string = id_product = product.getId_global() != null && !product.getId_global().isEmpty() ? AppLocal.PREFIX_PRODUCT_NEW + product.getId_global() : AppLocal.PREFIX_PRODUCT + product.getID();
            if (AppLocal.LIST_ITEMS_DELIVEROO == null || !AppLocal.LIST_ITEMS_DELIVEROO.contains(id_product)) continue;
            status = product.isSold_out() ? "unavailable" : "available";
            jsonItem = new JSONObject();
            jsonItem.put("item_id", (Object)id_product);
            jsonItem.put("status", (Object)status);
            itemUnavailabilities.put((Object)jsonItem);
        }
        for (SupplementItemInfo option : options) {
            String id_option;
            String string = id_option = option.getId_global() != null && !option.getId_global().isEmpty() ? AppLocal.PREFIX_OPTION_NEW + option.getId_global() : AppLocal.PREFIX_OPTION + option.getiD();
            if (AppLocal.LIST_ITEMS_DELIVEROO == null || !AppLocal.LIST_ITEMS_DELIVEROO.contains(id_option)) continue;
            status = option.isSold_out() ? "unavailable" : "available";
            jsonItem = new JSONObject();
            jsonItem.put("item_id", (Object)id_option);
            jsonItem.put("status", (Object)status);
            itemUnavailabilities.put((Object)jsonItem);
        }
        return itemUnavailabilities;
    }

    public void setStatusItemsDeleviroo(final List<ProductInfoExt> products, final List<SupplementItemInfo> options) {
        if (AppLocal.MODULE_DELIVERO) {
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (ItemService.this.mDeliveroService == null) {
                            ItemService.this.mDeliveroService = DeliveroService.getInstance();
                        }
                        ItemService.this.mDeliveroService.getMenu();
                        JSONArray itemUnavailabilities = ItemService.this.getJsonUnavailabilities(products, options);
                        ItemService.this.mDeliveroService.setItemsUnavailabilities(itemUnavailabilities);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            });
        }
    }

    public void changeStatusItems(List<StatusItem> statusItems) throws BasicException {
        for (StatusItem statusItem : statusItems) {
            System.out.println("statusItem : " + statusItem);
            if (statusItem == null || statusItem.getType_item() == null) continue;
            switch (statusItem.getType_item()) {
                case "product": {
                    this.dlItems.setSoldOutProductVyIdGlobal(statusItem.getId_item(), statusItem.isSold_out(), statusItem.getId_global());
                    break;
                }
                case "option": {
                    this.dlItems.setSoldOutOptionByIdGlobal(statusItem.getId_item(), statusItem.isSold_out(), statusItem.getId_global());
                    break;
                }
                case "ingredient": {
                    this.dlItems.updateStatusIngredient(statusItem.getId_item(), statusItem.isSold_out(), statusItem.getId_global());
                }
            }
        }
        AppLocal.product_management = true;
        this.support.firePropertyChange("reload", null, null);
    }

    public void updateProductByLanguage(ProductInfoExt product) {
        if (AppLocal.APP_LANGUAGE != null && !AppLocal.APP_LANGUAGE.isEmpty()) {
            this.multiLanguageProductService.setMultiLanguageProduct(product.getName(), product.getDescription(), product.getDescription_uberEat(), product.getID(), AppLocal.APP_LANGUAGE);
        }
    }

    public void updateNameCategoryByLanguage(CategoryInfo category) {
        if (AppLocal.APP_LANGUAGE != null && !AppLocal.APP_LANGUAGE.isEmpty()) {
            this.multiLanguageCategoryService.setMultiLanguageCategory(category.getName(), category.getID(), AppLocal.APP_LANGUAGE);
        }
    }

    public void updateNameSupplementByLanguage(SupplementInfo supplement) {
        if (AppLocal.APP_LANGUAGE != null && !AppLocal.APP_LANGUAGE.isEmpty()) {
            this.multiLanguageSupplementService.setMultiLanguageSupplement(supplement.getName(), supplement.getiD(), AppLocal.APP_LANGUAGE);
        }
    }

    public void updateNameSupplementItemByLanguage(SupplementItemInfo supplementItem) {
        if (AppLocal.APP_LANGUAGE != null && !AppLocal.APP_LANGUAGE.isEmpty()) {
            this.multiLanguageSupplementItemService.setMultiLanguageSupplementItem(supplementItem.getName(), supplementItem.getiD(), AppLocal.APP_LANGUAGE);
        }
    }

    public void updatePromotionByLanguage(PromotionInfo promotionInfo) {
        if (AppLocal.APP_LANGUAGE != null && !AppLocal.APP_LANGUAGE.isEmpty()) {
            this.multiLanguagePromotionService.setMultiLanguagePromotion(promotionInfo.getName_promotion(), promotionInfo.getDescription(), promotionInfo.getText_promo(), promotionInfo.getId(), AppLocal.APP_LANGUAGE);
        }
    }

    public void updateCarteByLanguage(CarteInfo carteInfo) {
        if (AppLocal.APP_LANGUAGE != null && !AppLocal.APP_LANGUAGE.isEmpty()) {
            this.multiLanguageCarteService.setMultiLanguageCarte(carteInfo.getName(), carteInfo.getId(), AppLocal.APP_LANGUAGE);
        }
    }

    public void updateGSSByLanguage(GroupSubSupplementInfo groupSubSupplementInfo) {
        if (AppLocal.APP_LANGUAGE != null && !AppLocal.APP_LANGUAGE.isEmpty()) {
            this.multiLanguageGSSService.setMultiLanguageGSS(groupSubSupplementInfo.getName_group(), groupSubSupplementInfo.getTitle_group(), groupSubSupplementInfo.getId(), AppLocal.APP_LANGUAGE);
        }
    }

    public void setSoldOutOption(int option_id, boolean sold_out) {
        try {
            this.dlItems.setSoldOutOption(option_id, sold_out);
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public List<ProductInfoExt> setSoldOut(int product_id, boolean sold_out) {
        ArrayList<ProductInfoExt> products = new ArrayList<ProductInfoExt>();
        try {
            this.dlItems.setSoldOut(product_id, sold_out);
            if (sold_out) {
                List<ProductInfoExt> productToSetSoldOut = this.setSoldOutProducts(product_id);
                products.addAll(productToSetSoldOut);
            } else {
                List<ProductInfoExt> productToSetVisible = this.setVisibleProductsBySubProduct(product_id);
                products.addAll(productToSetVisible);
            }
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return products;
    }

    public double calculateNightTariffPrice(double price) {
        if (AppLocal.HOUR_START_NIGHT_TARIFF != null && !AppLocal.HOUR_START_NIGHT_TARIFF.isEmpty() && AppLocal.HOUR_END_NIGHT_TARIFF != null && !AppLocal.HOUR_END_NIGHT_TARIFF.isEmpty() && DateUtils.isCurrentTimeBetween(AppLocal.HOUR_START_NIGHT_TARIFF, AppLocal.HOUR_END_NIGHT_TARIFF) && AppLocal.PERCENTAGE_NIGHT_TARIFF != 0) {
            return price + price * (double)AppLocal.PERCENTAGE_NIGHT_TARIFF / 100.0;
        }
        return price;
    }

    static {
        listsizes = new ArrayList<String>();
        tagslistsizes = new ArrayList<String>();
    }
}

