/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.service;

import com.openbravo.basic.BasicException;
import com.openbravo.dao.DataLogicOrder;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.SignatureGenerator;
import com.openbravo.service.ArchivageService;
import fr.protactile.norm.beans.ArchivPeriode;
import fr.protactile.norm.beans.Duplicata;
import fr.protactile.norm.beans.EnteteInfo;
import fr.protactile.norm.beans.Facture;
import fr.protactile.norm.beans.GrandTotalPeriode;
import fr.protactile.norm.beans.GrandTotalTicket;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IntegrityCheacker {
    private DataLogicOrder dlOrder;
    private DataLogicSales dlSales;

    public IntegrityCheacker(DataLogicOrder dlOrder, DataLogicSales dlSales) {
        this.dlOrder = dlOrder;
        this.dlSales = dlSales;
    }

    public List<String> cheackEnteteBetween(Date dateStart, Date dateEnd) throws SQLException, BasicException, IOException {
        List<EnteteInfo> entetes = this.dlOrder.getEnteteBetween(dateStart, dateEnd);
        ArrayList<String> errors = new ArrayList<String>();
        StringBuilder errorsString = new StringBuilder();
        boolean isFirst = true;
        if (entetes.size() > 0) {
            EnteteInfo previousSigned = entetes.get(0);
            for (EnteteInfo ligne : entetes) {
                if (!isFirst && ligne.getGrandTotalTicket() != null) {
                    String emprinte = ligne.getEmprinteWithoutPreviousSignature() + ",O," + previousSigned.getSignature();
                    System.out.println("emprinte : " + emprinte);
                    boolean verify = this.verifySignature(emprinte, ligne.getSignature(), ligne.getTimestampGDH());
                    if (!verify) {
                        errors.add(ligne.getObjectAsString());
                        errorsString.append(ligne.getId()).append(" ");
                    }
                }
                isFirst = false;
                previousSigned = ligne;
            }
        }
        System.out.println("+++++++ errors entete : " + errors);
        return errors;
    }

    public List<String> cheackFacturesBetween(Date dateStart, Date dateEnd) throws SQLException, IOException, BasicException {
        List<Facture> factures = this.dlSales.getFacturesBetween(dateStart, dateEnd);
        StringBuilder errors = new StringBuilder();
        ArrayList<String> errorsFactures = new ArrayList<String>();
        boolean isFirst = true;
        if (factures.size() > 0) {
            Facture previousSigned = factures.get(0);
            for (Facture ligne : factures) {
                String emprinte;
                boolean verify;
                if (!isFirst && !(verify = this.verifySignature(emprinte = ligne.getEmprinteWithoutPreviousSignature() + ",O," + previousSigned.getSignature(), ligne.getSignature(), ligne.getDateFacture()))) {
                    errors.append(ligne.getId() + " ");
                    errorsFactures.add(ligne.toString());
                }
                isFirst = false;
                previousSigned = ligne;
            }
        }
        System.out.println("+++++++ errors facture : " + errorsFactures);
        return errorsFactures;
    }

    public List<String> cheackDuplicatasBetween(Date dateStart, Date dateEnd) throws SQLException, IOException, BasicException {
        ArrayList<String> errors = new ArrayList<String>();
        List<Duplicata> duplicatas = this.dlOrder.getDuplicataByPeriode(dateStart, dateEnd);
        List<String> errorsDuplicatat = this.cheackDuplicatas(duplicatas);
        errors.addAll(errorsDuplicatat);
        List<Duplicata> duplicatasTicket = this.dlOrder.getDuplicataByPeriodeAndTypeDoc(dateStart, dateEnd, "Ticket");
        List<String> errorsDuplicatatTicket = this.cheackDuplicatas(duplicatasTicket);
        errors.addAll(errorsDuplicatatTicket);
        List<Duplicata> duplicatasFacture = this.dlOrder.getDuplicataByPeriodeAndTypeDoc(dateStart, dateEnd, "Facture");
        List<String> errorsDuplicatatFacture = this.cheackDuplicatas(duplicatasFacture);
        errors.addAll(errorsDuplicatatFacture);
        return errors;
    }

    public List<String> cheackDuplicatas(List<Duplicata> duplicatas) throws SQLException, IOException, BasicException {
        ArrayList<String> errorsDuplicatas = new ArrayList<String>();
        boolean isFirst = true;
        if (duplicatas.size() > 0) {
            Duplicata previousSigned = duplicatas.get(0);
            for (Duplicata ligne : duplicatas) {
                String emprinte;
                boolean verify;
                if (!isFirst && !(verify = this.verifySignature(emprinte = ligne.getEmprintWithoutSignature() + ",O," + previousSigned.getSignature(), ligne.getSignature(), ligne.getDate_impression()))) {
                    errorsDuplicatas.add(ligne.toString());
                }
                isFirst = false;
                previousSigned = ligne;
            }
        }
        System.out.println("+++++++ errors duplicatat : " + errorsDuplicatas);
        return errorsDuplicatas;
    }

    public List<String> cheackGrandTotalTicketsBetween(Date dateStart, Date dateEnd) throws SQLException, IOException, BasicException {
        List<GrandTotalTicket> gTTickets = this.dlOrder.getGrandTotalTicketBetween(dateStart, dateEnd);
        StringBuilder errors = new StringBuilder();
        ArrayList<String> errorsGrandTotalTickets = new ArrayList<String>();
        boolean isFirst = true;
        if (gTTickets.size() > 0) {
            GrandTotalTicket previousSigned = gTTickets.get(0);
            for (GrandTotalTicket ligne : gTTickets) {
                String emprinte;
                boolean verify;
                if (!isFirst && !(verify = this.verifySignature(emprinte = ligne.getEmprinteWithoutPreviousSignature() + ",O," + previousSigned.getSignature(), ligne.getSignature(), ligne.getTimestampGDH()))) {
                    errors.append(ligne.getId() + " ");
                    errorsGrandTotalTickets.add(ligne.toString());
                }
                isFirst = false;
                previousSigned = ligne;
            }
        }
        System.out.println("+++++++ errors GT : " + errorsGrandTotalTickets);
        return errorsGrandTotalTickets;
    }

    public List<String> cheackGrandTotalPeriodeBetween(Date dateStart, Date dateEnd) throws SQLException, IOException, BasicException {
        List<GrandTotalPeriode> gTjours = this.dlOrder.getGrandTotalPeriodeBetween("j", dateStart, dateEnd);
        StringBuilder errors = new StringBuilder();
        ArrayList<String> errorsGrandTotalPeriodes = new ArrayList<String>();
        boolean isFirst = true;
        if (gTjours.size() > 0) {
            GrandTotalPeriode previousSigned = gTjours.get(0);
            for (GrandTotalPeriode grandTotalPeriode : gTjours) {
                String emprinte;
                boolean verify;
                if (!isFirst && !(verify = this.verifySignature(emprinte = grandTotalPeriode.getEmprinteWithoutPreviousSignature() + ",O," + previousSigned.getSignature(), grandTotalPeriode.getSignature(), grandTotalPeriode.getTimestampGDH()))) {
                    errors.append(grandTotalPeriode.getId() + " ");
                    errorsGrandTotalPeriodes.add(grandTotalPeriode.toString());
                }
                isFirst = false;
                previousSigned = grandTotalPeriode;
            }
        }
        List<GrandTotalPeriode> gTMois = this.dlOrder.getGrandTotalPeriodeBetween("m", dateStart, dateEnd);
        isFirst = true;
        if (gTMois.size() > 0) {
            GrandTotalPeriode previousSigned = gTMois.get(0);
            for (GrandTotalPeriode ligne : gTMois) {
                String emprinte;
                boolean verify;
                if (!isFirst && !(verify = this.verifySignature(emprinte = ligne.getEmprinteWithoutPreviousSignature() + ",O," + previousSigned.getSignature(), ligne.getSignature(), ligne.getTimestampGDH()))) {
                    errors.append(ligne.getId() + " ");
                    errorsGrandTotalPeriodes.add(ligne.toString());
                }
                isFirst = false;
                previousSigned = ligne;
            }
        }
        List<GrandTotalPeriode> gTAnnees = this.dlOrder.getGrandTotalPeriodeBetween("a", dateStart, dateEnd);
        isFirst = true;
        if (gTAnnees.size() > 0) {
            GrandTotalPeriode previousSigned = gTAnnees.get(0);
            for (GrandTotalPeriode ligne : gTAnnees) {
                String string;
                boolean verify;
                if (!isFirst && !(verify = this.verifySignature(string = ligne.getEmprinteWithoutPreviousSignature() + ",O," + previousSigned.getSignature(), ligne.getSignature(), ligne.getTimestampGDH()))) {
                    errors.append(ligne.getId() + " ");
                    errorsGrandTotalPeriodes.add(ligne.toString());
                }
                isFirst = false;
                previousSigned = ligne;
            }
        }
        System.out.println("+++++++ errors GTP : " + errorsGrandTotalPeriodes);
        return errorsGrandTotalPeriodes;
    }

    public List<String> cheackArchivPeriodeBetween(Date dateStart, Date dateEnd) throws SQLException, IOException, BasicException {
        List<ArchivPeriode> gTjours = this.dlOrder.getArchivPeriodeBetween("j", dateStart, dateEnd);
        StringBuilder errors = new StringBuilder();
        ArrayList<String> errorsGrandTotalPeriodes = new ArrayList<String>();
        boolean isFirst = true;
        if (gTjours.size() > 0) {
            ArchivPeriode previousSigned = gTjours.get(0);
            for (ArchivPeriode archivPeriode : gTjours) {
                String emprinte;
                boolean verify;
                if (!isFirst && !(verify = this.verifySignature(emprinte = archivPeriode.getEmprinteWithoutPreviousSignature() + ",O," + previousSigned.getSignature(), archivPeriode.getSignature(), archivPeriode.getTimestampGDH()))) {
                    errors.append(archivPeriode.getId() + " ");
                    errorsGrandTotalPeriodes.add(archivPeriode.toString());
                }
                isFirst = false;
                previousSigned = archivPeriode;
            }
        }
        List<ArchivPeriode> gTMois = this.dlOrder.getArchivPeriodeBetween("m", dateStart, dateEnd);
        isFirst = true;
        if (gTMois.size() > 0) {
            ArchivPeriode previousSigned = gTMois.get(0);
            for (ArchivPeriode ligne : gTMois) {
                String emprinte;
                boolean verify;
                if (!isFirst && !(verify = this.verifySignature(emprinte = ligne.getEmprinteWithoutPreviousSignature() + ",O," + previousSigned.getSignature(), ligne.getSignature(), ligne.getTimestampGDH()))) {
                    errors.append(ligne.getId() + " ");
                    errorsGrandTotalPeriodes.add(ligne.toString());
                }
                isFirst = false;
                previousSigned = ligne;
            }
        }
        List<ArchivPeriode> gTAnnees = this.dlOrder.getArchivPeriodeBetween("a", dateStart, dateEnd);
        isFirst = true;
        if (gTAnnees.size() > 0) {
            ArchivPeriode previousSigned = gTAnnees.get(0);
            for (ArchivPeriode ligne : gTAnnees) {
                String string;
                boolean verify;
                if (!isFirst && !(verify = this.verifySignature(string = ligne.getEmprinteWithoutPreviousSignature() + ",O," + previousSigned.getSignature(), ligne.getSignature(), ligne.getTimestampGDH()))) {
                    errors.append(ligne.getId() + " ");
                    errorsGrandTotalPeriodes.add(ligne.toString());
                }
                isFirst = false;
                previousSigned = ligne;
            }
        }
        System.out.println("+++++++ errors archive : " + errorsGrandTotalPeriodes);
        return errorsGrandTotalPeriodes;
    }

    public List<String> cheackDataBeween(Date dateStart, Date dateEnd) throws SQLException, BasicException, IOException {
        ArrayList<String> errors = new ArrayList<String>();
        errors.addAll(this.cheackEnteteBetween(dateStart, dateEnd));
        errors.addAll(this.cheackFacturesBetween(dateStart, dateEnd));
        errors.addAll(this.cheackDuplicatasBetween(dateStart, dateEnd));
        errors.addAll(this.cheackGrandTotalPeriodeBetween(dateStart, dateEnd));
        System.out.println("+++++++++++++ errors : " + errors);
        return errors;
    }

    public boolean isDBIntegrityCorrectBetween(Date dateStart, Date dateEnd) {
        try {
            return this.cheackDataBeween(dateStart, dateEnd).isEmpty();
        }
        catch (SQLException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        catch (IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return false;
    }

    public boolean verifySignature(String data, String signature, Date dateSignature) {
        try {
            SignatureGenerator generator = SignatureGenerator.getGenerator();
            return generator.verifySignature(data, signature, dateSignature);
        }
        catch (Exception ex) {
            Logger.getLogger(ArchivageService.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }
}

