/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.service;

import com.openbravo.basic.BasicStorage;
import com.openbravo.beans.CarteMenu;
import com.openbravo.beans.DateUtils;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.ticket.CarteInfo;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.GroupSubSupplementInfo;
import com.openbravo.pos.ticket.MenuDishopBuilder;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.PromotionInfo;
import com.openbravo.pos.ticket.SupplementInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketInfoBuilder;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.ItemService;
import com.openbravo.service.TicketService;
import fr.protactile.procaisse.dao.entities.InfoDishop;
import fr.protactile.procaisse.dao.impl.InfoDishopDao;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.emitter.Emitter;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URISyntaxException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DishopService {
    private static DishopService m_instance;
    private ItemService mItemService;
    private String location_id;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private InfoDishop mInfoDishop;
    private InfoDishopDao mInfoDishopDao = new InfoDishopDao();
    private TicketService mTicketService;
    private final String URL_UPLOAD_MENU = "https://dishop.biborne.com/dishops";
    private final String URL_GET_MENU = "https://dishop.biborne.com/dishops/getJsonByStoreId/";
    private String URL_DELETE_MENU = "https://dishop.biborne.com/dishops/DeletetJsonByStoreId/";
    private String URL_GET_ORDERS = "https://dishop.biborne.com/dishops/v1/findAllOrderWithDates/";
    private String URL_CHANGE_STATUS = "https://dishop.biborne.com/dishops/orders/";
    private String TOKEN = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZCI6MSwibmFtZSI6IkFiZG91bGF5ZSBTYW1iIiwiZW1haWwiOiJhYmRvdWxheWUuc2FtYkBiaWJvcm5lLmNvbSIsImFkbWluIjp0cnVlLCJpYXQiOjE2NzE1MzIwMDYsImV4cCI6MzE3MjE1OTc0NDA2fQ.BIcGho2dtP4vEAl5fav4UFFZapHPqHij0lS5s_ZFgrA";
    private AppView m_App;
    private Date dateStart;
    private Date dateEnd;

    public static DishopService getInstance() {
        if (m_instance == null) {
            m_instance = new DishopService();
        }
        return m_instance;
    }

    private DishopService() {
        this.loadInfoDishop();
        this.mTicketService = TicketService.getInstance();
        this.mItemService = ItemService.getInstance();
        this.m_App = (AppView)BasicStorage.getObject("APP_ROOT_INSTANCE");
    }

    private void loadInfoDishop() {
        this.mInfoDishop = this.mInfoDishopDao.firstElement();
        if (this.mInfoDishop != null) {
            this.location_id = this.mInfoDishop.getLocation_id();
        } else {
            this.mInfoDishop = new InfoDishop();
            this.mInfoDishopDao.addDishopInfo(this.mInfoDishop);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.support.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.support.removePropertyChangeListener(pcl);
    }

    public void connect() throws URISyntaxException {
        System.out.println("connect dishop++++++++++++++++++++++ location_id : " + this.location_id);
        if (this.location_id != null && !this.location_id.isEmpty()) {
            Socket socket = IO.socket((String)"http://45.76.44.106:7001");
            socket.connect();
            socket.on(this.location_id, new Emitter.Listener(){

                public void call(Object ... args) {
                    boolean addOrder;
                    JSONObject jsonObject = (JSONObject)args[0];
                    System.out.println("+++++++++++ jsonObject : " + jsonObject);
                    int number_orders = DishopService.this.getNumberOrders();
                    boolean bl = addOrder = number_orders == 1 && (AppLocal.AUTO_PRINT_DISHOP || DishopService.this.m_App.getAppUserView() == null || DishopService.this.m_App.getAppUserView().getUser() == null);
                    if (addOrder && DishopService.this.mTicketService.isValidPeriodWithoutAlert()) {
                        DishopService.this.mTicketService.saveAndPrintDishopTicket(jsonObject);
                    } else {
                        DishopService.this.sentInfoOrders(number_orders, jsonObject);
                    }
                }
            });
        }
    }

    public void sentInfoOrders(int number_orders, JSONObject order) {
        Object[] info_orders = new Object[2];
        info_orders[1] = number_orders;
        info_orders[0] = order;
        System.out.println("number_orders sentInfoOrders; " + number_orders);
        this.support.firePropertyChange("dishop_order", null, info_orders);
    }

    public String getLocationID() {
        if (this.mInfoDishop == null) {
            this.mInfoDishop = this.mInfoDishopDao.firstElement();
        }
        if (this.mInfoDishop != null) {
            return this.mInfoDishop.getLocation_id();
        }
        return null;
    }

    public void setLocationID(String location_id) throws IOException {
        if (this.mInfoDishop == null) {
            this.mInfoDishop = this.mInfoDishopDao.firstElement();
        }
        if (this.mInfoDishop != null) {
            this.mInfoDishop.setLocation_id(location_id);
            this.mInfoDishopDao.setLocationId(this.mInfoDishop);
        } else {
            this.mInfoDishop = new InfoDishop();
            this.mInfoDishop.setLocation_id(location_id);
            this.mInfoDishopDao.addDishopInfo(this.mInfoDishop);
        }
    }

    public String uploadMenu() throws IOException {
        if (this.location_id != null && !this.location_id.isEmpty()) {
            List<CategoryInfo> categories = this.mItemService.getNotRemovedCategories();
            DishopService dishopService = this;
            List<ProductInfoExt> products = dishopService.mItemService.getNotRemovedProducts();
            DishopService dishopService2 = this;
            List<SupplementInfo> options = dishopService2.mItemService.getNotRemovedSupplements();
            DishopService dishopService3 = this;
            List<CarteInfo> cartes = dishopService3.mItemService.getNotRemovedCartes();
            DishopService dishopService4 = this;
            List<CarteMenu> cartesMenu = dishopService4.mItemService.getCarteMenu();
            DishopService dishopService5 = this;
            List<GroupSubSupplementInfo> groupsSubSupplements = dishopService5.mItemService.getNotRemovedGroupsSubOptions();
            DishopService dishopService6 = this;
            List<PromotionInfo> promotions = dishopService6.mItemService.getNotRemovedPromotionsProduct();
            boolean id_global_exist = true;
            for (CategoryInfo category : categories) {
                if (category == null || category.getId_global() != null && !category.getId_global().isEmpty()) continue;
                id_global_exist = false;
                break;
            }
            if (!id_global_exist) {
                return "Veuillez g\u00e9n\u00e9rer les ids globaux avant upload de la carte";
            }
            if (categories != null && !categories.isEmpty()) {
                boolean result = this.checkOldMenu();
                if (result) {
                    MenuDishopBuilder menu = new MenuDishopBuilder().categories(categories).products(products).options(options).cartes(cartes).cartesMenu(cartesMenu).groupsSubSupplements(groupsSubSupplements).promotions(promotions).build();
                    JSONObject jsonMenu = menu.getMenuObject();
                    System.out.println("jsonMenu : " + jsonMenu);
                    return this.uploadMenu(jsonMenu);
                }
                return "Une erreur est servenu.";
            }
            return "Carte vide.";
        }
        return "Merci d'introduire le store id.";
    }

    private String uploadMenu(JSONObject jsonMenu) throws IOException {
        String result_message = "";
        OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).build();
        JSONObject jsonBody = new JSONObject();
        jsonBody.put("storeid", (Object)this.location_id);
        jsonBody.put("json", (Object)jsonMenu);
        String resourceUrl = "https://dishop.biborne.com/dishops";
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonBody.toString());
        Request request = new Request.Builder().url(resourceUrl).post(requestBody).addHeader("Content-Type", "application/json").build();
        Response response = client.newCall(request).execute();
        System.out.println("response : " + response);
        if (response.code() == 200) {
            result_message = "OK";
        }
        System.out.println("result_message : " + result_message);
        response.close();
        return result_message;
    }

    public boolean checkOldMenu() {
        Response response = null;
        try {
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            Request request = new Request.Builder().url("https://dishop.biborne.com/dishops/getJsonByStoreId/" + this.location_id).method("GET", null).build();
            response = client.newCall(request).execute();
            System.out.println("response checkOldMenu " + response);
            if (response.code() == 200) {
                boolean deleteOldMenu = response.body() != null && !response.body().string().isEmpty();
                response.close();
                if (deleteOldMenu) {
                    return this.deleteMenu();
                }
                return true;
            }
            response.close();
            return false;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            response.close();
            return false;
        }
    }

    private boolean deleteMenu() throws IOException {
        boolean success;
        block3: {
            success = false;
            Response response = null;
            try {
                OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).build();
                Request request = new Request.Builder().url(this.URL_DELETE_MENU + this.location_id).delete().addHeader("Content-Type", "application/json").build();
                response = client.newCall(request).execute();
                System.out.println("response :deleteMenu " + response);
                if (response.code() == 200) {
                    success = true;
                }
                response.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (response == null) break block3;
                response.close();
            }
        }
        return success;
    }

    public JSONArray getArrayOrders(Date dateStart, Date dateEnd, boolean new_orders) throws JSONException {
        try {
            OkHttpClient client = new OkHttpClient.Builder().readTimeout(1L, TimeUnit.MINUTES).build();
            String text_dateStart = com.openbravo.pos.util.DateUtils.formatterYEAR_MONTH_DAY_TIRETS6.format(dateStart);
            String text_dateEnd = com.openbravo.pos.util.DateUtils.formatterYEAR_MONTH_DAY_TIRETS6.format(dateEnd);
            String resourceUrl = this.URL_GET_ORDERS + this.location_id + "&" + text_dateStart + "&" + text_dateEnd;
            System.out.println("+++++++++++ resourceUrl : " + resourceUrl);
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)"");
            Request request = new Request.Builder().url(resourceUrl).get().addHeader("Authorization", "Bearer " + this.TOKEN).addHeader("Content-Type", "application/json").build();
            Response response = client.newCall(request).execute();
            System.out.println("+++++++++++ end : " + new Date());
            System.out.println("response.code() : " + response.code());
            if (response.code() == 200) {
                String response_orders = response.body().string();
                System.out.println("response_orders : " + response_orders);
                JSONArray jsonOrders = new JSONArray(response_orders);
                return jsonOrders;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Erreur de connexion.", 1500, NPosition.CENTER);
        }
        return null;
    }

    public JSONArray getOrders(Date dateStart, Date dateEnd, boolean new_orders) throws JSONException {
        if (AppLocal.ONLINE_ORDER_HOST_NAME != null && !AppLocal.ONLINE_ORDER_HOST_NAME.isEmpty() && AppLocal.ID_SITE_ORDERS != null && !AppLocal.ID_SITE_ORDERS.isEmpty()) {
            try {
                OkHttpClient client = new OkHttpClient.Builder().readTimeout(1L, TimeUnit.MINUTES).build();
                String text_dateStart = com.openbravo.pos.util.DateUtils.formatterYEAR_MONTH_DAY_TIRETS6.format(dateStart);
                String text_dateEnd = com.openbravo.pos.util.DateUtils.formatterYEAR_MONTH_DAY_TIRETS6.format(dateEnd);
                String resourceUrl = this.URL_GET_ORDERS + this.location_id + "&" + text_dateStart + "&" + text_dateEnd;
                System.out.println("+++++++++++ resourceUrl : " + resourceUrl);
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)"");
                Request request = new Request.Builder().url(resourceUrl).method("GET", requestBody).addHeader("Authorization", "Bearer " + this.TOKEN).build();
                Response response = client.newCall(request).execute();
                System.out.println("+++++++++++ end : " + new Date());
                if (response.code() == 200) {
                    String response_orders = response.body().string();
                    JSONArray jsonOrders = new JSONArray(response_orders);
                    return jsonOrders;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Erreur de connexion.", 1500, NPosition.CENTER);
            }
        }
        return null;
    }

    public int getNumberOrders() {
        if (this.dateStart == null || this.dateEnd == null) {
            Calendar calToday = Calendar.getInstance();
            Date date_created_order = DateUtils.getToday();
            if (calToday.getTime().getHours() >= 0 && calToday.getTime().getHours() <= AppLocal.dateEnd) {
                calToday.setTime(date_created_order);
                calToday.add(6, -1);
                date_created_order = calToday.getTime();
            }
            this.setTime(date_created_order);
        }
        int number_commandes = 0;
        JSONArray jsonOrders = this.getArrayOrders(this.dateStart, this.dateEnd, true);
        if (jsonOrders != null) {
            JSONArray jsonNewOrders = new JSONArray();
            for (int i = 0; i < jsonOrders.length(); ++i) {
                String numberOrder;
                String status;
                JSONObject jsonOrder = jsonOrders.getJSONObject(i);
                String idOrder = jsonOrder.isNull("id") ? null : jsonOrder.getString("id");
                String string = status = jsonOrder.isNull("status_pos") ? null : jsonOrder.getString("status_pos");
                if (status != null && status.equalsIgnoreCase("COMPLETED")) continue;
                String string2 = numberOrder = jsonOrder.isNull("display_id") ? null : String.valueOf(jsonOrder.getInt("display_id"));
                if (idOrder == null) continue;
                String oldTicket = null;
                if (this.mTicketService == null) {
                    this.mTicketService = TicketService.getInstance();
                }
                try {
                    oldTicket = this.mTicketService.getTicketByIdPlatform(idOrder, numberOrder);
                    System.out.println("oldTicket : getNumberOrders " + oldTicket);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                if (oldTicket != null) continue;
                jsonNewOrders.put((Object)jsonOrder);
            }
            number_commandes = jsonNewOrders.length();
            System.out.println("number_commandes : " + number_commandes);
        }
        return number_commandes;
    }

    public void setTime(Date date) {
        Calendar calStart = Calendar.getInstance();
        calStart.setTime(date);
        calStart.add(11, AppLocal.dateStart);
        calStart.getTime();
        this.dateStart = calStart.getTime();
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(date);
        if (AppLocal.dateStart >= AppLocal.dateEnd) {
            calEnd.add(11, AppLocal.dateEnd + 24);
        } else {
            calEnd.add(11, AppLocal.dateEnd);
        }
        calEnd.getTime();
        this.dateEnd = calEnd.getTime();
    }

    public LinkedHashMap<String, TicketInfo> getOrdersDetail() {
        JSONArray jsonOrders;
        LinkedHashMap<String, TicketInfo> orders = new LinkedHashMap<String, TicketInfo>();
        if (this.dateStart == null || this.dateEnd == null) {
            Calendar calToday = Calendar.getInstance();
            Date date_created_order = DateUtils.getToday();
            if (calToday.getTime().getHours() >= 0 && calToday.getTime().getHours() <= AppLocal.dateEnd) {
                calToday.setTime(date_created_order);
                calToday.add(6, -1);
                date_created_order = calToday.getTime();
            }
            this.setTime(date_created_order);
        }
        if ((jsonOrders = this.getArrayOrders(this.dateStart, this.dateEnd, true)) != null) {
            for (int i = 0; i < jsonOrders.length(); ++i) {
                String numberOrder;
                JSONObject jsonOrder = jsonOrders.getJSONObject(i);
                String idOrder = jsonOrder.isNull("id") ? null : jsonOrder.getString("id");
                String string = numberOrder = jsonOrder.isNull("display_id") ? null : String.valueOf(jsonOrder.getInt("display_id"));
                if (idOrder == null) continue;
                String oldTicket = null;
                if (this.mTicketService == null) {
                    this.mTicketService = TicketService.getInstance();
                }
                try {
                    oldTicket = this.mTicketService.getTicketByIdPlatform(idOrder, numberOrder);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                if (oldTicket != null) continue;
                TicketInfo mTicketInfo = TicketInfoBuilder.create(null).objectOrder(jsonOrder).buildOrderDishop().toTicketInfo();
                orders.put(idOrder, mTicketInfo);
            }
        }
        System.out.println("orders : " + orders.size());
        return orders;
    }

    public void rejectOrder(String orderId) {
        this.changeStatusOrder(orderId, "REJECTED");
    }

    public void validOrder(String orderId) {
        this.changeStatusOrder(orderId, "COMPLETED");
    }

    public void changeStatusOrder(String orderId, String status) {
        try {
            JSONObject jsonBodyRequest = new JSONObject();
            JSONObject jsonItem = new JSONObject();
            LocalDateTime localDateTime = LocalDateTime.now();
            ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.systemDefault());
            String formattedDate = zonedDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
            jsonBodyRequest.put("savedAt", (Object)formattedDate);
            jsonBodyRequest.put("status_pos", (Object)"COMPLETED");
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonBodyRequest.toString());
            Request request = new Request.Builder().url(this.URL_CHANGE_STATUS + orderId + "&" + this.location_id + "/refresh-status").method("PUT", body).addHeader("Authorization", "Bearer " + this.TOKEN).addHeader("Content-Type", "application/json").build();
            Response response = client.newCall(request).execute();
            System.out.println("+++++++ response : " + response);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }
}

