/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.service;

import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.MenuDeliveroBuilder;
import com.openbravo.pos.ticket.SupplementInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketInfoBuilder;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.ItemService;
import com.openbravo.service.TicketService;
import fr.protactile.procaisse.dao.entities.DeliverooInfo;
import fr.protactile.procaisse.dao.impl.DeliverooInfoDao;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.emitter.Emitter;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URISyntaxException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.DatatypeConverter;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONObject;

public class DeliveroService {
    private static DeliveroService m_instance;
    private String token_eats_store_orders_read;
    private String token_eats_orders;
    private String api_key;
    private String api_secret;
    private String api_key_prod = "xx-xV3iO1iZd_NOrz7NRId-NuMlz9V6viOP47zwpleskiI";
    private String api_secret_prod = "WOqV0K05i2n-CwxDyI9nmTaT7tJOvaNXN4qxAexC5JlEZypDWkrP5do2rHw8QbarEdwHbYU_7p9dTmebe8uvKA";
    private String api_key_test = "xx-test-hjpCIK1VA44CNyvN84zImEI-O0faUX5VwmoOPCnQ35Q";
    private String api_secret_test = "QVFfBoJZK_S5lHZeuWFX6Xu0jyVqhO6SopDRA6W1qUk_F-yjiUDe-zqiCBVwnjFYYALK0OMRBmMqdg_R948_vw";
    private ItemService mItemService;
    private String ONLINE = "ONLINE";
    private final String MESSAGE = "message";
    private final String MESSAGE_ERROR_TOKEN = "Invalid OAuth 2.0 credentials provided.";
    private final String MESSAGE_ERROR_SOTREID_EMPTY = "Merci d'introduire le store id.";
    private final String MESSAGE_ERROR_DB_EMPTY = "Carte vide.";
    private final String SUCCESS = "OK";
    private final String URL_GET_BRAND_ID = "/site/v1/restaurant_locations/";
    private final String URL_UPLOAD_MENU = "/menu/v1/brands/";
    private final String URL_CHANGE_STATUS_ITEM = "/menu/v2/brands/";
    private final String URL_SYNC_STATUS = "/order/v1/orders/";
    private final String URL_GET_MENU = "/menu/v2/brands/";
    private String location_id;
    private String brand_id;
    private DeliverooInfo mDeliverooInfo;
    private DeliverooInfoDao mDeliverooInfoDao;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private TicketService mTicketService;
    private String client_id_test = "6fde2b7ot142mq9oq3033j7i2k";
    private String client_secret_test = "nkcptl9qbgs417bc1imp38ns2mhc43idbs51gqbga1dptfj3ph0";
    private String CLIENT_CREDENTIALS = "client_credentials";
    private String client_id_prod = "166uibmqegttkbmk6e8djhet5m";
    private String client_secret_prod = "1ah66pirskatu3e12v7bgjao4v8merorh2igj618n3d5uiudj63c";
    private String client_id;
    private String client_secret;
    private String URL_OAUTH_TEST = "https://auth-sandbox.developers.deliveroo.com/oauth2/token";
    private String URL_OAUTH_PROD = "https://auth.developers.deliveroo.com/oauth2/token";
    private String URL_OAUTH2;
    private String token;
    private String ACCESS_TOKEN = "access_token";
    private String URL_API;
    private String URL_API_TEST = "https://api-sandbox.developers.deliveroo.com";
    private String URL_API_PROD = "https://api.developers.deliveroo.com";

    public static DeliveroService getInstance() {
        if (m_instance == null) {
            m_instance = new DeliveroService();
        }
        return m_instance;
    }

    private DeliveroService() {
        if (AppLocal.DELIVEROO_DEV_MODE) {
            this.api_key = this.api_key_test;
            this.api_secret = this.api_secret_test;
            this.client_id = this.client_id_test;
            this.client_secret = this.client_secret_test;
            this.URL_OAUTH2 = this.URL_OAUTH_TEST;
            this.URL_API = this.URL_API_TEST;
        } else {
            this.api_key = this.api_key_prod;
            this.api_secret = this.api_secret_prod;
            this.client_id = this.client_id_prod;
            this.client_secret = this.client_secret_prod;
            this.URL_OAUTH2 = this.URL_OAUTH_PROD;
            this.URL_API = this.URL_API_PROD;
        }
        this.mDeliverooInfoDao = new DeliverooInfoDao();
        this.mItemService = ItemService.getInstance();
        System.out.println("+++++++++++ start");
        this.loadInfoDeliveroo();
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.support.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.support.removePropertyChangeListener(pcl);
    }

    public void connect() throws URISyntaxException {
        if (this.location_id != null && !this.location_id.isEmpty()) {
            Socket socket = IO.socket((String)"http://45.76.44.106:7000");
            socket.connect();
            socket.on(this.location_id, new Emitter.Listener(){

                public void call(Object ... args) {
                    String status;
                    JSONObject jsonOrder;
                    JSONObject jsonBody;
                    String event;
                    JSONObject jsonObject = (JSONObject)args[0];
                    System.out.println("+++++++++++ json_order : " + jsonObject);
                    String string = event = jsonObject.isNull("event") ? "" : jsonObject.getString("event");
                    if (!jsonObject.isNull("body") && event != null && event.equals("order.new") && !(jsonBody = jsonObject.getJSONObject("body")).isNull("order") && (jsonOrder = jsonBody.getJSONObject("order")) != null) {
                        try {
                            String oldTicket;
                            if (DeliveroService.this.mTicketService == null) {
                                DeliveroService.this.mTicketService = TicketService.getInstance();
                            }
                            String string2 = oldTicket = jsonOrder.isNull("id") ? null : DeliveroService.this.mTicketService.getTicketByIdPlatform(jsonOrder.getString("id"));
                            if (oldTicket == null) {
                                if (AppLocal.AUTO_ACCEPT_DELIVEROO_ORDERS) {
                                    DeliveroService.this.addOrder(jsonOrder);
                                } else {
                                    DeliveroService.this.sentInfoOrders(1, jsonOrder);
                                }
                            }
                        }
                        catch (Exception ex) {
                            LogToFile.log("severe", ex.getMessage(), ex);
                        }
                    }
                    if (!jsonObject.isNull("body") && event != null && event.equals("order.status_update") && !(jsonBody = jsonObject.getJSONObject("body")).isNull("order") && (jsonOrder = jsonBody.getJSONObject("order")) != null && !(status = jsonOrder.getString("status")).equals("canceled")) {
                        String order_id = jsonOrder.isNull("id") ? null : jsonOrder.getString("id");
                        boolean checkPLU = DeliveroService.this.checkPLU(jsonOrder);
                        DeliveroService.this.syncStatus(order_id, checkPLU);
                    }
                }
            });
        }
    }

    public String uploadMenu() throws IOException {
        System.out.println("location_id : " + this.location_id);
        if (this.location_id != null && !this.location_id.isEmpty()) {
            System.out.println("brand_id : " + this.brand_id);
            if (this.brand_id == null || this.brand_id.isEmpty()) {
                this.getBrandID();
            }
            if (this.brand_id != null && !this.brand_id.isEmpty()) {
                List<CategoryInfo> categories = this.mItemService.getCategories();
                List<SupplementInfo> groupsOptions = this.mItemService.getGroupsOptions();
                if (categories != null && !categories.isEmpty()) {
                    MenuDeliveroBuilder menu = new MenuDeliveroBuilder().categories(categories).groupsOptions(groupsOptions).location_id(this.location_id).build();
                    JSONObject jsonMenu = menu.getMenuObject();
                    System.out.println("+++++++++ jsonMenu : " + jsonMenu);
                    return this.uploadMenu(jsonMenu, 0);
                }
                return "Carte vide.";
            }
        }
        return "Merci d'introduire le store id.";
    }

    private String uploadMenu(JSONObject jsonMenu, int number_try) throws IOException {
        this.generateToken();
        byte[] keyBytes = (this.api_key + ":" + this.api_secret).getBytes("UTF-8");
        String basicAuth = DatatypeConverter.printBase64Binary((byte[])keyBytes);
        System.out.println("++++ basicAuth : " + basicAuth);
        String result_message = "";
        OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).build();
        String resourceUrl = this.URL_API + "/menu/v1/brands/" + this.brand_id + "/menus/" + this.location_id;
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonMenu.toString());
        Request request = new Request.Builder().url(resourceUrl).put(requestBody).addHeader("Authorization", "Bearer " + this.token).addHeader("Content-Type", "application/json").build();
        Response response = client.newCall(request).execute();
        System.out.println("++++++++response.code() " + response.code());
        if (response.code() == 200) {
            result_message = "OK";
            this.getMenu();
        } else {
            try {
                String response_body = response.body().string();
                System.out.println("+++++++ response_items : " + response_body);
                JSONObject jsonResponse = new JSONObject(response_body);
                System.out.println("+++++++ jsonResponse : " + jsonResponse);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        response.close();
        return result_message;
    }

    public void getBrandID() {
        if (this.location_id != null && !this.location_id.isEmpty()) {
            try {
                this.generateToken();
                OkHttpClient client = new OkHttpClient().newBuilder().build();
                Request request = new Request.Builder().url(this.URL_API + "/site/v1/restaurant_locations/" + this.location_id).method("GET", null).addHeader("Authorization", "Bearer " + this.token).build();
                Response response = client.newCall(request).execute();
                System.out.println("getBrandID : " + response.code());
                if (response.code() == 200) {
                    String response_body = response.body().string();
                    System.out.println("+++++++ response_items : " + response_body);
                    JSONObject jsonResponse = new JSONObject(response_body);
                    if (!jsonResponse.isNull("brand_id")) {
                        JSONArray brand_ids = jsonResponse.getJSONArray("brand_id");
                        System.out.println("+++++++++++ brand_ids : " + brand_ids);
                        if (brand_ids != null && brand_ids.length() > 0) {
                            this.brand_id = brand_ids.getString(0);
                            this.setBrandId(this.brand_id);
                        }
                    }
                }
                response.close();
            }
            catch (IOException ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    private void loadInfoDeliveroo() {
        this.mDeliverooInfo = this.mDeliverooInfoDao.firstElement();
        if (this.mDeliverooInfo != null) {
            this.brand_id = this.mDeliverooInfo.getBrand_id();
            this.location_id = this.mDeliverooInfo.getLocation_id();
        } else {
            this.mDeliverooInfo = new DeliverooInfo();
            this.mDeliverooInfoDao.addDeliverooInfo(this.mDeliverooInfo);
        }
    }

    private void setBrandId(String brand_id) {
        if (this.mDeliverooInfo != null) {
            this.mDeliverooInfo.setBrand_id(brand_id);
            this.mDeliverooInfoDao.setBrandId(this.mDeliverooInfo);
        }
    }

    public String getLocationID() {
        if (this.mDeliverooInfo == null) {
            this.mDeliverooInfo = this.mDeliverooInfoDao.firstElement();
        }
        if (this.mDeliverooInfo != null) {
            return this.mDeliverooInfo.getLocation_id();
        }
        return null;
    }

    public void setLocationID(String location_id) throws IOException {
        if (this.mDeliverooInfo == null) {
            this.mDeliverooInfo = this.mDeliverooInfoDao.firstElement();
        }
        if (this.mDeliverooInfo != null) {
            this.mDeliverooInfo.setLocation_id(location_id);
            this.mDeliverooInfoDao.setLocationId(this.mDeliverooInfo);
        } else {
            this.mDeliverooInfo = new DeliverooInfo();
            this.mDeliverooInfo.setLocation_id(location_id);
            this.mDeliverooInfoDao.addDeliverooInfo(this.mDeliverooInfo);
        }
    }

    public void changeStatusProduct(int id_item, String status, boolean is_item_modifier) {
        this.generateToken();
        String text_id_item = is_item_modifier ? "option_" + id_item : "product_" + id_item;
        System.out.println("++++++++++++ text_id_item : " + text_id_item);
        if (AppLocal.LIST_ITEMS_DELIVEROO == null) {
            this.getMenu();
        }
        if (AppLocal.LIST_ITEMS_DELIVEROO != null && AppLocal.LIST_ITEMS_DELIVEROO.contains(text_id_item) && this.location_id != null && !this.location_id.isEmpty()) {
            if (this.brand_id == null || this.brand_id.isEmpty()) {
                this.getBrandID();
            }
            if (this.brand_id != null && !this.brand_id.isEmpty()) {
                try {
                    JSONObject jsonBodyRequest = new JSONObject();
                    JSONArray itemUnavailabilities = new JSONArray();
                    JSONObject jsonItem = new JSONObject();
                    jsonItem.put("item_id", (Object)text_id_item);
                    jsonItem.put("status", (Object)status);
                    itemUnavailabilities.put((Object)jsonItem);
                    jsonBodyRequest.put("item_unavailabilities", (Object)itemUnavailabilities);
                    OkHttpClient client = new OkHttpClient().newBuilder().build();
                    MediaType mediaType = MediaType.parse((String)"application/json");
                    RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonBodyRequest.toString());
                    Request request = new Request.Builder().url(this.URL_API + "/menu/v2/brands/" + this.brand_id + "/sites/" + this.location_id + "/menu/item_unavailabilities").method("POST", body).addHeader("Authorization", "Bearer " + this.token).addHeader("Content-Type", "application/json").build();
                    Response response = client.newCall(request).execute();
                    System.out.println("+++++++ response : " + response);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
    }

    public void setProductAvailable(int id_item, boolean is_item_modifier) {
        this.changeStatusProduct(id_item, "available", is_item_modifier);
    }

    public void setProductUnAvailable(int id_item, boolean is_item_modifier) {
        this.changeStatusProduct(id_item, "unavailable", is_item_modifier);
    }

    private void encaisserOrder(TicketInfo ticket) {
        if (this.mTicketService == null) {
            this.mTicketService = TicketService.getInstance();
        }
        this.mTicketService.orderAttente(false, ticket, false, true, true, false, true, AppLocal.PRINT_TICKET_DELIVEROO);
    }

    private void addOrder(JSONObject json_order) {
        TicketInfo ticket = TicketInfoBuilder.create(null).objectOrder(json_order).buildOrderDeliveroo().toTicketInfo();
        if (ticket != null) {
            this.encaisserOrder(ticket);
        }
    }

    public void sentInfoOrders(int number_orders, JSONObject order) {
        Object[] info_orders = new Object[2];
        info_orders[1] = number_orders;
        info_orders[0] = order;
        this.support.firePropertyChange("deliveroo_orders", null, info_orders);
    }

    public String syncStatus(String order_id, boolean checkPLU) {
        String result_message = "";
        if (order_id != null && !order_id.isEmpty()) {
            try {
                this.generateToken();
                OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).build();
                String resourceUrl = this.URL_API + "/order/v1/orders/" + order_id + "/sync_status";
                System.out.println("++++++ resourceUrl : " + resourceUrl);
                JSONObject jsonRoot = new JSONObject();
                String status = checkPLU ? "succeeded" : "failed";
                jsonRoot.put("status", (Object)status);
                if (!checkPLU) {
                    jsonRoot.put("reason", (Object)"pos_item_id_not_found");
                }
                ZonedDateTime gmtTime = LocalDateTime.now().atZone(ZoneId.of("GMT"));
                LocalDateTime localTime = gmtTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
                String occurred_at = localTime.format(DateTimeFormatter.ISO_DATE_TIME);
                jsonRoot.put("occurred_at", (Object)occurred_at);
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonRoot.toString());
                Request request = new Request.Builder().url(resourceUrl).post(requestBody).addHeader("Authorization", "Bearer " + this.token).addHeader("Content-Type", "application/json").build();
                Response response = client.newCall(request).execute();
                System.out.println("+++++++++ response : " + response);
                if (response.code() == 200) {
                    result_message = "OK";
                }
                response.close();
                return result_message;
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return result_message;
    }

    public void getMenu() {
        if (this.location_id != null && !this.location_id.isEmpty()) {
            if (this.brand_id == null || this.brand_id.isEmpty()) {
                this.getBrandID();
            }
            if (this.brand_id != null && !this.brand_id.isEmpty()) {
                this.generateToken();
                try {
                    OkHttpClient client = new OkHttpClient().newBuilder().build();
                    Request request = new Request.Builder().url(this.URL_API + "/menu/v2/brands/" + this.brand_id + "/sites/" + this.location_id + "/menu").method("GET", null).addHeader("Authorization", "Bearer " + this.token).build();
                    Response response = client.newCall(request).execute();
                    if (response.code() == 200) {
                        JSONObject jsonMenu;
                        String response_body = response.body().string();
                        System.out.println("+++++++ response_items : " + response_body);
                        JSONObject jsonResponse = new JSONObject(response_body);
                        if (!jsonResponse.isNull("menu") && !(jsonMenu = jsonResponse.getJSONObject("menu")).isNull("items")) {
                            JSONArray arrayItems = jsonMenu.getJSONArray("items");
                            if (AppLocal.LIST_ITEMS_DELIVEROO == null) {
                                AppLocal.LIST_ITEMS_DELIVEROO = new ArrayList<String>();
                            } else {
                                AppLocal.LIST_ITEMS_DELIVEROO.clear();
                            }
                            for (int i = 0; i < arrayItems.length(); ++i) {
                                String itemId;
                                JSONObject objectItem = arrayItems.getJSONObject(i);
                                if (objectItem.isNull("id") || (itemId = objectItem.getString("id")) == null || itemId.isEmpty()) continue;
                                AppLocal.LIST_ITEMS_DELIVEROO.add(itemId);
                            }
                        }
                    }
                    response.close();
                }
                catch (IOException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
    }

    public void generateToken() {
        try {
            String response_items;
            JSONObject jsonResponse;
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            MediaType mediaType = MediaType.parse((String)"application/x-www-form-urlencoded");
            StringBuilder bodyBuilder = new StringBuilder();
            bodyBuilder.append("client_id=");
            bodyBuilder.append(this.client_id);
            bodyBuilder.append("&");
            bodyBuilder.append("client_secret=");
            bodyBuilder.append(this.client_secret);
            bodyBuilder.append("&");
            bodyBuilder.append("grant_type=");
            bodyBuilder.append(this.CLIENT_CREDENTIALS);
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)bodyBuilder.toString());
            Request request = new Request.Builder().url(this.URL_OAUTH2).method("POST", body).addHeader("Content-Type", "application/x-www-form-urlencoded").build();
            Response response = client.newCall(request).execute();
            System.out.println("response setToken : " + response.code());
            if (response.code() == 200 && !(jsonResponse = new JSONObject(response_items = response.body().string())).isNull(this.ACCESS_TOKEN)) {
                this.token = jsonResponse.getString(this.ACCESS_TOKEN);
            }
            response.close();
        }
        catch (IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private boolean checkPLU(JSONObject jsonOrder) {
        if (!jsonOrder.isNull("items")) {
            JSONArray items = jsonOrder.getJSONArray("items");
            for (int i = 0; i < items.length(); ++i) {
                String pos_item_id;
                JSONObject itemObject = items.getJSONObject(i);
                if (!itemObject.isNull("pos_item_id") && ((pos_item_id = itemObject.getString("pos_item_id")) == null || pos_item_id.isEmpty())) {
                    return false;
                }
                if (itemObject.isNull("modifiers")) continue;
                JSONArray modifiers = itemObject.getJSONArray("modifiers");
                for (int j = 0; j < modifiers.length(); ++j) {
                    String pos_modifier_id;
                    JSONObject modifierObject = modifiers.getJSONObject(j);
                    if (modifierObject.isNull("pos_item_id") || (pos_modifier_id = modifierObject.getString("pos_item_id")) != null && !pos_modifier_id.isEmpty()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void setItemsUnavailabilities(JSONArray itemUnavailabilities) {
        this.generateToken();
        if (this.location_id != null && !this.location_id.isEmpty()) {
            if (this.brand_id == null || this.brand_id.isEmpty()) {
                this.getBrandID();
            }
            if (this.brand_id != null && !this.brand_id.isEmpty()) {
                try {
                    JSONObject jsonBodyRequest = new JSONObject();
                    jsonBodyRequest.put("item_unavailabilities", (Object)itemUnavailabilities);
                    OkHttpClient client = new OkHttpClient().newBuilder().build();
                    MediaType mediaType = MediaType.parse((String)"application/json");
                    RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonBodyRequest.toString());
                    Request request = new Request.Builder().url(this.URL_API + "/menu/v2/brands/" + this.brand_id + "/sites/" + this.location_id + "/menu/item_unavailabilities").method("POST", body).addHeader("Authorization", "Bearer " + this.token).addHeader("Content-Type", "application/json").build();
                    Response response = client.newCall(request).execute();
                    System.out.println("+++++++ response : " + response);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
    }

    public void getListItemDeliveroo() {
        this.generateToken();
        if (AppLocal.LIST_ITEMS_DELIVEROO == null) {
            this.getMenu();
        }
    }
}

