/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.service;

import com.openbravo.pos.forms.StartPOS;
import com.openbravo.pos.util.Event;
import com.openbravo.pos.util.Journal;
import com.openbravo.pos.util.LogToFile;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.commons.io.input.ReversedLinesFileReader;

public class DeletionDetecter {
    private Preferences preferences = Preferences.userNodeForPackage(StartPOS.class);
    public static final String REG_VAR_JET = "jet";
    public static final String REG_VAR_BACKUP_MANUEL = "back";
    public static final String REG_VAR_GRAND_TOTAL_TICKET = "gttckt";
    public static final String REG_VAR_GRAND_TOTAL_PERIODE_JOUR = "gtpdj";
    public static final String REG_VAR_GRAND_TOTAL_PERIODE_MOIS = "gtpdm";
    public static final String REG_VAR_GRAND_TOTAL_PERIODE_ANNEE = "gtpda";
    public static final String REG_VAR_ARCHIV_JOUR = "archj";
    public static final String REG_VAR_ARCHIV_MOIS = "archm";
    public static final String REG_VAR_ARCHIV_ANNEE = "archa";
    public static final String REG_VAR_ENTETE = "ent";

    public boolean isJetDeletionDetected() throws IOException {
        if (Journal.FILE.exists()) {
            ReversedLinesFileReader fileReader = new ReversedLinesFileReader(Journal.FILE);
            String previousEvent = fileReader.readLine();
            return !this.preferences.get(REG_VAR_JET, "").equals(previousEvent);
        }
        return !this.preferences.get(REG_VAR_JET, "").equals("");
    }

    public String getLastLine(String regVar) {
        return this.preferences.get(regVar, "");
    }

    public void detectDeletion(String regVar, String lastValue) {
        if (!this.preferences.get(regVar, "").equals("") && !this.preferences.get(regVar, "").equals(lastValue)) {
            try {
                switch (regVar) {
                    case "jet": {
                        Journal.writeToJET(new Event(90, "D\u00e9tection d'un d\u00e9faut d'int\u00e9grit\u00e9", "", "Description", new Date().getTime(), "D\u00e9tection de supression ou modification  des lignes du Journal"));
                        break;
                    }
                    case "archj": {
                        break;
                    }
                    case "archm": {
                        break;
                    }
                    case "archa": {
                        break;
                    }
                    case "gtpdj": {
                        break;
                    }
                    case "gtpdm": {
                        break;
                    }
                    case "gtpda": {
                        break;
                    }
                    case "gttckt": {
                        break;
                    }
                }
            }
            catch (IOException ex) {
                Logger.getLogger(DeletionDetecter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void pushToRegistre(String regVar, String lastValue) {
        try {
            this.preferences.put(regVar, (String)(lastValue.length() > 8000 ? lastValue.substring(0, 8000) + "..." : lastValue));
            this.preferences.flush();
        }
        catch (BackingStoreException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public boolean isDefautDetcted(String regVar, String lastValue) {
        return !this.preferences.get(regVar, "").equals("") && !this.preferences.get(regVar, "").equals(lastValue);
    }

    public void controlJETDeletion() {
        try {
            if (this.isJetDeletionDetected()) {
                Journal.writeToJET(new Event(90, "D\u00e9tection d'un d\u00e9faut d'int\u00e9grit\u00e9", "", "Description", new Date().getTime(), "D\u00e9tection de supression ou de modification des lignes du Journal"));
            }
        }
        catch (IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }
}

