/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.service;

import com.openbravo.basic.BasicException;
import com.openbravo.pos.util.CSVUtil;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.entities.AddressInfo;
import fr.protactile.procaisse.dao.entities.CustomerInfo;
import fr.protactile.procaisse.dao.impl.AddressInfoDao;
import fr.protactile.procaisse.services.CustomerService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;

public class CustomerEnvService {
    private AddressInfoDao mAdresseInfoDao = new AddressInfoDao();
    private CustomerService mCustomerService = CustomerService.getInstance();

    private Double parseValue(String value) {
        if (value != null && !value.isEmpty() && !value.equals("")) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public void importClients(File customersCSVFile) throws IOException {
        List allDatas;
        if (customersCSVFile.exists() && (allDatas = FileUtils.readLines((File)customersCSVFile)) != null && !allDatas.isEmpty()) {
            if (((String)allDatas.get(0)).contains("CLIENT,TEL1,TEL2,TEL3,ADR1,ADR2,ADR3")) {
                this.importClientsFromCsvAndroidSoft(customersCSVFile);
            } else {
                Object[] columns = new String[18];
                int idCustomer = 0;
                int max_length = 18;
                for (int i = 1; i < allDatas.size(); ++i) {
                    idCustomer = 0;
                    columns = ((String)allDatas.get(i)).replace("null", "").split(",");
                    if (columns.length < max_length) {
                        Object[] secondsTab = new String[max_length - columns.length];
                        for (int j = 0; j < max_length - columns.length; ++j) {
                            secondsTab[j] = "";
                        }
                        columns = (String[])ArrayUtils.addAll((Object[])columns, (Object[])secondsTab);
                    }
                    boolean j = false;
                    try {
                        CustomerInfo customer;
                        if (columns.length < 4 || columns[0].equals("")) continue;
                        Object phone = columns[2];
                        phone = ((String)phone).replaceAll(" ", "");
                        String phone2 = (String)columns[3];
                        Object email = columns[17];
                        if (phone != null && !((String)phone).isEmpty() && ((String)phone).length() == 9) {
                            phone = "0" + (String)phone;
                        }
                        if (phone2 != null && !phone2.isEmpty() && phone2.length() == 9) {
                            phone2 = "0" + phone2;
                        }
                        if ((customer = new CustomerInfo((String)columns[0], (String)phone, phone2, (String)columns[1], (String)email)).getPhone() != null && !customer.getPhone().isEmpty()) {
                            this.mCustomerService.save(customer);
                            if (customer.getId() != null) {
                                idCustomer = customer.getId();
                            }
                        }
                        if (idCustomer == 0) continue;
                        AddressInfo addressInfo = new AddressInfo((String)columns[6], (String)columns[13], (String)columns[5], (String)columns[14], (String)columns[10], (String)columns[15], (String)columns[16], (String)columns[7], (String)columns[9], (String)columns[4], idCustomer, this.parseValue((String)columns[11]), this.parseValue((String)columns[12]), (String)columns[8]);
                        this.mAdresseInfoDao.save(addressInfo);
                        continue;
                    }
                    catch (BasicException ex) {
                        LogToFile.log("severe", null, ex);
                    }
                }
            }
        }
    }

    public void importClientsFromCsvAndroidSoft(File customersCSVFile) throws IOException {
        List allDatas;
        if (customersCSVFile.exists() && (allDatas = FileUtils.readLines((File)customersCSVFile, (String)"UTF-8")) != null && !allDatas.isEmpty()) {
            String[] columns = new String[17];
            int idCustomer = 0;
            int max_length = 17;
            for (int i = 1; i < allDatas.size(); ++i) {
                columns = ((String)allDatas.get(i)).replace("\"", "").split(",");
                String name = columns[0].replace("non d\u00e9fini", "");
                String tel1 = columns[1].replace("non d\u00e9fini", "");
                String tel2 = columns[2].replace("non d\u00e9fini", "");
                String tel3 = columns[3].replace("non d\u00e9fini", "");
                String adr = columns[4].replace("non d\u00e9fini", "");
                String zipCode = columns[5].replace("non d\u00e9fini", "");
                String city = columns[6].replace("non d\u00e9fini", "");
                String interphone = "";
                String etage = "";
                String batiment = "";
                String remark = "";
                String company = "";
                for (int j = 7; j < columns.length; ++j) {
                    String unknown = columns[j].replace("non d\u00e9fini", "");
                    if (unknown.contains("interphone:")) {
                        interphone = unknown.replace("interphone:", "");
                        continue;
                    }
                    if (unknown.contains("\u00e9tage:")) {
                        etage = unknown.replace("\u00e9tage:", "");
                        continue;
                    }
                    if (unknown.contains("b\u00e2timent:")) {
                        batiment = unknown.replace("b\u00e2timent:", "");
                        continue;
                    }
                    if (unknown.contains("compl\u00e9ment:")) {
                        remark = unknown.replace("compl\u00e9ment:", "");
                        continue;
                    }
                    if (!unknown.contains("soci\u00e9t\u00e9:")) continue;
                    company = unknown.replace("soci\u00e9t\u00e9:", "");
                }
                try {
                    if (columns.length < 4 || columns[0].equals("")) continue;
                    CustomerInfo customer = new CustomerInfo(name, tel1, tel2.contains("non") ? null : tel2, null);
                    this.mCustomerService.save(customer);
                    if (customer.getId() != null) {
                        idCustomer = customer.getId();
                    }
                    if (idCustomer == 0) continue;
                    AddressInfo addressInfo = new AddressInfo(adr, zipCode, city, "", interphone, batiment, "", etage, "", company, idCustomer, 0.0, 0.0, remark);
                    this.mAdresseInfoDao.save(addressInfo);
                    continue;
                }
                catch (BasicException ex) {
                    LogToFile.log("severe", null, ex);
                }
            }
        }
    }

    public void exportClients(File customersCSVFile) throws IOException, BasicException {
        ArrayList<String> customersWithAdresses = new ArrayList<String>();
        List<CustomerInfo> customers = this.mCustomerService.getAllCustomers();
        if (customers != null && customers.size() > 0) {
            customersWithAdresses.add(customers.get(0).getEnteteCSV());
            for (CustomerInfo customer : customers) {
                String[] lines;
                for (String line : lines = customer.getLineString().split("\n")) {
                    customersWithAdresses.add(line);
                }
            }
        }
        CSVUtil.writeStringsToCSVFile(new File(customersCSVFile.getAbsolutePath() + File.separator + "Clients.csv"), customersWithAdresses);
    }
}

