/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.service;

import com.openbravo.basic.BasicException;
import com.openbravo.components.ProgressBarCustomized;
import com.openbravo.controllers.RootAppController;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.dao.DataLogicStats;
import com.openbravo.format.Formats;
import com.openbravo.models.RankCategory;
import com.openbravo.models.RankProduct;
import com.openbravo.models.RankProductDiver;
import com.openbravo.models.RankTypeOrder;
import com.openbravo.pos.admin.DataLogicAdmin;
import com.openbravo.pos.admin.User;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.printer.PrinterHelper;
import com.openbravo.pos.ticket.CaisseZ;
import com.openbravo.pos.ticket.GroupedTax;
import com.openbravo.pos.ticket.HourInfo;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.ticket.PaymentLine;
import com.openbravo.pos.ticket.TaxLineTicket;
import com.openbravo.pos.ticket.TaxeLine;
import com.openbravo.pos.ticket.TotaleEncaissement;
import com.openbravo.pos.ticket.TurnoverInfo;
import com.openbravo.pos.ticket.UserCaisseInfo;
import com.openbravo.pos.ticket.UserInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.Event;
import com.openbravo.pos.util.HTMLBuilder;
import com.openbravo.pos.util.Journal;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.postgresql.db.PostgreService;
import com.openbravo.service.ArchivageService;
import com.procaisse.db.connection.firebase.FirebaseService;
import com.protactile.mailer.Email;
import com.protactile.mailer.Mailer;
import fr.protactile.norm.beans.GrandTotalPeriode;
import fr.protactile.procaisse.dao.entities.CaisseInfo;
import fr.protactile.procaisse.orders.export.ExportGeneratorHelper;
import fr.protactile.procaisse.orders.export.ExportTurnoverExcel;
import fr.protactile.procaisse.orders.export.ZDayDetail;
import fr.protactile.procaisse.services.ZGlobalService;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Message;
import javax.swing.JDialog;
import javax.swing.JProgressBar;

public class ClotureService {
    private DataLogicSales dlSales;
    private DataLogicAdmin dlUser;
    private DataLogicStats dlStats;
    private JRootApp m_appview;
    private LocalDate date_purge;
    private PropertyChangeSupport support;
    private static ClotureService m_instance;
    private ZGlobalService mZGlobalService;
    private PostgreService mPostgreService = null;
    private FirebaseService mFirebaseService = null;

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.support.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.support.removePropertyChangeListener(pcl);
    }

    private ClotureService(DataLogicSales dlSales, JRootApp m_appview) {
        this.dlSales = dlSales;
        this.dlStats = m_appview.getM_dlStats();
        this.dlUser = (DataLogicAdmin)m_appview.getBean("com.openbravo.pos.admin.DataLogicAdmin");
        this.m_appview = m_appview;
        this.dlSales.setDlStats(m_appview.getM_dlStats());
        this.support = new PropertyChangeSupport(this);
    }

    public static ClotureService getInstance(DataLogicSales dlSales, JRootApp m_appview) {
        if (m_instance == null) {
            m_instance = new ClotureService(dlSales, m_appview);
        }
        return m_instance;
    }

    public synchronized void closeCaisseAutomatiqueDay(boolean show_progress_bar) throws BasicException {
        JProgressBar pb;
        System.out.println("+++++++++++++ close automoatically 3");
        AppLocal.CLOTURE_PERIODE = true;
        ProgressBarCustomized barCustomized = show_progress_bar ? new ProgressBarCustomized("Cloture Journali\u00e8re", 2) : null;
        JDialog dialog = barCustomized != null ? barCustomized.getDialogueProgressBar() : null;
        JProgressBar jProgressBar = pb = barCustomized != null ? barCustomized.getPb() : null;
        if (pb != null) {
            pb.setValue(1);
            pb.setString("Calcule en cours ...");
        }
        double htAmount = 0.0;
        double taxAmount = 0.0;
        CaisseInfo caisse = this.dlSales.getCaisse(AppLocal.token);
        ArrayList<TaxeLine> allTaxes = new ArrayList<TaxeLine>();
        List<TaxeLine> taxes = this.dlSales.getTaxeByDate();
        allTaxes.addAll(taxes);
        for (TaxeLine allTaxe : allTaxes) {
            htAmount += allTaxe.getHt();
            taxAmount += allTaxe.getTax();
        }
        double fondClose = 0.0;
        double caNet = this.dlSales.getCA(caisse.getDateOpen());
        caisse.setDateClose(new Date());
        caisse.setUser_close(new UserInfo("0", "User Maintenance", 1));
        caisse.setFondClose(fondClose);
        CaisseZ caisseZ = new CaisseZ();
        caisseZ.setDateClose(caisse.getDateClose());
        caisseZ.setDateOpen(caisse.getDateOpen());
        caisseZ.setCaisse(caisse.getId());
        caisseZ.setUser_close_id("0");
        caisseZ.setUser_open_id("0");
        caisseZ.setHtAmount(htAmount);
        caisseZ.setTaxAmount(taxAmount);
        caisseZ.setTtcAmount(caNet);
        if (pb != null) {
            pb.setValue(10);
            pb.setString("Traitement de fond de caisse en cours ...");
        }
        try {
            Journal.writeToJET(new Event(170, "Traitement de fond de caisse", "0", "fon de caisse", new Date().getTime(), "" + caisseZ.getTtcAmount()));
            Date dateFinPeriode = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dateFinPeriode);
            calendar.add(5, -1);
            dateFinPeriode = calendar.getTime();
            dateFinPeriode.setHours(0);
            dateFinPeriode.setMinutes(0);
            dateFinPeriode.setSeconds(0);
            if (pb != null) {
                pb.setValue(20);
                pb.setString("cloture de la caisse en cours ...");
            }
            this.dlSales.closeCaisse(caisse, caisseZ, "j", allTaxes, "0", dateFinPeriode);
            boolean first_day = AppLocal.dlItems.isFirstDay();
            if (!first_day) {
                this.dlSales.resetNumber();
            }
            dateFinPeriode = calendar.getTime();
            dateFinPeriode.setHours(0);
            dateFinPeriode.setMinutes(0);
            dateFinPeriode.setSeconds(0);
            if (pb != null) {
                pb.setValue(80);
                pb.setString("Archivage en cours ...");
            }
            ArchivageService archivageUtils = new ArchivageService(this.dlSales, this.m_appview.getM_dlItems(), "0");
            archivageUtils.archivRecursive("j", dateFinPeriode);
            if (pb != null) {
                pb.setValue(80);
                pb.setString("Fin d'archivage ...");
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
        if (pb != null) {
            pb.setValue(100);
        }
        if (dialog != null) {
            dialog.dispose();
        }
    }

    public void closeCaisseAutomatiqueMonth(boolean show_progress_bar) throws BasicException {
        JProgressBar pb;
        System.out.println("+++++++ cloture mensuel");
        this.date_purge = LocalDate.now();
        this.date_purge = this.date_purge.minusMonths(1L);
        this.date_purge = this.date_purge.minusDays(1L);
        ProgressBarCustomized barCustomized = show_progress_bar ? new ProgressBarCustomized("Cloture Mensuelle", 2) : null;
        JDialog dialog = barCustomized != null ? barCustomized.getDialogueProgressBar() : null;
        JProgressBar jProgressBar = pb = barCustomized != null ? barCustomized.getPb() : null;
        if (pb != null) {
            pb.setValue(1);
            pb.setString("Calcule en cours ...");
        }
        double htAmount = 0.0;
        double taxAmount = 0.0;
        ArrayList<TaxeLine> allTaxes = new ArrayList<TaxeLine>();
        List<TaxeLine> taxes = this.dlSales.getTaxeByDate();
        allTaxes.addAll(taxes);
        for (TaxeLine allTaxe : allTaxes) {
            htAmount += allTaxe.getHt();
            taxAmount += allTaxe.getTax();
        }
        double fondClose = 0.0;
        double caNet = this.dlSales.getCA();
        CaisseInfo caisse = this.dlSales.getCaisse(AppLocal.token);
        caisse.setOuverte(false);
        caisse.setDateClose(new Date());
        caisse.setUser_close(new UserInfo("0", "User Maintenance", 1));
        caisse.setFondClose(fondClose);
        CaisseZ caisseZ = new CaisseZ();
        caisseZ.setDateClose(caisse.getDateClose());
        caisseZ.setDateOpen(caisse.getDateOpen());
        caisseZ.setCaisse(caisse.getId());
        caisseZ.setUser_close_id("0");
        caisseZ.setUser_open_id("0");
        caisseZ.setHtAmount(htAmount);
        caisseZ.setTaxAmount(taxAmount);
        caisseZ.setTtcAmount(caNet);
        try {
            if (pb != null) {
                pb.setValue(10);
                pb.setString("Traitement de fond de caisse en cours ...");
            }
            Journal.writeToJET(new Event(170, "Traitement de fond de caisse", "0", "fon de caisse", new Date().getTime(), "" + caisseZ.getTtcAmount()));
            Date dateFinPeriode = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dateFinPeriode);
            calendar.add(2, -1);
            dateFinPeriode = calendar.getTime();
            if (pb != null) {
                pb.setValue(15);
                pb.setString("cloture de la caisse en cours ...");
            }
            this.dlSales.closeCaisse(caisse, caisseZ, "m", allTaxes, "0", dateFinPeriode);
            this.dlSales.resetNumber();
            if (pb != null) {
                pb.setValue(60);
                pb.setString("Archivage en cours ...");
            }
            System.out.println("++++++++++++++ dateFinPeriode archive : " + dateFinPeriode);
            ArchivageService archivageUtils = new ArchivageService(this.dlSales, this.m_appview.getM_dlItems(), "0");
            archivageUtils.archivRecursive("m", dateFinPeriode);
            if (pb != null) {
                pb.setValue(90);
                pb.setString("Fin d'archivage");
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
        if (pb != null) {
            pb.setValue(100);
        }
        if (dialog != null) {
            dialog.dispose();
        }
    }

    public void closeCaisseAutomatiqueYear() throws BasicException {
        ProgressBarCustomized barCustomized = new ProgressBarCustomized("Clotures Annuelle", 2);
        JDialog dialog = barCustomized.getDialogueProgressBar();
        JProgressBar pb = barCustomized.getPb();
        pb.setValue(1);
        pb.setString("Calcule en cours ...");
        double htAmount = 0.0;
        double taxAmount = 0.0;
        ArrayList<TaxeLine> allTaxes = new ArrayList<TaxeLine>();
        List<TaxeLine> taxes = this.dlSales.getTaxeByDate();
        allTaxes.addAll(taxes);
        for (TaxeLine allTaxe : allTaxes) {
            htAmount += allTaxe.getHt();
            taxAmount += allTaxe.getTax();
        }
        double fondClose = 0.0;
        double caNet = this.dlSales.getCA();
        CaisseInfo caisse = this.dlSales.getCaisse(AppLocal.token);
        caisse.setOuverte(false);
        caisse.setDateClose(new Date());
        caisse.setUser_close(new UserInfo("0", "User Maintenance", 1));
        caisse.setFondClose(fondClose);
        CaisseZ caisseZ = new CaisseZ();
        caisseZ.setDateClose(caisse.getDateClose());
        caisseZ.setDateOpen(caisse.getDateOpen());
        caisseZ.setCaisse(caisse.getId());
        caisseZ.setUser_close_id("0");
        caisseZ.setUser_open_id("0");
        caisseZ.setHtAmount(htAmount);
        caisseZ.setTaxAmount(taxAmount);
        caisseZ.setTtcAmount(caNet);
        try {
            pb.setValue(10);
            pb.setString("Traitement de fond de caisse en cours ...");
            Journal.writeToJET(new Event(170, "Traitement de fond de caisse", "0", "fon de caisse", new Date().getTime(), "" + caisseZ.getTtcAmount()));
            Date dateFinPeriode = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dateFinPeriode);
            calendar.add(1, -1);
            dateFinPeriode = calendar.getTime();
            pb.setValue(20);
            pb.setString("cloture de la caisse en cours ...");
            this.dlSales.closeCaisse(caisse, caisseZ, "a", allTaxes, "0", dateFinPeriode);
            this.dlSales.resetNumber();
            pb.setValue(80);
            pb.setString("Archivage en cours ...");
            ArchivageService archivageUtils = new ArchivageService(this.dlSales, this.m_appview.getM_dlItems(), "0");
            archivageUtils.archivRecursive("a", dateFinPeriode);
            pb.setValue(80);
            pb.setString("Fin d'archivage ...");
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
        pb.setValue(100);
        dialog.dispose();
    }

    public void sendStatistiqueEmail(Date dateStart, Date dateEnd, String title) {
        if (AppLocal.EMAIL_SYNTHESE) {
            try {
                List<PaymentLine> payments = this.dlStats.loadPaymentBetween(dateStart, dateEnd);
                Integer m_iSales = this.dlStats.getNbOrderBetween(dateStart, dateEnd);
                double caCanceled = this.dlStats.getCACanceledByCaisseId(dateStart, dateEnd);
                List<TaxeLine> taxes = this.dlStats.getTaxeByDateBetween(dateStart, dateEnd);
                List<UserCaisseInfo> users = this.dlSales.getCAbyUser(dateStart, dateEnd);
                List<HourInfo> salesByHour = this.dlStats.loadSatisticByHour(dateStart, dateEnd);
                ArrayList<TurnoverInfo> salesByUnit = new ArrayList<TurnoverInfo>();
                salesByUnit.clear();
                salesByUnit.addAll(salesByHour);
                String unit = "h";
                List<RankProductDiver> items_divers = this.dlStats.getRankItemDivers(dateStart, dateEnd);
                List<RankCategory> m_resultCategories = this.dlStats.getRankCategories(dateStart, dateEnd);
                for (RankCategory m_resultCategory : m_resultCategories) {
                    m_resultCategory.setRankProducts(this.dlStats.getRankItems(dateStart, dateEnd, m_resultCategory.getId()));
                }
                Double totalDiscount = this.dlStats.getTotalDiscountOrderOfType(dateStart, dateEnd, "pourcentage") + this.dlStats.getTotalDiscountOrderOfType(dateStart, dateEnd, "somme");
                Double totalDiscountOnLines = this.dlStats.getTotalDiscountOnTicketLines(dateStart, dateEnd);
                double caBrut = 0.0;
                double tvas = 0.0;
                double caNet = 0.0;
                ArrayList<TaxeLine> allTaxes = new ArrayList<TaxeLine>();
                if (taxes != null) {
                    allTaxes.addAll(taxes);
                }
                for (TaxeLine allTaxe : allTaxes) {
                    caBrut += allTaxe.getHt();
                    tvas += allTaxe.getTax();
                }
                for (UserCaisseInfo user : users) {
                    caNet += user.getTotal().doubleValue();
                }
                LinkedHashMap<String, String> data = this.getSynthesCaisseMap(unit, salesByUnit, m_resultCategories, items_divers, caNet, caCanceled, tvas, payments, allTaxes, users, this.dlSales.getCaisse(AppLocal.token), MarqueNFC.fetchOrStore(this.dlSales), dateStart, dateEnd, totalDiscount, totalDiscountOnLines);
                ExportGeneratorHelper mEGH = new ExportGeneratorHelper(dateStart, dateEnd);
                mEGH.setDlStats(this.dlStats);
                mEGH.setDlSales(this.dlSales);
                mEGH.setTotal(caNet);
                mEGH.setNbOrders(m_iSales);
                mEGH.setTaxes(allTaxes);
                mEGH.setPayments(payments);
                mEGH.setzPeriod("");
                mEGH.setMarqueNFC(MarqueNFC.fetchOrStore(this.dlSales));
                ZDayDetail zDetail = new ZDayDetail(this.dlSales, this.dlStats);
                mEGH.setzDetail(zDetail);
                mEGH.setIsForClosedCaisse(true);
                mEGH.loadData();
                ExportTurnoverExcel mExportTurnoverExcel = new ExportTurnoverExcel();
                mExportTurnoverExcel.setComponentParent(null);
                mExportTurnoverExcel.setShowDetailTurnover(true);
                mExportTurnoverExcel.setTemporaryDirectoryOutput();
                String fileName = title + " (" + DateUtils.formatDate(dateStart) + ").xlsx";
                mExportTurnoverExcel.setFileName(fileName);
                String $resultExportFile = mExportTurnoverExcel.export(mEGH, false);
                Email email = new Email();
                email.setFromAddress("ProCaisse", "no-reply@giga-tactile.fr");
                List<User> receipts = this.dlUser.getUsersHavingPermission("5");
                receipts.stream().filter(receipt -> receipt != null && !receipt.getEmail().isEmpty()).forEachOrdered(receipt -> email.addRecipient(receipt.getName(), receipt.getEmail(), Message.RecipientType.TO));
                if (!email.getRecipients().isEmpty()) {
                    HTMLBuilder emailHtml = new HTMLBuilder("Rapport du Synth\u00e8se: " + title, data, null);
                    email.setTextHTML(emailHtml.toString());
                    email.setSubject("Rapport du Synth\u00e8se: " + title + " de " + PrinterHelper.dateFormatterFull.format(dateStart) + " \u00e0 " + PrinterHelper.dateFormatterFull.format(dateEnd));
                    if ($resultExportFile != null && !$resultExportFile.equals("canceled") && new File($resultExportFile).exists() && !new File($resultExportFile).isDirectory()) {
                        FileDataSource sourceFile = new FileDataSource($resultExportFile);
                        email.addAttachment(fileName, (DataSource)sourceFile);
                    }
                    System.out.println("before send mail");
                    Mailer.sendMailParametred(email);
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public LinkedHashMap<String, String> getSynthesCaisseMap(String chiffePerUnit, List<TurnoverInfo> salesByUnit, List<RankCategory> categories, List<RankProductDiver> items_divers, double caNet, double caCanceld, double tvas, List<PaymentLine> payments, List<TaxeLine> taxes, List<UserCaisseInfo> users, CaisseInfo caisse, MarqueNFC marqueNF, Date dateStart, Date dateEnd, Double discountOrders, Double discountOnLines) {
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        data.put("Journal de synth\u00e8se", "");
        data.put(" P\u00e9riode de " + PrinterHelper.dateFormatterFull.format(dateStart), "");
        data.put(" \u00e0 " + PrinterHelper.dateFormatterFull.format(dateEnd), "");
        data.put("Chiffre d'affaire par mode de paiement", "");
        for (PaymentLine paymentLine : payments) {
            if (!paymentLine.getM_PaymentType().equals("Avoir")) {
                data.put(paymentLine.getM_PaymentType(), Formats.CURRENCY.formatValue(paymentLine.getM_PaymentValue()));
                continue;
            }
            if (paymentLine.getM_PaymentValue() > 0.0) {
                data.put("Avoir Encaiss\u00e9", Formats.CURRENCY.formatValue(paymentLine.getM_PaymentValue()));
                continue;
            }
            data.put("Avoir D\u00e9caiss\u00e9", Formats.CURRENCY.formatValue(paymentLine.getM_PaymentValue()));
        }
        for (RankCategory categorie : categories) {
            data.put(categorie.getName() + " : " + categorie.getTurnover(), "");
            for (RankProduct rankProduct : categorie.getRankProducts()) {
                data.put(rankProduct.getQuantity() + " * " + rankProduct.getName(), rankProduct.getTurnover());
            }
        }
        if (items_divers != null && items_divers.size() > 0) {
            double divers_turnover = 0.0;
            for (RankProductDiver items_diver : items_divers) {
                divers_turnover += items_diver.getTurnover();
            }
            data.put("Produits Divers : " + AppVarUtils.printPrice(divers_turnover), "");
            for (RankProductDiver items_diver : items_divers) {
                data.put(AppVarUtils.printMultiply(items_diver.getQuantity()) + " * " + items_diver.getName(), AppVarUtils.printPrice(items_diver.getTurnover()));
            }
        }
        data.put("Chiffre d'affaire par employ\u00e9", "");
        for (UserCaisseInfo user : users) {
            data.put(user.getName(), user.printTotal());
        }
        data.put(" Chiffre d'affaire par " + (chiffePerUnit.equals("h") ? "heure" : (chiffePerUnit.equals("j") ? "jour" : "mois")) + "  ", "");
        for (TurnoverInfo entry : salesByUnit) {
            Integer key = entry.getIndex();
            Double value = entry.getturnover();
            String numberUnit = chiffePerUnit.equals("h") ? key + "h" : (chiffePerUnit.equals("j") ? "Le " + key + " " + DateUtils.getNameOfMonth(dateStart.getMonth() + 1) : DateUtils.getNameOfMonth(key));
            data.put(numberUnit, Formats.CURRENCY.formatValue(value));
        }
        data.put(" TVA ", "");
        data.put("TVA \u00e0 reverser ", Formats.CURRENCY.formatValue(tvas));
        for (TaxeLine taxe : taxes) {
            data.put("TVA " + taxe.getName(), Formats.CURRENCY.formatValue(taxe.getTax()));
        }
        data.put(" R\u00e9duction et promotions ", "");
        data.put("R\u00e9ductions sur les commandes ", Formats.CURRENCY.formatValue(discountOrders));
        data.put("R\u00e9ductions sur les articles ", Formats.CURRENCY.formatValue(discountOnLines));
        data.put(" R\u00e9sum\u00e9 ", "");
        data.put("Chiffre d'affaire total  ", Formats.CURRENCY.formatValue(caNet));
        data.put("Chiffre d'affaire Annul\u00e9 ", Formats.CURRENCY.formatValue(caCanceld));
        if (caisse != null && caisse.getFondCaisse() > 0.0) {
            data.put("Fond de caisse \u00e0 l'ouverture ", Formats.CURRENCY.formatValue(caisse.getFondCaisse()));
        }
        if (caisse != null && caisse.getFondClose() > 0.0 && caisse.getDateOpen().before(caisse.getDateClose())) {
            data.put("Fond de caisse \u00e0 la fermeture ", Formats.CURRENCY.formatValue(caisse.getFondClose()));
        }
        return data;
    }

    public synchronized void doClotureAutomatique(Date now, boolean borne) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(now);
        cal.add(5, -1);
        if (!this.m_appview.getM_dlItems().isClotured("j", cal.getTime())) {
            try {
                System.out.println("+++++++++++++ close automoatically 2");
                this.closeCaisseAutomatiqueDay(true);
                ExecutorService exec = Executors.newSingleThreadExecutor();
                exec.execute(() -> Platform.runLater(() -> {
                    try {
                        if (AppLocal.IS_STATS_ONLINE_ENABLED.booleanValue()) {
                            this.mPostgreService = PostgreService.getInstance();
                            this.mPostgreService.SendDataToPostgree();
                        }
                        this.mFirebaseService = FirebaseService.getInstance();
                        this.mFirebaseService.uploadAllNF525Archives();
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }));
                cal.setTime(now);
                if (borne) {
                    this.m_appview.checkbeforeshowborne();
                } else {
                    this.m_appview.closeAppView();
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public synchronized void doClotureAutomatiqueSelfCheckout(Date now) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(now);
        cal.add(5, -1);
        if (!this.m_appview.getM_dlItems().isClotured("j", cal.getTime())) {
            try {
                System.out.println("+++++++++++++ close automoatically 2");
                this.closeCaisseAutomatiqueDay(true);
                ExecutorService exec = Executors.newSingleThreadExecutor();
                exec.execute(() -> Platform.runLater(() -> {
                    try {
                        if (AppLocal.IS_STATS_ONLINE_ENABLED.booleanValue()) {
                            this.mPostgreService = PostgreService.getInstance();
                            this.mPostgreService.SendDataToPostgree();
                        }
                        this.mFirebaseService = FirebaseService.getInstance();
                        this.mFirebaseService.uploadAllNF525Archives();
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }));
                cal.setTime(now);
                this.m_appview.showSelfcheckoutWithoutCashlogy();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public boolean isAfterHour(Date today, int hour) {
        if (DateUtils.isAfterHour(today, hour)) {
            return true;
        }
        try {
            long diff;
            long HoursDiff;
            GrandTotalPeriode lastGrandTotalPeriode = this.m_appview.getM_dlItems().getLastGrandTotalPeriode("j");
            if (lastGrandTotalPeriode != null && (HoursDiff = TimeUnit.HOURS.convert(diff = today.getTime() - lastGrandTotalPeriode.getTimestampGDH().getTime(), TimeUnit.MILLISECONDS)) > 30L) {
                return true;
            }
        }
        catch (BasicException ex) {
            Logger.getLogger(RootAppController.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    public void clotureCaisse(final boolean borne) {
        final Calendar cal = Calendar.getInstance();
        final Date today = new Date();
        cal.setTime(today);
        cal.add(5, -1);
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (!ClotureService.this.m_appview.getM_dlItems().isFirstDay() && !ClotureService.this.m_appview.getM_dlItems().isClotured("j", cal.getTime()) && ClotureService.this.isAfterHour(today, 6)) {
                    AppLocal.START_CLOTURE = true;
                    Platform.runLater(() -> ClotureService.this.support.firePropertyChange("start_cloture", null, null));
                    try {
                        System.out.println("++++++++++++++++ cloture day");
                        ClotureService.this.closeCaisseAutomatiqueDay(false);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", null, ex);
                    }
                }
                cal.setTime(today);
                cal.add(2, -1);
                if (!ClotureService.this.m_appview.getM_dlItems().isFirstMonth() && !ClotureService.this.m_appview.getM_dlItems().isClotured("m", cal.getTime()) && ClotureService.this.isAfterHour(today, 6)) {
                    try {
                        if (!AppLocal.START_CLOTURE) {
                            AppLocal.START_CLOTURE = true;
                            Platform.runLater(() -> ClotureService.this.support.firePropertyChange("start_cloture", null, null));
                        }
                        ClotureService.this.closeCaisseAutomatiqueMonth(false);
                        if (!borne) {
                            AppLocal.isBackupRecomended = true;
                        }
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", null, ex);
                    }
                }
                if (AppLocal.IS_STATS_ONLINE_ENABLED.booleanValue()) {
                    ClotureService.this.mPostgreService = PostgreService.getInstance();
                    ClotureService.this.mPostgreService.SendDataToPostgree();
                    ClotureService.this.mPostgreService.doSynchronizeOrderDataTimer();
                }
                ClotureService.this.mZGlobalService = ZGlobalService.getInstance();
                ClotureService.this.mZGlobalService.addToZGlobal("borne");
                try {
                    ClotureService.this.mFirebaseService = FirebaseService.getInstance();
                    ClotureService.this.mFirebaseService.uploadAllNF525Archives();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", null, ex);
                }
                AppLocal.START_CLOTURE = false;
                Platform.runLater(() -> ClotureService.this.support.firePropertyChange("end_cloture", null, null));
            }
        }).start();
    }

    public HashMap<String, Object> getFinancialReportInfo(Date dateStart, Date dateEnd) throws BasicException {
        HashMap<String, Object> map_infos = new HashMap<String, Object>();
        Integer m_iSales = 0;
        Double allProduct = 0.0;
        Double nbproduct = 0.0;
        Double nbProductDiver = 0.0;
        Double caCanceled = 0.0;
        Double total_cash = 0.0;
        Double total_cb = 0.0;
        Double total_avoir_decaisse = 0.0;
        Double total_avoir_encaisse = 0.0;
        Double total_tr = 0.0;
        Double total_debit = 0.0;
        Double total_cashdro = 0.0;
        Double total_cashglory = 0.0;
        Double total_cheque = 0.0;
        Double total_loyalty_card = 0.0;
        Double total_credit_employe = 0.0;
        Double total_virment = 0.0;
        Double tva_5_5_ht = 0.0;
        Double tva_10_ht = 0.0;
        Double tva_20_ht = 0.0;
        Double total_at_spot = 0.0;
        Double total_take_away = 0.0;
        Double total_delivery = 0.0;
        Double total_uber = 0.0;
        Double total_delivero = 0.0;
        Double total_just_eat = 0.0;
        Double tva_0_ht = 0.0;
        Double total_drive = 0.0;
        Double tva_7_7_ht = 0.0;
        Double tva_2_5_ht = 0.0;
        Double tva_2_1_ht = 0.0;
        Double tva_8_5_ht = 0.0;
        Double total_smood = 0.0;
        Double total_twint = 0.0;
        Double total_cheque_total = 0.0;
        Double tva_6_ht = 0.0;
        Double tva_12_ht = 0.0;
        Double tva_21_ht = 0.0;
        Double tps = 0.0;
        Double tvq = 0.0;
        Double credit_card_total = 0.0;
        Double debit_card_total = 0.0;
        Double tva_8_1_ht = 0.0;
        Double tva_2_6_ht = 0.0;
        int number_orders_platform = 0;
        Double cash_glogy_total = 0.0;
        Double total_dishop = 0.0;
        double total_stripe = 0.0;
        int number_at_spot = 0;
        int number_take_away = 0;
        int number_delivery = 0;
        int number_drive = 0;
        double total_ht_at_spot = 0.0;
        double total_ht_take_away = 0.0;
        double total_ht_delivery = 0.0;
        double total_ht_drive = 0.0;
        Double total_carte_tr = 0.0;
        Double total_bank_transfer = 0.0;
        int year = dateStart.getYear() + 1900;
        int month = dateStart.getMonth() + 1;
        System.out.println("++++++++++++ dateStart : " + dateStart);
        System.out.println("++++++++++++ dateEnd : " + dateEnd);
        List<PaymentLine> payments = this.dlStats.loadPaymentXDay(dateStart, dateEnd);
        m_iSales = this.dlStats.getNbOrderXDay(dateStart, dateEnd);
        caCanceled = this.dlStats.getCACanceledXDay(dateStart, dateEnd);
        nbproduct = this.dlStats.getNbProduitXDay(dateStart, dateEnd);
        nbProductDiver = this.dlStats.getNbProduitDiversXDay(dateStart, dateEnd);
        List<TaxLineTicket> taxes = this.dlStats.getTaxeXDayTicket(dateStart, dateEnd);
        Double totalDiscount = this.dlStats.getTotalDiscountOrderOfType(dateStart, dateEnd, "pourcentage") + this.dlStats.getTotalDiscountOrderOfType(dateStart, dateEnd, "somme");
        Double totalDiscountOnLines = this.dlStats.getTotalDiscountOnTicketLines(dateStart, dateEnd);
        double turnover_platform = this.dlStats.getTurnoverPlatformXDay(dateStart, dateEnd);
        List<GroupedTax> globalTaxes = this.dlStats.getGlobalTaxes(dateStart, dateEnd);
        TotaleEncaissement totaleEncaissement = this.dlStats.getTotalEncaissement(dateStart, dateEnd);
        double total_ht_taxable = totaleEncaissement != null ? totaleEncaissement.getTotal_ht_taxable() : 0.0;
        double total_ht_no_taxable = totaleEncaissement != null ? totaleEncaissement.getTotal_ht_no_taxable() : 0.0;
        double total_orders_deliveroo = 0.0;
        int nb_cb = 0;
        int nb_tr = 0;
        int nb_carte_tr = 0;
        List<RankTypeOrder> dataTypeOrders = this.dlStats.loadSatisticOrderByType(dateStart, dateEnd);
        if (dataTypeOrders != null) {
            for (RankTypeOrder typeOrder : dataTypeOrders) {
                switch (typeOrder.getName()) {
                    case "Sur Place": {
                        total_at_spot = typeOrder.getCa();
                        number_at_spot = (int)typeOrder.getCount();
                        break;
                    }
                    case "A Emporter": {
                        total_take_away = typeOrder.getCa();
                        number_take_away = (int)typeOrder.getCount();
                        break;
                    }
                    case "En Livraison": {
                        total_delivery = typeOrder.getCa();
                        number_delivery = (int)typeOrder.getCount();
                        break;
                    }
                    case "Uber Eats": {
                        total_uber = typeOrder.getCa();
                        break;
                    }
                    case "Delivero": {
                        total_delivero = typeOrder.getCa();
                        break;
                    }
                    case "Just Eat": {
                        total_just_eat = typeOrder.getCa();
                        break;
                    }
                    case "Drive": {
                        total_drive = typeOrder.getCa();
                        number_drive = (int)typeOrder.getCount();
                        break;
                    }
                    case "Smood": {
                        total_smood = typeOrder.getCa();
                        break;
                    }
                    case "Dishop": {
                        total_dishop = typeOrder.getCa();
                    }
                }
            }
        }
        if (payments != null) {
            for (PaymentLine payment : payments) {
                switch (payment.getM_PaymentType()) {
                    case "Espece": {
                        total_cash = payment.getM_PaymentValue();
                        break;
                    }
                    case "Debit": {
                        total_debit = payment.getM_PaymentValue();
                        break;
                    }
                    case "Cashdro": {
                        total_cashdro = payment.getM_PaymentValue();
                        break;
                    }
                    case "cashGlory": {
                        total_cashglory = payment.getM_PaymentValue();
                        break;
                    }
                    case "Ticket Resto": {
                        total_tr = payment.getM_PaymentValue();
                        nb_tr = payment.getNombre();
                        break;
                    }
                    case "Avoir": {
                        if (payment.getM_PaymentValue() > 0.0) {
                            total_avoir_encaisse = payment.getM_PaymentValue();
                            break;
                        }
                        total_avoir_decaisse = payment.getM_PaymentValue();
                        break;
                    }
                    case "cheque": {
                        total_cheque = payment.getM_PaymentValue();
                        break;
                    }
                    case "CB": {
                        total_cb = payment.getM_PaymentValue();
                        nb_cb = payment.getNombre();
                        break;
                    }
                    case "Cr\u00e9dit Employ\u00e9": {
                        total_credit_employe = payment.getM_PaymentValue();
                        break;
                    }
                    case "Carte Fid\u00e9lit\u00e9": {
                        total_loyalty_card = payment.getM_PaymentValue();
                        break;
                    }
                    case "Virement": {
                        total_virment = payment.getM_PaymentValue();
                        number_orders_platform = payment.getNombre();
                        break;
                    }
                    case "Twint": {
                        total_twint = payment.getM_PaymentValue();
                        break;
                    }
                    case "Ch\u00e8que vacances": {
                        total_cheque_total = payment.getM_PaymentValue();
                        break;
                    }
                    case "Cashlogy": {
                        cash_glogy_total = payment.getM_PaymentValue();
                        break;
                    }
                    case "stripe": {
                        total_stripe = payment.getM_PaymentValue();
                        break;
                    }
                    case "carte credit": {
                        credit_card_total = payment.getM_PaymentValue();
                        break;
                    }
                    case "carte debit": {
                        debit_card_total = payment.getM_PaymentValue();
                        break;
                    }
                    case "Carte Ticket Resto": {
                        total_carte_tr = payment.getM_PaymentValue();
                        nb_carte_tr = payment.getNombre();
                        break;
                    }
                    case "Virement bancaire": {
                        total_bank_transfer = payment.getM_PaymentValue();
                    }
                }
            }
        }
        allProduct = nbproduct + nbProductDiver;
        double TVA_5_5 = 0.055;
        double TVA_10 = 0.1;
        double TVA_20 = 0.2;
        double TVA_0 = 0.0;
        double TVA_7_7 = 0.077;
        double TVA_2_5 = 0.025;
        double TVA_2_1 = 0.021;
        double TVA_8_5 = 0.085;
        double TVA_6 = 0.06;
        double TVA_12 = 0.12;
        double TVA_21 = 0.21;
        double TVA_8_1 = 0.081;
        double TVA_2_6 = 0.026;
        for (TaxLineTicket taxLineTicket : taxes) {
            if (taxLineTicket == null) continue;
            if (taxLineTicket.getRate() == 0.055) {
                tva_5_5_ht = tva_5_5_ht + taxLineTicket.getSumHT();
            }
            if (taxLineTicket.getRate() == 0.1) {
                tva_10_ht = tva_10_ht + taxLineTicket.getSumHT();
            }
            if (taxLineTicket.getRate() == 0.2) {
                tva_20_ht = tva_20_ht + taxLineTicket.getSumHT();
            }
            if (taxLineTicket.getRate() == 0.0) {
                tva_0_ht = tva_0_ht + taxLineTicket.getSumHT();
            }
            if (taxLineTicket.getRate() == 0.077) {
                tva_7_7_ht = tva_7_7_ht + taxLineTicket.getSumHT();
            }
            if (taxLineTicket.getRate() == 0.025) {
                tva_2_5_ht = tva_2_5_ht + taxLineTicket.getSumHT();
            }
            if (taxLineTicket.getRate() == 0.021) {
                tva_2_1_ht = tva_2_1_ht + taxLineTicket.getSumHT();
            }
            if (taxLineTicket.getRate() == 0.085) {
                tva_8_5_ht = tva_8_5_ht + taxLineTicket.getSumHT();
            }
            if (taxLineTicket.getRate() == 0.06) {
                tva_6_ht = tva_6_ht + taxLineTicket.getSumHT();
            }
            if (taxLineTicket.getRate() == 0.12) {
                tva_12_ht = tva_12_ht + taxLineTicket.getSumHT();
            }
            if (taxLineTicket.getRate() == 0.21) {
                tva_21_ht = tva_21_ht + taxLineTicket.getSumHT();
            }
            if (taxLineTicket.getRate() == 0.081) {
                tva_8_1_ht = tva_8_1_ht + taxLineTicket.getSumHT();
            }
            if (taxLineTicket.getRate() != 0.026) continue;
            tva_2_6_ht = tva_2_6_ht + taxLineTicket.getSumHT();
        }
        List<RankTypeOrder> dataTypePlatformOrders = this.dlStats.loadPlatformOrdersByType(dateStart, dateEnd);
        if (dataTypePlatformOrders != null) {
            for (RankTypeOrder typeOrder : dataTypePlatformOrders) {
                if (typeOrder.getName() == null) continue;
                switch (typeOrder.getName()) {
                    case "Uber Eats": {
                        total_uber = total_uber + typeOrder.getCa();
                        break;
                    }
                    case "Just Eat": {
                        total_just_eat = total_just_eat + typeOrder.getCa();
                        break;
                    }
                    case "Smood": {
                        total_smood = total_smood + typeOrder.getCa();
                        break;
                    }
                    case "Deliveroo": {
                        total_orders_deliveroo = typeOrder.getCa();
                    }
                }
            }
        }
        List<RankTypeOrder> list = this.dlStats.loadHtTotalOrderByType(dateStart, dateEnd);
        if (dataTypeOrders != null) {
            for (RankTypeOrder typeOrder : list) {
                switch (typeOrder.getName()) {
                    case "Sur Place": {
                        total_ht_at_spot = typeOrder.getCa();
                        break;
                    }
                    case "A Emporter": {
                        total_ht_take_away = typeOrder.getCa();
                        break;
                    }
                    case "En Livraison": {
                        total_ht_delivery = typeOrder.getCa();
                        break;
                    }
                    case "Drive": {
                        total_ht_drive = typeOrder.getCa();
                    }
                }
            }
        }
        map_infos.put("NUMBER_ORDERS", m_iSales);
        map_infos.put("CASH_TOTAL", total_cash);
        map_infos.put("CB_TOTAL", total_cb);
        map_infos.put("TR_TOTAL", total_tr);
        map_infos.put("DEBIT_TOTAL", total_debit);
        map_infos.put("CREDIT_EMPLOYEE_TOTAL", total_credit_employe);
        map_infos.put("LOYALTY_CARD", total_loyalty_card);
        map_infos.put("CASHDRO_TOTAL", total_cashdro);
        map_infos.put("CACH_GLORY_TOTAL", total_cashglory);
        map_infos.put("VIRMENT_TOTAL", total_virment);
        map_infos.put("CHEQUE_TOTAL", total_cheque);
        map_infos.put("AVOIR_TOTAL_DECAISSE", total_avoir_decaisse);
        map_infos.put("AVOIR_TOTAL_ENCAISSE", total_avoir_encaisse);
        map_infos.put("TVA_5_5_HT", tva_5_5_ht);
        map_infos.put("TVA_10_HT", tva_10_ht);
        map_infos.put("TVA_20_HT", tva_20_ht);
        map_infos.put("NUMBER_PRODUCTS_SOLD", allProduct);
        map_infos.put("TURNOVER_CANCELED", caCanceled);
        map_infos.put("TOTAL_ORDERS_AT_SPOT", total_at_spot);
        map_infos.put("TOTAL_ORDERS_TAKE_AWAY", total_take_away);
        map_infos.put("TOTAL_ORDERS_DELIVERY", total_delivery);
        map_infos.put("TOTAL_ORDERS_UBER", total_uber);
        map_infos.put("TOTAL_ORDERS_DELIVERO", total_delivero);
        map_infos.put("NUMBER_CB", nb_cb);
        map_infos.put("NUMBER_TR", nb_tr);
        map_infos.put("TOTAL_DISCOUNT", totalDiscount);
        map_infos.put("TOTAL_DISCOUNT_LINES", totalDiscountOnLines);
        map_infos.put("TOTAL_ORDERS_JUST_EAT", total_just_eat);
        map_infos.put("TVA_0_HT", tva_0_ht);
        map_infos.put("TOTAL_ORDERS_DRIVE", total_drive);
        map_infos.put("TVA_7_7_HT", tva_7_7_ht);
        map_infos.put("TVA_2_5_HT", tva_2_5_ht);
        map_infos.put("TVA_2_1_HT", tva_2_1_ht);
        map_infos.put("TVA_8_5_HT", tva_8_5_ht);
        map_infos.put("TWINT_TOTAL", total_twint);
        map_infos.put("TOTAL_ORDERS_SMOOD", total_smood);
        map_infos.put("CHEQUE_VACANCES_TOTAL", total_cheque_total);
        map_infos.put("TURNOVER_PLATFORM", turnover_platform);
        map_infos.put("NUMBER_ORDERS_PLATFORM", number_orders_platform);
        map_infos.put("TOTAL_ORDERS_DISHOP", total_dishop);
        map_infos.put("STRIPE_TOTAL", total_stripe);
        map_infos.put("TOTAL_ORDERS_DELIVEROO", total_orders_deliveroo);
        map_infos.put("TVA_6_HT", tva_6_ht);
        map_infos.put("TVA_12_HT", tva_12_ht);
        map_infos.put("TVA_21_HT", tva_21_ht);
        map_infos.put("TURNOVER_UBEREAT", total_uber);
        map_infos.put("CASH_LOGY_TOTAL", cash_glogy_total);
        map_infos.put("TVA_8_1_HT", tva_8_1_ht);
        map_infos.put("TVA_2_6_HT", tva_2_6_ht);
        map_infos.put("TPS", tps);
        map_infos.put("TVQ", tvq);
        map_infos.put("CREDIT_CARD_TOTAL", credit_card_total);
        map_infos.put("DEBIT_CARD_TOTAL", debit_card_total);
        map_infos.put("TOTAL_HT_TAXABLE", total_ht_taxable);
        map_infos.put("TOTAL_HT_NO_TAXABLE", total_ht_no_taxable);
        map_infos.put("TAXES", globalTaxes);
        map_infos.put("TOTAL_HT_ORDERS_AT_SPOT", total_ht_at_spot);
        map_infos.put("TOTAL_HT_ORDERS_TAKE_AWAY", total_ht_take_away);
        map_infos.put("TOTAL_HT_ORDERS_DELIVERY", total_ht_delivery);
        map_infos.put("TOTAL_HT_ORDERS_DRIVE", total_ht_drive);
        map_infos.put("NUMBER_ORDERS_AT_SPOT", number_at_spot);
        map_infos.put("NUMBER_ORDERS_TAKE_AWAY", number_take_away);
        map_infos.put("NUMBER_ORDERS_DELIVERY", number_delivery);
        map_infos.put("NUMBER_ORDERS_DRIVE", number_drive);
        map_infos.put("CARTE_TR_TOTAL", total_carte_tr);
        map_infos.put("BANK_TRANSFER_TOTAL", total_bank_transfer);
        map_infos.put("NUMBER_CARTE_TR", nb_carte_tr);
        return map_infos;
    }

    public void updateNumberPlatform() throws BasicException, ParseException {
        System.out.println("++++++++ updateNumberPlatform :");
        List<GrandTotalPeriode> gtp = AppLocal.dlItems.loadGrandTotalPeriod("j");
        for (GrandTotalPeriode grandTotalPeriode : gtp) {
            Date dateEnd = new Date();
            Date dateStart = DateUtils.SDF_YYYYMMDD.parse(grandTotalPeriode.getId());
            DateUtils.setDateHours(dateStart, dateEnd);
            PaymentLine payment = this.dlStats.loadPaymentXDay(dateStart, dateEnd, "Virement");
            System.out.println("payment " + payment);
            int number_order_platform = payment != null ? payment.getNombre() : 0;
            System.out.println("number_order_platform : " + number_order_platform);
            System.out.println("grandTotalPeriode.getId() : " + grandTotalPeriode.getId());
            this.dlSales.updateGTP(number_order_platform, grandTotalPeriode.getId());
        }
    }
}

