/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.service;

import com.openbravo.keen.CassandraManager;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.GagSSL;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.norm.beans.Client;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class ClientService {
    private static final String API_URL = "http://api-version.biborne.com";
    private static final String URL_CLIENT = "http://api-version.biborne.com/clients";
    private CassandraManager m_keenProject;

    public void synchronizeClientInfos(MarqueNFC marque) throws JSONException {
        JSONObject json = new JSONObject();
        Client client = new Client("" + AppLocal.getLicenceId(), "" + AppLocal.getActivationId(), marque.getCompany(), marque.getAdresse1() + " " + marque.getCity() + " " + marque.getCountry(), marque.getEmail(), marque.getTel(), marque.getSiret(), new Date(), marque.getIntraTVA(), marque.getZipCode());
        if (this.m_keenProject != null) {
            String user_keen_id = this.m_keenProject.readUserInfoInflux();
            HashMap<String, String> clientMap = new HashMap<String, String>();
            clientMap.put("licenceId", client.getLicenceId());
            clientMap.put("activationId", client.getActivationId());
            clientMap.put("company", client.getCompany());
            clientMap.put("adresse", client.getAdresse());
            clientMap.put("email", client.getEmail());
            clientMap.put("tel", client.getTel());
            clientMap.put("siret", client.getSiret());
            clientMap.put("tvaIntra", client.getTvaIntra());
            clientMap.put("zipCode", client.getZipCode());
            clientMap.put("teamviewerId", LogToFile.getTeamViewerId());
            clientMap.put("token", AppLocal.token);
            clientMap.put("userKeenId", user_keen_id);
            json.put("client", clientMap);
            json.put("appName", (Object)"Procaisse");
            json.put("soft", (Object)"10.0.1.27");
            json.put("code", (Object)AppVarUtils.generatorDailyCode());
            JSONObject jSONObject = this.postToServer(json.toString(1));
        }
    }

    private JSONObject postToServer(String json) throws JSONException {
        OkHttpClient client = GagSSL.getUnsafeOkHttpClient();
        JSONObject jsn = null;
        System.out.println("++ json : " + json);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)json);
        Request request = new Request.Builder().url(URL_CLIENT).post(requestBody).build();
        try (Response response = client.newCall(request).execute();){
            int httpResponseCode = response.code();
            System.out.println("+++++++++++ httpResponseCode : " + httpResponseCode);
            String string = response.body().string();
        }
        catch (IOException ex) {
            LogToFile.log("severe", null, ex);
        }
        return jsn;
    }

    public void updatePOSVersion() {
        try {
            String keenio = "";
            String siret = "";
            MarqueNFC marqueNF = MarqueNFC.fetchOrStore(AppLocal.dlSales);
            if (marqueNF != null && marqueNF.getSiret() != null && !marqueNF.getSiret().isEmpty()) {
                siret = marqueNF.getSiret();
            }
            if (AppLocal.dlItems != null && (keenio = AppLocal.dlItems.getUserKeenIo()) == null) {
                keenio = "-";
            }
            JSONObject jsonBody = new JSONObject();
            jsonBody.put("siret", (Object)siret);
            jsonBody.put("keenio", (Object)keenio);
            jsonBody.put("version", (Object)"10.0.1.27");
            jsonBody.put("name", (Object)AppLocal.source_order);
            OkHttpClient client = new OkHttpClient();
            String url = "https://json.biborne.com/api/v1/VersionRestaurant/checkAndChangeVersion";
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonBody.toString());
            Request request = new Request.Builder().url(url).post(requestBody).build();
            Response response = client.newCall(request).execute();
            System.out.println("+++++++++ response : " + response);
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public void sendVersion() {
    }
}

