/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.service;

import com.openbravo.basic.BasicException;
import com.openbravo.basic.BasicStorage;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.util.DateUtils;
import fr.protactile.norm.beans.GrandTotalPeriode;
import fr.protactile.procaisse.dao.entities.CaisseInfo;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CleanerService {
    private AppView m_App;
    private DataLogicItems m_dlItems;
    private Date m_today;
    private final String[] periods = new String[]{"j", "m", "a"};

    private CleanerService() {
        this.m_App = (AppView)BasicStorage.getObject("APP_ROOT_INSTANCE");
        if (this.m_App == null) {
            throw new UnsupportedOperationException("Une erreur est survenu lors d'initialisation de m_AppView");
        }
        this.m_dlItems = (DataLogicItems)this.m_App.getBean("com.openbravo.dao.DataLogicItems");
        this.m_today = new Date();
    }

    private boolean isPosOpen() {
        try {
            CaisseInfo m_caisse = this.m_dlItems.getCaisse(AppLocal.token);
            if (m_caisse == null) {
                return true;
            }
            return m_caisse.isOuverte();
        }
        catch (BasicException ex) {
            Logger.getLogger(CleanerService.class.getName()).log(Level.SEVERE, null, ex);
            return true;
        }
    }

    public static CleanerService build() {
        return new CleanerService();
    }

    public void cleanClotureAfterToday() throws BasicException {
        if (this.isPosOpen()) {
            throw new UnsupportedOperationException("La caisse est d\u00e9j\u00e0 ouverte, veuillez fermer la caisse d'abord");
        }
        Calendar mCalendar = Calendar.getInstance();
        for (String period : this.periods) {
            GrandTotalPeriode grandTotalPeriode = this.m_dlItems.getLastGrandTotalPeriode(period);
            ArrayList<String> ids_to_clean = new ArrayList<String>();
            if (grandTotalPeriode != null) {
                String id = null;
                switch (period) {
                    case "j": {
                        Date lastDateInsered = DateUtils.validateDateFormat(grandTotalPeriode.getId(), "yyyyMMdd");
                        if (lastDateInsered == null) break;
                        while (lastDateInsered.after(this.m_today) || lastDateInsered.getDate() == this.m_today.getDate() && lastDateInsered.getMonth() == this.m_today.getMonth() && lastDateInsered.getYear() == this.m_today.getYear()) {
                            mCalendar.setTime(lastDateInsered);
                            id = DateUtils.SDF_ID_DAY_PERIOD.format(mCalendar.getTime());
                            ids_to_clean.add(id);
                            mCalendar.add(5, -1);
                            lastDateInsered = mCalendar.getTime();
                        }
                        break;
                    }
                    case "m": {
                        Date lastMonthInsered = DateUtils.validateDateFormat(grandTotalPeriode.getId(), "yyyyMM");
                        if (lastMonthInsered == null) break;
                        while (lastMonthInsered.after(this.m_today) || lastMonthInsered.getMonth() == this.m_today.getMonth() && lastMonthInsered.getYear() == this.m_today.getYear()) {
                            mCalendar.setTime(lastMonthInsered);
                            id = DateUtils.SDF_ID_MONTH_PERIOD.format(mCalendar.getTime());
                            ids_to_clean.add(id);
                            mCalendar.add(2, -1);
                            lastMonthInsered = mCalendar.getTime();
                        }
                        break;
                    }
                    case "a": {
                        Date lastYear = DateUtils.validateDateFormat(grandTotalPeriode.getId(), "yyyy");
                        if (lastYear == null) break;
                        while (lastYear.after(this.m_today) || lastYear.getYear() == this.m_today.getYear()) {
                            mCalendar.setTime(lastYear);
                            id = DateUtils.SDF_ID_YEAR_PERIOD.format(mCalendar.getTime());
                            ids_to_clean.add(id);
                            mCalendar.add(1, -1);
                            lastYear = mCalendar.getTime();
                        }
                        break;
                    }
                }
            }
            if (ids_to_clean.size() <= 0) continue;
            for (String idPeriodToClean : ids_to_clean) {
                this.m_dlItems.cleanByPeriodId(idPeriodToClean);
            }
        }
    }
}

