/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.service;

import com.openbravo.basic.BasicException;
import com.openbravo.beans.CarteMenu;
import com.openbravo.pos.admin.User;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.CarteInfo;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.GroupSubSupplementInfo;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.ticket.PhotoDispaly;
import com.openbravo.pos.ticket.PrinterInfo;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.PromotionInfo;
import com.openbravo.pos.ticket.SupplementInfo;
import com.openbravo.pos.util.LogToFile;
import java.util.ArrayList;
import java.util.List;

public class CarteSyncService {
    private static final String NETWORK_LABEL = "R\u00e9seau";

    public static List<CategoryInfo> getCategories() {
        ArrayList<CategoryInfo> categories = new ArrayList();
        try {
            categories = AppLocal.dlItems.getCategories(true, false, true);
        }
        catch (BasicException ex) {
            ex.printStackTrace();
            return null;
        }
        return categories;
    }

    public static List<PrinterInfo> getPrinters() {
        ArrayList<PrinterInfo> printers = new ArrayList();
        try {
            printers = AppLocal.dlItems.getPrinterByMode(NETWORK_LABEL);
        }
        catch (BasicException ex) {
            ex.printStackTrace();
            return null;
        }
        return printers;
    }

    public static List<ProductInfoExt> getItems() {
        ArrayList<ProductInfoExt> products = new ArrayList();
        try {
            products = AppLocal.dlItems.getAllItems(false, false);
        }
        catch (BasicException ex) {
            ex.printStackTrace();
            return null;
        }
        return products;
    }

    public static List<SupplementInfo> getSupplements() {
        ArrayList<SupplementInfo> supplements = new ArrayList();
        try {
            supplements = AppLocal.dlItems.getAllSupplements(false);
        }
        catch (BasicException ex) {
            ex.printStackTrace();
            return null;
        }
        return supplements;
    }

    public static List<CarteInfo> getCartes() {
        ArrayList<CarteInfo> cartes = new ArrayList();
        try {
            cartes = AppLocal.dlItems.getAllCartes(false);
        }
        catch (BasicException ex) {
            ex.printStackTrace();
            return null;
        }
        return cartes;
    }

    public static List<CarteMenu> getCarteMenu() {
        List<CarteMenu> carteMenu;
        try {
            carteMenu = AppLocal.dlItems.getCarteMenus();
        }
        catch (BasicException ex) {
            ex.printStackTrace();
            return null;
        }
        return carteMenu;
    }

    public static MarqueNFC getMarque() {
        try {
            return AppLocal.dlItems.getMarqueNF();
        }
        catch (BasicException ex) {
            return null;
        }
    }

    public static List<User> getUsers() {
        try {
            return AppLocal.dlUser.getSynchroUsers();
        }
        catch (BasicException ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
            return null;
        }
    }

    public static List<PhotoDispaly> getPhotoPub() {
        try {
            return AppLocal.dlSales.getPubPhoto();
        }
        catch (BasicException ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
            return null;
        }
    }

    public static List<PhotoDispaly> getPhotosHome() {
        try {
            return AppLocal.dlSales.getHomeBornePhoto();
        }
        catch (BasicException ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
            return null;
        }
    }

    public static List<PhotoDispaly> getPhotosDualScreen() {
        try {
            return AppLocal.dlSales.getAllPhoto();
        }
        catch (BasicException ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
            return null;
        }
    }

    public static List<GroupSubSupplementInfo> getGroupsSubOptions() {
        ArrayList<GroupSubSupplementInfo> groupsSubOptions = new ArrayList();
        try {
            groupsSubOptions = AppLocal.dlItems.getAllGroupsSubSupplements(false);
        }
        catch (BasicException ex) {
            ex.printStackTrace();
            return null;
        }
        return groupsSubOptions;
    }

    public static List<PromotionInfo> getPromotionsProduct() {
        ArrayList<PromotionInfo> promotions = new ArrayList();
        try {
            promotions = AppLocal.dlItems.getPromotions(true);
        }
        catch (BasicException ex) {
            ex.printStackTrace();
            return null;
        }
        return promotions;
    }
}

