/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.service;

import com.openbravo.basic.BasicException;
import com.openbravo.beans.CarteMenu;
import com.openbravo.beans.ProductSupplementsRelation;
import com.openbravo.beans.ProdustIngredientRelation;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.parser.CarteParser;
import com.openbravo.pos.parser.ResponseObject;
import com.openbravo.pos.ticket.CarteInfo;
import com.openbravo.pos.ticket.CarteItemInfo;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.GroupSubSupplementInfo;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.ticket.PrinterInfo;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.PromotionInfo;
import com.openbravo.pos.ticket.SupplementInfo;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.ZoneInfo;
import com.openbravo.pos.util.CSVUtil;
import com.openbravo.pos.util.Event;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.Journal;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.SystemUtils;
import com.openbravo.pos.util.ZipUtils;
import com.openbravo.service.CarteSyncService;
import com.openbravo.service.ItemService;
import com.procaisse.db.connection.firebase.FirebaseService;
import fr.protactile.procaisse.dao.entities.CarteInfo_DB;
import fr.protactile.procaisse.dao.entities.LanguageInfo;
import fr.protactile.procaisse.dao.entities.LocalScreen;
import fr.protactile.procaisse.dao.entities.NutrientData;
import fr.protactile.procaisse.dao.entities.SettingInfo;
import fr.protactile.procaisse.dao.entities.TagInfo;
import fr.protactile.procaisse.dao.impl.CarteInfo_DB_Dao;
import fr.protactile.procaisse.dao.impl.SettingInfoDao;
import fr.protactile.procaisse.services.LanguageService;
import fr.protactile.procaisse.services.LocalScreenService;
import fr.protactile.procaisse.services.NutrientDataService;
import fr.protactile.procaisse.services.TagsService;
import java.awt.Color;
import java.awt.FlowLayout;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.swing.JDialog;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.io.FileUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.json.JSONArray;
import org.json.JSONTokener;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class CarteService {
    private final DataLogicSales m_dlSales;
    private final AppView app;
    private final DataLogicItems dlItems;
    private String printerFileName = "Carte" + File.separator + "printers.csv";
    private String categorieFileName = "Carte" + File.separator + "categories.csv";
    private String productFileName = "Carte" + File.separator + "products.csv";
    private String ingredientsndSupplementsFileName = "Carte" + File.separator + "ingredientsAndSupplements.csv";
    private String supplementItemsFileName = "Carte" + File.separator + "supplementItems.csv";
    private String carteFileName = "Carte" + File.separator + "cartes.csv";
    private String carteMenusFileName = "Carte" + File.separator + "carteMenus.csv";
    private String cartesItemsFileName = "Carte" + File.separator + "cartesItems.csv";
    private String productsIngredientRelationsFileName = "Carte" + File.separator + "productsIngredientRelations.csv";
    private String productsSupplementRelationsFileName = "Carte" + File.separator + "productsSupplementRelations.csv";
    private String PROCAISSE_CONFIG = SystemUtils.SYS_USER_HOME + File.separator + "procaisse.properties";
    public static final MediaType MEDIA_TYPE_MARKDOWN = MediaType.parse((String)"text/x-markdown; charset=utf-8");
    private ItemService mItemService;
    private FilerUtils mFilerUtils;
    private FirebaseService mFirebaseService;
    private String siret;
    private MarqueNFC marqueNF;
    private CarteInfo_DB_Dao mCarteInfoDao;
    private LanguageService languageService;
    private final String TARIFF = "tarif";
    private final String TYPE_TARIF = "type_tarif";
    private SettingInfoDao mSettingInfoDao;

    public CarteService(DataLogicSales m_dlSales, DataLogicItems dlItems, AppView app) {
        this.m_dlSales = m_dlSales;
        this.dlItems = dlItems;
        this.app = app;
        this.mFilerUtils = FilerUtils.getInstance();
        try {
            this.marqueNF = AppLocal.dlSales.getMarqueNF();
            if (this.marqueNF != null && this.marqueNF.getSiret() != null && !this.marqueNF.getSiret().isEmpty()) {
                this.siret = this.marqueNF.getSiret();
            }
            this.mFirebaseService = FirebaseService.getInstance();
            this.mCarteInfoDao = new CarteInfo_DB_Dao();
            this.mSettingInfoDao = new SettingInfoDao();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void importEntireCarte(File sourceFolder) throws IOException, BasicException, SQLException, ZipException {
        File productsSupplementRelationsFile;
        File productsIngredientRelationsFile;
        int MAX = 100;
        JDialog frame = new JDialog();
        frame.setLocationRelativeTo(null);
        frame.setUndecorated(true);
        JProgressBar pb = new JProgressBar();
        pb.setMinimum(0);
        pb.setMaximum(100);
        pb.setStringPainted(true);
        pb.setBackground(Color.GREEN);
        frame.setLayout(new FlowLayout());
        frame.setAlwaysOnTop(true);
        frame.getContentPane().add(pb);
        pb.setSize(400, 300);
        frame.pack();
        frame.setVisible(true);
        boolean currentValue = false;
        pb.setValue(0);
        ZipFile zip = new ZipFile(sourceFolder.getAbsolutePath());
        String directory = System.getProperty("java.io.tmpdir");
        zip.extractAll(directory);
        File printersFile = new File(directory + this.printerFileName);
        pb.setValue(8);
        pb.setString("l'import des categories");
        Map<Integer, PrinterInfo> printersMap = null;
        if (printersFile.exists()) {
            printersMap = this.importPrinters(printersFile);
        }
        pb.setValue(18);
        File categorieFile = new File(directory + this.categorieFileName);
        Map<Integer, CategoryInfo> categoriesMap = null;
        if (categorieFile.exists()) {
            categoriesMap = this.importCategories(categorieFile, null, true);
        }
        HashMap<Integer, CategoryInfo> categoriesMap_parent = new HashMap<Integer, CategoryInfo>();
        categoriesMap_parent.putAll(categoriesMap);
        Map<Integer, CategoryInfo> categoriesMap_sub = null;
        if (categorieFile.exists()) {
            categoriesMap_sub = this.importCategories(categorieFile, categoriesMap_parent, false);
        }
        if (categoriesMap == null) {
            categoriesMap = new HashMap<Integer, CategoryInfo>();
        }
        categoriesMap.putAll(categoriesMap_sub);
        pb.setValue(28);
        File productFile = new File(directory + this.productFileName);
        Map<Integer, ProductInfoExt> productsMap = null;
        if (productFile.exists()) {
            productsMap = this.importProducts(productFile, printersMap, categoriesMap);
        }
        pb.setValue(28);
        File ingredientsndSupplementsFile = new File(directory + this.ingredientsndSupplementsFileName);
        Map<Integer, SupplementInfo> supplementsMap = null;
        if (ingredientsndSupplementsFile.exists()) {
            supplementsMap = this.importSupplements(ingredientsndSupplementsFile);
        }
        pb.setValue(38);
        File supplementItemsFile = new File(directory + this.supplementItemsFileName);
        Map<Integer, SupplementItemInfo> supplementItemsMap = null;
        if (supplementItemsFile.exists()) {
            supplementItemsMap = this.importSupplementItems(supplementItemsFile, supplementsMap);
        }
        pb.setValue(68);
        File carteFile = new File(directory + this.carteFileName);
        Map<Integer, CarteInfo> carteMap = null;
        if (carteFile.exists()) {
            carteMap = this.importCartes(carteFile);
        }
        pb.setValue(78);
        File carteMenusFile = new File(directory + this.carteMenusFileName);
        if (carteMenusFile.exists()) {
            this.importCartMenus(carteMenusFile, carteMap, productsMap);
        }
        pb.setValue(88);
        File cartesItemsFile = new File(directory + this.cartesItemsFileName);
        if (cartesItemsFile.exists()) {
            this.importCartItems(carteMenusFile, carteMap, productsMap);
        }
        if ((productsIngredientRelationsFile = new File(directory + this.productsIngredientRelationsFileName)).exists()) {
            this.importItemIngredients(productsIngredientRelationsFile, supplementItemsMap, productsMap);
        }
        if ((productsSupplementRelationsFile = new File(directory + this.productsSupplementRelationsFileName)).exists()) {
            this.importItemSupplements(productsSupplementRelationsFile, supplementsMap, productsMap);
        }
        this.importProcaisseProperties(new File(directory + "Carte" + File.separator + "procaisse.properties"));
        pb.setValue(98);
        FilerUtils filerUtils = FilerUtils.getInstance();
        File imagesDirectory = filerUtils.getFileFullPath("images");
        File temporaireDirectoryImages = new File(directory + File.separator + "Carte" + File.separator + "images");
        if (temporaireDirectoryImages.exists()) {
            FileUtils.copyDirectory((File)temporaireDirectoryImages, (File)imagesDirectory);
        }
        pb.setValue(100);
        frame.dispose();
        Journal.writeToJET(new Event(140, "Importation de donn\u00e9es", AppLocal.user != null ? AppLocal.user.getId() : "", "", new Date().getTime(), ""));
    }

    public void exportCarte(final File destinationFolder) throws BasicException, IOException, Exception {
        int MAX = 100;
        final JDialog frame = new JDialog();
        frame.setLocationRelativeTo(null);
        frame.setUndecorated(true);
        final JProgressBar pb = new JProgressBar();
        pb.setMinimum(0);
        pb.setMaximum(100);
        pb.setStringPainted(true);
        pb.setBackground(Color.GREEN);
        frame.setLayout(new FlowLayout());
        frame.setAlwaysOnTop(true);
        frame.getContentPane().add(pb);
        pb.setSize(300, 200);
        frame.pack();
        frame.setVisible(true);
        boolean currentValue = false;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                pb.setValue(0);
                String directory = System.getProperty("java.io.tmpdir");
                try {
                    CarteService.this.exportPrinters(new File(directory + CarteService.this.printerFileName));
                    pb.setValue(8);
                    pb.setString("l'export des categories");
                    CarteService.this.exportCategories(new File(directory + CarteService.this.categorieFileName));
                    pb.setValue(16);
                    pb.setString("l'export des produits");
                    CarteService.this.exportProducts(new File(directory + CarteService.this.productFileName));
                    pb.setValue(24);
                    pb.setString("l'export des ingredients");
                    CarteService.this.exportSupplements(new File(directory + CarteService.this.ingredientsndSupplementsFileName));
                    pb.setValue(32);
                    pb.setString("l'export des options");
                    CarteService.this.exportSupplementItems(new File(directory + CarteService.this.supplementItemsFileName));
                    pb.setValue(40);
                    pb.setString("l'export des familles");
                    CarteService.this.exportFamilles(new File(directory + CarteService.this.carteFileName));
                    pb.setValue(60);
                    pb.setString("l'export des menus");
                    CarteService.this.exportFamillesMenus(new File(directory + CarteService.this.carteMenusFileName));
                    pb.setValue(70);
                    CarteService.this.exportFamillesItems(new File(directory + CarteService.this.cartesItemsFileName));
                    pb.setValue(80);
                    pb.setString("l'export de la structure relationnel");
                    pb.repaint();
                    CarteService.this.exportProductsIngredientRelations(new File(directory + CarteService.this.productsIngredientRelationsFileName));
                    pb.setValue(86);
                    CarteService.this.exportProductsSupplementRelations(new File(directory + CarteService.this.productsSupplementRelationsFileName));
                    File infos = new File(directory + "Carte" + File.separator + "README.txt");
                    FileUtils.write((File)infos, (CharSequence)"Procaisse Version : 10.0.1.27\n");
                    FileUtils.write((File)infos, (CharSequence)("Carte export\u00e9 le : " + new Date()), (boolean)true);
                    FilerUtils filerUtils = FilerUtils.getInstance();
                    File imagesDirectory = filerUtils.getFileFullPath("images");
                    if (imagesDirectory.exists()) {
                        FileUtils.copyDirectoryToDirectory((File)imagesDirectory, (File)new File(directory + File.separator + "Carte"));
                    }
                    File properties = new File(directory + "Carte" + File.separator + "procaisse.properties");
                    FileUtils.copyFile((File)new File(CarteService.this.PROCAISSE_CONFIG), (File)properties);
                    pb.setString("compression des fichies");
                    ZipUtils.zipFolder(directory + "Carte", destinationFolder.getAbsolutePath() + File.separator + "Carte.zip");
                    pb.setValue(100);
                    frame.dispose();
                    Journal.writeToJET(new Event(110, "Exportation de donn\u00e9es", AppLocal.user != null ? AppLocal.user.getId() : "", "", new Date().getTime(), ""));
                }
                catch (BasicException ex) {
                    LogToFile.log("severe", null, ex);
                }
                catch (IOException ex) {
                    LogToFile.log("severe", null, ex);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", null, ex);
                }
            }
        });
    }

    public Map<Integer, SupplementInfo> importSupplements(File sourceFolder) throws IOException, BasicException, SQLException {
        HashMap<Integer, SupplementInfo> supplements = new HashMap<Integer, SupplementInfo>();
        boolean isFirstRow = true;
        for (String supplementLine : FileUtils.readLines((File)sourceFolder, (String)"UTF-8")) {
            if (isFirstRow) {
                isFirstRow = false;
                continue;
            }
            SupplementInfo si = new SupplementInfo(supplementLine);
            this.m_dlSales.addGroupeOption(si, true);
            supplements.put(si.getImportedID(), si);
        }
        return supplements;
    }

    public Map<Integer, CarteInfo> importCartes(File sourceFolder) throws IOException, BasicException, SQLException {
        HashMap<Integer, CarteInfo> mapCartes = new HashMap<Integer, CarteInfo>();
        ArrayList<CarteInfo> cartes = new ArrayList<CarteInfo>();
        boolean isFirstRow = true;
        for (String carteLine : FileUtils.readLines((File)sourceFolder, (String)"UTF-8")) {
            if (isFirstRow) {
                isFirstRow = false;
                continue;
            }
            CarteInfo ci = new CarteInfo(carteLine);
            cartes.add(this.dlItems.addCarte(ci));
            mapCartes.put(ci.getImportedId(), ci);
        }
        return mapCartes;
    }

    public Map<Integer, CategoryInfo> importCategories(File sourceFolder, Map<Integer, CategoryInfo> mapcategories_parent, boolean add_parent) throws IOException, BasicException, SQLException {
        HashMap<Integer, CategoryInfo> mapcategories = new HashMap<Integer, CategoryInfo>();
        boolean isFirstRow = true;
        for (String categoryLine : FileUtils.readLines((File)sourceFolder, (String)"UTF-8")) {
            if (isFirstRow) {
                isFirstRow = false;
                continue;
            }
            CategoryInfo ci = new CategoryInfo(categoryLine);
            if (add_parent) {
                if (ci.getParent_id() != -1) continue;
                this.dlItems.addCategory(ci, false);
                mapcategories.put(ci.getImportedID(), ci);
                continue;
            }
            if (ci.getParent_id() == -1) continue;
            ci.setParent_id(mapcategories_parent.get(ci.getParent_id()).getID());
            this.dlItems.addCategory(ci, false);
            mapcategories.put(ci.getImportedID(), ci);
        }
        return mapcategories;
    }

    public Map<Integer, PrinterInfo> importPrinters(File sourceFolder) throws IOException, BasicException, SQLException {
        HashMap<Integer, PrinterInfo> printersMap = new HashMap<Integer, PrinterInfo>();
        boolean isFirstRow = true;
        for (String printerLine : FileUtils.readLines((File)sourceFolder, (String)"UTF-8")) {
            if (isFirstRow) {
                isFirstRow = false;
                continue;
            }
            PrinterInfo pi = new PrinterInfo(printerLine);
            if (pi.getImportedId() == 1) continue;
            this.m_dlSales.addPrinter(pi);
            printersMap.put(pi.getImportedId(), pi);
        }
        return printersMap;
    }

    public void importCartMenus(File sourceFolder, Map<Integer, CarteInfo> mapCartes, Map<Integer, ProductInfoExt> mapProducts) throws IOException, BasicException, SQLException {
        ArrayList<CarteMenu> carteMenus = new ArrayList<CarteMenu>();
        boolean isFirstRow = true;
        for (String carteMenuLine : FileUtils.readLines((File)sourceFolder, (String)"UTF-8")) {
            if (isFirstRow) {
                isFirstRow = false;
                continue;
            }
            CarteMenu cMTemporaire = new CarteMenu(carteMenuLine);
            CarteInfo cInfo = mapCartes.get(cMTemporaire.getIdCarte());
            ProductInfoExt pInfo = mapProducts.get(cMTemporaire.getIdItem());
            if (cInfo == null || pInfo == null) continue;
            cMTemporaire.setIdCarte(cInfo.getId());
            cMTemporaire.setIdItem(pInfo.getID());
            carteMenus.add(cMTemporaire);
        }
        if (carteMenus.size() > 0) {
            this.dlItems.addCarteMenu(carteMenus);
        }
    }

    public void importCartItems(File sourceFolder, Map<Integer, CarteInfo> mapCartes, Map<Integer, ProductInfoExt> mapProducts) throws IOException, BasicException, SQLException {
        boolean isFirstRow = true;
        for (String carteItemLine : FileUtils.readLines((File)sourceFolder, (String)"UTF-8")) {
            if (isFirstRow) {
                isFirstRow = false;
                continue;
            }
            CarteItemInfo ciTemporaire = new CarteItemInfo(carteItemLine);
            CarteInfo cInfo = mapCartes.get(ciTemporaire.getId_carte());
            ProductInfoExt pInfo = mapProducts.get(ciTemporaire.getId_item());
            if (cInfo == null || pInfo == null) continue;
            ciTemporaire.setId_carte(cInfo.getId());
            ciTemporaire.setId_item(pInfo.getID());
            this.dlItems.addCarteItem(ciTemporaire);
        }
    }

    public Map<Integer, ProductInfoExt> importProducts(File sourceFolder, Map<Integer, PrinterInfo> mapPrinters, Map<Integer, CategoryInfo> mapcategories) throws IOException, BasicException, SQLException {
        HashMap<Integer, ProductInfoExt> mapProducts = new HashMap<Integer, ProductInfoExt>();
        boolean isFirstRow = true;
        for (String productLine : FileUtils.readLines((File)sourceFolder, (String)"UTF-8")) {
            CategoryInfo categoryInfo;
            PrinterInfo printer;
            if (isFirstRow) {
                isFirstRow = false;
                continue;
            }
            ProductInfoExt pi = new ProductInfoExt(productLine);
            if (pi.getPrinterID() > 0 && mapPrinters != null && (printer = mapPrinters.get(pi.getPrinterID())) != null) {
                pi.setPrinterID(printer.getId());
            }
            if (pi.isHasLabel() && pi.getPrinterLabel() > 0 && mapPrinters != null && (printer = mapPrinters.get(pi.getPrinterLabel())) != null) {
                pi.setPrinterLabel(printer.getId());
            }
            if ((categoryInfo = mapcategories.get(pi.getCategoryid())) == null) continue;
            pi.setCategoryid(categoryInfo.getID());
            this.m_dlSales.addProductMaxColumns(pi);
            mapProducts.put(pi.getImportedId(), pi);
        }
        return mapProducts;
    }

    public Map<Integer, SupplementItemInfo> importSupplementItems(File sourceFolder, Map<Integer, SupplementInfo> supplements) throws IOException, BasicException, SQLException {
        HashMap<Integer, SupplementItemInfo> supplementsItemInfos = new HashMap<Integer, SupplementItemInfo>();
        boolean isFirstRow = true;
        for (String supplementItemLine : FileUtils.readLines((File)sourceFolder, (String)"UTF-8")) {
            if (isFirstRow) {
                isFirstRow = false;
                continue;
            }
            SupplementItemInfo si = new SupplementItemInfo(supplementItemLine);
            SupplementInfo sCategory = supplements.get(si.getId_supplement());
            if (sCategory == null) continue;
            si.setId_supplement(sCategory.getiD());
            this.dlItems.addSupplementItem(si);
            supplementsItemInfos.put(si.getImportedID(), si);
        }
        return supplementsItemInfos;
    }

    public void importItemIngredients(File sourceFolder, Map<Integer, SupplementItemInfo> mapSupplementItems, Map<Integer, ProductInfoExt> mapProducts) throws IOException, BasicException, SQLException {
        boolean isFirstRow = true;
        ArrayList<ProdustIngredientRelation> ingredientsProducts = new ArrayList<ProdustIngredientRelation>();
        for (String itemIngredientLine : FileUtils.readLines((File)sourceFolder, (String)"UTF-8")) {
            if (isFirstRow) {
                isFirstRow = false;
                continue;
            }
            ProdustIngredientRelation pIR = new ProdustIngredientRelation(itemIngredientLine);
            ProductInfoExt pInfo = mapProducts.get(pIR.getProductId());
            SupplementItemInfo sInfo = mapSupplementItems.get(pIR.getSupplementId());
            if (pInfo == null || sInfo == null) continue;
            pIR.setProductId(pInfo.getID());
            pIR.setSupplementId(sInfo.getiD());
            pIR.setQuantity(1);
            ingredientsProducts.add(pIR);
        }
        if (ingredientsProducts.size() > 0) {
            this.dlItems.addItemIngredientRelation(ingredientsProducts);
        }
    }

    public void importItemSupplements(File sourceFolder, Map<Integer, SupplementInfo> mapSupplement, Map<Integer, ProductInfoExt> mapProducts) throws IOException, BasicException, SQLException {
        boolean isFirstRow = true;
        ArrayList<ProductSupplementsRelation> productSupplementsRelation = new ArrayList<ProductSupplementsRelation>();
        for (String itemSupplementLine : FileUtils.readLines((File)sourceFolder, (String)"UTF-8")) {
            if (isFirstRow) {
                isFirstRow = false;
                continue;
            }
            ProductSupplementsRelation pIR = new ProductSupplementsRelation(itemSupplementLine);
            ProductInfoExt pInfo = mapProducts.get(pIR.getProductId());
            SupplementInfo sInfo = mapSupplement.get(pIR.getSupplementId());
            if (pInfo == null || sInfo == null) continue;
            pIR.setProductId(pInfo.getID());
            pIR.setSupplementId(sInfo.getiD());
            productSupplementsRelation.add(pIR);
        }
        if (productSupplementsRelation.size() > 0) {
            this.dlItems.addItemSupplements(productSupplementsRelation);
        }
    }

    public void exportSupplementItems(File sourceFolder) throws BasicException, IOException {
        List<SupplementItemInfo> supplementItems = this.m_dlSales.getSupplementItems();
        ArrayList<String> supplementItemsString = new ArrayList<String>();
        if (supplementItems.size() > 0) {
            supplementItemsString.add(supplementItems.get(0).getEntetOfCSV());
            for (SupplementItemInfo pIR : supplementItems) {
                supplementItemsString.add(pIR.getSupplementItemsAsString());
            }
            CSVUtil.writeStringsToCSVFile(sourceFolder, supplementItemsString, false);
        }
    }

    public void exportProductsSupplementRelations(File sourceFolder) throws BasicException, IOException {
        List<ProductSupplementsRelation> productsSupplementRelations = this.m_dlSales.getProductsSupplementRelations();
        ArrayList<String> productsSupplementRelationsString = new ArrayList<String>();
        if (productsSupplementRelations.size() > 0) {
            productsSupplementRelationsString.add(productsSupplementRelations.get(0).getEntetOfCSV());
            for (ProductSupplementsRelation pIR : productsSupplementRelations) {
                productsSupplementRelationsString.add(pIR.getpIRAsString());
            }
            CSVUtil.writeStringsToCSVFile(sourceFolder, productsSupplementRelationsString, false);
        }
    }

    public void exportProductsIngredientRelations(File sourceFolder) throws BasicException, IOException {
        List<ProdustIngredientRelation> productsIngredientRelations = this.m_dlSales.getProductsIngredientRelations();
        ArrayList<String> productsIngredientRelationsString = new ArrayList<String>();
        if (productsIngredientRelations.size() > 0) {
            productsIngredientRelationsString.add(productsIngredientRelations.get(0).getEntetOfCSV());
            for (ProdustIngredientRelation pIR : productsIngredientRelations) {
                productsIngredientRelationsString.add(pIR.getpIRAsString());
            }
            CSVUtil.writeStringsToCSVFile(sourceFolder, productsIngredientRelationsString, false);
        }
    }

    public void exportFamillesMenus(File sourceFolder) throws BasicException, IOException {
        List<CarteMenu> carteMenus = this.m_dlSales.getCarteMenus();
        ArrayList<String> carteMenusString = new ArrayList<String>();
        if (carteMenus.size() > 0) {
            carteMenusString.add(carteMenus.get(0).getEntetOfCSV());
            for (CarteMenu carteMenu : carteMenus) {
                carteMenusString.add(carteMenu.getCartesMenusAsString());
            }
            CSVUtil.writeStringsToCSVFile(sourceFolder, carteMenusString, false);
        }
    }

    public void exportFamillesItems(File sourceFolder) throws BasicException, IOException {
        List<CarteItemInfo> carteItems = this.m_dlSales.getCarteItems();
        ArrayList<String> carteItemsString = new ArrayList<String>();
        if (carteItems.size() > 0) {
            carteItemsString.add(carteItems.get(0).getEntetOfCSV());
            for (CarteItemInfo carteItem : carteItems) {
                carteItemsString.add(carteItem.getCartesItemsAsString());
            }
            CSVUtil.writeStringsToCSVFile(sourceFolder, carteItemsString, false);
        }
    }

    public void exportPrinters(File sourceFolder) throws BasicException, IOException {
        List<PrinterInfo> printers = this.m_dlSales.getPrintersWithoutPrincipal();
        ArrayList<String> printersString = new ArrayList<String>();
        if (printers.size() > 0) {
            printersString.add(printers.get(0).getEntetOfCSV());
            for (PrinterInfo printer : printers) {
                printersString.add(printer.getPrinterAsString());
            }
            CSVUtil.writeStringsToCSVFile(sourceFolder, printersString, false);
        }
    }

    public void exportCategories(File sourceFolder) throws BasicException, IOException {
        List<CategoryInfo> categories = this.dlItems.getAllCategories();
        ArrayList<String> categoriesString = new ArrayList<String>();
        if (categories.size() > 0) {
            categoriesString.add(categories.get(0).getEntetOfCSV());
            for (CategoryInfo cat : categories) {
                categoriesString.add(cat.getCategorieAsString());
            }
            CSVUtil.writeStringsToCSVFile(sourceFolder, categoriesString, false);
        }
    }

    public void exportProducts(File sourceFolder) throws BasicException, IOException {
        List<ProductInfoExt> products = this.dlItems.getAllProductsWithoutConstraints();
        ArrayList<String> productsString = new ArrayList<String>();
        if (products.size() > 0) {
            productsString.add(products.get(0).getEntetOfCSV());
            for (ProductInfoExt product : products) {
                productsString.add(product.getProductAsString());
            }
            CSVUtil.writeStringsToCSVFile(sourceFolder, productsString, false);
        }
    }

    public void exportSupplements(File sourceFolder) throws BasicException, IOException {
        List<SupplementInfo> supplements = this.dlItems.getAllIngredientsAndSupplements();
        ArrayList<String> supplementsString = new ArrayList<String>();
        if (supplements.size() > 0) {
            supplementsString.add(supplements.get(0).getEntetOfCSV());
            for (SupplementInfo supplement : supplements) {
                supplementsString.add(supplement.getSupplementAsString());
            }
            CSVUtil.writeStringsToCSVFile(sourceFolder, supplementsString, false);
        }
    }

    public void exportFamilles(File sourceFolder) throws BasicException, IOException {
        List<CarteInfo> cartes = this.m_dlSales.getCartesWithoutConstraints();
        ArrayList<String> cartesString = new ArrayList<String>();
        if (cartes.size() > 0) {
            cartesString.add(cartes.get(0).getEntetOfCSV());
            for (CarteInfo carte : cartes) {
                cartesString.add(carte.getCarteAsString());
            }
            CSVUtil.writeStringsToCSVFile(sourceFolder, cartesString, false);
        }
    }

    public Properties loadParams(File f) {
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = new FileInputStream(f);
        }
        catch (Exception e) {
            is = null;
            LogToFile.log("severe", e.getMessage(), e);
        }
        try {
            if (is == null) {
                is = this.getClass().getResourceAsStream("server.properties");
            }
            props.load(is);
        }
        catch (Exception e) {
            LogToFile.log("severe", e.getMessage(), e);
        }
        return props;
    }

    public void importProcaisseProperties(File newPropertiesFile) {
        Properties newProperties = this.loadParams(newPropertiesFile);
        Properties oldProperties = this.loadParams(new File(this.PROCAISSE_CONFIG));
        newProperties.setProperty("db.driverlib", oldProperties.getProperty("db.driverlib"));
        newProperties.setProperty("db.driver", oldProperties.getProperty("db.driver"));
        newProperties.setProperty("db.URL", oldProperties.getProperty("db.URL"));
        newProperties.setProperty("machine.hostname", oldProperties.getProperty("machine.hostname"));
        newProperties.setProperty("db.engine", oldProperties.getProperty("db.engine"));
        newProperties.setProperty("machine.token", oldProperties.getProperty("machine.token"));
        newProperties.setProperty("stats.online", oldProperties.getProperty("stats.online"));
        this.saveParamChanges(newProperties);
    }

    public void saveParamChanges(Properties props) {
        try {
            File f = new File(this.PROCAISSE_CONFIG);
            try (FileOutputStream out = new FileOutputStream(f);){
                props.store(out, "Procaisse. Configuration file.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void uploadCarte() throws IOException {
        if (AppLocal.ONLINE_ORDER_HOST_NAME != null && !AppLocal.ONLINE_ORDER_HOST_NAME.isEmpty()) {
            List<CategoryInfo> categories = CarteSyncService.getCategories();
            List<ProductInfoExt> items = CarteSyncService.getItems();
            List<SupplementInfo> options = CarteSyncService.getSupplements();
            List<CarteInfo> cartes = CarteSyncService.getCartes();
            List<CarteMenu> cartesMenu = CarteSyncService.getCarteMenu();
            List<PrinterInfo> printers = CarteSyncService.getPrinters();
            List<GroupSubSupplementInfo> groupsSubSupplements = CarteSyncService.getGroupsSubOptions();
            List<PromotionInfo> promotions = CarteSyncService.getPromotionsProduct();
            LocalScreenService mLocalScreenService = LocalScreenService.getInstance();
            List<LocalScreen> screens = mLocalScreenService.getAllScreens();
            System.out.println("+++++++++ screens : " + screens);
            TagsService mTagsService = TagsService.getInstance();
            List<TagInfo> tags = mTagsService.getAllTags();
            List<ZoneInfo> zones = AppLocal.dlSales.getAllZones();
            LanguageService languageService = LanguageService.getInstance();
            List<LanguageInfo> languages = languageService.getAllLanguages();
            NutrientDataService mDataService = NutrientDataService.getInstance();
            List<NutrientData> ntriDatas = mDataService.findAll();
            JSONObject jsonCarte = ResponseObject.getJsonCarteANDParams(printers, categories, items, options, cartes, cartesMenu, groupsSubSupplements, promotions, screens, tags, zones, languages, true, ntriDatas);
            JSONObject jsonRoot = new JSONObject();
            long licenceId = AppLocal.getLicenceId();
            System.out.println("+++++++++= licenceId : " + licenceId);
            jsonRoot.put((Object)"procaisse_licence_id", (Object)licenceId);
            jsonRoot.put((Object)"orderJson", (Object)jsonCarte);
            OkHttpClient client = new OkHttpClient();
            String resourceUrl = AppLocal.ONLINE_ORDER_HOST_NAME + "/ordersJson";
            System.out.println("++++++++++ resourceUrl : " + resourceUrl);
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonRoot.toString());
            Request request = new Request.Builder().url(resourceUrl).post(requestBody).build();
            Response response = client.newCall(request).execute();
            String response_body = response.body().string();
            System.out.println("response_body : " + response_body);
            response.close();
        }
    }

    public boolean uploadPicture() throws IOException {
        if (AppLocal.ONLINE_ORDER_HOST_NAME != null && !AppLocal.ONLINE_ORDER_HOST_NAME.isEmpty()) {
            long licenceId = AppLocal.getLicenceId();
            System.out.println("+++++++++++ licenceId : " + licenceId);
            if (this.mItemService == null) {
                this.mItemService = ItemService.getInstance();
            }
            this.mItemService.deleteImages();
            File file = this.mFilerUtils.getFileImagesToUpload();
            String url = "http://45.76.44.106:3005/api/upload/" + licenceId;
            System.out.println("++++++++++++ url : " + url);
            OkHttpClient client = new OkHttpClient.Builder().writeTimeout(10L, TimeUnit.MINUTES).readTimeout(3L, TimeUnit.MINUTES).build();
            System.out.println("+++++++++ start : " + new Date());
            MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("uploads[]", "images", RequestBody.create((MediaType)MEDIA_TYPE_MARKDOWN, (File)file)).build();
            Request request = new Request.Builder().url(url).post((RequestBody)requestBody).build();
            Response response = client.newCall(request).execute();
            System.out.println("+++++++++++ response : " + response + " date : " + new Date());
            return response.code() == 200;
        }
        return false;
    }

    public boolean downloadCarte() {
        boolean result_download;
        block8: {
            result_download = false;
            try {
                System.out.println("+++++++++++++++++++++++ downloadCarte() ");
                org.json.JSONObject jsonItems = null;
                File carteFile = this.mFilerUtils.getFileFullPath("cartes/" + this.siret + ".json");
                if (!carteFile.exists()) break block8;
                System.out.println("file exist");
                FileInputStream fileInputStream = new FileInputStream(carteFile);
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
                JSONTokener tokener = new JSONTokener((Reader)inputStreamReader);
                jsonItems = new org.json.JSONObject(tokener);
                System.out.println("+++++++++++++++++++++++++jsonItems" + jsonItems.toString());
                if (jsonItems.toString().equals("{}")) break block8;
                System.out.println("not emptys");
                if (!jsonItems.has("orderJson")) break block8;
                System.out.println("orderJson exist");
                org.json.JSONObject orderJson = jsonItems.getJSONObject("orderJson");
                Object[] result = null;
                try {
                    result = CarteParser.parseItems(orderJson);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.error.json.items"), 4000, NPosition.CENTER);
                }
                if (result != null) {
                    CarteInfo_DB last_carte = this.mCarteInfoDao.getLastCarteInfo();
                    if (last_carte == null || !last_carte.getFirst_menu_downloaded().booleanValue()) {
                        System.out.println("vider la carte***************");
                        this.m_dlSales.resetCarte();
                    }
                    AppLocal.product_management = true;
                    this.synchroParams(orderJson);
                    AppLocal.dlSync.persistGlobal(result, true);
                    if (last_carte == null) {
                        last_carte = new CarteInfo_DB();
                        last_carte.setFirst_menu_downloaded(true);
                        last_carte.setLast_update(new Date());
                        this.mCarteInfoDao.addCarte(last_carte);
                    } else {
                        last_carte.setLast_update(new Date());
                        this.mCarteInfoDao.updateCarteInfo(last_carte);
                    }
                    result_download = true;
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return result_download;
    }

    public boolean downloadPicture() throws IOException {
        System.out.println("+++++++++++++++++++++++ downloadPicture() ");
        return this.mFirebaseService.bulkFilesDownload();
    }

    private void synchrLabelParamsSizes(AppConfig appConfig, String product_size_1, String product_size_2, String product_size_3, String product_size_4, String product_size_5, String product_size_6, String product_size_7, String product_size_8, String product_size_9, String product_size_10) {
        appConfig.setProperty("product.size.junior", product_size_1);
        appConfig.setProperty("product.size.senior", product_size_2);
        appConfig.setProperty("product.size.mega", product_size_3);
        appConfig.setProperty("product.size1", product_size_4);
        appConfig.setProperty("product.size2", product_size_5);
        appConfig.setProperty("product.size3", product_size_6);
        appConfig.setProperty("product.size4", product_size_7);
        appConfig.setProperty("product.size5", product_size_8);
        appConfig.setProperty("product.size6", product_size_9);
        appConfig.setProperty("product.size7", product_size_10);
    }

    public void synchroEnabledSizes(AppConfig appConfig, String product_size1_enabled, String product_size2_enabled, String product_size3_enabled, String product_size4_enabled, String product_size5_enabled, String product_size6_enabled, String product_size7_enabled, String product_size8_enabled, String product_size9_enabled, String product_size10_enabled) {
        appConfig.setProperty("product.junior.enabled", product_size1_enabled);
        appConfig.setProperty("product.senior.enabled", product_size2_enabled);
        appConfig.setProperty("product.mega.enabled", product_size3_enabled);
        appConfig.setProperty("product.size1.enabled", product_size4_enabled);
        appConfig.setProperty("product.size2.enabled", product_size5_enabled);
        appConfig.setProperty("product.size3.enabled", product_size6_enabled);
        appConfig.setProperty("product.size4.enabled", product_size7_enabled);
        appConfig.setProperty("product.size5.enabled", product_size8_enabled);
        appConfig.setProperty("product.size6.enabled", product_size9_enabled);
        appConfig.setProperty("product.size7.enabled", product_size10_enabled);
    }

    public void synchroDescreptionSizes(AppConfig appConfig, String product_size1_descreption, String product_size2_descreption, String product_size3_descreption, String product_size4_descreption, String product_size5_descreption, String product_size6_descreption, String product_size7_descreption, String product_size8_descreption, String product_size9_descreption, String product_size10_descreption) {
        appConfig.setProperty("product.size1.description", product_size1_descreption);
        appConfig.setProperty("product.size2.description", product_size2_descreption);
        appConfig.setProperty("product.size3.description", product_size3_descreption);
        appConfig.setProperty("product.size4.description", product_size4_descreption);
        appConfig.setProperty("product.size5.description", product_size5_descreption);
        appConfig.setProperty("product.size6.description", product_size6_descreption);
        appConfig.setProperty("product.size7.description", product_size7_descreption);
        appConfig.setProperty("product.size8.description", product_size8_descreption);
        appConfig.setProperty("product.size9.description", product_size9_descreption);
        appConfig.setProperty("product.size10.description", product_size10_descreption);
    }

    public void exportCarteJSON(File destinationFolder, boolean oldJSonVersion) throws BasicException, IOException, Exception {
        List<CategoryInfo> categories = CarteSyncService.getCategories();
        List<ProductInfoExt> items = CarteSyncService.getItems();
        List<SupplementInfo> options = CarteSyncService.getSupplements();
        List<CarteInfo> cartes = CarteSyncService.getCartes();
        List<CarteMenu> cartesMenu = CarteSyncService.getCarteMenu();
        List<PrinterInfo> printers = CarteSyncService.getPrinters();
        List<GroupSubSupplementInfo> groupsSubSupplements = CarteSyncService.getGroupsSubOptions();
        List<PromotionInfo> promotions = CarteSyncService.getPromotionsProduct();
        LocalScreenService mLocalScreenService = LocalScreenService.getInstance();
        List<LocalScreen> screens = mLocalScreenService.getAllScreens();
        TagsService mTagsService = TagsService.getInstance();
        List<TagInfo> tags = mTagsService.getAllTags();
        LanguageService languageService = LanguageService.getInstance();
        List<LanguageInfo> languages = languageService.getAllLanguages();
        List<ZoneInfo> zones = AppLocal.dlSales.getAllZones();
        NutrientDataService mDataService = NutrientDataService.getInstance();
        List<NutrientData> ntriDatas = mDataService.findAll();
        JSONObject jsonCarte = ResponseObject.getJsonCarteANDParams(printers, categories, items, options, cartes, cartesMenu, groupsSubSupplements, promotions, screens, tags, zones, languages, oldJSonVersion, ntriDatas);
        System.out.println("********jsonCarte :" + jsonCarte.toString());
        String path_file = destinationFolder.getAbsolutePath() + File.separator + "carte.json";
        FileWriter fileJson = new FileWriter(path_file, Charset.forName("UTF-8"));
        fileJson.write(jsonCarte.toJSONString());
        fileJson.close();
        Journal.writeToJET(new Event(110, "Exportation de donn\u00e9es", AppLocal.user != null ? AppLocal.user.getId() : "", "", new Date().getTime(), ""));
    }

    public void importCarteJson(File sourceFolder, boolean merge) throws IOException, BasicException, SQLException, ZipException, ParseException {
        int MAX = 100;
        JDialog frame = new JDialog();
        frame.setLocationRelativeTo(null);
        frame.setUndecorated(true);
        JProgressBar pb = new JProgressBar();
        pb.setMinimum(0);
        pb.setMaximum(100);
        pb.setStringPainted(true);
        pb.setBackground(Color.GREEN);
        frame.setLayout(new FlowLayout());
        frame.setAlwaysOnTop(true);
        frame.getContentPane().add(pb);
        pb.setSize(400, 300);
        frame.pack();
        frame.setVisible(true);
        boolean currentValue = false;
        pb.setValue(0);
        JSONParser jsonParser = new JSONParser();
        System.out.println("sourceFolder.getAbsolutePath() : " + sourceFolder.getAbsolutePath());
        String obj = jsonParser.parse((Reader)new FileReader(sourceFolder.getAbsolutePath(), Charset.forName("UTF-8"))).toString();
        org.json.JSONObject jsonImported = new org.json.JSONObject(obj);
        pb.setValue(20);
        pb.setString("lire le fichier");
        org.json.JSONObject jsonItems = null;
        jsonItems = !jsonImported.isNull("orderJson") ? jsonImported.getJSONObject("orderJson") : jsonImported;
        Object[] result = CarteParser.parseItems(jsonItems);
        pb.setValue(40);
        pb.setString("analyser les donn\u00e9es");
        this.synchroSizes(jsonItems);
        pb.setValue(50);
        pb.setString("inserer les donn\u00e9es");
        AppLocal.product_management = true;
        AppLocal.dlSync.persistGlobal(result, true, merge);
        pb.setValue(100);
        frame.dispose();
        Journal.writeToJET(new Event(140, "Importation de donn\u00e9es", AppLocal.user != null ? AppLocal.user.getId() : "", "", new Date().getTime(), ""));
    }

    public void synchroParams(org.json.JSONObject jsonItems) {
        List<LanguageInfo> languages;
        AppLocal.RELOAD_PROPERTIES_AFTER_SYNCH = false;
        AppLocal.SYNCHRO_NAME_SIZE = true;
        FilerUtils mFilerUtils = FilerUtils.getInstance();
        AppConfig appConfig = AppConfig.getInstance(true, mFilerUtils.getFileProperties());
        if (!jsonItems.isNull("sizes")) {
            JSONArray arraySizes = jsonItems.getJSONArray("sizes");
            block24: for (int i = 0; i < arraySizes.length(); ++i) {
                org.json.JSONObject objectSize = arraySizes.getJSONObject(i);
                if (objectSize.isNull("name_size")) continue;
                String name_size = objectSize.getString("name_size");
                String label_size = objectSize.isNull("label_size") ? "" : objectSize.getString("label_size");
                String description_size = objectSize.isNull("description") ? "" : objectSize.getString("description");
                boolean enabled = objectSize.isNull("size_displayed") ? false : objectSize.getBoolean("size_displayed");
                String value_enabled = enabled ? "yes" : "no";
                switch (name_size) {
                    case "junior": {
                        appConfig.setProperty("product.size.junior", label_size);
                        appConfig.setProperty("product.junior.enabled", value_enabled);
                        appConfig.setProperty("product.size1.description", description_size);
                        continue block24;
                    }
                    case "senior": {
                        appConfig.setProperty("product.size.senior", label_size);
                        appConfig.setProperty("product.senior.enabled", value_enabled);
                        appConfig.setProperty("product.size2.description", description_size);
                        continue block24;
                    }
                    case "mega": {
                        appConfig.setProperty("product.size.mega", label_size);
                        appConfig.setProperty("product.mega.enabled", value_enabled);
                        appConfig.setProperty("product.size3.description", description_size);
                        continue block24;
                    }
                    case "size1": {
                        appConfig.setProperty("product.size1", label_size);
                        appConfig.setProperty("product.size1.enabled", value_enabled);
                        appConfig.setProperty("product.size4.description", description_size);
                        continue block24;
                    }
                    case "size2": {
                        appConfig.setProperty("product.size2", label_size);
                        appConfig.setProperty("product.size2.enabled", value_enabled);
                        appConfig.setProperty("product.size5.description", description_size);
                        continue block24;
                    }
                    case "size3": {
                        appConfig.setProperty("product.size3", label_size);
                        appConfig.setProperty("product.size3.enabled", value_enabled);
                        appConfig.setProperty("product.size6.description", description_size);
                        continue block24;
                    }
                    case "size4": {
                        appConfig.setProperty("product.size4", label_size);
                        appConfig.setProperty("product.size4.enabled", value_enabled);
                        appConfig.setProperty("product.size7.description", description_size);
                        continue block24;
                    }
                    case "size5": {
                        appConfig.setProperty("product.size5", label_size);
                        appConfig.setProperty("product.size5.enabled", value_enabled);
                        appConfig.setProperty("product.size8.description", description_size);
                        continue block24;
                    }
                    case "size6": {
                        appConfig.setProperty("product.size6", label_size);
                        appConfig.setProperty("product.size6.enabled", value_enabled);
                        appConfig.setProperty("product.size9.description", description_size);
                        continue block24;
                    }
                    case "size7": {
                        appConfig.setProperty("product.size7", label_size);
                        appConfig.setProperty("product.size7.enabled", value_enabled);
                        appConfig.setProperty("product.size10.description", description_size);
                    }
                }
            }
        }
        if ((languages = CarteParser.parseLanguages(jsonItems)) != null) {
            if (this.languageService == null) {
                this.languageService = LanguageService.getInstance();
            }
            this.languageService.setLanguages(languages);
            this.setLanguageDefault(appConfig);
        }
        if (!jsonItems.isNull("tarif")) {
            String tariff_value = jsonItems.getString("tarif");
            SettingInfo settingInfo = new SettingInfo();
            settingInfo.setSetting_name("type_tarif");
            settingInfo.setSetting_value(tariff_value);
            settingInfo.setLast_update(new Date().getTime());
            SettingInfo localSetting = this.findSettingByName(settingInfo.getSetting_name());
            if (localSetting == null) {
                this.saveSetting(settingInfo);
            } else {
                settingInfo.setId(localSetting.getId());
                this.mSettingInfoDao.setLastUpdate(settingInfo);
            }
            appConfig.setProperty("tariff", tariff_value);
        }
        appConfig.save();
        appConfig.initInfoProductSize();
        appConfig.initTariff();
    }

    public SettingInfo saveSetting(SettingInfo mSettingInfo) {
        if (this.mSettingInfoDao.getSessionFactory() != null) {
            Session session = this.mSettingInfoDao.getSessionFactory().getCurrentSession();
            Transaction tx = session.beginTransaction();
            session.save((Object)mSettingInfo);
            tx.commit();
        }
        return mSettingInfo;
    }

    public SettingInfo findSettingByName(String media_name) {
        return this.mSettingInfoDao.findByName(media_name);
    }

    public void synchroSizes(org.json.JSONObject jsonItems) {
        List<LanguageInfo> languages;
        AppLocal.RELOAD_PROPERTIES_AFTER_SYNCH = false;
        AppLocal.SYNCHRO_NAME_SIZE = true;
        FilerUtils mFilerUtils = FilerUtils.getInstance();
        AppConfig appConfig = AppConfig.getInstance(true, mFilerUtils.getFileProperties());
        if (!(jsonItems.isNull("product_size_1") || jsonItems.isNull("product_size_2") || jsonItems.isNull("product_size_3") || jsonItems.isNull("product_size_4") || jsonItems.isNull("product_size_5") || jsonItems.isNull("product_size_6") || jsonItems.isNull("product_size_7") || jsonItems.isNull("product_size_8") || jsonItems.isNull("product_size_9") || jsonItems.isNull("product_size_10"))) {
            this.synchrLabelParamsSizes(appConfig, jsonItems.getString("product_size_1"), jsonItems.getString("product_size_2"), jsonItems.getString("product_size_3"), jsonItems.getString("product_size_4"), jsonItems.getString("product_size_5"), jsonItems.getString("product_size_6"), jsonItems.getString("product_size_7"), jsonItems.getString("product_size_8"), jsonItems.getString("product_size_9"), jsonItems.getString("product_size_10"));
        }
        if (!(jsonItems.isNull("product_size_1_enabled") || jsonItems.isNull("product_size_2_enabled") || jsonItems.isNull("product_size_3_enabled") || jsonItems.isNull("product_size_4_enabled") || jsonItems.isNull("product_size_5_enabled") || jsonItems.isNull("product_size_6_enabled") || jsonItems.isNull("product_size_7_enabled") || jsonItems.isNull("product_size_8_enabled") || jsonItems.isNull("product_size_9_enabled") || jsonItems.isNull("product_size_10_enabled"))) {
            this.synchroEnabledSizes(appConfig, jsonItems.getString("product_size_1_enabled"), jsonItems.getString("product_size_2_enabled"), jsonItems.getString("product_size_3_enabled"), jsonItems.getString("product_size_4_enabled"), jsonItems.getString("product_size_5_enabled"), jsonItems.getString("product_size_6_enabled"), jsonItems.getString("product_size_7_enabled"), jsonItems.getString("product_size_8_enabled"), jsonItems.getString("product_size_9_enabled"), jsonItems.getString("product_size_10_enabled"));
        }
        if (!(jsonItems.isNull("product_size_1_descreption") || jsonItems.isNull("product_size_2_descreption") || jsonItems.isNull("product_size_3_descreption") || jsonItems.isNull("product_size_4_descreption") || jsonItems.isNull("product_size_5_descreption") || jsonItems.isNull("product_size_6_descreption") || jsonItems.isNull("product_size_7_descreption") || jsonItems.isNull("product_size_8_descreption") || jsonItems.isNull("product_size_9_descreption") || jsonItems.isNull("product_size_10_descreption"))) {
            this.synchroDescreptionSizes(appConfig, jsonItems.getString("product_size_1_descreption"), jsonItems.getString("product_size_2_descreption"), jsonItems.getString("product_size_3_descreption"), jsonItems.getString("product_size_4_descreption"), jsonItems.getString("product_size_5_descreption"), jsonItems.getString("product_size_6_descreption"), jsonItems.getString("product_size_7_descreption"), jsonItems.getString("product_size_8_descreption"), jsonItems.getString("product_size_9_descreption"), jsonItems.getString("product_size_10_descreption"));
        }
        if ((languages = CarteParser.parseLanguages(jsonItems)) != null) {
            if (this.languageService == null) {
                this.languageService = LanguageService.getInstance();
            }
            this.languageService.setLanguages(languages);
            this.setLanguageDefault(appConfig);
        }
        appConfig.save();
        appConfig.initInfoProductSize();
    }

    private void setLanguageDefault(AppConfig appConfig) {
        LanguageInfo defaultLanguage;
        String newCodeLanguage;
        if (this.languageService == null) {
            this.languageService = LanguageService.getInstance();
        }
        String string = newCodeLanguage = (defaultLanguage = this.languageService.getDefaultLanguage()) != null ? defaultLanguage.getCode_language() : null;
        if (newCodeLanguage != null && !newCodeLanguage.isEmpty() && !newCodeLanguage.equals(AppLocal.APP_LANGUAGE_DEFAULT)) {
            AppLocal.APP_LANGUAGE_DEFAULT = newCodeLanguage;
            AppLocal.APP_LANGUAGE = newCodeLanguage;
            appConfig.setProperty("app.language", newCodeLanguage);
            AppLocal.loadLanguages();
        }
    }

    public void exportImageForUpload(final File destinationFolder) throws BasicException, IOException, Exception {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String directory = System.getProperty("java.io.tmpdir");
                try {
                    CarteService.this.exportProductsSupplementRelations(new File(directory + CarteService.this.productsSupplementRelationsFileName));
                    FilerUtils filerUtils = FilerUtils.getInstance();
                    File imagesDirectory = filerUtils.getFileFullPath("images");
                    if (imagesDirectory.exists()) {
                        FileUtils.copyDirectoryToDirectory((File)imagesDirectory, (File)destinationFolder);
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", null, ex);
                }
            }
        });
    }
}

