/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.service;

import com.fazecast.jSerialComm.SerialPort;
import com.openbravo.pos.util.LogToFile;
import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;

public class BipperService {
    private final String port;
    private OutputStream outputStream;

    public BipperService(String port) {
        this.port = port;
    }

    public void initAndSetNumeroBipper(int biper) {
        SerialPort comPort = SerialPort.getCommPort((String)this.port);
        comPort.setComPortParameters(9600, 8, 1, 0);
        comPort.openPort(2000);
        this.outputStream = comPort.getOutputStream();
        if (this.outputStream != null) {
            try {
                String s = "S" + StringUtils.leftPad((String)("" + biper), (int)4, (String)"0");
                byte[] msgBytes = new byte[s.length() + 1];
                System.arraycopy(s.getBytes(), 0, msgBytes, 0, s.length());
                msgBytes[s.length()] = 3;
                this.outputStream.write(msgBytes);
                this.outputStream.close();
                comPort.closePort();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public void initAndCallBipper(int biper) {
        SerialPort comPort = SerialPort.getCommPort((String)this.port);
        comPort.setComPortParameters(9600, 8, 1, 0);
        comPort.openPort(2000);
        this.outputStream = comPort.getOutputStream();
        if (this.outputStream != null) {
            try {
                String s2 = StringUtils.leftPad((String)("" + biper), (int)4, (String)"0");
                byte[] msgBytes2 = new byte[s2.length() + 2];
                msgBytes2[0] = 1;
                System.arraycopy(s2.getBytes(), 1, msgBytes2, 1, s2.length() - 1);
                msgBytes2[s2.length() + 1] = 3;
                this.outputStream.write(msgBytes2);
                this.outputStream.close();
                comPort.closePort();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }
}

