/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.service;

import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.SystemUtils;
import java.awt.Color;
import java.awt.FlowLayout;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JDialog;
import javax.swing.JProgressBar;
import org.apache.commons.io.FileUtils;

public class BackupService {
    private static Calendar cal;
    private final List<String> fileList;
    private SimpleDateFormat formatter = DateUtils.formatterYEAR_MONTH_DAY_TIRETS6;
    private Date today = new Date();
    private static String OUTPUT_ZIP_FILE;
    private static final String SOURCE_FOLDER;

    private static Path getOrderFileIn(Path dir) throws IOException {
        File testDirectory = new File(dir.toString());
        File[] files = testDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String name = pathname.getName().toLowerCase();
                return pathname.isFile();
            }
        });
        long lastMod = Long.MIN_VALUE;
        File lastFilePath = null;
        for (File file : files) {
            if (file.lastModified() <= lastMod) continue;
            lastFilePath = file;
            lastMod = file.lastModified();
        }
        if (lastFilePath != null) {
            return lastFilePath.toPath();
        }
        return null;
    }

    public BackupService() throws IOException {
        cal = Calendar.getInstance();
        this.fileList = new ArrayList<String>();
    }

    public void doBackup(File destination) throws IOException {
        BackupService appBackup = new BackupService();
        this.buildOutPutZipFile(destination.toString());
        appBackup.generateFileList(new File(SOURCE_FOLDER));
        if (!destination.exists()) {
            FileUtils.forceMkdir((File)destination);
        }
        appBackup.zipIt(OUTPUT_ZIP_FILE);
    }

    public static int fileCount(Path dir) throws IOException {
        try (Stream<Path> files = Files.list(dir);){
            int n = (int)files.count();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zipIt(String zipFile) {
        JDialog frame = new JDialog();
        frame.setLocationRelativeTo(null);
        frame.setUndecorated(true);
        JProgressBar pb = new JProgressBar();
        pb.setMinimum(0);
        pb.setMaximum(10000);
        pb.setStringPainted(true);
        pb.setBackground(Color.GREEN);
        frame.setLayout(new FlowLayout());
        frame.setAlwaysOnTop(true);
        frame.getContentPane().add(pb);
        frame.setSize(600, 300);
        pb.setSize(600, 300);
        frame.pack();
        frame.setVisible(true);
        int currentValue = 100;
        pb.setValue(currentValue);
        byte[] buffer = new byte[1024];
        String source = new File(SOURCE_FOLDER).getName();
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            fos = new FileOutputStream(zipFile);
            zos = new ZipOutputStream(fos);
            FileInputStream in = null;
            int pas = 9000 / this.fileList.size();
            for (String file : this.fileList) {
                pb.setValue(currentValue += pas);
                pb.setString("File Added : " + file);
                ZipEntry ze = new ZipEntry(source + File.separator + file);
                zos.putNextEntry(ze);
                try {
                    int len;
                    in = new FileInputStream(SOURCE_FOLDER + File.separator + file);
                    while ((len = in.read(buffer)) > 0) {
                        zos.write(buffer, 0, len);
                    }
                }
                finally {
                    in.close();
                }
            }
            pb.setValue(1000);
            frame.dispose();
            zos.closeEntry();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                zos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void generateFileList(File node) {
        if (node.isFile()) {
            this.fileList.add(this.generateZipEntry(node.toString()));
        }
        if (node.isDirectory()) {
            String[] subNote;
            for (String filename : subNote = node.list()) {
                this.generateFileList(new File(node, filename));
            }
        }
    }

    private String generateZipEntry(String file) {
        return file.substring(SOURCE_FOLDER.length() + 1, file.length());
    }

    private void buildOutPutZipFile(String destination) {
        StringBuilder sb = new StringBuilder(destination);
        sb.append(File.separator);
        sb.append("procaisse-db-");
        sb.append(this.getDayOfWeek());
        sb.append("-");
        sb.append(this.formatter.format(this.today));
        sb.append(".zip");
        OUTPUT_ZIP_FILE = sb.toString();
    }

    private String getDayOfWeek() {
        int day = cal.get(7);
        switch (day) {
            case 1: {
                return "dimanche";
            }
            case 2: {
                return "lundi";
            }
            case 3: {
                return "mardi";
            }
            case 4: {
                return "mercredi";
            }
            case 5: {
                return "jeudi";
            }
            case 6: {
                return "vendredi";
            }
            case 7: {
                return "samedi";
            }
        }
        return "dimanche";
    }

    static {
        SOURCE_FOLDER = SystemUtils.SYS_USER_HOME + File.separator + "procaisse-database";
    }
}

