/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.service;

import com.openbravo.basic.BasicException;
import com.openbravo.beans.TicketAvoir;
import com.openbravo.dao.DataLogicOrder;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;

public class AvoirService {
    private DataLogicOrder dlOrder;
    private final int MAXNUMBER = 999;

    public AvoirService(DataLogicOrder dlOrder) {
        this.dlOrder = dlOrder;
    }

    public TicketAvoir addTicketAvoir(double amount, Date experationDate, String origin, String idTicket) {
        try {
            TicketAvoir avoir = new TicketAvoir(false, amount, this.buildBarCode(amount, experationDate), experationDate, origin);
            avoir.setTicket(idTicket);
            avoir = this.dlOrder.AddAvoir(avoir);
            return avoir;
        }
        catch (BasicException | SQLException ex) {
            LogToFile.log("severe", null, ex);
            return null;
        }
    }

    public String buildBarCode(double amount, Date experationDate) throws SQLException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(experationDate);
        String jour = NumericUtils.formatToStringInteger3Digits(cal.get(6));
        String year = DateUtils.formatYear2(experationDate);
        String amounts = NumericUtils.formatToStringInteger6Digits((int)(Math.abs(amount) * 100.0));
        String id = NumericUtils.formatToStringInteger3Digits(this.getDayIdAvoir());
        return jour + amounts + id + year;
    }

    public int getDayIdAvoir() throws SQLException {
        int idAvoir = 0;
        idAvoir = 999 - (this.dlOrder.getLastAvoirId() + 1) % 999;
        return idAvoir;
    }

    public TicketAvoir buildAndAddTicketAvoir(String codeBar, String origin) throws BasicException, SQLException {
        int jour = Integer.valueOf(codeBar.substring(0, 3));
        int year = 2000 + Integer.valueOf(codeBar.substring(12));
        double Amount2 = Double.valueOf(codeBar.substring(3, 9)) / 100.0;
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(6, jour);
        Date experationDate = new Date(cal.getTime().getYear(), cal.getTime().getMonth(), cal.getTime().getDate());
        return this.dlOrder.AddAvoir(new TicketAvoir(false, Amount2, codeBar, experationDate, origin));
    }

    public Date getDateExpire() {
        Date experationDate = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(experationDate);
        cal.add(this.convertDelaiUnitToInt(this.getDelaiUnit()), this.getDelai());
        return cal.getTime();
    }

    private int convertDelaiUnitToInt(String unit) {
        switch (unit.toLowerCase()) {
            case "mois": {
                return 2;
            }
            case "ann\u00e9es": {
                return 1;
            }
            case "jours": {
                return 5;
            }
        }
        return 2;
    }

    private String getDelaiUnit() {
        return AppLocal.PRINT_AVOIR_UNIT;
    }

    private int getDelai() {
        return AppLocal.PRINT_AVOIR_DELAY;
    }
}

