/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.service;

import com.openbravo.basic.BasicException;
import com.openbravo.basic.BasicStorage;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.payment.PaymentInfo;
import com.openbravo.pos.ticket.CaisseZ;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.ticket.TotaleEncaissement;
import com.openbravo.pos.util.CSVUtil;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.Event;
import com.openbravo.pos.util.Journal;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.SignatureGenerator;
import com.openbravo.pos.util.ZipUtils;
import com.openbravo.service.ClotureService;
import fr.protactile.norm.beans.ArchivPeriode;
import fr.protactile.norm.beans.Duplicata;
import fr.protactile.norm.beans.DuplicataJustificatifPayment;
import fr.protactile.norm.beans.EnteteInfo;
import fr.protactile.norm.beans.Facture;
import fr.protactile.norm.beans.GrandTotalPeriode;
import fr.protactile.norm.beans.GrandTotalTicket;
import fr.protactile.norm.beans.JustificatifPayment;
import fr.protactile.norm.beans.Line;
import fr.protactile.norm.beans.LineFacture;
import fr.protactile.norm.beans.LineNote;
import fr.protactile.norm.beans.RecapGeneralFacture;
import fr.protactile.norm.beans.RecapGeneralNote;
import fr.protactile.norm.beans.RecapTaxFacture;
import fr.protactile.norm.beans.RecapTaxNote;
import fr.protactile.norm.beans.TicketPayementNorm;
import fr.protactile.norm.beans.TotalTax;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.CompressionLevel;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import org.apache.commons.io.FileUtils;

public class ArchivageService {
    private String archivDirectoryString = AppLocal.EMPLACEMENT_ARCHIVE + File.separator + "archive";
    private DataLogicSales dlSales;
    private DataLogicItems dlItems;
    private File directoryArchive;
    private Calendar calendar = Calendar.getInstance();
    private LinkedHashMap<String, File> files = new LinkedHashMap();
    File fileJournal = new File(AppLocal.JOURNAL_FILE);
    int PERIODE_INCREMENT;
    SimpleDateFormat dateSignatureFormat = DateUtils.SDF_DATE_SIGNATURE;
    SimpleDateFormat idJoursPeriode = DateUtils.SDF_YYYYMMDD;
    SimpleDateFormat idMoisPeriode = DateUtils.SDF_ID_MONTH_PERIOD;
    SimpleDateFormat idAnnePeriode = DateUtils.SDF_ID_YEAR_PERIOD;
    SimpleDateFormat dateFormatterId;
    private String idUser;
    private ClotureService clotureService;
    private String ARCHIVE_TMP = AppLocal.EMPLACEMENT_ARCHIVE + File.separator + "archive_tmp" + File.separator + "archive";
    private boolean error_integrity;

    public ArchivageService(DataLogicSales dataLogicSales, DataLogicItems dlItems, String idUser) throws IOException {
        this.idUser = idUser;
        this.dlSales = dataLogicSales;
        this.dlItems = dlItems;
        this.directoryArchive = new File(this.archivDirectoryString);
        if (!this.directoryArchive.exists()) {
            FileUtils.forceMkdir((File)this.directoryArchive);
        }
        this.clotureService = ClotureService.getInstance(this.dlSales, (JRootApp)BasicStorage.getObject("APP_ROOT_INSTANCE"));
    }

    public void archiver(String typePeriode, Date dateFinArchivage) throws BasicException, IOException, ParseException, Exception {
        this.error_integrity = false;
        switch (typePeriode) {
            case "a": {
                this.PERIODE_INCREMENT = 1;
                this.dateFormatterId = this.idAnnePeriode;
                break;
            }
            case "j": {
                this.PERIODE_INCREMENT = 5;
                this.dateFormatterId = this.idJoursPeriode;
                break;
            }
            case "m": {
                this.PERIODE_INCREMENT = 2;
                this.dateFormatterId = this.idMoisPeriode;
                break;
            }
            default: {
                this.PERIODE_INCREMENT = 5;
                this.dateFormatterId = this.idJoursPeriode;
            }
        }
        GrandTotalTicket firstGrandTotalTicket = this.dlSales.getFirstTotalTicket();
        ArchivPeriode lastArchiv = this.dlSales.getLastArchivPeriode(typePeriode);
        if (firstGrandTotalTicket != null || lastArchiv != null) {
            Date dateStartArchivage = null;
            if (firstGrandTotalTicket != null) {
                dateStartArchivage = firstGrandTotalTicket.getTimestampGDH();
            }
            if (lastArchiv != null) {
                String chemin;
                GrandTotalPeriode grandTotalPeriodeCorrespondant;
                System.out.println("lastArchiv : " + lastArchiv.toString());
                dateStartArchivage = DateUtils.getDateFromString(lastArchiv.getId());
                this.calendar.setTime(dateStartArchivage);
                this.calendar.add(this.PERIODE_INCREMENT, 1);
                dateStartArchivage = this.calendar.getTime();
                System.out.println("dateStartArchivage============== : " + dateStartArchivage);
                System.out.println("dateFinArchivage============ : " + dateFinArchivage);
                while (dateStartArchivage.before(dateFinArchivage) && !lastArchiv.getId().equals(this.dateFormatterId.format(dateFinArchivage))) {
                    grandTotalPeriodeCorrespondant = this.archivPeriod(typePeriode, dateStartArchivage);
                    if (grandTotalPeriodeCorrespondant != null) {
                        String signature = this.signerZipFile(grandTotalPeriodeCorrespondant.getId(), lastArchiv);
                        chemin = this.archivDirectoryString + File.separator + grandTotalPeriodeCorrespondant.getId() + ".zip";
                        if (new Integer(lastArchiv.getId()) < new Integer(this.dateFormatterId.format(dateStartArchivage)) && !DateUtils.isToday(dateStartArchivage)) {
                            this.dlSales.insertArchivagePeriode(grandTotalPeriodeCorrespondant, signature, chemin, this.idUser);
                        }
                    }
                    Date dateStart = new Date(dateStartArchivage.getTime());
                    this.calendar.add(this.PERIODE_INCREMENT, 1);
                    dateStartArchivage = this.calendar.getTime();
                    Date dateEnd = new Date(dateStartArchivage.getTime());
                    lastArchiv = this.dlSales.getLastArchivPeriode(typePeriode);
                    this.sendEmail(dateStart, dateEnd);
                }
                if (lastArchiv != null && new Integer(lastArchiv.getId()) < new Integer(this.dateFormatterId.format(dateFinArchivage)) && !DateUtils.isToday(dateStartArchivage) && (grandTotalPeriodeCorrespondant = this.archivPeriod(typePeriode, dateStartArchivage)) != null) {
                    this.dlSales.deleteLigneById("ARCHIV_PERIODE", this.dateFormatterId.format(dateFinArchivage));
                    ArchivPeriode archivPeriodeAncienne = this.dlSales.getLastArchivPeriode(typePeriode);
                    chemin = this.archivDirectoryString + File.separator + grandTotalPeriodeCorrespondant.getId() + ".zip";
                    String signature = this.signerZipFile(grandTotalPeriodeCorrespondant.getId(), lastArchiv);
                    if (archivPeriodeAncienne != null) {
                        this.dlSales.insertArchivagePeriode(grandTotalPeriodeCorrespondant, signature, chemin, this.idUser);
                    } else {
                        this.dlSales.insertArchivagePeriode(grandTotalPeriodeCorrespondant, signature, chemin, this.idUser);
                    }
                    Date dateStart = new Date(dateStartArchivage.getTime());
                    Calendar ca = Calendar.getInstance();
                    ca.setTime(dateStart);
                    ca.add(this.PERIODE_INCREMENT, 1);
                    Date dateEnd = ca.getTime();
                    this.sendEmail(dateStart, dateEnd);
                }
            } else {
                String signature;
                GrandTotalPeriode grandTotalPeriodeCorrespondant;
                System.out.println("dateStartArchivage============== : " + dateStartArchivage);
                System.out.println("dateFinArchivage============ : " + dateFinArchivage);
                Object chemin = "";
                if (new Integer(this.dateFormatterId.format(dateStartArchivage)) <= new Integer(this.dateFormatterId.format(dateFinArchivage)) && !DateUtils.isToday(dateStartArchivage)) {
                    grandTotalPeriodeCorrespondant = this.archivPeriod(typePeriode, dateStartArchivage);
                    chemin = this.archivDirectoryString + File.separator + grandTotalPeriodeCorrespondant.getId() + ".zip";
                    signature = this.signerZipFile(grandTotalPeriodeCorrespondant.getId(), null);
                    this.dlSales.insertArchivagePeriode(grandTotalPeriodeCorrespondant, signature, (String)chemin, this.idUser);
                    this.calendar.setTime(dateStartArchivage);
                    Date dateStart = new Date(dateStartArchivage.getTime());
                    this.calendar.add(this.PERIODE_INCREMENT, 1);
                    dateStartArchivage = this.calendar.getTime();
                    Date dateEnd = new Date(dateStartArchivage.getTime());
                    lastArchiv = this.dlSales.getLastArchivPeriode(typePeriode);
                    this.sendEmail(dateStart, dateEnd);
                }
                while (dateStartArchivage.before(dateFinArchivage) && !DateUtils.isToday(dateStartArchivage)) {
                    if (new Integer(lastArchiv.getId()) < new Integer(this.dateFormatterId.format(dateFinArchivage))) {
                        grandTotalPeriodeCorrespondant = this.archivPeriod(typePeriode, dateStartArchivage);
                        chemin = this.archivDirectoryString + File.separator + grandTotalPeriodeCorrespondant.getId() + ".zip";
                        signature = this.signerZipFile(grandTotalPeriodeCorrespondant.getId(), lastArchiv);
                        this.dlSales.insertArchivagePeriode(grandTotalPeriodeCorrespondant, signature, (String)chemin, this.idUser);
                    }
                    Date dateStart = new Date(dateStartArchivage.getTime());
                    this.calendar.add(this.PERIODE_INCREMENT, 1);
                    dateStartArchivage = this.calendar.getTime();
                    Date dateEnd = new Date(dateStartArchivage.getTime());
                    lastArchiv = this.dlSales.getLastArchivPeriode(typePeriode);
                    this.sendEmail(dateStart, dateEnd);
                }
                if (lastArchiv != null && new Integer(lastArchiv.getId()) < new Integer(this.dateFormatterId.format(dateFinArchivage)) && !DateUtils.isToday(dateStartArchivage)) {
                    Date dateStart;
                    String signature2;
                    grandTotalPeriodeCorrespondant = this.archivPeriod(typePeriode, dateFinArchivage);
                    this.dlSales.deleteLigneById("ARCHIV_PERIODE", grandTotalPeriodeCorrespondant.getId());
                    ArchivPeriode archivPeriodeAncienne = this.dlSales.getLastArchivPeriode(typePeriode);
                    if (archivPeriodeAncienne != null) {
                        signature2 = this.signerZipFile(grandTotalPeriodeCorrespondant.getId(), archivPeriodeAncienne);
                        this.dlSales.insertArchivagePeriode(grandTotalPeriodeCorrespondant, signature2, (String)chemin, this.idUser);
                        dateStart = new Date(dateStartArchivage.getTime());
                        Calendar ca = Calendar.getInstance();
                        ca.setTime(dateStart);
                        ca.add(this.PERIODE_INCREMENT, 1);
                        Date dateEnd = ca.getTime();
                        this.sendEmail(dateStart, dateEnd);
                    } else {
                        signature2 = this.signerZipFile(grandTotalPeriodeCorrespondant.getId(), null);
                        this.dlSales.insertArchivagePeriode(grandTotalPeriodeCorrespondant, signature2, (String)chemin, this.idUser);
                        dateStart = new Date(dateStartArchivage.getTime());
                        Calendar ca = Calendar.getInstance();
                        ca.setTime(dateStart);
                        ca.add(this.PERIODE_INCREMENT, 1);
                        Date dateEnd = ca.getTime();
                        this.sendEmail(dateStart, dateEnd);
                    }
                }
            }
            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Archivage a \u00e9t\u00e9 effectu\u00e9 avec succ\u00e8s.", 1500, NPosition.TOP_CENTER);
            if (this.error_integrity) {
                new NotifyWindow(NotifyType.WARNING_NOTIFICATION, "des erreurs d'integrit\u00e9 sont d\u00e9tect\u00e9 au moment d'archigave.", 1500, NPosition.TOP_CENTER);
            }
        }
    }

    public GrandTotalPeriode archivPeriod(String typePeriode, Date periodeDate) throws BasicException, IOException, ParseException, Exception {
        ArrayList<String> errors = new ArrayList<String>();
        GrandTotalPeriode grandTotalPeriode = this.dlSales.getGrandTotalPeriodeById(switch (typePeriode) {
            case "a" -> this.idAnnePeriode.format(periodeDate);
            case "j" -> this.idJoursPeriode.format(periodeDate);
            case "m" -> this.idMoisPeriode.format(periodeDate);
            default -> this.idJoursPeriode.format(periodeDate);
        });
        System.out.println("+++++++ periodeDate : " + periodeDate);
        List<Facture> factures = this.dlSales.getFacturesByPeriode(typePeriode, periodeDate);
        errors.addAll(this.cheackFactures(factures));
        List<Duplicata> duplicatas = this.dlSales.getDuplicataByPeriode(typePeriode, periodeDate, true);
        errors.addAll(this.cheackDuplicatas(duplicatas));
        List<Duplicata> duplicatasTicket = this.dlSales.getDuplicataByPeriodeAndTypeDoc(typePeriode, periodeDate, "Ticket");
        errors.addAll(this.cheackDuplicatas(duplicatasTicket));
        List<Duplicata> duplicatasFacture = this.dlSales.getDuplicataByPeriodeAndTypeDoc(typePeriode, periodeDate, "Facture");
        errors.addAll(this.cheackDuplicatas(duplicatasFacture));
        List<Duplicata> allduplicatas = this.dlSales.getDuplicataByPeriode(typePeriode, periodeDate, false);
        List<GrandTotalTicket> grandTotalTickets = this.dlSales.getGrandTotalTicketByPeriode(typePeriode, periodeDate);
        List<TicketInfo> tickets = this.dlSales.getTicketsByPeriode(typePeriode, periodeDate);
        List<EnteteInfo> entetes = this.dlSales.getEnteteBetween(typePeriode, periodeDate);
        errors.addAll(this.cheackEnteteBetween(entetes));
        List<EnteteInfo> entetesNote = this.dlSales.getEnteteNoteBetween(typePeriode, periodeDate);
        errors.addAll(this.cheackEnteteNoteBetween(entetesNote));
        List<GrandTotalPeriode> gtps = this.dlItems.getGTPByPeriodeArchive(typePeriode, periodeDate);
        errors.addAll(this.checkGTP(gtps));
        List<TotaleEncaissement> totaleEncaissements = this.dlSales.getTotalEncaissementByPeriode(typePeriode, periodeDate);
        List<Line> linesEncaissements = this.dlItems.getLinesByPeriode(typePeriode, periodeDate);
        List<TotalTax> totalTaxes = this.dlItems.getTotalTaxByPeriode(typePeriode, periodeDate);
        List<TicketPayementNorm> payements = this.dlItems.getTicketPayementsNormByPeriode(typePeriode, periodeDate);
        List<String> eventList = this.getListEventByPeriode(typePeriode, periodeDate);
        System.out.println("check event 1*");
        errors.addAll(this.cheackEvents(eventList));
        List<CaisseZ> caissesZ = this.dlSales.getCaisseZ(typePeriode, periodeDate);
        List<JustificatifPayment> justificatifPayments = this.dlSales.getJustificatifPaymentByPeriode(typePeriode, periodeDate);
        errors.addAll(this.cheackJustificatifPayment(justificatifPayments));
        List<DuplicataJustificatifPayment> duplicatasJustificatifPayment = this.dlSales.getDuplicataJustificatifPaymentByPeriode(typePeriode, periodeDate);
        errors.addAll(this.cheackDuplicatasJustificatifPayment(duplicatasJustificatifPayment));
        List<LineNote> linesNote = this.dlItems.getLinesNoteByPeriode(typePeriode, periodeDate);
        List<RecapTaxNote> recapTaxeNote = this.dlItems.getRecapTaxNoteByPeriode(typePeriode, periodeDate);
        List<RecapGeneralNote> recapGeneralNote = this.dlItems.getRecapGeneralNoteByPeriode(typePeriode, periodeDate);
        List<LineFacture> linesFacture = this.dlItems.getLinesFactureByPeriode(typePeriode, periodeDate);
        List<RecapTaxFacture> recapTaxfacture = this.dlItems.getRecapTaxFactureByPeriode(typePeriode, periodeDate);
        List<RecapGeneralFacture> recapGeneralFacture = this.dlItems.getRecapGeneralFactureByPeriode(typePeriode, periodeDate);
        this.createCSVFilesAndZipIt(grandTotalPeriode, factures, grandTotalTickets, tickets, totaleEncaissements, eventList, allduplicatas, errors, periodeDate, entetes, linesEncaissements, totalTaxes, payements, gtps, entetesNote, caissesZ, duplicatasJustificatifPayment, justificatifPayments, linesNote, recapTaxeNote, recapGeneralNote, linesFacture, recapTaxfacture, recapGeneralFacture);
        this.error_integrity = errors != null && !errors.isEmpty();
        return grandTotalPeriode;
    }

    public void createCSVFilesAndZipIt(GrandTotalPeriode grandTotalPeriode, List<Facture> factures, List<GrandTotalTicket> grandTotalTickets, List<TicketInfo> tickets, List<TotaleEncaissement> totaleEncaissements, List<String> eventList, List<Duplicata> duplicatas, List<String> errors, Date datePeriode, List<EnteteInfo> entetes, List<Line> linesEncaissements, List<TotalTax> totalTaxes, List<TicketPayementNorm> payements, List<GrandTotalPeriode> gtps, List<EnteteInfo> entetesNotes, List<CaisseZ> caissesZ, List<DuplicataJustificatifPayment> duplicatasJustificatifPayment, List<JustificatifPayment> justificatifPayments, List<LineNote> linesNote, List<RecapTaxNote> recapTaxNotes, List<RecapGeneralNote> recapGeneralNotes, List<LineFacture> linesFacture, List<RecapTaxFacture> recapTaxfacture, List<RecapGeneralFacture> recapGeneralfacture) throws BasicException, ParseException, Exception {
        try {
            this.files.clear();
            Date dateGenerationArchiv = new Date();
            String pathFactures = this.ARCHIVE_TMP + File.separator + "factures.csv";
            File fileFacture = new File(pathFactures);
            this.files.put(fileFacture.getName(), fileFacture);
            Facture f = new Facture();
            String enteteFacture = f.getEntete();
            CSVUtil.writeStringsToCSVFile(fileFacture, factures, enteteFacture);
            String pathDuplicatas = this.ARCHIVE_TMP + File.separator + "duplicatas.csv";
            File fileDuplicata = new File(pathDuplicatas);
            this.files.put(fileDuplicata.getName(), fileDuplicata);
            Duplicata d = new Duplicata();
            String enteteDuplicata = d.getEntete();
            CSVUtil.writeStringsToCSVFile(fileDuplicata, duplicatas, enteteDuplicata);
            String pathEntetes = this.ARCHIVE_TMP + File.separator + "ent\u00eate d\u2019encaissement.csv";
            File fileEntetes = new File(pathEntetes);
            this.files.put(fileEntetes.getName(), fileEntetes);
            String enteteEntete = EnteteInfo.getEntete();
            CSVUtil.writeStringsToCSVFile(fileEntetes, entetes, enteteEntete);
            String pathLines = this.ARCHIVE_TMP + File.separator + "lignes d\u2019encaissement.csv";
            File fileLines = new File(pathLines);
            this.files.put(fileLines.getName(), fileLines);
            String enteteLine = Line.getEntete();
            CSVUtil.writeStringsToCSVFile(fileLines, linesEncaissements, enteteLine);
            String pathTotalTaxes = this.ARCHIVE_TMP + File.separator + "R\u00e9capitulatif d\u2019encaissement.csv";
            File fileTotalTaxes = new File(pathTotalTaxes);
            this.files.put(fileTotalTaxes.getName(), fileTotalTaxes);
            String enteteTax = TotalTax.getEntete();
            CSVUtil.writeStringsToCSVFile(fileTotalTaxes, totalTaxes, enteteTax);
            String pathPayements = this.ARCHIVE_TMP + File.separator + "R\u00e8glement du ticket d\u2019encaissement.csv";
            File filePayements = new File(pathPayements);
            this.files.put(filePayements.getName(), filePayements);
            String entetePayements = TicketPayementNorm.getEntete();
            CSVUtil.writeStringsToCSVFile(filePayements, payements, entetePayements);
            String pathGTP = this.ARCHIVE_TMP + File.separator + "Grand Total P\u00e9riode.csv";
            File fileGtps = new File(pathGTP);
            this.files.put(fileGtps.getName(), fileGtps);
            String enteteGtp = GrandTotalPeriode.getEntete();
            CSVUtil.writeStringsToCSVFile(fileGtps, gtps, enteteGtp);
            String pathEntetesNotes = this.ARCHIVE_TMP + File.separator + "notes.csv";
            File fileEntetesNotes = new File(pathEntetesNotes);
            this.files.put(fileEntetesNotes.getName(), fileEntetesNotes);
            String enteteEnteteNote = EnteteInfo.getEnteteNote();
            CSVUtil.writeStringsToCSVFile(fileEntetesNotes, entetesNotes, enteteEnteteNote, true);
            String pathTicket = this.ARCHIVE_TMP + File.separator + "tickets.csv";
            File fileTicket = new File(pathTicket);
            TicketInfo ticketNull = new TicketInfo();
            String enteteTicket = ticketNull.getEntete();
            ArrayList<Object> listTicket = new ArrayList<Object>();
            listTicket.add(enteteTicket.toString());
            for (TicketInfo ticket : tickets) {
                ticket.setPayments(this.dlSales.findPaymetsByIdTicket(ticket.getId()));
                List<TicketLineInfo> lines = this.dlSales.loadLines(ticket.getId());
                List<TicketLineInfo> linesExterne = this.dlSales.getTicketLineExterne(ticket.getId());
                lines.addAll(linesExterne);
                ticket.setLines(lines);
                listTicket.add(ticket.toString());
                for (TicketLineInfo line : ticket.getLines()) {
                    if (line.isNext()) continue;
                    listTicket.add(line.getID() + " , " + line.getNameProduct() + " , " + line.getPrice() + " , " + line.getTaxInfo().getName());
                }
                double renduMonnaie = 0.0;
                for (PaymentInfo payment : ticket.getPayments()) {
                    listTicket.add(payment.getName() + " , " + payment.getTendered());
                    renduMonnaie += payment.getTendered() - payment.getTotal();
                }
                for (PaymentInfo payment : ticket.getPayments()) {
                    if (!(renduMonnaie > 0.0) || !(payment.getTendered() - payment.getTotal() > 0.0)) continue;
                    listTicket.add("Rendu " + payment.getName() + " , " + Formats.CURRENCY.formatValue(payment.getTendered() - payment.getTotal()));
                }
            }
            FileUtils.writeLines((File)fileTicket, listTicket);
            String pathTotal = this.ARCHIVE_TMP + File.separator + "total_encaissement.csv";
            File fileTotalEncaissement = new File(pathTotal);
            this.files.put(fileTotalEncaissement.getName(), fileTotalEncaissement);
            TotaleEncaissement totaleEncaissementNull = new TotaleEncaissement();
            String enteteTotalEncaissement = totaleEncaissementNull.getEntete();
            CSVUtil.writeStringsToCSVFile(fileTotalEncaissement, totaleEncaissements, enteteTotalEncaissement);
            String pathFondCaisse = this.ARCHIVE_TMP + File.separator + "fond_caisse.csv";
            File fileFondCaisse = new File(pathFondCaisse);
            this.files.put(fileFondCaisse.getName(), fileFondCaisse);
            CaisseZ caisseZ = new CaisseZ();
            String enteteFondCaisse = caisseZ.getEntete();
            CSVUtil.writeStringsToCSVFile(fileFondCaisse, caissesZ, enteteFondCaisse);
            String pathGrandTTicket = this.ARCHIVE_TMP + File.separator + "grand_total_ticket.csv";
            File fileGrandTTicket = new File(pathGrandTTicket);
            this.files.put(fileGrandTTicket.getName(), fileGrandTTicket);
            GrandTotalTicket grandTotalTicketNull = new GrandTotalTicket();
            String enteteTotaltickets = grandTotalTicketNull.getEntete();
            CSVUtil.writeStringsToCSVFile(fileGrandTTicket, grandTotalTickets, enteteTotaltickets);
            String pathDuplicatasJustificatifPayment = this.ARCHIVE_TMP + File.separator + "duplicatas_justificatif_payment.csv";
            File fileDuplicataJustificatifPayment = new File(pathDuplicatasJustificatifPayment);
            this.files.put(fileDuplicataJustificatifPayment.getName(), fileDuplicataJustificatifPayment);
            DuplicataJustificatifPayment duplicatatJustificatifPayment = new DuplicataJustificatifPayment();
            String enteteDuplicataJustificatifPayment = duplicatatJustificatifPayment.getEntete();
            CSVUtil.writeStringsToCSVFile(fileDuplicataJustificatifPayment, duplicatasJustificatifPayment, enteteDuplicataJustificatifPayment);
            String pathJustificatifPayment = this.ARCHIVE_TMP + File.separator + "justificatif_payment.csv";
            File fileJustificatifPayment = new File(pathJustificatifPayment);
            this.files.put(fileJustificatifPayment.getName(), fileJustificatifPayment);
            JustificatifPayment justificatifPayment = new JustificatifPayment();
            String enteteJustificatifPayment = justificatifPayment.getEntete();
            CSVUtil.writeStringsToCSVFile(fileJustificatifPayment, justificatifPayments, enteteJustificatifPayment);
            String pathLinesNote = this.ARCHIVE_TMP + File.separator + "lines_note.csv";
            File fileLinesNote = new File(pathLinesNote);
            this.files.put(fileLinesNote.getName(), fileLinesNote);
            String enteteLineNote = LineNote.getEntete();
            CSVUtil.writeStringsToCSVFile(fileLinesNote, linesNote, enteteLineNote);
            String pathRecapGeneralNote = this.ARCHIVE_TMP + File.separator + "recap_general_note.csv";
            File fileRecapGeneralNote = new File(pathRecapGeneralNote);
            this.files.put(fileRecapGeneralNote.getName(), fileRecapGeneralNote);
            String enteteRecapGeneralNote = RecapGeneralNote.getEntete();
            CSVUtil.writeStringsToCSVFile(fileRecapGeneralNote, recapGeneralNotes, enteteRecapGeneralNote);
            String pathLinesFacture = this.ARCHIVE_TMP + File.separator + "lines_facture.csv";
            File fileLinesfacture = new File(pathLinesFacture);
            this.files.put(fileLinesfacture.getName(), fileLinesfacture);
            String enteteLineFacture = LineFacture.getEntete();
            CSVUtil.writeStringsToCSVFile(fileLinesfacture, linesFacture, enteteLineFacture);
            String pathRecapTaxFacture = this.ARCHIVE_TMP + File.separator + "recap_tax_facture.csv";
            File fileRecapTaxFacture = new File(pathRecapTaxFacture);
            this.files.put(fileRecapTaxFacture.getName(), fileRecapTaxFacture);
            String enteteRecapTaxFacture = RecapTaxFacture.getEntete();
            CSVUtil.writeStringsToCSVFile(fileRecapTaxFacture, recapTaxfacture, enteteRecapTaxFacture);
            String pathRecapGeneralFacture = this.ARCHIVE_TMP + File.separator + "recap_general_facture.csv";
            File fileRecapGeneralFacture = new File(pathRecapGeneralFacture);
            this.files.put(fileRecapGeneralFacture.getName(), fileRecapGeneralFacture);
            String enteteRecapGeneralFacture = RecapGeneralFacture.getEntete();
            CSVUtil.writeStringsToCSVFile(fileRecapGeneralFacture, recapGeneralfacture, enteteRecapGeneralFacture);
            String pathtJETPeriode = this.ARCHIVE_TMP + File.separator + "JET_periode.csv";
            File fileJETPeriode = new File(pathtJETPeriode);
            this.files.put(fileJETPeriode.getName(), fileJETPeriode);
            FileUtils.writeLines((File)fileJETPeriode, eventList);
            String pathtErros = this.ARCHIVE_TMP + File.separator + "Rapport.txt";
            File fileErrors = new File(pathtErros);
            this.files.put(fileErrors.getName(), fileErrors);
            ArrayList<Object> rapporsList = new ArrayList<Object>();
            rapporsList.add("Date de g\u00e9n\u00e9raton de l'archive : " + DateUtils.SDF_FULL_DATE_TIME.format(dateGenerationArchiv));
            rapporsList.add("https://docs.google.com/document/d/17IkAdKjyo5GGumGh6yQkvGKhru1FGxZAZ1btoWfXuo0/edit?usp=sharing");
            if (grandTotalPeriode != null && grandTotalPeriode.getTypePeriode().equals("j")) {
                Date dateEnd = new Date();
                Date dateStart = new Date(datePeriode.getTime());
                DateUtils.setDateHours(dateStart, dateEnd);
                rapporsList.add("date de d\u00e9but de p\u00e9riode : " + dateStart);
                rapporsList.add("date de fin de p\u00e9riode : " + dateEnd);
            }
            rapporsList.add("D\u00e9fauts d'int\u00e9grit\u00e9s :");
            rapporsList.addAll(errors);
            FileUtils.writeLines((File)fileErrors, rapporsList);
        }
        catch (IOException ex) {
            LogToFile.log("severe", null, ex);
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 2500, NPosition.CENTER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String signerZipFile(String archivePeriodeId, ArchivPeriode lastArchive) throws IOException {
        try {
            ArrayList<String> lines = new ArrayList<String>();
            for (File file : this.files.values()) {
                if (!file.isFile()) continue;
                BufferedReader inputStream = null;
                try {
                    String line;
                    inputStream = new BufferedReader(new FileReader(file));
                    while ((line = inputStream.readLine()) != null) {
                        lines.add(line);
                    }
                }
                catch (IOException e) {
                    System.out.println(e);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            StringBuilder oldSignatureBuilder = new StringBuilder();
            if (lastArchive != null && lastArchive.getSignature() != null) {
                oldSignatureBuilder.append(",O,");
                oldSignatureBuilder.append(lastArchive.getSignature());
            } else {
                oldSignatureBuilder.append(",N,");
            }
            lines.add(oldSignatureBuilder.toString());
            File last_archive_signature = new File(this.ARCHIVE_TMP + File.separator + "last_archive_signature.txt");
            FileUtils.writeStringToFile((File)last_archive_signature, (String)oldSignatureBuilder.toString());
            File file_all_data = new File(this.ARCHIVE_TMP + File.separator + "file_all_data_tmp.txt");
            if (!file_all_data.exists()) {
                file_all_data.createNewFile();
            }
            if (file_all_data != null && file_all_data.exists()) {
                FileUtils.writeLines((File)file_all_data, lines);
            }
            SignatureGenerator generator = SignatureGenerator.getGenerator();
            String signature = generator.sign(file_all_data);
            File file_signature = new File(this.ARCHIVE_TMP + File.separator + "signature_all_data.txt");
            FileUtils.writeStringToFile((File)file_signature, (String)signature);
            System.out.println("++++++++ signature : " + signature);
            FileUtils.forceDeleteOnExit((File)file_all_data);
            ZipUtils.zipFolder(this.ARCHIVE_TMP, this.directoryArchive.getAbsolutePath() + File.separator + archivePeriodeId + ".zip");
            FileUtils.forceDeleteOnExit((File)new File(this.ARCHIVE_TMP));
            return signature;
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
            return null;
        }
    }

    public List<String> getListEventByPeriode(String typePeriode, Date datePeriode) throws IOException, ParseException {
        SimpleDateFormat idDateFormatter = switch (typePeriode) {
            case "j" -> DateUtils.SDF_ID_DAY_PERIOD;
            case "m" -> DateUtils.SDF_ID_MONTH_PERIOD;
            case "a" -> DateUtils.SDF_ID_YEAR_PERIOD;
            default -> DateUtils.SDF_ID_DAY_PERIOD;
        };
        if (!this.fileJournal.exists()) {
            Journal.extarctProtectedfile();
        }
        if (this.fileJournal.exists()) {
            List allDatas = FileUtils.readLines((File)this.fileJournal);
            SimpleDateFormat typeFormat = DateUtils.SDF_DATE_SIGNATURE;
            Date tmpDate = null;
            if (allDatas != null && !allDatas.isEmpty()) {
                ArrayList<String> listeEvent = new ArrayList<String>();
                StringBuilder entete5 = new StringBuilder();
                entete5.append("ID");
                entete5.append(",");
                entete5.append("Code evenement");
                entete5.append(",");
                entete5.append("Descriptif");
                entete5.append(",");
                entete5.append("Code Operateur");
                entete5.append(",");
                entete5.append("Horodatage");
                entete5.append(",");
                entete5.append("Informations");
                entete5.append(",");
                entete5.append("Signature");
                entete5.append(",");
                entete5.append("code caisse");
                if (typePeriode.equals("j")) {
                    listeEvent.add(entete5.toString());
                    Date dateEnd = new Date();
                    Date dateStart = new Date(datePeriode.getTime());
                    DateUtils.setDateHours(dateStart, dateEnd);
                    for (int i = allDatas.size() - 1; i > 0; --i) {
                        String data = (String)allDatas.get(i);
                        String[] datas = data.split(",");
                        try {
                            tmpDate = typeFormat.parse(datas[4]);
                            if (tmpDate.after(dateStart) && tmpDate.before(dateEnd)) {
                                listeEvent.add((String)allDatas.get(i));
                                continue;
                            }
                            if (!tmpDate.before(dateStart)) continue;
                            break;
                        }
                        catch (Exception e) {
                            LogToFile.log("severe", e.getMessage(), e);
                        }
                    }
                } else {
                    for (int i = allDatas.size() - 1; i > 0; --i) {
                        String[] datas = ((String)allDatas.get(i)).split(",");
                        try {
                            tmpDate = typeFormat.parse(datas[4]);
                        }
                        catch (ParseException e) {
                            LogToFile.log("severe", e.getMessage(), e);
                        }
                        if (new Integer(idDateFormatter.format(tmpDate)).intValue() == new Integer(idDateFormatter.format(datePeriode)).intValue()) {
                            String eventString = (String)allDatas.get(i);
                            listeEvent.add(eventString);
                            continue;
                        }
                        if (new Integer(idDateFormatter.format(tmpDate)) >= new Integer(idDateFormatter.format(datePeriode))) {
                            continue;
                        }
                        break;
                    }
                }
                return listeEvent;
            }
            Files.deleteIfExists(this.fileJournal.toPath());
        }
        return new ArrayList<String>();
    }

    public void archivRecursive(String typePeriode, Date dateFinArchivage) throws IOException {
        try {
            switch (typePeriode) {
                case "a": {
                    this.archiver("j", dateFinArchivage);
                    this.archiver("m", dateFinArchivage);
                    this.archiver(typePeriode, dateFinArchivage);
                    break;
                }
                case "j": {
                    this.archiver(typePeriode, dateFinArchivage);
                    break;
                }
                case "m": {
                    this.archiver("j", dateFinArchivage);
                    this.archiver(typePeriode, dateFinArchivage);
                    break;
                }
            }
        }
        catch (ParseException ex) {
            LogToFile.log("severe", null, ex);
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public List<String> cheackEvents(List<String> eventsString) throws SQLException, IOException {
        System.out.println("check events test *********************************");
        StringBuilder errors = new StringBuilder();
        ArrayList<String> errorsList = new ArrayList<String>();
        try {
            if (eventsString.size() > 1) {
                Event previousSigned = new Event(eventsString.get(eventsString.size() - 1));
                for (int i = eventsString.size() - 2; i > 0; --i) {
                    Event ligne = new Event(eventsString.get(i));
                    String emprinte = ligne.getEmprinte() + ",O," + previousSigned.getSignature();
                    boolean verify = this.verifySignature(emprinte, ligne.getSignature(), new Date(ligne.getHorodatage()));
                    if (!verify) {
                        System.out.println("emprinte : " + emprinte);
                        System.out.println("ligne signature : " + ligne.getSignature());
                        String oldSignature = this.oldSignature(emprinte);
                        String newSignature = this.newSignature(emprinte);
                        System.out.println("oldSignature : " + oldSignature);
                        System.out.println("newSignature : " + newSignature);
                        errors.append(ligne.getId()).append(" ");
                        errorsList.add(ligne.getMsgIntegrityError());
                    }
                    previousSigned = ligne;
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
        if (errors.length() > 0) {
            Journal.writeToJET(new Event(90, "D\u00e9tection d'un d\u00e9faut d'int\u00e9grit\u00e9", "", "D\u00e9tection de supression ou modification  des lignes du Journal", new Date().getTime(), ""));
        }
        return errorsList;
    }

    public List<String> cheackFactures(List<Facture> factures) throws SQLException, IOException {
        StringBuilder errors = new StringBuilder();
        ArrayList<String> errorsFactures = new ArrayList<String>();
        boolean isFirst = true;
        if (factures.size() > 0) {
            Facture previousSigned = factures.get(0);
            for (Facture ligne : factures) {
                String emprinte;
                boolean verify;
                if (!isFirst && !(verify = this.verifySignature(emprinte = ligne.getEmprinteWithoutPreviousSignature() + ",O," + previousSigned.getSignature(), ligne.getSignature(), ligne.getDateFacture()))) {
                    errors.append(ligne.getId() + " ");
                    errorsFactures.add(ligne.getMsgIntegrityError());
                }
                isFirst = false;
                previousSigned = ligne;
            }
        }
        if (errors.length() > 0) {
            Journal.writeToJET(new Event(90, "D\u00e9tection d'un d\u00e9faut d'int\u00e9grit\u00e9", "", "d\u00e9faut aux Factures", new Date().getTime(), ""));
        }
        return errorsFactures;
    }

    public List<String> cheackEnteteBetween(List<EnteteInfo> entetes) throws SQLException, BasicException, IOException {
        ArrayList<String> errors = new ArrayList<String>();
        StringBuilder errorsString = new StringBuilder();
        boolean isFirst = true;
        int kiwi = 1;
        if (entetes.size() > 0) {
            EnteteInfo previousSigned = entetes.get(0);
            for (EnteteInfo ligne : entetes) {
                ++kiwi;
                if (!isFirst && ligne.getGrandTotalTicket() != null) {
                    String emprinte = ligne.getEmprinteWithoutPreviousSignature() + ",O," + previousSigned.getSignature();
                    boolean verify = this.verifySignature(emprinte, ligne.getSignature(), ligne.getTimestampGDH());
                    if (!verify && ligne.getGrandTotalTicket().getId() != null) {
                        errors.add(ligne.getObjectAsString());
                        errorsString.append(ligne.getId()).append(" ");
                    }
                } else if (ligne.getGrandTotalTicket() == null) {
                    Journal.writeToJET(new Event(90, "D\u00e9tection d'un d\u00e9faut d'int\u00e9grit\u00e9", "", "d\u00e9faut aux Entetes", new Date().getTime(), ligne.getId()));
                }
                isFirst = false;
                previousSigned = ligne;
            }
        }
        if (errors.size() > 0) {
            Journal.writeToJET(new Event(90, "D\u00e9tection d'un d\u00e9faut d'int\u00e9grit\u00e9", "", "d\u00e9faut aux Entetes", new Date().getTime(), ""));
        }
        return errors;
    }

    public List<String> cheackDuplicatas(List<Duplicata> duplicatas) throws SQLException, IOException, BasicException {
        StringBuilder errors = new StringBuilder();
        ArrayList<String> errorsDuplicatas = new ArrayList<String>();
        boolean isFirst = true;
        if (duplicatas.size() > 0) {
            Duplicata previousSigned = duplicatas.get(0);
            for (Duplicata ligne : duplicatas) {
                String emprinte;
                boolean verify;
                if (!isFirst && !(verify = this.verifySignature(emprinte = ligne.getEmprintWithoutSignature() + ",O," + previousSigned.getSignature(), ligne.getSignature(), ligne.getDate_impression()))) {
                    errors.append(ligne.getId() + " ");
                    errorsDuplicatas.add(ligne.getMsgIntegrityError());
                }
                isFirst = false;
                previousSigned = ligne;
            }
        }
        return errorsDuplicatas;
    }

    public List<String> cheackEnteteNoteBetween(List<EnteteInfo> entetes) throws SQLException, BasicException, IOException {
        ArrayList<String> errors = new ArrayList<String>();
        StringBuilder errorsString = new StringBuilder();
        boolean isFirst = true;
        if (entetes.size() > 0) {
            EnteteInfo previousSigned = entetes.get(0);
            for (EnteteInfo ligne : entetes) {
                String emprinte;
                boolean verify;
                if (!isFirst && !(verify = this.verifySignature(emprinte = ligne.getEmprinteNoteWithoutPreviousSignature() + ",O," + previousSigned.getSignature(), ligne.getSignature(), ligne.getTimestampGDH()))) {
                    errors.add(ligne.getObjectNoteAsString());
                    errorsString.append(ligne.getId()).append(" ");
                }
                isFirst = false;
                previousSigned = ligne;
            }
        }
        if (errors.size() > 0) {
            Journal.writeToJET(new Event(90, "D\u00e9tection d'un d\u00e9faut d'int\u00e9grit\u00e9", "", "d\u00e9faut aux Notes", new Date().getTime(), ""));
        }
        return errors;
    }

    public List<String> cheackArchives(List<ArchivPeriode> archives) throws SQLException, BasicException, IOException {
        ArrayList<String> errors = new ArrayList<String>();
        StringBuilder errorsString = new StringBuilder();
        boolean isFirst = true;
        if (archives.size() > 0) {
            ArchivPeriode previousSigned = archives.get(0);
            for (ArchivPeriode ligne : archives) {
                if (!isFirst) {
                    String emprinte = ligne.getEmprinteWithoutPreviousSignature() + ",O," + previousSigned.getSignature();
                    System.out.println(" ligne.getTimestampGDH()archive : " + ligne.getTimestampGDH());
                    boolean verify = this.verifySignature(emprinte, ligne.getSignature(), ligne.getTimestampGDH());
                    if (!verify) {
                        errors.add(ligne.getMsgIntegrityError() + " ");
                        errorsString.append(ligne.getId()).append(" ");
                    }
                }
                isFirst = false;
                previousSigned = ligne;
            }
        }
        if (errors.size() > 0) {
            Journal.writeToJET(new Event(90, "D\u00e9tection d'un d\u00e9faut d'int\u00e9grit\u00e9", "", "d\u00e9faut aux Archives", new Date().getTime(), ""));
        }
        return errors;
    }

    public List<String> cheackDuplicatasJustificatifPayment(List<DuplicataJustificatifPayment> duplicatas) throws SQLException, IOException, BasicException {
        StringBuilder errors = new StringBuilder();
        ArrayList<String> errorsDuplicatas = new ArrayList<String>();
        boolean isFirst = true;
        if (duplicatas.size() > 0) {
            DuplicataJustificatifPayment previousSigned = duplicatas.get(0);
            for (DuplicataJustificatifPayment ligne : duplicatas) {
                String emprinte;
                boolean verify;
                if (!isFirst && !(verify = this.verifySignature(emprinte = ligne.getEmprintWithoutSignature() + ",O," + previousSigned.getSignature(), ligne.getSignature(), ligne.getDate_impression()))) {
                    errors.append(ligne.getId() + " ");
                    errorsDuplicatas.add(ligne.getMsgIntegrityError());
                }
                isFirst = false;
                previousSigned = ligne;
            }
        }
        return errorsDuplicatas;
    }

    public List<String> cheackJustificatifPayment(List<JustificatifPayment> justificatifPayments) throws SQLException, IOException, BasicException {
        StringBuilder errors = new StringBuilder();
        ArrayList<String> errorsJustificatifPayment = new ArrayList<String>();
        boolean isFirst = true;
        if (justificatifPayments.size() > 0) {
            JustificatifPayment previousSigned = justificatifPayments.get(0);
            for (JustificatifPayment ligne : justificatifPayments) {
                String emprinte;
                boolean verify;
                if (!isFirst && !(verify = this.verifySignature(emprinte = ligne.getEmprintWithoutSignature() + ",O," + previousSigned.getSignature(), ligne.getSignature(), ligne.getTimestampGDH()))) {
                    errors.append(ligne.getId() + " ");
                    errorsJustificatifPayment.add(ligne.getMsgIntegrityError());
                }
                isFirst = false;
                previousSigned = ligne;
            }
        }
        return errorsJustificatifPayment;
    }

    public void regenerateArchives(List<String> months) throws IOException, ParseException, Exception {
        for (String periode : months) {
            GrandTotalPeriode grandTotalPeriode = this.dlSales.getGrandTotalPeriodeById(periode);
            if (grandTotalPeriode == null) continue;
            Date dateStartArchivage = DateUtils.getDateFromString(periode);
            GrandTotalPeriode grandTotalPeriodeCorrespondant = this.archivPeriod("m", dateStartArchivage);
            ArchivPeriode mArchivPeriode = this.dlSales.getArchivPeriodeById(periode);
            if (mArchivPeriode != null) continue;
            if (grandTotalPeriodeCorrespondant != null) {
                ArchivPeriode lastArchiv = this.dlSales.getLastArchivPeriode("m");
                String chemin = this.archivDirectoryString + File.separator + grandTotalPeriodeCorrespondant.getId() + ".zip";
                String signature = this.signerZipFile(grandTotalPeriodeCorrespondant.getId(), lastArchiv);
                this.dlSales.insertArchivagePeriode(grandTotalPeriodeCorrespondant, signature, chemin, this.idUser);
            }
            mArchivPeriode = this.dlSales.getArchivPeriodeById(periode);
        }
    }

    public void encrypt(String srcFolder, String destZipFile) {
        try {
            ZipParameters zipParameters = new ZipParameters();
            zipParameters.setEncryptFiles(true);
            zipParameters.setCompressionLevel(CompressionLevel.NORMAL);
            zipParameters.setEncryptionMethod(EncryptionMethod.AES);
            ZipFile zipFile = new ZipFile(destZipFile, "protactilepa42".toCharArray());
            zipFile.addFolder(new File(srcFolder), zipParameters);
            zipFile.close();
            this.deleteFiles();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteFiles() {
        File folder = new File(this.ARCHIVE_TMP);
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                for (File file_child : file.listFiles()) {
                    try {
                        Files.deleteIfExists(file_child.toPath());
                    }
                    catch (IOException ex) {
                        Logger.getLogger(ArchivageService.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                continue;
            }
            try {
                Files.deleteIfExists(file.toPath());
            }
            catch (IOException ex) {
                Logger.getLogger(ArchivageService.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void sendEmail(Date dateStart, Date dateEnd) {
        if (dateStart != null && dateEnd != null) {
            DateUtils.setDateHours(dateStart, dateEnd);
            this.clotureService.sendStatistiqueEmail(dateStart, dateEnd, "Cloture");
        }
    }

    public boolean verifySignature(String data, String signature, Date dateSignature) {
        try {
            SignatureGenerator generator = SignatureGenerator.getGenerator();
            return generator.verifySignature(data, signature, dateSignature);
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
            return false;
        }
    }

    public String oldSignature(String emprint) {
        if (emprint != null) {
            String result = emprint.replace(' ', '_');
            try {
                SignatureGenerator generator = SignatureGenerator.getGenerator();
                String data = new String(result.getBytes("UTF-8"));
                String signature = generator.encrypt(data);
                return signature;
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return null;
    }

    public String newSignature(String emprint) {
        if (emprint != null) {
            String result = emprint.replace(' ', '_');
            try {
                SignatureGenerator generator = SignatureGenerator.getGenerator();
                String data = new String(result.getBytes("UTF-8"));
                String signature = generator.digitalSign(data);
                return signature;
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return null;
    }

    public List<String> checkGTP(List<GrandTotalPeriode> gtps) throws SQLException, IOException, BasicException {
        StringBuilder errors = new StringBuilder();
        ArrayList<String> errorsGTP = new ArrayList<String>();
        boolean isFirst = true;
        if (gtps.size() > 0) {
            boolean verify;
            String emprinte;
            GrandTotalPeriode previousSigned = null;
            for (GrandTotalPeriode ligne : gtps) {
                if (!ligne.getTypePeriode().equals("j")) continue;
                System.out.println("ligne id : " + ligne.getId());
                if (!isFirst) {
                    System.out.println("ligne date : " + ligne.getTimestampGDH());
                    System.out.println("ligne id : " + ligne.getId());
                    emprinte = ligne.getEmprinteWithoutPreviousSignature() + ",O," + previousSigned.getSignature();
                    verify = this.verifySignature(emprinte, ligne.getSignature(), ligne.getTimestampGDH());
                    if (!verify) {
                        errors.append(ligne.getId() + " ");
                        errorsGTP.add(ligne.getMsgIntegrityError());
                    }
                }
                isFirst = false;
                previousSigned = ligne;
            }
            isFirst = true;
            for (GrandTotalPeriode ligne : gtps) {
                if (!ligne.getTypePeriode().equals("m")) continue;
                System.out.println("ligne id : " + ligne.getId());
                if (!isFirst) {
                    System.out.println("ligne date : " + ligne.getTimestampGDH());
                    System.out.println("ligne id : " + ligne.getId());
                    emprinte = ligne.getEmprinteWithoutPreviousSignature() + ",O," + previousSigned.getSignature();
                    verify = this.verifySignature(emprinte, ligne.getSignature(), ligne.getTimestampGDH());
                    if (!verify) {
                        errors.append(ligne.getId() + " ");
                        errorsGTP.add(ligne.getMsgIntegrityError());
                    }
                }
                isFirst = false;
                previousSigned = ligne;
            }
        }
        return errorsGTP;
    }
}

