/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.qrcode;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;

public class QrCodePrinter {
    public static byte[] toQrCode(String content) {
        return QrCodeBuilder.create().withModel((byte)50, (byte)0).withSize((byte)6).withErrorCorrection((byte)51).withContent(content, (byte)48).toBytes();
    }

    private static final class QrCodeBuilder {
        private final Map commands = new EnumMap(QrCommand.class);

        private QrCodeBuilder() {
        }

        public static QrCodeBuilder create() {
            return new QrCodeBuilder();
        }

        private static byte[] append(byte penultimate, byte last) {
            return new byte[]{29, 40, 107, 3, 0, 49, penultimate, last};
        }

        public QrCodeBuilder withModel(byte model, byte size) {
            this.commands.put(QrCommand.MODEL, new byte[]{29, 40, 107, 4, 0, 49, 65, model, size});
            return this;
        }

        public QrCodeBuilder withSize(byte size) {
            this.commands.put(QrCommand.SIZE, QrCodeBuilder.append((byte)67, size));
            return this;
        }

        public QrCodeBuilder withErrorCorrection(byte errorCorrection) {
            this.commands.put(QrCommand.ERROR_CORRECTION, QrCodeBuilder.append((byte)69, errorCorrection));
            return this;
        }

        public QrCodeBuilder withContent(String content, byte print) {
            int contentLength = content.length() + 3;
            byte length = (byte)(contentLength % 256);
            byte height = (byte)(contentLength / 256);
            this.commands.put(QrCommand.STORE, new byte[]{29, 40, 107, length, height, 49, 80, print});
            this.commands.put(QrCommand.CONTENT, content.getBytes());
            this.commands.put(QrCommand.PRINT, QrCodeBuilder.append((byte)81, print));
            return this;
        }

        public byte[] toBytes() {
            if (this.commands.size() != QrCommand.values().length) {
                throw new IllegalStateException("Not all commands given.");
            }
            byte[] result = new byte[]{};
            for (byte[] current : this.commands.values()) {
                int old_length = result.length;
                result = Arrays.copyOf(result, result.length + current.length);
                System.arraycopy(current, 0, result, old_length, current.length);
            }
            return result;
        }
    }

    static enum QrCommand {
        MODEL,
        SIZE,
        ERROR_CORRECTION,
        STORE,
        CONTENT,
        PRINT;

    }
}

