/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder;
import com.google.zxing.qrcode.encoder.QRCode;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.qrcode.JsonHelperOrder;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;

public class QrCodeHelper {
    private static ByteMatrix generateMatrix(String data, ErrorCorrectionLevel level) throws WriterException {
        QRCode qr = new QRCode();
        QRCodeWriter writer = new QRCodeWriter();
        Encoder.encode((String)data, (ErrorCorrectionLevel)level, (QRCode)qr);
        ByteMatrix matrix = qr.getMatrix();
        return matrix;
    }

    private static BitMatrix generateMatrix(String data, int width, int height) throws WriterException {
        QRCodeWriter writer = new QRCodeWriter();
        BitMatrix bitMatrix = writer.encode(data, BarcodeFormat.QR_CODE, width, height);
        return bitMatrix;
    }

    private static BufferedImage writeImage(String outputFileName, String imageFormat, BitMatrix matrix, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 1);
        int white = 0xFFFFFF;
        int black = 0;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                image.setRGB(i, j, matrix.get(i, j) ? black : white);
            }
        }
        try {
            ImageIO.write((RenderedImage)image, imageFormat, new File(outputFileName));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return image;
    }

    private static BufferedImage writeImage(String outputFileName, String imageFormat, ByteMatrix matrix, int size) throws FileNotFoundException, IOException {
        BufferedImage im = null;
        Area a = new Area();
        Area module = new Area(new Rectangle2D.Float(0.05f, 0.05f, 0.9f, 0.9f));
        AffineTransform at = new AffineTransform();
        int width = matrix.getWidth();
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < width; ++j) {
                if (matrix.get(j, i) == 1) {
                    a.add(module);
                }
                at.setToTranslation(1.0, 0.0);
                module.transform(at);
            }
            at.setToTranslation(-width, 1.0);
            module.transform(at);
        }
        double ratio = (double)size / (double)width;
        double adjustment = (double)width / (double)(width + 8);
        at.setToTranslation(4.0, 4.0);
        a.transform(at);
        at.setToScale(ratio *= adjustment, ratio);
        a.transform(at);
        im = new BufferedImage(size, size, 1);
        Graphics2D g = (Graphics2D)im.getGraphics();
        Color couleur1 = new Color(0);
        g.setPaint(couleur1);
        g.setBackground(new Color(0xFFFFFF));
        g.clearRect(0, 0, size, size);
        g.fill(a);
        File f = new File(outputFileName);
        f.setWritable(true);
        try {
            ImageIO.write((RenderedImage)im, imageFormat, f);
            f.createNewFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return im;
    }

    public static BufferedImage orderToImageQrCode(TicketInfo order, String source, int id_ticket) {
        try {
            String data = order == null ? JsonHelperOrder.orderToText(id_ticket) : JsonHelperOrder.orderToText(order, source);
            String imageFormat = "png";
            System.out.println("++++++++++ data : " + data);
            String outputFileName = FileUtils.getTempDirectoryPath() + "qrcode-04.png";
            int size = 320;
            ErrorCorrectionLevel level = ErrorCorrectionLevel.M;
            return QrCodeHelper.writeImage(outputFileName, "png", QrCodeHelper.generateMatrix(data, 320, 320), 320, 320);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage siteTicketToImageQrCode(String web_site) {
        try {
            String data = web_site;
            String imageFormat = "png";
            String outputFileName = FileUtils.getTempDirectoryPath() + "qrcode-04.png";
            int size = 320;
            return QrCodeHelper.writeImage(outputFileName, "png", QrCodeHelper.generateMatrix(data, 320, 320), 320, 320);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage stringToImageQrCode(String data) {
        try {
            String imageFormat = "png";
            System.out.println("++++++++++ data : " + data);
            String outputFileName = FileUtils.getTempDirectoryPath() + "qrcode-04.png";
            int size = 320;
            return QrCodeHelper.writeImage(outputFileName, "png", QrCodeHelper.generateMatrix(data, 320, 320), 320, 320);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

