/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.qrcode;

import java.awt.image.BufferedImage;

public class QImage {
    public int[][] getPixelsSlow(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[][] result = new int[height][width];
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                result[row][col] = image.getRGB(col, row);
            }
        }
        return result;
    }

    public byte[] recollectSlice(int y, int x, int[][] img) {
        byte[] slices = new byte[]{0, 0, 0};
        int yy = y;
        for (int i = 0; yy < y + 24 && i < 3; yy += 8, ++i) {
            byte slice = 0;
            for (int b = 0; b < 8; ++b) {
                int yyy = yy + b;
                if (yyy >= img.length) continue;
                int col = img[yyy][x];
                boolean v = this.shouldPrintColor(col);
                slice = (byte)(slice | (byte)((v ? 1 : 0) << 7 - b));
            }
            slices[i] = slice;
        }
        return slices;
    }

    private boolean shouldPrintColor(int col) {
        int threshold = 127;
        int a = col >> 24 & 0xFF;
        if (a != 255) {
            return false;
        }
        int r = col >> 16 & 0xFF;
        int g = col >> 8 & 0xFF;
        int b = col & 0xFF;
        int luminance = (int)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
        return luminance < 127;
    }
}

