/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.qrcode;

import com.openbravo.pos.ticket.ItemOrderInfo;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.ProductTicket;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.NumericUtils;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonHelperOrder {
    private static final String KEY_ORDER_NUMBER = "N";
    private static final String KEY_ORDER_TYPE = "TP";
    private static final String KEY_ORDER_TOTAL = "TT";
    private static final String KEY_ORDER_ITEMS = "IS";
    private static final String KEY_LINE_ID = "id";
    private static final String KEY_LINE_QTY = "q";
    private static final String KEY_LINE_PS = "ps";
    private static final String KEY_LINE_INGS = "ings";
    private static final String KEY_LINE_OPTIONS = "opts";
    private static HashMap<String, Integer> size_product = new HashMap();

    private static JSONArray sanitizeLines(List<TicketLineInfo> lines) {
        JSONArray array_lines = new JSONArray();
        for (TicketLineInfo next : lines) {
            JSONObject object_line = new JSONObject();
            object_line.put(KEY_LINE_ID, next.getProductID());
            object_line.put("p", next.getPrice());
            object_line.put(KEY_LINE_QTY, next.getMultiply());
            JSONArray array_ings = new JSONArray();
            JSONArray arrays_options = new JSONArray();
            JSONArray arrays_plats = new JSONArray();
            if (next.getListIngredientsIN() != null) {
                for (SupplementItemInfo ingredient : next.getListIngredientsIN()) {
                    array_ings.put(ingredient.getId_supplement());
                }
            }
            if (next.getListSupplements() != null) {
                for (OptionItemOrder option : next.getListSupplements()) {
                    JSONObject object_option = new JSONObject();
                    object_option.put(KEY_LINE_ID, option.getSupplement());
                    object_option.put("p", (Object)option.getPrice());
                    object_option.put(KEY_LINE_QTY, option.getNumberOption());
                    arrays_options.put((Object)object_option);
                }
            }
            if (next.getListProducts() != null) {
                for (ProductTicket product : next.getListProducts()) {
                    JSONObject object_product = new JSONObject();
                    object_product.put(KEY_LINE_ID, product.getIdProduct());
                    object_product.put("p", product.getPriceProduct());
                    object_product.put(KEY_LINE_QTY, product.getNumberProduct());
                    arrays_plats.put((Object)object_product);
                }
            }
            if (array_ings.length() > 0) {
                object_line.put(KEY_LINE_INGS, (Object)array_ings);
            }
            if (arrays_options.length() > 0) {
                object_line.put(KEY_LINE_OPTIONS, (Object)arrays_options);
            }
            if (arrays_plats.length() > 0) {
                object_line.put(KEY_LINE_PS, (Object)arrays_plats);
            }
            array_lines.put((Object)object_line);
        }
        return array_lines;
    }

    public static String orderToJson(TicketInfo ticket) {
        JSONObject json_order = new JSONObject();
        json_order.put(KEY_ORDER_NUMBER, ticket.getNumero_order());
        if (ticket.getType().equals("A Emporter")) {
            json_order.put(KEY_ORDER_TYPE, 2);
        } else if (ticket.getType().equals("Sur Place")) {
            json_order.put(KEY_ORDER_TYPE, 1);
        }
        json_order.put(KEY_ORDER_TOTAL, ticket.getTotal());
        json_order.put(KEY_ORDER_ITEMS, (Object)JsonHelperOrder.sanitizeLines(ticket.getLines()));
        return json_order.toString();
    }

    public static String orderToText(TicketInfo ticket, String source) {
        if (size_product.isEmpty()) {
            size_product.put("junior", 1);
            size_product.put("senior", 2);
            size_product.put("mega", 3);
            size_product.put("size1", 4);
            size_product.put("size2", 5);
            size_product.put("size3", 6);
            size_product.put(null, 0);
        }
        int source_number = source.equals("borne") ? 1 : 0;
        String output = "S " + source_number + ";";
        output = output + "N " + ticket.getNumero_order() + " " + ticket.getNum_order_borne() + ";";
        output = output + "T " + (ticket.getType().equals("A Emporter") ? "2" : "1") + ";";
        output = output + "Z " + NumericUtils.round(ticket.getTotal()) + ";";
        for (TicketLineInfo next : ticket.getLines()) {
            int time_served = next.getTime_served() == null || next.getTime_served().equals("now") ? 0 : 1;
            int promo_basket = next.isPromo_basket() ? 1 : 0;
            output = output + "L " + next.getRef_web() + " " + (int)next.getMultiply() + " " + next.getPrice() + " " + size_product.get(next.getName_sizeProduct()) + " " + time_served + " " + promo_basket + ";";
            if (next.getListSupplements() != null) {
                for (OptionItemOrder option : next.getListSupplements()) {
                    output = output + "O " + option.getRef_web() + " " + option.getNumberOption() + " " + option.getNumber_free() + ";";
                }
            }
            if (next.getListIngredients() != null) {
                for (ItemOrderInfo ingredient : next.getListIngredients()) {
                    output = output + "I " + ingredient.getRef_web() + ";";
                }
            }
            if (next.getListProducts() == null) continue;
            for (ProductTicket product : next.getListProducts()) {
                output = output + "P " + product.getRef_web_carte() + " " + product.getRef_web_item() + " " + product.getNumberProduct() + ";";
            }
        }
        return output;
    }

    public static String orderToText(int id_ticket) {
        String output = "O " + id_ticket;
        return output;
    }
}

